var navigationEvents = [];
var flutterFunctions = [];
var flutterUploadEvent = null;
window.flutterTriggerEvent = null;

var flutterPushEvent = function(args, pushEvent = false) {  
        
    if(!pushEvent)
        navigationEvents = [];
    navigationEvents.push(args);

};

window.addOnFlutterLoad = function(callback) {
    flutterFunctions.push(callback);
}



window.addEventListener('flutterInAppWebViewPlatformReady', function(event) {

    if(this.flutterFunctions.length) {
        flutterFunctions.forEach(function(callback) {
            callback();
        })
    }

    window.IS_FLUTTER = true;
    window.flutterPopEvent = function() {

        const currentEvent = navigationEvents.pop();        

        if(currentEvent === undefined)
            window.flutter_inappwebview.callHandler('exitApp')
        
        const type = currentEvent.type;        

        switch(type) {
            case 'dialog': currentEvent.dialog.close(); break;
            case 'url': {
                if(window.flutterTriggerEvent) {
                    window.flutterTriggerEvent({
                        type: 'drawer',
                        data: true
                    })
                }
                window.flutter_inappwebview.callHandler('canExitApp')
            } ; break;
            default: {
                window.flutter_inappwebview.callHandler('exitApp')
            }
        }

    }

    window.keyboard = function(kHeight) {

        const wHeight = window.innerHeight;
        const body = document.querySelector('body');
        const content = document.querySelector('body app-root > div');
        const paddingBottom = kHeight > 0 ? kHeight - 30 : 0;

        kHeight -= paddingBottom
        content.style.height =  (wHeight - kHeight) + 'px';
        content.style.overflow = 'auto';
        body.style.height = (wHeight - kHeight) + 'px';
        body.style.overflow = 'auto';
        body.style.paddingBottom = paddingBottom + 'px';

    }

    window.chooseImageAndUpload = function(source, url, postData, getData, headerData) {
        window.flutter_inappwebview.callHandler('chooseImageAndUpload', source, url, postData, getData, headerData);
    }

    window.generateFocusInput = function() {

        setTimeout(function() {

            const textInputs = document.querySelectorAll('input');
            textInputs.forEach(function(input) {
                input.addEventListener('focus', function() {
                    setTimeout(function() {
                        input.scrollIntoView({
                            behavior: 'smooth',
                            block: 'center'
                        });
                    }, 500)
                })
            })

        }, 1000)

    }

})

window.flutterExitApp = function() {
    window.flutter_inappwebview.callHandler('exitApp')
}

window.launchUrl = function(url) {
    window.flutter_inappwebview.callHandler('launchUrl', url);
}

window.setPushEvent = function(args, pushEvent = false) {
    flutterPushEvent(args, pushEvent);    
}

window.setFlutterUploadEvent = function(callback) {
    flutterUploadEvent = callback;
}

window.onFlutterUploadEvent = function() {
    if(flutterUploadEvent)
        flutterUploadEvent();
}