(self["webpackChunkfrontend"] = self["webpackChunkfrontend"] || []).push([["vendor"],{

/***/ 42220:
/*!***********************************************************************************!*\
  !*** ./node_modules/@brazilian-utils/brazilian-utils/dist/brazilian-utils.esm.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "capitalize": () => (/* binding */ capitalize),
/* harmony export */   "formatBoleto": () => (/* binding */ format$2),
/* harmony export */   "formatCEP": () => (/* binding */ format$1),
/* harmony export */   "formatCNPJ": () => (/* binding */ format$5),
/* harmony export */   "formatCPF": () => (/* binding */ format$4),
/* harmony export */   "formatCurrency": () => (/* binding */ format$3),
/* harmony export */   "formatPJ": () => (/* binding */ format),
/* harmony export */   "generateCNPJ": () => (/* binding */ generate$1),
/* harmony export */   "generateCPF": () => (/* binding */ generate),
/* harmony export */   "generateChecksum": () => (/* binding */ generateChecksum),
/* harmony export */   "generateRandomNumber": () => (/* binding */ generateRandomNumber),
/* harmony export */   "getCities": () => (/* binding */ getCities),
/* harmony export */   "getStates": () => (/* binding */ getStates),
/* harmony export */   "isLastChar": () => (/* binding */ isLastChar),
/* harmony export */   "isValidBoleto": () => (/* binding */ isValid$6),
/* harmony export */   "isValidCEP": () => (/* binding */ isValid$5),
/* harmony export */   "isValidCNPJ": () => (/* binding */ isValid$8),
/* harmony export */   "isValidCPF": () => (/* binding */ isValid$7),
/* harmony export */   "isValidEmail": () => (/* binding */ isValid$3),
/* harmony export */   "isValidIE": () => (/* binding */ isValid),
/* harmony export */   "isValidLandlinePhone": () => (/* binding */ isValidLandlinePhone),
/* harmony export */   "isValidLicensePlate": () => (/* binding */ isValid$4),
/* harmony export */   "isValidMobilePhone": () => (/* binding */ isValidMobilePhone),
/* harmony export */   "isValidPIS": () => (/* binding */ isValid$1),
/* harmony export */   "isValidPhone": () => (/* binding */ isValid$2),
/* harmony export */   "onlyNumbers": () => (/* binding */ onlyNumbers),
/* harmony export */   "parseCurrency": () => (/* binding */ parse$1)
/* harmony export */ });
function isLastChar(index, input) {
  return index === input.length - 1;
}

function onlyNumbers(input) {
  return String(input).replace(/[^\d]/g, '');
}

function generateChecksum(base, weight) {
  var digits = onlyNumbers(base);
  var weights = typeof weight === 'number' ? Array(digits.length).fill(0).map(function (_, i) {
    return weight - i;
  }) : weight;
  return digits.split('').reduce(function (acc, digit, i) {
    return acc + parseInt(digit, 10) * weights[i];
  }, 0);
}

function generateRandomNumber(length) {
  return Array(length).fill(1).reduce(function (acc, number) {
    return "" + acc + Math.random().toString().substr(2, number);
  }, '');
}

function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  subClass.__proto__ = superClass;
}

var STATES_DATA = {
  AC: {
    code: '2',
    areaCodes: [68],
    ieLength: 13,
    name: 'Acre'
  },
  AL: {
    code: '4',
    areaCodes: [82],
    ieLength: 9,
    name: 'Alagoas'
  },
  AP: {
    code: '2',
    areaCodes: [96],
    ieLength: 9,
    name: 'Amapá'
  },
  AM: {
    code: '2',
    areaCodes: [92, 97],
    ieLength: 9,
    name: 'Amazonas'
  },
  BA: {
    code: '5',
    areaCodes: [71, 73, 74, 75, 77],
    ieLength: [8, 9],
    name: 'Bahia'
  },
  CE: {
    code: '3',
    areaCodes: [85, 88],
    ieLength: 9,
    name: 'Ceará'
  },
  DF: {
    code: '1',
    areaCodes: [61],
    ieLength: 13,
    name: 'Distrito Federal'
  },
  ES: {
    code: '7',
    areaCodes: [27, 28],
    ieLength: 9,
    name: 'Espírito Santo'
  },
  GO: {
    code: '1',
    areaCodes: [62, 64],
    ieLength: 9,
    name: 'Goiás'
  },
  MA: {
    code: '3',
    areaCodes: [98, 99],
    ieLength: 9,
    name: 'Maranhão'
  },
  MG: {
    code: '6',
    areaCodes: [31, 32, 33, 34, 35, 37, 38],
    ieLength: 13,
    name: 'Minas Gerais'
  },
  MT: {
    code: '1',
    areaCodes: [65, 66],
    ieLength: 11,
    name: 'Mato Grosso'
  },
  MS: {
    code: '1',
    areaCodes: [67],
    ieLength: 9,
    name: 'Mato Grosso do Sul'
  },
  PA: {
    code: '2',
    areaCodes: [91, 93, 94],
    ieLength: 9,
    name: 'Pará'
  },
  PB: {
    code: '4',
    areaCodes: [83],
    ieLength: 9,
    name: 'Paraíba'
  },
  PE: {
    code: '4',
    areaCodes: [81, 87],
    ieLength: 9,
    name: 'Pernambuco'
  },
  PI: {
    code: '3',
    areaCodes: [86, 89],
    ieLength: 9,
    name: 'Piauí'
  },
  PR: {
    code: '9',
    areaCodes: [41, 42, 43, 44, 45, 46],
    ieLength: 10,
    name: 'Paraná'
  },
  RJ: {
    code: '7',
    areaCodes: [21, 22, 24],
    ieLength: 8,
    name: 'Rio de Janeiro'
  },
  RN: {
    code: '4',
    areaCodes: [84],
    ieLength: [9, 10],
    name: 'Rio Grande do Norte'
  },
  RO: {
    code: '2',
    areaCodes: [69],
    ieLength: 14,
    name: 'Rondônia'
  },
  RS: {
    code: '0',
    areaCodes: [51, 53, 54, 55],
    ieLength: 10,
    name: 'Rio Grande do Sul'
  },
  RR: {
    code: '2',
    areaCodes: [95],
    ieLength: 9,
    name: 'Roraima'
  },
  SC: {
    code: '9',
    areaCodes: [47, 48, 49],
    ieLength: 9,
    name: 'Santa Catarina'
  },
  SE: {
    code: '5',
    areaCodes: [79],
    ieLength: 9,
    name: 'Sergipe'
  },
  SP: {
    code: '8',
    areaCodes: [11, 12, 13, 14, 15, 16, 17, 18, 19],
    ieLength: 12,
    name: 'São Paulo'
  },
  TO: {
    code: '1',
    areaCodes: [63],
    ieLength: [9, 11],
    name: 'Tocantins'
  }
};
var STATES = /*#__PURE__*/Object.keys(STATES_DATA);

var Validator = /*#__PURE__*/function () {
  function Validator() {}

  var _proto = Validator.prototype;

  _proto.isValid = function isValid(ie) {
    return this.checkLength(ie) && this.itStartsWith(ie) && this.calcIe(ie);
  };

  return Validator;
}();

var AC = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(AC, _Validator);

  function AC() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = AC.prototype;

  _proto.checkLength = function checkLength(ie) {
    return ie.length === STATES_DATA.AC.ieLength;
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return ie.substr(0, 2) === '01';
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigits(ie);
  };

  _proto.calcDigits = function calcDigits(inscricaoEstadual) {
    var length = inscricaoEstadual.length;
    var body = inscricaoEstadual.substr(0, length - 2);
    var fDig = this.calcDigit(body);
    var sDig = this.calcDigit(body + fDig.toString());
    var pos2dig = inscricaoEstadual.length - 1;
    var pos1dig = inscricaoEstadual.length - 2;
    return parseInt(inscricaoEstadual[pos1dig], 10) === fDig && parseInt(inscricaoEstadual[pos2dig], 10) === sDig;
  };

  _proto.calcDigit = function calcDigit(body) {
    var weight = body.length - 7;
    var sum = 0;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight--;

      if (weight === 1) {
        weight = 9;
      }
    });
    var mod = 11;
    var rest = sum % mod;
    var dig = mod - rest;

    if (dig >= 10) {
      dig = 0;
    }

    return dig;
  };

  return AC;
}(Validator);

var AL = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(AL, _Validator);

  function AL() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = AL.prototype;

  _proto.checkLength = function checkLength(ie) {
    return ie.length === STATES_DATA.AL.ieLength;
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return ie.substr(0, 2) === '24';
  };

  _proto.calcIe = function calcIe(ie) {
    return this.digitCalc(ie);
  };

  _proto.digitCalc = function digitCalc(ie) {
    var weight = 9;
    var position = 8;
    var sum = 0;

    for (var i = 0; i < position; i++) {
      sum += parseInt(ie.charAt(i), 10) * weight;
      weight--;
    }

    var product = sum * 10;
    var digit = product - Math.floor(product / 11) * 11;

    if (digit >= 10) {
      digit = 0;
    }

    return digit === parseInt(ie.charAt(position), 10);
  };

  return AL;
}(Validator);

var AP = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(AP, _Validator);

  function AP() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = AP.prototype;

  _proto.checkLength = function checkLength(ie) {
    return ie.length === STATES_DATA.AP.ieLength;
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return ie.substr(0, 2) === '03';
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigit(ie);
  };

  _proto.calcDigit = function calcDigit(ie) {
    var length = ie.length;
    var position = length - 1;
    var weight = length;
    var body = ie.substr(0, position);
    var bodyInt = parseInt(body, 10);
    var p = 0;
    var d = 0;

    if (3000001 <= bodyInt && bodyInt <= 3017000) {
      p = 5;
      d = 0;
    } else if (bodyInt >= 3017001 && bodyInt <= 3019022) {
      p = 9;
      d = 1;
    }

    var sum = p;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight--;
    });
    var dig = 11 - sum % 11;

    if (dig === 10) {
      dig = 0;
    }

    if (dig === 11) {
      dig = d;
    }

    return dig === parseInt(ie.charAt(position), 10);
  };

  return AP;
}(Validator);

var AM = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(AM, _Validator);

  function AM() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = AM.prototype;

  _proto.checkLength = function checkLength(ie) {
    return ie.length === STATES_DATA.AM.ieLength;
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return Boolean(ie);
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigit(ie);
  };

  _proto.calcDigit = function calcDigit(ie) {
    var length = ie.length;
    var position = length - 1;
    var weight = length;
    var body = ie.substr(0, position);
    var sum = 0;
    var dig = 0;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight--;
    });

    if (sum < 11) {
      dig = 11 - sum;
    } else {
      var rest = sum % 11;
      dig = 11 - rest;

      if (dig >= 10) {
        dig = 0;
      }
    }

    return dig === parseInt(ie.charAt(position), 10);
  };

  return AM;
}(Validator);

var BA = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(BA, _Validator);

  function BA() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = BA.prototype;

  _proto.checkLength = function checkLength(ie) {
    return STATES_DATA.BA.ieLength.includes(ie.length);
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return Boolean(ie);
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigits(ie);
  };

  _proto.calcDigits = function calcDigits(ie) {
    var length = ie.length;
    var body = ie.substr(0, length - 2);
    var mod = this.getModule(ie);
    var secondDig = this.calcDigit(body, mod);
    var firstDig = this.calcDigit(body + secondDig, mod);
    var posSecondDig = length - 1;
    var posFirstDig = length - 2;
    var ieAtFirstPos = parseInt(ie.charAt(posFirstDig), 10);
    var ieAtSecondPos = parseInt(ie.charAt(posSecondDig), 10);
    return ieAtFirstPos === firstDig && ieAtSecondPos === secondDig;
  };

  _proto.getModule = function getModule(ie) {
    var pos = 0;

    if (ie.length === 9) {
      pos = 1;
    }

    var charAt = parseInt(ie.substr(pos, 1), 10);
    var arr = [0, 1, 2, 3, 4, 5, 8];

    if (arr.indexOf(charAt) >= 0) {
      return 10;
    }

    return 11;
  };

  _proto.calcDigit = function calcDigit(body, mod) {
    var weight = body.length + 1;
    var sum = 0;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight--;
    });
    var rest = sum % mod;
    var dig = mod - rest;

    if (dig >= 10) {
      dig = 0;
    }

    return dig;
  };

  return BA;
}(Validator);

var CE = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(CE, _Validator);

  function CE() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = CE.prototype;

  _proto.checkLength = function checkLength(ie) {
    return ie.length === STATES_DATA.CE.ieLength;
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return Boolean(ie);
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigit(ie);
  };

  _proto.calcDigit = function calcDigit(ie) {
    var length = ie.length;
    var position = length - 1;
    var weight = length;
    var body = ie.substr(0, position);
    var sum = 0;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight--;
    });
    var rest = sum % 11;
    var dig = 11 - rest;

    if (dig >= 10) {
      dig = 0;
    }

    return dig === parseInt(ie.charAt(position), 10);
  };

  return CE;
}(Validator);

var DF = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(DF, _Validator);

  function DF() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = DF.prototype;

  _proto.checkLength = function checkLength(ie) {
    return ie.length === STATES_DATA.DF.ieLength;
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return ie.substr(0, 2) === '07';
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigits(ie);
  };

  _proto.calcDigits = function calcDigits(ie) {
    var length = ie.length;
    var body = ie.substr(0, length - 2);
    var firstDig = this.calcDigit(body);
    var secondDig = this.calcDigit(body + firstDig);
    var posSecondDig = length - 1;
    var posFirstDig = length - 2;
    var ieAtFirstPos = parseInt(ie.charAt(posFirstDig), 10);
    var ieAtSecondPos = parseInt(ie.charAt(posSecondDig), 10);
    return ieAtFirstPos === firstDig && ieAtSecondPos === secondDig;
  };

  _proto.calcDigit = function calcDigit(body) {
    var weight = body.length - 7;
    var sum = 0;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight--;

      if (weight === 1) {
        weight = 9;
      }
    });
    var mod = 11;
    var rest = sum % mod;
    var dig = mod - rest;

    if (dig >= 10) {
      dig = 0;
    }

    return dig;
  };

  return DF;
}(Validator);

var ES = /*#__PURE__*/function (_CE) {
  _inheritsLoose(ES, _CE);

  function ES() {
    return _CE.apply(this, arguments) || this;
  }

  return ES;
}(CE);

var GO = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(GO, _Validator);

  function GO() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = GO.prototype;

  _proto.checkLength = function checkLength(ie) {
    return ie.length === STATES_DATA.GO.ieLength;
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    var beginWith = ['10', '11', '12'];
    var begin = ie.substr(0, 2);
    return beginWith.indexOf(begin) >= 0;
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigit(ie);
  };

  _proto.calcDigit = function calcDigit(ie) {
    var length = ie.length;
    var position = length - 1;
    var weight = length;
    var body = ie.substr(0, position);
    var bodyInt = parseInt(body, 10);
    var sum = 0;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight--;
    });
    var rest = sum % 11;
    var dig = 11 - rest;

    if (dig >= 10) {
      if (dig === 11 && 10103105 <= bodyInt && bodyInt <= 10119997) {
        dig = 1;
      } else {
        dig = 0;
      }
    }

    return dig === parseInt(ie.charAt(position), 10);
  };

  return GO;
}(Validator);

var MA = /*#__PURE__*/function (_CE) {
  _inheritsLoose(MA, _CE);

  function MA() {
    return _CE.apply(this, arguments) || this;
  }

  var _proto = MA.prototype;

  _proto.itStartsWith = function itStartsWith(ie) {
    return ie.substr(0, 2) === '12';
  };

  return MA;
}(CE);

var MT = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(MT, _Validator);

  function MT() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = MT.prototype;

  _proto.checkLength = function checkLength(ie) {
    return ie.length === STATES_DATA.MT.ieLength;
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return Boolean(ie);
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigit(ie);
  };

  _proto.calcDigit = function calcDigit(ie) {
    var length = ie.length;
    var position = length - 1;
    var weight = 3;
    var body = ie.substr(0, position);
    var sum = 0;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight--;

      if (weight === 1) {
        weight = 9;
      }
    });
    var rest = sum % 11;
    var dig = 11 - rest;

    if (dig >= 10) {
      dig = 0;
    }

    return dig === parseInt(ie.charAt(position), 10);
  };

  return MT;
}(Validator);

var MS = /*#__PURE__*/function (_CE) {
  _inheritsLoose(MS, _CE);

  function MS() {
    return _CE.apply(this, arguments) || this;
  }

  var _proto = MS.prototype;

  _proto.itStartsWith = function itStartsWith(ie) {
    return ie.substr(0, 2) === '28';
  };

  return MS;
}(CE);

var MG = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(MG, _Validator);

  function MG() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = MG.prototype;

  _proto.checkLength = function checkLength(ie) {
    return ie.length === STATES_DATA.MG.ieLength;
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return Boolean(ie);
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigit(ie);
  };

  _proto.calcDigit = function calcDigit(ie) {
    var length = ie.length;
    var posFirstDigit = length - 2;
    var posSecondDigit = length - 1;
    var body = ie.substring(0, 11);
    var firstDigit = this.calcFirstDigit(body);
    var secondDigit = this.calcSecondDigit(body + firstDigit);
    var digitAtFirstDigit = parseInt(ie.charAt(posFirstDigit), 10);
    var digitAtSecondDigit = parseInt(ie.charAt(posSecondDigit), 10);
    return firstDigit === digitAtFirstDigit && secondDigit === digitAtSecondDigit;
  };

  _proto.calcFirstDigit = function calcFirstDigit(ie) {
    var body = ie.slice(0, 3) + 0 + ie.slice(3);
    var concat = '';
    body.split('').forEach(function (item, index) {
      var weight = (index + 3) % 2 === 0 ? 2 : 1;
      concat += parseInt(item, 10) * weight;
    });
    var sum = 0;
    concat.split('').forEach(function (item) {
      sum += parseInt(item, 10);
    });
    var sumString = sum.toString();
    var length = sumString.length;
    var lastChar = sumString.substr(length - 1, 1);
    var lastCharInt = parseInt(lastChar, 10);
    return lastCharInt === 0 ? 0 : 10 - lastCharInt;
  };

  _proto.calcSecondDigit = function calcSecondDigit(body) {
    var weight = 3;
    var sum = 0;
    body.split('').forEach(function (item) {
      sum += parseInt(item, 10) * weight;
      weight--;

      if (weight === 1) {
        weight = 11;
      }
    });
    var rest = sum % 11;
    var digit = 11 - rest;

    if (digit >= 10) {
      digit = 0;
    }

    return digit;
  };

  return MG;
}(Validator);

var PA = /*#__PURE__*/function (_CE) {
  _inheritsLoose(PA, _CE);

  function PA() {
    return _CE.apply(this, arguments) || this;
  }

  var _proto = PA.prototype;

  _proto.itStartsWith = function itStartsWith(ie) {
    return ie.substr(0, 2) === '15';
  };

  return PA;
}(CE);

var PB = /*#__PURE__*/function (_CE) {
  _inheritsLoose(PB, _CE);

  function PB() {
    return _CE.apply(this, arguments) || this;
  }

  return PB;
}(CE);

var PR = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(PR, _Validator);

  function PR() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = PR.prototype;

  _proto.checkLength = function checkLength(ie) {
    return ie.length === STATES_DATA.PR.ieLength;
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return Boolean(ie);
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigits(ie);
  };

  _proto.calcDigits = function calcDigits(ie) {
    var length = ie.length;
    var body = ie.substr(0, length - 2);
    var firstDig = this.calcDigit(body);
    var secondDig = this.calcDigit(body + firstDig);
    var posSecondDig = length - 1;
    var posFirstDig = length - 2;
    var ieAtFirstPos = parseInt(ie.charAt(posFirstDig), 10);
    var ieAtSecondPos = parseInt(ie.charAt(posSecondDig), 10);
    return ieAtFirstPos === firstDig && ieAtSecondPos === secondDig;
  };

  _proto.calcDigit = function calcDigit(body) {
    var weight = body.length - 5;
    var sum = 0;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight--;

      if (weight === 1) {
        weight = 7;
      }
    });
    var mod = 11;
    var rest = sum % mod;
    var dig = mod - rest;

    if (dig >= 10) {
      dig = 0;
    }

    return dig;
  };

  return PR;
}(Validator);

var PE = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(PE, _Validator);

  function PE() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = PE.prototype;

  _proto.checkLength = function checkLength(ie) {
    return ie.length === STATES_DATA.PE.ieLength;
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return Boolean(ie);
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigits(ie);
  };

  _proto.calcDigits = function calcDigits(ie) {
    var length = ie.length;
    var body = ie.substr(0, length - 2);
    var firstDig = this.calcDigit(body);
    var secondDig = this.calcDigit(body + firstDig);
    var posSecondDig = length - 1;
    var posFirstDig = length - 2;
    var ieAtFirstPos = parseInt(ie.charAt(posFirstDig), 10);
    var ieAtSecondPos = parseInt(ie.charAt(posSecondDig), 10);
    return ieAtFirstPos === firstDig && ieAtSecondPos === secondDig;
  };

  _proto.calcDigit = function calcDigit(body) {
    var weight = body.length + 1;
    var sum = 0;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight--;
    });
    var mod = 11;
    var rest = sum % mod;
    var dig = mod - rest;

    if (dig >= 10) {
      dig = 0;
    }

    return dig;
  };

  return PE;
}(Validator);

var PI = /*#__PURE__*/function (_CE) {
  _inheritsLoose(PI, _CE);

  function PI() {
    return _CE.apply(this, arguments) || this;
  }

  return PI;
}(CE);

var RJ = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(RJ, _Validator);

  function RJ() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = RJ.prototype;

  _proto.checkLength = function checkLength(ie) {
    return ie.length === STATES_DATA.RJ.ieLength;
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return Boolean(ie);
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigit(ie);
  };

  _proto.calcDigit = function calcDigit(ie) {
    var length = ie.length;
    var position = length - 1;
    var weight = 2;
    var body = ie.substr(0, position);
    var sum = 0;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight--;

      if (weight === 1) {
        weight = 7;
      }
    });
    var rest = sum % 11;
    var dig = 11 - rest;

    if (dig >= 10) {
      dig = 0;
    }

    return dig === parseInt(ie.charAt(position), 10);
  };

  return RJ;
}(Validator);

var RN = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(RN, _Validator);

  function RN() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = RN.prototype;

  _proto.checkLength = function checkLength(ie) {
    return STATES_DATA.RN.ieLength.includes(ie.length);
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return ie.substr(0, 2) === '20';
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigit(ie);
  };

  _proto.calcDigit = function calcDigit(ie) {
    var length = ie.length;
    var position = length - 1;
    var weight = length;
    var body = ie.substr(0, position);
    var sum = 0;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight--;
    });
    var rest = sum % 11;
    var dig = 11 - rest;

    if (dig >= 10) {
      dig = 0;
    }

    return dig === parseInt(ie.charAt(position), 10);
  };

  return RN;
}(Validator);

var RS = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(RS, _Validator);

  function RS() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = RS.prototype;

  _proto.checkLength = function checkLength(ie) {
    return ie.length === STATES_DATA.RS.ieLength;
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return Boolean(ie);
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigit(ie);
  };

  _proto.calcDigit = function calcDigit(ie) {
    var length = ie.length;
    var position = length - 1;
    var weight = 2;
    var body = ie.substr(0, position);
    var sum = 0;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight--;

      if (weight === 1) {
        weight = 9;
      }
    });
    var rest = sum % 11;
    var dig = 11 - rest;

    if (dig >= 10) {
      dig = 0;
    }

    return dig === parseInt(ie.charAt(position), 10);
  };

  return RS;
}(Validator);

var RO = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(RO, _Validator);

  function RO() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = RO.prototype;

  _proto.checkLength = function checkLength(ie) {
    return ie.length === STATES_DATA.RO.ieLength;
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return Boolean(ie);
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigit(ie);
  };

  _proto.calcDigit = function calcDigit(ie) {
    var length = ie.length;
    var position = length - 1;
    var weight = 6;
    var body = ie.substr(0, position);
    var sum = 0;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight--;

      if (weight === 1) {
        weight = 9;
      }
    });
    var rest = sum % 11;
    var dig = 11 - rest;

    if (dig >= 10) {
      dig -= 10;
    }

    return dig === parseInt(ie.charAt(position), 10);
  };

  return RO;
}(Validator);

var RR = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(RR, _Validator);

  function RR() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = RR.prototype;

  _proto.checkLength = function checkLength(ie) {
    return ie.length === STATES_DATA.RR.ieLength;
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return ie.substr(0, 2) === '24';
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigit(ie);
  };

  _proto.calcDigit = function calcDigit(ie) {
    var length = ie.length;
    var position = length - 1;
    var weight = 1;
    var body = ie.substr(0, position);
    var sum = 0;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight++;
    });
    var dig = sum % 9;
    return dig === parseInt(ie.charAt(position), 10);
  };

  return RR;
}(Validator);

var SC = /*#__PURE__*/function (_CE) {
  _inheritsLoose(SC, _CE);

  function SC() {
    return _CE.apply(this, arguments) || this;
  }

  return SC;
}(CE);

var SP = /*#__PURE__*/function (_Validator) {
  _inheritsLoose(SP, _Validator);

  function SP() {
    return _Validator.apply(this, arguments) || this;
  }

  var _proto = SP.prototype;

  _proto.checkLength = function checkLength(ie) {
    return ie.length === STATES_DATA.SP.ieLength;
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return Boolean(ie);
  };

  _proto.calcIe = function calcIe(ie) {
    return this.calcDigit(ie);
  };

  _proto.calcDigit = function calcDigit(ie) {
    var length = ie.length;
    var positionFirstDigit = length - 4;
    var positionSecondDigit = length - 1;
    var firstDigit = this.calcFirstDigit(ie);
    var secondDigit = this.calcSecondDigit(ie);
    var ieAtFirstPos = parseInt(ie.charAt(positionFirstDigit), 10);
    var ieAtSecondPos = parseInt(ie.charAt(positionSecondDigit), 10);
    return firstDigit === ieAtFirstPos && secondDigit === ieAtSecondPos;
  };

  _proto.calcFirstDigit = function calcFirstDigit(ie) {
    var body = ie.substr(0, 8);
    var weight = [1, 3, 4, 5, 6, 7, 8, 10];
    var sum = 0;
    body.split('').forEach(function (digit, index) {
      sum += parseInt(digit, 10) * weight[index];
    });
    var dig = sum % 11;
    var digit = dig.toString();
    return parseInt(digit.substr(digit.length - 1, 1), 10);
  };

  _proto.calcSecondDigit = function calcSecondDigit(ie) {
    var body = ie.substr(0, 11);
    var weight = 3;
    var sum = 0;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight--;

      if (weight === 1) {
        weight = 10;
      }
    });
    var dig = sum % 11;
    var digit = dig.toString();
    return parseInt(digit.substr(digit.length - 1, 1), 10);
  };

  return SP;
}(Validator);

var SE = /*#__PURE__*/function (_CE) {
  _inheritsLoose(SE, _CE);

  function SE() {
    return _CE.apply(this, arguments) || this;
  }

  return SE;
}(CE);

var TO = /*#__PURE__*/function (_CE) {
  _inheritsLoose(TO, _CE);

  function TO() {
    return _CE.apply(this, arguments) || this;
  }

  var _proto = TO.prototype;

  _proto.checkLength = function checkLength(ie) {
    return STATES_DATA.TO.ieLength.includes(ie.length);
  };

  _proto.itStartsWith = function itStartsWith(ie) {
    return Boolean(ie);
  };

  _proto.calcIe = function calcIe(ie) {
    return this.checkOld(ie) || this.checkNew(ie);
  };

  _proto.checkOld = function checkOld(ie) {
    var body = ie.slice(0, 2) + ie.slice(4);
    return this.oldStartsWith(ie) && this.calcOld(body);
  };

  _proto.oldStartsWith = function oldStartsWith(ie) {
    var beginWith = ['01', '02', '03', '99'];
    var begin = ie.substr(2, 2);
    return beginWith.indexOf(begin) >= 0;
  };

  _proto.calcOld = function calcOld(ie) {
    return this.calcDigit(ie);
  };

  _proto.checkNew = function checkNew(ie) {
    return this.calcNew(ie);
  };

  _proto.calcNew = function calcNew(ie) {
    var length = ie.length;
    var position = length - 1;
    var weight = 9;
    var body = ie.substr(0, position);
    var sum = 0;
    body.split('').forEach(function (digit) {
      sum += parseInt(digit, 10) * weight;
      weight--;
    });
    var rest = sum % 11;
    var dig = 11 - rest;

    if (rest < 2) {
      dig = 0;
    }

    return dig === parseInt(ie.charAt(position), 10);
  };

  return TO;
}(CE);

var STATE = {
  AC: AC,
  AL: AL,
  AP: AP,
  AM: AM,
  BA: BA,
  CE: CE,
  DF: DF,
  ES: ES,
  GO: GO,
  MA: MA,
  MT: MT,
  MS: MS,
  MG: MG,
  PA: PA,
  PB: PB,
  PR: PR,
  PE: PE,
  PI: PI,
  RJ: RJ,
  RN: RN,
  RS: RS,
  RO: RO,
  RR: RR,
  SC: SC,
  SP: SP,
  SE: SE,
  TO: TO
};

function isValid(uf, inscricaoEstadual) {
  var digits = onlyNumbers(inscricaoEstadual);
  var state = new STATE[uf]();
  return state.isValid(digits);
}

var LENGTH = 11;
var WEIGHTS = [3, 2, 9, 8, 7, 6, 5, 4, 3, 2];
var RESERVED_NUMBERS = ['00000000000', '11111111111', '22222222222', '33333333333', '44444444444', '55555555555', '66666666666', '77777777777', '88888888888', '99999999999'];

function isValidLength(pis) {
  return pis.length === LENGTH;
}

function isReservedNumber(pis) {
  return RESERVED_NUMBERS.indexOf(pis) >= 0;
}

function hasOnlyNumbers(pis) {
  return !!pis.match(/^[0-9]+$/);
}

function removeSeparators(pis) {
  return pis.replace(/[ ().,*-]/g, '');
}

function isValid$1(pis) {
  if (!pis || typeof pis !== 'string') return false;
  var numeric = removeSeparators(pis);
  if (!isValidLength(numeric) || isReservedNumber(numeric) || !hasOnlyNumbers(numeric)) return false;
  var weightedChecksum = generateChecksum(numeric.substr(0, numeric.length - 1), WEIGHTS);
  var verifyingDigit = +numeric.charAt(numeric.length - 1);
  var calculatedDigit = 11 - weightedChecksum % 11;
  return calculatedDigit === verifyingDigit || calculatedDigit === 10 && verifyingDigit === 0 || calculatedDigit === 11 && verifyingDigit === 0;
}

var VALID_AREA_CODES = /*#__PURE__*/Object.keys(STATES_DATA).reduce(function (acc, state) {
  return acc.concat(STATES_DATA[state].areaCodes);
}, []);
var PHONE_MIN_LENGTH = 10;
var PHONE_MAX_LENGTH = 11;
var MOBILE_VALID_FIRST_NUMBERS = [6, 7, 8, 9];
var LANDLINE_VALID_FIRST_NUMBERS = [2, 3, 4, 5];

function isValidDDD(phone) {
  return VALID_AREA_CODES.includes(Number(phone.substr(0, 2)));
}

function isValidMobilePhoneLength(phone) {
  return phone.length === PHONE_MAX_LENGTH;
}

function isValidLandlinePhoneLength(phone) {
  return phone.length >= PHONE_MIN_LENGTH && phone.length < PHONE_MAX_LENGTH;
}

function isValidLength$1(phone) {
  return isValidLandlinePhoneLength(phone) || isValidMobilePhoneLength(phone);
}

function isValidMobilePhoneFirstNumber(phone) {
  return MOBILE_VALID_FIRST_NUMBERS.includes(Number(phone.charAt(2)));
}

function isValidLandlinePhoneFirstNumber(phone) {
  return LANDLINE_VALID_FIRST_NUMBERS.includes(Number(phone.charAt(2)));
}

function isValidFirstNumber(phone) {
  return phone.length === PHONE_MIN_LENGTH ? isValidLandlinePhoneFirstNumber(phone) : isValidMobilePhoneFirstNumber(phone);
}

function parsePhoneDigits(phone) {
  return {
    isValidDigits: !!phone && typeof phone === 'string',
    digits: onlyNumbers(phone)
  };
}

function isValidMobilePhone(phone) {
  var _parsePhoneDigits = parsePhoneDigits(phone),
      isValidDigits = _parsePhoneDigits.isValidDigits,
      digits = _parsePhoneDigits.digits;

  if (!isValidDigits) return false;
  return isValidMobilePhoneLength(digits) && isValidMobilePhoneFirstNumber(digits) && isValidDDD(digits);
}

function isValidLandlinePhone(phone) {
  var _parsePhoneDigits2 = parsePhoneDigits(phone),
      isValidDigits = _parsePhoneDigits2.isValidDigits,
      digits = _parsePhoneDigits2.digits;

  if (!isValidDigits) return false;
  return isValidLandlinePhoneLength(digits) && isValidLandlinePhoneFirstNumber(digits) && isValidDDD(digits);
}

function isValid$2(phone) {
  var _parsePhoneDigits3 = parsePhoneDigits(phone),
      isValidDigits = _parsePhoneDigits3.isValidDigits,
      digits = _parsePhoneDigits3.digits;

  if (!isValidDigits) return false;
  return isValidLength$1(digits) && isValidFirstNumber(digits) && isValidDDD(digits);
}

var MAX_RECIPIENT_LENGTH = 64;
var MAX_DOMAIN_LENGTH = 253;
var MAX_EMAIL_LENGTH = MAX_RECIPIENT_LENGTH + 1 + MAX_DOMAIN_LENGTH;
var validEmailRegex = /^([!#$%&'*+\-/=?^_`{|}~]{0,1}([a-zA-Z0-9][!#$%&'*+\-/=?^_`{|}~.]{0,1})+)@(([a-zA-Z0-9][-.]{0,1})+)([.]{1}[a-zA-Z0-9]+)$/;

var stringIsBiggerThan = function stringIsBiggerThan(len) {
  for (var _len = arguments.length, strs = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    strs[_key - 1] = arguments[_key];
  }

  return strs.reduce(function (length, s) {
    return length + s.length;
  }, 0) > len;
};

function isValid$3(email) {
  if (!email || typeof email !== 'string') return false;
  if (stringIsBiggerThan(MAX_EMAIL_LENGTH, email)) return false;
  var matchedEmail = validEmailRegex.exec(email);
  if (!matchedEmail) return false;
  var recipient = matchedEmail[1],
      domain = matchedEmail[3],
      topLevelDomain = matchedEmail[5];
  if (stringIsBiggerThan(MAX_RECIPIENT_LENGTH, recipient)) return false;
  if (stringIsBiggerThan(MAX_DOMAIN_LENGTH, domain, topLevelDomain)) return false;
  return true;
}

var validMercosulLicensePlateRegex = /^[a-z]{3}[0-9]{1}[a-z]{1}[0-9]{2}$/i;
var validBrazilianLicensePlateRegex = /^[a-z]{3}-?[0-9]{4}$/i;

function isValid$4(licensePlate) {
  if (!licensePlate || typeof licensePlate !== 'string') return false;
  return validMercosulLicensePlateRegex.test(licensePlate) || validBrazilianLicensePlateRegex.test(licensePlate);
}

var LENGTH$1 = 20;
var DOT_INDEXES = [8, 12, 15];
var HYPHEN_INDEXES = [6];

function format(processoJuridico) {
  var digits = onlyNumbers(processoJuridico);
  return digits.slice(0, LENGTH$1).split('').reduce(function (acc, digit, index) {
    var result = "" + acc + digit;

    if (!isLastChar(index, processoJuridico)) {
      if (DOT_INDEXES.includes(index)) return result + ".";
      if (HYPHEN_INDEXES.includes(index)) return result + "-";
    }

    return result;
  }, '');
}

var LENGTH$2 = 8;
var HYPHEN_INDEXES$1 = [4];

function isValidLength$2(cep) {
  return cep.length === LENGTH$2;
}

function format$1(cep) {
  var digits = onlyNumbers(cep);
  return digits.slice(0, LENGTH$2).split('').reduce(function (acc, digit, i) {
    var result = "" + acc + digit;

    if (!isLastChar(i, digits)) {
      if (HYPHEN_INDEXES$1.indexOf(i) >= 0) return result + "-";
    }

    return result;
  }, '');
}

function isValid$5(cep) {
  if (!cep || typeof cep !== 'string') return false;
  var digits = onlyNumbers(cep);
  return isValidLength$2(digits);
}

var PARTIALS = [{
  end: 9,
  start: 0,
  index: 9
}, {
  end: 20,
  start: 10,
  index: 20
}, {
  end: 31,
  start: 21,
  index: 31
}];
var DOT_INDEXES$1 = [4, 14, 25];
var SPACE_INDEXES = [9, 20, 31, 32];
var LENGTH$3 = 47;
var CHECK_DIGIT_POSITION = 4;
var MOD_11_WEIGHTS = {
  end: 9,
  initial: 2
};
var MOD_10_WEIGHTS = [2, 1];
var DIGITABLE_LINE_TO_BOLETO_CONVERT_POSITIONS = [{
  end: 4,
  start: 0
}, {
  end: 47,
  start: 32
}, {
  end: 9,
  start: 4
}, {
  end: 20,
  start: 10
}, {
  end: 31,
  start: 21
}];

function isValidLength$3(digitableLine) {
  return digitableLine.length === LENGTH$3;
}

function mod10(partial) {
  var sum = partial.split('').reverse().reduce(function (acc, digit, index) {
    var result = parseInt(digit, 10) * MOD_10_WEIGHTS[index % 2];
    return acc + (result > 9 ? 1 + result % 10 : result);
  }, 0);
  var mod = sum % 10;
  return mod > 0 ? 10 - mod : 0;
}

function mod11(value) {
  var initial = MOD_11_WEIGHTS.initial,
      end = MOD_11_WEIGHTS.end;
  var weight = initial;
  var sum = value.split('').reverse().reduce(function (acc, digit) {
    var result = parseInt(digit, 10) * weight;
    weight = weight < end ? weight + 1 : initial;
    return acc + result;
  }, 0);
  var mod = sum % 11;
  return mod === 0 || mod === 1 ? 1 : 11 - mod;
}

function isValidPartials(digitableLine) {
  return PARTIALS.every(function (_ref) {
    var start = _ref.start,
        end = _ref.end,
        index = _ref.index;
    var mod = mod10(digitableLine.substring(start, end));
    return +digitableLine[index] === mod;
  });
}

function parse(digitableLine) {
  return DIGITABLE_LINE_TO_BOLETO_CONVERT_POSITIONS.reduce(function (acc, pos) {
    return acc + digitableLine.substring(pos.start, pos.end);
  }, '');
}

function isValidCheckDigit(parsedDigitableLine) {
  var mod = mod11(parsedDigitableLine.slice(0, CHECK_DIGIT_POSITION) + parsedDigitableLine.slice(CHECK_DIGIT_POSITION + 1));
  return +parsedDigitableLine[CHECK_DIGIT_POSITION] === mod;
}

function isValid$6(digitableLine) {
  if (!digitableLine || typeof digitableLine !== 'string') return false;
  var digits = onlyNumbers(digitableLine);
  if (!isValidLength$3(digits)) return false;
  if (!isValidPartials(digits)) return false;
  var parsedDigits = parse(digits);
  return isValidCheckDigit(parsedDigits);
}

function format$2(boleto) {
  var digits = onlyNumbers(boleto);
  return digits.slice(0, LENGTH$3).split('').reduce(function (acc, digit, index) {
    var result = "" + acc + digit;

    if (!isLastChar(index, digits)) {
      if (DOT_INDEXES$1.indexOf(index) >= 0) return result + ".";
      if (SPACE_INDEXES.indexOf(index) >= 0) return result + " ";
    }

    return result;
  }, '');
}

function format$3(value, options) {
  if (options === void 0) {
    options = {
      precision: 2
    };
  }

  return value.toFixed(options.precision).replace('.', ',').replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1.');
}

function parse$1(value) {
  return parseInt(value.replace(/\D/g, '') || '0', 10) / 100;
}

var LENGTH$4 = 11;
var DOT_INDEXES$2 = [2, 5];
var HYPHEN_INDEXES$2 = [8];
var RESERVED_NUMBERS$1 = ['00000000000', '11111111111', '22222222222', '33333333333', '44444444444', '55555555555', '66666666666', '77777777777', '88888888888', '99999999999'];
var CHECK_DIGITS_INDEXES = [9, 10];

function format$4(cpf, options) {
  if (options === void 0) {
    options = {};
  }

  var digits = onlyNumbers(cpf);

  if (options.pad) {
    digits = digits.padStart(LENGTH$4, '0');
  }

  return digits.slice(0, LENGTH$4).split('').reduce(function (acc, digit, i) {
    var result = "" + acc + digit;

    if (!isLastChar(i, digits)) {
      if (DOT_INDEXES$2.indexOf(i) >= 0) return result + ".";
      if (HYPHEN_INDEXES$2.indexOf(i) >= 0) return result + "-";
    }

    return result;
  }, '');
}

function generate(state) {
  var stateCode = state && STATES.includes(state) ? STATES_DATA[state].code : generateRandomNumber(1);
  var baseCPF = generateRandomNumber(LENGTH$4 - 3) + stateCode;
  var firstCheckDigitMod = generateChecksum(baseCPF, 10) % 11;
  var firstCheckDigit = (firstCheckDigitMod < 2 ? 0 : 11 - firstCheckDigitMod).toString();
  var secondCheckDigitMod = generateChecksum(baseCPF + firstCheckDigit, 11) % 11;
  var secondCheckDigit = (secondCheckDigitMod < 2 ? 0 : 11 - secondCheckDigitMod).toString();
  return "" + baseCPF + firstCheckDigit.toString() + secondCheckDigit.toString();
}

function isValidFormat(cpf) {
  return /^\d{3}\.?\d{3}\.?\d{3}-?\d{2}$/.test(cpf);
}

function isReservedNumber$1(cpf) {
  return RESERVED_NUMBERS$1.indexOf(cpf) >= 0;
} // TODO: move to checksum helper


function isValidChecksum(cpf) {
  return CHECK_DIGITS_INDEXES.every(function (i) {
    var mod = generateChecksum(cpf.slice(0, i).split('').reduce(function (acc, digit) {
      return acc + digit;
    }, ''), i + 1) % 11;
    return cpf[i] === String(mod < 2 ? 0 : 11 - mod);
  });
}

function isValid$7(cpf) {
  if (!cpf || typeof cpf !== 'string') return false;
  var digits = onlyNumbers(cpf);
  return isValidFormat(cpf) && !isReservedNumber$1(digits) && isValidChecksum(digits);
}

var LENGTH$5 = 14;
var DOT_INDEXES$3 = [1, 4];
var SLASH_INDEXES = [7];
var HYPHEN_INDEXES$3 = [11];
var RESERVED_NUMBERS$2 = ['00000000000000', '11111111111111', '22222222222222', '33333333333333', '44444444444444', '55555555555555', '66666666666666', '77777777777777', '88888888888888', '99999999999999'];
var CHECK_DIGITS_INDEXES$1 = [12, 13];
var FIRST_CHECK_DIGIT_WEIGHTS = [5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2];
var SECOND_CHECK_DIGIT_WEIGHTS = /*#__PURE__*/[6].concat(FIRST_CHECK_DIGIT_WEIGHTS);

function format$5(cnpj, options) {
  if (options === void 0) {
    options = {};
  }

  var digits = onlyNumbers(cnpj);

  if (options.pad) {
    digits = digits.padStart(LENGTH$5, '0');
  }

  return digits.slice(0, LENGTH$5).split('').reduce(function (acc, digit, index) {
    var result = "" + acc + digit;

    if (!isLastChar(index, digits)) {
      if (DOT_INDEXES$3.includes(index)) return result + ".";
      if (SLASH_INDEXES.includes(index)) return result + "/";
      if (HYPHEN_INDEXES$3.includes(index)) return result + "-";
    }

    return result;
  }, '');
}

function generate$1() {
  var baseCNPJ = generateRandomNumber(LENGTH$5 - 2);
  var firstCheckDigitMod = generateChecksum(baseCNPJ, FIRST_CHECK_DIGIT_WEIGHTS) % 11;
  var firstCheckDigit = (firstCheckDigitMod < 2 ? 0 : 11 - firstCheckDigitMod).toString();
  var secondCheckDigitMod = generateChecksum(baseCNPJ + firstCheckDigit, SECOND_CHECK_DIGIT_WEIGHTS) % 11;
  var secondCheckDigit = (secondCheckDigitMod < 2 ? 0 : 11 - secondCheckDigitMod).toString();
  return "" + baseCNPJ + firstCheckDigit + secondCheckDigit;
}

function isValidFormat$1(cnpj) {
  return /^\d{2}\.?\d{3}\.?\d{3}\/?\d{4}-?\d{2}$/.test(cnpj);
}

function isReservedNumber$2(cpf) {
  return RESERVED_NUMBERS$2.indexOf(cpf) >= 0;
} // TODO: move to checksum helper


function isValidChecksum$1(cnpj) {
  var weights = [].concat(FIRST_CHECK_DIGIT_WEIGHTS);
  return CHECK_DIGITS_INDEXES$1.every(function (i) {
    if (i === CHECK_DIGITS_INDEXES$1[CHECK_DIGITS_INDEXES$1.length - 1]) {
      weights.unshift(6);
    }

    var mod = generateChecksum(cnpj.slice(0, i).split('').reduce(function (acc, digit) {
      return acc + digit;
    }, ''), weights) % 11;
    return cnpj[i] === String(mod < 2 ? 0 : 11 - mod);
  });
}

function isValid$8(cnpj) {
  if (!cnpj || typeof cnpj !== 'string') return false;
  var numbers = onlyNumbers(cnpj);
  return isValidFormat$1(cnpj) && !isReservedNumber$2(numbers) && isValidChecksum$1(numbers);
}

var ACRONYMS = ['cia', 'cnpj', 'cpf', 'ltda', 'me', 'rg'];
var PREPOSITIONS = ['a', 'com', 'da', 'das', 'de', 'do', 'dos', 'e', 'em', 'na', 'nas', 'no', 'nos', 'o', 'por', 'sem'];

function capitalize(value, _temp) {
  var _ref = _temp === void 0 ? {} : _temp,
      _ref$lowerCaseWords = _ref.lowerCaseWords,
      lowerCaseWords = _ref$lowerCaseWords === void 0 ? PREPOSITIONS : _ref$lowerCaseWords,
      _ref$upperCaseWords = _ref.upperCaseWords,
      upperCaseWords = _ref$upperCaseWords === void 0 ? ACRONYMS : _ref$upperCaseWords;

  return value.split(' ').filter(function (word) {
    return !!word;
  }).map(function (word, index) {
    var lowerCaseWord = word.toLocaleLowerCase();
    if (index > 0 && lowerCaseWords.indexOf(lowerCaseWord) !== -1) return lowerCaseWord;
    var upperCaseWord = word.toLocaleUpperCase();
    if (upperCaseWords.indexOf(upperCaseWord) !== -1) return upperCaseWord;
    return upperCaseWord.charAt(0) + lowerCaseWord.substr(1);
  }).join(' ');
}

var stateNameComparer = function stateNameComparer(_ref, _ref2) {
  var nameA = _ref.name;
  var nameB = _ref2.name;
  return nameA.localeCompare(nameB);
};

var sortByStateName = function sortByStateName(states) {
  return states.sort(stateNameComparer);
};

function getStates() {
  var states = STATES.map(function (code) {
    return {
      code: code,
      name: STATES_DATA[code].name
    };
  });
  return sortByStateName(states);
}

var CITIES_DATA = {
  GO: ['Abadia de Goiás', 'Abadiânia', 'Acreúna', 'Adelândia', 'Alexânia', 'Aloândia', 'Alto Horizonte', 'Alto Paraíso de Goiás', 'Alvorada do Norte', 'Amaralina', 'Americano do Brasil', 'Amorinópolis', 'Anhanguera', 'Anicuns', 'Anápolis', 'Aparecida de Goiânia', 'Aparecida do Rio Doce', 'Aporé', 'Aragarças', 'Aragoiânia', 'Araguapaz', 'Araçu', 'Arenópolis', 'Aruanã', 'Aurilândia', 'Avelinópolis', 'Baliza', 'Barro Alto', 'Bela Vista de Goiás', 'Bom Jardim de Goiás', 'Bom Jesus de Goiás', 'Bonfinópolis', 'Bonópolis', 'Brazabrantes', 'Britânia', 'Buriti Alegre', 'Buriti de Goiás', 'Buritinópolis', 'Cabeceiras', 'Cachoeira Alta', 'Cachoeira Dourada', 'Cachoeira de Goiás', 'Caiapônia', 'Caldas Novas', 'Caldazinha', 'Campestre de Goiás', 'Campinaçu', 'Campinorte', 'Campo Alegre de Goiás', 'Campo Limpo de Goiás', 'Campos Belos', 'Campos Verdes', 'Carmo do Rio Verde', 'Castelândia', 'Catalão', 'Caturaí', 'Cavalcante', 'Caçu', 'Ceres', 'Cezarina', 'Chapadão do Céu', 'Cidade Ocidental', 'Cocalzinho de Goiás', 'Colinas do Sul', 'Corumbaíba', 'Corumbá de Goiás', 'Cristalina', 'Cristianópolis', 'Crixás', 'Cromínia', 'Cumari', 'Córrego do Ouro', 'Damianópolis', 'Damolândia', 'Davinópolis', 'Diorama', 'Divinópolis de Goiás', 'Doverlândia', 'Edealina', 'Edéia', 'Estrela do Norte', 'Faina', 'Fazenda Nova', 'Firminópolis', 'Flores de Goiás', 'Formosa', 'Formoso', 'Gameleira de Goiás', 'Goiandira', 'Goianira', 'Goianápolis', 'Goianésia', 'Goiatuba', 'Goiás', 'Goiânia', 'Gouvelândia', 'Guapó', 'Guarani de Goiás', 'Guaraíta', 'Guarinos', 'Heitoraí', 'Hidrolina', 'Hidrolândia', 'Iaciara', 'Inaciolândia', 'Indiara', 'Inhumas', 'Ipameri', 'Ipiranga de Goiás', 'Iporá', 'Israelândia', 'Itaberaí', 'Itaguari', 'Itaguaru', 'Itajá', 'Itapaci', 'Itapirapuã', 'Itapuranga', 'Itarumã', 'Itauçu', 'Itumbiara', 'Ivolândia', 'Jandaia', 'Jaraguá', 'Jataí', 'Jaupaci', 'Jesúpolis', 'Joviânia', 'Jussara', 'Lagoa Santa', 'Leopoldo de Bulhões', 'Luziânia', 'Mairipotaba', 'Mambaí', 'Mara Rosa', 'Marzagão', 'Matrinchã', 'Maurilândia', 'Mimoso de Goiás', 'Minaçu', 'Mineiros', 'Moiporá', 'Monte Alegre de Goiás', 'Montes Claros de Goiás', 'Montividiu', 'Montividiu do Norte', 'Morrinhos', 'Morro Agudo de Goiás', 'Mossâmedes', 'Mozarlândia', 'Mundo Novo', 'Mutunópolis', 'Nazário', 'Nerópolis', 'Niquelândia', 'Nova América', 'Nova Aurora', 'Nova Crixás', 'Nova Glória', 'Nova Iguaçu de Goiás', 'Nova Roma', 'Nova Veneza', 'Novo Brasil', 'Novo Gama', 'Novo Planalto', 'Orizona', 'Ouro Verde de Goiás', 'Ouvidor', 'Padre Bernardo', 'Palestina de Goiás', 'Palmeiras de Goiás', 'Palmelo', 'Palminópolis', 'Panamá', 'Paranaiguara', 'Paraúna', 'Perolândia', 'Petrolina de Goiás', 'Pilar de Goiás', 'Piracanjuba', 'Piranhas', 'Pirenópolis', 'Pires do Rio', 'Planaltina', 'Pontalina', 'Porangatu', 'Porteirão', 'Portelândia', 'Posse', 'Professor Jamil', 'Quirinópolis', 'Rialma', 'Rianápolis', 'Rio Quente', 'Rio Verde', 'Rubiataba', 'Sanclerlândia', 'Santa Bárbara de Goiás', 'Santa Cruz de Goiás', 'Santa Fé de Goiás', 'Santa Helena de Goiás', 'Santa Isabel', 'Santa Rita do Araguaia', 'Santa Rita do Novo Destino', 'Santa Rosa de Goiás', 'Santa Tereza de Goiás', 'Santa Terezinha de Goiás', 'Santo Antônio da Barra', 'Santo Antônio de Goiás', 'Santo Antônio do Descoberto', 'Senador Canedo', 'Serranópolis', 'Silvânia', 'Simolândia', 'São Domingos', 'São Francisco de Goiás', "São João d'Aliança", 'São João da Paraúna', 'São Luiz do Norte', 'São Luís de Montes Belos', 'São Miguel do Araguaia', 'São Miguel do Passa Quatro', 'São Patrício', 'São Simão', "Sítio d'Abadia", 'Taquaral de Goiás', 'Teresina de Goiás', 'Terezópolis de Goiás', 'Trindade', 'Trombas', 'Três Ranchos', 'Turvelândia', 'Turvânia', 'Uirapuru', 'Uruana', 'Uruaçu', 'Urutaí', 'Valparaíso de Goiás', 'Varjão', 'Vianópolis', 'Vicentinópolis', 'Vila Boa', 'Vila Propício', 'Água Fria de Goiás', 'Água Limpa', 'Águas Lindas de Goiás'],
  MG: ['Abadia dos Dourados', 'Abaeté', 'Abre Campo', 'Acaiaca', 'Aguanil', 'Aimorés', 'Aiuruoca', 'Alagoa', 'Albertina', 'Alfenas', 'Alfredo Vasconcelos', 'Almenara', 'Alpercata', 'Alpinópolis', 'Alterosa', 'Alto Caparaó', 'Alto Jequitibá', 'Alto Rio Doce', 'Alvarenga', 'Alvinópolis', 'Alvorada de Minas', 'Além Paraíba', 'Amparo do Serra', 'Andradas', 'Andrelândia', 'Angelândia', 'Antônio Carlos', 'Antônio Dias', 'Antônio Prado de Minas', 'Aracitaba', 'Araguari', 'Arantina', 'Araponga', 'Araporã', 'Arapuá', 'Araxá', 'Araçaí', 'Araçuaí', 'Araújos', 'Arceburgo', 'Arcos', 'Areado', 'Argirita', 'Aricanduva', 'Arinos', 'Astolfo Dutra', 'Ataléia', 'Augusto de Lima', 'Açucena', 'Baependi', 'Baldim', 'Bambuí', 'Bandeira', 'Bandeira do Sul', 'Barbacena', 'Barra Longa', 'Barroso', 'Barão de Cocais', 'Barão de Monte Alto', 'Bela Vista de Minas', 'Belmiro Braga', 'Belo Horizonte', 'Belo Oriente', 'Belo Vale', 'Berilo', 'Berizal', 'Bertópolis', 'Betim', 'Bias Fortes', 'Bicas', 'Biquinhas', 'Boa Esperança', 'Bocaina de Minas', 'Bocaiúva', 'Bom Despacho', 'Bom Jardim de Minas', 'Bom Jesus da Penha', 'Bom Jesus do Amparo', 'Bom Jesus do Galho', 'Bom Repouso', 'Bom Sucesso', 'Bonfim', 'Bonfinópolis de Minas', 'Bonito de Minas', 'Borda da Mata', 'Botelhos', 'Botumirim', 'Brasilândia de Minas', 'Brasília de Minas', 'Brazópolis', 'Braúnas', 'Brumadinho', 'Brás Pires', 'Bueno Brandão', 'Buenópolis', 'Bugre', 'Buritis', 'Buritizeiro', 'Cabeceira Grande', 'Cabo Verde', 'Cachoeira Dourada', 'Cachoeira da Prata', 'Cachoeira de Minas', 'Cachoeira de Pajeú', 'Caetanópolis', 'Caeté', 'Caiana', 'Cajuri', 'Caldas', 'Camacho', 'Camanducaia', 'Cambuquira', 'Cambuí', 'Campanha', 'Campanário', 'Campestre', 'Campina Verde', 'Campo Azul', 'Campo Belo', 'Campo Florido', 'Campo do Meio', 'Campos Altos', 'Campos Gerais', 'Cana Verde', 'Canaã', 'Candeias', 'Cantagalo', 'Canápolis', 'Caparaó', 'Capela Nova', 'Capelinha', 'Capetinga', 'Capim Branco', 'Capinópolis', 'Capitão Andrade', 'Capitão Enéas', 'Capitólio', 'Caputira', 'Caranaíba', 'Carandaí', 'Carangola', 'Caratinga', 'Caraí', 'Carbonita', 'Careaçu', 'Carlos Chagas', 'Carmo da Cachoeira', 'Carmo da Mata', 'Carmo de Minas', 'Carmo do Cajuru', 'Carmo do Paranaíba', 'Carmo do Rio Claro', 'Carmésia', 'Carmópolis de Minas', 'Carneirinho', 'Carrancas', 'Carvalhos', 'Carvalhópolis', 'Casa Grande', 'Cascalho Rico', 'Cataguases', 'Catas Altas', 'Catas Altas da Noruega', 'Catuji', 'Catuti', 'Caxambu', 'Cedro do Abaeté', 'Central de Minas', 'Centralina', 'Chalé', 'Chapada Gaúcha', 'Chapada do Norte', 'Chiador', 'Chácara', 'Cipotânea', 'Claraval', 'Claro dos Poções', 'Cláudio', 'Coimbra', 'Coluna', 'Comendador Gomes', 'Comercinho', 'Conceição da Aparecida', 'Conceição da Barra de Minas', 'Conceição das Alagoas', 'Conceição das Pedras', 'Conceição de Ipanema', 'Conceição do Mato Dentro', 'Conceição do Pará', 'Conceição do Rio Verde', 'Conceição dos Ouros', 'Confins', 'Congonhal', 'Congonhas', 'Congonhas do Norte', 'Conquista', 'Conselheiro Lafaiete', 'Conselheiro Pena', 'Consolação', 'Contagem', 'Coqueiral', 'Coração de Jesus', 'Cordisburgo', 'Cordislândia', 'Corinto', 'Coroaci', 'Coromandel', 'Coronel Fabriciano', 'Coronel Murta', 'Coronel Pacheco', 'Coronel Xavier Chaves', 'Couto de Magalhães de Minas', 'Cristais', 'Cristiano Otoni', 'Cristina', 'Cristália', 'Crisólita', 'Crucilândia', 'Cruzeiro da Fortaleza', 'Cruzília', 'Cuparaque', 'Curral de Dentro', 'Curvelo', 'Cássia', 'Córrego Danta', 'Córrego Fundo', 'Córrego Novo', 'Córrego do Bom Jesus', 'Cônego Marinho', 'Datas', 'Delfim Moreira', 'Delfinópolis', 'Delta', 'Descoberto', 'Desterro de Entre Rios', 'Desterro do Melo', 'Diamantina', 'Diogo de Vasconcelos', 'Dionísio', 'Divino', 'Divino das Laranjeiras', 'Divinolândia de Minas', 'Divinésia', 'Divinópolis', 'Divisa Alegre', 'Divisa Nova', 'Divisópolis', 'Dom Bosco', 'Dom Cavati', 'Dom Joaquim', 'Dom Silvério', 'Dom Viçoso', 'Dona Euzébia', 'Dores de Campos', 'Dores de Guanhães', 'Dores do Indaiá', 'Dores do Turvo', 'Doresópolis', 'Douradoquara', 'Durandé', 'Elói Mendes', 'Engenheiro Caldas', 'Engenheiro Navarro', 'Entre Folhas', 'Entre Rios de Minas', 'Ervália', 'Esmeraldas', 'Espera Feliz', 'Espinosa', 'Espírito Santo do Dourado', 'Estiva', 'Estrela Dalva', 'Estrela do Indaiá', 'Estrela do Sul', 'Eugenópolis', 'Ewbank da Câmara', 'Extrema', 'Fama', 'Faria Lemos', 'Felisburgo', 'Felixlândia', 'Felício dos Santos', 'Fernandes Tourinho', 'Ferros', 'Fervedouro', 'Florestal', 'Formiga', 'Formoso', 'Fortaleza de Minas', 'Fortuna de Minas', 'Francisco Badaró', 'Francisco Dumont', 'Francisco Sá', 'Franciscópolis', 'Frei Gaspar', 'Frei Inocêncio', 'Frei Lagonegro', 'Fronteira', 'Fronteira dos Vales', 'Fruta de Leite', 'Frutal', 'Funilândia', 'Galiléia', 'Gameleiras', 'Glaucilândia', 'Goiabeira', 'Goianá', 'Gonzaga', 'Gonçalves', 'Gouveia', 'Governador Valadares', 'Grupiara', 'Grão Mogol', 'Guanhães', 'Guapé', 'Guaraciaba', 'Guaraciama', 'Guarani', 'Guaranésia', 'Guarará', 'Guarda-Mor', 'Guaxupé', 'Guidoval', 'Guimarânia', 'Guiricema', 'Gurinhatã', 'Heliodora', 'Iapu', 'Ibertioga', 'Ibiaí', 'Ibiracatu', 'Ibiraci', 'Ibirité', 'Ibitiúra de Minas', 'Ibituruna', 'Ibiá', 'Icaraí de Minas', 'Igarapé', 'Igaratinga', 'Iguatama', 'Ijaci', 'Ilicínea', 'Imbé de Minas', 'Inconfidentes', 'Indaiabira', 'Indianópolis', 'Ingaí', 'Inhapim', 'Inhaúma', 'Inimutaba', 'Ipaba', 'Ipanema', 'Ipatinga', 'Ipiaçu', 'Ipuiúna', 'Iraí de Minas', 'Itabira', 'Itabirinha', 'Itabirito', 'Itacambira', 'Itacarambi', 'Itaguara', 'Itaipé', 'Itajubá', 'Itamarandiba', 'Itamarati de Minas', 'Itambacuri', 'Itambé do Mato Dentro', 'Itamogi', 'Itamonte', 'Itanhandu', 'Itanhomi', 'Itaobim', 'Itapagipe', 'Itapecerica', 'Itapeva', 'Itatiaiuçu', 'Itaverava', 'Itaú de Minas', 'Itaúna', 'Itinga', 'Itueta', 'Ituiutaba', 'Itumirim', 'Iturama', 'Itutinga', 'Jaboticatubas', 'Jacinto', 'Jacutinga', 'Jacuí', 'Jaguaraçu', 'Jampruca', 'Janaúba', 'Januária', 'Japaraíba', 'Japonvar', 'Jaíba', 'Jeceaba', 'Jenipapo de Minas', 'Jequeri', 'Jequitaí', 'Jequitibá', 'Jequitinhonha', 'Jesuânia', 'Joanésia', 'Joaquim Felício', 'Joaíma', 'Jordânia', 'Josenópolis', 'José Gonçalves de Minas', 'José Raydan', 'João Monlevade', 'João Pinheiro', 'Juatuba', 'Juiz de Fora', 'Juramento', 'Juruaia', 'Juvenília', 'Ladainha', 'Lagamar', 'Lagoa Dourada', 'Lagoa Formosa', 'Lagoa Grande', 'Lagoa Santa', 'Lagoa da Prata', 'Lagoa dos Patos', 'Lajinha', 'Lambari', 'Lamim', 'Laranjal', 'Lassance', 'Lavras', 'Leandro Ferreira', 'Leme do Prado', 'Leopoldina', 'Liberdade', 'Lima Duarte', 'Limeira do Oeste', 'Lontra', 'Luisburgo', 'Luislândia', 'Luminárias', 'Luz', 'Machacalis', 'Machado', 'Madre de Deus de Minas', 'Malacacheta', 'Mamonas', 'Manga', 'Manhuaçu', 'Manhumirim', 'Mantena', 'Mar de Espanha', 'Maravilhas', 'Maria da Fé', 'Mariana', 'Marilac', 'Maripá de Minas', 'Marliéria', 'Marmelópolis', 'Martinho Campos', 'Martins Soares', 'Mata Verde', 'Materlândia', 'Mateus Leme', 'Mathias Lobato', 'Matias Barbosa', 'Matias Cardoso', 'Matipó', 'Mato Verde', 'Matozinhos', 'Matutina', 'Medeiros', 'Medina', 'Mendes Pimentel', 'Mercês', 'Mesquita', 'Minas Novas', 'Minduri', 'Mirabela', 'Miradouro', 'Miravânia', 'Miraí', 'Moeda', 'Moema', 'Monjolos', 'Monsenhor Paulo', 'Montalvânia', 'Monte Alegre de Minas', 'Monte Azul', 'Monte Belo', 'Monte Carmelo', 'Monte Formoso', 'Monte Santo de Minas', 'Monte Sião', 'Montes Claros', 'Montezuma', 'Morada Nova de Minas', 'Morro da Garça', 'Morro do Pilar', 'Munhoz', 'Muriaé', 'Mutum', 'Muzambinho', 'Mário Campos', 'Nacip Raydan', 'Nanuque', 'Naque', 'Natalândia', 'Natércia', 'Nazareno', 'Nepomuceno', 'Ninheira', 'Nova Belém', 'Nova Era', 'Nova Lima', 'Nova Módica', 'Nova Ponte', 'Nova Porteirinha', 'Nova Resende', 'Nova Serrana', 'Nova União', 'Novo Cruzeiro', 'Novo Oriente de Minas', 'Novorizonte', 'Olaria', "Olhos-d'Água", 'Oliveira', 'Oliveira Fortes', 'Olímpio Noronha', 'Onça de Pitangui', 'Oratórios', 'Orizânia', 'Ouro Branco', 'Ouro Fino', 'Ouro Preto', 'Ouro Verde de Minas', 'Padre Carvalho', 'Padre Paraíso', 'Pai Pedro', 'Paineiras', 'Pains', 'Paiva', 'Palma', 'Palmópolis', 'Papagaios', 'Paracatu', 'Paraguaçu', 'Paraisópolis', 'Paraopeba', 'Pará de Minas', 'Passa Quatro', 'Passa Tempo', 'Passa Vinte', 'Passabém', 'Passos', 'Patis', 'Patos de Minas', 'Patrocínio', 'Patrocínio do Muriaé', 'Paula Cândido', 'Paulistas', 'Pavão', 'Pedra Azul', 'Pedra Bonita', 'Pedra Dourada', 'Pedra do Anta', 'Pedra do Indaiá', 'Pedralva', 'Pedras de Maria da Cruz', 'Pedrinópolis', 'Pedro Leopoldo', 'Pedro Teixeira', 'Pequeri', 'Pequi', 'Perdigão', 'Perdizes', 'Perdões', 'Periquito', 'Pescador', 'Peçanha', 'Piau', 'Piedade de Caratinga', 'Piedade de Ponte Nova', 'Piedade do Rio Grande', 'Piedade dos Gerais', 'Pimenta', "Pingo d'Água", 'Pintópolis', 'Piracema', 'Pirajuba', 'Piranga', 'Piranguinho', 'Piranguçu', 'Pirapetinga', 'Pirapora', 'Piraúba', 'Pitangui', 'Piumhi', 'Planura', 'Pocrane', 'Pompéu', 'Ponte Nova', 'Ponto Chique', 'Ponto dos Volantes', 'Porteirinha', 'Porto Firme', 'Poté', 'Pouso Alegre', 'Pouso Alto', 'Poço Fundo', 'Poços de Caldas', 'Prados', 'Prata', 'Pratinha', 'Pratápolis', 'Presidente Bernardes', 'Presidente Juscelino', 'Presidente Kubitschek', 'Presidente Olegário', 'Prudente de Morais', 'Quartel Geral', 'Queluzito', 'Raposos', 'Raul Soares', 'Recreio', 'Reduto', 'Resende Costa', 'Resplendor', 'Ressaquinha', 'Riachinho', 'Riacho dos Machados', 'Ribeirão Vermelho', 'Ribeirão das Neves', 'Rio Acima', 'Rio Casca', 'Rio Doce', 'Rio Espera', 'Rio Manso', 'Rio Novo', 'Rio Paranaíba', 'Rio Pardo de Minas', 'Rio Piracicaba', 'Rio Pomba', 'Rio Preto', 'Rio Vermelho', 'Rio do Prado', 'Ritápolis', 'Rochedo de Minas', 'Rodeiro', 'Romaria', 'Rosário da Limeira', 'Rubelita', 'Rubim', 'Sabará', 'Sabinópolis', 'Sacramento', 'Salinas', 'Salto da Divisa', 'Santa Bárbara', 'Santa Bárbara do Leste', 'Santa Bárbara do Monte Verde', 'Santa Bárbara do Tugúrio', 'Santa Cruz de Minas', 'Santa Cruz de Salinas', 'Santa Cruz do Escalvado', 'Santa Efigênia de Minas', 'Santa Fé de Minas', 'Santa Helena de Minas', 'Santa Juliana', 'Santa Luzia', 'Santa Margarida', 'Santa Maria de Itabira', 'Santa Maria do Salto', 'Santa Maria do Suaçuí', 'Santa Rita de Caldas', 'Santa Rita de Ibitipoca', 'Santa Rita de Jacutinga', 'Santa Rita de Minas', 'Santa Rita do Itueto', 'Santa Rita do Sapucaí', 'Santa Rosa da Serra', 'Santa Vitória', 'Santana da Vargem', 'Santana de Cataguases', 'Santana de Pirapama', 'Santana do Deserto', 'Santana do Garambéu', 'Santana do Jacaré', 'Santana do Manhuaçu', 'Santana do Paraíso', 'Santana do Riacho', 'Santana dos Montes', 'Santo Antônio do Amparo', 'Santo Antônio do Aventureiro', 'Santo Antônio do Grama', 'Santo Antônio do Itambé', 'Santo Antônio do Jacinto', 'Santo Antônio do Monte', 'Santo Antônio do Retiro', 'Santo Antônio do Rio Abaixo', 'Santo Hipólito', 'Santos Dumont', 'Sapucaí-Mirim', 'Sardoá', 'Sarzedo', 'Sem-Peixe', 'Senador Amaral', 'Senador Cortes', 'Senador Firmino', 'Senador José Bento', 'Senador Modestino Gonçalves', 'Senhora de Oliveira', 'Senhora do Porto', 'Senhora dos Remédios', 'Sericita', 'Seritinga', 'Serra Azul de Minas', 'Serra da Saudade', 'Serra do Salitre', 'Serra dos Aimorés', 'Serrania', 'Serranos', 'Serranópolis de Minas', 'Serro', 'Sete Lagoas', 'Setubinha', 'Silveirânia', 'Silvianópolis', 'Simonésia', 'Simão Pereira', 'Sobrália', 'Soledade de Minas', 'São Bento Abade', 'São Brás do Suaçuí', 'São Domingos das Dores', 'São Domingos do Prata', 'São Francisco', 'São Francisco de Paula', 'São Francisco de Sales', 'São Francisco do Glória', 'São Félix de Minas', 'São Geraldo', 'São Geraldo da Piedade', 'São Geraldo do Baixio', 'São Gonçalo do Abaeté', 'São Gonçalo do Pará', 'São Gonçalo do Rio Abaixo', 'São Gonçalo do Rio Preto', 'São Gonçalo do Sapucaí', 'São Gotardo', 'São Joaquim de Bicas', 'São José da Barra', 'São José da Lapa', 'São José da Safira', 'São José da Varginha', 'São José do Alegre', 'São José do Divino', 'São José do Goiabal', 'São José do Jacuri', 'São José do Mantimento', 'São João Batista do Glória', 'São João Evangelista', 'São João Nepomuceno', 'São João da Lagoa', 'São João da Mata', 'São João da Ponte', 'São João das Missões', 'São João del Rei', 'São João do Manhuaçu', 'São João do Manteninha', 'São João do Oriente', 'São João do Pacuí', 'São João do Paraíso', 'São Lourenço', 'São Miguel do Anta', 'São Pedro da União', 'São Pedro do Suaçuí', 'São Pedro dos Ferros', 'São Romão', 'São Roque de Minas', 'São Sebastião da Bela Vista', 'São Sebastião da Vargem Alegre', 'São Sebastião do Anta', 'São Sebastião do Maranhão', 'São Sebastião do Oeste', 'São Sebastião do Paraíso', 'São Sebastião do Rio Preto', 'São Sebastião do Rio Verde', 'São Tiago', 'São Tomás de Aquino', 'São Tomé das Letras', 'São Vicente de Minas', 'Tabuleiro', 'Taiobeiras', 'Taparuba', 'Tapira', 'Tapiraí', 'Taquaraçu de Minas', 'Tarumirim', 'Teixeiras', 'Teófilo Otoni', 'Timóteo', 'Tiradentes', 'Tiros', 'Tocantins', 'Tocos do Moji', 'Toledo', 'Tombos', 'Três Corações', 'Três Marias', 'Três Pontas', 'Tumiritinga', 'Tupaciguara', 'Turmalina', 'Turvolândia', 'Ubaporanga', 'Ubaí', 'Uberaba', 'Uberlândia', 'Ubá', 'Umburatiba', 'Unaí', 'União de Minas', 'Uruana de Minas', 'Urucuia', 'Urucânia', 'Vargem Alegre', 'Vargem Bonita', 'Vargem Grande do Rio Pardo', 'Varginha', 'Varjão de Minas', 'Varzelândia', 'Vazante', 'Verdelândia', 'Veredinha', 'Vermelho Novo', 'Veríssimo', 'Vespasiano', 'Vieiras', 'Virgem da Lapa', 'Virginópolis', 'Virgolândia', 'Virgínia', 'Visconde do Rio Branco', 'Viçosa', 'Volta Grande', 'Várzea da Palma', 'Wenceslau Braz', 'Água Boa', 'Água Comprida', 'Águas Formosas', 'Águas Vermelhas'],
  PA: ['Abaetetuba', 'Abel Figueiredo', 'Acará', 'Afuá', 'Alenquer', 'Almeirim', 'Altamira', 'Anajás', 'Ananindeua', 'Anapu', 'Augusto Corrêa', 'Aurora do Pará', 'Aveiro', 'Bagre', 'Baião', 'Bannach', 'Barcarena', 'Belterra', 'Belém', 'Benevides', 'Bom Jesus do Tocantins', 'Bonito', 'Bragança', 'Brasil Novo', 'Brejo Grande do Araguaia', 'Breu Branco', 'Breves', 'Bujaru', 'Cachoeira do Arari', 'Cachoeira do Piriá', 'Cametá', 'Canaã dos Carajás', 'Capanema', 'Capitão Poço', 'Castanhal', 'Chaves', 'Colares', 'Conceição do Araguaia', 'Concórdia do Pará', 'Cumaru do Norte', 'Curionópolis', 'Curralinho', 'Curuá', 'Curuçá', 'Dom Eliseu', 'Eldorado do Carajás', 'Faro', 'Floresta do Araguaia', 'Garrafão do Norte', 'Goianésia do Pará', 'Gurupá', 'Igarapé-Açu', 'Igarapé-Miri', 'Inhangapi', 'Ipixuna do Pará', 'Irituia', 'Itaituba', 'Itupiranga', 'Jacareacanga', 'Jacundá', 'Juruti', 'Limoeiro do Ajuru', 'Magalhães Barata', 'Marabá', 'Maracanã', 'Marapanim', 'Marituba', 'Medicilândia', 'Melgaço', 'Mocajuba', 'Moju', 'Mojuí dos Campos', 'Monte Alegre', 'Muaná', 'Mãe do Rio', 'Nova Esperança do Piriá', 'Nova Ipixuna', 'Nova Timboteua', 'Novo Progresso', 'Novo Repartimento', 'Oeiras do Pará', 'Oriximiná', 'Ourilândia do Norte', 'Ourém', 'Pacajá', 'Palestina do Pará', 'Paragominas', 'Parauapebas', "Pau D'Arco", 'Peixe-Boi', 'Piçarra', 'Placas', 'Ponta de Pedras', 'Portel', 'Porto de Moz', 'Prainha', 'Primavera', 'Quatipuru', 'Redenção', 'Rio Maria', 'Rondon do Pará', 'Rurópolis', 'Salinópolis', 'Salvaterra', 'Santa Bárbara do Pará', 'Santa Cruz do Arari', 'Santa Izabel do Pará', 'Santa Luzia do Pará', 'Santa Maria das Barreiras', 'Santa Maria do Pará', 'Santana do Araguaia', 'Santarém', 'Santarém Novo', 'Santo Antônio do Tauá', 'Sapucaia', 'Senador José Porfírio', 'Soure', 'São Caetano de Odivelas', 'São Domingos do Araguaia', 'São Domingos do Capim', 'São Francisco do Pará', 'São Félix do Xingu', 'São Geraldo do Araguaia', 'São João da Ponta', 'São João de Pirabas', 'São João do Araguaia', 'São Miguel do Guamá', 'São Sebastião da Boa Vista', 'Tailândia', 'Terra Alta', 'Terra Santa', 'Tomé-Açu', 'Tracuateua', 'Trairão', 'Tucumã', 'Tucuruí', 'Ulianópolis', 'Uruará', 'Vigia', 'Viseu', 'Vitória do Xingu', 'Xinguara', 'Água Azul do Norte', 'Óbidos'],
  CE: ['Abaiara', 'Acarape', 'Acaraú', 'Acopiara', 'Aiuaba', 'Alcântaras', 'Altaneira', 'Alto Santo', 'Amontada', 'Antonina do Norte', 'Apuiarés', 'Aquiraz', 'Aracati', 'Aracoiaba', 'Ararendá', 'Araripe', 'Aratuba', 'Arneiroz', 'Assaré', 'Aurora', 'Baixio', 'Banabuiú', 'Barbalha', 'Barreira', 'Barro', 'Barroquinha', 'Baturité', 'Beberibe', 'Bela Cruz', 'Boa Viagem', 'Brejo Santo', 'Camocim', 'Campos Sales', 'Canindé', 'Capistrano', 'Caridade', 'Caririaçu', 'Cariré', 'Cariús', 'Carnaubal', 'Cascavel', 'Catarina', 'Catunda', 'Caucaia', 'Cedro', 'Chaval', 'Chorozinho', 'Choró', 'Coreaú', 'Crateús', 'Crato', 'Croatá', 'Cruz', 'Deputado Irapuan Pinheiro', 'Ereré', 'Eusébio', 'Farias Brito', 'Forquilha', 'Fortaleza', 'Fortim', 'Frecheirinha', 'General Sampaio', 'Granja', 'Granjeiro', 'Graça', 'Groaíras', 'Guaiúba', 'Guaraciaba do Norte', 'Guaramiranga', 'Hidrolândia', 'Horizonte', 'Ibaretama', 'Ibiapina', 'Ibicuitinga', 'Icapuí', 'Icó', 'Iguatu', 'Independência', 'Ipaporanga', 'Ipaumirim', 'Ipu', 'Ipueiras', 'Iracema', 'Irauçuba', 'Itaitinga', 'Itaiçaba', 'Itapajé', 'Itapipoca', 'Itapiúna', 'Itarema', 'Itatira', 'Jaguaretama', 'Jaguaribara', 'Jaguaribe', 'Jaguaruana', 'Jardim', 'Jati', 'Jijoca de Jericoacoara', 'Juazeiro do Norte', 'Jucás', 'Lavras da Mangabeira', 'Limoeiro do Norte', 'Madalena', 'Maracanaú', 'Maranguape', 'Marco', 'Martinópole', 'Massapê', 'Mauriti', 'Meruoca', 'Milagres', 'Milhã', 'Miraíma', 'Missão Velha', 'Mombaça', 'Monsenhor Tabosa', 'Morada Nova', 'Moraújo', 'Morrinhos', 'Mucambo', 'Mulungu', 'Nova Olinda', 'Nova Russas', 'Novo Oriente', 'Ocara', 'Orós', 'Pacajus', 'Pacatuba', 'Pacoti', 'Pacujá', 'Palhano', 'Palmácia', 'Paracuru', 'Paraipaba', 'Parambu', 'Paramoti', 'Pedra Branca', 'Penaforte', 'Pentecoste', 'Pereiro', 'Pindoretama', 'Piquet Carneiro', 'Pires Ferreira', 'Poranga', 'Porteiras', 'Potengi', 'Potiretama', 'Quiterianópolis', 'Quixadá', 'Quixelô', 'Quixeramobim', 'Quixeré', 'Redenção', 'Reriutaba', 'Russas', 'Saboeiro', 'Salitre', 'Santa Quitéria', 'Santana do Acaraú', 'Santana do Cariri', 'Senador Pompeu', 'Senador Sá', 'Sobral', 'Solonópole', 'São Benedito', 'São Gonçalo do Amarante', 'São João do Jaguaribe', 'São Luís do Curu', 'Tabuleiro do Norte', 'Tamboril', 'Tarrafas', 'Tauá', 'Tejuçuoca', 'Tianguá', 'Trairi', 'Tururu', 'Ubajara', 'Umari', 'Umirim', 'Uruburetama', 'Uruoca', 'Varjota', 'Viçosa do Ceará', 'Várzea Alegre'],
  BA: ['Abaré', 'Abaíra', 'Acajutiba', 'Adustina', 'Aiquara', 'Alagoinhas', 'Alcobaça', 'Almadina', 'Amargosa', 'Amélia Rodrigues', 'América Dourada', 'Anagé', 'Andaraí', 'Andorinha', 'Angical', 'Anguera', 'Antas', 'Antônio Cardoso', 'Antônio Gonçalves', 'Aporá', 'Apuarema', 'Aracatu', 'Araci', 'Aramari', 'Arataca', 'Aratuípe', 'Araçás', 'Aurelino Leal', 'Baianópolis', 'Baixa Grande', 'Banzaê', 'Barra', 'Barra da Estiva', 'Barra do Choça', 'Barra do Mendes', 'Barra do Rocha', 'Barreiras', 'Barro Alto', 'Barro Preto', 'Barrocas', 'Belmonte', 'Belo Campo', 'Biritinga', 'Boa Nova', 'Boa Vista do Tupim', 'Bom Jesus da Lapa', 'Bom Jesus da Serra', 'Boninal', 'Bonito', 'Boquira', 'Botuporã', 'Brejolândia', 'Brejões', 'Brotas de Macaúbas', 'Brumado', 'Buerarema', 'Buritirama', 'Caatiba', 'Cabaceiras do Paraguaçu', 'Cachoeira', 'Caculé', 'Caetanos', 'Caetité', 'Cafarnaum', 'Cairu', 'Caldeirão Grande', 'Camacan', 'Camamu', 'Camaçari', 'Campo Alegre de Lourdes', 'Campo Formoso', 'Canarana', 'Canavieiras', 'Candeal', 'Candeias', 'Candiba', 'Cansanção', 'Canudos', 'Canápolis', 'Capela do Alto Alegre', 'Capim Grosso', 'Caravelas', 'Caraíbas', 'Cardeal da Silva', 'Carinhanha', 'Casa Nova', 'Castro Alves', 'Catolândia', 'Catu', 'Caturama', 'Caém', 'Central', 'Chorrochó', 'Cipó', 'Coaraci', 'Cocos', 'Conceição da Feira', 'Conceição do Almeida', 'Conceição do Coité', 'Conceição do Jacuípe', 'Conde', 'Condeúba', 'Contendas do Sincorá', 'Coração de Maria', 'Cordeiros', 'Coribe', 'Coronel João Sá', 'Correntina', 'Cotegipe', 'Cravolândia', 'Cristópolis', 'Crisópolis', 'Cruz das Almas', 'Curaçá', 'Cândido Sales', 'Cícero Dantas', "Dias d'Ávila", 'Dom Basílio', 'Dom Macedo Costa', 'Dário Meira', 'Elísio Medrado', 'Encruzilhada', 'Entre Rios', 'Esplanada', 'Euclides da Cunha', 'Eunápolis', 'Feira da Mata', 'Feira de Santana', 'Filadélfia', 'Firmino Alves', 'Floresta Azul', 'Formosa do Rio Preto', 'Fátima', 'Gandu', 'Gavião', 'Gentio do Ouro', 'Glória', 'Gongogi', 'Governador Mangabeira', 'Guajeru', 'Guanambi', 'Guaratinga', 'Heliópolis', 'Iaçu', 'Ibiassucê', 'Ibicaraí', 'Ibicoara', 'Ibicuí', 'Ibipeba', 'Ibipitanga', 'Ibiquera', 'Ibirapitanga', 'Ibirapuã', 'Ibirataia', 'Ibitiara', 'Ibititá', 'Ibotirama', 'Ichu', 'Igaporã', 'Igrapiúna', 'Iguaí', 'Ilhéus', 'Inhambupe', 'Ipecaetá', 'Ipiaú', 'Ipirá', 'Ipupiara', 'Irajuba', 'Iramaia', 'Iraquara', 'Irará', 'Irecê', 'Itabela', 'Itaberaba', 'Itabuna', 'Itacaré', 'Itaeté', 'Itagi', 'Itagibá', 'Itagimirim', 'Itaguaçu da Bahia', 'Itaju do Colônia', 'Itajuípe', 'Itamaraju', 'Itamari', 'Itambé', 'Itanagra', 'Itanhém', 'Itaparica', 'Itapebi', 'Itapetinga', 'Itapicuru', 'Itapitanga', 'Itapé', 'Itaquara', 'Itarantim', 'Itatim', 'Itiruçu', 'Itiúba', 'Itororó', 'Ituaçu', 'Ituberá', 'Iuiu', 'Jaborandi', 'Jacaraci', 'Jacobina', 'Jaguaquara', 'Jaguarari', 'Jaguaripe', 'Jandaíra', 'Jequié', 'Jeremoabo', 'Jiquiriçá', 'Jitaúna', 'João Dourado', 'Juazeiro', 'Jucuruçu', 'Jussara', 'Jussari', 'Jussiape', 'Lafaiete Coutinho', 'Lagoa Real', 'Laje', 'Lajedinho', 'Lajedo do Tabocal', 'Lajedão', 'Lamarão', 'Lapão', 'Lauro de Freitas', 'Lençóis', 'Licínio de Almeida', 'Livramento de Nossa Senhora', 'Luís Eduardo Magalhães', 'Macajuba', 'Macarani', 'Macaúbas', 'Macururé', 'Madre de Deus', 'Maetinga', 'Maiquinique', 'Mairi', 'Malhada', 'Malhada de Pedras', 'Manoel Vitorino', 'Mansidão', 'Maracás', 'Maragogipe', 'Maraú', 'Marcionílio Souza', 'Mascote', 'Mata de São João', 'Matina', 'Medeiros Neto', 'Miguel Calmon', 'Milagres', 'Mirangaba', 'Mirante', 'Monte Santo', 'Morpará', 'Morro do Chapéu', 'Mortugaba', 'Mucugê', 'Mucuri', 'Mulungu do Morro', 'Mundo Novo', 'Muniz Ferreira', 'Muquém do São Francisco', 'Muritiba', 'Mutuípe', 'Nazaré', 'Nilo Peçanha', 'Nordestina', 'Nova Canaã', 'Nova Fátima', 'Nova Ibiá', 'Nova Itarana', 'Nova Redenção', 'Nova Soure', 'Nova Viçosa', 'Novo Horizonte', 'Novo Triunfo', 'Olindina', 'Oliveira dos Brejinhos', 'Ouriçangas', 'Ourolândia', 'Palmas de Monte Alto', 'Palmeiras', 'Paramirim', 'Paratinga', 'Paripiranga', 'Pau Brasil', 'Paulo Afonso', 'Pedro Alexandre', 'Pedrão', 'Piatã', 'Pilão Arcado', 'Pindaí', 'Pindobaçu', 'Pintadas', 'Piraí do Norte', 'Piripá', 'Piritiba', 'Planaltino', 'Planalto', 'Pojuca', 'Ponto Novo', 'Porto Seguro', 'Potiraguá', 'Poções', 'Prado', 'Presidente Dutra', 'Presidente Jânio Quadros', 'Presidente Tancredo Neves', 'Pé de Serra', 'Queimadas', 'Quijingue', 'Quixabeira', 'Rafael Jambeiro', 'Remanso', 'Retirolândia', 'Riacho de Santana', 'Riachão das Neves', 'Riachão do Jacuípe', 'Ribeira do Amparo', 'Ribeira do Pombal', 'Ribeirão do Largo', 'Rio Real', 'Rio de Contas', 'Rio do Antônio', 'Rio do Pires', 'Rodelas', 'Ruy Barbosa', 'Salinas da Margarida', 'Salvador', 'Santa Brígida', 'Santa Bárbara', 'Santa Cruz Cabrália', 'Santa Cruz da Vitória', 'Santa Inês', 'Santa Luzia', 'Santa Maria da Vitória', 'Santa Rita de Cássia', 'Santa Terezinha', 'Santaluz', 'Santana', 'Santanópolis', 'Santo Amaro', 'Santo Antônio de Jesus', 'Santo Estêvão', 'Sapeaçu', 'Saubara', 'Saúde', 'Seabra', 'Sebastião Laranjeiras', 'Senhor do Bonfim', 'Sento Sé', 'Serra Dourada', 'Serra Preta', 'Serra do Ramalho', 'Serrinha', 'Serrolândia', 'Simões Filho', 'Sobradinho', 'Souto Soares', 'Sátiro Dias', 'São Desidério', 'São Domingos', 'São Felipe', 'São Francisco do Conde', 'São Félix', 'São Félix do Coribe', 'São Gabriel', 'São Gonçalo dos Campos', 'São José da Vitória', 'São José do Jacuípe', 'São Miguel das Matas', 'São Sebastião do Passé', 'Sítio do Mato', 'Sítio do Quinto', 'Tabocas do Brejo Velho', 'Tanhaçu', 'Tanque Novo', 'Tanquinho', 'Taperoá', 'Tapiramutá', 'Teixeira de Freitas', 'Teodoro Sampaio', 'Teofilândia', 'Teolândia', 'Terra Nova', 'Tremedal', 'Tucano', 'Uauá', 'Ubaitaba', 'Ubatã', 'Ubaíra', 'Uibaí', 'Umburanas', 'Una', 'Urandi', 'Uruçuca', 'Utinga', 'Valente', 'Valença', 'Varzedo', 'Vera Cruz', 'Vereda', 'Vitória da Conquista', 'Várzea Nova', 'Várzea da Roça', 'Várzea do Poço', 'Wagner', 'Wanderley', 'Wenceslau Guimarães', 'Xique-Xique', 'Água Fria', 'Érico Cardoso'],
  PR: ['Abatiá', 'Adrianópolis', 'Agudos do Sul', 'Almirante Tamandaré', 'Altamira do Paraná', 'Alto Paraná', 'Alto Paraíso', 'Alto Piquiri', 'Altônia', 'Alvorada do Sul', 'Amaporã', 'Ampére', 'Anahy', 'Andirá', 'Antonina', 'Antônio Olinto', 'Apucarana', 'Arapongas', 'Arapoti', 'Arapuã', 'Araruna', 'Araucária', 'Ariranha do Ivaí', 'Assaí', 'Assis Chateaubriand', 'Astorga', 'Atalaia', 'Balsa Nova', 'Bandeirantes', 'Barbosa Ferraz', 'Barra do Jacaré', 'Barracão', 'Bela Vista da Caroba', 'Bela Vista do Paraíso', 'Bituruna', 'Boa Esperança', 'Boa Esperança do Iguaçu', 'Boa Ventura de São Roque', 'Boa Vista da Aparecida', 'Bocaiúva do Sul', 'Bom Jesus do Sul', 'Bom Sucesso', 'Bom Sucesso do Sul', 'Borrazópolis', 'Braganey', 'Brasilândia do Sul', 'Cafeara', 'Cafelândia', 'Cafezal do Sul', 'Califórnia', 'Cambará', 'Cambira', 'Cambé', 'Campina Grande do Sul', 'Campina da Lagoa', 'Campina do Simão', 'Campo Bonito', 'Campo Largo', 'Campo Magro', 'Campo Mourão', 'Campo do Tenente', 'Candói', 'Cantagalo', 'Capanema', 'Capitão Leônidas Marques', 'Carambeí', 'Carlópolis', 'Cascavel', 'Castro', 'Catanduvas', 'Centenário do Sul', 'Cerro Azul', 'Chopinzinho', 'Cianorte', 'Cidade Gaúcha', 'Clevelândia', 'Colombo', 'Colorado', 'Congonhinhas', 'Conselheiro Mairinck', 'Contenda', 'Corbélia', 'Cornélio Procópio', 'Coronel Domingos Soares', 'Coronel Vivida', 'Corumbataí do Sul', 'Cruz Machado', 'Cruzeiro do Iguaçu', 'Cruzeiro do Oeste', 'Cruzeiro do Sul', 'Cruzmaltina', 'Curitiba', 'Curiúva', 'Cândido de Abreu', 'Céu Azul', "Diamante D'Oeste", 'Diamante do Norte', 'Diamante do Sul', 'Dois Vizinhos', 'Douradina', 'Doutor Camargo', 'Doutor Ulysses', 'Engenheiro Beltrão', 'Entre Rios do Oeste', 'Enéas Marques', 'Esperança Nova', 'Espigão Alto do Iguaçu', 'Farol', 'Faxinal', 'Fazenda Rio Grande', 'Fernandes Pinheiro', 'Figueira', 'Flor da Serra do Sul', 'Floraí', 'Floresta', 'Florestópolis', 'Flórida', 'Formosa do Oeste', 'Foz do Iguaçu', 'Foz do Jordão', 'Francisco Alves', 'Francisco Beltrão', 'Fênix', 'General Carneiro', 'Godoy Moreira', 'Goioerê', 'Goioxim', 'Grandes Rios', 'Guairaçá', 'Guamiranga', 'Guapirama', 'Guaporema', 'Guaraci', 'Guaraniaçu', 'Guarapuava', 'Guaraqueçaba', 'Guaratuba', 'Guaíra', 'Honório Serpa', 'Ibaiti', 'Ibema', 'Ibiporã', 'Icaraíma', 'Iguaraçu', 'Iguatu', 'Imbaú', 'Imbituva', 'Inajá', 'Indianópolis', 'Inácio Martins', 'Ipiranga', 'Iporã', 'Iracema do Oeste', 'Irati', 'Iretama', 'Itaguajé', 'Itaipulândia', 'Itambaracá', 'Itambé', "Itapejara d'Oeste", 'Itaperuçu', 'Itaúna do Sul', 'Ivaiporã', 'Ivatuba', 'Ivaté', 'Ivaí', 'Jaboti', 'Jacarezinho', 'Jaguapitã', 'Jaguariaíva', 'Jandaia do Sul', 'Janiópolis', 'Japira', 'Japurá', 'Jardim Alegre', 'Jardim Olinda', 'Jataizinho', 'Jesuítas', 'Joaquim Távora', 'Jundiaí do Sul', 'Juranda', 'Jussara', 'Kaloré', 'Lapa', 'Laranjal', 'Laranjeiras do Sul', 'Leópolis', 'Lidianópolis', 'Lindoeste', 'Loanda', 'Lobato', 'Londrina', 'Luiziana', 'Lunardelli', 'Lupionópolis', 'Mallet', 'Mamborê', 'Mandaguari', 'Mandaguaçu', 'Mandirituba', 'Manfrinópolis', 'Mangueirinha', 'Manoel Ribas', 'Marechal Cândido Rondon', 'Maria Helena', 'Marialva', 'Marilena', 'Mariluz', 'Marilândia do Sul', 'Maringá', 'Maripá', 'Mariópolis', 'Marmeleiro', 'Marquinho', 'Marumbi', 'Matelândia', 'Matinhos', 'Mato Rico', 'Mauá da Serra', 'Medianeira', 'Mercedes', 'Mirador', 'Miraselva', 'Missal', 'Moreira Sales', 'Morretes', 'Munhoz de Melo', 'Nossa Senhora das Graças', 'Nova Aliança do Ivaí', 'Nova América da Colina', 'Nova Aurora', 'Nova Cantu', 'Nova Esperança', 'Nova Esperança do Sudoeste', 'Nova Fátima', 'Nova Laranjeiras', 'Nova Londrina', 'Nova Olímpia', 'Nova Prata do Iguaçu', 'Nova Santa Bárbara', 'Nova Santa Rosa', 'Nova Tebas', 'Novo Itacolomi', 'Ortigueira', 'Ourizona', 'Ouro Verde do Oeste', 'Paiçandu', 'Palmas', 'Palmeira', 'Palmital', 'Palotina', 'Paranacity', 'Paranaguá', 'Paranapoema', 'Paranavaí', 'Paraíso do Norte', 'Pato Bragado', 'Pato Branco', 'Paula Freitas', 'Paulo Frontin', 'Peabiru', 'Perobal', 'Pinhais', 'Pinhal de São Bento', 'Pinhalão', 'Pinhão', 'Piraquara', 'Piraí do Sul', 'Pitanga', 'Pitangueiras', 'Piên', 'Planaltina do Paraná', 'Planalto', 'Ponta Grossa', 'Pontal do Paraná', 'Porecatu', 'Porto Amazonas', 'Porto Barreiro', 'Porto Rico', 'Porto Vitória', 'Prado Ferreira', 'Pranchita', 'Presidente Castelo Branco', 'Primeiro de Maio', 'Prudentópolis', 'Pérola', "Pérola d'Oeste", 'Quarto Centenário', 'Quatiguá', 'Quatro Barras', 'Quatro Pontes', 'Quedas do Iguaçu', 'Querência do Norte', 'Quinta do Sol', 'Quitandinha', 'Ramilândia', 'Rancho Alegre', "Rancho Alegre D'Oeste", 'Realeza', 'Rebouças', 'Renascença', 'Reserva', 'Reserva do Iguaçu', 'Ribeirão Claro', 'Ribeirão do Pinhal', 'Rio Azul', 'Rio Bom', 'Rio Bonito do Iguaçu', 'Rio Branco do Ivaí', 'Rio Branco do Sul', 'Rio Negro', 'Rolândia', 'Roncador', 'Rondon', 'Rosário do Ivaí', 'Sabáudia', 'Salgado Filho', 'Salto do Itararé', 'Salto do Lontra', 'Santa Amélia', 'Santa Cecília do Pavão', 'Santa Cruz de Monte Castelo', 'Santa Fé', 'Santa Helena', 'Santa Inês', 'Santa Isabel do Ivaí', 'Santa Izabel do Oeste', 'Santa Lúcia', 'Santa Maria do Oeste', 'Santa Mariana', 'Santa Mônica', 'Santa Tereza do Oeste', 'Santa Terezinha de Itaipu', 'Santana do Itararé', 'Santo Antônio da Platina', 'Santo Antônio do Caiuá', 'Santo Antônio do Paraíso', 'Santo Antônio do Sudoeste', 'Santo Inácio', 'Sapopema', 'Sarandi', 'Saudade do Iguaçu', 'Sengés', 'Serranópolis do Iguaçu', 'Sertaneja', 'Sertanópolis', 'Siqueira Campos', 'Sulina', 'São Carlos do Ivaí', 'São Jerônimo da Serra', "São Jorge d'Oeste", 'São Jorge do Ivaí', 'São Jorge do Patrocínio', 'São José da Boa Vista', 'São José das Palmeiras', 'São José dos Pinhais', 'São João', 'São João do Caiuá', 'São João do Ivaí', 'São João do Triunfo', 'São Manoel do Paraná', 'São Mateus do Sul', 'São Miguel do Iguaçu', 'São Pedro do Iguaçu', 'São Pedro do Ivaí', 'São Pedro do Paraná', 'São Sebastião da Amoreira', 'São Tomé', 'Tamarana', 'Tamboara', 'Tapejara', 'Tapira', 'Teixeira Soares', 'Telêmaco Borba', 'Terra Boa', 'Terra Rica', 'Terra Roxa', 'Tibagi', 'Tijucas do Sul', 'Toledo', 'Tomazina', 'Três Barras do Paraná', 'Tunas do Paraná', 'Tuneiras do Oeste', 'Tupãssi', 'Turvo', 'Ubiratã', 'Umuarama', 'Uniflor', 'União da Vitória', 'Uraí', 'Ventania', 'Vera Cruz do Oeste', 'Verê', 'Virmond', 'Vitorino', 'Wenceslau Braz', 'Xambrê', 'Ângulo'],
  SC: ['Abdon Batista', 'Abelardo Luz', 'Agrolândia', 'Agronômica', 'Alfredo Wagner', 'Alto Bela Vista', 'Anchieta', 'Angelina', 'Anita Garibaldi', 'Anitápolis', 'Antônio Carlos', 'Apiúna', 'Arabutã', 'Araquari', 'Araranguá', 'Armazém', 'Arroio Trinta', 'Arvoredo', 'Ascurra', 'Atalanta', 'Aurora', 'Balneário Arroio do Silva', 'Balneário Barra do Sul', 'Balneário Camboriú', 'Balneário Gaivota', 'Balneário Piçarras', 'Balneário Rincão', 'Bandeirante', 'Barra Bonita', 'Barra Velha', 'Bela Vista do Toldo', 'Belmonte', 'Benedito Novo', 'Biguaçu', 'Blumenau', 'Bocaina do Sul', 'Bom Jardim da Serra', 'Bom Jesus', 'Bom Jesus do Oeste', 'Bom Retiro', 'Bombinhas', 'Botuverá', 'Braço do Norte', 'Braço do Trombudo', 'Brunópolis', 'Brusque', 'Caibi', 'Calmon', 'Camboriú', 'Campo Alegre', 'Campo Belo do Sul', 'Campo Erê', 'Campos Novos', 'Canelinha', 'Canoinhas', 'Capinzal', 'Capivari de Baixo', 'Capão Alto', 'Catanduvas', 'Caxambu do Sul', 'Caçador', 'Celso Ramos', 'Cerro Negro', 'Chapadão do Lageado', 'Chapecó', 'Cocal do Sul', 'Concórdia', 'Cordilheira Alta', 'Coronel Freitas', 'Coronel Martins', 'Correia Pinto', 'Corupá', 'Criciúma', 'Cunha Porã', 'Cunhataí', 'Curitibanos', 'Descanso', 'Dionísio Cerqueira', 'Dona Emma', 'Doutor Pedrinho', 'Entre Rios', 'Ermo', 'Erval Velho', 'Faxinal dos Guedes', 'Flor do Sertão', 'Florianópolis', 'Formosa do Sul', 'Forquilhinha', 'Fraiburgo', 'Frei Rogério', 'Galvão', 'Garopaba', 'Garuva', 'Gaspar', 'Governador Celso Ramos', 'Gravatal', 'Grão Pará', 'Guabiruba', 'Guaraciaba', 'Guaramirim', 'Guarujá do Sul', 'Guatambú', "Herval d'Oeste", 'Ibiam', 'Ibicaré', 'Ibirama', 'Ilhota', 'Imaruí', 'Imbituba', 'Imbuia', 'Indaial', 'Iomerê', 'Ipira', 'Iporã do Oeste', 'Ipuaçu', 'Ipumirim', 'Iraceminha', 'Irani', 'Irati', 'Irineópolis', 'Itaiópolis', 'Itajaí', 'Itapema', 'Itapiranga', 'Itapoá', 'Ituporanga', 'Itá', 'Içara', 'Jaborá', 'Jacinto Machado', 'Jaguaruna', 'Jaraguá do Sul', 'Jardinópolis', 'Joaçaba', 'Joinville', 'José Boiteux', 'Jupiá', 'Lacerdópolis', 'Lages', 'Laguna', 'Lajeado Grande', 'Laurentino', 'Lauro Müller', 'Lebon Régis', 'Leoberto Leal', 'Lindóia do Sul', 'Lontras', 'Luiz Alves', 'Luzerna', 'Macieira', 'Mafra', 'Major Gercino', 'Major Vieira', 'Maracajá', 'Maravilha', 'Marema', 'Massaranduba', 'Matos Costa', 'Meleiro', 'Mirim Doce', 'Modelo', 'Mondaí', 'Monte Carlo', 'Monte Castelo', 'Morro Grande', 'Morro da Fumaça', 'Navegantes', 'Nova Erechim', 'Nova Itaberaba', 'Nova Trento', 'Nova Veneza', 'Novo Horizonte', 'Orleans', 'Otacílio Costa', 'Ouro', 'Ouro Verde', 'Paial', 'Painel', 'Palhoça', 'Palma Sola', 'Palmeira', 'Palmitos', 'Papanduva', 'Paraíso', 'Passo de Torres', 'Passos Maia', 'Paulo Lopes', 'Pedras Grandes', 'Penha', 'Peritiba', 'Pescaria Brava', 'Petrolândia', 'Pinhalzinho', 'Pinheiro Preto', 'Piratuba', 'Planalto Alegre', 'Pomerode', 'Ponte Alta', 'Ponte Alta do Norte', 'Ponte Serrada', 'Porto Belo', 'Porto União', 'Pouso Redondo', 'Praia Grande', 'Presidente Castello Branco', 'Presidente Getúlio', 'Presidente Nereu', 'Princesa', 'Quilombo', 'Rancho Queimado', 'Rio Fortuna', 'Rio Negrinho', 'Rio Rufino', 'Rio das Antas', 'Rio do Campo', 'Rio do Oeste', 'Rio do Sul', 'Rio dos Cedros', 'Riqueza', 'Rodeio', 'Romelândia', 'Salete', 'Saltinho', 'Salto Veloso', 'Sangão', 'Santa Cecília', 'Santa Helena', 'Santa Rosa de Lima', 'Santa Rosa do Sul', 'Santa Terezinha', 'Santa Terezinha do Progresso', 'Santiago do Sul', 'Santo Amaro da Imperatriz', 'Saudades', 'Schroeder', 'Seara', 'Serra Alta', 'Siderópolis', 'Sombrio', 'Sul Brasil', 'São Bento do Sul', 'São Bernardino', 'São Bonifácio', 'São Carlos', 'São Cristóvão do Sul', 'São Domingos', 'São Francisco do Sul', 'São Joaquim', 'São José', 'São José do Cedro', 'São José do Cerrito', 'São João Batista', 'São João do Itaperiú', 'São João do Oeste', 'São João do Sul', 'São Lourenço do Oeste', 'São Ludgero', 'São Martinho', 'São Miguel da Boa Vista', 'São Miguel do Oeste', 'São Pedro de Alcântara', 'Taió', 'Tangará', 'Tigrinhos', 'Tijucas', 'Timbé do Sul', 'Timbó', 'Timbó Grande', 'Treviso', 'Treze Tílias', 'Treze de Maio', 'Trombudo Central', 'Três Barras', 'Tubarão', 'Tunápolis', 'Turvo', 'União do Oeste', 'Urubici', 'Urupema', 'Urussanga', 'Vargem', 'Vargem Bonita', 'Vargeão', 'Vidal Ramos', 'Videira', 'Vitor Meireles', 'Witmarsum', 'Xanxerê', 'Xavantina', 'Xaxim', 'Zortéa', 'Água Doce', 'Águas Frias', 'Águas Mornas', 'Águas de Chapecó'],
  PE: ['Abreu e Lima', 'Afogados da Ingazeira', 'Afrânio', 'Agrestina', 'Alagoinha', 'Aliança', 'Altinho', 'Amaraji', 'Angelim', 'Araripina', 'Araçoiaba', 'Arcoverde', 'Barra de Guabiraba', 'Barreiros', 'Belo Jardim', 'Belém de Maria', 'Belém do São Francisco', 'Betânia', 'Bezerros', 'Bodocó', 'Bom Conselho', 'Bom Jardim', 'Bonito', 'Brejinho', 'Brejo da Madre de Deus', 'Brejão', 'Buenos Aires', 'Buíque', 'Cabo de Santo Agostinho', 'Cabrobó', 'Cachoeirinha', 'Caetés', 'Calumbi', 'Calçado', 'Camaragibe', 'Camocim de São Félix', 'Camutanga', 'Canhotinho', 'Capoeiras', 'Carnaubeira da Penha', 'Carnaíba', 'Carpina', 'Caruaru', 'Casinhas', 'Catende', 'Cedro', 'Chã Grande', 'Chã de Alegria', 'Condado', 'Correntes', 'Cortês', 'Cumaru', 'Cupira', 'Custódia', 'Dormentes', 'Escada', 'Exu', 'Feira Nova', 'Fernando de Noronha', 'Ferreiros', 'Flores', 'Floresta', 'Frei Miguelinho', 'Gameleira', 'Garanhuns', 'Glória do Goitá', 'Goiana', 'Granito', 'Gravatá', 'Iati', 'Ibimirim', 'Ibirajuba', 'Igarassu', 'Iguaracy', 'Ilha de Itamaracá', 'Inajá', 'Ingazeira', 'Ipojuca', 'Ipubi', 'Itacuruba', 'Itambé', 'Itapetim', 'Itapissuma', 'Itaquitinga', 'Itaíba', 'Jaboatão dos Guararapes', 'Jaqueira', 'Jataúba', 'Jatobá', 'Joaquim Nabuco', 'João Alfredo', 'Jucati', 'Jupi', 'Jurema', 'Lagoa Grande', 'Lagoa de Itaenga', 'Lagoa do Carro', 'Lagoa do Ouro', 'Lagoa dos Gatos', 'Lajedo', 'Limoeiro', 'Macaparana', 'Machados', 'Manari', 'Maraial', 'Mirandiba', 'Moreilândia', 'Moreno', 'Nazaré da Mata', 'Olinda', 'Orobó', 'Orocó', 'Ouricuri', 'Palmares', 'Palmeirina', 'Panelas', 'Paranatama', 'Parnamirim', 'Passira', 'Paudalho', 'Paulista', 'Pedra', 'Pesqueira', 'Petrolina', 'Petrolândia', 'Pombos', 'Poção', 'Primavera', 'Quipapá', 'Quixaba', 'Recife', 'Riacho das Almas', 'Ribeirão', 'Rio Formoso', 'Sairé', 'Salgadinho', 'Salgueiro', 'Saloá', 'Sanharó', 'Santa Cruz', 'Santa Cruz da Baixa Verde', 'Santa Cruz do Capibaribe', 'Santa Filomena', 'Santa Maria da Boa Vista', 'Santa Maria do Cambucá', 'Santa Terezinha', 'Serra Talhada', 'Serrita', 'Sertânia', 'Sirinhaém', 'Solidão', 'Surubim', 'São Benedito do Sul', 'São Bento do Una', 'São Caitano', 'São Joaquim do Monte', 'São José da Coroa Grande', 'São José do Belmonte', 'São José do Egito', 'São João', 'São Lourenço da Mata', 'São Vicente Férrer', 'Tabira', 'Tacaimbó', 'Tacaratu', 'Tamandaré', 'Taquaritinga do Norte', 'Terezinha', 'Terra Nova', 'Timbaúba', 'Toritama', 'Tracunhaém', 'Trindade', 'Triunfo', 'Tupanatinga', 'Tuparetama', 'Venturosa', 'Verdejante', 'Vertente do Lério', 'Vertentes', 'Vicência', 'Vitória de Santo Antão', 'Xexéu', 'Água Preta', 'Águas Belas'],
  TO: ['Abreulândia', 'Aguiarnópolis', 'Aliança do Tocantins', 'Almas', 'Alvorada', 'Ananás', 'Angico', 'Aparecida do Rio Negro', 'Aragominas', 'Araguacema', 'Araguanã', 'Araguatins', 'Araguaçu', 'Araguaína', 'Arapoema', 'Arraias', 'Augustinópolis', 'Aurora do Tocantins', 'Axixá do Tocantins', 'Babaçulândia', 'Bandeirantes do Tocantins', 'Barra do Ouro', 'Barrolândia', 'Bernardo Sayão', 'Bom Jesus do Tocantins', 'Brasilândia do Tocantins', 'Brejinho de Nazaré', 'Buriti do Tocantins', 'Cachoeirinha', 'Campos Lindos', 'Cariri do Tocantins', 'Carmolândia', 'Carrasco Bonito', 'Caseara', 'Centenário', 'Chapada da Natividade', 'Chapada de Areia', 'Colinas do Tocantins', 'Colméia', 'Combinado', 'Conceição do Tocantins', 'Couto Magalhães', 'Cristalândia', 'Crixás do Tocantins', 'Darcinópolis', 'Dianópolis', 'Divinópolis do Tocantins', 'Dois Irmãos do Tocantins', 'Dueré', 'Esperantina', 'Figueirópolis', 'Filadélfia', 'Formoso do Araguaia', 'Fátima', 'Goianorte', 'Goiatins', 'Guaraí', 'Gurupi', 'Ipueiras', 'Itacajá', 'Itaguatins', 'Itapiratins', 'Itaporã do Tocantins', 'Jaú do Tocantins', 'Juarina', 'Lagoa da Confusão', 'Lagoa do Tocantins', 'Lajeado', 'Lavandeira', 'Lizarda', 'Luzinópolis', 'Marianópolis do Tocantins', 'Mateiros', 'Maurilândia do Tocantins', 'Miracema do Tocantins', 'Miranorte', 'Monte Santo do Tocantins', 'Monte do Carmo', 'Muricilândia', 'Natividade', 'Nazaré', 'Nova Olinda', 'Nova Rosalândia', 'Novo Acordo', 'Novo Alegre', 'Novo Jardim', 'Oliveira de Fátima', 'Palmas', 'Palmeirante', 'Palmeiras do Tocantins', 'Palmeirópolis', 'Paranã', 'Paraíso do Tocantins', "Pau D'Arco", 'Pedro Afonso', 'Peixe', 'Pequizeiro', 'Pindorama do Tocantins', 'Piraquê', 'Pium', 'Ponte Alta do Bom Jesus', 'Ponte Alta do Tocantins', 'Porto Alegre do Tocantins', 'Porto Nacional', 'Praia Norte', 'Presidente Kennedy', 'Pugmil', 'Recursolândia', 'Riachinho', 'Rio Sono', 'Rio da Conceição', 'Rio dos Bois', 'Sampaio', 'Sandolândia', 'Santa Fé do Araguaia', 'Santa Maria do Tocantins', 'Santa Rita do Tocantins', 'Santa Rosa do Tocantins', 'Santa Tereza do Tocantins', 'Santa Terezinha do Tocantins', 'Silvanópolis', 'Sucupira', 'São Bento do Tocantins', 'São Félix do Tocantins', 'São Miguel do Tocantins', 'São Salvador do Tocantins', 'São Sebastião do Tocantins', 'São Valério', 'Sítio Novo do Tocantins', 'Tabocão', 'Taguatinga', 'Taipas do Tocantins', 'Talismã', 'Tocantinópolis', 'Tocantínia', 'Tupirama', 'Tupiratins', 'Wanderlândia', 'Xambioá'],
  RN: ['Acari', 'Afonso Bezerra', 'Alexandria', 'Almino Afonso', 'Alto do Rodrigues', 'Angicos', 'Antônio Martins', 'Apodi', 'Areia Branca', 'Arês', 'Açu', 'Baraúna', 'Barcelona', 'Baía Formosa', 'Bento Fernandes', 'Bodó', 'Bom Jesus', 'Brejinho', 'Caicó', 'Caiçara do Norte', 'Caiçara do Rio do Vento', 'Campo Grande', 'Campo Redondo', 'Canguaretama', 'Caraúbas', 'Carnaubais', 'Carnaúba dos Dantas', 'Ceará-Mirim', 'Cerro Corá', 'Coronel Ezequiel', 'Coronel João Pessoa', 'Cruzeta', 'Currais Novos', 'Doutor Severiano', 'Encanto', 'Equador', 'Espírito Santo', 'Extremoz', 'Felipe Guerra', 'Fernando Pedroza', 'Florânia', 'Francisco Dantas', 'Frutuoso Gomes', 'Galinhos', 'Goianinha', 'Governador Dix-Sept Rosado', 'Grossos', 'Guamaré', 'Ielmo Marinho', 'Ipanguaçu', 'Ipueira', 'Itajá', 'Itaú', 'Jandaíra', 'Janduís', 'Januário Cicco', 'Japi', 'Jardim de Angicos', 'Jardim de Piranhas', 'Jardim do Seridó', 'Jaçanã', 'José da Penha', 'João Câmara', 'João Dias', 'Jucurutu', 'Jundiá', 'Lagoa Nova', 'Lagoa Salgada', "Lagoa d'Anta", 'Lagoa de Pedras', 'Lagoa de Velhos', 'Lajes', 'Lajes Pintadas', 'Lucrécia', 'Luís Gomes', 'Macau', 'Macaíba', 'Major Sales', 'Marcelino Vieira', 'Martins', 'Maxaranguape', 'Messias Targino', 'Montanhas', 'Monte Alegre', 'Monte das Gameleiras', 'Mossoró', 'Natal', 'Nova Cruz', 'Nísia Floresta', "Olho d'Água do Borges", 'Ouro Branco', 'Paraná', 'Parazinho', 'Paraú', 'Parelhas', 'Parnamirim', 'Passa e Fica', 'Passagem', 'Patu', 'Pau dos Ferros', 'Pedra Grande', 'Pedra Preta', 'Pedro Avelino', 'Pedro Velho', 'Pendências', 'Pilões', 'Portalegre', 'Porto do Mangue', 'Poço Branco', 'Pureza', 'Rafael Fernandes', 'Rafael Godeiro', 'Riacho da Cruz', 'Riacho de Santana', 'Riachuelo', 'Rio do Fogo', 'Rodolfo Fernandes', 'Ruy Barbosa', 'Santa Cruz', 'Santa Maria', 'Santana do Matos', 'Santana do Seridó', 'Santo Antônio', 'Senador Elói de Souza', 'Senador Georgino Avelino', 'Serra Caiada', 'Serra Negra do Norte', 'Serra de São Bento', 'Serra do Mel', 'Serrinha', 'Serrinha dos Pintos', 'Severiano Melo', 'São Bento do Norte', 'São Bento do Trairí', 'São Fernando', 'São Francisco do Oeste', 'São Gonçalo do Amarante', 'São José de Mipibu', 'São José do Campestre', 'São José do Seridó', 'São João do Sabugi', 'São Miguel', 'São Miguel do Gostoso', 'São Paulo do Potengi', 'São Pedro', 'São Rafael', 'São Tomé', 'São Vicente', 'Sítio Novo', 'Taboleiro Grande', 'Taipu', 'Tangará', 'Tenente Ananias', 'Tenente Laurentino Cruz', 'Tibau', 'Tibau do Sul', 'Timbaúba dos Batistas', 'Touros', 'Triunfo Potiguar', 'Umarizal', 'Upanema', 'Venha-Ver', 'Vera Cruz', 'Vila Flor', 'Viçosa', 'Várzea', 'Água Nova'],
  PI: ['Acauã', 'Agricolândia', 'Alagoinha do Piauí', 'Alegrete do Piauí', 'Alto Longá', 'Altos', 'Alvorada do Gurguéia', 'Amarante', 'Angical do Piauí', 'Antônio Almeida', 'Anísio de Abreu', 'Aroazes', 'Aroeiras do Itaim', 'Arraial', 'Assunção do Piauí', 'Avelino Lopes', 'Baixa Grande do Ribeiro', "Barra D'Alcântara", 'Barras', 'Barreiras do Piauí', 'Barro Duro', 'Batalha', 'Bela Vista do Piauí', 'Belém do Piauí', 'Beneditinos', 'Bertolínia', 'Betânia do Piauí', 'Boa Hora', 'Bocaina', 'Bom Jesus', 'Bom Princípio do Piauí', 'Bonfim do Piauí', 'Boqueirão do Piauí', 'Brasileira', 'Brejo do Piauí', 'Buriti dos Lopes', 'Buriti dos Montes', 'Cabeceiras do Piauí', 'Cajazeiras do Piauí', 'Cajueiro da Praia', 'Caldeirão Grande do Piauí', 'Campinas do Piauí', 'Campo Alegre do Fidalgo', 'Campo Grande do Piauí', 'Campo Largo do Piauí', 'Campo Maior', 'Canavieira', 'Canto do Buriti', 'Capitão Gervásio Oliveira', 'Capitão de Campos', 'Caracol', 'Caraúbas do Piauí', 'Caridade do Piauí', 'Castelo do Piauí', 'Caxingó', 'Cocal', 'Cocal de Telha', 'Cocal dos Alves', 'Coivaras', 'Colônia do Gurguéia', 'Colônia do Piauí', 'Conceição do Canindé', 'Coronel José Dias', 'Corrente', 'Cristalândia do Piauí', 'Cristino Castro', 'Curimatá', 'Currais', 'Curral Novo do Piauí', 'Curralinhos', 'Demerval Lobão', 'Dirceu Arcoverde', 'Dom Expedito Lopes', 'Dom Inocêncio', 'Domingos Mourão', 'Elesbão Veloso', 'Eliseu Martins', 'Esperantina', 'Fartura do Piauí', 'Flores do Piauí', 'Floresta do Piauí', 'Floriano', 'Francinópolis', 'Francisco Ayres', 'Francisco Macedo', 'Francisco Santos', 'Fronteiras', 'Geminiano', 'Gilbués', 'Guadalupe', 'Guaribas', 'Hugo Napoleão', 'Ilha Grande', 'Inhuma', 'Ipiranga do Piauí', 'Isaías Coelho', 'Itainópolis', 'Itaueira', 'Jacobina do Piauí', 'Jaicós', 'Jardim do Mulato', 'Jatobá do Piauí', 'Jerumenha', 'Joaquim Pires', 'Joca Marques', 'José de Freitas', 'João Costa', 'Juazeiro do Piauí', 'Jurema', 'Júlio Borges', 'Lagoa Alegre', 'Lagoa de São Francisco', 'Lagoa do Barro do Piauí', 'Lagoa do Piauí', 'Lagoa do Sítio', 'Lagoinha do Piauí', 'Landri Sales', 'Luzilândia', 'Luís Correia', 'Madeiro', 'Manoel Emídio', 'Marcolândia', 'Marcos Parente', 'Massapê do Piauí', 'Matias Olímpio', 'Miguel Alves', 'Miguel Leão', 'Milton Brandão', 'Monsenhor Gil', 'Monsenhor Hipólito', 'Monte Alegre do Piauí', 'Morro Cabeça no Tempo', 'Morro do Chapéu do Piauí', 'Murici dos Portelas', 'Nazaré do Piauí', 'Nazária', 'Nossa Senhora de Nazaré', 'Nossa Senhora dos Remédios', 'Nova Santa Rita', 'Novo Oriente do Piauí', 'Novo Santo Antônio', 'Oeiras', "Olho D'Água do Piauí", 'Padre Marcos', 'Paes Landim', 'Pajeú do Piauí', 'Palmeira do Piauí', 'Palmeirais', 'Paquetá', 'Parnaguá', 'Parnaíba', 'Passagem Franca do Piauí', 'Patos do Piauí', "Pau D'Arco do Piauí", 'Paulistana', 'Pavussu', 'Pedro II', 'Pedro Laurentino', 'Picos', 'Pimenteiras', 'Pio IX', 'Piracuruca', 'Piripiri', 'Porto', 'Porto Alegre do Piauí', 'Prata do Piauí', 'Queimada Nova', 'Redenção do Gurguéia', 'Regeneração', 'Riacho Frio', 'Ribeira do Piauí', 'Ribeiro Gonçalves', 'Rio Grande do Piauí', 'Santa Cruz do Piauí', 'Santa Cruz dos Milagres', 'Santa Filomena', 'Santa Luz', 'Santa Rosa do Piauí', 'Santana do Piauí', 'Santo Antônio de Lisboa', 'Santo Antônio dos Milagres', 'Santo Inácio do Piauí', 'Sebastião Barros', 'Sebastião Leal', 'Sigefredo Pacheco', 'Simplício Mendes', 'Simões', 'Socorro do Piauí', 'Sussuapara', 'São Braz do Piauí', 'São Francisco de Assis do Piauí', 'São Francisco do Piauí', 'São Félix do Piauí', 'São Gonçalo do Gurguéia', 'São Gonçalo do Piauí', 'São José do Divino', 'São José do Peixe', 'São José do Piauí', 'São João da Canabrava', 'São João da Fronteira', 'São João da Serra', 'São João da Varjota', 'São João do Arraial', 'São João do Piauí', 'São Julião', 'São Lourenço do Piauí', 'São Luis do Piauí', 'São Miguel da Baixa Grande', 'São Miguel do Fidalgo', 'São Miguel do Tapuio', 'São Pedro do Piauí', 'São Raimundo Nonato', 'Tamboril do Piauí', 'Tanque do Piauí', 'Teresina', 'União', 'Uruçuí', 'Valença do Piauí', 'Vera Mendes', 'Vila Nova do Piauí', 'Várzea Branca', 'Várzea Grande', 'Wall Ferraz', 'Água Branca'],
  RS: ['Aceguá', 'Agudo', 'Ajuricaba', 'Alecrim', 'Alegrete', 'Alegria', 'Almirante Tamandaré do Sul', 'Alpestre', 'Alto Alegre', 'Alto Feliz', 'Alvorada', 'Amaral Ferrador', 'Ametista do Sul', 'André da Rocha', 'Anta Gorda', 'Antônio Prado', 'Arambaré', 'Araricá', 'Aratiba', 'Arroio Grande', 'Arroio do Meio', 'Arroio do Padre', 'Arroio do Sal', 'Arroio do Tigre', 'Arroio dos Ratos', 'Arvorezinha', 'Augusto Pestana', 'Bagé', 'Balneário Pinhal', 'Barra Funda', 'Barra do Guarita', 'Barra do Quaraí', 'Barra do Ribeiro', 'Barra do Rio Azul', 'Barracão', 'Barros Cassal', 'Barão', 'Barão de Cotegipe', 'Barão do Triunfo', 'Benjamin Constant do Sul', 'Bento Gonçalves', 'Boa Vista das Missões', 'Boa Vista do Buricá', 'Boa Vista do Cadeado', 'Boa Vista do Incra', 'Boa Vista do Sul', 'Bom Jesus', 'Bom Princípio', 'Bom Progresso', 'Bom Retiro do Sul', 'Boqueirão do Leão', 'Bossoroca', 'Bozano', 'Braga', 'Brochier', 'Butiá', 'Cacequi', 'Cachoeira do Sul', 'Cachoeirinha', 'Cacique Doble', 'Caibaté', 'Caiçara', 'Camaquã', 'Camargo', 'Cambará do Sul', 'Campestre da Serra', 'Campina das Missões', 'Campinas do Sul', 'Campo Bom', 'Campo Novo', 'Campos Borges', 'Candelária', 'Candiota', 'Canela', 'Canguçu', 'Canoas', 'Canudos do Vale', 'Capela de Santana', 'Capitão', 'Capivari do Sul', 'Capão Bonito do Sul', 'Capão da Canoa', 'Capão do Cipó', 'Capão do Leão', 'Carazinho', 'Caraá', 'Carlos Barbosa', 'Carlos Gomes', 'Casca', 'Caseiros', 'Catuípe', 'Caxias do Sul', 'Caçapava do Sul', 'Centenário', 'Cerrito', 'Cerro Branco', 'Cerro Grande', 'Cerro Grande do Sul', 'Cerro Largo', 'Chapada', 'Charqueadas', 'Charrua', 'Chiapetta', 'Chuvisca', 'Chuí', 'Cidreira', 'Ciríaco', 'Colinas', 'Colorado', 'Condor', 'Constantina', 'Coqueiro Baixo', 'Coqueiros do Sul', 'Coronel Barros', 'Coronel Bicaco', 'Coronel Pilar', 'Cotiporã', 'Coxilha', 'Crissiumal', 'Cristal', 'Cristal do Sul', 'Cruz Alta', 'Cruzaltense', 'Cruzeiro do Sul', 'Cândido Godói', 'David Canabarro', 'Derrubadas', 'Dezesseis de Novembro', 'Dilermando de Aguiar', 'Dois Irmãos', 'Dois Irmãos das Missões', 'Dois Lajeados', 'Dom Feliciano', 'Dom Pedrito', 'Dom Pedro de Alcântara', 'Dona Francisca', 'Doutor Maurício Cardoso', 'Doutor Ricardo', 'Eldorado do Sul', 'Encantado', 'Encruzilhada do Sul', 'Engenho Velho', 'Entre Rios do Sul', 'Entre-Ijuís', 'Erebango', 'Erechim', 'Ernestina', 'Erval Grande', 'Erval Seco', 'Esmeralda', 'Esperança do Sul', 'Espumoso', 'Estação', 'Esteio', 'Estrela', 'Estrela Velha', 'Estância Velha', 'Eugênio de Castro', 'Fagundes Varela', 'Farroupilha', 'Faxinal do Soturno', 'Faxinalzinho', 'Fazenda Vilanova', 'Feliz', 'Flores da Cunha', 'Floriano Peixoto', 'Fontoura Xavier', 'Formigueiro', 'Forquetinha', 'Fortaleza dos Valos', 'Frederico Westphalen', 'Garibaldi', 'Garruchos', 'Gaurama', 'General Câmara', 'Gentil', 'Getúlio Vargas', 'Giruá', 'Glorinha', 'Gramado', 'Gramado Xavier', 'Gramado dos Loureiros', 'Gravataí', 'Guabiju', 'Guaporé', 'Guarani das Missões', 'Guaíba', 'Harmonia', 'Herval', 'Herveiras', 'Horizontina', 'Hulha Negra', 'Humaitá', 'Ibarama', 'Ibiaçá', 'Ibiraiaras', 'Ibirapuitã', 'Ibirubá', 'Igrejinha', 'Ijuí', 'Ilópolis', 'Imbé', 'Imigrante', 'Independência', 'Inhacorá', 'Ipiranga do Sul', 'Ipê', 'Iraí', 'Itaara', 'Itacurubi', 'Itapuca', 'Itaqui', 'Itati', 'Itatiba do Sul', 'Ivorá', 'Ivoti', 'Jaboticaba', 'Jacuizinho', 'Jacutinga', 'Jaguari', 'Jaguarão', 'Jaquirana', 'Jari', 'Jóia', 'Júlio de Castilhos', 'Lagoa Bonita do Sul', 'Lagoa Vermelha', 'Lagoa dos Três Cantos', 'Lagoão', 'Lajeado', 'Lajeado do Bugre', 'Lavras do Sul', 'Liberato Salzano', 'Lindolfo Collor', 'Linha Nova', 'Machadinho', 'Mampituba', 'Manoel Viana', 'Maquiné', 'Maratá', 'Marau', 'Marcelino Ramos', 'Mariana Pimentel', 'Mariano Moro', 'Marques de Souza', 'Mata', 'Mato Castelhano', 'Mato Leitão', 'Mato Queimado', 'Maximiliano de Almeida', 'Maçambará', 'Minas do Leão', 'Miraguaí', 'Montauri', 'Monte Alegre dos Campos', 'Monte Belo do Sul', 'Montenegro', 'Mormaço', 'Morrinhos do Sul', 'Morro Redondo', 'Morro Reuter', 'Mostardas', 'Muitos Capões', 'Muliterno', 'Muçum', 'Nicolau Vergueiro', 'Nonoai', 'Nova Alvorada', 'Nova Araçá', 'Nova Bassano', 'Nova Boa Vista', 'Nova Bréscia', 'Nova Candelária', 'Nova Esperança do Sul', 'Nova Hartz', 'Nova Palma', 'Nova Petrópolis', 'Nova Prata', 'Nova Pádua', 'Nova Ramada', 'Nova Roma do Sul', 'Nova Santa Rita', 'Novo Barreiro', 'Novo Cabrais', 'Novo Hamburgo', 'Novo Machado', 'Novo Tiradentes', 'Novo Xingu', 'Não-Me-Toque', 'Osório', 'Paim Filho', 'Palmares do Sul', 'Palmeira das Missões', 'Palmitinho', 'Panambi', 'Pantano Grande', 'Paraí', 'Paraíso do Sul', 'Pareci Novo', 'Parobé', 'Passa Sete', 'Passo Fundo', 'Passo do Sobrado', 'Paulo Bento', 'Paverama', 'Pedras Altas', 'Pedro Osório', 'Pejuçara', 'Pelotas', 'Picada Café', 'Pinhal', 'Pinhal Grande', 'Pinhal da Serra', 'Pinheirinho do Vale', 'Pinheiro Machado', 'Pinto Bandeira', 'Pirapó', 'Piratini', 'Planalto', 'Ponte Preta', 'Pontão', 'Porto Alegre', 'Porto Lucena', 'Porto Mauá', 'Porto Vera Cruz', 'Porto Xavier', 'Portão', 'Pouso Novo', 'Poço das Antas', 'Presidente Lucena', 'Progresso', 'Protásio Alves', 'Putinga', 'Quaraí', 'Quatro Irmãos', 'Quevedos', 'Quinze de Novembro', 'Redentora', 'Relvado', 'Restinga Sêca', 'Rio Grande', 'Rio Pardo', 'Rio dos Índios', 'Riozinho', 'Roca Sales', 'Rodeio Bonito', 'Rolador', 'Rolante', 'Ronda Alta', 'Rondinha', 'Roque Gonzales', 'Rosário do Sul', 'Sagrada Família', 'Saldanha Marinho', 'Salto do Jacuí', 'Salvador das Missões', 'Salvador do Sul', 'Sananduva', "Sant'Ana do Livramento", 'Santa Bárbara do Sul', 'Santa Cecília do Sul', 'Santa Clara do Sul', 'Santa Cruz do Sul', 'Santa Margarida do Sul', 'Santa Maria', 'Santa Maria do Herval', 'Santa Rosa', 'Santa Tereza', 'Santa Vitória do Palmar', 'Santana da Boa Vista', 'Santiago', 'Santo Antônio da Patrulha', 'Santo Antônio das Missões', 'Santo Antônio do Palma', 'Santo Antônio do Planalto', 'Santo Augusto', 'Santo Cristo', 'Santo Expedito do Sul', 'Santo Ângelo', 'Sapiranga', 'Sapucaia do Sul', 'Sarandi', 'Seberi', 'Sede Nova', 'Segredo', 'Selbach', 'Senador Salgado Filho', 'Sentinela do Sul', 'Serafina Corrêa', 'Sertão', 'Sertão Santana', 'Sete de Setembro', 'Severiano de Almeida', 'Silveira Martins', 'Sinimbu', 'Sobradinho', 'Soledade', 'São Borja', 'São Domingos do Sul', 'São Francisco de Assis', 'São Francisco de Paula', 'São Gabriel', 'São Jerônimo', 'São Jorge', 'São José das Missões', 'São José do Herval', 'São José do Hortêncio', 'São José do Inhacorá', 'São José do Norte', 'São José do Ouro', 'São José do Sul', 'São José dos Ausentes', 'São João da Urtiga', 'São João do Polêsine', 'São Leopoldo', 'São Lourenço do Sul', 'São Luiz Gonzaga', 'São Marcos', 'São Martinho', 'São Martinho da Serra', 'São Miguel das Missões', 'São Nicolau', 'São Paulo das Missões', 'São Pedro da Serra', 'São Pedro das Missões', 'São Pedro do Butiá', 'São Pedro do Sul', 'São Sebastião do Caí', 'São Sepé', 'São Valentim', 'São Valentim do Sul', 'São Valério do Sul', 'São Vendelino', 'São Vicente do Sul', 'Sério', 'Tabaí', 'Tapejara', 'Tapera', 'Tapes', 'Taquara', 'Taquari', 'Taquaruçu do Sul', 'Tavares', 'Tenente Portela', 'Terra de Areia', 'Teutônia', 'Tio Hugo', 'Tiradentes do Sul', 'Toropi', 'Torres', 'Tramandaí', 'Travesseiro', 'Trindade do Sul', 'Triunfo', 'Três Arroios', 'Três Cachoeiras', 'Três Coroas', 'Três Forquilhas', 'Três Palmeiras', 'Três Passos', 'Três de Maio', 'Tucunduva', 'Tunas', 'Tupanci do Sul', 'Tupanciretã', 'Tupandi', 'Tuparendi', 'Turuçu', 'Ubiretama', 'Unistalda', 'União da Serra', 'Uruguaiana', 'Vacaria', 'Vale Real', 'Vale Verde', 'Vale do Sol', 'Vanini', 'Venâncio Aires', 'Vera Cruz', 'Veranópolis', 'Vespasiano Corrêa', 'Viadutos', 'Viamão', 'Vicente Dutra', 'Victor Graeff', 'Vila Flores', 'Vila Lângaro', 'Vila Maria', 'Vila Nova do Sul', 'Vista Alegre', 'Vista Alegre do Prata', 'Vista Gaúcha', 'Vitória das Missões', 'Westfália', 'Xangri-lá', 'Água Santa', 'Áurea'],
  MT: ['Acorizal', 'Alta Floresta', 'Alto Araguaia', 'Alto Boa Vista', 'Alto Garças', 'Alto Paraguai', 'Alto Taquari', 'Apiacás', 'Araguaiana', 'Araguainha', 'Araputanga', 'Arenápolis', 'Aripuanã', 'Barra do Bugres', 'Barra do Garças', 'Barão de Melgaço', 'Bom Jesus do Araguaia', 'Brasnorte', 'Campinápolis', 'Campo Novo do Parecis', 'Campo Verde', 'Campos de Júlio', 'Canabrava do Norte', 'Canarana', 'Carlinda', 'Castanheira', 'Chapada dos Guimarães', 'Cláudia', 'Cocalinho', 'Colniza', 'Colíder', 'Comodoro', 'Confresa', "Conquista D'Oeste", 'Cotriguaçu', 'Cuiabá', 'Curvelândia', 'Cáceres', 'Denise', 'Diamantino', 'Dom Aquino', 'Feliz Natal', "Figueirópolis D'Oeste", 'Gaúcha do Norte', 'General Carneiro', "Glória D'Oeste", 'Guarantã do Norte', 'Guiratinga', 'Indiavaí', 'Ipiranga do Norte', 'Itanhangá', 'Itaúba', 'Itiquira', 'Jaciara', 'Jangada', 'Jauru', 'Juara', 'Juruena', 'Juscimeira', 'Juína', "Lambari D'Oeste", 'Lucas do Rio Verde', 'Luciara', 'Marcelândia', 'Matupá', "Mirassol d'Oeste", 'Nobres', 'Nortelândia', 'Nossa Senhora do Livramento', 'Nova Bandeirantes', 'Nova Brasilândia', 'Nova Canaã do Norte', 'Nova Guarita', 'Nova Lacerda', 'Nova Marilândia', 'Nova Maringá', 'Nova Monte Verde', 'Nova Mutum', 'Nova Nazaré', 'Nova Olímpia', 'Nova Santa Helena', 'Nova Ubiratã', 'Nova Xavantina', 'Novo Horizonte do Norte', 'Novo Mundo', 'Novo Santo Antônio', 'Novo São Joaquim', 'Paranatinga', 'Paranaíta', 'Pedra Preta', 'Peixoto de Azevedo', 'Planalto da Serra', 'Poconé', 'Pontal do Araguaia', 'Ponte Branca', 'Pontes e Lacerda', 'Porto Alegre do Norte', 'Porto Esperidião', 'Porto Estrela', 'Porto dos Gaúchos', 'Poxoréu', 'Primavera do Leste', 'Querência', 'Reserva do Cabaçal', 'Ribeirão Cascalheira', 'Ribeirãozinho', 'Rio Branco', 'Rondolândia', 'Rondonópolis', 'Rosário Oeste', 'Salto do Céu', 'Santa Carmem', 'Santa Cruz do Xingu', 'Santa Rita do Trivelato', 'Santa Terezinha', 'Santo Afonso', 'Santo Antônio do Leste', 'Santo Antônio do Leverger', 'Sapezal', 'Serra Nova Dourada', 'Sinop', 'Sorriso', 'São Félix do Araguaia', 'São José do Povo', 'São José do Rio Claro', 'São José do Xingu', 'São José dos Quatro Marcos', 'São Pedro da Cipa', 'Tabaporã', 'Tangará da Serra', 'Tapurah', 'Terra Nova do Norte', 'Tesouro', 'Torixoréu', 'União do Sul', 'Vale de São Domingos', 'Vera', 'Vila Bela da Santíssima Trindade', 'Vila Rica', 'Várzea Grande', 'Água Boa'],
  AC: ['Acrelândia', 'Assis Brasil', 'Brasiléia', 'Bujari', 'Capixaba', 'Cruzeiro do Sul', 'Epitaciolândia', 'Feijó', 'Jordão', 'Manoel Urbano', 'Marechal Thaumaturgo', 'Mâncio Lima', 'Plácido de Castro', 'Porto Acre', 'Porto Walter', 'Rio Branco', 'Rodrigues Alves', 'Santa Rosa do Purus', 'Sena Madureira', 'Senador Guiomard', 'Tarauacá', 'Xapuri'],
  SP: ['Adamantina', 'Adolfo', 'Aguaí', 'Agudos', 'Alambari', 'Alfredo Marcondes', 'Altair', 'Altinópolis', 'Alto Alegre', 'Alumínio', 'Alvinlândia', 'Americana', 'Amparo', 'Américo Brasiliense', 'Américo de Campos', 'Analândia', 'Andradina', 'Angatuba', 'Anhembi', 'Anhumas', 'Aparecida', "Aparecida d'Oeste", 'Apiaí', 'Aramina', 'Arandu', 'Arapeí', 'Araraquara', 'Araras', 'Araçariguama', 'Araçatuba', 'Araçoiaba da Serra', 'Arco-Íris', 'Arealva', 'Areias', 'Areiópolis', 'Ariranha', 'Artur Nogueira', 'Arujá', 'Aspásia', 'Assis', 'Atibaia', 'Auriflama', 'Avanhandava', 'Avaré', 'Avaí', 'Bady Bassitt', 'Balbinos', 'Bananal', 'Barbosa', 'Bariri', 'Barra Bonita', 'Barra do Chapéu', 'Barra do Turvo', 'Barretos', 'Barrinha', 'Barueri', 'Barão de Antonina', 'Bastos', 'Batatais', 'Bauru', 'Bebedouro', 'Bento de Abreu', 'Bernardino de Campos', 'Bertioga', 'Bilac', 'Birigui', 'Biritiba Mirim', 'Boa Esperança do Sul', 'Bocaina', 'Bofete', 'Boituva', 'Bom Jesus dos Perdões', 'Bom Sucesso de Itararé', 'Boracéia', 'Borborema', 'Borebi', 'Borá', 'Botucatu', 'Bragança Paulista', 'Braúna', 'Brejo Alegre', 'Brodowski', 'Brotas', 'Buri', 'Buritama', 'Buritizal', 'Bálsamo', 'Cabreúva', 'Cabrália Paulista', 'Cachoeira Paulista', 'Caconde', 'Cafelândia', 'Caiabu', 'Caieiras', 'Caiuá', 'Cajamar', 'Cajati', 'Cajobi', 'Cajuru', 'Campina do Monte Alegre', 'Campinas', 'Campo Limpo Paulista', 'Campos Novos Paulista', 'Campos do Jordão', 'Cananéia', 'Canas', 'Canitar', 'Capela do Alto', 'Capivari', 'Capão Bonito', 'Caraguatatuba', 'Carapicuíba', 'Cardoso', 'Casa Branca', 'Castilho', 'Catanduva', 'Catiguá', 'Caçapava', 'Cedral', 'Cerqueira César', 'Cerquilho', 'Cesário Lange', 'Charqueada', 'Chavantes', 'Clementina', 'Colina', 'Colômbia', 'Conchal', 'Conchas', 'Cordeirópolis', 'Coroados', 'Coronel Macedo', 'Corumbataí', 'Cosmorama', 'Cosmópolis', 'Cotia', 'Cravinhos', 'Cristais Paulista', 'Cruzeiro', 'Cruzália', 'Cubatão', 'Cunha', 'Cássia dos Coqueiros', 'Cândido Mota', 'Cândido Rodrigues', 'Descalvado', 'Diadema', 'Dirce Reis', 'Divinolândia', 'Dobrada', 'Dois Córregos', 'Dolcinópolis', 'Dourado', 'Dracena', 'Duartina', 'Dumont', 'Echaporã', 'Eldorado', 'Elias Fausto', 'Elisiário', 'Embaúba', 'Embu das Artes', 'Embu-Guaçu', 'Emilianópolis', 'Engenheiro Coelho', 'Espírito Santo do Pinhal', 'Espírito Santo do Turvo', 'Estiva Gerbi', "Estrela d'Oeste", 'Estrela do Norte', 'Euclides da Cunha Paulista', 'Fartura', 'Fernando Prestes', 'Fernandópolis', 'Fernão', 'Ferraz de Vasconcelos', 'Flora Rica', 'Floreal', 'Florínea', 'Flórida Paulista', 'Franca', 'Francisco Morato', 'Franco da Rocha', 'Gabriel Monteiro', 'Garça', 'Gastão Vidigal', 'Gavião Peixoto', 'General Salgado', 'Getulina', 'Glicério', 'Guaimbê', 'Guaiçara', 'Guapiara', 'Guapiaçu', 'Guaraci', "Guarani d'Oeste", 'Guarantã', 'Guararapes', 'Guararema', 'Guaratinguetá', 'Guaraçaí', 'Guareí', 'Guariba', 'Guarujá', 'Guarulhos', 'Guará', 'Guatapará', 'Guaíra', 'Guzolândia', 'Gália', 'Herculândia', 'Holambra', 'Hortolândia', 'Iacanga', 'Iacri', 'Iaras', 'Ibaté', 'Ibirarema', 'Ibirá', 'Ibitinga', 'Ibiúna', 'Icém', 'Iepê', 'Igarapava', 'Igaratá', 'Igaraçu do Tietê', 'Iguape', 'Ilha Comprida', 'Ilha Solteira', 'Ilhabela', 'Indaiatuba', 'Indiana', 'Indiaporã', 'Inúbia Paulista', 'Ipaussu', 'Iperó', 'Ipeúna', 'Ipiguá', 'Iporanga', 'Ipuã', 'Iracemápolis', 'Irapuru', 'Irapuã', 'Itaberá', 'Itajobi', 'Itaju', 'Itanhaém', 'Itaoca', 'Itapecerica da Serra', 'Itapetininga', 'Itapeva', 'Itapevi', 'Itapira', 'Itapirapuã Paulista', 'Itaporanga', 'Itapura', 'Itapuí', 'Itaquaquecetuba', 'Itararé', 'Itariri', 'Itatiba', 'Itatinga', 'Itaí', 'Itirapina', 'Itirapuã', 'Itobi', 'Itu', 'Itupeva', 'Ituverava', 'Itápolis', 'Jaborandi', 'Jaboticabal', 'Jacareí', 'Jaci', 'Jacupiranga', 'Jaguariúna', 'Jales', 'Jambeiro', 'Jandira', 'Jardinópolis', 'Jarinu', 'Jaú', 'Jeriquara', 'Joanópolis', 'José Bonifácio', 'João Ramalho', 'Jumirim', 'Jundiaí', 'Junqueirópolis', 'Juquitiba', 'Juquiá', 'Júlio Mesquita', 'Lagoinha', 'Laranjal Paulista', 'Lavrinhas', 'Lavínia', 'Leme', 'Lençóis Paulista', 'Limeira', 'Lindóia', 'Lins', 'Lorena', 'Lourdes', 'Louveira', 'Lucianópolis', 'Lucélia', 'Luiziânia', 'Lupércio', 'Lutécia', 'Luís Antônio', 'Macatuba', 'Macaubal', 'Macedônia', 'Magda', 'Mairinque', 'Mairiporã', 'Manduri', 'Marabá Paulista', 'Maracaí', 'Marapoama', 'Marinópolis', 'Mariápolis', 'Martinópolis', 'Marília', 'Matão', 'Mauá', 'Mendonça', 'Meridiano', 'Mesópolis', 'Miguelópolis', 'Mineiros do Tietê', 'Mira Estrela', 'Miracatu', 'Mirandópolis', 'Mirante do Paranapanema', 'Mirassol', 'Mirassolândia', 'Mococa', 'Mogi Guaçu', 'Mogi Mirim', 'Mogi das Cruzes', 'Mombuca', 'Mongaguá', 'Monte Alegre do Sul', 'Monte Alto', 'Monte Aprazível', 'Monte Azul Paulista', 'Monte Castelo', 'Monte Mor', 'Monteiro Lobato', 'Monções', 'Morro Agudo', 'Morungaba', 'Motuca', 'Murutinga do Sul', 'Nantes', 'Narandiba', 'Natividade da Serra', 'Nazaré Paulista', 'Neves Paulista', 'Nhandeara', 'Nipoã', 'Nova Aliança', 'Nova Campina', 'Nova Canaã Paulista', 'Nova Castilho', 'Nova Europa', 'Nova Granada', 'Nova Guataporanga', 'Nova Independência', 'Nova Luzitânia', 'Nova Odessa', 'Novais', 'Novo Horizonte', 'Nuporanga', 'Ocauçu', 'Olímpia', 'Onda Verde', 'Oriente', 'Orindiúva', 'Orlândia', 'Osasco', 'Oscar Bressane', 'Osvaldo Cruz', 'Ourinhos', 'Ouro Verde', 'Ouroeste', 'Pacaembu', 'Palestina', 'Palmares Paulista', "Palmeira d'Oeste", 'Palmital', 'Panorama', 'Paraguaçu Paulista', 'Paraibuna', 'Paranapanema', 'Paranapuã', 'Parapuã', 'Paraíso', 'Pardinho', 'Pariquera-Açu', 'Parisi', 'Patrocínio Paulista', 'Paulicéia', 'Paulistânia', 'Paulo de Faria', 'Paulínia', 'Pederneiras', 'Pedra Bela', 'Pedranópolis', 'Pedregulho', 'Pedreira', 'Pedrinhas Paulista', 'Pedro de Toledo', 'Penápolis', 'Pereira Barreto', 'Pereiras', 'Peruíbe', 'Piacatu', 'Piedade', 'Pilar do Sul', 'Pindamonhangaba', 'Pindorama', 'Pinhalzinho', 'Piquerobi', 'Piquete', 'Piracaia', 'Piracicaba', 'Piraju', 'Pirajuí', 'Pirangi', 'Pirapora do Bom Jesus', 'Pirapozinho', 'Pirassununga', 'Piratininga', 'Pitangueiras', 'Planalto', 'Platina', 'Poloni', 'Pompéia', 'Pongaí', 'Pontal', 'Pontalinda', 'Pontes Gestal', 'Populina', 'Porangaba', 'Porto Feliz', 'Porto Ferreira', 'Potim', 'Potirendaba', 'Poá', 'Pracinha', 'Pradópolis', 'Praia Grande', 'Pratânia', 'Presidente Alves', 'Presidente Bernardes', 'Presidente Epitácio', 'Presidente Prudente', 'Presidente Venceslau', 'Promissão', 'Quadra', 'Quatá', 'Queiroz', 'Queluz', 'Quintana', 'Rafard', 'Rancharia', 'Redenção da Serra', 'Regente Feijó', 'Reginópolis', 'Registro', 'Restinga', 'Ribeira', 'Ribeirão Bonito', 'Ribeirão Branco', 'Ribeirão Corrente', 'Ribeirão Grande', 'Ribeirão Pires', 'Ribeirão Preto', 'Ribeirão do Sul', 'Ribeirão dos Índios', 'Rifaina', 'Rincão', 'Rinópolis', 'Rio Claro', 'Rio Grande da Serra', 'Rio das Pedras', 'Riolândia', 'Riversul', 'Rosana', 'Roseira', 'Rubinéia', 'Rubiácea', 'Sabino', 'Sagres', 'Sales', 'Sales Oliveira', 'Salesópolis', 'Salmourão', 'Saltinho', 'Salto', 'Salto Grande', 'Salto de Pirapora', 'Sandovalina', 'Santa Adélia', 'Santa Albertina', 'Santa Branca', "Santa Bárbara d'Oeste", "Santa Clara d'Oeste", 'Santa Cruz da Conceição', 'Santa Cruz da Esperança', 'Santa Cruz das Palmeiras', 'Santa Cruz do Rio Pardo', 'Santa Ernestina', 'Santa Fé do Sul', 'Santa Gertrudes', 'Santa Isabel', 'Santa Lúcia', 'Santa Maria da Serra', 'Santa Mercedes', "Santa Rita d'Oeste", 'Santa Rita do Passa Quatro', 'Santa Rosa de Viterbo', 'Santa Salete', 'Santana da Ponte Pensa', 'Santana de Parnaíba', 'Santo Anastácio', 'Santo André', 'Santo Antônio da Alegria', 'Santo Antônio de Posse', 'Santo Antônio do Aracanguá', 'Santo Antônio do Jardim', 'Santo Antônio do Pinhal', 'Santo Expedito', 'Santos', 'Santópolis do Aguapeí', 'Sarapuí', 'Sarutaiá', 'Sebastianópolis do Sul', 'Serra Azul', 'Serra Negra', 'Serrana', 'Sertãozinho', 'Sete Barras', 'Severínia', 'Silveiras', 'Socorro', 'Sorocaba', 'Sud Mennucci', 'Sumaré', 'Suzano', 'Suzanápolis', 'São Bento do Sapucaí', 'São Bernardo do Campo', 'São Caetano do Sul', 'São Carlos', 'São Francisco', 'São Joaquim da Barra', 'São José da Bela Vista', 'São José do Barreiro', 'São José do Rio Pardo', 'São José do Rio Preto', 'São José dos Campos', 'São João da Boa Vista', 'São João das Duas Pontes', 'São João de Iracema', "São João do Pau d'Alho", 'São Lourenço da Serra', 'São Luiz do Paraitinga', 'São Manuel', 'São Miguel Arcanjo', 'São Paulo', 'São Pedro', 'São Pedro do Turvo', 'São Roque', 'São Sebastião', 'São Sebastião da Grama', 'São Simão', 'São Vicente', 'Tabapuã', 'Tabatinga', 'Taboão da Serra', 'Taciba', 'Taguaí', 'Taiaçu', 'Taiúva', 'Tambaú', 'Tanabi', 'Tapiratiba', 'Tapiraí', 'Taquaral', 'Taquaritinga', 'Taquarituba', 'Taquarivaí', 'Tarabai', 'Tarumã', 'Tatuí', 'Taubaté', 'Tejupá', 'Teodoro Sampaio', 'Terra Roxa', 'Tietê', 'Timburi', 'Torre de Pedra', 'Torrinha', 'Trabiju', 'Tremembé', 'Três Fronteiras', 'Tuiuti', 'Tupi Paulista', 'Tupã', 'Turiúba', 'Turmalina', 'Ubarana', 'Ubatuba', 'Ubirajara', 'Uchoa', 'União Paulista', 'Uru', 'Urupês', 'Urânia', 'Valentim Gentil', 'Valinhos', 'Valparaíso', 'Vargem', 'Vargem Grande Paulista', 'Vargem Grande do Sul', 'Vera Cruz', 'Vinhedo', 'Viradouro', 'Vista Alegre do Alto', 'Vitória Brasil', 'Votorantim', 'Votuporanga', 'Várzea Paulista', 'Zacarias', 'Águas da Prata', 'Águas de Lindóia', 'Águas de Santa Bárbara', 'Águas de São Pedro', 'Álvares Florence', 'Álvares Machado', 'Álvaro de Carvalho', 'Óleo'],
  ES: ['Afonso Cláudio', 'Alegre', 'Alfredo Chaves', 'Alto Rio Novo', 'Anchieta', 'Apiacá', 'Aracruz', 'Atílio Vivacqua', 'Baixo Guandu', 'Barra de São Francisco', 'Boa Esperança', 'Bom Jesus do Norte', 'Brejetuba', 'Cachoeiro de Itapemirim', 'Cariacica', 'Castelo', 'Colatina', 'Conceição da Barra', 'Conceição do Castelo', 'Divino de São Lourenço', 'Domingos Martins', 'Dores do Rio Preto', 'Ecoporanga', 'Fundão', 'Governador Lindenberg', 'Guarapari', 'Guaçuí', 'Ibatiba', 'Ibiraçu', 'Ibitirama', 'Iconha', 'Irupi', 'Itaguaçu', 'Itapemirim', 'Itarana', 'Iúna', 'Jaguaré', 'Jerônimo Monteiro', 'João Neiva', 'Laranja da Terra', 'Linhares', 'Mantenópolis', 'Marataízes', 'Marechal Floriano', 'Marilândia', 'Mimoso do Sul', 'Montanha', 'Mucurici', 'Muniz Freire', 'Muqui', 'Nova Venécia', 'Pancas', 'Pedro Canário', 'Pinheiros', 'Piúma', 'Ponto Belo', 'Presidente Kennedy', 'Rio Bananal', 'Rio Novo do Sul', 'Santa Leopoldina', 'Santa Maria de Jetibá', 'Santa Teresa', 'Serra', 'Sooretama', 'São Domingos do Norte', 'São Gabriel da Palha', 'São José do Calçado', 'São Mateus', 'São Roque do Canaã', 'Vargem Alta', 'Venda Nova do Imigrante', 'Viana', 'Vila Pavão', 'Vila Valério', 'Vila Velha', 'Vitória', 'Água Doce do Norte', 'Águia Branca'],
  MA: ['Afonso Cunha', 'Alcântara', 'Aldeias Altas', 'Altamira do Maranhão', 'Alto Alegre do Maranhão', 'Alto Alegre do Pindaré', 'Alto Parnaíba', 'Amapá do Maranhão', 'Amarante do Maranhão', 'Anajatuba', 'Anapurus', 'Apicum-Açu', 'Araguanã', 'Araioses', 'Arame', 'Arari', 'Axixá', 'Açailândia', 'Bacabal', 'Bacabeira', 'Bacuri', 'Bacurituba', 'Balsas', 'Barra do Corda', 'Barreirinhas', 'Barão de Grajaú', 'Bela Vista do Maranhão', 'Belágua', 'Benedito Leite', 'Bequimão', 'Bernardo do Mearim', 'Boa Vista do Gurupi', 'Bom Jardim', 'Bom Jesus das Selvas', 'Bom Lugar', 'Brejo', 'Brejo de Areia', 'Buriti', 'Buriti Bravo', 'Buriticupu', 'Buritirana', 'Cachoeira Grande', 'Cajapió', 'Cajari', 'Campestre do Maranhão', 'Cantanhede', 'Capinzal do Norte', 'Carolina', 'Carutapera', 'Caxias', 'Cedral', 'Central do Maranhão', 'Centro Novo do Maranhão', 'Centro do Guilherme', 'Chapadinha', 'Cidelândia', 'Codó', 'Coelho Neto', 'Colinas', 'Conceição do Lago-Açu', 'Coroatá', 'Cururupu', 'Cândido Mendes', 'Davinópolis', 'Dom Pedro', 'Duque Bacelar', 'Esperantinópolis', 'Estreito', 'Feira Nova do Maranhão', 'Fernando Falcão', 'Formosa da Serra Negra', 'Fortaleza dos Nogueiras', 'Fortuna', 'Godofredo Viana', 'Gonçalves Dias', 'Governador Archer', 'Governador Edison Lobão', 'Governador Eugênio Barros', 'Governador Luiz Rocha', 'Governador Newton Bello', 'Governador Nunes Freire', 'Grajaú', 'Graça Aranha', 'Guimarães', 'Humberto de Campos', 'Icatu', 'Igarapé Grande', 'Igarapé do Meio', 'Imperatriz', 'Itaipava do Grajaú', 'Itapecuru Mirim', 'Itinga do Maranhão', 'Jatobá', 'Jenipapo dos Vieiras', 'Joselândia', 'João Lisboa', 'Junco do Maranhão', 'Lago Verde', 'Lago da Pedra', 'Lago do Junco', 'Lago dos Rodrigues', 'Lagoa Grande do Maranhão', 'Lagoa do Mato', 'Lajeado Novo', 'Lima Campos', 'Loreto', 'Luís Domingues', 'Magalhães de Almeida', 'Maracaçumé', 'Marajá do Sena', 'Maranhãozinho', 'Mata Roma', 'Matinha', 'Matões', 'Matões do Norte', 'Milagres do Maranhão', 'Mirador', 'Miranda do Norte', 'Mirinzal', 'Montes Altos', 'Monção', 'Morros', 'Nina Rodrigues', 'Nova Colinas', 'Nova Iorque', 'Nova Olinda do Maranhão', "Olho d'Água das Cunhãs", 'Olinda Nova do Maranhão', 'Palmeirândia', 'Paraibano', 'Parnarama', 'Passagem Franca', 'Pastos Bons', 'Paulino Neves', 'Paulo Ramos', 'Paço do Lumiar', 'Pedreiras', 'Pedro do Rosário', 'Penalva', 'Peri Mirim', 'Peritoró', 'Pindaré-Mirim', 'Pinheiro', 'Pio XII', 'Pirapemas', 'Porto Franco', 'Porto Rico do Maranhão', 'Poção de Pedras', 'Presidente Dutra', 'Presidente Juscelino', 'Presidente Médici', 'Presidente Sarney', 'Presidente Vargas', 'Primeira Cruz', 'Raposa', 'Riachão', 'Ribamar Fiquene', 'Rosário', 'Sambaíba', 'Santa Filomena do Maranhão', 'Santa Helena', 'Santa Inês', 'Santa Luzia', 'Santa Luzia do Paruá', 'Santa Quitéria do Maranhão', 'Santa Rita', 'Santana do Maranhão', 'Santo Amaro do Maranhão', 'Santo Antônio dos Lopes', 'Satubinha', 'Senador Alexandre Costa', 'Senador La Rocque', 'Serrano do Maranhão', 'Sucupira do Norte', 'Sucupira do Riachão', 'São Benedito do Rio Preto', 'São Bento', 'São Bernardo', 'São Domingos do Azeitão', 'São Domingos do Maranhão', 'São Francisco do Brejão', 'São Francisco do Maranhão', 'São Félix de Balsas', 'São José de Ribamar', 'São José dos Basílios', 'São João Batista', 'São João do Carú', 'São João do Paraíso', 'São João do Soter', 'São João dos Patos', 'São Luís', 'São Luís Gonzaga do Maranhão', 'São Mateus do Maranhão', 'São Pedro da Água Branca', 'São Pedro dos Crentes', 'São Raimundo das Mangabeiras', 'São Raimundo do Doca Bezerra', 'São Roberto', 'São Vicente Ferrer', 'Sítio Novo', 'Tasso Fragoso', 'Timbiras', 'Timon', 'Trizidela do Vale', 'Tufilândia', 'Tuntum', 'Turiaçu', 'Turilândia', 'Tutóia', 'Urbano Santos', 'Vargem Grande', 'Viana', 'Vila Nova dos Martírios', 'Vitorino Freire', 'Vitória do Mearim', 'Zé Doca', 'Água Doce do Maranhão'],
  PB: ['Aguiar', 'Alagoa Grande', 'Alagoa Nova', 'Alagoinha', 'Alcantil', 'Algodão de Jandaíra', 'Alhandra', 'Amparo', 'Aparecida', 'Arara', 'Araruna', 'Araçagi', 'Areia', 'Areia de Baraúnas', 'Areial', 'Aroeiras', 'Assunção', 'Bananeiras', 'Baraúna', 'Barra de Santa Rosa', 'Barra de Santana', 'Barra de São Miguel', 'Bayeux', 'Baía da Traição', 'Belém', 'Belém do Brejo do Cruz', 'Bernardino Batista', 'Boa Ventura', 'Boa Vista', 'Bom Jesus', 'Bom Sucesso', 'Bonito de Santa Fé', 'Boqueirão', 'Borborema', 'Brejo do Cruz', 'Brejo dos Santos', 'Caaporã', 'Cabaceiras', 'Cabedelo', 'Cachoeira dos Índios', 'Cacimba de Areia', 'Cacimba de Dentro', 'Cacimbas', 'Caiçara', 'Cajazeiras', 'Cajazeirinhas', 'Caldas Brandão', 'Camalaú', 'Campina Grande', 'Capim', 'Caraúbas', 'Carrapateira', 'Casserengue', 'Catingueira', 'Catolé do Rocha', 'Caturité', 'Conceição', 'Condado', 'Conde', 'Congo', 'Coremas', 'Coxixola', 'Cruz do Espírito Santo', 'Cubati', 'Cuitegi', 'Cuité', 'Cuité de Mamanguape', 'Curral Velho', 'Curral de Cima', 'Damião', 'Desterro', 'Diamante', 'Dona Inês', 'Duas Estradas', 'Emas', 'Esperança', 'Fagundes', 'Frei Martinho', 'Gado Bravo', 'Guarabira', 'Gurinhém', 'Gurjão', 'Ibiara', 'Igaracy', 'Imaculada', 'Ingá', 'Itabaiana', 'Itaporanga', 'Itapororoca', 'Itatuba', 'Jacaraú', 'Jericó', 'Joca Claudino', 'João Pessoa', 'Juarez Távora', 'Juazeirinho', 'Junco do Seridó', 'Juripiranga', 'Juru', 'Lagoa', 'Lagoa Seca', 'Lagoa de Dentro', 'Lastro', 'Livramento', 'Logradouro', 'Lucena', 'Malta', 'Mamanguape', 'Manaíra', 'Marcação', 'Mari', 'Marizópolis', 'Massaranduba', 'Mataraca', 'Matinhas', 'Mato Grosso', 'Maturéia', 'Mogeiro', 'Montadas', 'Monte Horebe', 'Monteiro', 'Mulungu', "Mãe d'Água", 'Natuba', 'Nazarezinho', 'Nova Floresta', 'Nova Olinda', 'Nova Palmeira', "Olho d'Água", 'Olivedos', 'Ouro Velho', 'Parari', 'Passagem', 'Patos', 'Paulista', 'Pedra Branca', 'Pedra Lavrada', 'Pedras de Fogo', 'Pedro Régis', 'Piancó', 'Picuí', 'Pilar', 'Pilões', 'Pilõezinhos', 'Pirpirituba', 'Pitimbu', 'Pocinhos', 'Pombal', 'Poço Dantas', 'Poço de José de Moura', 'Prata', 'Princesa Isabel', 'Puxinanã', 'Queimadas', 'Quixaba', 'Remígio', 'Riacho de Santo Antônio', 'Riacho dos Cavalos', 'Riachão', 'Riachão do Bacamarte', 'Riachão do Poço', 'Rio Tinto', 'Salgadinho', 'Salgado de São Félix', 'Santa Cecília', 'Santa Cruz', 'Santa Helena', 'Santa Inês', 'Santa Luzia', 'Santa Rita', 'Santa Teresinha', 'Santana de Mangueira', 'Santana dos Garrotes', 'Santo André', 'Sapé', 'Serra Branca', 'Serra Grande', 'Serra Redonda', 'Serra da Raiz', 'Serraria', 'Sertãozinho', 'Sobrado', 'Soledade', 'Solânea', 'Sossêgo', 'Sousa', 'Sumé', 'São Bentinho', 'São Bento', 'São Domingos', 'São Domingos do Cariri', 'São Francisco', 'São José da Lagoa Tapada', 'São José de Caiana', 'São José de Espinharas', 'São José de Piranhas', 'São José de Princesa', 'São José do Bonfim', 'São José do Brejo do Cruz', 'São José do Sabugi', 'São José dos Cordeiros', 'São José dos Ramos', 'São João do Cariri', 'São João do Rio do Peixe', 'São João do Tigre', 'São Mamede', 'São Miguel de Taipu', 'São Sebastião de Lagoa de Roça', 'São Sebastião do Umbuzeiro', 'São Vicente do Seridó', 'Tacima', 'Taperoá', 'Tavares', 'Teixeira', 'Tenório', 'Triunfo', 'Uiraúna', 'Umbuzeiro', 'Vieirópolis', 'Vista Serrana', 'Várzea', 'Zabelê', 'Água Branca'],
  MS: ['Alcinópolis', 'Amambai', 'Anastácio', 'Anaurilândia', 'Angélica', 'Antônio João', 'Aparecida do Taboado', 'Aquidauana', 'Aral Moreira', 'Bandeirantes', 'Bataguassu', 'Batayporã', 'Bela Vista', 'Bodoquena', 'Bonito', 'Brasilândia', 'Caarapó', 'Camapuã', 'Campo Grande', 'Caracol', 'Cassilândia', 'Chapadão do Sul', 'Corguinho', 'Coronel Sapucaia', 'Corumbá', 'Costa Rica', 'Coxim', 'Deodápolis', 'Dois Irmãos do Buriti', 'Douradina', 'Dourados', 'Eldorado', 'Figueirão', 'Fátima do Sul', 'Glória de Dourados', 'Guia Lopes da Laguna', 'Iguatemi', 'Inocência', 'Itaporã', 'Itaquiraí', 'Ivinhema', 'Japorã', 'Jaraguari', 'Jardim', 'Jateí', 'Juti', 'Ladário', 'Laguna Carapã', 'Maracaju', 'Miranda', 'Mundo Novo', 'Naviraí', 'Nioaque', 'Nova Alvorada do Sul', 'Nova Andradina', 'Novo Horizonte do Sul', 'Paranaíba', 'Paranhos', 'Paraíso das Águas', 'Pedro Gomes', 'Ponta Porã', 'Porto Murtinho', 'Ribas do Rio Pardo', 'Rio Brilhante', 'Rio Negro', 'Rio Verde de Mato Grosso', 'Rochedo', 'Santa Rita do Pardo', 'Selvíria', 'Sete Quedas', 'Sidrolândia', 'Sonora', 'São Gabriel do Oeste', 'Tacuru', 'Taquarussu', 'Terenos', 'Três Lagoas', 'Vicentina', 'Água Clara'],
  RO: ["Alta Floresta D'Oeste", 'Alto Alegre dos Parecis', 'Alto Paraíso', "Alvorada D'Oeste", 'Ariquemes', 'Buritis', 'Cabixi', 'Cacaulândia', 'Cacoal', 'Campo Novo de Rondônia', 'Candeias do Jamari', 'Castanheiras', 'Cerejeiras', 'Chupinguaia', 'Colorado do Oeste', 'Corumbiara', 'Costa Marques', 'Cujubim', "Espigão D'Oeste", 'Governador Jorge Teixeira', 'Guajará-Mirim', 'Itapuã do Oeste', 'Jaru', 'Ji-Paraná', "Machadinho D'Oeste", 'Ministro Andreazza', 'Mirante da Serra', 'Monte Negro', "Nova Brasilândia D'Oeste", 'Nova Mamoré', 'Nova União', 'Novo Horizonte do Oeste', 'Ouro Preto do Oeste', 'Parecis', 'Pimenta Bueno', 'Pimenteiras do Oeste', 'Porto Velho', 'Presidente Médici', 'Primavera de Rondônia', 'Rio Crespo', 'Rolim de Moura', "Santa Luzia D'Oeste", 'Seringueiras', "São Felipe D'Oeste", 'São Francisco do Guaporé', 'São Miguel do Guaporé', 'Teixeirópolis', 'Theobroma', 'Urupá', 'Vale do Anari', 'Vale do Paraíso', 'Vilhena'],
  RR: ['Alto Alegre', 'Amajari', 'Boa Vista', 'Bonfim', 'Cantá', 'Caracaraí', 'Caroebe', 'Iracema', 'Mucajaí', 'Normandia', 'Pacaraima', 'Rorainópolis', 'São João da Baliza', 'São Luiz', 'Uiramutã'],
  AM: ['Alvarães', 'Amaturá', 'Anamã', 'Anori', 'Apuí', 'Atalaia do Norte', 'Autazes', 'Barcelos', 'Barreirinha', 'Benjamin Constant', 'Beruri', 'Boa Vista do Ramos', 'Boca do Acre', 'Borba', 'Caapiranga', 'Canutama', 'Carauari', 'Careiro', 'Careiro da Várzea', 'Coari', 'Codajás', 'Eirunepé', 'Envira', 'Fonte Boa', 'Guajará', 'Humaitá', 'Ipixuna', 'Iranduba', 'Itacoatiara', 'Itamarati', 'Itapiranga', 'Japurá', 'Juruá', 'Jutaí', 'Lábrea', 'Manacapuru', 'Manaquiri', 'Manaus', 'Manicoré', 'Maraã', 'Maués', 'Nhamundá', 'Nova Olinda do Norte', 'Novo Airão', 'Novo Aripuanã', 'Parintins', 'Pauini', 'Presidente Figueiredo', 'Rio Preto da Eva', 'Santa Isabel do Rio Negro', 'Santo Antônio do Içá', 'Silves', 'São Gabriel da Cachoeira', 'São Paulo de Olivença', 'São Sebastião do Uatumã', 'Tabatinga', 'Tapauá', 'Tefé', 'Tonantins', 'Uarini', 'Urucará', 'Urucurituba'],
  AP: ['Amapá', 'Calçoene', 'Cutias', 'Ferreira Gomes', 'Itaubal', 'Laranjal do Jari', 'Macapá', 'Mazagão', 'Oiapoque', 'Pedra Branca do Amapari', 'Porto Grande', 'Pracuúba', 'Santana', 'Serra do Navio', 'Tartarugalzinho', 'Vitória do Jari'],
  SE: ['Amparo do São Francisco', 'Aquidabã', 'Aracaju', 'Arauá', 'Areia Branca', 'Barra dos Coqueiros', 'Boquim', 'Brejo Grande', 'Campo do Brito', 'Canhoba', 'Canindé de São Francisco', 'Capela', 'Carira', 'Carmópolis', 'Cedro de São João', 'Cristinápolis', 'Cumbe', 'Divina Pastora', 'Estância', 'Feira Nova', 'Frei Paulo', 'Gararu', 'General Maynard', 'Gracho Cardoso', 'Ilha das Flores', 'Indiaroba', 'Itabaiana', 'Itabaianinha', 'Itabi', "Itaporanga d'Ajuda", 'Japaratuba', 'Japoatã', 'Lagarto', 'Laranjeiras', 'Macambira', 'Malhada dos Bois', 'Malhador', 'Maruim', 'Moita Bonita', 'Monte Alegre de Sergipe', 'Muribeca', 'Neópolis', 'Nossa Senhora Aparecida', 'Nossa Senhora da Glória', 'Nossa Senhora das Dores', 'Nossa Senhora de Lourdes', 'Nossa Senhora do Socorro', 'Pacatuba', 'Pedra Mole', 'Pedrinhas', 'Pinhão', 'Pirambu', 'Porto da Folha', 'Poço Redondo', 'Poço Verde', 'Propriá', 'Riachuelo', 'Riachão do Dantas', 'Ribeirópolis', 'Rosário do Catete', 'Salgado', 'Santa Luzia do Itanhy', 'Santa Rosa de Lima', 'Santana do São Francisco', 'Santo Amaro das Brotas', 'Simão Dias', 'Siriri', 'São Cristóvão', 'São Domingos', 'São Francisco', 'São Miguel do Aleixo', 'Telha', 'Tobias Barreto', 'Tomar do Geru', 'Umbaúba'],
  AL: ['Anadia', 'Arapiraca', 'Atalaia', 'Barra de Santo Antônio', 'Barra de São Miguel', 'Batalha', 'Belo Monte', 'Belém', 'Boca da Mata', 'Branquinha', 'Cacimbinhas', 'Cajueiro', 'Campestre', 'Campo Alegre', 'Campo Grande', 'Canapi', 'Capela', 'Carneiros', 'Chã Preta', 'Coité do Nóia', 'Colônia Leopoldina', 'Coqueiro Seco', 'Coruripe', 'Craíbas', 'Delmiro Gouveia', 'Dois Riachos', 'Estrela de Alagoas', 'Feira Grande', 'Feliz Deserto', 'Flexeiras', 'Girau do Ponciano', 'Ibateguara', 'Igaci', 'Igreja Nova', 'Inhapi', 'Jacaré dos Homens', 'Jacuípe', 'Japaratinga', 'Jaramataia', 'Jequiá da Praia', 'Joaquim Gomes', 'Jundiá', 'Junqueiro', 'Lagoa da Canoa', 'Limoeiro de Anadia', 'Maceió', 'Major Isidoro', 'Mar Vermelho', 'Maragogi', 'Maravilha', 'Marechal Deodoro', 'Maribondo', 'Mata Grande', 'Matriz de Camaragibe', 'Messias', 'Minador do Negrão', 'Monteirópolis', 'Murici', 'Novo Lino', "Olho d'Água Grande", "Olho d'Água das Flores", "Olho d'Água do Casado", 'Olivença', 'Ouro Branco', 'Palestina', 'Palmeira dos Índios', 'Pariconha', 'Paripueira', 'Passo de Camaragibe', 'Paulo Jacinto', 'Penedo', 'Piaçabuçu', 'Pilar', 'Pindoba', 'Piranhas', 'Porto Calvo', 'Porto Real do Colégio', 'Porto de Pedras', 'Poço das Trincheiras', 'Pão de Açúcar', 'Quebrangulo', 'Rio Largo', 'Roteiro', 'Santa Luzia do Norte', 'Santana do Ipanema', 'Santana do Mundaú', 'Satuba', 'Senador Rui Palmeira', 'São Brás', 'São José da Laje', 'São José da Tapera', 'São Luís do Quitunde', 'São Miguel dos Campos', 'São Miguel dos Milagres', 'São Sebastião', "Tanque d'Arca", 'Taquarana', 'Teotônio Vilela', 'Traipu', 'União dos Palmares', 'Viçosa', 'Água Branca'],
  RJ: ['Angra dos Reis', 'Aperibé', 'Araruama', 'Areal', 'Armação dos Búzios', 'Arraial do Cabo', 'Barra Mansa', 'Barra do Piraí', 'Belford Roxo', 'Bom Jardim', 'Bom Jesus do Itabapoana', 'Cabo Frio', 'Cachoeiras de Macacu', 'Cambuci', 'Campos dos Goytacazes', 'Cantagalo', 'Carapebus', 'Cardoso Moreira', 'Carmo', 'Casimiro de Abreu', 'Comendador Levy Gasparian', 'Conceição de Macabu', 'Cordeiro', 'Duas Barras', 'Duque de Caxias', 'Engenheiro Paulo de Frontin', 'Guapimirim', 'Iguaba Grande', 'Itaboraí', 'Itaguaí', 'Italva', 'Itaocara', 'Itaperuna', 'Itatiaia', 'Japeri', 'Laje do Muriaé', 'Macaé', 'Macuco', 'Magé', 'Mangaratiba', 'Maricá', 'Mendes', 'Mesquita', 'Miguel Pereira', 'Miracema', 'Natividade', 'Nilópolis', 'Niterói', 'Nova Friburgo', 'Nova Iguaçu', 'Paracambi', 'Paraty', 'Paraíba do Sul', 'Paty do Alferes', 'Petrópolis', 'Pinheiral', 'Piraí', 'Porciúncula', 'Porto Real', 'Quatis', 'Queimados', 'Quissamã', 'Resende', 'Rio Bonito', 'Rio Claro', 'Rio das Flores', 'Rio das Ostras', 'Rio de Janeiro', 'Santa Maria Madalena', 'Santo Antônio de Pádua', 'Sapucaia', 'Saquarema', 'Seropédica', 'Silva Jardim', 'Sumidouro', 'São Fidélis', 'São Francisco de Itabapoana', 'São Gonçalo', 'São José de Ubá', 'São José do Vale do Rio Preto', 'São João da Barra', 'São João de Meriti', 'São Pedro da Aldeia', 'São Sebastião do Alto', 'Tanguá', 'Teresópolis', 'Trajano de Moraes', 'Três Rios', 'Valença', 'Varre-Sai', 'Vassouras', 'Volta Redonda'],
  DF: ['Brasília']
};

var sortAlphabetically = function sortAlphabetically(cityA, cityB) {
  return cityA.localeCompare(cityB);
};

function getCities(state) {
  if (state) {
    var states = getStates();
    var foundState = states.find(function (_ref) {
      var name = _ref.name,
          code = _ref.code;
      return name === state || code === state;
    });

    if (!foundState) {
      return [];
    }

    return CITIES_DATA[foundState.code].sort(sortAlphabetically);
  }

  return Object.values(CITIES_DATA).reduce(function (acc, city) {
    return acc.concat(city);
  }, []).sort(sortAlphabetically);
}



/***/ }),

/***/ 62600:
/*!********************************************************************************************!*\
  !*** ./node_modules/@material-extended/mde/__ivy_ngcc__/fesm2015/material-extended-mde.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MdePopover": () => (/* binding */ MdePopover),
/* harmony export */   "MdePopoverModule": () => (/* binding */ MdePopoverModule),
/* harmony export */   "MdePopoverTarget": () => (/* binding */ MdePopoverTarget),
/* harmony export */   "MdePopoverTrigger": () => (/* binding */ MdePopoverTrigger),
/* harmony export */   "transformPopover": () => (/* binding */ transformPopover)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 94666);
/* harmony import */ var _angular_cdk_overlay__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/cdk/overlay */ 25895);
/* harmony import */ var _angular_cdk_coercion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/cdk/coercion */ 48971);
/* harmony import */ var _angular_cdk_keycodes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/cdk/keycodes */ 28456);
/* harmony import */ var _angular_animations__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/animations */ 24851);
/* harmony import */ var _angular_cdk_a11y__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/cdk/a11y */ 24218);
/* harmony import */ var _angular_cdk_bidi__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/cdk/bidi */ 72867);
/* harmony import */ var _angular_cdk_portal__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/cdk/portal */ 17520);










/**
 * Throws an exception for the case when popover trigger doesn't have a valid mde-popover instance
 */







function MdePopover_ng_template_0_div_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "div", 3);
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngStyle", ctx_r1.popoverArrowStyles);
  }
}

function MdePopover_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("keydown", function MdePopover_ng_template_0_Template_div_keydown_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r3);
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r2._handleKeydown($event));
    })("click", function MdePopover_ng_template_0_Template_div_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r3);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r4.onClick());
    })("mouseover", function MdePopover_ng_template_0_Template_div_mouseover_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r3);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r5.onMouseOver());
    })("mouseleave", function MdePopover_ng_template_0_Template_div_mouseleave_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r3);
      const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r6.onMouseLeave());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, MdePopover_ng_template_0_div_1_Template, 1, 1, "div", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojection"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("mde-popover-overlap", ctx_r0.overlapTrigger);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", ctx_r0._classList)("ngStyle", ctx_r0.popoverPanelStyles)("@.disabled", ctx_r0.disableAnimation)("@transformPopover", "enter");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !ctx_r0.overlapTrigger);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngStyle", ctx_r0.popoverContentStyles)("cdkTrapFocus", ctx_r0.focusTrapEnabled)("cdkTrapFocusAutoCapture", ctx_r0.focusTrapAutoCaptureEnabled);
  }
}

const _c0 = ["*"];

function throwMdePopoverMissingError() {
  throw Error(`mde-popover-trigger: must pass in an mde-popover instance.

    Example:
      <mde-popover #popover="mdePopover"></mde-popover>
      <button [mdePopoverTriggerFor]="popover"></button>`);
}
/**
 * Throws an exception for the case when popover's mdePopoverPositionX value isn't valid.
 * In other words, it doesn't match 'before' or 'after'.
 */


function throwMdePopoverInvalidPositionX() {
  throw Error(`mdePopoverPositionX value must be either 'before' or after'.
      Example: <mde-popover mdePopoverPositionX="before" #popover="mdePopover"></mde-popover>`);
}
/**
 * Throws an exception for the case when popover's mdePopoverPositionY value isn't valid.
 * In other words, it doesn't match 'above' or 'below'.
 */


function throwMdePopoverInvalidPositionY() {
  throw Error(`mdePopoverPositionY value must be either 'above' or below'.
      Example: <mde-popover mdePopoverPositionY="above" #popover="mdePopover"></mde-popover>`);
}
/**
 * Below are all the animations for the md-popover component.
 * Animation duration and timing values are based on AngularJS Material.
 */

/**
 * This animation controls the popover panel's entry and exit from the page.
 *
 * When the popover panel is added to the DOM, it scales in and fades in its border.
 *
 * When the popover panel is removed from the DOM, it simply fades out after a brief
 * delay to display the ripple.
 */


const transformPopover = (0,_angular_animations__WEBPACK_IMPORTED_MODULE_1__.trigger)('transformPopover', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_1__.state)('enter', (0,_angular_animations__WEBPACK_IMPORTED_MODULE_1__.style)({
  opacity: 1,
  transform: `scale(1)`
})), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_1__.transition)('void => *', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_1__.style)({
  opacity: 0,
  transform: `scale(0)`
}), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_1__.animate)(`200ms cubic-bezier(0.25, 0.8, 0.25, 1)`)]), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_1__.transition)('* => void', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_1__.animate)('50ms 100ms linear', (0,_angular_animations__WEBPACK_IMPORTED_MODULE_1__.style)({
  opacity: 0
}))])]);
let MdePopover = class MdePopover {
  constructor(_elementRef, zone) {
    this._elementRef = _elementRef;
    this.zone = zone;
    this.role = 'dialog';
    /** Settings for popover, view setters and getters for more detail */

    this._positionX = 'after';
    this._positionY = 'below';
    this._triggerEvent = 'hover';
    this._enterDelay = 200;
    this._leaveDelay = 200;
    this._overlapTrigger = true;
    this._disableAnimation = false;
    this._targetOffsetX = 0;
    this._targetOffsetY = 0;
    this._arrowOffsetX = 20;
    this._arrowWidth = 8;
    this._arrowColor = 'rgba(0, 0, 0, 0.12)';
    this._closeOnClick = true;
    this._focusTrapEnabled = true;
    this._focusTrapAutoCaptureEnabled = true;
    /** Config object to be passed into the popover's ngClass */

    this._classList = {}; // TODO: Write comment description

    /** */

    this.containerPositioning = false;
    /** Closing disabled on popover */

    this.closeDisabled = false;
    /** Emits the current animation state whenever it changes. */

    this._onAnimationStateChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /** Event emitted when the popover is closed. */

    this.close = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    this.setPositionClasses();
  }
  /** Position of the popover in the X axis. */


  get positionX() {
    return this._positionX;
  }

  set positionX(value) {
    if (value !== 'before' && value !== 'after') {
      throwMdePopoverInvalidPositionX();
    }

    this._positionX = value;
    this.setPositionClasses();
  }
  /** Position of the popover in the Y axis. */


  get positionY() {
    return this._positionY;
  }

  set positionY(value) {
    if (value !== 'above' && value !== 'below') {
      throwMdePopoverInvalidPositionY();
    }

    this._positionY = value;
    this.setPositionClasses();
  }
  /** Popover trigger event */


  get triggerEvent() {
    return this._triggerEvent;
  }

  set triggerEvent(value) {
    this._triggerEvent = value;
  }
  /** Popover enter delay */


  get enterDelay() {
    return this._enterDelay;
  }

  set enterDelay(value) {
    this._enterDelay = value;
  }
  /** Popover leave delay */


  get leaveDelay() {
    return this._leaveDelay;
  }

  set leaveDelay(value) {
    this._leaveDelay = value;
  }
  /** Popover overlap trigger */


  get overlapTrigger() {
    return this._overlapTrigger;
  }

  set overlapTrigger(value) {
    this._overlapTrigger = value;
  }
  /** Popover target offset x */


  get targetOffsetX() {
    return this._targetOffsetX;
  }

  set targetOffsetX(value) {
    this._targetOffsetX = value;
  }
  /** Popover target offset y */


  get targetOffsetY() {
    return this._targetOffsetY;
  }

  set targetOffsetY(value) {
    this._targetOffsetY = value;
  }
  /** Popover arrow offset x */


  get arrowOffsetX() {
    return this._arrowOffsetX;
  }

  set arrowOffsetX(value) {
    this._arrowOffsetX = value;
  }
  /** Popover arrow width */


  get arrowWidth() {
    return this._arrowWidth;
  }

  set arrowWidth(value) {
    this._arrowWidth = value;
  }
  /** Popover arrow color */


  get arrowColor() {
    return this._arrowColor;
  }

  set arrowColor(value) {
    this._arrowColor = value;
  }
  /**
   * Popover container close on click
   * default: true
   */


  get closeOnClick() {
    return this._closeOnClick;
  }

  set closeOnClick(value) {
    this._closeOnClick = (0,_angular_cdk_coercion__WEBPACK_IMPORTED_MODULE_2__.coerceBooleanProperty)(value);
  }
  /**
   * Disable animations of popover and all child elements
   * default: false
   */


  get disableAnimation() {
    return this._disableAnimation;
  }

  set disableAnimation(value) {
    this._disableAnimation = (0,_angular_cdk_coercion__WEBPACK_IMPORTED_MODULE_2__.coerceBooleanProperty)(value);
  }
  /**
   * Popover focus trap using cdkTrapFocus
   * default: true
   */


  get focusTrapEnabled() {
    return this._focusTrapEnabled;
  }

  set focusTrapEnabled(value) {
    this._focusTrapEnabled = (0,_angular_cdk_coercion__WEBPACK_IMPORTED_MODULE_2__.coerceBooleanProperty)(value);
  }
  /**
   * Popover focus trap auto capture using cdkTrapFocusAutoCapture
   * default: true
   */


  get focusTrapAutoCaptureEnabled() {
    return this._focusTrapAutoCaptureEnabled;
  }

  set focusTrapAutoCaptureEnabled(value) {
    this._focusTrapAutoCaptureEnabled = (0,_angular_cdk_coercion__WEBPACK_IMPORTED_MODULE_2__.coerceBooleanProperty)(value);
  }
  /**
   * This method takes classes set on the host md-popover element and applies them on the
   * popover template that displays in the overlay container.  Otherwise, it's difficult
   * to style the containing popover from outside the component.
   * @param classes list of class names
   */


  set panelClass(classes) {
    if (classes && classes.length) {
      this._classList = classes.split(' ').reduce((obj, className) => {
        obj[className] = true;
        return obj;
      }, {});
      this._elementRef.nativeElement.className = '';
      this.setPositionClasses();
    }
  }
  /**
   * This method takes classes set on the host md-popover element and applies them on the
   * popover template that displays in the overlay container.  Otherwise, it's difficult
   * to style the containing popover from outside the component.
   * @deprecated Use `panelClass` instead.
   */


  get classList() {
    return this.panelClass;
  }

  set classList(classes) {
    this.panelClass = classes;
  }

  ngOnDestroy() {
    this._emitCloseEvent();

    this.close.complete();
  }
  /** Handle a keyboard event from the popover, delegating to the appropriate action. */


  _handleKeydown(event) {
    switch (event.keyCode) {
      case _angular_cdk_keycodes__WEBPACK_IMPORTED_MODULE_3__.ESCAPE:
        this._emitCloseEvent();

        return;
    }
  }
  /**
   * This emits a close event to which the trigger is subscribed. When emitted, the
   * trigger will close the popover.
   */


  _emitCloseEvent() {
    this.close.emit();
  }
  /** Close popover on click if closeOnClick is true */


  onClick() {
    if (this.closeOnClick) {
      this._emitCloseEvent();
    }
  }
  /**
   * TODO: Refactor when @angular/cdk includes feature I mentioned on github see link below.
   * https://github.com/angular/material2/pull/5493#issuecomment-313085323
   */

  /** Disables close of popover when leaving trigger element and mouse over the popover */


  onMouseOver() {
    if (this.triggerEvent === 'hover') {
      this.closeDisabled = true;
    }
  }
  /** Enables close of popover when mouse leaving popover element */


  onMouseLeave() {
    if (this.triggerEvent === 'hover') {
      this.closeDisabled = false;

      this._emitCloseEvent();
    }
  } // TODO: Refactor how styles are set and updated on the component, use best practices.
  // TODO: If arrow left and right positioning is requested, see if flex direction can be used to work with order.

  /** Sets the current styles for the popover to allow for dynamically changing settings */


  setCurrentStyles() {
    // TODO: See if arrow position can be calculated automatically and allow override.
    // TODO: See if flex order is a better alternative to position arrow top or bottom.
    this.popoverArrowStyles = {
      'right': this.positionX === 'before' ? this.arrowOffsetX - this.arrowWidth + 'px' : '',
      'left': this.positionX === 'after' ? this.arrowOffsetX - this.arrowWidth + 'px' : '',
      'border-top': this.positionY === 'below' ? this.arrowWidth + 'px solid ' + this.arrowColor : '0px solid transparent',
      'border-right':  false ? 0 : this.arrowWidth + 'px solid transparent',
      'border-bottom': this.positionY === 'above' ? this.arrowWidth + 'px solid ' + this.arrowColor : this.arrowWidth + 'px solid transparent',
      'border-left':  false ? 0 : this.arrowWidth + 'px solid transparent'
    }; // TODO: Remove if flex order is added.

    this.popoverContentStyles = {
      'padding-top': this.overlapTrigger === true ? '0px' : this.arrowWidth + 'px',
      'padding-bottom': this.overlapTrigger === true ? '0px' : this.arrowWidth + 'px',
      'margin-top': this.overlapTrigger === false && this.positionY === 'below' && this.containerPositioning === false ? -(this.arrowWidth * 2) + 'px' : '0px'
    };
  }
  /**
   * It's necessary to set position-based classes to ensure the popover panel animation
   * folds out from the correct direction.
   */


  setPositionClasses(posX = this.positionX, posY = this.positionY) {
    this._classList['mde-popover-before'] = posX === 'before';
    this._classList['mde-popover-after'] = posX === 'after';
    this._classList['mde-popover-above'] = posY === 'above';
    this._classList['mde-popover-below'] = posY === 'below';
  }

};

MdePopover.ɵfac = function MdePopover_Factory(t) {
  return new (t || MdePopover)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
};

MdePopover.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
  type: MdePopover,
  selectors: [["mde-popover"]],
  viewQuery: function MdePopover_Query(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵviewQuery"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.templateRef = _t.first);
    }
  },
  hostVars: 1,
  hostBindings: function MdePopover_HostBindings(rf, ctx) {
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("role", ctx.role);
    }
  },
  inputs: {
    positionX: ["mdePopoverPositionX", "positionX"],
    positionY: ["mdePopoverPositionY", "positionY"],
    triggerEvent: ["mdePopoverTriggerOn", "triggerEvent"],
    enterDelay: ["mdePopoverEnterDelay", "enterDelay"],
    leaveDelay: ["mdePopoverLeaveDelay", "leaveDelay"],
    overlapTrigger: ["mdePopoverOverlapTrigger", "overlapTrigger"],
    targetOffsetX: ["mdePopoverOffsetX", "targetOffsetX"],
    targetOffsetY: ["mdePopoverOffsetY", "targetOffsetY"],
    arrowOffsetX: ["mdePopoverArrowOffsetX", "arrowOffsetX"],
    arrowWidth: ["mdePopoverArrowWidth", "arrowWidth"],
    arrowColor: ["mdePopoverArrowColor", "arrowColor"],
    closeOnClick: ["mdePopoverCloseOnClick", "closeOnClick"],
    disableAnimation: ["mdePopoverDisableAnimation", "disableAnimation"],
    focusTrapEnabled: ["mdeFocusTrapEnabled", "focusTrapEnabled"],
    focusTrapAutoCaptureEnabled: ["mdeFocusTrapAutoCaptureEnabled", "focusTrapAutoCaptureEnabled"],
    panelClass: ["class", "panelClass"],
    classList: "classList"
  },
  outputs: {
    close: "close"
  },
  exportAs: ["mdePopover"],
  ngContentSelectors: _c0,
  decls: 1,
  vars: 0,
  consts: [["role", "dialog", 1, "mde-popover-panel", 3, "ngClass", "ngStyle", "keydown", "click", "mouseover", "mouseleave"], ["class", "mde-popover-direction-arrow", 3, "ngStyle", 4, "ngIf"], [1, "mde-popover-content", 3, "ngStyle", "cdkTrapFocus", "cdkTrapFocusAutoCapture"], [1, "mde-popover-direction-arrow", 3, "ngStyle"]],
  template: function MdePopover_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojectionDef"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, MdePopover_ng_template_0_Template, 4, 10, "ng-template");
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.NgClass, _angular_common__WEBPACK_IMPORTED_MODULE_4__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_4__.NgStyle, _angular_cdk_a11y__WEBPACK_IMPORTED_MODULE_5__.CdkTrapFocus],
  styles: [".mde-popover-panel{display:flex;flex-direction:column;max-height:calc(100vh + 48px)}.mde-popover-ripple{position:absolute;top:0;left:0;bottom:0;right:0}.mde-popover-below .mde-popover-direction-arrow{position:absolute;bottom:0;width:0;height:0;border-bottom-width:0!important;z-index:99999}.mde-popover-above .mde-popover-direction-arrow{position:absolute;top:0;width:0;height:0;border-top-width:0!important;z-index:99999}.mde-popover-after .mde-popover-direction-arrow{left:20px}.mde-popover-before .mde-popover-direction-arrow{right:20px}"],
  encapsulation: 2,
  data: {
    animation: [transformPopover]
  },
  changeDetection: 0
});

MdePopover.ctorParameters = () => [{
  type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone
}];

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.HostBinding)('attr.role')], MdePopover.prototype, "role", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverPositionX')], MdePopover.prototype, "positionX", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverPositionY')], MdePopover.prototype, "positionY", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverTriggerOn')], MdePopover.prototype, "triggerEvent", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverEnterDelay')], MdePopover.prototype, "enterDelay", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverLeaveDelay')], MdePopover.prototype, "leaveDelay", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverOverlapTrigger')], MdePopover.prototype, "overlapTrigger", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverOffsetX')], MdePopover.prototype, "targetOffsetX", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverOffsetY')], MdePopover.prototype, "targetOffsetY", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverArrowOffsetX')], MdePopover.prototype, "arrowOffsetX", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverArrowWidth')], MdePopover.prototype, "arrowWidth", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverArrowColor')], MdePopover.prototype, "arrowColor", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverCloseOnClick')], MdePopover.prototype, "closeOnClick", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverDisableAnimation')], MdePopover.prototype, "disableAnimation", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdeFocusTrapEnabled')], MdePopover.prototype, "focusTrapEnabled", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdeFocusTrapAutoCaptureEnabled')], MdePopover.prototype, "focusTrapAutoCaptureEnabled", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('class')], MdePopover.prototype, "panelClass", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)()], MdePopover.prototype, "classList", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)()], MdePopover.prototype, "close", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewChild)(_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef)], MdePopover.prototype, "templateRef", void 0);
/**
 * This directive is intended to be used in conjunction with an mde-popover tag. It is
 * responsible for toggling the display of the provided popover instance.
 */


let MdePopoverTrigger = class MdePopoverTrigger {
  constructor(_overlay, _elementRef, _viewContainerRef, _dir, _changeDetectorRef) {
    this._overlay = _overlay;
    this._elementRef = _elementRef;
    this._viewContainerRef = _viewContainerRef;
    this._dir = _dir;
    this._changeDetectorRef = _changeDetectorRef;
    this.ariaHaspopup = true;
    this._overlayRef = null;
    this._popoverOpen = false;
    this._halt = false; // tracking input type is necessary so it's possible to only auto-focus
    // the first item of the list when the popover is opened via the keyboard

    this._openedByMouse = false;
    /** Popover backdrop close on click */

    this.backdropCloseOnClick = true;
    /** Event emitted when the associated popover is opened. */

    this.opened = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /** Event emitted when the associated popover is closed. */

    this.closed = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
  }

  ngAfterViewInit() {
    this._checkPopover();

    this._setCurrentConfig();

    this.popover.close.subscribe(() => this.closePopover());
  }

  ngOnDestroy() {
    this.destroyPopover();
  }

  _setCurrentConfig() {
    if (this.positionX === 'before' || this.positionX === 'after') {
      this.popover.positionX = this.positionX;
    }

    if (this.positionY === 'above' || this.positionY === 'below') {
      this.popover.positionY = this.positionY;
    }

    if (this.triggerEvent) {
      this.popover.triggerEvent = this.triggerEvent;
    }

    if (this.enterDelay) {
      this.popover.enterDelay = this.enterDelay;
    }

    if (this.leaveDelay) {
      this.popover.leaveDelay = this.leaveDelay;
    }

    if (this.overlapTrigger === true || this.overlapTrigger === false) {
      this.popover.overlapTrigger = this.overlapTrigger;
    }

    if (this.targetOffsetX) {
      this.popover.targetOffsetX = this.targetOffsetX;
    }

    if (this.targetOffsetY) {
      this.popover.targetOffsetY = this.targetOffsetY;
    }

    if (this.arrowOffsetX) {
      this.popover.arrowOffsetX = this.arrowOffsetX;
    }

    if (this.arrowWidth) {
      this.popover.arrowWidth = this.arrowWidth;
    }

    if (this.arrowColor) {
      this.popover.arrowColor = this.arrowColor;
    }

    if (this.closeOnClick === true || this.closeOnClick === false) {
      this.popover.closeOnClick = this.closeOnClick;
    }

    this.popover.setCurrentStyles();
  }
  /** Whether the popover is open. */


  get popoverOpen() {
    return this._popoverOpen;
  }

  onClick(event) {
    if (this.popover.triggerEvent === 'click') {
      // this.popover.setCurrentStyles();
      // this._setCurrentConfig();
      this.togglePopover();
    }
  }

  onMouseEnter(event) {
    this._halt = false;

    if (this.popover.triggerEvent === 'hover') {
      this._mouseoverTimer = setTimeout(() => {
        this.openPopover();
      }, this.popover.enterDelay);
    }
  }

  onMouseLeave(event) {
    if (this.popover.triggerEvent === 'hover') {
      if (this._mouseoverTimer) {
        clearTimeout(this._mouseoverTimer);
        this._mouseoverTimer = null;
      }

      if (this._popoverOpen) {
        setTimeout(() => {
          if (!this.popover.closeDisabled) {
            this.closePopover();
          }
        }, this.popover.leaveDelay);
      } else {
        this._halt = true;
      }
    }
  }
  /** Toggles the popover between the open and closed states. */


  togglePopover() {
    return this._popoverOpen ? this.closePopover() : this.openPopover();
  }
  /** Opens the popover. */


  openPopover() {
    if (!this._popoverOpen && !this._halt) {
      this._createOverlay().attach(this._portal);
      /** Only subscribe to backdrop if trigger event is click */


      if (this.triggerEvent === 'click' && this.backdropCloseOnClick === true) {
        this._subscribeToBackdrop();
      }

      this._initPopover();
    }
  }
  /** Closes the popover. */


  closePopover() {
    if (this._overlayRef) {
      this._overlayRef.detach();
      /** Only unsubscribe to backdrop if trigger event is click */


      if (this.triggerEvent === 'click' && this.backdropCloseOnClick === true) {
        this._backdropSubscription.unsubscribe();
      }

      this._resetPopover();
    }
  }
  /** Removes the popover from the DOM. */


  destroyPopover() {
    if (this._mouseoverTimer) {
      clearTimeout(this._mouseoverTimer);
      this._mouseoverTimer = null;
    }

    if (this._overlayRef) {
      this._overlayRef.dispose();

      this._overlayRef = null;

      this._cleanUpSubscriptions();
    }
  }
  /** Focuses the popover trigger. */


  focus() {
    this._elementRef.nativeElement.focus();
  }
  /** The text direction of the containing app. */


  get dir() {
    return this._dir && this._dir.value === 'rtl' ? 'rtl' : 'ltr';
  }
  /**
  * This method ensures that the popover closes when the overlay backdrop is clicked.
  * We do not use first() here because doing so would not catch clicks from within
  * the popover, and it would fail to unsubscribe properly. Instead, we unsubscribe
  * explicitly when the popover is closed or destroyed.
  */


  _subscribeToBackdrop() {
    if (this._overlayRef) {
      this._backdropSubscription = this._overlayRef.backdropClick().subscribe(() => {
        this.popover._emitCloseEvent();
      });
    }
  }
  /**
  * This method sets the popover state to open and focuses the first item if
  * the popover was opened via the keyboard.
  */


  _initPopover() {
    this._setIsPopoverOpen(true);
  }
  /**
  * This method resets the popover when it's closed, most importantly restoring
  * focus to the popover trigger if the popover was opened via the keyboard.
  */


  _resetPopover() {
    this._setIsPopoverOpen(false); // Focus only needs to be reset to the host element if the popover was opened
    // by the keyboard and manually shifted to the first popover item.


    if (!this._openedByMouse) {
      this.focus();
    }

    this._openedByMouse = false;
  }
  /** set state rather than toggle to support triggers sharing a popover */


  _setIsPopoverOpen(isOpen) {
    this._popoverOpen = isOpen;
    this._popoverOpen ? this.opened.emit() : this.closed.emit();
  }
  /**
  *  This method checks that a valid instance of MdPopover has been passed into
  *  mdPopoverTriggerFor. If not, an exception is thrown.
  */


  _checkPopover() {
    if (!this.popover) {
      throwMdePopoverMissingError();
    }
  }
  /**
  *  This method creates the overlay from the provided popover's template and saves its
  *  OverlayRef so that it can be attached to the DOM when openPopover is called.
  */


  _createOverlay() {
    if (!this._overlayRef) {
      this._portal = new _angular_cdk_portal__WEBPACK_IMPORTED_MODULE_7__.TemplatePortal(this.popover.templateRef, this._viewContainerRef);

      const config = this._getOverlayConfig();

      this._subscribeToPositions(config.positionStrategy);

      this._overlayRef = this._overlay.create(config);
    }

    return this._overlayRef;
  }
  /**
  * This method builds the configuration object needed to create the overlay, the OverlayConfig.
  * @returns OverlayConfig
  */


  _getOverlayConfig() {
    const overlayState = new _angular_cdk_overlay__WEBPACK_IMPORTED_MODULE_8__.OverlayConfig();
    overlayState.positionStrategy = this._getPosition();
    /** Display overlay backdrop if trigger event is click */

    if (this.triggerEvent === 'click') {
      overlayState.hasBackdrop = true;
      overlayState.backdropClass = 'cdk-overlay-transparent-backdrop';
    }

    overlayState.direction = this.dir;
    overlayState.scrollStrategy = this._overlay.scrollStrategies.reposition();
    return overlayState;
  }
  /**
  * Listens to changes in the position of the overlay and sets the correct classes
  * on the popover based on the new position. This ensures the animation origin is always
  * correct, even if a fallback position is used for the overlay.
  */


  _subscribeToPositions(position) {
    this._positionSubscription = position.positionChanges.subscribe(change => {
      const posisionX = change.connectionPair.overlayX === 'start' ? 'after' : 'before';
      let posisionY = change.connectionPair.overlayY === 'top' ? 'below' : 'above';

      if (!this.popover.overlapTrigger) {
        posisionY = posisionY === 'below' ? 'above' : 'below';
      } // required for ChangeDetectionStrategy.OnPush


      this._changeDetectorRef.markForCheck();

      this.popover.zone.run(() => {
        this.popover.positionX = posisionX;
        this.popover.positionY = posisionY;
        this.popover.setCurrentStyles();
        this.popover.setPositionClasses(posisionX, posisionY);
      });
    });
  }
  /**
  * This method builds the position strategy for the overlay, so the popover is properly connected
  * to the trigger.
  * @returns ConnectedPositionStrategy
  */


  _getPosition() {
    const [originX, originFallbackX] = this.popover.positionX === 'before' ? ['end', 'start'] : ['start', 'end'];
    const [overlayY, overlayFallbackY] = this.popover.positionY === 'above' ? ['bottom', 'top'] : ['top', 'bottom']; // let originY = overlayY;
    // let fallbackOriginY = overlayFallbackY;

    let originY = overlayY;
    let originFallbackY = overlayFallbackY;
    const overlayX = originX;
    const overlayFallbackX = originFallbackX; // let [originY, originFallbackY] = [overlayY, overlayFallbackY];
    // let [overlayX, overlayFallbackX] = [originX, originFallbackX];

    /** Reverse overlayY and fallbackOverlayY when overlapTrigger is false */

    if (!this.popover.overlapTrigger) {
      originY = overlayY === 'top' ? 'bottom' : 'top';
      originFallbackY = overlayFallbackY === 'top' ? 'bottom' : 'top';
    }

    let offsetX = 0;
    let offsetY = 0;

    if (this.popover.targetOffsetX && !isNaN(Number(this.popover.targetOffsetX))) {
      offsetX = Number(this.popover.targetOffsetX); // offsetX = -16;
    }

    if (this.popover.targetOffsetY && !isNaN(Number(this.popover.targetOffsetY))) {
      offsetY = Number(this.popover.targetOffsetY); // offsetY = -10;
    }
    /**
     * For overriding position element, when mdePopoverTargetAt has a valid element reference.
     * Useful for sticking popover to parent element and offsetting arrow to trigger element.
     * If undefined defaults to the trigger element reference.
     */


    let element = this._elementRef;

    if (typeof this.targetElement !== 'undefined') {
      this.popover.containerPositioning = true;
      element = this.targetElement._elementRef;
    }

    return this._overlay.position().flexibleConnectedTo(element).withPositions([{
      originX,
      originY,
      overlayX,
      overlayY,
      offsetY
    }, {
      originX: originFallbackX,
      originY,
      overlayX: overlayFallbackX,
      overlayY,
      offsetY
    }, {
      originX,
      originY: originFallbackY,
      overlayX,
      overlayY: overlayFallbackY,
      offsetY: -offsetY
    }, {
      originX: originFallbackX,
      originY: originFallbackY,
      overlayX: overlayFallbackX,
      overlayY: overlayFallbackY,
      offsetY: -offsetY
    }]).withDefaultOffsetX(offsetX).withDefaultOffsetY(offsetY);
    /*
    return this._overlay.position()
      .connectedTo(element,
          {originX: posX, originY: originY},
          {overlayX: posX, overlayY: overlayY})
      .withFallbackPosition(
          {originX: fallbackX, originY: originY},
          {overlayX: fallbackX, overlayY: overlayY})
      .withFallbackPosition(
          {originX: posX, originY: fallbackOriginY},
          {overlayX: posX, overlayY: fallbackOverlayY})
      .withFallbackPosition(
          {originX: fallbackX, originY: fallbackOriginY},
          {overlayX: fallbackX, overlayY: fallbackOverlayY})
      .withOffsetX(offsetX)
      .withOffsetY(offsetY);
      */
  }

  _cleanUpSubscriptions() {
    if (this._backdropSubscription) {
      this._backdropSubscription.unsubscribe();
    }

    if (this._positionSubscription) {
      this._positionSubscription.unsubscribe();
    }
  }

  _handleMousedown(event) {
    if (event && !(0,_angular_cdk_a11y__WEBPACK_IMPORTED_MODULE_5__.isFakeMousedownFromScreenReader)(event)) {
      this._openedByMouse = true;
    }
  }

};

MdePopoverTrigger.ɵfac = function MdePopoverTrigger_Factory(t) {
  return new (t || MdePopoverTrigger)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_cdk_overlay__WEBPACK_IMPORTED_MODULE_8__.Overlay), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_cdk_bidi__WEBPACK_IMPORTED_MODULE_9__.Directionality, 8), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef));
};

MdePopoverTrigger.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: MdePopoverTrigger,
  selectors: [["", "mdePopoverTriggerFor", ""]],
  hostVars: 1,
  hostBindings: function MdePopoverTrigger_HostBindings(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function MdePopoverTrigger_click_HostBindingHandler($event) {
        return ctx.onClick($event);
      })("mouseenter", function MdePopoverTrigger_mouseenter_HostBindingHandler($event) {
        return ctx.onMouseEnter($event);
      })("mouseleave", function MdePopoverTrigger_mouseleave_HostBindingHandler($event) {
        return ctx.onMouseLeave($event);
      })("mousedown", function MdePopoverTrigger_mousedown_HostBindingHandler($event) {
        return ctx._handleMousedown($event);
      });
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-haspopup", ctx.ariaHaspopup);
    }
  },
  inputs: {
    backdropCloseOnClick: ["mdePopoverBackdropCloseOnClick", "backdropCloseOnClick"],
    popover: ["mdePopoverTriggerFor", "popover"],
    targetElement: ["mdePopoverTargetAt", "targetElement"],
    positionX: ["mdePopoverPositionX", "positionX"],
    positionY: ["mdePopoverPositionY", "positionY"],
    triggerEvent: ["mdePopoverTriggerOn", "triggerEvent"],
    enterDelay: ["mdePopoverEnterDelay", "enterDelay"],
    leaveDelay: ["mdePopoverLeaveDelay", "leaveDelay"],
    overlapTrigger: ["mdePopoverOverlapTrigger", "overlapTrigger"],
    targetOffsetX: ["mdePopoverOffsetX", "targetOffsetX"],
    targetOffsetY: ["mdePopoverOffsetY", "targetOffsetY"],
    arrowOffsetX: ["mdePopoverArrowOffsetX", "arrowOffsetX"],
    arrowWidth: ["mdePopoverArrowWidth", "arrowWidth"],
    arrowColor: ["mdePopoverArrowColor", "arrowColor"],
    closeOnClick: ["mdePopoverCloseOnClick", "closeOnClick"]
  },
  outputs: {
    opened: "opened",
    closed: "closed"
  },
  exportAs: ["mdePopoverTrigger"]
});

MdePopoverTrigger.ctorParameters = () => [{
  type: _angular_cdk_overlay__WEBPACK_IMPORTED_MODULE_8__.Overlay
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef
}, {
  type: _angular_cdk_bidi__WEBPACK_IMPORTED_MODULE_9__.Directionality,
  decorators: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Optional
  }]
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef
}];

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.HostBinding)('attr.aria-haspopup')], MdePopoverTrigger.prototype, "ariaHaspopup", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverTriggerFor')], MdePopoverTrigger.prototype, "popover", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverTargetAt')], MdePopoverTrigger.prototype, "targetElement", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverPositionX')], MdePopoverTrigger.prototype, "positionX", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverPositionY')], MdePopoverTrigger.prototype, "positionY", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverTriggerOn')], MdePopoverTrigger.prototype, "triggerEvent", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverEnterDelay')], MdePopoverTrigger.prototype, "enterDelay", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverLeaveDelay')], MdePopoverTrigger.prototype, "leaveDelay", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverOverlapTrigger')], MdePopoverTrigger.prototype, "overlapTrigger", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverOffsetX')], MdePopoverTrigger.prototype, "targetOffsetX", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverOffsetY')], MdePopoverTrigger.prototype, "targetOffsetY", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverArrowOffsetX')], MdePopoverTrigger.prototype, "arrowOffsetX", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverArrowWidth')], MdePopoverTrigger.prototype, "arrowWidth", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverArrowColor')], MdePopoverTrigger.prototype, "arrowColor", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverCloseOnClick')], MdePopoverTrigger.prototype, "closeOnClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mdePopoverBackdropCloseOnClick')], MdePopoverTrigger.prototype, "backdropCloseOnClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)()], MdePopoverTrigger.prototype, "opened", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)()], MdePopoverTrigger.prototype, "closed", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.HostListener)('click', ['$event'])], MdePopoverTrigger.prototype, "onClick", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.HostListener)('mouseenter', ['$event'])], MdePopoverTrigger.prototype, "onMouseEnter", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.HostListener)('mouseleave', ['$event'])], MdePopoverTrigger.prototype, "onMouseLeave", null);

(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.HostListener)('mousedown', ['$event'])], MdePopoverTrigger.prototype, "_handleMousedown", null);

MdePopoverTrigger = (0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__param)(3, (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Optional)())], MdePopoverTrigger);
let MdePopoverTarget = class MdePopoverTarget {
  constructor(_elementRef) {
    this._elementRef = _elementRef;
  }

};

MdePopoverTarget.ɵfac = function MdePopoverTarget_Factory(t) {
  return new (t || MdePopoverTarget)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef));
};

MdePopoverTarget.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: MdePopoverTarget,
  selectors: [["mde-popover-target"], ["", "mdePopoverTarget", ""]],
  exportAs: ["mdePopoverTarget"]
});

MdePopoverTarget.ctorParameters = () => [{
  type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef
}];

let MdePopoverModule = class MdePopoverModule {};

MdePopoverModule.ɵfac = function MdePopoverModule_Factory(t) {
  return new (t || MdePopoverModule)();
};

MdePopoverModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
  type: MdePopoverModule
});
MdePopoverModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
  imports: [_angular_cdk_overlay__WEBPACK_IMPORTED_MODULE_8__.OverlayModule, _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_cdk_a11y__WEBPACK_IMPORTED_MODULE_5__.A11yModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](MdePopover, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Component,
    args: [{
      selector: 'mde-popover',
      template: "<ng-template>\n  <div class=\"mde-popover-panel\" role=\"dialog\" [class.mde-popover-overlap]=\"overlapTrigger\"\n       [ngClass]=\"_classList\" [ngStyle]=\"popoverPanelStyles\" (keydown)=\"_handleKeydown($event)\"\n       (click)=\"onClick()\" (mouseover)=\"onMouseOver()\" (mouseleave)=\"onMouseLeave()\" [@.disabled]=\"disableAnimation\"\n       [@transformPopover]=\"'enter'\">\n    <div class=\"mde-popover-direction-arrow\" [ngStyle]=\"popoverArrowStyles\" *ngIf=\"!overlapTrigger\"></div>\n    <div class=\"mde-popover-content\" [ngStyle]=\"popoverContentStyles\" [cdkTrapFocus]=\"focusTrapEnabled\" [cdkTrapFocusAutoCapture]=\"focusTrapAutoCaptureEnabled\">\n      <ng-content></ng-content>\n    </div>\n  </div>\n</ng-template>\n",
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectionStrategy.OnPush,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewEncapsulation.None,
      animations: [transformPopover],
      exportAs: 'mdePopover',
      styles: [".mde-popover-panel{display:flex;flex-direction:column;max-height:calc(100vh + 48px)}.mde-popover-ripple{position:absolute;top:0;left:0;bottom:0;right:0}.mde-popover-below .mde-popover-direction-arrow{position:absolute;bottom:0;width:0;height:0;border-bottom-width:0!important;z-index:99999}.mde-popover-above .mde-popover-direction-arrow{position:absolute;top:0;width:0;height:0;border-top-width:0!important;z-index:99999}.mde-popover-after .mde-popover-direction-arrow{left:20px}.mde-popover-before .mde-popover-direction-arrow{right:20px}"]
    }]
  }], function () {
    return [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone
    }];
  }, {
    role: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.HostBinding,
      args: ['attr.role']
    }],
    close: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Output
    }],
    positionX: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverPositionX']
    }],
    positionY: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverPositionY']
    }],
    triggerEvent: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverTriggerOn']
    }],
    enterDelay: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverEnterDelay']
    }],
    leaveDelay: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverLeaveDelay']
    }],
    overlapTrigger: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverOverlapTrigger']
    }],
    targetOffsetX: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverOffsetX']
    }],
    targetOffsetY: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverOffsetY']
    }],
    arrowOffsetX: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverArrowOffsetX']
    }],
    arrowWidth: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverArrowWidth']
    }],
    arrowColor: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverArrowColor']
    }],
    closeOnClick: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverCloseOnClick']
    }],
    disableAnimation: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverDisableAnimation']
    }],
    focusTrapEnabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdeFocusTrapEnabled']
    }],
    focusTrapAutoCaptureEnabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdeFocusTrapAutoCaptureEnabled']
    }],
    panelClass: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['class']
    }],
    classList: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input
    }],
    templateRef: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewChild,
      args: [_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef]
    }]
  });
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](MdePopoverTrigger, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Directive,
    args: [{
      selector: '[mdePopoverTriggerFor]',
      exportAs: 'mdePopoverTrigger'
    }]
  }], function () {
    return [{
      type: _angular_cdk_overlay__WEBPACK_IMPORTED_MODULE_8__.Overlay
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef
    }, {
      type: _angular_cdk_bidi__WEBPACK_IMPORTED_MODULE_9__.Directionality,
      decorators: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Optional
      }]
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef
    }];
  }, {
    ariaHaspopup: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.HostBinding,
      args: ['attr.aria-haspopup']
    }],
    backdropCloseOnClick: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverBackdropCloseOnClick']
    }],
    opened: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Output
    }],
    closed: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Output
    }],
    onClick: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.HostListener,
      args: ['click', ['$event']]
    }],
    onMouseEnter: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.HostListener,
      args: ['mouseenter', ['$event']]
    }],
    onMouseLeave: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.HostListener,
      args: ['mouseleave', ['$event']]
    }],
    _handleMousedown: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.HostListener,
      args: ['mousedown', ['$event']]
    }],
    popover: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverTriggerFor']
    }],
    targetElement: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverTargetAt']
    }],
    positionX: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverPositionX']
    }],
    positionY: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverPositionY']
    }],
    triggerEvent: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverTriggerOn']
    }],
    enterDelay: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverEnterDelay']
    }],
    leaveDelay: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverLeaveDelay']
    }],
    overlapTrigger: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverOverlapTrigger']
    }],
    targetOffsetX: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverOffsetX']
    }],
    targetOffsetY: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverOffsetY']
    }],
    arrowOffsetX: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverArrowOffsetX']
    }],
    arrowWidth: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverArrowWidth']
    }],
    arrowColor: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverArrowColor']
    }],
    closeOnClick: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['mdePopoverCloseOnClick']
    }]
  });
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](MdePopoverTarget, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Directive,
    args: [{
      selector: 'mde-popover-target, [mdePopoverTarget]',
      exportAs: 'mdePopoverTarget'
    }]
  }], function () {
    return [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef
    }];
  }, null);
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](MdePopoverModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgModule,
    args: [{
      imports: [_angular_cdk_overlay__WEBPACK_IMPORTED_MODULE_8__.OverlayModule, _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_cdk_a11y__WEBPACK_IMPORTED_MODULE_5__.A11yModule],
      exports: [MdePopover, MdePopoverTrigger, MdePopoverTarget],
      declarations: [MdePopover, MdePopoverTrigger, MdePopoverTarget]
    }]
  }], null, null);
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](MdePopoverModule, {
    declarations: function () {
      return [MdePopover, MdePopoverTrigger, MdePopoverTarget];
    },
    imports: function () {
      return [_angular_cdk_overlay__WEBPACK_IMPORTED_MODULE_8__.OverlayModule, _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_cdk_a11y__WEBPACK_IMPORTED_MODULE_5__.A11yModule];
    },
    exports: function () {
      return [MdePopover, MdePopoverTrigger, MdePopoverTarget];
    }
  });
})();
/*
 * Public API Surface of mde
 */

/**
 * Generated bundle index. Do not edit.
 */




/***/ }),

/***/ 9575:
/*!****************************************************************************************!*\
  !*** ./node_modules/@swimlane/ngx-charts/__ivy_ngcc__/fesm2015/swimlane-ngx-charts.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AdvancedLegendComponent": () => (/* binding */ AdvancedLegendComponent),
/* harmony export */   "AdvancedPieChartComponent": () => (/* binding */ AdvancedPieChartComponent),
/* harmony export */   "AlignmentTypes": () => (/* binding */ AlignmentTypes),
/* harmony export */   "AreaChartComponent": () => (/* binding */ AreaChartComponent),
/* harmony export */   "AreaChartModule": () => (/* binding */ AreaChartModule),
/* harmony export */   "AreaChartNormalizedComponent": () => (/* binding */ AreaChartNormalizedComponent),
/* harmony export */   "AreaChartStackedComponent": () => (/* binding */ AreaChartStackedComponent),
/* harmony export */   "AreaComponent": () => (/* binding */ AreaComponent),
/* harmony export */   "AreaSeriesComponent": () => (/* binding */ AreaSeriesComponent),
/* harmony export */   "AxesModule": () => (/* binding */ AxesModule),
/* harmony export */   "AxisLabelComponent": () => (/* binding */ AxisLabelComponent),
/* harmony export */   "BarChartModule": () => (/* binding */ BarChartModule),
/* harmony export */   "BarComponent": () => (/* binding */ BarComponent),
/* harmony export */   "BarHorizontal2DComponent": () => (/* binding */ BarHorizontal2DComponent),
/* harmony export */   "BarHorizontalComponent": () => (/* binding */ BarHorizontalComponent),
/* harmony export */   "BarHorizontalNormalizedComponent": () => (/* binding */ BarHorizontalNormalizedComponent),
/* harmony export */   "BarHorizontalStackedComponent": () => (/* binding */ BarHorizontalStackedComponent),
/* harmony export */   "BarLabelComponent": () => (/* binding */ BarLabelComponent),
/* harmony export */   "BarVertical2DComponent": () => (/* binding */ BarVertical2DComponent),
/* harmony export */   "BarVerticalComponent": () => (/* binding */ BarVerticalComponent),
/* harmony export */   "BarVerticalNormalizedComponent": () => (/* binding */ BarVerticalNormalizedComponent),
/* harmony export */   "BarVerticalStackedComponent": () => (/* binding */ BarVerticalStackedComponent),
/* harmony export */   "BaseChartComponent": () => (/* binding */ BaseChartComponent),
/* harmony export */   "BubbleChartComponent": () => (/* binding */ BubbleChartComponent),
/* harmony export */   "BubbleChartModule": () => (/* binding */ BubbleChartModule),
/* harmony export */   "BubbleSeriesComponent": () => (/* binding */ BubbleSeriesComponent),
/* harmony export */   "CardComponent": () => (/* binding */ CardComponent),
/* harmony export */   "CardSeriesComponent": () => (/* binding */ CardSeriesComponent),
/* harmony export */   "ChartCommonModule": () => (/* binding */ ChartCommonModule),
/* harmony export */   "ChartComponent": () => (/* binding */ ChartComponent),
/* harmony export */   "CircleComponent": () => (/* binding */ CircleComponent),
/* harmony export */   "CircleSeriesComponent": () => (/* binding */ CircleSeriesComponent),
/* harmony export */   "ColorHelper": () => (/* binding */ ColorHelper),
/* harmony export */   "CountUpDirective": () => (/* binding */ CountUpDirective),
/* harmony export */   "D0Types": () => (/* binding */ D0Types),
/* harmony export */   "GaugeArcComponent": () => (/* binding */ GaugeArcComponent),
/* harmony export */   "GaugeAxisComponent": () => (/* binding */ GaugeAxisComponent),
/* harmony export */   "GaugeComponent": () => (/* binding */ GaugeComponent),
/* harmony export */   "GaugeModule": () => (/* binding */ GaugeModule),
/* harmony export */   "GridPanelComponent": () => (/* binding */ GridPanelComponent),
/* harmony export */   "GridPanelSeriesComponent": () => (/* binding */ GridPanelSeriesComponent),
/* harmony export */   "HeatCellSeriesComponent": () => (/* binding */ HeatCellSeriesComponent),
/* harmony export */   "HeatMapCellComponent": () => (/* binding */ HeatMapCellComponent),
/* harmony export */   "HeatMapComponent": () => (/* binding */ HeatMapComponent),
/* harmony export */   "HeatMapModule": () => (/* binding */ HeatMapModule),
/* harmony export */   "LegendComponent": () => (/* binding */ LegendComponent),
/* harmony export */   "LegendEntryComponent": () => (/* binding */ LegendEntryComponent),
/* harmony export */   "LineChartComponent": () => (/* binding */ LineChartComponent),
/* harmony export */   "LineChartModule": () => (/* binding */ LineChartModule),
/* harmony export */   "LineComponent": () => (/* binding */ LineComponent),
/* harmony export */   "LineSeriesComponent": () => (/* binding */ LineSeriesComponent),
/* harmony export */   "LinearGaugeComponent": () => (/* binding */ LinearGaugeComponent),
/* harmony export */   "NgxChartsModule": () => (/* binding */ NgxChartsModule),
/* harmony export */   "NumberCardComponent": () => (/* binding */ NumberCardComponent),
/* harmony export */   "NumberCardModule": () => (/* binding */ NumberCardModule),
/* harmony export */   "PieArcComponent": () => (/* binding */ PieArcComponent),
/* harmony export */   "PieChartComponent": () => (/* binding */ PieChartComponent),
/* harmony export */   "PieChartModule": () => (/* binding */ PieChartModule),
/* harmony export */   "PieGridComponent": () => (/* binding */ PieGridComponent),
/* harmony export */   "PieGridSeriesComponent": () => (/* binding */ PieGridSeriesComponent),
/* harmony export */   "PieLabelComponent": () => (/* binding */ PieLabelComponent),
/* harmony export */   "PieSeriesComponent": () => (/* binding */ PieSeriesComponent),
/* harmony export */   "PlacementTypes": () => (/* binding */ PlacementTypes),
/* harmony export */   "PolarChartComponent": () => (/* binding */ PolarChartComponent),
/* harmony export */   "PolarChartModule": () => (/* binding */ PolarChartModule),
/* harmony export */   "PolarSeriesComponent": () => (/* binding */ PolarSeriesComponent),
/* harmony export */   "ScaleLegendComponent": () => (/* binding */ ScaleLegendComponent),
/* harmony export */   "SeriesHorizontal": () => (/* binding */ SeriesHorizontal),
/* harmony export */   "SeriesVerticalComponent": () => (/* binding */ SeriesVerticalComponent),
/* harmony export */   "ShowTypes": () => (/* binding */ ShowTypes),
/* harmony export */   "StyleTypes": () => (/* binding */ StyleTypes),
/* harmony export */   "SvgLinearGradientComponent": () => (/* binding */ SvgLinearGradientComponent),
/* harmony export */   "SvgRadialGradientComponent": () => (/* binding */ SvgRadialGradientComponent),
/* harmony export */   "Timeline": () => (/* binding */ Timeline),
/* harmony export */   "TooltipArea": () => (/* binding */ TooltipArea),
/* harmony export */   "TooltipContentComponent": () => (/* binding */ TooltipContentComponent),
/* harmony export */   "TooltipDirective": () => (/* binding */ TooltipDirective),
/* harmony export */   "TooltipModule": () => (/* binding */ TooltipModule),
/* harmony export */   "TooltipService": () => (/* binding */ TooltipService),
/* harmony export */   "TreeMapCellComponent": () => (/* binding */ TreeMapCellComponent),
/* harmony export */   "TreeMapCellSeriesComponent": () => (/* binding */ TreeMapCellSeriesComponent),
/* harmony export */   "TreeMapComponent": () => (/* binding */ TreeMapComponent),
/* harmony export */   "TreeMapModule": () => (/* binding */ TreeMapModule),
/* harmony export */   "VisibilityObserver": () => (/* binding */ VisibilityObserver),
/* harmony export */   "XAxisComponent": () => (/* binding */ XAxisComponent),
/* harmony export */   "XAxisTicksComponent": () => (/* binding */ XAxisTicksComponent),
/* harmony export */   "YAxisComponent": () => (/* binding */ YAxisComponent),
/* harmony export */   "YAxisTicksComponent": () => (/* binding */ YAxisTicksComponent),
/* harmony export */   "calculateViewDimensions": () => (/* binding */ calculateViewDimensions),
/* harmony export */   "colorSets": () => (/* binding */ colorSets),
/* harmony export */   "count": () => (/* binding */ count),
/* harmony export */   "decimalChecker": () => (/* binding */ decimalChecker),
/* harmony export */   "escapeLabel": () => (/* binding */ escapeLabel),
/* harmony export */   "formatLabel": () => (/* binding */ formatLabel),
/* harmony export */   "getDomain": () => (/* binding */ getDomain),
/* harmony export */   "getScale": () => (/* binding */ getScale),
/* harmony export */   "getScaleType": () => (/* binding */ getScaleType),
/* harmony export */   "getUniqueXDomainValues": () => (/* binding */ getUniqueXDomainValues),
/* harmony export */   "gridLayout": () => (/* binding */ gridLayout),
/* harmony export */   "gridSize": () => (/* binding */ gridSize),
/* harmony export */   "hexToRgb": () => (/* binding */ hexToRgb),
/* harmony export */   "id": () => (/* binding */ id),
/* harmony export */   "invertColor": () => (/* binding */ invertColor),
/* harmony export */   "reduceTicks": () => (/* binding */ reduceTicks),
/* harmony export */   "shadeRGBColor": () => (/* binding */ shadeRGBColor),
/* harmony export */   "sortByDomain": () => (/* binding */ sortByDomain),
/* harmony export */   "sortByTime": () => (/* binding */ sortByTime),
/* harmony export */   "sortLinear": () => (/* binding */ sortLinear),
/* harmony export */   "throttle": () => (/* binding */ throttle),
/* harmony export */   "throttleable": () => (/* binding */ throttleable),
/* harmony export */   "tickFormat": () => (/* binding */ tickFormat),
/* harmony export */   "trimLabel": () => (/* binding */ trimLabel),
/* harmony export */   "ɵa": () => (/* binding */ InjectionRegisteryService),
/* harmony export */   "ɵb": () => (/* binding */ InjectionService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ 94666);
/* harmony import */ var _angular_animations__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/animations */ 24851);
/* harmony import */ var _angular_cdk_portal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/cdk/portal */ 17520);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs */ 36312);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs/operators */ 80823);
/* harmony import */ var d3_selection__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! d3-selection */ 93884);
/* harmony import */ var d3_brush__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-brush */ 84542);
/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! d3-scale */ 70725);
/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! d3-scale */ 80000);
/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! d3-scale */ 97986);
/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! d3-scale */ 68641);
/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! d3-scale */ 6766);
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/platform-browser */ 34497);
/* harmony import */ var d3_shape__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! d3-shape */ 96093);
/* harmony import */ var d3_shape__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! d3-shape */ 38507);
/* harmony import */ var d3_shape__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! d3-shape */ 78500);
/* harmony import */ var d3_shape__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! d3-shape */ 86218);
/* harmony import */ var d3_shape__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! d3-shape */ 66314);
/* harmony import */ var d3_shape__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! d3-shape */ 13547);
/* harmony import */ var d3_shape__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! d3-shape */ 93873);
/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! d3-array */ 20182);
/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! d3-array */ 53766);
/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! d3-array */ 21552);
/* harmony import */ var d3_interpolate__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! d3-interpolate */ 73335);
/* harmony import */ var d3_format__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! d3-format */ 6467);
/* harmony import */ var d3_color__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! d3-color */ 21210);
/* harmony import */ var d3_hierarchy__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! d3-hierarchy */ 91226);
/* harmony import */ var d3_hierarchy__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! d3-hierarchy */ 77107);
/* harmony import */ var d3_time_format__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! d3-time-format */ 16893);





















const _c0 = ["caretElm"];

function TooltipContentComponent_span_4_ng_template_1_Template(rf, ctx) {}

const _c1 = function (a0) {
  return {
    model: a0
  };
};

function TooltipContentComponent_span_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, TooltipContentComponent_span_4_ng_template_1_Template, 0, 0, "ng-template", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngTemplateOutlet", ctx_r1.template)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](2, _c1, ctx_r1.context));
  }
}

function TooltipContentComponent_span_5_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "span", 6);
  }

  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("innerHTML", ctx_r2.title, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeHtml"]);
  }
}

function ChartComponent_ngx_charts_scale_legend_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceHTML"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "ngx-charts-scale-legend", 4);
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("horizontal", ctx_r0.legendOptions && ctx_r0.legendOptions.position === "below")("valueRange", ctx_r0.legendOptions.domain)("colors", ctx_r0.legendOptions.colors)("height", ctx_r0.view[1])("width", ctx_r0.legendWidth);
  }
}

function ChartComponent_ngx_charts_legend_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceHTML"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "ngx-charts-legend", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("labelClick", function ChartComponent_ngx_charts_legend_4_Template_ngx_charts_legend_labelClick_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r2.legendLabelClick.emit($event));
    })("labelActivate", function ChartComponent_ngx_charts_legend_4_Template_ngx_charts_legend_labelActivate_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r4.legendLabelActivate.emit($event));
    })("labelDeactivate", function ChartComponent_ngx_charts_legend_4_Template_ngx_charts_legend_labelDeactivate_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.legendLabelDeactivate.emit($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("horizontal", ctx_r1.legendOptions && ctx_r1.legendOptions.position === "below")("data", ctx_r1.legendOptions.domain)("title", ctx_r1.legendOptions.title)("colors", ctx_r1.legendOptions.colors)("height", ctx_r1.view[1])("width", ctx_r1.legendWidth)("activeEntries", ctx_r1.activeEntries);
  }
}

const _c2 = ["*"];
const _c3 = ["ngx-charts-axis-label", ""];
const _c4 = ["ticksel"];
const _c5 = ["ngx-charts-x-axis-ticks", ""];

function XAxisTicksComponent__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 3)(1, "title");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "text", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const tick_r3 = ctx.$implicit;
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r1.tickTransform(tick_r3));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.tickFormat(tick_r3));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("font-size", "12px");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("text-anchor", ctx_r1.textAnchor)("transform", ctx_r1.textTransform);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx_r1.tickTrim(ctx_r1.tickFormat(tick_r3)), " ");
  }
}

function XAxisTicksComponent__svg_g_3__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "line", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r5.gridLineTransform());
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("y1", -ctx_r5.gridLineHeight);
  }
}

function XAxisTicksComponent__svg_g_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, XAxisTicksComponent__svg_g_3__svg_g_1_Template, 2, 2, "g", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const tick_r4 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r2.tickTransform(tick_r4));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r2.showGridLines);
  }
}

const _c6 = ["ngx-charts-x-axis", ""];

function XAxisComponent__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function XAxisComponent__svg_g_1_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r2.emitTicksHeight($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("trimTicks", ctx_r0.trimTicks)("rotateTicks", ctx_r0.rotateTicks)("maxTickLength", ctx_r0.maxTickLength)("tickFormatting", ctx_r0.tickFormatting)("tickArguments", ctx_r0.tickArguments)("tickStroke", ctx_r0.tickStroke)("scale", ctx_r0.xScale)("orient", ctx_r0.xOrient)("showGridLines", ctx_r0.showGridLines)("gridLineHeight", ctx_r0.dims.height)("width", ctx_r0.dims.width)("tickValues", ctx_r0.ticks);
  }
}

function XAxisComponent__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "g", 3);
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("label", ctx_r1.labelText)("offset", ctx_r1.labelOffset)("orient", "bottom")("height", ctx_r1.dims.height)("width", ctx_r1.dims.width);
  }
}

const _c7 = ["ngx-charts-y-axis-ticks", ""];

function YAxisTicksComponent__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 4)(1, "title");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "text", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const tick_r5 = ctx.$implicit;
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r1.transform(tick_r5));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r1.tickFormat(tick_r5));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("font-size", "12px");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("dy", ctx_r1.dy)("x", ctx_r1.x1)("y", ctx_r1.y1)("text-anchor", ctx_r1.textAnchor);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx_r1.tickTrim(ctx_r1.tickFormat(tick_r5)), " ");
  }
}

function YAxisTicksComponent__svg_path_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "path", 6);
  }

  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("d", ctx_r2.referenceAreaPath)("transform", ctx_r2.gridLineTransform());
  }
}

function YAxisTicksComponent__svg_g_4__svg_g_1__svg_line_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "line", 9);
  }

  if (rf & 2) {
    const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("x2", ctx_r8.gridLineWidth);
  }
}

function YAxisTicksComponent__svg_g_4__svg_g_1__svg_line_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "line", 9);
  }

  if (rf & 2) {
    const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("x2", -ctx_r9.gridLineWidth);
  }
}

function YAxisTicksComponent__svg_g_4__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, YAxisTicksComponent__svg_g_4__svg_g_1__svg_line_1_Template, 1, 1, "line", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, YAxisTicksComponent__svg_g_4__svg_g_1__svg_line_2_Template, 1, 1, "line", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r7.gridLineTransform());
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r7.orient === "left");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r7.orient === "right");
  }
}

function YAxisTicksComponent__svg_g_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, YAxisTicksComponent__svg_g_4__svg_g_1_Template, 3, 3, "g", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const tick_r6 = ctx.$implicit;
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r3.transform(tick_r6));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r3.showGridLines);
  }
}

function YAxisTicksComponent__svg_g_5__svg_g_1__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g")(1, "title");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "text", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const refLine_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2).$implicit;
    const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r12.tickTrim(ctx_r12.tickFormat(refLine_r10.value)));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("dy", ctx_r12.dy)("y", -6)("x", ctx_r12.gridLineWidth)("text-anchor", ctx_r12.textAnchor);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", refLine_r10.name, " ");
  }
}

function YAxisTicksComponent__svg_g_5__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "line", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, YAxisTicksComponent__svg_g_5__svg_g_1__svg_g_2_Template, 5, 6, "g", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const refLine_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r11.transform(refLine_r10.value));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("x2", ctx_r11.gridLineWidth)("transform", ctx_r11.gridLineTransform());
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r11.showRefLabels);
  }
}

function YAxisTicksComponent__svg_g_5_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, YAxisTicksComponent__svg_g_5__svg_g_1_Template, 3, 4, "g", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r4.showRefLines);
  }
}

const _c8 = ["ngx-charts-y-axis", ""];

function YAxisComponent__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function YAxisComponent__svg_g_1_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r2.emitTicksWidth($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("trimTicks", ctx_r0.trimTicks)("maxTickLength", ctx_r0.maxTickLength)("tickFormatting", ctx_r0.tickFormatting)("tickArguments", ctx_r0.tickArguments)("tickValues", ctx_r0.ticks)("tickStroke", ctx_r0.tickStroke)("scale", ctx_r0.yScale)("orient", ctx_r0.yOrient)("showGridLines", ctx_r0.showGridLines)("gridLineWidth", ctx_r0.dims.width)("referenceLines", ctx_r0.referenceLines)("showRefLines", ctx_r0.showRefLines)("showRefLabels", ctx_r0.showRefLabels)("height", ctx_r0.dims.height);
  }
}

function YAxisComponent__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "g", 3);
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("label", ctx_r1.labelText)("offset", ctx_r1.labelOffset)("orient", ctx_r1.yOrient)("height", ctx_r1.dims.height)("width", ctx_r1.dims.width);
  }
}

const _c9 = ["ngx-charts-circle-series", ""];

function CircleSeriesComponent__svg_g_0__svg_rect_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "rect", 4);
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("@animationState", "active");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("x", ctx_r1.circle.cx - ctx_r1.circle.radius)("y", ctx_r1.circle.cy)("width", ctx_r1.circle.radius * 2)("height", ctx_r1.circle.height)("fill", ctx_r1.gradientFill);
  }
}

const _c10 = function (a0) {
  return {
    name: a0
  };
};

function CircleSeriesComponent__svg_g_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g")(1, "defs");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](2, "g", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, CircleSeriesComponent__svg_g_0__svg_rect_3_Template, 1, 6, "rect", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "g", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function CircleSeriesComponent__svg_g_0_Template__svg_g_select_4_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r2.onClick(ctx_r2.circle.data));
    })("activate", function CircleSeriesComponent__svg_g_0_Template__svg_g_activate_4_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r4.activateCircle());
    })("deactivate", function CircleSeriesComponent__svg_g_0_Template__svg_g_deactivate_4_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.deactivateCircle());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("name", ctx_r0.gradientId)("stops", ctx_r0.circle.gradientStops);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r0.barVisible && ctx_r0.type === "standard");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("active", ctx_r0.isActive(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](18, _c10, ctx_r0.circle.seriesName)));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("cx", ctx_r0.circle.cx)("cy", ctx_r0.circle.cy)("r", ctx_r0.circle.radius)("fill", ctx_r0.circle.color)("pointerEvents", ctx_r0.circle.value === 0 ? "none" : "all")("data", ctx_r0.circle.value)("classNames", ctx_r0.circle.classNames)("tooltipDisabled", ctx_r0.tooltipDisabled)("tooltipPlacement", "top")("tooltipType", "tooltip")("tooltipTitle", ctx_r0.tooltipTemplate ? undefined : ctx_r0.getTooltipText(ctx_r0.circle))("tooltipTemplate", ctx_r0.tooltipTemplate)("tooltipContext", ctx_r0.circle.data);
  }
}

const _c11 = ["ngx-charts-circle", ""];
const _c12 = ["ngx-charts-grid-panel", ""];
const _c13 = ["ngx-charts-grid-panel-series", ""];

function GridPanelSeriesComponent__svg_g_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "g", 1);
  }

  if (rf & 2) {
    const gridPanel_r1 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("grid-panel", true)("odd", gridPanel_r1.class === "odd")("even", gridPanel_r1.class === "even");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("height", gridPanel_r1.height)("width", gridPanel_r1.width)("x", gridPanel_r1.x)("y", gridPanel_r1.y);
  }
}

const _c14 = ["ngx-charts-svg-linear-gradient", ""];

function SvgLinearGradientComponent__svg_stop_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "stop");
  }

  if (rf & 2) {
    const stop_r1 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("stop-color", stop_r1.color)("stop-opacity", stop_r1.opacity);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("offset", stop_r1.offset + "%");
  }
}

const _c15 = ["ngx-charts-svg-radial-gradient", ""];

function SvgRadialGradientComponent__svg_stop_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "stop");
  }

  if (rf & 2) {
    const stop_r1 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("stop-color", stop_r1.color)("stop-opacity", stop_r1.opacity);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("offset", stop_r1.offset + "%");
  }
}

const _c16 = ["ngx-charts-area", ""];

function AreaComponent__svg_defs_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "defs");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "g", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("name", ctx_r0.gradientId)("stops", ctx_r0.gradientStops);
  }
}

const _c17 = ["ngx-charts-count-up", ""];
const _c18 = ["tooltipAnchor"];
const _c19 = ["ngx-charts-tooltip-area", ""];

function TooltipArea__svg_ng_template_2__xhtml_div_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "span", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const tooltipItem_r5 = ctx.$implicit;
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("background-color", tooltipItem_r5.color);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx_r4.getToolTipText(tooltipItem_r5), " ");
  }
}

function TooltipArea__svg_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceHTML"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, TooltipArea__svg_ng_template_2__xhtml_div_1_Template, 3, 3, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const model_r3 = ctx.model;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", model_r3);
  }
}

const _c20 = ["ngx-charts-timeline", ""];

function LegendComponent_header_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "header", 4)(1, "span", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r0.title);
  }
}

function LegendComponent_li_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "li", 6)(1, "ngx-charts-legend-entry", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function LegendComponent_li_4_Template_ngx_charts_legend_entry_select_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r3.labelClick.emit($event));
    })("activate", function LegendComponent_li_4_Template_ngx_charts_legend_entry_activate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.activate($event));
    })("deactivate", function LegendComponent_li_4_Template_ngx_charts_legend_entry_deactivate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r6.deactivate($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const entry_r2 = ctx.$implicit;
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("label", entry_r2.label)("formattedLabel", entry_r2.formattedLabel)("color", entry_r2.color)("isActive", ctx_r1.isActive(entry_r2));
  }
}

function AdvancedLegendComponent_div_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "div", 7);
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("countTo", ctx_r0.roundedTotal)("valueFormatting", ctx_r0.valueFormatting);
  }
}

function AdvancedLegendComponent_div_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx_r1.valueFormatting ? ctx_r1.valueFormatting(ctx_r1.roundedTotal) : ctx_r1.defaultValueFormatting(ctx_r1.roundedTotal), " ");
  }
}

function AdvancedLegendComponent_div_7_div_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "div", 16);
  }

  if (rf & 2) {
    const legendItem_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("countTo", legendItem_r3._value)("valueFormatting", ctx_r4.valueFormatting);
  }
}

function AdvancedLegendComponent_div_7_div_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const legendItem_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx_r5.valueFormatting ? ctx_r5.valueFormatting(legendItem_r3.value) : ctx_r5.defaultValueFormatting(legendItem_r3.value), " ");
  }
}

function AdvancedLegendComponent_div_7_div_6_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "div", 18);
  }

  if (rf & 2) {
    const legendItem_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("countTo", legendItem_r3.percentage)("countSuffix", "%");
  }
}

function AdvancedLegendComponent_div_7_div_7_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const legendItem_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", legendItem_r3.percentage.toLocaleString(), "%");
  }
}

function AdvancedLegendComponent_div_7_Template(rf, ctx) {
  if (rf & 1) {
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("mouseenter", function AdvancedLegendComponent_div_7_Template_div_mouseenter_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const legendItem_r3 = restoredCtx.$implicit;
      const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r12.activate.emit(legendItem_r3.data));
    })("mouseleave", function AdvancedLegendComponent_div_7_Template_div_mouseleave_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const legendItem_r3 = restoredCtx.$implicit;
      const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r14.deactivate.emit(legendItem_r3.data));
    })("click", function AdvancedLegendComponent_div_7_Template_div_click_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const legendItem_r3 = restoredCtx.$implicit;
      const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r15.select.emit(legendItem_r3.data));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, AdvancedLegendComponent_div_7_div_2_Template, 1, 2, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, AdvancedLegendComponent_div_7_div_3_Template, 2, 1, "div", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "div", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](6, AdvancedLegendComponent_div_7_div_6_Template, 1, 2, "div", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](7, AdvancedLegendComponent_div_7_div_7_Template, 2, 1, "div", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const legendItem_r3 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("border-left-color", legendItem_r3.color);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r2.animations);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx_r2.animations);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](legendItem_r3.displayLabel);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r2.animations);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx_r2.animations);
  }
}

const _c21 = ["tooltipTemplate"];
const _c22 = ["seriesTooltipTemplate"];

function AreaChartComponent__svg_g_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function AreaChartComponent__svg_g_5_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r6);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.updateXAxisHeight($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r0.xScale)("dims", ctx_r0.dims)("showGridLines", ctx_r0.showGridLines)("showLabel", ctx_r0.showXAxisLabel)("labelText", ctx_r0.xAxisLabel)("trimTicks", ctx_r0.trimXAxisTicks)("rotateTicks", ctx_r0.rotateXAxisTicks)("maxTickLength", ctx_r0.maxXAxisTickLength)("tickFormatting", ctx_r0.xAxisTickFormatting)("ticks", ctx_r0.xAxisTicks);
  }
}

function AreaChartComponent__svg_g_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function AreaChartComponent__svg_g_6_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r8);
      const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r7.updateYAxisWidth($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("yScale", ctx_r1.yScale)("dims", ctx_r1.dims)("showGridLines", ctx_r1.showGridLines)("showLabel", ctx_r1.showYAxisLabel)("labelText", ctx_r1.yAxisLabel)("trimTicks", ctx_r1.trimYAxisTicks)("maxTickLength", ctx_r1.maxYAxisTickLength)("tickFormatting", ctx_r1.yAxisTickFormatting)("ticks", ctx_r1.yAxisTicks);
  }
}

function AreaChartComponent__svg_g_8_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "g", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const series_r9 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r2.xScale)("yScale", ctx_r2.yScale)("baseValue", ctx_r2.baseValue)("colors", ctx_r2.colors)("data", series_r9)("activeEntries", ctx_r2.activeEntries)("scaleType", ctx_r2.scaleType)("gradient", ctx_r2.gradient)("curve", ctx_r2.curve)("animations", ctx_r2.animations);
  }
}

function AreaChartComponent__svg_g_9__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g")(1, "g", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function AreaChartComponent__svg_g_9__svg_g_2_Template__svg_g_select_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const series_r11 = restoredCtx.$implicit;
      const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r12.onClick($event, series_r11));
    })("activate", function AreaChartComponent__svg_g_9__svg_g_2_Template__svg_g_activate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r14.onActivate($event));
    })("deactivate", function AreaChartComponent__svg_g_9__svg_g_2_Template__svg_g_deactivate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r15.onDeactivate($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const series_r11 = ctx.$implicit;
    const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r10.xScale)("yScale", ctx_r10.yScale)("colors", ctx_r10.colors)("activeEntries", ctx_r10.activeEntries)("data", series_r11)("scaleType", ctx_r10.scaleType)("visibleValue", ctx_r10.hoveredVertical)("tooltipDisabled", ctx_r10.tooltipDisabled)("tooltipTemplate", ctx_r10.tooltipTemplate);
  }
}

function AreaChartComponent__svg_g_9_Template(rf, ctx) {
  if (rf & 1) {
    const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("mouseleave", function AreaChartComponent__svg_g_9_Template__svg_g_mouseleave_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r17);
      const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r16.hideCircles());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "g", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("hover", function AreaChartComponent__svg_g_9_Template__svg_g_hover_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r17);
      const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r18.updateHoveredVertical($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, AreaChartComponent__svg_g_9__svg_g_2_Template, 2, 9, "g", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("dims", ctx_r3.dims)("xSet", ctx_r3.xSet)("xScale", ctx_r3.xScale)("yScale", ctx_r3.yScale)("results", ctx_r3.results)("colors", ctx_r3.colors)("tooltipDisabled", ctx_r3.tooltipDisabled)("tooltipTemplate", ctx_r3.seriesTooltipTemplate);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r3.results);
  }
}

function AreaChartComponent__svg_g_10__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "g", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const series_r20 = ctx.$implicit;
    const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r19.timelineXScale)("yScale", ctx_r19.timelineYScale)("baseValue", ctx_r19.baseValue)("colors", ctx_r19.colors)("data", series_r20)("scaleType", ctx_r19.scaleType)("gradient", ctx_r19.gradient)("curve", ctx_r19.curve)("animations", ctx_r19.animations);
  }
}

const _c23 = function (a0, a1) {
  return [a0, a1];
};

function AreaChartComponent__svg_g_10_Template(rf, ctx) {
  if (rf & 1) {
    const _r22 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("onDomainChange", function AreaChartComponent__svg_g_10_Template__svg_g_onDomainChange_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r22);
      const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r21.updateDomain($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, AreaChartComponent__svg_g_10__svg_g_1_Template, 2, 9, "g", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("results", ctx_r4.results)("view", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](10, _c23, ctx_r4.timelineWidth, ctx_r4.height))("height", ctx_r4.timelineHeight)("scheme", ctx_r4.scheme)("customColors", ctx_r4.customColors)("legend", ctx_r4.legend)("scaleType", ctx_r4.scaleType);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r4.timelineTransform);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r4.results)("ngForTrackBy", ctx_r4.trackBy);
  }
}

function AreaChartNormalizedComponent__svg_g_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function AreaChartNormalizedComponent__svg_g_5_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r6);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.updateXAxisHeight($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r0.xScale)("dims", ctx_r0.dims)("showGridLines", ctx_r0.showGridLines)("showLabel", ctx_r0.showXAxisLabel)("labelText", ctx_r0.xAxisLabel)("trimTicks", ctx_r0.trimXAxisTicks)("rotateTicks", ctx_r0.rotateXAxisTicks)("maxTickLength", ctx_r0.maxXAxisTickLength)("tickFormatting", ctx_r0.xAxisTickFormatting)("ticks", ctx_r0.xAxisTicks);
  }
}

function AreaChartNormalizedComponent__svg_g_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function AreaChartNormalizedComponent__svg_g_6_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r8);
      const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r7.updateYAxisWidth($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("yScale", ctx_r1.yScale)("dims", ctx_r1.dims)("showGridLines", ctx_r1.showGridLines)("showLabel", ctx_r1.showYAxisLabel)("labelText", ctx_r1.yAxisLabel)("trimTicks", ctx_r1.trimYAxisTicks)("maxTickLength", ctx_r1.maxYAxisTickLength)("tickFormatting", ctx_r1.yAxisTickFormatting)("ticks", ctx_r1.yAxisTicks);
  }
}

function AreaChartNormalizedComponent__svg_g_8_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "g", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const series_r9 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r2.xScale)("yScale", ctx_r2.yScale)("colors", ctx_r2.colors)("data", series_r9)("scaleType", ctx_r2.scaleType)("activeEntries", ctx_r2.activeEntries)("gradient", ctx_r2.gradient)("curve", ctx_r2.curve)("animations", ctx_r2.animations);
  }
}

function AreaChartNormalizedComponent__svg_g_9__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g")(1, "g", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function AreaChartNormalizedComponent__svg_g_9__svg_g_2_Template__svg_g_select_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const series_r11 = restoredCtx.$implicit;
      const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r12.onClick($event, series_r11));
    })("activate", function AreaChartNormalizedComponent__svg_g_9__svg_g_2_Template__svg_g_activate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r14.onActivate($event));
    })("deactivate", function AreaChartNormalizedComponent__svg_g_9__svg_g_2_Template__svg_g_deactivate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r15.onDeactivate($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const series_r11 = ctx.$implicit;
    const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r10.xScale)("yScale", ctx_r10.yScale)("colors", ctx_r10.colors)("activeEntries", ctx_r10.activeEntries)("data", series_r11)("scaleType", ctx_r10.scaleType)("visibleValue", ctx_r10.hoveredVertical)("tooltipDisabled", ctx_r10.tooltipDisabled)("tooltipTemplate", ctx_r10.tooltipTemplate);
  }
}

function AreaChartNormalizedComponent__svg_g_9_Template(rf, ctx) {
  if (rf & 1) {
    const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("mouseleave", function AreaChartNormalizedComponent__svg_g_9_Template__svg_g_mouseleave_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r17);
      const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r16.hideCircles());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "g", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("hover", function AreaChartNormalizedComponent__svg_g_9_Template__svg_g_hover_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r17);
      const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r18.updateHoveredVertical($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, AreaChartNormalizedComponent__svg_g_9__svg_g_2_Template, 2, 9, "g", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("dims", ctx_r3.dims)("xSet", ctx_r3.xSet)("xScale", ctx_r3.xScale)("yScale", ctx_r3.yScale)("results", ctx_r3.results)("colors", ctx_r3.colors)("showPercentage", true)("tooltipDisabled", ctx_r3.tooltipDisabled)("tooltipTemplate", ctx_r3.seriesTooltipTemplate);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r3.results);
  }
}

function AreaChartNormalizedComponent__svg_g_10__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "g", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const series_r20 = ctx.$implicit;
    const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r19.timelineXScale)("yScale", ctx_r19.timelineYScale)("colors", ctx_r19.colors)("data", series_r20)("scaleType", ctx_r19.scaleType)("gradient", ctx_r19.gradient)("curve", ctx_r19.curve)("animations", ctx_r19.animations);
  }
}

function AreaChartNormalizedComponent__svg_g_10_Template(rf, ctx) {
  if (rf & 1) {
    const _r22 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("onDomainChange", function AreaChartNormalizedComponent__svg_g_10_Template__svg_g_onDomainChange_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r22);
      const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r21.updateDomain($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, AreaChartNormalizedComponent__svg_g_10__svg_g_1_Template, 2, 8, "g", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("results", ctx_r4.results)("view", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](10, _c23, ctx_r4.timelineWidth, ctx_r4.height))("height", ctx_r4.timelineHeight)("scheme", ctx_r4.scheme)("customColors", ctx_r4.customColors)("legend", ctx_r4.legend)("scaleType", ctx_r4.scaleType);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r4.timelineTransform);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r4.results)("ngForTrackBy", ctx_r4.trackBy);
  }
}

const _c24 = ".ngx-charts{float:left;overflow:visible}.ngx-charts .arc,.ngx-charts .bar,.ngx-charts .circle{cursor:pointer}.ngx-charts .arc.active,.ngx-charts .arc:hover,.ngx-charts .bar.active,.ngx-charts .bar:hover,.ngx-charts .card.active,.ngx-charts .card:hover,.ngx-charts .cell.active,.ngx-charts .cell:hover{opacity:.8;transition:opacity .1s ease-in-out}.ngx-charts .arc:focus,.ngx-charts .bar:focus,.ngx-charts .card:focus,.ngx-charts .cell:focus{outline:none}.ngx-charts .arc.hidden,.ngx-charts .bar.hidden,.ngx-charts .card.hidden,.ngx-charts .cell.hidden{display:none}.ngx-charts g:focus{outline:none}.ngx-charts .area-series.inactive,.ngx-charts .line-series-range.inactive,.ngx-charts .line-series.inactive,.ngx-charts .polar-series-area.inactive,.ngx-charts .polar-series-path.inactive{opacity:.2;transition:opacity .1s ease-in-out}.ngx-charts .line-highlight{display:none}.ngx-charts .line-highlight.active{display:block}.ngx-charts .area{opacity:.6}.ngx-charts .circle:hover{cursor:pointer}.ngx-charts .label{font-size:12px;font-weight:400}.ngx-charts .tooltip-anchor{fill:#000}.ngx-charts .gridline-path{fill:none;stroke:#ddd;stroke-width:1}.ngx-charts .refline-path{stroke:#a8b2c7;stroke-dasharray:5;stroke-dashoffset:5;stroke-width:1}.ngx-charts .refline-label{font-size:9px}.ngx-charts .reference-area{fill:#000;fill-opacity:.05}.ngx-charts .gridline-path-dotted{fill:none;stroke:#ddd;stroke-dasharray:1,20;stroke-dashoffset:3;stroke-width:1}.ngx-charts .grid-panel rect{fill:none}.ngx-charts .grid-panel.odd rect{fill:rgba(0,0,0,.05)}";

function AreaChartStackedComponent__svg_g_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function AreaChartStackedComponent__svg_g_5_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r6);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.updateXAxisHeight($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r0.xScale)("dims", ctx_r0.dims)("showGridLines", ctx_r0.showGridLines)("showLabel", ctx_r0.showXAxisLabel)("labelText", ctx_r0.xAxisLabel)("trimTicks", ctx_r0.trimXAxisTicks)("rotateTicks", ctx_r0.rotateXAxisTicks)("maxTickLength", ctx_r0.maxXAxisTickLength)("tickFormatting", ctx_r0.xAxisTickFormatting)("ticks", ctx_r0.xAxisTicks);
  }
}

function AreaChartStackedComponent__svg_g_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function AreaChartStackedComponent__svg_g_6_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r8);
      const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r7.updateYAxisWidth($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("yScale", ctx_r1.yScale)("dims", ctx_r1.dims)("showGridLines", ctx_r1.showGridLines)("showLabel", ctx_r1.showYAxisLabel)("labelText", ctx_r1.yAxisLabel)("trimTicks", ctx_r1.trimYAxisTicks)("maxTickLength", ctx_r1.maxYAxisTickLength)("tickFormatting", ctx_r1.yAxisTickFormatting)("ticks", ctx_r1.yAxisTicks);
  }
}

function AreaChartStackedComponent__svg_g_8_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "g", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const series_r9 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r2.xScale)("yScale", ctx_r2.yScale)("colors", ctx_r2.colors)("data", series_r9)("scaleType", ctx_r2.scaleType)("gradient", ctx_r2.gradient)("activeEntries", ctx_r2.activeEntries)("curve", ctx_r2.curve)("animations", ctx_r2.animations);
  }
}

function AreaChartStackedComponent__svg_g_9__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g")(1, "g", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function AreaChartStackedComponent__svg_g_9__svg_g_2_Template__svg_g_select_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const series_r11 = restoredCtx.$implicit;
      const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r12.onClick($event, series_r11));
    })("activate", function AreaChartStackedComponent__svg_g_9__svg_g_2_Template__svg_g_activate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r14.onActivate($event));
    })("deactivate", function AreaChartStackedComponent__svg_g_9__svg_g_2_Template__svg_g_deactivate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r15.onDeactivate($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const series_r11 = ctx.$implicit;
    const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r10.xScale)("yScale", ctx_r10.yScale)("colors", ctx_r10.colors)("activeEntries", ctx_r10.activeEntries)("data", series_r11)("scaleType", ctx_r10.scaleType)("visibleValue", ctx_r10.hoveredVertical)("tooltipDisabled", ctx_r10.tooltipDisabled)("tooltipTemplate", ctx_r10.tooltipTemplate);
  }
}

function AreaChartStackedComponent__svg_g_9_Template(rf, ctx) {
  if (rf & 1) {
    const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("mouseleave", function AreaChartStackedComponent__svg_g_9_Template__svg_g_mouseleave_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r17);
      const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r16.hideCircles());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "g", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("hover", function AreaChartStackedComponent__svg_g_9_Template__svg_g_hover_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r17);
      const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r18.updateHoveredVertical($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, AreaChartStackedComponent__svg_g_9__svg_g_2_Template, 2, 9, "g", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("dims", ctx_r3.dims)("xSet", ctx_r3.xSet)("xScale", ctx_r3.xScale)("yScale", ctx_r3.yScale)("results", ctx_r3.results)("colors", ctx_r3.colors)("tooltipDisabled", ctx_r3.tooltipDisabled)("tooltipTemplate", ctx_r3.seriesTooltipTemplate);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r3.results)("ngForTrackBy", ctx_r3.trackBy);
  }
}

function AreaChartStackedComponent__svg_g_10__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "g", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const series_r20 = ctx.$implicit;
    const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r19.timelineXScale)("yScale", ctx_r19.timelineYScale)("colors", ctx_r19.colors)("data", series_r20)("scaleType", ctx_r19.scaleType)("gradient", ctx_r19.gradient)("curve", ctx_r19.curve)("animations", ctx_r19.animations);
  }
}

function AreaChartStackedComponent__svg_g_10_Template(rf, ctx) {
  if (rf & 1) {
    const _r22 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("onDomainChange", function AreaChartStackedComponent__svg_g_10_Template__svg_g_onDomainChange_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r22);
      const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r21.updateDomain($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, AreaChartStackedComponent__svg_g_10__svg_g_1_Template, 2, 8, "g", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("results", ctx_r4.results)("view", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](10, _c23, ctx_r4.timelineWidth, ctx_r4.height))("height", ctx_r4.timelineHeight)("scheme", ctx_r4.scheme)("customColors", ctx_r4.customColors)("legend", ctx_r4.legend)("scaleType", ctx_r4.scaleType);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r4.timelineTransform);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r4.results)("ngForTrackBy", ctx_r4.trackBy);
  }
}

const _c25 = ["ngx-charts-area-series", ""];
const _c26 = ["ngx-charts-bar", ""];

function BarComponent__svg_defs_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "defs");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "g", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("orientation", ctx_r0.orientation)("name", ctx_r0.gradientId)("stops", ctx_r0.gradientStops);
  }
}

function BarHorizontalComponent__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BarHorizontalComponent__svg_g_2_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r2.updateXAxisHeight($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r0.xScale)("dims", ctx_r0.dims)("showGridLines", ctx_r0.showGridLines)("showLabel", ctx_r0.showXAxisLabel)("labelText", ctx_r0.xAxisLabel)("trimTicks", ctx_r0.trimXAxisTicks)("rotateTicks", ctx_r0.rotateXAxisTicks)("maxTickLength", ctx_r0.maxXAxisTickLength)("tickFormatting", ctx_r0.xAxisTickFormatting)("ticks", ctx_r0.xAxisTicks);
  }
}

function BarHorizontalComponent__svg_g_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BarHorizontalComponent__svg_g_3_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r5);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r4.updateYAxisWidth($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("yScale", ctx_r1.yScale)("dims", ctx_r1.dims)("showLabel", ctx_r1.showYAxisLabel)("labelText", ctx_r1.yAxisLabel)("trimTicks", ctx_r1.trimYAxisTicks)("maxTickLength", ctx_r1.maxYAxisTickLength)("tickFormatting", ctx_r1.yAxisTickFormatting)("ticks", ctx_r1.yAxisTicks)("yAxisOffset", ctx_r1.dataLabelMaxWidth.negative);
  }
}

function BarHorizontal2DComponent__svg_g_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BarHorizontal2DComponent__svg_g_3_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r3.updateXAxisHeight($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r0.valueScale)("dims", ctx_r0.dims)("showGridLines", ctx_r0.showGridLines)("showLabel", ctx_r0.showXAxisLabel)("labelText", ctx_r0.xAxisLabel)("trimTicks", ctx_r0.trimXAxisTicks)("rotateTicks", ctx_r0.rotateXAxisTicks)("maxTickLength", ctx_r0.maxXAxisTickLength)("tickFormatting", ctx_r0.xAxisTickFormatting)("ticks", ctx_r0.xAxisTicks);
  }
}

function BarHorizontal2DComponent__svg_g_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BarHorizontal2DComponent__svg_g_4_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r6);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.updateYAxisWidth($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("yScale", ctx_r1.groupScale)("dims", ctx_r1.dims)("showLabel", ctx_r1.showYAxisLabel)("labelText", ctx_r1.yAxisLabel)("trimTicks", ctx_r1.trimYAxisTicks)("maxTickLength", ctx_r1.maxYAxisTickLength)("tickFormatting", ctx_r1.yAxisTickFormatting)("ticks", ctx_r1.yAxisTicks)("yAxisOffset", ctx_r1.dataLabelMaxWidth.negative);
  }
}

function BarHorizontal2DComponent__svg_g_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g")(1, "g", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function BarHorizontal2DComponent__svg_g_5_Template__svg_g_select_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r9.onClick($event, group_r7));
    })("activate", function BarHorizontal2DComponent__svg_g_5_Template__svg_g_activate_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r11.onActivate($event, group_r7));
    })("deactivate", function BarHorizontal2DComponent__svg_g_5_Template__svg_g_deactivate_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r12.onDeactivate($event, group_r7));
    })("dataLabelWidthChanged", function BarHorizontal2DComponent__svg_g_5_Template__svg_g_dataLabelWidthChanged_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const index_r8 = restoredCtx.index;
      const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r13.onDataLabelMaxWidthChanged($event, index_r8));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const group_r7 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("@animationState", "active");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r2.groupTransform(group_r7));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r2.valueScale)("activeEntries", ctx_r2.activeEntries)("yScale", ctx_r2.innerScale)("colors", ctx_r2.colors)("series", group_r7.series)("dims", ctx_r2.dims)("gradient", ctx_r2.gradient)("tooltipDisabled", ctx_r2.tooltipDisabled)("tooltipTemplate", ctx_r2.tooltipTemplate)("seriesName", group_r7.name)("roundEdges", ctx_r2.roundEdges)("animations", ctx_r2.animations)("showDataLabel", ctx_r2.showDataLabel)("dataLabelFormatting", ctx_r2.dataLabelFormatting)("noBarWhenZero", ctx_r2.noBarWhenZero);
  }
}

function BarHorizontalNormalizedComponent__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BarHorizontalNormalizedComponent__svg_g_2_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r3.updateXAxisHeight($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r0.xScale)("dims", ctx_r0.dims)("showGridLines", ctx_r0.showGridLines)("showLabel", ctx_r0.showXAxisLabel)("labelText", ctx_r0.xAxisLabel)("trimTicks", ctx_r0.trimXAxisTicks)("rotateTicks", ctx_r0.rotateXAxisTicks)("maxTickLength", ctx_r0.maxXAxisTickLength)("tickFormatting", ctx_r0.xAxisTickFormatting)("ticks", ctx_r0.xAxisTicks);
  }
}

function BarHorizontalNormalizedComponent__svg_g_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BarHorizontalNormalizedComponent__svg_g_3_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r6);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.updateYAxisWidth($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("yScale", ctx_r1.yScale)("dims", ctx_r1.dims)("showLabel", ctx_r1.showYAxisLabel)("labelText", ctx_r1.yAxisLabel)("trimTicks", ctx_r1.trimYAxisTicks)("maxTickLength", ctx_r1.maxYAxisTickLength)("tickFormatting", ctx_r1.yAxisTickFormatting)("ticks", ctx_r1.yAxisTicks);
  }
}

function BarHorizontalNormalizedComponent__svg_g_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g")(1, "g", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function BarHorizontalNormalizedComponent__svg_g_4_Template__svg_g_select_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r9);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r8.onClick($event, group_r7));
    })("activate", function BarHorizontalNormalizedComponent__svg_g_4_Template__svg_g_activate_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r9);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r10.onActivate($event, group_r7));
    })("deactivate", function BarHorizontalNormalizedComponent__svg_g_4_Template__svg_g_deactivate_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r9);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r11.onDeactivate($event, group_r7));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const group_r7 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("@animationState", "active");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r2.groupTransform(group_r7));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r2.xScale)("yScale", ctx_r2.yScale)("activeEntries", ctx_r2.activeEntries)("colors", ctx_r2.colors)("series", group_r7.series)("dims", ctx_r2.dims)("gradient", ctx_r2.gradient)("tooltipDisabled", ctx_r2.tooltipDisabled)("tooltipTemplate", ctx_r2.tooltipTemplate)("seriesName", group_r7.name)("animations", ctx_r2.animations)("noBarWhenZero", ctx_r2.noBarWhenZero);
  }
}

function BarHorizontalStackedComponent__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BarHorizontalStackedComponent__svg_g_2_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r3.updateXAxisHeight($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r0.xScale)("dims", ctx_r0.dims)("showGridLines", ctx_r0.showGridLines)("showLabel", ctx_r0.showXAxisLabel)("labelText", ctx_r0.xAxisLabel)("trimTicks", ctx_r0.trimXAxisTicks)("rotateTicks", ctx_r0.rotateXAxisTicks)("maxTickLength", ctx_r0.maxXAxisTickLength)("tickFormatting", ctx_r0.xAxisTickFormatting)("ticks", ctx_r0.xAxisTicks);
  }
}

function BarHorizontalStackedComponent__svg_g_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BarHorizontalStackedComponent__svg_g_3_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r6);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.updateYAxisWidth($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("yScale", ctx_r1.yScale)("dims", ctx_r1.dims)("showLabel", ctx_r1.showYAxisLabel)("labelText", ctx_r1.yAxisLabel)("trimTicks", ctx_r1.trimYAxisTicks)("maxTickLength", ctx_r1.maxYAxisTickLength)("tickFormatting", ctx_r1.yAxisTickFormatting)("ticks", ctx_r1.yAxisTicks)("yAxisOffset", ctx_r1.dataLabelMaxWidth.negative);
  }
}

function BarHorizontalStackedComponent__svg_g_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g")(1, "g", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function BarHorizontalStackedComponent__svg_g_4_Template__svg_g_select_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r9.onClick($event, group_r7));
    })("activate", function BarHorizontalStackedComponent__svg_g_4_Template__svg_g_activate_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r11.onActivate($event, group_r7));
    })("deactivate", function BarHorizontalStackedComponent__svg_g_4_Template__svg_g_deactivate_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r12.onDeactivate($event, group_r7));
    })("dataLabelWidthChanged", function BarHorizontalStackedComponent__svg_g_4_Template__svg_g_dataLabelWidthChanged_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const index_r8 = restoredCtx.index;
      const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r13.onDataLabelMaxWidthChanged($event, index_r8));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const group_r7 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("@animationState", "active");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r2.groupTransform(group_r7));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r2.xScale)("yScale", ctx_r2.yScale)("colors", ctx_r2.colors)("series", group_r7.series)("activeEntries", ctx_r2.activeEntries)("dims", ctx_r2.dims)("gradient", ctx_r2.gradient)("tooltipDisabled", ctx_r2.tooltipDisabled)("tooltipTemplate", ctx_r2.tooltipTemplate)("seriesName", group_r7.name)("animations", ctx_r2.animations)("showDataLabel", ctx_r2.showDataLabel)("dataLabelFormatting", ctx_r2.dataLabelFormatting)("noBarWhenZero", ctx_r2.noBarWhenZero);
  }
}

function BarVerticalComponent__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BarVerticalComponent__svg_g_2_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r2.updateXAxisHeight($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r0.xScale)("dims", ctx_r0.dims)("showLabel", ctx_r0.showXAxisLabel)("labelText", ctx_r0.xAxisLabel)("trimTicks", ctx_r0.trimXAxisTicks)("rotateTicks", ctx_r0.rotateXAxisTicks)("maxTickLength", ctx_r0.maxXAxisTickLength)("tickFormatting", ctx_r0.xAxisTickFormatting)("ticks", ctx_r0.xAxisTicks)("xAxisOffset", ctx_r0.dataLabelMaxHeight.negative);
  }
}

function BarVerticalComponent__svg_g_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BarVerticalComponent__svg_g_3_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r5);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r4.updateYAxisWidth($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("yScale", ctx_r1.yScale)("dims", ctx_r1.dims)("showGridLines", ctx_r1.showGridLines)("showLabel", ctx_r1.showYAxisLabel)("labelText", ctx_r1.yAxisLabel)("trimTicks", ctx_r1.trimYAxisTicks)("maxTickLength", ctx_r1.maxYAxisTickLength)("tickFormatting", ctx_r1.yAxisTickFormatting)("ticks", ctx_r1.yAxisTicks);
  }
}

function BarVertical2DComponent__svg_g_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BarVertical2DComponent__svg_g_3_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r3.updateXAxisHeight($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r0.groupScale)("dims", ctx_r0.dims)("showLabel", ctx_r0.showXAxisLabel)("labelText", ctx_r0.xAxisLabel)("trimTicks", ctx_r0.trimXAxisTicks)("rotateTicks", ctx_r0.rotateXAxisTicks)("maxTickLength", ctx_r0.maxXAxisTickLength)("tickFormatting", ctx_r0.xAxisTickFormatting)("ticks", ctx_r0.xAxisTicks)("xAxisOffset", ctx_r0.dataLabelMaxHeight.negative);
  }
}

function BarVertical2DComponent__svg_g_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BarVertical2DComponent__svg_g_4_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r6);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.updateYAxisWidth($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("yScale", ctx_r1.valueScale)("dims", ctx_r1.dims)("showGridLines", ctx_r1.showGridLines)("showLabel", ctx_r1.showYAxisLabel)("labelText", ctx_r1.yAxisLabel)("trimTicks", ctx_r1.trimYAxisTicks)("maxTickLength", ctx_r1.maxYAxisTickLength)("tickFormatting", ctx_r1.yAxisTickFormatting)("ticks", ctx_r1.yAxisTicks);
  }
}

function BarVertical2DComponent__svg_g_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function BarVertical2DComponent__svg_g_5_Template__svg_g_select_0_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r9.onClick($event, group_r7));
    })("activate", function BarVertical2DComponent__svg_g_5_Template__svg_g_activate_0_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r11.onActivate($event, group_r7));
    })("deactivate", function BarVertical2DComponent__svg_g_5_Template__svg_g_deactivate_0_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r12.onDeactivate($event, group_r7));
    })("dataLabelHeightChanged", function BarVertical2DComponent__svg_g_5_Template__svg_g_dataLabelHeightChanged_0_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const index_r8 = restoredCtx.index;
      const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r13.onDataLabelMaxHeightChanged($event, index_r8));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const group_r7 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("@animationState", "active")("activeEntries", ctx_r2.activeEntries)("xScale", ctx_r2.innerScale)("yScale", ctx_r2.valueScale)("colors", ctx_r2.colors)("series", group_r7.series)("dims", ctx_r2.dims)("gradient", ctx_r2.gradient)("tooltipDisabled", ctx_r2.tooltipDisabled)("tooltipTemplate", ctx_r2.tooltipTemplate)("showDataLabel", ctx_r2.showDataLabel)("dataLabelFormatting", ctx_r2.dataLabelFormatting)("seriesName", group_r7.name)("roundEdges", ctx_r2.roundEdges)("animations", ctx_r2.animations)("noBarWhenZero", ctx_r2.noBarWhenZero);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r2.groupTransform(group_r7));
  }
}

function BarVerticalNormalizedComponent__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BarVerticalNormalizedComponent__svg_g_2_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r3.updateXAxisHeight($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r0.xScale)("dims", ctx_r0.dims)("showLabel", ctx_r0.showXAxisLabel)("labelText", ctx_r0.xAxisLabel)("trimTicks", ctx_r0.trimXAxisTicks)("rotateTicks", ctx_r0.rotateXAxisTicks)("maxTickLength", ctx_r0.maxXAxisTickLength)("tickFormatting", ctx_r0.xAxisTickFormatting)("ticks", ctx_r0.xAxisTicks);
  }
}

function BarVerticalNormalizedComponent__svg_g_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BarVerticalNormalizedComponent__svg_g_3_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r6);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.updateYAxisWidth($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("yScale", ctx_r1.yScale)("dims", ctx_r1.dims)("showGridLines", ctx_r1.showGridLines)("showLabel", ctx_r1.showYAxisLabel)("labelText", ctx_r1.yAxisLabel)("trimTicks", ctx_r1.trimYAxisTicks)("maxTickLength", ctx_r1.maxYAxisTickLength)("tickFormatting", ctx_r1.yAxisTickFormatting)("ticks", ctx_r1.yAxisTicks);
  }
}

function BarVerticalNormalizedComponent__svg_g_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g")(1, "g", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function BarVerticalNormalizedComponent__svg_g_4_Template__svg_g_select_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r9);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r8.onClick($event, group_r7));
    })("activate", function BarVerticalNormalizedComponent__svg_g_4_Template__svg_g_activate_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r9);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r10.onActivate($event, group_r7));
    })("deactivate", function BarVerticalNormalizedComponent__svg_g_4_Template__svg_g_deactivate_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r9);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r11.onDeactivate($event, group_r7));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const group_r7 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("@animationState", "active");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r2.groupTransform(group_r7));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r2.xScale)("yScale", ctx_r2.yScale)("activeEntries", ctx_r2.activeEntries)("colors", ctx_r2.colors)("series", group_r7.series)("dims", ctx_r2.dims)("gradient", ctx_r2.gradient)("tooltipDisabled", ctx_r2.tooltipDisabled)("tooltipTemplate", ctx_r2.tooltipTemplate)("seriesName", group_r7.name)("animations", ctx_r2.animations)("noBarWhenZero", ctx_r2.noBarWhenZero);
  }
}

function BarVerticalStackedComponent__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BarVerticalStackedComponent__svg_g_2_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r3.updateXAxisHeight($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r0.xScale)("dims", ctx_r0.dims)("showLabel", ctx_r0.showXAxisLabel)("labelText", ctx_r0.xAxisLabel)("trimTicks", ctx_r0.trimXAxisTicks)("rotateTicks", ctx_r0.rotateXAxisTicks)("maxTickLength", ctx_r0.maxXAxisTickLength)("tickFormatting", ctx_r0.xAxisTickFormatting)("ticks", ctx_r0.xAxisTicks)("xAxisOffset", ctx_r0.dataLabelMaxHeight.negative);
  }
}

function BarVerticalStackedComponent__svg_g_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BarVerticalStackedComponent__svg_g_3_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r6);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.updateYAxisWidth($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("yScale", ctx_r1.yScale)("dims", ctx_r1.dims)("showGridLines", ctx_r1.showGridLines)("showLabel", ctx_r1.showYAxisLabel)("labelText", ctx_r1.yAxisLabel)("trimTicks", ctx_r1.trimYAxisTicks)("maxTickLength", ctx_r1.maxYAxisTickLength)("tickFormatting", ctx_r1.yAxisTickFormatting)("ticks", ctx_r1.yAxisTicks);
  }
}

function BarVerticalStackedComponent__svg_g_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g")(1, "g", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function BarVerticalStackedComponent__svg_g_4_Template__svg_g_select_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r9.onClick($event, group_r7));
    })("activate", function BarVerticalStackedComponent__svg_g_4_Template__svg_g_activate_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r11.onActivate($event, group_r7));
    })("deactivate", function BarVerticalStackedComponent__svg_g_4_Template__svg_g_deactivate_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const group_r7 = restoredCtx.$implicit;
      const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r12.onDeactivate($event, group_r7));
    })("dataLabelHeightChanged", function BarVerticalStackedComponent__svg_g_4_Template__svg_g_dataLabelHeightChanged_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const index_r8 = restoredCtx.index;
      const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r13.onDataLabelMaxHeightChanged($event, index_r8));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const group_r7 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("@animationState", "active");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r2.groupTransform(group_r7));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r2.xScale)("yScale", ctx_r2.yScale)("activeEntries", ctx_r2.activeEntries)("colors", ctx_r2.colors)("series", group_r7.series)("dims", ctx_r2.dims)("gradient", ctx_r2.gradient)("tooltipDisabled", ctx_r2.tooltipDisabled)("tooltipTemplate", ctx_r2.tooltipTemplate)("showDataLabel", ctx_r2.showDataLabel)("dataLabelFormatting", ctx_r2.dataLabelFormatting)("seriesName", group_r7.name)("animations", ctx_r2.animations)("noBarWhenZero", ctx_r2.noBarWhenZero);
  }
}

const _c27 = ["ngx-charts-series-vertical", ""];

function SeriesVerticalComponent__svg_g_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function SeriesVerticalComponent__svg_g_0_Template__svg_g_select_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r3.onClick($event));
    })("activate", function SeriesVerticalComponent__svg_g_0_Template__svg_g_activate_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.activate.emit($event));
    })("deactivate", function SeriesVerticalComponent__svg_g_0_Template__svg_g_deactivate_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r6.deactivate.emit($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const bar_r2 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("@animationState", "active")("@.disabled", !ctx_r0.animations)("width", bar_r2.width)("height", bar_r2.height)("x", bar_r2.x)("y", bar_r2.y)("fill", bar_r2.color)("stops", bar_r2.gradientStops)("data", bar_r2.data)("orientation", "vertical")("roundEdges", bar_r2.roundEdges)("gradient", ctx_r0.gradient)("ariaLabel", bar_r2.ariaLabel)("isActive", ctx_r0.isActive(bar_r2.data))("tooltipDisabled", ctx_r0.tooltipDisabled)("tooltipPlacement", ctx_r0.tooltipPlacement)("tooltipType", ctx_r0.tooltipType)("tooltipTitle", ctx_r0.tooltipTemplate ? undefined : bar_r2.tooltipText)("tooltipTemplate", ctx_r0.tooltipTemplate)("tooltipContext", bar_r2.data)("noBarWhenZero", ctx_r0.noBarWhenZero)("animations", ctx_r0.animations);
  }
}

function SeriesVerticalComponent__svg_g_1__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function SeriesVerticalComponent__svg_g_1__svg_g_1_Template__svg_g_dimensionsChanged_0_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r11);
      const i_r9 = restoredCtx.index;
      const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r10.dataLabelHeightChanged.emit({
        size: $event,
        index: i_r9
      }));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const b_r8 = ctx.$implicit;
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("barX", b_r8.x)("barY", b_r8.y)("barWidth", b_r8.width)("barHeight", b_r8.height)("value", b_r8.total)("valueFormatting", ctx_r7.dataLabelFormatting)("orientation", "vertical");
  }
}

function SeriesVerticalComponent__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, SeriesVerticalComponent__svg_g_1__svg_g_1_Template, 1, 7, "g", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r1.barsForDataLabels)("ngForTrackBy", ctx_r1.trackDataLabelBy);
  }
}

const _c28 = ["ngx-charts-series-horizontal", ""];

function SeriesHorizontal__svg_g_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function SeriesHorizontal__svg_g_0_Template__svg_g_select_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r3.click($event));
    })("activate", function SeriesHorizontal__svg_g_0_Template__svg_g_activate_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.activate.emit($event));
    })("deactivate", function SeriesHorizontal__svg_g_0_Template__svg_g_deactivate_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r6.deactivate.emit($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const bar_r2 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("@animationState", "active")("width", bar_r2.width)("height", bar_r2.height)("x", bar_r2.x)("y", bar_r2.y)("fill", bar_r2.color)("stops", bar_r2.gradientStops)("data", bar_r2.data)("orientation", "horizontal")("roundEdges", bar_r2.roundEdges)("gradient", ctx_r0.gradient)("isActive", ctx_r0.isActive(bar_r2.data))("ariaLabel", bar_r2.ariaLabel)("animations", ctx_r0.animations)("tooltipDisabled", ctx_r0.tooltipDisabled)("tooltipPlacement", ctx_r0.tooltipPlacement)("tooltipType", ctx_r0.tooltipType)("tooltipTitle", ctx_r0.tooltipTemplate ? undefined : bar_r2.tooltipText)("tooltipTemplate", ctx_r0.tooltipTemplate)("tooltipContext", bar_r2.data)("noBarWhenZero", ctx_r0.noBarWhenZero);
  }
}

function SeriesHorizontal__svg_g_1__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function SeriesHorizontal__svg_g_1__svg_g_1_Template__svg_g_dimensionsChanged_0_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r11);
      const i_r9 = restoredCtx.index;
      const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r10.dataLabelWidthChanged.emit({
        size: $event,
        index: i_r9
      }));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const b_r8 = ctx.$implicit;
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("barX", b_r8.x)("barY", b_r8.y)("barWidth", b_r8.width)("barHeight", b_r8.height)("value", b_r8.total)("valueFormatting", ctx_r7.dataLabelFormatting)("orientation", "horizontal");
  }
}

function SeriesHorizontal__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, SeriesHorizontal__svg_g_1__svg_g_1_Template, 1, 7, "g", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r1.barsForDataLabels)("ngForTrackBy", ctx_r1.trackDataLabelBy);
  }
}

const _c29 = ["ngx-charts-bar-label", ""];

function BubbleChartComponent__svg_g_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BubbleChartComponent__svg_g_5_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r3.updateXAxisHeight($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("showGridLines", ctx_r0.showGridLines)("dims", ctx_r0.dims)("xScale", ctx_r0.xScale)("showLabel", ctx_r0.showXAxisLabel)("labelText", ctx_r0.xAxisLabel)("trimTicks", ctx_r0.trimXAxisTicks)("rotateTicks", ctx_r0.rotateXAxisTicks)("maxTickLength", ctx_r0.maxXAxisTickLength)("tickFormatting", ctx_r0.xAxisTickFormatting)("ticks", ctx_r0.xAxisTicks);
  }
}

function BubbleChartComponent__svg_g_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function BubbleChartComponent__svg_g_6_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r6);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.updateYAxisWidth($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("showGridLines", ctx_r1.showGridLines)("yScale", ctx_r1.yScale)("dims", ctx_r1.dims)("showLabel", ctx_r1.showYAxisLabel)("labelText", ctx_r1.yAxisLabel)("trimTicks", ctx_r1.trimYAxisTicks)("maxTickLength", ctx_r1.maxYAxisTickLength)("tickFormatting", ctx_r1.yAxisTickFormatting)("ticks", ctx_r1.yAxisTicks);
  }
}

function BubbleChartComponent__svg_g_9_Template(rf, ctx) {
  if (rf & 1) {
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g")(1, "g", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function BubbleChartComponent__svg_g_9_Template__svg_g_select_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r9);
      const series_r7 = restoredCtx.$implicit;
      const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r8.onClick($event, series_r7));
    })("activate", function BubbleChartComponent__svg_g_9_Template__svg_g_activate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r9);
      const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r10.onActivate($event));
    })("deactivate", function BubbleChartComponent__svg_g_9_Template__svg_g_deactivate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r9);
      const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r11.onDeactivate($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const series_r7 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("@animationState", "active");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r2.xScale)("yScale", ctx_r2.yScale)("rScale", ctx_r2.rScale)("xScaleType", ctx_r2.xScaleType)("yScaleType", ctx_r2.yScaleType)("xAxisLabel", ctx_r2.xAxisLabel)("yAxisLabel", ctx_r2.yAxisLabel)("colors", ctx_r2.colors)("data", series_r7)("activeEntries", ctx_r2.activeEntries)("tooltipDisabled", ctx_r2.tooltipDisabled)("tooltipTemplate", ctx_r2.tooltipTemplate);
  }
}

const _c30 = ["ngx-charts-bubble-series", ""];

function BubbleSeriesComponent__svg_g_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g")(1, "g")(2, "g", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function BubbleSeriesComponent__svg_g_0_Template__svg_g_select_2_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const circle_r1 = restoredCtx.$implicit;
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r2.onClick(circle_r1.data));
    })("activate", function BubbleSeriesComponent__svg_g_0_Template__svg_g_activate_2_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const circle_r1 = restoredCtx.$implicit;
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r4.activateCircle(circle_r1));
    })("deactivate", function BubbleSeriesComponent__svg_g_0_Template__svg_g_deactivate_2_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const circle_r1 = restoredCtx.$implicit;
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.deactivateCircle(circle_r1));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
  }

  if (rf & 2) {
    const circle_r1 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", circle_r1.transform);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("opacity", circle_r1.opacity);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("active", circle_r1.isActive);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("@animationState", "active")("cx", 0)("cy", 0)("r", circle_r1.radius)("fill", circle_r1.color)("pointerEvents", "all")("data", circle_r1.value)("classNames", circle_r1.classNames)("tooltipDisabled", ctx_r0.tooltipDisabled)("tooltipPlacement", "top")("tooltipType", "tooltip")("tooltipTitle", ctx_r0.tooltipTemplate ? undefined : ctx_r0.getTooltipText(circle_r1))("tooltipTemplate", ctx_r0.tooltipTemplate)("tooltipContext", circle_r1.data);
  }
}

const _c31 = ["ngx-charts-heat-map-cell", ""];

function HeatMapCellComponent__svg_defs_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "defs");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "g", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("name", ctx_r0.gradientId)("stops", ctx_r0.gradientStops);
  }
}

const _c32 = ["ngx-charts-heat-map-cell-series", ""];

const _c33 = function (a0, a1, a2) {
  return {
    series: a0,
    name: a1,
    value: a2
  };
};

function HeatCellSeriesComponent__svg_g_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function HeatCellSeriesComponent__svg_g_0_Template__svg_g_select_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const c_r1 = restoredCtx.$implicit;
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r2.onClick(c_r1.cell));
    })("activate", function HeatCellSeriesComponent__svg_g_0_Template__svg_g_activate_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const c_r1 = restoredCtx.$implicit;
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r4.activate.emit(c_r1.cell));
    })("deactivate", function HeatCellSeriesComponent__svg_g_0_Template__svg_g_deactivate_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const c_r1 = restoredCtx.$implicit;
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.deactivate.emit(c_r1.cell));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const c_r1 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("x", c_r1.x)("y", c_r1.y)("width", c_r1.width)("height", c_r1.height)("fill", c_r1.fill)("data", c_r1.data)("gradient", ctx_r0.gradient)("animations", ctx_r0.animations)("tooltipDisabled", ctx_r0.tooltipDisabled)("tooltipPlacement", "top")("tooltipType", "tooltip")("tooltipTitle", ctx_r0.tooltipTemplate ? undefined : ctx_r0.tooltipText(c_r1))("tooltipTemplate", ctx_r0.tooltipTemplate)("tooltipContext", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction3"](14, _c33, c_r1.series, c_r1.label, c_r1.data));
  }
}

function HeatMapComponent__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function HeatMapComponent__svg_g_2_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r3.updateXAxisHeight($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r0.xScale)("dims", ctx_r0.dims)("showLabel", ctx_r0.showXAxisLabel)("labelText", ctx_r0.xAxisLabel)("trimTicks", ctx_r0.trimXAxisTicks)("rotateTicks", ctx_r0.rotateXAxisTicks)("maxTickLength", ctx_r0.maxXAxisTickLength)("tickFormatting", ctx_r0.xAxisTickFormatting)("ticks", ctx_r0.xAxisTicks);
  }
}

function HeatMapComponent__svg_g_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function HeatMapComponent__svg_g_3_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r6);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.updateYAxisWidth($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("yScale", ctx_r1.yScale)("dims", ctx_r1.dims)("showLabel", ctx_r1.showYAxisLabel)("labelText", ctx_r1.yAxisLabel)("trimTicks", ctx_r1.trimYAxisTicks)("maxTickLength", ctx_r1.maxYAxisTickLength)("tickFormatting", ctx_r1.yAxisTickFormatting)("ticks", ctx_r1.yAxisTicks);
  }
}

function HeatMapComponent__svg_rect_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "rect");
  }

  if (rf & 2) {
    const rect_r7 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("x", rect_r7.x)("y", rect_r7.y)("rx", rect_r7.rx)("width", rect_r7.width)("height", rect_r7.height)("fill", rect_r7.fill);
  }
}

const _c34 = ["ngx-charts-line", ""];

function LineChartComponent__svg_g_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function LineChartComponent__svg_g_5_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r6);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.updateXAxisHeight($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r0.xScale)("dims", ctx_r0.dims)("showGridLines", ctx_r0.showGridLines)("showLabel", ctx_r0.showXAxisLabel)("labelText", ctx_r0.xAxisLabel)("trimTicks", ctx_r0.trimXAxisTicks)("rotateTicks", ctx_r0.rotateXAxisTicks)("maxTickLength", ctx_r0.maxXAxisTickLength)("tickFormatting", ctx_r0.xAxisTickFormatting)("ticks", ctx_r0.xAxisTicks);
  }
}

function LineChartComponent__svg_g_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function LineChartComponent__svg_g_6_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r8);
      const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r7.updateYAxisWidth($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("yScale", ctx_r1.yScale)("dims", ctx_r1.dims)("showGridLines", ctx_r1.showGridLines)("showLabel", ctx_r1.showYAxisLabel)("labelText", ctx_r1.yAxisLabel)("trimTicks", ctx_r1.trimYAxisTicks)("maxTickLength", ctx_r1.maxYAxisTickLength)("tickFormatting", ctx_r1.yAxisTickFormatting)("ticks", ctx_r1.yAxisTicks)("referenceLines", ctx_r1.referenceLines)("showRefLines", ctx_r1.showRefLines)("showRefLabels", ctx_r1.showRefLabels);
  }
}

function LineChartComponent__svg_g_8_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "g", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const series_r9 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("@animationState", "active");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r2.xScale)("yScale", ctx_r2.yScale)("colors", ctx_r2.colors)("data", series_r9)("activeEntries", ctx_r2.activeEntries)("scaleType", ctx_r2.scaleType)("curve", ctx_r2.curve)("rangeFillOpacity", ctx_r2.rangeFillOpacity)("hasRange", ctx_r2.hasRange)("animations", ctx_r2.animations);
  }
}

function LineChartComponent__svg_g_9__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g")(1, "g", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function LineChartComponent__svg_g_9__svg_g_2_Template__svg_g_select_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r12.onClick($event));
    })("activate", function LineChartComponent__svg_g_9__svg_g_2_Template__svg_g_activate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r14.onActivate($event));
    })("deactivate", function LineChartComponent__svg_g_9__svg_g_2_Template__svg_g_deactivate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r15.onDeactivate($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const series_r11 = ctx.$implicit;
    const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r10.xScale)("yScale", ctx_r10.yScale)("colors", ctx_r10.colors)("data", series_r11)("scaleType", ctx_r10.scaleType)("visibleValue", ctx_r10.hoveredVertical)("activeEntries", ctx_r10.activeEntries)("tooltipDisabled", ctx_r10.tooltipDisabled)("tooltipTemplate", ctx_r10.tooltipTemplate);
  }
}

function LineChartComponent__svg_g_9_Template(rf, ctx) {
  if (rf & 1) {
    const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("mouseleave", function LineChartComponent__svg_g_9_Template__svg_g_mouseleave_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r17);
      const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r16.hideCircles());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "g", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("hover", function LineChartComponent__svg_g_9_Template__svg_g_hover_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r17);
      const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r18.updateHoveredVertical($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, LineChartComponent__svg_g_9__svg_g_2_Template, 2, 9, "g", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("dims", ctx_r3.dims)("xSet", ctx_r3.xSet)("xScale", ctx_r3.xScale)("yScale", ctx_r3.yScale)("results", ctx_r3.results)("colors", ctx_r3.colors)("tooltipDisabled", ctx_r3.tooltipDisabled)("tooltipTemplate", ctx_r3.seriesTooltipTemplate);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r3.results);
  }
}

function LineChartComponent__svg_g_10__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "g", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const series_r20 = ctx.$implicit;
    const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx_r19.timelineXScale)("yScale", ctx_r19.timelineYScale)("colors", ctx_r19.colors)("data", series_r20)("scaleType", ctx_r19.scaleType)("curve", ctx_r19.curve)("hasRange", ctx_r19.hasRange)("animations", ctx_r19.animations);
  }
}

function LineChartComponent__svg_g_10_Template(rf, ctx) {
  if (rf & 1) {
    const _r22 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("onDomainChange", function LineChartComponent__svg_g_10_Template__svg_g_onDomainChange_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r22);
      const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r21.updateDomain($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, LineChartComponent__svg_g_10__svg_g_1_Template, 2, 8, "g", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("results", ctx_r4.results)("view", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](10, _c23, ctx_r4.timelineWidth, ctx_r4.height))("height", ctx_r4.timelineHeight)("scheme", ctx_r4.scheme)("customColors", ctx_r4.customColors)("scaleType", ctx_r4.scaleType)("legend", ctx_r4.legend);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r4.timelineTransform);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r4.results)("ngForTrackBy", ctx_r4.trackBy);
  }
}

const _c35 = ["ngx-charts-line-series", ""];

function LineSeriesComponent__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "g", 4);
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("name", ctx_r0.gradientId)("stops", ctx_r0.gradientStops);
  }
}

function LineSeriesComponent__svg_g_5_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "g", 5);
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("active", ctx_r1.isActive(ctx_r1.data))("inactive", ctx_r1.isInactive(ctx_r1.data));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("data", ctx_r1.data)("path", ctx_r1.outerPath)("fill", ctx_r1.hasGradient ? ctx_r1.gradientUrl : ctx_r1.colors.getColor(ctx_r1.data.name))("opacity", ctx_r1.rangeFillOpacity)("animations", ctx_r1.animations);
  }
}

function PolarChartComponent__svg_g_4__svg_circle_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "circle", 8);
  }

  if (rf & 2) {
    const r_r6 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("r", r_r6);
  }
}

function PolarChartComponent__svg_g_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, PolarChartComponent__svg_g_4__svg_circle_1_Template, 1, 1, "circle", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r0.radiusTicks);
  }
}

function PolarChartComponent__svg_g_5__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "g", 10);
  }

  if (rf & 2) {
    const tick_r8 = ctx.$implicit;
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("data", tick_r8)("radius", ctx_r7.outerRadius)("label", tick_r8.label)("max", ctx_r7.outerRadius)("value", ctx_r7.showGridLines ? 1 : ctx_r7.outerRadius)("explodeSlices", true)("animations", ctx_r7.animations)("labelTrim", ctx_r7.labelTrim)("labelTrimSize", ctx_r7.labelTrimSize);
  }
}

function PolarChartComponent__svg_g_5_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, PolarChartComponent__svg_g_5__svg_g_1_Template, 1, 9, "g", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r1.thetaTicks);
  }
}

function PolarChartComponent__svg_g_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("dimensionsChanged", function PolarChartComponent__svg_g_6_Template__svg_g_dimensionsChanged_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10);
      const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r9.updateYAxisWidth($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("yScale", ctx_r2.yAxisScale)("dims", ctx_r2.yAxisDims)("showGridLines", ctx_r2.showGridLines)("showLabel", ctx_r2.showYAxisLabel)("labelText", ctx_r2.yAxisLabel)("trimTicks", ctx_r2.trimYAxisTicks)("maxTickLength", ctx_r2.maxYAxisTickLength)("tickFormatting", ctx_r2.yAxisTickFormatting);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r2.transformYAxis);
  }
}

function PolarChartComponent__svg_g_7_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "g", 12);
  }

  if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("label", ctx_r3.xAxisLabel)("offset", ctx_r3.labelOffset)("orient", "bottom")("height", ctx_r3.dims.height)("width", ctx_r3.dims.width);
  }
}

function PolarChartComponent__svg_g_9_Template(rf, ctx) {
  if (rf & 1) {
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g")(1, "g", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function PolarChartComponent__svg_g_9_Template__svg_g_select_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r12.onClick($event));
    })("activate", function PolarChartComponent__svg_g_9_Template__svg_g_activate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r14.onActivate($event));
    })("deactivate", function PolarChartComponent__svg_g_9_Template__svg_g_deactivate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13);
      const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r15.onDeactivate($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const series_r11 = ctx.$implicit;
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("@animationState", "active");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("gradient", ctx_r4.gradient)("xScale", ctx_r4.xScale)("yScale", ctx_r4.yScale)("colors", ctx_r4.colors)("data", series_r11)("activeEntries", ctx_r4.activeEntries)("scaleType", ctx_r4.scaleType)("curve", ctx_r4.curve)("rangeFillOpacity", ctx_r4.rangeFillOpacity)("animations", ctx_r4.animations)("tooltipDisabled", ctx_r4.tooltipDisabled)("tooltipTemplate", ctx_r4.tooltipTemplate);
  }
}

const _c36 = ["ngx-charts-polar-series", ""];

function PolarSeriesComponent__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "g", 4);
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("color", ctx_r0.seriesColor)("name", ctx_r0.gradientId)("startOpacity", 0.25)("endOpacity", 1)("stops", ctx_r0.gradientStops);
  }
}

function PolarSeriesComponent__svg_g_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function PolarSeriesComponent__svg_g_4_Template__svg_g_select_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const circle_r2 = restoredCtx.$implicit;
      const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r3.select.emit(circle_r2.data));
    })("activate", function PolarSeriesComponent__svg_g_4_Template__svg_g_activate_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const circle_r2 = restoredCtx.$implicit;
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.activate.emit({
        name: circle_r2.data.series
      }));
    })("deactivate", function PolarSeriesComponent__svg_g_4_Template__svg_g_deactivate_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r4);
      const circle_r2 = restoredCtx.$implicit;
      const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r6.deactivate.emit({
        name: circle_r2.data.series
      }));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const circle_r2 = ctx.$implicit;
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("opacity", ctx_r1.inactive ? 0.2 : 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("cx", circle_r2.cx)("cy", circle_r2.cy)("r", ctx_r1.circleRadius)("fill", circle_r2.color)("tooltipDisabled", ctx_r1.tooltipDisabled)("tooltipPlacement", "top")("tooltipTitle", ctx_r1.tooltipTemplate ? undefined : ctx_r1.tooltipText(circle_r2))("tooltipTemplate", ctx_r1.tooltipTemplate)("tooltipContext", circle_r2.data);
  }
}

const _c37 = ["ngx-charts-pie-label", ""];
const _c38 = ["ngx-charts-pie-arc", ""];

function PieArcComponent__svg_defs_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "defs");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "g", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("color", ctx_r0.fill)("name", ctx_r0.radialGradientId)("startOpacity", ctx_r0.startOpacity);
  }
}

const _c39 = ".pie-label{font-size:11px}.pie-label.animation{-webkit-animation:fadeIn .75s ease-in;animation:fadeIn .75s ease-in}@-webkit-keyframes fadeIn{0%{opacity:0}to{opacity:1}}@keyframes fadeIn{0%{opacity:0}to{opacity:1}}.pie-label-line{stroke-dasharray:100%}.pie-label-line.animation{-webkit-animation:drawOut 3s linear;animation:drawOut 3s linear;transition:d .75s}@-webkit-keyframes drawOut{0%{stroke-dashoffset:100%}to{stroke-dashoffset:0}}@keyframes drawOut{0%{stroke-dashoffset:100%}to{stroke-dashoffset:0}}";

function PieGridComponent__svg_g_2__svg_text_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "text", 10);
  }

  if (rf & 2) {
    const series_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("countTo", series_r1.percent)("countSuffix", "%");
  }
}

function PieGridComponent__svg_g_2__svg_text_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "text", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const series_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", series_r1.percent.toLocaleString(), " ");
  }
}

function PieGridComponent__svg_g_2__svg_text_6_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "text", 12);
  }

  if (rf & 2) {
    const series_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("countTo", series_r1.total)("countPrefix", ctx_r4.label + ": ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("y", series_r1.outerRadius);
  }
}

function PieGridComponent__svg_g_2__svg_text_7_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "text", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const series_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("y", series_r1.outerRadius);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate2"](" ", ctx_r5.label, ": ", series_r1.total.toLocaleString(), " ");
  }
}

const _c40 = function (a0) {
  return {
    data: a0
  };
};

function PieGridComponent__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 3)(1, "g", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function PieGridComponent__svg_g_2_Template__svg_g_select_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r11);
      const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r10.onClick($event));
    })("activate", function PieGridComponent__svg_g_2_Template__svg_g_activate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r11);
      const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r12.onActivate($event));
    })("deactivate", function PieGridComponent__svg_g_2_Template__svg_g_deactivate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r11);
      const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r13.onDeactivate($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, PieGridComponent__svg_g_2__svg_text_2_Template, 1, 2, "text", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, PieGridComponent__svg_g_2__svg_text_3_Template, 2, 1, "text", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "text", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](6, PieGridComponent__svg_g_2__svg_text_6_Template, 1, 3, "text", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](7, PieGridComponent__svg_g_2__svg_text_7_Template, 2, 3, "text", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const series_r1 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", series_r1.transform);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("colors", series_r1.colors)("data", series_r1.data)("innerRadius", series_r1.innerRadius)("outerRadius", series_r1.outerRadius)("animations", ctx_r0.animations)("tooltipDisabled", ctx_r0.tooltipDisabled)("tooltipPlacement", "top")("tooltipType", "tooltip")("tooltipTitle", ctx_r0.tooltipTemplate ? undefined : ctx_r0.tooltipText(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](17, _c40, series_r1)))("tooltipTemplate", ctx_r0.tooltipTemplate)("tooltipContext", series_r1.data[0].data);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r0.animations);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx_r0.animations);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", series_r1.label, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r0.animations);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx_r0.animations);
  }
}

const _c41 = ["ngx-charts-pie-grid-series", ""];

function PieGridSeriesComponent__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function PieGridSeriesComponent__svg_g_1_Template__svg_g_select_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r2.onClick($event));
    })("activate", function PieGridSeriesComponent__svg_g_1_Template__svg_g_activate_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r4.activate.emit($event));
    })("deactivate", function PieGridSeriesComponent__svg_g_1_Template__svg_g_deactivate_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r5.deactivate.emit($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const arc_r1 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("startAngle", arc_r1.startAngle)("endAngle", arc_r1.endAngle)("innerRadius", ctx_r0.innerRadius)("outerRadius", ctx_r0.outerRadius)("fill", ctx_r0.color(arc_r1))("value", arc_r1.data.value)("data", arc_r1.data)("gradient", false)("pointerEvents", arc_r1.pointerEvents)("animate", arc_r1.animate);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("class", arc_r1.class);
  }
}

const _c42 = ["ngx-charts-pie-series", ""];

function PieSeriesComponent__svg_g_0__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "g", 3);
  }

  if (rf & 2) {
    const arc_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("data", arc_r1)("radius", ctx_r2.outerRadius)("color", ctx_r2.color(arc_r1))("label", ctx_r2.labelText(arc_r1))("labelTrim", ctx_r2.trimLabels)("labelTrimSize", ctx_r2.maxLabelLength)("max", ctx_r2.max)("value", arc_r1.value)("explodeSlices", ctx_r2.explodeSlices)("animations", ctx_r2.animations);
  }
}

function PieSeriesComponent__svg_g_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, PieSeriesComponent__svg_g_0__svg_g_1_Template, 1, 10, "g", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "g", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function PieSeriesComponent__svg_g_0_Template__svg_g_select_2_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r5);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r4.onClick($event));
    })("activate", function PieSeriesComponent__svg_g_0_Template__svg_g_activate_2_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r5);
      const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r6.activate.emit($event));
    })("deactivate", function PieSeriesComponent__svg_g_0_Template__svg_g_deactivate_2_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r5);
      const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r7.deactivate.emit($event));
    })("dblclick", function PieSeriesComponent__svg_g_0_Template__svg_g_dblclick_2_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r5);
      const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r8.dblclick.emit($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const arc_r1 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r0.labelVisible(arc_r1));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("startAngle", arc_r1.startAngle)("endAngle", arc_r1.endAngle)("innerRadius", ctx_r0.innerRadius)("outerRadius", ctx_r0.outerRadius)("fill", ctx_r0.color(arc_r1))("value", arc_r1.data.value)("gradient", ctx_r0.gradient)("data", arc_r1.data)("max", ctx_r0.max)("explodeSlices", ctx_r0.explodeSlices)("isActive", ctx_r0.isActive(arc_r1.data))("animate", ctx_r0.animations)("tooltipDisabled", ctx_r0.tooltipDisabled)("tooltipPlacement", "top")("tooltipType", "tooltip")("tooltipTitle", ctx_r0.getTooltipTitle(arc_r1))("tooltipTemplate", ctx_r0.tooltipTemplate)("tooltipContext", arc_r1.data);
  }
}

const _c43 = ["textEl"];
const _c44 = ["ngx-charts-card", ""];

function CardComponent__svg_path_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "path", 7);
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("fill", ctx_r0.bandColor)("transform", ctx_r0.transformBand)("d", ctx_r0.bandPath);
  }
}

const _c45 = ["ngx-charts-card-series", ""];

function CardSeriesComponent__svg_rect_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "rect", 2);
  }

  if (rf & 2) {
    const c_r2 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("fill", ctx_r0.emptyColor);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("x", c_r2.x)("y", c_r2.y)("width", c_r2.width)("height", c_r2.height);
  }
}

function CardSeriesComponent__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function CardSeriesComponent__svg_g_1_Template__svg_g_select_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r5);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r4.onClick($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const c_r3 = ctx.$implicit;
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("x", c_r3.x)("y", c_r3.y)("width", c_r3.width)("height", c_r3.height)("color", c_r3.color)("bandColor", c_r3.bandColor)("textColor", c_r3.textColor)("data", c_r3.data)("label", c_r3.label)("medianSize", ctx_r1.medianSize)("valueFormatting", ctx_r1.valueFormatting)("labelFormatting", ctx_r1.labelFormatting)("animations", ctx_r1.animations);
  }
}

const _c46 = ["ngx-charts-tree-map-cell", ""];

function TreeMapCellComponent__svg_defs_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "defs");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "g", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("name", ctx_r0.gradientId)("stops", ctx_r0.gradientStops);
  }
}

function TreeMapCellComponent__svg_foreignObject_3__xhtml_span_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "span", 8);
  }

  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("countTo", ctx_r2.value)("valueFormatting", ctx_r2.valueFormatting);
  }
}

function TreeMapCellComponent__svg_foreignObject_3__xhtml_span_5_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "span", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx_r3.formattedValue, " ");
  }
}

function TreeMapCellComponent__svg_foreignObject_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "foreignObject", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceHTML"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](2, "span", 5)(3, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, TreeMapCellComponent__svg_foreignObject_3__xhtml_span_4_Template, 1, 2, "span", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](5, TreeMapCellComponent__svg_foreignObject_3__xhtml_span_5_Template, 2, 1, "span", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("pointer-events", "none");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("x", ctx_r1.x)("y", ctx_r1.y)("width", ctx_r1.width)("height", ctx_r1.height);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("color", ctx_r1.getTextColor())("height", ctx_r1.height + "px")("width", ctx_r1.width + "px");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("innerHTML", ctx_r1.formattedLabel, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeHtml"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r1.animations);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx_r1.animations);
  }
}

const _c47 = ["ngx-charts-tree-map-cell-series", ""];

function TreeMapCellSeriesComponent__svg_g_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function TreeMapCellSeriesComponent__svg_g_0_Template__svg_g_select_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r3);
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r2.onClick($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const c_r1 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("data", c_r1.data)("x", c_r1.x)("y", c_r1.y)("width", c_r1.width)("height", c_r1.height)("fill", c_r1.fill)("label", c_r1.label)("value", c_r1.value)("valueType", c_r1.valueType)("valueFormatting", ctx_r0.valueFormatting)("labelFormatting", ctx_r0.labelFormatting)("gradient", ctx_r0.gradient)("animations", ctx_r0.animations)("tooltipDisabled", ctx_r0.tooltipDisabled)("tooltipPlacement", "top")("tooltipType", "tooltip")("tooltipTitle", ctx_r0.tooltipTemplate ? undefined : ctx_r0.getTooltipText(c_r1))("tooltipTemplate", ctx_r0.tooltipTemplate)("tooltipContext", c_r1.data);
  }
}

const _c48 = ["valueTextEl"];
const _c49 = ["unitsTextEl"];

function LinearGaugeComponent__svg_line_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "line", 10);
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r0.transformLine)("stroke", ctx_r0.colors.getColor(ctx_r0.units));
  }
}

function LinearGaugeComponent__svg_line_5_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "line", 11);
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r1.transformLine)("stroke", ctx_r1.colors.getColor(ctx_r1.units));
  }
}

const _c50 = function () {
  return {};
};

function GaugeComponent__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g")(1, "g", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function GaugeComponent__svg_g_2_Template__svg_g_select_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r5);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r4.onClick($event));
    })("activate", function GaugeComponent__svg_g_2_Template__svg_g_activate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r5);
      const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r6.onActivate($event));
    })("deactivate", function GaugeComponent__svg_g_2_Template__svg_g_deactivate_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r5);
      const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r7.onDeactivate($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const arc_r3 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r0.rotation);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("backgroundArc", arc_r3.backgroundArc)("valueArc", arc_r3.valueArc)("cornerRadius", ctx_r0.cornerRadius)("colors", ctx_r0.colors)("isActive", ctx_r0.isActive(arc_r3.valueArc.data))("tooltipDisabled", ctx_r0.tooltipDisabled)("tooltipTemplate", ctx_r0.tooltipTemplate)("valueFormatting", ctx_r0.valueFormatting)("animations", ctx_r0.animations);
  }
}

function GaugeComponent__svg_g_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "g", 6);
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("bigSegments", ctx_r1.bigSegments)("smallSegments", ctx_r1.smallSegments)("min", ctx_r1.min)("max", ctx_r1.max)("radius", ctx_r1.outerRadius)("angleSpan", ctx_r1.angleSpan)("valueScale", ctx_r1.valueScale)("startAngle", ctx_r1.startAngle)("tickFormatting", ctx_r1.axisTickFormatting);
  }
}

function GaugeComponent__svg_text_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "text", 7, 8)(2, "tspan", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "tspan", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("text-anchor", "middle");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx_r2.textTransform);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r2.displayValue);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx_r2.units);
  }
}

const _c51 = ["ngx-charts-gauge-arc", ""];
const _c52 = ["ngx-charts-gauge-axis", ""];

function GaugeAxisComponent__svg_g_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "path");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const tick_r3 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("d", tick_r3.line);
  }
}

function GaugeAxisComponent__svg_g_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 2)(1, "text", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const tick_r4 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("text-anchor", tick_r4.textAnchor);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", tick_r4.textTransform);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", tick_r4.text, " ");
  }
}

function GaugeAxisComponent__svg_g_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "path");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const tick_r5 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("d", tick_r5.line);
  }
}

function isViewContainerRef(x) {
  return x.element;
}
/**
 * Injection service is a helper to append components
 * dynamically to a known location in the DOM, most
 * noteably for dialogs/tooltips appending to body.
 *
 * @export
 */


class InjectionService {
  constructor(applicationRef, componentFactoryResolver, injector) {
    this.applicationRef = applicationRef;
    this.componentFactoryResolver = componentFactoryResolver;
    this.injector = injector;
  }
  /**
   * Sets a default global root view container. This is useful for
   * things like ngUpgrade that doesn't have a ApplicationRef root.
   *
   * @param container
   */


  static setGlobalRootViewContainer(container) {
    InjectionService.globalRootViewContainer = container;
  }
  /**
   * Gets the root view container to inject the component to.
   *
   * @memberOf InjectionService
   */


  getRootViewContainer() {
    if (this._container) return this._container;
    if (InjectionService.globalRootViewContainer) return InjectionService.globalRootViewContainer;
    if (this.applicationRef.components.length) return this.applicationRef.components[0];
    throw new Error('View Container not found! ngUpgrade needs to manually set this via setRootViewContainer or setGlobalRootViewContainer.');
  }
  /**
   * Overrides the default root view container. This is useful for
   * things like ngUpgrade that doesn't have a ApplicationRef root.
   *
   * @param container
   *
   * @memberOf InjectionService
   */


  setRootViewContainer(container) {
    this._container = container;
  }
  /**
   * Gets the html element for a component ref.
   *
   * @param componentRef
   *
   * @memberOf InjectionService
   */


  getComponentRootNode(component) {
    if (isViewContainerRef(component)) {
      return component.element.nativeElement;
    }

    if (component.hostView && component.hostView.rootNodes.length > 0) {
      return component.hostView.rootNodes[0];
    } // the top most component root node has no `hostView`


    return component.location.nativeElement;
  }
  /**
   * Gets the root component container html element.
   *
   * @memberOf InjectionService
   */


  getRootViewContainerNode(component) {
    return this.getComponentRootNode(component);
  }
  /**
   * Projects the bindings onto the component
   *
   * @param component
   * @param options
   *
   * @memberOf InjectionService
   */


  projectComponentBindings(component, bindings) {
    if (bindings) {
      if (bindings.inputs !== undefined) {
        const bindingKeys = Object.getOwnPropertyNames(bindings.inputs);

        for (const bindingName of bindingKeys) {
          component.instance[bindingName] = bindings.inputs[bindingName];
        }
      }

      if (bindings.outputs !== undefined) {
        const eventKeys = Object.getOwnPropertyNames(bindings.outputs);

        for (const eventName of eventKeys) {
          component.instance[eventName] = bindings.outputs[eventName];
        }
      }
    }

    return component;
  }
  /**
   * Appends a component to a adjacent location
   *
   * @param componentClass
   * @param [options={}]
   * @param [location]
   *
   * @memberOf InjectionService
   */


  appendComponent(componentClass, bindings = {}, location) {
    if (!location) location = this.getRootViewContainer();
    const appendLocation = this.getComponentRootNode(location);
    const portalHost = new _angular_cdk_portal__WEBPACK_IMPORTED_MODULE_2__.DomPortalHost(appendLocation, this.componentFactoryResolver, this.applicationRef, this.injector);
    const portal = new _angular_cdk_portal__WEBPACK_IMPORTED_MODULE_2__.ComponentPortal(componentClass);
    const componentRef = portalHost.attach(portal);
    this.projectComponentBindings(componentRef, bindings);
    return componentRef;
  }

}

InjectionService.ɵfac = function InjectionService_Factory(t) {
  return new (t || InjectionService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ApplicationRef), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ComponentFactoryResolver), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.Injector));
};

InjectionService.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({
  token: InjectionService,
  factory: InjectionService.ɵfac
});
InjectionService.globalRootViewContainer = null;

InjectionService.ctorParameters = () => [{
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ApplicationRef
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ComponentFactoryResolver
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Injector
}];
/**
 * Throttle a function
 *
 */


function throttle(func, wait, options) {
  options = options || {};
  let context;
  let args;
  let result;
  let timeout = null;
  let previous = 0;

  function later() {
    previous = options.leading === false ? 0 : +new Date();
    timeout = null;
    result = func.apply(context, args);
  }

  return function () {
    const now = +new Date();

    if (!previous && options.leading === false) {
      previous = now;
    }

    const remaining = wait - (now - previous);
    context = this;
    args = arguments;

    if (remaining <= 0) {
      clearTimeout(timeout);
      timeout = null;
      previous = now;
      result = func.apply(context, args);
    } else if (!timeout && options.trailing !== false) {
      timeout = setTimeout(later, remaining);
    }

    return result;
  };
}
/**
 * Throttle decorator
 *
 *  class MyClass {
 *    throttleable(10)
 *    myFn() { ... }
 *  }
 */


function throttleable(duration, options) {
  return function innerDecorator(target, key, descriptor) {
    return {
      configurable: true,
      enumerable: descriptor.enumerable,
      get: function getter() {
        Object.defineProperty(this, key, {
          configurable: true,
          enumerable: descriptor.enumerable,
          value: throttle(descriptor.value, duration, options)
        });
        return this[key];
      }
    };
  };
}

var PlacementTypes;

(function (PlacementTypes) {
  PlacementTypes[PlacementTypes["top"] = 'top'] = "top";
  PlacementTypes[PlacementTypes["bottom"] = 'bottom'] = "bottom";
  PlacementTypes[PlacementTypes["left"] = 'left'] = "left";
  PlacementTypes[PlacementTypes["right"] = 'right'] = "right";
})(PlacementTypes || (PlacementTypes = {}));

const caretOffset = 7;

function verticalPosition(elDimensions, popoverDimensions, alignment) {
  if (alignment === 'top') {
    return elDimensions.top - caretOffset;
  }

  if (alignment === 'bottom') {
    return elDimensions.top + elDimensions.height - popoverDimensions.height + caretOffset;
  }

  if (alignment === 'center') {
    return elDimensions.top + elDimensions.height / 2 - popoverDimensions.height / 2;
  }

  return undefined;
}

function horizontalPosition(elDimensions, popoverDimensions, alignment) {
  if (alignment === 'left') {
    return elDimensions.left - caretOffset;
  }

  if (alignment === 'right') {
    return elDimensions.left + elDimensions.width - popoverDimensions.width + caretOffset;
  }

  if (alignment === 'center') {
    return elDimensions.left + elDimensions.width / 2 - popoverDimensions.width / 2;
  }

  return undefined;
}
/**
 * Position helper for the popover directive.
 *
 * @export
 */


class PositionHelper {
  /**
   * Calculate vertical alignment position
   *
   * @memberOf PositionHelper
   */
  static calculateVerticalAlignment(elDimensions, popoverDimensions, alignment) {
    let result = verticalPosition(elDimensions, popoverDimensions, alignment);

    if (result + popoverDimensions.height > window.innerHeight) {
      result = window.innerHeight - popoverDimensions.height;
    }

    return result;
  }
  /**
   * Calculate vertical caret position
   *
   * @memberOf PositionHelper
   */


  static calculateVerticalCaret(elDimensions, popoverDimensions, caretDimensions, alignment) {
    let result;

    if (alignment === 'top') {
      result = elDimensions.height / 2 - caretDimensions.height / 2 + caretOffset;
    }

    if (alignment === 'bottom') {
      result = popoverDimensions.height - elDimensions.height / 2 - caretDimensions.height / 2 - caretOffset;
    }

    if (alignment === 'center') {
      result = popoverDimensions.height / 2 - caretDimensions.height / 2;
    }

    const popoverPosition = verticalPosition(elDimensions, popoverDimensions, alignment);

    if (popoverPosition + popoverDimensions.height > window.innerHeight) {
      result += popoverPosition + popoverDimensions.height - window.innerHeight;
    }

    return result;
  }
  /**
   * Calculate horz alignment position
   *
   * @memberOf PositionHelper
   */


  static calculateHorizontalAlignment(elDimensions, popoverDimensions, alignment) {
    let result = horizontalPosition(elDimensions, popoverDimensions, alignment);

    if (result + popoverDimensions.width > window.innerWidth) {
      result = window.innerWidth - popoverDimensions.width;
    }

    return result;
  }
  /**
   * Calculate horz caret position
   *
   * @memberOf PositionHelper
   */


  static calculateHorizontalCaret(elDimensions, popoverDimensions, caretDimensions, alignment) {
    let result;

    if (alignment === 'left') {
      result = elDimensions.width / 2 - caretDimensions.width / 2 + caretOffset;
    }

    if (alignment === 'right') {
      result = popoverDimensions.width - elDimensions.width / 2 - caretDimensions.width / 2 - caretOffset;
    }

    if (alignment === 'center') {
      result = popoverDimensions.width / 2 - caretDimensions.width / 2;
    }

    const popoverPosition = horizontalPosition(elDimensions, popoverDimensions, alignment);

    if (popoverPosition + popoverDimensions.width > window.innerWidth) {
      result += popoverPosition + popoverDimensions.width - window.innerWidth;
    }

    return result;
  }
  /**
   * Checks if the element's position should be flipped
   *
   * @memberOf PositionHelper
   */


  static shouldFlip(elDimensions, popoverDimensions, placement, spacing) {
    let flip = false;

    if (placement === 'right') {
      if (elDimensions.left + elDimensions.width + popoverDimensions.width + spacing > window.innerWidth) {
        flip = true;
      }
    }

    if (placement === 'left') {
      if (elDimensions.left - popoverDimensions.width - spacing < 0) {
        flip = true;
      }
    }

    if (placement === 'top') {
      if (elDimensions.top - popoverDimensions.height - spacing < 0) {
        flip = true;
      }
    }

    if (placement === 'bottom') {
      if (elDimensions.top + elDimensions.height + popoverDimensions.height + spacing > window.innerHeight) {
        flip = true;
      }
    }

    return flip;
  }
  /**
   * Position caret
   *
   * @memberOf PositionHelper
   */


  static positionCaret(placement, elmDim, hostDim, caretDimensions, alignment) {
    let top = 0;
    let left = 0;

    if (placement === PlacementTypes.right) {
      left = -7;
      top = PositionHelper.calculateVerticalCaret(hostDim, elmDim, caretDimensions, alignment);
    } else if (placement === PlacementTypes.left) {
      left = elmDim.width;
      top = PositionHelper.calculateVerticalCaret(hostDim, elmDim, caretDimensions, alignment);
    } else if (placement === PlacementTypes.top) {
      top = elmDim.height;
      left = PositionHelper.calculateHorizontalCaret(hostDim, elmDim, caretDimensions, alignment);
    } else if (placement === PlacementTypes.bottom) {
      top = -7;
      left = PositionHelper.calculateHorizontalCaret(hostDim, elmDim, caretDimensions, alignment);
    }

    return {
      top,
      left
    };
  }
  /**
   * Position content
   *
   * @memberOf PositionHelper
   */


  static positionContent(placement, elmDim, hostDim, spacing, alignment) {
    let top = 0;
    let left = 0;

    if (placement === PlacementTypes.right) {
      left = hostDim.left + hostDim.width + spacing;
      top = PositionHelper.calculateVerticalAlignment(hostDim, elmDim, alignment);
    } else if (placement === PlacementTypes.left) {
      left = hostDim.left - elmDim.width - spacing;
      top = PositionHelper.calculateVerticalAlignment(hostDim, elmDim, alignment);
    } else if (placement === PlacementTypes.top) {
      top = hostDim.top - elmDim.height - spacing;
      left = PositionHelper.calculateHorizontalAlignment(hostDim, elmDim, alignment);
    } else if (placement === PlacementTypes.bottom) {
      top = hostDim.top + hostDim.height + spacing;
      left = PositionHelper.calculateHorizontalAlignment(hostDim, elmDim, alignment);
    }

    return {
      top,
      left
    };
  }
  /**
   * Determine placement based on flip
   *
   * @memberOf PositionHelper
   */


  static determinePlacement(placement, elmDim, hostDim, spacing) {
    const shouldFlip = PositionHelper.shouldFlip(hostDim, elmDim, placement, spacing);

    if (shouldFlip) {
      if (placement === PlacementTypes.right) {
        return PlacementTypes.left;
      } else if (placement === PlacementTypes.left) {
        return PlacementTypes.right;
      } else if (placement === PlacementTypes.top) {
        return PlacementTypes.bottom;
      } else if (placement === PlacementTypes.bottom) {
        return PlacementTypes.top;
      }
    }

    return placement;
  }

}

class TooltipContentComponent {
  constructor(element, renderer, platformId) {
    this.element = element;
    this.renderer = renderer;
    this.platformId = platformId;
  }

  get cssClasses() {
    let clz = 'ngx-charts-tooltip-content';
    clz += ` position-${this.placement}`;
    clz += ` type-${this.type}`;
    clz += ` ${this.cssClass}`;
    return clz;
  }

  ngAfterViewInit() {
    setTimeout(this.position.bind(this));
  }

  position() {
    if (!(0,_angular_common__WEBPACK_IMPORTED_MODULE_3__.isPlatformBrowser)(this.platformId)) {
      return;
    }

    const nativeElm = this.element.nativeElement;
    const hostDim = this.host.nativeElement.getBoundingClientRect(); // if no dims were found, never show

    if (!hostDim.height && !hostDim.width) return;
    const elmDim = nativeElm.getBoundingClientRect();
    this.checkFlip(hostDim, elmDim);
    this.positionContent(nativeElm, hostDim, elmDim);

    if (this.showCaret) {
      this.positionCaret(hostDim, elmDim);
    } // animate its entry


    setTimeout(() => this.renderer.addClass(nativeElm, 'animate'), 1);
  }

  positionContent(nativeElm, hostDim, elmDim) {
    const {
      top,
      left
    } = PositionHelper.positionContent(this.placement, elmDim, hostDim, this.spacing, this.alignment);
    this.renderer.setStyle(nativeElm, 'top', `${top}px`);
    this.renderer.setStyle(nativeElm, 'left', `${left}px`);
  }

  positionCaret(hostDim, elmDim) {
    const caretElm = this.caretElm.nativeElement;
    const caretDimensions = caretElm.getBoundingClientRect();
    const {
      top,
      left
    } = PositionHelper.positionCaret(this.placement, elmDim, hostDim, caretDimensions, this.alignment);
    this.renderer.setStyle(caretElm, 'top', `${top}px`);
    this.renderer.setStyle(caretElm, 'left', `${left}px`);
  }

  checkFlip(hostDim, elmDim) {
    this.placement = PositionHelper.determinePlacement(this.placement, elmDim, hostDim, this.spacing);
  }

  onWindowResize() {
    this.position();
  }

}

TooltipContentComponent.ɵfac = function TooltipContentComponent_Factory(t) {
  return new (t || TooltipContentComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.Renderer2), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.PLATFORM_ID));
};

TooltipContentComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: TooltipContentComponent,
  selectors: [["ngx-tooltip-content"]],
  viewQuery: function TooltipContentComponent_Query(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵviewQuery"](_c0, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.caretElm = _t.first);
    }
  },
  hostVars: 2,
  hostBindings: function TooltipContentComponent_HostBindings(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("resize", function TooltipContentComponent_resize_HostBindingHandler() {
        return ctx.onWindowResize();
      }, false, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresolveWindow"]);
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassMap"](ctx.cssClasses);
    }
  },
  inputs: {
    placement: "placement",
    host: "host",
    showCaret: "showCaret",
    type: "type",
    alignment: "alignment",
    spacing: "spacing",
    cssClass: "cssClass",
    title: "title",
    template: "template",
    context: "context"
  },
  decls: 6,
  vars: 6,
  consts: [[3, "hidden"], ["caretElm", ""], [1, "tooltip-content"], [4, "ngIf"], [3, "innerHTML", 4, "ngIf"], [3, "ngTemplateOutlet", "ngTemplateOutletContext"], [3, "innerHTML"]],
  template: function TooltipContentComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "span", 0, 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "div", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, TooltipContentComponent_span_4_Template, 2, 4, "span", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](5, TooltipContentComponent_span_5_Template, 1, 1, "span", 4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassMapInterpolate1"]("tooltip-caret position-", ctx.placement, "");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("hidden", !ctx.showCaret);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.title);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.title);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgTemplateOutlet],
  styles: [".ngx-charts-tooltip-content{border-radius:3px;display:block;font-weight:400;opacity:0;pointer-events:none!important;position:fixed;z-index:5000}.ngx-charts-tooltip-content.type-popover{background:#fff;border:1px solid #72809b;box-shadow:0 1px 3px 0 rgba(0,0,0,.2),0 1px 1px 0 rgba(0,0,0,.14),0 2px 1px -1px rgba(0,0,0,.12);color:#060709;font-size:13px;padding:4px}.ngx-charts-tooltip-content.type-popover .tooltip-caret{height:0;position:absolute;width:0;z-index:5001}.ngx-charts-tooltip-content.type-popover .tooltip-caret.position-left{border-bottom:7px solid transparent;border-left:7px solid #fff;border-top:7px solid transparent}.ngx-charts-tooltip-content.type-popover .tooltip-caret.position-top{border-left:7px solid transparent;border-right:7px solid transparent;border-top:7px solid #fff}.ngx-charts-tooltip-content.type-popover .tooltip-caret.position-right{border-bottom:7px solid transparent;border-right:7px solid #fff;border-top:7px solid transparent}.ngx-charts-tooltip-content.type-popover .tooltip-caret.position-bottom{border-bottom:7px solid #fff;border-left:7px solid transparent;border-right:7px solid transparent}.ngx-charts-tooltip-content.type-tooltip{background:rgba(0,0,0,.75);color:#fff;font-size:12px;padding:0 10px;pointer-events:auto;text-align:center}.ngx-charts-tooltip-content.type-tooltip .tooltip-caret.position-left{border-bottom:7px solid transparent;border-left:7px solid rgba(0,0,0,.75);border-top:7px solid transparent}.ngx-charts-tooltip-content.type-tooltip .tooltip-caret.position-top{border-left:7px solid transparent;border-right:7px solid transparent;border-top:7px solid rgba(0,0,0,.75)}.ngx-charts-tooltip-content.type-tooltip .tooltip-caret.position-right{border-bottom:7px solid transparent;border-right:7px solid rgba(0,0,0,.75);border-top:7px solid transparent}.ngx-charts-tooltip-content.type-tooltip .tooltip-caret.position-bottom{border-bottom:7px solid rgba(0,0,0,.75);border-left:7px solid transparent;border-right:7px solid transparent}.ngx-charts-tooltip-content .tooltip-label{display:block;font-size:1em;line-height:1em;padding:8px 5px 5px}.ngx-charts-tooltip-content .tooltip-val{display:block;font-size:1.3em;line-height:1em;padding:0 5px 8px}.ngx-charts-tooltip-content .tooltip-caret{height:0;position:absolute;width:0;z-index:5001}.ngx-charts-tooltip-content.position-right{transform:translate3d(10px,0,0)}.ngx-charts-tooltip-content.position-left{transform:translate3d(-10px,0,0)}.ngx-charts-tooltip-content.position-top{transform:translate3d(0,-10px,0)}.ngx-charts-tooltip-content.position-bottom{transform:translate3d(0,10px,0)}.ngx-charts-tooltip-content.animate{opacity:1;pointer-events:auto;transform:translateZ(0);transition:opacity .3s,transform .3s}.area-tooltip-container{padding:5px 0;pointer-events:none}.tooltip-item{line-height:1.2em;padding:5px 0;text-align:left}.tooltip-item .tooltip-item-color{border-radius:3px;color:#5b646b;display:inline-block;height:12px;margin-right:5px;width:12px}"],
  encapsulation: 2
});

TooltipContentComponent.ctorParameters = () => [{
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Renderer2
}, {
  type: undefined,
  decorators: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Inject,
    args: [_angular_core__WEBPACK_IMPORTED_MODULE_1__.PLATFORM_ID]
  }]
}];

TooltipContentComponent.propDecorators = {
  host: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showCaret: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  type: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  placement: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  alignment: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  spacing: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  cssClass: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  title: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  template: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  context: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  caretElm: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewChild,
    args: ['caretElm']
  }],
  cssClasses: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostBinding,
    args: ['class']
  }],
  onWindowResize: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['window:resize']
  }]
};

(0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([throttleable(100)], TooltipContentComponent.prototype, "onWindowResize", null);

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](InjectionService, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Injectable
  }], function () {
    return [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ApplicationRef
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ComponentFactoryResolver
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Injector
    }];
  }, null);
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](TooltipContentComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-tooltip-content',
      template: `
    <div>
      <span #caretElm [hidden]="!showCaret" class="tooltip-caret position-{{ this.placement }}"> </span>
      <div class="tooltip-content">
        <span *ngIf="!title">
          <ng-template [ngTemplateOutlet]="template" [ngTemplateOutletContext]="{ model: context }"> </ng-template>
        </span>
        <span *ngIf="title" [innerHTML]="title"> </span>
      </div>
    </div>
  `,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      styles: [".ngx-charts-tooltip-content{border-radius:3px;display:block;font-weight:400;opacity:0;pointer-events:none!important;position:fixed;z-index:5000}.ngx-charts-tooltip-content.type-popover{background:#fff;border:1px solid #72809b;box-shadow:0 1px 3px 0 rgba(0,0,0,.2),0 1px 1px 0 rgba(0,0,0,.14),0 2px 1px -1px rgba(0,0,0,.12);color:#060709;font-size:13px;padding:4px}.ngx-charts-tooltip-content.type-popover .tooltip-caret{height:0;position:absolute;width:0;z-index:5001}.ngx-charts-tooltip-content.type-popover .tooltip-caret.position-left{border-bottom:7px solid transparent;border-left:7px solid #fff;border-top:7px solid transparent}.ngx-charts-tooltip-content.type-popover .tooltip-caret.position-top{border-left:7px solid transparent;border-right:7px solid transparent;border-top:7px solid #fff}.ngx-charts-tooltip-content.type-popover .tooltip-caret.position-right{border-bottom:7px solid transparent;border-right:7px solid #fff;border-top:7px solid transparent}.ngx-charts-tooltip-content.type-popover .tooltip-caret.position-bottom{border-bottom:7px solid #fff;border-left:7px solid transparent;border-right:7px solid transparent}.ngx-charts-tooltip-content.type-tooltip{background:rgba(0,0,0,.75);color:#fff;font-size:12px;padding:0 10px;pointer-events:auto;text-align:center}.ngx-charts-tooltip-content.type-tooltip .tooltip-caret.position-left{border-bottom:7px solid transparent;border-left:7px solid rgba(0,0,0,.75);border-top:7px solid transparent}.ngx-charts-tooltip-content.type-tooltip .tooltip-caret.position-top{border-left:7px solid transparent;border-right:7px solid transparent;border-top:7px solid rgba(0,0,0,.75)}.ngx-charts-tooltip-content.type-tooltip .tooltip-caret.position-right{border-bottom:7px solid transparent;border-right:7px solid rgba(0,0,0,.75);border-top:7px solid transparent}.ngx-charts-tooltip-content.type-tooltip .tooltip-caret.position-bottom{border-bottom:7px solid rgba(0,0,0,.75);border-left:7px solid transparent;border-right:7px solid transparent}.ngx-charts-tooltip-content .tooltip-label{display:block;font-size:1em;line-height:1em;padding:8px 5px 5px}.ngx-charts-tooltip-content .tooltip-val{display:block;font-size:1.3em;line-height:1em;padding:0 5px 8px}.ngx-charts-tooltip-content .tooltip-caret{height:0;position:absolute;width:0;z-index:5001}.ngx-charts-tooltip-content.position-right{transform:translate3d(10px,0,0)}.ngx-charts-tooltip-content.position-left{transform:translate3d(-10px,0,0)}.ngx-charts-tooltip-content.position-top{transform:translate3d(0,-10px,0)}.ngx-charts-tooltip-content.position-bottom{transform:translate3d(0,10px,0)}.ngx-charts-tooltip-content.animate{opacity:1;pointer-events:auto;transform:translateZ(0);transition:opacity .3s,transform .3s}.area-tooltip-container{padding:5px 0;pointer-events:none}.tooltip-item{line-height:1.2em;padding:5px 0;text-align:left}.tooltip-item .tooltip-item-color{border-radius:3px;color:#5b646b;display:inline-block;height:12px;margin-right:5px;width:12px}"]
    }]
  }], function () {
    return [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Renderer2
    }, {
      type: undefined,
      decorators: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Inject,
        args: [_angular_core__WEBPACK_IMPORTED_MODULE_1__.PLATFORM_ID]
      }]
    }];
  }, {
    cssClasses: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostBinding,
      args: ['class']
    }],
    placement: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    onWindowResize: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['window:resize']
    }],
    host: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showCaret: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    type: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    alignment: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    spacing: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    cssClass: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    title: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    template: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    context: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    caretElm: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewChild,
      args: ['caretElm']
    }]
  });
})();

class InjectionRegisteryService {
  constructor(injectionService) {
    this.injectionService = injectionService;
    this.defaults = {};
    this.components = new Map();
  }

  getByType(type = this.type) {
    return this.components.get(type);
  }

  create(bindings) {
    return this.createByType(this.type, bindings);
  }

  createByType(type, bindings) {
    bindings = this.assignDefaults(bindings);
    const component = this.injectComponent(type, bindings);
    this.register(type, component);
    return component;
  }

  destroy(instance) {
    const compsByType = this.components.get(instance.componentType);

    if (compsByType && compsByType.length) {
      const idx = compsByType.indexOf(instance);

      if (idx > -1) {
        const component = compsByType[idx];
        component.destroy();
        compsByType.splice(idx, 1);
      }
    }
  }

  destroyAll() {
    this.destroyByType(this.type);
  }

  destroyByType(type) {
    const comps = this.components.get(type);

    if (comps && comps.length) {
      let i = comps.length - 1;

      while (i >= 0) {
        this.destroy(comps[i--]);
      }
    }
  }

  injectComponent(type, bindings) {
    return this.injectionService.appendComponent(type, bindings);
  }

  assignDefaults(bindings) {
    const inputs = Object.assign({}, this.defaults.inputs);
    const outputs = Object.assign({}, this.defaults.outputs);

    if (!bindings.inputs && !bindings.outputs) {
      bindings = {
        inputs: bindings
      };
    }

    if (inputs) {
      bindings.inputs = Object.assign(Object.assign({}, inputs), bindings.inputs);
    }

    if (outputs) {
      bindings.outputs = Object.assign(Object.assign({}, outputs), bindings.outputs);
    }

    return bindings;
  }

  register(type, component) {
    if (!this.components.has(type)) {
      this.components.set(type, []);
    }

    const types = this.components.get(type);
    types.push(component);
  }

}

class TooltipService extends InjectionRegisteryService {
  constructor(injectionService) {
    super(injectionService);
    this.type = TooltipContentComponent;
  }

}

TooltipService.ɵfac = function TooltipService_Factory(t) {
  return new (t || TooltipService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](InjectionService));
};

TooltipService.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({
  token: TooltipService,
  factory: TooltipService.ɵfac
});

TooltipService.ctorParameters = () => [{
  type: InjectionService
}];

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](TooltipService, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Injectable
  }], function () {
    return [{
      type: InjectionService
    }];
  }, null);
})();

class ChartComponent {
  constructor() {
    this.showLegend = false;
    this.animations = true;
    this.legendLabelClick = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.legendLabelActivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.legendLabelDeactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
  }

  ngOnChanges(changes) {
    this.update();
  }

  update() {
    let legendColumns = 0;

    if (this.showLegend) {
      this.legendType = this.getLegendType();

      if (!this.legendOptions || this.legendOptions.position === 'right') {
        if (this.legendType === 'scaleLegend') {
          legendColumns = 1;
        } else {
          legendColumns = 2;
        }
      }
    }

    const chartColumns = 12 - legendColumns;
    this.chartWidth = Math.floor(this.view[0] * chartColumns / 12.0);
    this.legendWidth = !this.legendOptions || this.legendOptions.position === 'right' ? Math.floor(this.view[0] * legendColumns / 12.0) : this.chartWidth;
  }

  getLegendType() {
    if (this.legendOptions.scaleType === 'linear') {
      return 'scaleLegend';
    } else {
      return 'legend';
    }
  }

}

ChartComponent.ɵfac = function ChartComponent_Factory(t) {
  return new (t || ChartComponent)();
};

ChartComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: ChartComponent,
  selectors: [["ngx-charts-chart"]],
  inputs: {
    showLegend: "showLegend",
    animations: "animations",
    legendType: "legendType",
    view: "view",
    legendOptions: "legendOptions",
    data: "data",
    legendData: "legendData",
    colors: "colors",
    activeEntries: "activeEntries"
  },
  outputs: {
    legendLabelClick: "legendLabelClick",
    legendLabelActivate: "legendLabelActivate",
    legendLabelDeactivate: "legendLabelDeactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵProvidersFeature"]([TooltipService]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  ngContentSelectors: _c2,
  decls: 5,
  vars: 8,
  consts: [[1, "ngx-charts-outer"], [1, "ngx-charts"], ["class", "chart-legend", 3, "horizontal", "valueRange", "colors", "height", "width", 4, "ngIf"], ["class", "chart-legend", 3, "horizontal", "data", "title", "colors", "height", "width", "activeEntries", "labelClick", "labelActivate", "labelDeactivate", 4, "ngIf"], [1, "chart-legend", 3, "horizontal", "valueRange", "colors", "height", "width"], [1, "chart-legend", 3, "horizontal", "data", "title", "colors", "height", "width", "activeEntries", "labelClick", "labelActivate", "labelDeactivate"]],
  template: function ChartComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵprojectionDef"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "svg", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵprojection"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, ChartComponent_ngx_charts_scale_legend_3_Template, 1, 5, "ngx-charts-scale-legend", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, ChartComponent_ngx_charts_legend_4_Template, 1, 7, "ngx-charts-legend", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("width", ctx.view[0], "px");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("@animationState", "active")("@.disabled", !ctx.animations);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("width", ctx.chartWidth)("height", ctx.view[1]);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.showLegend && ctx.legendType === "scaleLegend");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.showLegend && ctx.legendType === "legend");
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, LegendComponent, ScaleLegendComponent];
  },
  encapsulation: 2,
  data: {
    animation: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':enter', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 0
    }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)('500ms 100ms', (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 1
    }))])])]
  },
  changeDetection: 0
});
ChartComponent.propDecorators = {
  view: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showLegend: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendOptions: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  data: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendData: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  colors: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  animations: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendLabelClick: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  legendLabelActivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  legendLabelDeactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](ChartComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      providers: [TooltipService],
      selector: 'ngx-charts-chart',
      template: `
    <div class="ngx-charts-outer" [style.width.px]="view[0]" [@animationState]="'active'" [@.disabled]="!animations">
      <svg class="ngx-charts" [attr.width]="chartWidth" [attr.height]="view[1]">
        <ng-content></ng-content>
      </svg>
      <ngx-charts-scale-legend
        *ngIf="showLegend && legendType === 'scaleLegend'"
        class="chart-legend"
        [horizontal]="legendOptions && legendOptions.position === 'below'"
        [valueRange]="legendOptions.domain"
        [colors]="legendOptions.colors"
        [height]="view[1]"
        [width]="legendWidth"
      >
      </ngx-charts-scale-legend>
      <ngx-charts-legend
        *ngIf="showLegend && legendType === 'legend'"
        class="chart-legend"
        [horizontal]="legendOptions && legendOptions.position === 'below'"
        [data]="legendOptions.domain"
        [title]="legendOptions.title"
        [colors]="legendOptions.colors"
        [height]="view[1]"
        [width]="legendWidth"
        [activeEntries]="activeEntries"
        (labelClick)="legendLabelClick.emit($event)"
        (labelActivate)="legendLabelActivate.emit($event)"
        (labelDeactivate)="legendLabelDeactivate.emit($event)"
      >
      </ngx-charts-legend>
    </div>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      animations: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':enter', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 0
      }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)('500ms 100ms', (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 1
      }))])])]
    }]
  }], function () {
    return [];
  }, {
    showLegend: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    animations: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendLabelClick: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    legendLabelActivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    legendLabelDeactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    legendType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    view: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendOptions: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    data: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendData: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    colors: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();
/**
 * Visibility Observer
 */


class VisibilityObserver {
  constructor(element, zone) {
    this.element = element;
    this.zone = zone;
    this.visible = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.isVisible = false;
    this.runCheck();
  }

  destroy() {
    clearTimeout(this.timeout);
  }

  onVisibilityChange() {
    // trigger zone recalc for columns
    this.zone.run(() => {
      this.isVisible = true;
      this.visible.emit(true);
    });
  }

  runCheck() {
    const check = () => {
      if (!this.element) {
        return;
      } // https://davidwalsh.name/offsetheight-visibility


      const {
        offsetHeight,
        offsetWidth
      } = this.element.nativeElement;

      if (offsetHeight && offsetWidth) {
        clearTimeout(this.timeout);
        this.onVisibilityChange();
      } else {
        clearTimeout(this.timeout);
        this.zone.runOutsideAngular(() => {
          this.timeout = setTimeout(() => check(), 100);
        });
      }
    };

    this.zone.runOutsideAngular(() => {
      this.timeout = setTimeout(() => check());
    });
  }

}

VisibilityObserver.ɵfac = function VisibilityObserver_Factory(t) {
  return new (t || VisibilityObserver)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.NgZone));
};

VisibilityObserver.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineDirective"]({
  type: VisibilityObserver,
  selectors: [["visibility-observer"]],
  outputs: {
    visible: "visible"
  }
});

VisibilityObserver.ctorParameters = () => [{
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.NgZone
}];

VisibilityObserver.propDecorators = {
  visible: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](VisibilityObserver, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Directive,
    args: [{
      selector: 'visibility-observer'
    }]
  }], function () {
    return [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.NgZone
    }];
  }, {
    visible: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }]
  });
})();

class BaseChartComponent {
  constructor(chartElement, zone, cd, platformId) {
    this.chartElement = chartElement;
    this.zone = zone;
    this.cd = cd;
    this.platformId = platformId;
    this.scheme = 'cool';
    this.schemeType = 'ordinal';
    this.animations = true;
    this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
  }

  ngAfterViewInit() {
    this.bindWindowResizeEvent(); // listen for visibility of the element for hidden by default scenario

    this.visibilityObserver = new VisibilityObserver(this.chartElement, this.zone);
    this.visibilityObserver.visible.subscribe(this.update.bind(this));
  }

  ngOnDestroy() {
    this.unbindEvents();

    if (this.visibilityObserver) {
      this.visibilityObserver.visible.unsubscribe();
      this.visibilityObserver.destroy();
    }
  }

  ngOnChanges(changes) {
    this.update();
  }

  update() {
    if (this.results) {
      this.results = this.cloneData(this.results);
    } else {
      this.results = [];
    }

    if (this.view) {
      this.width = this.view[0];
      this.height = this.view[1];
    } else {
      const dims = this.getContainerDims();

      if (dims) {
        this.width = dims.width;
        this.height = dims.height;
      }
    } // default values if width or height are 0 or undefined


    if (!this.width) {
      this.width = 600;
    }

    if (!this.height) {
      this.height = 400;
    }

    this.width = Math.floor(this.width);
    this.height = Math.floor(this.height);

    if (this.cd) {
      this.cd.markForCheck();
    }
  }

  getContainerDims() {
    let width;
    let height;
    const hostElem = this.chartElement.nativeElement;

    if ((0,_angular_common__WEBPACK_IMPORTED_MODULE_3__.isPlatformBrowser)(this.platformId) && hostElem.parentNode !== null) {
      // Get the container dimensions
      const dims = hostElem.parentNode.getBoundingClientRect();
      width = dims.width;
      height = dims.height;
    }

    if (width && height) {
      return {
        width,
        height
      };
    }

    return null;
  }
  /**
   * Converts all date objects that appear as name
   * into formatted date strings
   */


  formatDates() {
    for (let i = 0; i < this.results.length; i++) {
      const g = this.results[i];
      g.label = g.name;

      if (g.label instanceof Date) {
        g.label = g.label.toLocaleDateString();
      }

      if (g.series) {
        for (let j = 0; j < g.series.length; j++) {
          const d = g.series[j];
          d.label = d.name;

          if (d.label instanceof Date) {
            d.label = d.label.toLocaleDateString();
          }
        }
      }
    }
  }

  unbindEvents() {
    if (this.resizeSubscription) {
      this.resizeSubscription.unsubscribe();
    }
  }

  bindWindowResizeEvent() {
    if (!(0,_angular_common__WEBPACK_IMPORTED_MODULE_3__.isPlatformBrowser)(this.platformId)) {
      return;
    }

    const source = (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(window, 'resize');
    const subscription = source.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.debounceTime)(200)).subscribe(e => {
      this.update();

      if (this.cd) {
        this.cd.markForCheck();
      }
    });
    this.resizeSubscription = subscription;
  }
  /**
   * Clones the data into a new object
   *
   * @memberOf BaseChart
   */


  cloneData(data) {
    const results = [];

    for (const item of data) {
      const copy = {
        name: item['name']
      };

      if (item['value'] !== undefined) {
        copy['value'] = item['value'];
      }

      if (item['series'] !== undefined) {
        copy['series'] = [];

        for (const seriesItem of item['series']) {
          const seriesItemCopy = Object.assign({}, seriesItem);
          copy['series'].push(seriesItemCopy);
        }
      }

      if (item['extra'] !== undefined) {
        copy['extra'] = JSON.parse(JSON.stringify(item['extra']));
      }

      results.push(copy);
    }

    return results;
  }

}

BaseChartComponent.ɵfac = function BaseChartComponent_Factory(t) {
  return new (t || BaseChartComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.NgZone), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectorRef), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.PLATFORM_ID));
};

BaseChartComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: BaseChartComponent,
  selectors: [["base-chart"]],
  inputs: {
    scheme: "scheme",
    schemeType: "schemeType",
    animations: "animations",
    results: "results",
    view: "view",
    customColors: "customColors"
  },
  outputs: {
    select: "select"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  decls: 1,
  vars: 0,
  template: function BaseChartComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "div");
    }
  },
  encapsulation: 2
});

BaseChartComponent.ctorParameters = () => [{
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.NgZone
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectorRef
}, {
  type: undefined,
  decorators: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Inject,
    args: [_angular_core__WEBPACK_IMPORTED_MODULE_1__.PLATFORM_ID]
  }]
}];

BaseChartComponent.propDecorators = {
  results: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  view: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  scheme: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  schemeType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  customColors: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  animations: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  select: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](BaseChartComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'base-chart',
      template: ` <div></div> `
    }]
  }], function () {
    return [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.NgZone
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectorRef
    }, {
      type: undefined,
      decorators: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Inject,
        args: [_angular_core__WEBPACK_IMPORTED_MODULE_1__.PLATFORM_ID]
      }]
    }];
  }, {
    scheme: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    schemeType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    animations: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    select: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    results: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    view: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    customColors: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class AxisLabelComponent {
  constructor(element) {
    this.textHeight = 25;
    this.margin = 5;
    this.element = element.nativeElement;
  }

  ngOnChanges(changes) {
    this.update();
  }

  update() {
    this.strokeWidth = '0.01';
    this.textAnchor = 'middle';
    this.transform = '';

    switch (this.orient) {
      case 'top':
        this.y = this.offset;
        this.x = this.width / 2;
        break;

      case 'bottom':
        this.y = this.offset;
        this.x = this.width / 2;
        break;

      case 'left':
        this.y = -(this.offset + this.textHeight + this.margin);
        this.x = -this.height / 2;
        this.transform = 'rotate(270)';
        break;

      case 'right':
        this.y = this.offset + this.margin;
        this.x = -this.height / 2;
        this.transform = 'rotate(270)';
        break;

      default:
    }
  }

}

AxisLabelComponent.ɵfac = function AxisLabelComponent_Factory(t) {
  return new (t || AxisLabelComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef));
};

AxisLabelComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: AxisLabelComponent,
  selectors: [["g", "ngx-charts-axis-label", ""]],
  inputs: {
    orient: "orient",
    label: "label",
    offset: "offset",
    width: "width",
    height: "height"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c3,
  decls: 2,
  vars: 6,
  template: function AxisLabelComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "text");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("stroke-width", ctx.strokeWidth)("x", ctx.x)("y", ctx.y)("text-anchor", ctx.textAnchor)("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.label, " ");
    }
  },
  encapsulation: 2,
  changeDetection: 0
});

AxisLabelComponent.ctorParameters = () => [{
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
}];

AxisLabelComponent.propDecorators = {
  orient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  label: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  offset: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  width: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  height: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](AxisLabelComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-axis-label]',
      template: `
    <svg:text
      [attr.stroke-width]="strokeWidth"
      [attr.x]="x"
      [attr.y]="y"
      [attr.text-anchor]="textAnchor"
      [attr.transform]="transform"
    >
      {{ label }}
    </svg:text>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush
    }]
  }], function () {
    return [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
    }];
  }, {
    orient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    label: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    offset: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    width: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    height: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

function trimLabel(s, max = 16) {
  if (typeof s !== 'string') {
    if (typeof s === 'number') {
      return s + '';
    } else {
      return '';
    }
  }

  s = s.trim();

  if (s.length <= max) {
    return s;
  } else {
    return `${s.slice(0, max)}...`;
  }
}

function reduceTicks(ticks, maxTicks) {
  if (ticks.length > maxTicks) {
    const reduced = [];
    const modulus = Math.floor(ticks.length / maxTicks);

    for (let i = 0; i < ticks.length; i++) {
      if (i % modulus === 0) {
        reduced.push(ticks[i]);
      }
    }

    ticks = reduced;
  }

  return ticks;
}

class XAxisTicksComponent {
  constructor(platformId) {
    this.platformId = platformId;
    this.tickArguments = [5];
    this.tickStroke = '#ccc';
    this.trimTicks = true;
    this.maxTickLength = 16;
    this.showGridLines = false;
    this.rotateTicks = true;
    this.dimensionsChanged = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.verticalSpacing = 20;
    this.rotateLabels = false;
    this.innerTickSize = 6;
    this.outerTickSize = 6;
    this.tickPadding = 3;
    this.textAnchor = 'middle';
    this.maxTicksLength = 0;
    this.maxAllowedLength = 16;
    this.height = 0;
    this.approxHeight = 10;
  }

  ngOnChanges(changes) {
    this.update();
  }

  ngAfterViewInit() {
    setTimeout(() => this.updateDims());
  }

  updateDims() {
    if (!(0,_angular_common__WEBPACK_IMPORTED_MODULE_3__.isPlatformBrowser)(this.platformId)) {
      // for SSR, use approximate value instead of measured
      this.dimensionsChanged.emit({
        height: this.approxHeight
      });
      return;
    }

    const height = parseInt(this.ticksElement.nativeElement.getBoundingClientRect().height, 10);

    if (height !== this.height) {
      this.height = height;
      this.dimensionsChanged.emit({
        height: this.height
      });
      setTimeout(() => this.updateDims());
    }
  }

  update() {
    const scale = this.scale;
    this.ticks = this.getTicks();

    if (this.tickFormatting) {
      this.tickFormat = this.tickFormatting;
    } else if (scale.tickFormat) {
      this.tickFormat = scale.tickFormat.apply(scale, this.tickArguments);
    } else {
      this.tickFormat = function (d) {
        if (d.constructor.name === 'Date') {
          return d.toLocaleDateString();
        }

        return d.toLocaleString();
      };
    }

    const angle = this.rotateTicks ? this.getRotationAngle(this.ticks) : null;
    this.adjustedScale = this.scale.bandwidth ? function (d) {
      return this.scale(d) + this.scale.bandwidth() * 0.5;
    } : this.scale;
    this.textTransform = '';

    if (angle && angle !== 0) {
      this.textTransform = `rotate(${angle})`;
      this.textAnchor = 'end';
      this.verticalSpacing = 10;
    } else {
      this.textAnchor = 'middle';
    }

    setTimeout(() => this.updateDims());
  }

  getRotationAngle(ticks) {
    let angle = 0;
    this.maxTicksLength = 0;

    for (let i = 0; i < ticks.length; i++) {
      const tick = this.tickFormat(ticks[i]).toString();
      let tickLength = tick.length;

      if (this.trimTicks) {
        tickLength = this.tickTrim(tick).length;
      }

      if (tickLength > this.maxTicksLength) {
        this.maxTicksLength = tickLength;
      }
    }

    const len = Math.min(this.maxTicksLength, this.maxAllowedLength);
    const charWidth = 7; // need to measure this

    const wordWidth = len * charWidth;
    let baseWidth = wordWidth;
    const maxBaseWidth = Math.floor(this.width / ticks.length); // calculate optimal angle

    while (baseWidth > maxBaseWidth && angle > -90) {
      angle -= 30;
      baseWidth = Math.cos(angle * (Math.PI / 180)) * wordWidth;
    }

    this.approxHeight = Math.max(Math.abs(Math.sin(angle * (Math.PI / 180)) * wordWidth), 10);
    return angle;
  }

  getTicks() {
    let ticks;
    const maxTicks = this.getMaxTicks(20);
    const maxScaleTicks = this.getMaxTicks(100);

    if (this.tickValues) {
      ticks = this.tickValues;
    } else if (this.scale.ticks) {
      ticks = this.scale.ticks.apply(this.scale, [maxScaleTicks]);
    } else {
      ticks = this.scale.domain();
      ticks = reduceTicks(ticks, maxTicks);
    }

    return ticks;
  }

  getMaxTicks(tickWidth) {
    return Math.floor(this.width / tickWidth);
  }

  tickTransform(tick) {
    return 'translate(' + this.adjustedScale(tick) + ',' + this.verticalSpacing + ')';
  }

  gridLineTransform() {
    return `translate(0,${-this.verticalSpacing - 5})`;
  }

  tickTrim(label) {
    return this.trimTicks ? trimLabel(label, this.maxTickLength) : label;
  }

}

XAxisTicksComponent.ɵfac = function XAxisTicksComponent_Factory(t) {
  return new (t || XAxisTicksComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.PLATFORM_ID));
};

XAxisTicksComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: XAxisTicksComponent,
  selectors: [["g", "ngx-charts-x-axis-ticks", ""]],
  viewQuery: function XAxisTicksComponent_Query(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵviewQuery"](_c4, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.ticksElement = _t.first);
    }
  },
  inputs: {
    tickArguments: "tickArguments",
    tickStroke: "tickStroke",
    trimTicks: "trimTicks",
    maxTickLength: "maxTickLength",
    showGridLines: "showGridLines",
    rotateTicks: "rotateTicks",
    scale: "scale",
    orient: "orient",
    tickValues: "tickValues",
    tickFormatting: "tickFormatting",
    gridLineHeight: "gridLineHeight",
    width: "width"
  },
  outputs: {
    dimensionsChanged: "dimensionsChanged"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c5,
  decls: 4,
  vars: 2,
  consts: [["ticksel", ""], ["class", "tick", 4, "ngFor", "ngForOf"], [4, "ngFor", "ngForOf"], [1, "tick"], ["stroke-width", "0.01"], [4, "ngIf"], ["y2", "0", 1, "gridline-path", "gridline-path-vertical"]],
  template: function XAxisTicksComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", null, 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, XAxisTicksComponent__svg_g_2_Template, 5, 7, "g", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, XAxisTicksComponent__svg_g_3_Template, 2, 2, "g", 2);
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.ticks);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.ticks);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf],
  encapsulation: 2,
  changeDetection: 0
});

XAxisTicksComponent.ctorParameters = () => [{
  type: undefined,
  decorators: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Inject,
    args: [_angular_core__WEBPACK_IMPORTED_MODULE_1__.PLATFORM_ID]
  }]
}];

XAxisTicksComponent.propDecorators = {
  scale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  orient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tickArguments: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tickValues: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tickStroke: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showGridLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gridLineHeight: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  width: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  rotateTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  dimensionsChanged: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  ticksElement: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewChild,
    args: ['ticksel']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](XAxisTicksComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-x-axis-ticks]',
      template: `
    <svg:g #ticksel>
      <svg:g *ngFor="let tick of ticks" class="tick" [attr.transform]="tickTransform(tick)">
        <title>{{ tickFormat(tick) }}</title>
        <svg:text
          stroke-width="0.01"
          [attr.text-anchor]="textAnchor"
          [attr.transform]="textTransform"
          [style.font-size]="'12px'"
        >
          {{ tickTrim(tickFormat(tick)) }}
        </svg:text>
      </svg:g>
    </svg:g>

    <svg:g *ngFor="let tick of ticks" [attr.transform]="tickTransform(tick)">
      <svg:g *ngIf="showGridLines" [attr.transform]="gridLineTransform()">
        <svg:line class="gridline-path gridline-path-vertical" [attr.y1]="-gridLineHeight" y2="0" />
      </svg:g>
    </svg:g>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush
    }]
  }], function () {
    return [{
      type: undefined,
      decorators: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Inject,
        args: [_angular_core__WEBPACK_IMPORTED_MODULE_1__.PLATFORM_ID]
      }]
    }];
  }, {
    tickArguments: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tickStroke: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showGridLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    rotateTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    dimensionsChanged: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    scale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    orient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tickValues: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gridLineHeight: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    width: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    ticksElement: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewChild,
      args: ['ticksel']
    }]
  });
})();

class XAxisComponent {
  constructor() {
    this.rotateTicks = true;
    this.showGridLines = false;
    this.xOrient = 'bottom';
    this.xAxisOffset = 0;
    this.dimensionsChanged = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.xAxisClassName = 'x axis';
    this.labelOffset = 0;
    this.fill = 'none';
    this.stroke = 'stroke';
    this.tickStroke = '#ccc';
    this.strokeWidth = 'none';
    this.padding = 5;
  }

  ngOnChanges(changes) {
    this.update();
  }

  update() {
    this.transform = `translate(0,${this.xAxisOffset + this.padding + this.dims.height})`;

    if (typeof this.xAxisTickCount !== 'undefined') {
      this.tickArguments = [this.xAxisTickCount];
    }
  }

  emitTicksHeight({
    height
  }) {
    const newLabelOffset = height + 25 + 5;

    if (newLabelOffset !== this.labelOffset) {
      this.labelOffset = newLabelOffset;
      setTimeout(() => {
        this.dimensionsChanged.emit({
          height
        });
      }, 0);
    }
  }

}

XAxisComponent.ɵfac = function XAxisComponent_Factory(t) {
  return new (t || XAxisComponent)();
};

XAxisComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: XAxisComponent,
  selectors: [["g", "ngx-charts-x-axis", ""]],
  viewQuery: function XAxisComponent_Query(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵviewQuery"](XAxisTicksComponent, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.ticksComponent = _t.first);
    }
  },
  inputs: {
    rotateTicks: "rotateTicks",
    showGridLines: "showGridLines",
    xOrient: "xOrient",
    xAxisOffset: "xAxisOffset",
    xScale: "xScale",
    dims: "dims",
    trimTicks: "trimTicks",
    maxTickLength: "maxTickLength",
    tickFormatting: "tickFormatting",
    showLabel: "showLabel",
    labelText: "labelText",
    ticks: "ticks",
    xAxisTickInterval: "xAxisTickInterval",
    xAxisTickCount: "xAxisTickCount"
  },
  outputs: {
    dimensionsChanged: "dimensionsChanged"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c6,
  decls: 3,
  vars: 4,
  consts: [["ngx-charts-x-axis-ticks", "", 3, "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "tickArguments", "tickStroke", "scale", "orient", "showGridLines", "gridLineHeight", "width", "tickValues", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-axis-label", "", 3, "label", "offset", "orient", "height", "width", 4, "ngIf"], ["ngx-charts-x-axis-ticks", "", 3, "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "tickArguments", "tickStroke", "scale", "orient", "showGridLines", "gridLineHeight", "width", "tickValues", "dimensionsChanged"], ["ngx-charts-axis-label", "", 3, "label", "offset", "orient", "height", "width"]],
  template: function XAxisComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, XAxisComponent__svg_g_1_Template, 1, 12, "g", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, XAxisComponent__svg_g_2_Template, 1, 5, "g", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("class", ctx.xAxisClassName)("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.xScale);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.showLabel);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, AxisLabelComponent, XAxisTicksComponent],
  encapsulation: 2,
  changeDetection: 0
});
XAxisComponent.propDecorators = {
  xScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  dims: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  rotateTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showGridLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  labelText: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  ticks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTickInterval: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTickCount: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xOrient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisOffset: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  dimensionsChanged: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  ticksComponent: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewChild,
    args: [XAxisTicksComponent]
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](XAxisComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-x-axis]',
      template: `
    <svg:g [attr.class]="xAxisClassName" [attr.transform]="transform">
      <svg:g
        ngx-charts-x-axis-ticks
        *ngIf="xScale"
        [trimTicks]="trimTicks"
        [rotateTicks]="rotateTicks"
        [maxTickLength]="maxTickLength"
        [tickFormatting]="tickFormatting"
        [tickArguments]="tickArguments"
        [tickStroke]="tickStroke"
        [scale]="xScale"
        [orient]="xOrient"
        [showGridLines]="showGridLines"
        [gridLineHeight]="dims.height"
        [width]="dims.width"
        [tickValues]="ticks"
        (dimensionsChanged)="emitTicksHeight($event)"
      />
      <svg:g
        ngx-charts-axis-label
        *ngIf="showLabel"
        [label]="labelText"
        [offset]="labelOffset"
        [orient]="'bottom'"
        [height]="dims.height"
        [width]="dims.width"
      ></svg:g>
    </svg:g>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush
    }]
  }], function () {
    return [];
  }, {
    rotateTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showGridLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xOrient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisOffset: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    dimensionsChanged: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    xScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    dims: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    labelText: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    ticks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTickInterval: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTickCount: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    ticksComponent: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewChild,
      args: [XAxisTicksComponent]
    }]
  });
})();
/**
 * Generates a rounded rectanglar path
 *
 * @export
 * @param x, y, w, h, r, tl, tr, bl, br
 */


function roundedRect(x, y, w, h, r, [tl, tr, bl, br]) {
  let retval = '';
  w = Math.floor(w);
  h = Math.floor(h);
  w = w === 0 ? 1 : w;
  h = h === 0 ? 1 : h;
  retval = `M${[x + r, y]}`;
  retval += `h${w - 2 * r}`;

  if (tr) {
    retval += `a${[r, r]} 0 0 1 ${[r, r]}`;
  } else {
    retval += `h${r}v${r}`;
  }

  retval += `v${h - 2 * r}`;

  if (br) {
    retval += `a${[r, r]} 0 0 1 ${[-r, r]}`;
  } else {
    retval += `v${r}h${-r}`;
  }

  retval += `h${2 * r - w}`;

  if (bl) {
    retval += `a${[r, r]} 0 0 1 ${[-r, -r]}`;
  } else {
    retval += `h${-r}v${-r}`;
  }

  retval += `v${2 * r - h}`;

  if (tl) {
    retval += `a${[r, r]} 0 0 1 ${[r, -r]}`;
  } else {
    retval += `v${-r}h${r}`;
  }

  retval += `z`;
  return retval;
}

class YAxisTicksComponent {
  constructor(platformId) {
    this.platformId = platformId;
    this.tickArguments = [5];
    this.tickStroke = '#ccc';
    this.trimTicks = true;
    this.maxTickLength = 16;
    this.showGridLines = false;
    this.showRefLabels = false;
    this.showRefLines = false;
    this.dimensionsChanged = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.innerTickSize = 6;
    this.tickPadding = 3;
    this.verticalSpacing = 20;
    this.textAnchor = 'middle';
    this.width = 0;
    this.outerTickSize = 6;
    this.rotateLabels = false;
    this.referenceLineLength = 0;
  }

  ngOnChanges(changes) {
    this.update();
  }

  ngAfterViewInit() {
    setTimeout(() => this.updateDims());
  }

  updateDims() {
    if (!(0,_angular_common__WEBPACK_IMPORTED_MODULE_3__.isPlatformBrowser)(this.platformId)) {
      // for SSR, use approximate value instead of measured
      this.width = this.getApproximateAxisWidth();
      this.dimensionsChanged.emit({
        width: this.width
      });
      return;
    }

    const width = parseInt(this.ticksElement.nativeElement.getBoundingClientRect().width, 10);

    if (width !== this.width) {
      this.width = width;
      this.dimensionsChanged.emit({
        width
      });
      setTimeout(() => this.updateDims());
    }
  }

  update() {
    let scale;
    const sign = this.orient === 'top' || this.orient === 'right' ? -1 : 1;
    this.tickSpacing = Math.max(this.innerTickSize, 0) + this.tickPadding;
    scale = this.scale;
    this.ticks = this.getTicks();

    if (this.tickFormatting) {
      this.tickFormat = this.tickFormatting;
    } else if (scale.tickFormat) {
      this.tickFormat = scale.tickFormat.apply(scale, this.tickArguments);
    } else {
      this.tickFormat = function (d) {
        if (d.constructor.name === 'Date') {
          return d.toLocaleDateString();
        }

        return d.toLocaleString();
      };
    }

    this.adjustedScale = scale.bandwidth ? function (d) {
      return scale(d) + scale.bandwidth() * 0.5;
    } : scale;

    if (this.showRefLines && this.referenceLines) {
      this.setReferencelines();
    }

    switch (this.orient) {
      case 'top':
        this.transform = function (tick) {
          return 'translate(' + this.adjustedScale(tick) + ',0)';
        };

        this.textAnchor = 'middle';
        this.y2 = this.innerTickSize * sign;
        this.y1 = this.tickSpacing * sign;
        this.dy = sign < 0 ? '0em' : '.71em';
        break;

      case 'bottom':
        this.transform = function (tick) {
          return 'translate(' + this.adjustedScale(tick) + ',0)';
        };

        this.textAnchor = 'middle';
        this.y2 = this.innerTickSize * sign;
        this.y1 = this.tickSpacing * sign;
        this.dy = sign < 0 ? '0em' : '.71em';
        break;

      case 'left':
        this.transform = function (tick) {
          return 'translate(0,' + this.adjustedScale(tick) + ')';
        };

        this.textAnchor = 'end';
        this.x2 = this.innerTickSize * -sign;
        this.x1 = this.tickSpacing * -sign;
        this.dy = '.32em';
        break;

      case 'right':
        this.transform = function (tick) {
          return 'translate(0,' + this.adjustedScale(tick) + ')';
        };

        this.textAnchor = 'start';
        this.x2 = this.innerTickSize * -sign;
        this.x1 = this.tickSpacing * -sign;
        this.dy = '.32em';
        break;

      default:
    }

    setTimeout(() => this.updateDims());
  }

  setReferencelines() {
    this.refMin = this.adjustedScale(Math.min.apply(null, this.referenceLines.map(item => item.value)));
    this.refMax = this.adjustedScale(Math.max.apply(null, this.referenceLines.map(item => item.value)));
    this.referenceLineLength = this.referenceLines.length;
    this.referenceAreaPath = roundedRect(0, this.refMax, this.gridLineWidth, this.refMin - this.refMax, 0, [false, false, false, false]);
  }

  getTicks() {
    let ticks;
    const maxTicks = this.getMaxTicks(20);
    const maxScaleTicks = this.getMaxTicks(50);

    if (this.tickValues) {
      ticks = this.tickValues;
    } else if (this.scale.ticks) {
      ticks = this.scale.ticks.apply(this.scale, [maxScaleTicks]);
    } else {
      ticks = this.scale.domain();
      ticks = reduceTicks(ticks, maxTicks);
    }

    return ticks;
  }

  getMaxTicks(tickHeight) {
    return Math.floor(this.height / tickHeight);
  }

  tickTransform(tick) {
    return `translate(${this.adjustedScale(tick)},${this.verticalSpacing})`;
  }

  gridLineTransform() {
    return `translate(5,0)`;
  }

  tickTrim(label) {
    return this.trimTicks ? trimLabel(label, this.maxTickLength) : label;
  }

  getApproximateAxisWidth() {
    const maxChars = Math.max(...this.ticks.map(t => this.tickTrim(this.tickFormat(t)).length));
    const charWidth = 7;
    return maxChars * charWidth;
  }

}

YAxisTicksComponent.ɵfac = function YAxisTicksComponent_Factory(t) {
  return new (t || YAxisTicksComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.PLATFORM_ID));
};

YAxisTicksComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: YAxisTicksComponent,
  selectors: [["g", "ngx-charts-y-axis-ticks", ""]],
  viewQuery: function YAxisTicksComponent_Query(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵviewQuery"](_c4, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.ticksElement = _t.first);
    }
  },
  inputs: {
    tickArguments: "tickArguments",
    tickStroke: "tickStroke",
    trimTicks: "trimTicks",
    maxTickLength: "maxTickLength",
    showGridLines: "showGridLines",
    showRefLabels: "showRefLabels",
    showRefLines: "showRefLines",
    scale: "scale",
    orient: "orient",
    tickValues: "tickValues",
    tickFormatting: "tickFormatting",
    gridLineWidth: "gridLineWidth",
    height: "height",
    referenceLines: "referenceLines"
  },
  outputs: {
    dimensionsChanged: "dimensionsChanged"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c7,
  decls: 6,
  vars: 4,
  consts: [["ticksel", ""], ["class", "tick", 4, "ngFor", "ngForOf"], ["class", "reference-area", 4, "ngIf"], [4, "ngFor", "ngForOf"], [1, "tick"], ["stroke-width", "0.01"], [1, "reference-area"], [4, "ngIf"], ["class", "gridline-path gridline-path-horizontal", "x1", "0", 4, "ngIf"], ["x1", "0", 1, "gridline-path", "gridline-path-horizontal"], ["x1", "0", 1, "refline-path", "gridline-path-horizontal"], [1, "refline-label"]],
  template: function YAxisTicksComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", null, 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, YAxisTicksComponent__svg_g_2_Template, 5, 9, "g", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, YAxisTicksComponent__svg_path_3_Template, 1, 2, "path", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, YAxisTicksComponent__svg_g_4_Template, 2, 2, "g", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](5, YAxisTicksComponent__svg_g_5_Template, 2, 1, "g", 3);
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.ticks);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.referenceLineLength > 1 && ctx.refMax && ctx.refMin && ctx.showRefLines);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.ticks);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.referenceLines);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf],
  encapsulation: 2,
  changeDetection: 0
});

YAxisTicksComponent.ctorParameters = () => [{
  type: undefined,
  decorators: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Inject,
    args: [_angular_core__WEBPACK_IMPORTED_MODULE_1__.PLATFORM_ID]
  }]
}];

YAxisTicksComponent.propDecorators = {
  scale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  orient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tickArguments: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tickValues: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tickStroke: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showGridLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gridLineWidth: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  height: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  referenceLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showRefLabels: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showRefLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  dimensionsChanged: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  ticksElement: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewChild,
    args: ['ticksel']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](YAxisTicksComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-y-axis-ticks]',
      template: `
    <svg:g #ticksel>
      <svg:g *ngFor="let tick of ticks" class="tick" [attr.transform]="transform(tick)">
        <title>{{ tickFormat(tick) }}</title>
        <svg:text
          stroke-width="0.01"
          [attr.dy]="dy"
          [attr.x]="x1"
          [attr.y]="y1"
          [attr.text-anchor]="textAnchor"
          [style.font-size]="'12px'"
        >
          {{ tickTrim(tickFormat(tick)) }}
        </svg:text>
      </svg:g>
    </svg:g>

    <svg:path
      *ngIf="referenceLineLength > 1 && refMax && refMin && showRefLines"
      class="reference-area"
      [attr.d]="referenceAreaPath"
      [attr.transform]="gridLineTransform()"
    />
    <svg:g *ngFor="let tick of ticks" [attr.transform]="transform(tick)">
      <svg:g *ngIf="showGridLines" [attr.transform]="gridLineTransform()">
        <svg:line
          *ngIf="orient === 'left'"
          class="gridline-path gridline-path-horizontal"
          x1="0"
          [attr.x2]="gridLineWidth"
        />
        <svg:line
          *ngIf="orient === 'right'"
          class="gridline-path gridline-path-horizontal"
          x1="0"
          [attr.x2]="-gridLineWidth"
        />
      </svg:g>
    </svg:g>

    <svg:g *ngFor="let refLine of referenceLines">
      <svg:g *ngIf="showRefLines" [attr.transform]="transform(refLine.value)">
        <svg:line
          class="refline-path gridline-path-horizontal"
          x1="0"
          [attr.x2]="gridLineWidth"
          [attr.transform]="gridLineTransform()"
        />
        <svg:g *ngIf="showRefLabels">
          <title>{{ tickTrim(tickFormat(refLine.value)) }}</title>
          <svg:text
            class="refline-label"
            [attr.dy]="dy"
            [attr.y]="-6"
            [attr.x]="gridLineWidth"
            [attr.text-anchor]="textAnchor"
          >
            {{ refLine.name }}
          </svg:text>
        </svg:g>
      </svg:g>
    </svg:g>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush
    }]
  }], function () {
    return [{
      type: undefined,
      decorators: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Inject,
        args: [_angular_core__WEBPACK_IMPORTED_MODULE_1__.PLATFORM_ID]
      }]
    }];
  }, {
    tickArguments: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tickStroke: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showGridLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showRefLabels: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showRefLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    dimensionsChanged: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    scale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    orient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tickValues: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gridLineWidth: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    height: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    referenceLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    ticksElement: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewChild,
      args: ['ticksel']
    }]
  });
})();

class YAxisComponent {
  constructor() {
    this.showGridLines = false;
    this.yOrient = 'left';
    this.yAxisOffset = 0;
    this.dimensionsChanged = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.yAxisClassName = 'y axis';
    this.labelOffset = 15;
    this.fill = 'none';
    this.stroke = '#CCC';
    this.tickStroke = '#CCC';
    this.strokeWidth = 1;
    this.padding = 5;
  }

  ngOnChanges(changes) {
    this.update();
  }

  update() {
    this.offset = -(this.yAxisOffset + this.padding);

    if (this.yOrient === 'right') {
      this.labelOffset = 65;
      this.transform = `translate(${this.offset + this.dims.width} , 0)`;
    } else {
      this.offset = this.offset;
      this.transform = `translate(${this.offset} , 0)`;
    }

    if (this.yAxisTickCount !== undefined) {
      this.tickArguments = [this.yAxisTickCount];
    }
  }

  emitTicksWidth({
    width
  }) {
    if (width !== this.labelOffset && this.yOrient === 'right') {
      this.labelOffset = width + this.labelOffset;
      setTimeout(() => {
        this.dimensionsChanged.emit({
          width
        });
      }, 0);
    } else if (width !== this.labelOffset) {
      this.labelOffset = width;
      setTimeout(() => {
        this.dimensionsChanged.emit({
          width
        });
      }, 0);
    }
  }

}

YAxisComponent.ɵfac = function YAxisComponent_Factory(t) {
  return new (t || YAxisComponent)();
};

YAxisComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: YAxisComponent,
  selectors: [["g", "ngx-charts-y-axis", ""]],
  viewQuery: function YAxisComponent_Query(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵviewQuery"](YAxisTicksComponent, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.ticksComponent = _t.first);
    }
  },
  inputs: {
    showGridLines: "showGridLines",
    yOrient: "yOrient",
    yAxisOffset: "yAxisOffset",
    yScale: "yScale",
    dims: "dims",
    trimTicks: "trimTicks",
    maxTickLength: "maxTickLength",
    tickFormatting: "tickFormatting",
    ticks: "ticks",
    showLabel: "showLabel",
    labelText: "labelText",
    yAxisTickInterval: "yAxisTickInterval",
    yAxisTickCount: "yAxisTickCount",
    referenceLines: "referenceLines",
    showRefLines: "showRefLines",
    showRefLabels: "showRefLabels"
  },
  outputs: {
    dimensionsChanged: "dimensionsChanged"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c8,
  decls: 3,
  vars: 4,
  consts: [["ngx-charts-y-axis-ticks", "", 3, "trimTicks", "maxTickLength", "tickFormatting", "tickArguments", "tickValues", "tickStroke", "scale", "orient", "showGridLines", "gridLineWidth", "referenceLines", "showRefLines", "showRefLabels", "height", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-axis-label", "", 3, "label", "offset", "orient", "height", "width", 4, "ngIf"], ["ngx-charts-y-axis-ticks", "", 3, "trimTicks", "maxTickLength", "tickFormatting", "tickArguments", "tickValues", "tickStroke", "scale", "orient", "showGridLines", "gridLineWidth", "referenceLines", "showRefLines", "showRefLabels", "height", "dimensionsChanged"], ["ngx-charts-axis-label", "", 3, "label", "offset", "orient", "height", "width"]],
  template: function YAxisComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, YAxisComponent__svg_g_1_Template, 1, 14, "g", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, YAxisComponent__svg_g_2_Template, 1, 5, "g", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("class", ctx.yAxisClassName)("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.yScale);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.showLabel);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, AxisLabelComponent, YAxisTicksComponent],
  encapsulation: 2,
  changeDetection: 0
});
YAxisComponent.propDecorators = {
  yScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  dims: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  ticks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showGridLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  labelText: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTickInterval: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTickCount: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yOrient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  referenceLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showRefLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showRefLabels: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisOffset: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  dimensionsChanged: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  ticksComponent: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewChild,
    args: [YAxisTicksComponent]
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](YAxisComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-y-axis]',
      template: `
    <svg:g [attr.class]="yAxisClassName" [attr.transform]="transform">
      <svg:g
        ngx-charts-y-axis-ticks
        *ngIf="yScale"
        [trimTicks]="trimTicks"
        [maxTickLength]="maxTickLength"
        [tickFormatting]="tickFormatting"
        [tickArguments]="tickArguments"
        [tickValues]="ticks"
        [tickStroke]="tickStroke"
        [scale]="yScale"
        [orient]="yOrient"
        [showGridLines]="showGridLines"
        [gridLineWidth]="dims.width"
        [referenceLines]="referenceLines"
        [showRefLines]="showRefLines"
        [showRefLabels]="showRefLabels"
        [height]="dims.height"
        (dimensionsChanged)="emitTicksWidth($event)"
      />

      <svg:g
        ngx-charts-axis-label
        *ngIf="showLabel"
        [label]="labelText"
        [offset]="labelOffset"
        [orient]="yOrient"
        [height]="dims.height"
        [width]="dims.width"
      ></svg:g>
    </svg:g>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush
    }]
  }], function () {
    return [];
  }, {
    showGridLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yOrient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisOffset: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    dimensionsChanged: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    yScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    dims: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    ticks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    labelText: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTickInterval: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTickCount: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    referenceLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showRefLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showRefLabels: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    ticksComponent: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewChild,
      args: [YAxisTicksComponent]
    }]
  });
})();

class AxesModule {}

AxesModule.ɵfac = function AxesModule_Factory(t) {
  return new (t || AxesModule)();
};

AxesModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({
  type: AxesModule
});
AxesModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](AxesModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.NgModule,
    args: [{
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule],
      declarations: [AxisLabelComponent, XAxisComponent, XAxisTicksComponent, YAxisComponent, YAxisTicksComponent],
      exports: [AxisLabelComponent, XAxisComponent, XAxisTicksComponent, YAxisComponent, YAxisTicksComponent]
    }]
  }], null, null);
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](AxesModule, {
    declarations: function () {
      return [AxisLabelComponent, XAxisComponent, XAxisTicksComponent, YAxisComponent, YAxisTicksComponent];
    },
    imports: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule];
    },
    exports: function () {
      return [AxisLabelComponent, XAxisComponent, XAxisTicksComponent, YAxisComponent, YAxisTicksComponent];
    }
  });
})();

var StyleTypes;

(function (StyleTypes) {
  StyleTypes[StyleTypes["popover"] = 'popover'] = "popover";
  StyleTypes[StyleTypes["tooltip"] = 'tooltip'] = "tooltip";
})(StyleTypes || (StyleTypes = {}));

var AlignmentTypes;

(function (AlignmentTypes) {
  AlignmentTypes[AlignmentTypes["left"] = 'left'] = "left";
  AlignmentTypes[AlignmentTypes["center"] = 'center'] = "center";
  AlignmentTypes[AlignmentTypes["right"] = 'right'] = "right";
})(AlignmentTypes || (AlignmentTypes = {}));

var ShowTypes;

(function (ShowTypes) {
  ShowTypes[ShowTypes["all"] = 'all'] = "all";
  ShowTypes[ShowTypes["focus"] = 'focus'] = "focus";
  ShowTypes[ShowTypes["mouseover"] = 'mouseover'] = "mouseover";
})(ShowTypes || (ShowTypes = {}));

class TooltipDirective {
  constructor(tooltipService, viewContainerRef, renderer) {
    this.tooltipService = tooltipService;
    this.viewContainerRef = viewContainerRef;
    this.renderer = renderer;
    this.tooltipCssClass = '';
    this.tooltipTitle = '';
    this.tooltipAppendToBody = true;
    this.tooltipSpacing = 10;
    this.tooltipDisabled = false;
    this.tooltipShowCaret = true;
    this.tooltipPlacement = PlacementTypes.top;
    this.tooltipAlignment = AlignmentTypes.center;
    this.tooltipType = StyleTypes.popover;
    this.tooltipCloseOnClickOutside = true;
    this.tooltipCloseOnMouseLeave = true;
    this.tooltipHideTimeout = 300;
    this.tooltipShowTimeout = 100;
    this.tooltipShowEvent = ShowTypes.all;
    this.tooltipImmediateExit = false;
    this.show = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.hide = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
  }

  get listensForFocus() {
    return this.tooltipShowEvent === ShowTypes.all || this.tooltipShowEvent === ShowTypes.focus;
  }

  get listensForHover() {
    return this.tooltipShowEvent === ShowTypes.all || this.tooltipShowEvent === ShowTypes.mouseover;
  }

  ngOnDestroy() {
    this.hideTooltip(true);
  }

  onFocus() {
    if (this.listensForFocus) {
      this.showTooltip();
    }
  }

  onBlur() {
    if (this.listensForFocus) {
      this.hideTooltip(true);
    }
  }

  onMouseEnter() {
    if (this.listensForHover) {
      this.showTooltip();
    }
  }

  onMouseLeave(target) {
    if (this.listensForHover && this.tooltipCloseOnMouseLeave) {
      clearTimeout(this.timeout);

      if (this.component) {
        const contentDom = this.component.instance.element.nativeElement;
        const contains = contentDom.contains(target);
        if (contains) return;
      }

      this.hideTooltip(this.tooltipImmediateExit);
    }
  }

  onMouseClick() {
    if (this.listensForHover) {
      this.hideTooltip(true);
    }
  }

  showTooltip(immediate) {
    if (this.component || this.tooltipDisabled) return;
    const time = immediate ? 0 : this.tooltipShowTimeout + (navigator.userAgent.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/) ? 300 : 0);
    clearTimeout(this.timeout);
    this.timeout = setTimeout(() => {
      this.tooltipService.destroyAll();
      const options = this.createBoundOptions();
      this.component = this.tooltipService.create(options); // add a tiny timeout to avoid event re-triggers

      setTimeout(() => {
        if (this.component) {
          this.addHideListeners(this.component.instance.element.nativeElement);
        }
      }, 10);
      this.show.emit(true);
    }, time);
  }

  addHideListeners(tooltip) {
    // on mouse enter, cancel the hide triggered by the leave
    this.mouseEnterContentEvent = this.renderer.listen(tooltip, 'mouseenter', () => {
      clearTimeout(this.timeout);
    }); // content mouse leave listener

    if (this.tooltipCloseOnMouseLeave) {
      this.mouseLeaveContentEvent = this.renderer.listen(tooltip, 'mouseleave', () => {
        this.hideTooltip(this.tooltipImmediateExit);
      });
    } // content close on click outside


    if (this.tooltipCloseOnClickOutside) {
      this.documentClickEvent = this.renderer.listen('window', 'click', event => {
        const contains = tooltip.contains(event.target);
        if (!contains) this.hideTooltip();
      });
    }
  }

  hideTooltip(immediate = false) {
    if (!this.component) return;

    const destroyFn = () => {
      // remove events
      if (this.mouseLeaveContentEvent) this.mouseLeaveContentEvent();
      if (this.mouseEnterContentEvent) this.mouseEnterContentEvent();
      if (this.documentClickEvent) this.documentClickEvent(); // emit events

      this.hide.emit(true); // destroy component

      this.tooltipService.destroy(this.component);
      this.component = undefined;
    };

    clearTimeout(this.timeout);

    if (!immediate) {
      this.timeout = setTimeout(destroyFn, this.tooltipHideTimeout);
    } else {
      destroyFn();
    }
  }

  createBoundOptions() {
    return {
      title: this.tooltipTitle,
      template: this.tooltipTemplate,
      host: this.viewContainerRef.element,
      placement: this.tooltipPlacement,
      alignment: this.tooltipAlignment,
      type: this.tooltipType,
      showCaret: this.tooltipShowCaret,
      cssClass: this.tooltipCssClass,
      spacing: this.tooltipSpacing,
      context: this.tooltipContext
    };
  }

}

TooltipDirective.ɵfac = function TooltipDirective_Factory(t) {
  return new (t || TooltipDirective)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](TooltipService), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewContainerRef), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.Renderer2));
};

TooltipDirective.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineDirective"]({
  type: TooltipDirective,
  selectors: [["", "ngx-tooltip", ""]],
  hostBindings: function TooltipDirective_HostBindings(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("focusin", function TooltipDirective_focusin_HostBindingHandler() {
        return ctx.onFocus();
      })("blur", function TooltipDirective_blur_HostBindingHandler() {
        return ctx.onBlur();
      })("mouseenter", function TooltipDirective_mouseenter_HostBindingHandler() {
        return ctx.onMouseEnter();
      })("mouseleave", function TooltipDirective_mouseleave_HostBindingHandler($event) {
        return ctx.onMouseLeave($event.target);
      })("click", function TooltipDirective_click_HostBindingHandler() {
        return ctx.onMouseClick();
      });
    }
  },
  inputs: {
    tooltipCssClass: "tooltipCssClass",
    tooltipTitle: "tooltipTitle",
    tooltipAppendToBody: "tooltipAppendToBody",
    tooltipSpacing: "tooltipSpacing",
    tooltipDisabled: "tooltipDisabled",
    tooltipShowCaret: "tooltipShowCaret",
    tooltipPlacement: "tooltipPlacement",
    tooltipAlignment: "tooltipAlignment",
    tooltipType: "tooltipType",
    tooltipCloseOnClickOutside: "tooltipCloseOnClickOutside",
    tooltipCloseOnMouseLeave: "tooltipCloseOnMouseLeave",
    tooltipHideTimeout: "tooltipHideTimeout",
    tooltipShowTimeout: "tooltipShowTimeout",
    tooltipShowEvent: "tooltipShowEvent",
    tooltipImmediateExit: "tooltipImmediateExit",
    tooltipTemplate: "tooltipTemplate",
    tooltipContext: "tooltipContext"
  },
  outputs: {
    show: "show",
    hide: "hide"
  }
});

TooltipDirective.ctorParameters = () => [{
  type: TooltipService
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewContainerRef
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Renderer2
}];

TooltipDirective.propDecorators = {
  tooltipCssClass: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipTitle: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipAppendToBody: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipSpacing: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipShowCaret: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipPlacement: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipAlignment: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipCloseOnClickOutside: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipCloseOnMouseLeave: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipHideTimeout: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipShowTimeout: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipShowEvent: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipContext: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipImmediateExit: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  show: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  hide: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  onFocus: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['focusin']
  }],
  onBlur: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['blur']
  }],
  onMouseEnter: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['mouseenter']
  }],
  onMouseLeave: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['mouseleave', ['$event.target']]
  }],
  onMouseClick: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['click']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](TooltipDirective, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Directive,
    args: [{
      selector: '[ngx-tooltip]'
    }]
  }], function () {
    return [{
      type: TooltipService
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewContainerRef
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Renderer2
    }];
  }, {
    tooltipCssClass: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTitle: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipAppendToBody: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipSpacing: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipShowCaret: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipPlacement: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipAlignment: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipCloseOnClickOutside: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipCloseOnMouseLeave: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipHideTimeout: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipShowTimeout: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipShowEvent: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipImmediateExit: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    show: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    hide: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    onFocus: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['focusin']
    }],
    onBlur: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['blur']
    }],
    onMouseEnter: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['mouseenter']
    }],
    onMouseLeave: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['mouseleave', ['$event.target']]
    }],
    onMouseClick: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['click']
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipContext: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class TooltipModule {}

TooltipModule.ɵfac = function TooltipModule_Factory(t) {
  return new (t || TooltipModule)();
};

TooltipModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({
  type: TooltipModule
});
TooltipModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({
  providers: [InjectionService, TooltipService],
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](TooltipModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.NgModule,
    args: [{
      declarations: [TooltipContentComponent, TooltipDirective],
      providers: [InjectionService, TooltipService],
      exports: [TooltipContentComponent, TooltipDirective],
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule],
      entryComponents: [TooltipContentComponent]
    }]
  }], null, null);
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](TooltipModule, {
    declarations: function () {
      return [TooltipContentComponent, TooltipDirective];
    },
    imports: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule];
    },
    exports: function () {
      return [TooltipContentComponent, TooltipDirective];
    }
  });
})();
/**
 * Formats a label given a date, number or string.
 *
 * @export
 */


function formatLabel(label) {
  if (label instanceof Date) {
    label = label.toLocaleDateString();
  } else {
    label = label.toLocaleString();
  }

  return label;
}
/**
 * Escapes a label.
 *
 * @export
 */


function escapeLabel(label) {
  return label.toLocaleString().replace(/[&'`"<>]/g, match => {
    return {
      '&': '&amp;',
      // tslint:disable-next-line: quotemark
      "'": '&#x27;',
      '`': '&#x60;',
      '"': '&quot;',
      '<': '&lt;',
      '>': '&gt;'
    }[match];
  });
}

const cache = {};
/**
 * Generates a short id.
 *
 * Description:
 *   A 4-character alphanumeric sequence (364 = 1.6 million)
 *   This should only be used for JavaScript specific models.
 *   http://stackoverflow.com/questions/6248666/how-to-generate-short-uid-like-ax4j9z-in-js
 *
 *   Example: `ebgf`
 */

function id() {
  let newId = ('0000' + (Math.random() * Math.pow(36, 4) << 0).toString(36)).slice(-4); // append a 'a' because neo gets mad

  newId = `a${newId}`; // ensure not already used

  if (!cache[newId]) {
    cache[newId] = true;
    return newId;
  }

  return id();
}

class CircleSeriesComponent {
  constructor() {
    this.type = 'standard';
    this.tooltipDisabled = false;
    this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.barVisible = false;
  }

  ngOnInit() {
    this.gradientId = 'grad' + id().toString();
    this.gradientFill = `url(#${this.gradientId})`;
  }

  ngOnChanges(changes) {
    this.update();
  }

  update() {
    this.circle = this.getActiveCircle();
  }

  getActiveCircle() {
    const indexActiveDataPoint = this.data.series.findIndex(d => {
      const label = d.name;
      return label && this.visibleValue && label.toString() === this.visibleValue.toString() && d.value !== undefined;
    });

    if (indexActiveDataPoint === -1) {
      // No valid point is 'active/hovered over' at this moment.
      return undefined;
    }

    return this.mapDataPointToCircle(this.data.series[indexActiveDataPoint], indexActiveDataPoint);
  }

  mapDataPointToCircle(d, i) {
    const seriesName = this.data.name;
    const value = d.value;
    const label = d.name;
    const tooltipLabel = formatLabel(label);
    let cx;

    if (this.scaleType === 'time') {
      cx = this.xScale(label);
    } else if (this.scaleType === 'linear') {
      cx = this.xScale(Number(label));
    } else {
      cx = this.xScale(label);
    }

    const cy = this.yScale(this.type === 'standard' ? value : d.d1);
    const radius = 5;
    const height = this.yScale.range()[0] - cy;
    const opacity = 1;
    let color;

    if (this.colors.scaleType === 'linear') {
      if (this.type === 'standard') {
        color = this.colors.getColor(value);
      } else {
        color = this.colors.getColor(d.d1);
      }
    } else {
      color = this.colors.getColor(seriesName);
    }

    const data = Object.assign({}, d, {
      series: seriesName,
      value,
      name: label
    });
    return {
      classNames: [`circle-data-${i}`],
      value,
      label,
      data,
      cx,
      cy,
      radius,
      height,
      tooltipLabel,
      color,
      opacity,
      seriesName,
      gradientStops: this.getGradientStops(color),
      min: d.min,
      max: d.max
    };
  }

  getTooltipText({
    tooltipLabel,
    value,
    seriesName,
    min,
    max
  }) {
    return `
      <span class="tooltip-label">${escapeLabel(seriesName)} • ${escapeLabel(tooltipLabel)}</span>
      <span class="tooltip-val">${value.toLocaleString()}${this.getTooltipMinMaxText(min, max)}</span>
    `;
  }

  getTooltipMinMaxText(min, max) {
    if (min !== undefined || max !== undefined) {
      let result = ' (';

      if (min !== undefined) {
        if (max === undefined) {
          result += '≥';
        }

        result += min.toLocaleString();

        if (max !== undefined) {
          result += ' - ';
        }
      } else if (max !== undefined) {
        result += '≤';
      }

      if (max !== undefined) {
        result += max.toLocaleString();
      }

      result += ')';
      return result;
    } else {
      return '';
    }
  }

  getGradientStops(color) {
    return [{
      offset: 0,
      color,
      opacity: 0.2
    }, {
      offset: 100,
      color,
      opacity: 1
    }];
  }

  onClick(data) {
    this.select.emit(data);
  }

  isActive(entry) {
    if (!this.activeEntries) return false;
    const item = this.activeEntries.find(d => {
      return entry.name === d.name;
    });
    return item !== undefined;
  }

  activateCircle() {
    this.barVisible = true;
    this.activate.emit({
      name: this.data.name
    });
  }

  deactivateCircle() {
    this.barVisible = false;
    this.circle.opacity = 0;
    this.deactivate.emit({
      name: this.data.name
    });
  }

}

CircleSeriesComponent.ɵfac = function CircleSeriesComponent_Factory(t) {
  return new (t || CircleSeriesComponent)();
};

CircleSeriesComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: CircleSeriesComponent,
  selectors: [["g", "ngx-charts-circle-series", ""]],
  inputs: {
    type: "type",
    tooltipDisabled: "tooltipDisabled",
    data: "data",
    xScale: "xScale",
    yScale: "yScale",
    colors: "colors",
    scaleType: "scaleType",
    visibleValue: "visibleValue",
    activeEntries: "activeEntries",
    tooltipTemplate: "tooltipTemplate"
  },
  outputs: {
    select: "select",
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c9,
  decls: 1,
  vars: 1,
  consts: [[4, "ngIf"], ["ngx-charts-svg-linear-gradient", "", "orientation", "vertical", 3, "name", "stops"], ["class", "tooltip-bar", 4, "ngIf"], ["ngx-charts-circle", "", "ngx-tooltip", "", 1, "circle", 3, "cx", "cy", "r", "fill", "pointerEvents", "data", "classNames", "tooltipDisabled", "tooltipPlacement", "tooltipType", "tooltipTitle", "tooltipTemplate", "tooltipContext", "select", "activate", "deactivate"], [1, "tooltip-bar"]],
  template: function CircleSeriesComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, CircleSeriesComponent__svg_g_0_Template, 5, 20, "g", 0);
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.circle);
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, TooltipDirective, CircleComponent, SvgLinearGradientComponent];
  },
  encapsulation: 2,
  data: {
    animation: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':enter', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 0
    }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(250, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 1
    }))])])]
  },
  changeDetection: 0
});
CircleSeriesComponent.propDecorators = {
  data: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  type: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  colors: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  scaleType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  visibleValue: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  select: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](CircleSeriesComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-circle-series]',
      template: `
    <svg:g *ngIf="circle">
      <defs>
        <svg:g
          ngx-charts-svg-linear-gradient
          orientation="vertical"
          [name]="gradientId"
          [stops]="circle.gradientStops"
        />
      </defs>
      <svg:rect
        *ngIf="barVisible && type === 'standard'"
        [@animationState]="'active'"
        [attr.x]="circle.cx - circle.radius"
        [attr.y]="circle.cy"
        [attr.width]="circle.radius * 2"
        [attr.height]="circle.height"
        [attr.fill]="gradientFill"
        class="tooltip-bar"
      />
      <svg:g
        ngx-charts-circle
        class="circle"
        [cx]="circle.cx"
        [cy]="circle.cy"
        [r]="circle.radius"
        [fill]="circle.color"
        [class.active]="isActive({ name: circle.seriesName })"
        [pointerEvents]="circle.value === 0 ? 'none' : 'all'"
        [data]="circle.value"
        [classNames]="circle.classNames"
        (select)="onClick(circle.data)"
        (activate)="activateCircle()"
        (deactivate)="deactivateCircle()"
        ngx-tooltip
        [tooltipDisabled]="tooltipDisabled"
        [tooltipPlacement]="'top'"
        [tooltipType]="'tooltip'"
        [tooltipTitle]="tooltipTemplate ? undefined : getTooltipText(circle)"
        [tooltipTemplate]="tooltipTemplate"
        [tooltipContext]="circle.data"
      />
    </svg:g>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      animations: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':enter', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 0
      }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(250, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 1
      }))])])]
    }]
  }], function () {
    return [];
  }, {
    type: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    select: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    data: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    colors: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    scaleType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    visibleValue: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class CircleComponent {
  constructor() {
    this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
  }

  onClick() {
    this.select.emit(this.data);
  }

  onMouseEnter() {
    this.activate.emit(this.data);
  }

  onMouseLeave() {
    this.deactivate.emit(this.data);
  }

  ngOnChanges(changes) {
    this.classNames = Array.isArray(this.classNames) ? this.classNames.join(' ') : '';
    this.classNames += 'circle';
  }

}

CircleComponent.ɵfac = function CircleComponent_Factory(t) {
  return new (t || CircleComponent)();
};

CircleComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: CircleComponent,
  selectors: [["g", "ngx-charts-circle", ""]],
  hostBindings: function CircleComponent_HostBindings(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function CircleComponent_click_HostBindingHandler() {
        return ctx.onClick();
      })("mouseenter", function CircleComponent_mouseenter_HostBindingHandler() {
        return ctx.onMouseEnter();
      })("mouseleave", function CircleComponent_mouseleave_HostBindingHandler() {
        return ctx.onMouseLeave();
      });
    }
  },
  inputs: {
    classNames: "classNames",
    cx: "cx",
    cy: "cy",
    r: "r",
    fill: "fill",
    stroke: "stroke",
    data: "data",
    circleOpacity: "circleOpacity",
    pointerEvents: "pointerEvents"
  },
  outputs: {
    select: "select",
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c11,
  decls: 1,
  vars: 8,
  template: function CircleComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "circle");
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("cx", ctx.cx)("cy", ctx.cy)("r", ctx.r)("fill", ctx.fill)("stroke", ctx.stroke)("opacity", ctx.circleOpacity)("class", ctx.classNames)("pointer-events", ctx.pointerEvents);
    }
  },
  encapsulation: 2,
  changeDetection: 0
});
CircleComponent.propDecorators = {
  cx: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  cy: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  r: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  fill: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  stroke: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  data: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  classNames: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  circleOpacity: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  pointerEvents: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  select: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  onClick: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['click']
  }],
  onMouseEnter: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['mouseenter']
  }],
  onMouseLeave: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['mouseleave']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](CircleComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-circle]',
      template: `
    <svg:circle
      [attr.cx]="cx"
      [attr.cy]="cy"
      [attr.r]="r"
      [attr.fill]="fill"
      [attr.stroke]="stroke"
      [attr.opacity]="circleOpacity"
      [attr.class]="classNames"
      [attr.pointer-events]="pointerEvents"
    />
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush
    }]
  }], function () {
    return [];
  }, {
    select: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    onClick: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['click']
    }],
    onMouseEnter: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['mouseenter']
    }],
    onMouseLeave: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['mouseleave']
    }],
    classNames: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    cx: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    cy: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    r: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    fill: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    stroke: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    data: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    circleOpacity: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    pointerEvents: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class GridPanelComponent {}

GridPanelComponent.ɵfac = function GridPanelComponent_Factory(t) {
  return new (t || GridPanelComponent)();
};

GridPanelComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: GridPanelComponent,
  selectors: [["g", "ngx-charts-grid-panel", ""]],
  inputs: {
    path: "path",
    width: "width",
    height: "height",
    x: "x",
    y: "y"
  },
  attrs: _c12,
  decls: 1,
  vars: 4,
  consts: [["stroke", "none", 1, "gridpanel"]],
  template: function GridPanelComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "rect", 0);
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("height", ctx.height)("width", ctx.width)("x", ctx.x)("y", ctx.y);
    }
  },
  encapsulation: 2,
  changeDetection: 0
});
GridPanelComponent.propDecorators = {
  path: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  width: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  height: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  x: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  y: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](GridPanelComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-grid-panel]',
      template: `
    <svg:rect [attr.height]="height" [attr.width]="width" [attr.x]="x" [attr.y]="y" stroke="none" class="gridpanel" />
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush
    }]
  }], null, {
    path: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    width: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    height: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    x: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    y: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class GridPanelSeriesComponent {
  ngOnChanges(changes) {
    this.update();
  }

  update() {
    this.gridPanels = this.getGridPanels();
  }

  getGridPanels() {
    return this.data.map(d => {
      let offset;
      let width;
      let height;
      let x;
      let y;
      let className = 'odd';

      if (this.orient === 'vertical') {
        const position = this.xScale(d.name);
        const positionIndex = Number.parseInt((position / this.xScale.step()).toString(), 10);

        if (positionIndex % 2 === 1) {
          className = 'even';
        }

        offset = this.xScale.bandwidth() * this.xScale.paddingInner();
        width = this.xScale.bandwidth() + offset;
        height = this.dims.height;
        x = this.xScale(d.name) - offset / 2;
        y = 0;
      } else if (this.orient === 'horizontal') {
        const position = this.yScale(d.name);
        const positionIndex = Number.parseInt((position / this.yScale.step()).toString(), 10);

        if (positionIndex % 2 === 1) {
          className = 'even';
        }

        offset = this.yScale.bandwidth() * this.yScale.paddingInner();
        width = this.dims.width;
        height = this.yScale.bandwidth() + offset;
        x = 0;
        y = this.yScale(d.name) - offset / 2;
      }

      return {
        name: d.name,
        class: className,
        height,
        width,
        x,
        y
      };
    });
  }

}

GridPanelSeriesComponent.ɵfac = function GridPanelSeriesComponent_Factory(t) {
  return new (t || GridPanelSeriesComponent)();
};

GridPanelSeriesComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: GridPanelSeriesComponent,
  selectors: [["g", "ngx-charts-grid-panel-series", ""]],
  inputs: {
    data: "data",
    dims: "dims",
    xScale: "xScale",
    yScale: "yScale",
    orient: "orient"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c13,
  decls: 1,
  vars: 1,
  consts: [["ngx-charts-grid-panel", "", 3, "height", "width", "x", "y", "grid-panel", "odd", "even", 4, "ngFor", "ngForOf"], ["ngx-charts-grid-panel", "", 3, "height", "width", "x", "y"]],
  template: function GridPanelSeriesComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, GridPanelSeriesComponent__svg_g_0_Template, 1, 10, "g", 0);
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.gridPanels);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, GridPanelComponent],
  encapsulation: 2,
  changeDetection: 0
});
GridPanelSeriesComponent.propDecorators = {
  data: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  dims: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  orient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](GridPanelSeriesComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-grid-panel-series]',
      template: `
    <svg:g
      ngx-charts-grid-panel
      *ngFor="let gridPanel of gridPanels"
      [height]="gridPanel.height"
      [width]="gridPanel.width"
      [x]="gridPanel.x"
      [y]="gridPanel.y"
      [class.grid-panel]="true"
      [class.odd]="gridPanel.class === 'odd'"
      [class.even]="gridPanel.class === 'even'"
    ></svg:g>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush
    }]
  }], null, {
    data: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    dims: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    orient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class SvgLinearGradientComponent {
  constructor() {
    this.orientation = 'vertical';
  }

  ngOnChanges(changes) {
    this.x1 = '0%';
    this.x2 = '0%';
    this.y1 = '0%';
    this.y2 = '0%';

    if (this.orientation === 'horizontal') {
      this.x2 = '100%';
    } else if (this.orientation === 'vertical') {
      this.y1 = '100%';
    }
  }

}

SvgLinearGradientComponent.ɵfac = function SvgLinearGradientComponent_Factory(t) {
  return new (t || SvgLinearGradientComponent)();
};

SvgLinearGradientComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: SvgLinearGradientComponent,
  selectors: [["g", "ngx-charts-svg-linear-gradient", ""]],
  inputs: {
    orientation: "orientation",
    name: "name",
    stops: "stops"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c14,
  decls: 2,
  vars: 6,
  consts: [[3, "id"], [3, "stop-color", "stop-opacity", 4, "ngFor", "ngForOf"]],
  template: function SvgLinearGradientComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "linearGradient", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, SvgLinearGradientComponent__svg_stop_1_Template, 1, 5, "stop", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("id", ctx.name);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("x1", ctx.x1)("y1", ctx.y1)("x2", ctx.x2)("y2", ctx.y2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.stops);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf],
  encapsulation: 2,
  changeDetection: 0
});
SvgLinearGradientComponent.propDecorators = {
  orientation: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  name: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  stops: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](SvgLinearGradientComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-svg-linear-gradient]',
      template: `
    <svg:linearGradient [id]="name" [attr.x1]="x1" [attr.y1]="y1" [attr.x2]="x2" [attr.y2]="y2">
      <svg:stop
        *ngFor="let stop of stops"
        [attr.offset]="stop.offset + '%'"
        [style.stop-color]="stop.color"
        [style.stop-opacity]="stop.opacity"
      />
    </svg:linearGradient>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush
    }]
  }], function () {
    return [];
  }, {
    orientation: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    name: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    stops: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class SvgRadialGradientComponent {
  constructor() {
    this.endOpacity = 1;
    this.cx = 0;
    this.cy = 0;
  }

  get stops() {
    return this.stopsInput || this.stopsDefault;
  }

  set stops(value) {
    this.stopsInput = value;
  }

  ngOnChanges(changes) {
    this.r = '30%';

    if ('color' in changes || 'startOpacity' in changes || 'endOpacity' in changes) {
      this.stopsDefault = [{
        offset: 0,
        color: this.color,
        opacity: this.startOpacity
      }, {
        offset: 100,
        color: this.color,
        opacity: this.endOpacity
      }];
    }
  }

}

SvgRadialGradientComponent.ɵfac = function SvgRadialGradientComponent_Factory(t) {
  return new (t || SvgRadialGradientComponent)();
};

SvgRadialGradientComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: SvgRadialGradientComponent,
  selectors: [["g", "ngx-charts-svg-radial-gradient", ""]],
  inputs: {
    endOpacity: "endOpacity",
    cx: "cx",
    cy: "cy",
    stops: "stops",
    color: "color",
    name: "name",
    startOpacity: "startOpacity"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c15,
  decls: 2,
  vars: 5,
  consts: [["gradientUnits", "userSpaceOnUse", 3, "id"], [3, "stop-color", "stop-opacity", 4, "ngFor", "ngForOf"]],
  template: function SvgRadialGradientComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "radialGradient", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, SvgRadialGradientComponent__svg_stop_1_Template, 1, 5, "stop", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("id", ctx.name);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("cx", ctx.cx)("cy", ctx.cy)("r", ctx.r);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.stops);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf],
  encapsulation: 2,
  changeDetection: 0
});
SvgRadialGradientComponent.propDecorators = {
  color: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  name: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  startOpacity: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  endOpacity: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  cx: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  cy: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  stops: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](SvgRadialGradientComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-svg-radial-gradient]',
      template: `
    <svg:radialGradient [id]="name" [attr.cx]="cx" [attr.cy]="cy" [attr.r]="r" gradientUnits="userSpaceOnUse">
      <svg:stop
        *ngFor="let stop of stops"
        [attr.offset]="stop.offset + '%'"
        [style.stop-color]="stop.color"
        [style.stop-opacity]="stop.opacity"
      />
    </svg:radialGradient>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush
    }]
  }], function () {
    return [];
  }, {
    endOpacity: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    cx: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    cy: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    stops: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    color: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    name: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    startOpacity: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class AreaComponent {
  constructor(element) {
    this.opacity = 1;
    this.startOpacity = 0.5;
    this.endOpacity = 1;
    this.gradient = false;
    this.animations = true;
    this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.initialized = false;
    this.hasGradient = false;
    this.element = element.nativeElement;
  }

  ngOnChanges(changes) {
    if (!this.initialized) {
      this.loadAnimation();
      this.initialized = true;
    } else {
      this.update();
    }
  }

  update() {
    this.gradientId = 'grad' + id().toString();
    this.gradientFill = `url(#${this.gradientId})`;

    if (this.gradient || this.stops) {
      this.gradientStops = this.getGradient();
      this.hasGradient = true;
    } else {
      this.hasGradient = false;
    }

    this.updatePathEl();
  }

  loadAnimation() {
    this.areaPath = this.startingPath;
    setTimeout(this.update.bind(this), 100);
  }

  updatePathEl() {
    const node = (0,d3_selection__WEBPACK_IMPORTED_MODULE_8__["default"])(this.element).select('.area');

    if (this.animations) {
      node.transition().duration(750).attr('d', this.path);
    } else {
      node.attr('d', this.path);
    }
  }

  getGradient() {
    if (this.stops) {
      return this.stops;
    }

    return [{
      offset: 0,
      color: this.fill,
      opacity: this.startOpacity
    }, {
      offset: 100,
      color: this.fill,
      opacity: this.endOpacity
    }];
  }

}

AreaComponent.ɵfac = function AreaComponent_Factory(t) {
  return new (t || AreaComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef));
};

AreaComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: AreaComponent,
  selectors: [["g", "ngx-charts-area", ""]],
  inputs: {
    opacity: "opacity",
    startOpacity: "startOpacity",
    endOpacity: "endOpacity",
    gradient: "gradient",
    animations: "animations",
    data: "data",
    path: "path",
    startingPath: "startingPath",
    fill: "fill",
    activeLabel: "activeLabel",
    stops: "stops"
  },
  outputs: {
    select: "select"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c16,
  decls: 2,
  vars: 5,
  consts: [[4, "ngIf"], [1, "area"], ["ngx-charts-svg-linear-gradient", "", "orientation", "vertical", 3, "name", "stops"]],
  template: function AreaComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, AreaComponent__svg_defs_0_Template, 2, 2, "defs", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "path", 1);
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.gradient);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("opacity", ctx.opacity);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("d", ctx.areaPath)("fill", ctx.gradient ? ctx.gradientFill : ctx.fill);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, SvgLinearGradientComponent],
  encapsulation: 2,
  changeDetection: 0
});

AreaComponent.ctorParameters = () => [{
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
}];

AreaComponent.propDecorators = {
  data: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  path: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  startingPath: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  fill: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  opacity: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  startOpacity: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  endOpacity: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  stops: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  animations: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  select: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](AreaComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-area]',
      template: `
    <svg:defs *ngIf="gradient">
      <svg:g ngx-charts-svg-linear-gradient orientation="vertical" [name]="gradientId" [stops]="gradientStops" />
    </svg:defs>
    <svg:path class="area" [attr.d]="areaPath" [attr.fill]="gradient ? gradientFill : fill" [style.opacity]="opacity" />
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush
    }]
  }], function () {
    return [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
    }];
  }, {
    opacity: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    startOpacity: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    endOpacity: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    animations: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    select: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    data: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    path: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    startingPath: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    fill: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    stops: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})(); // Robert Penner's easeOutExpo


function easeOutExpo(t, b, c, d) {
  return c * (-Math.pow(2, -10 * t / d) + 1) * 1024 / 1023 + b;
}
/**
 * Counts from a number to the end incrementally.
 */


function count(countFrom, countTo, countDecimals, countDuration, callback) {
  const startVal = Number(countFrom);
  const endVal = Number(countTo);
  const countDown = startVal > endVal;
  const decimals = Math.max(0, countDecimals);
  const dec = Math.pow(10, decimals);
  const duration = Number(countDuration) * 1000;
  let startTime;

  function runCount(timestamp) {
    let frameVal;
    const progress = timestamp - startTime;

    if (countDown) {
      frameVal = startVal - easeOutExpo(progress, 0, startVal - endVal, duration);
    } else {
      frameVal = easeOutExpo(progress, startVal, endVal - startVal, duration);
    }

    if (countDown) {
      frameVal = frameVal < endVal ? endVal : frameVal;
    } else {
      frameVal = frameVal > endVal ? endVal : frameVal;
    }

    frameVal = Math.round(frameVal * dec) / dec;
    const tick = progress < duration;
    callback({
      value: frameVal,
      progress,
      timestamp,
      finished: !tick
    });

    if (tick) {
      return requestAnimationFrame(val => runCount(val));
    }
  }

  return requestAnimationFrame(timestamp => {
    startTime = timestamp;
    return runCount(timestamp);
  });
}
/**
 * Determine decimals places
 *
 * @export
 */


function decimalChecker(countTo) {
  const endVal = Number(countTo);

  if (endVal % 1 !== 0 && Math.abs(endVal) <= 10) {
    return 2;
  }

  return 0;
}
/**
 * Count up component
 *
 * Loosely inspired by:
 *  - https://github.com/izupet/angular2-counto
 *  - https://inorganik.github.io/countUp.js/
 *
 * @export
 */


class CountUpDirective {
  constructor(cd, element) {
    this.cd = cd;
    this.countDuration = 1;
    this.countPrefix = '';
    this.countSuffix = '';
    this.countChange = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.countFinish = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.value = '';
    this._countDecimals = 0;
    this._countTo = 0;
    this._countFrom = 0;
    this.nativeElement = element.nativeElement;
  }

  set countDecimals(val) {
    this._countDecimals = val;
  }

  get countDecimals() {
    if (this._countDecimals) return this._countDecimals;
    return decimalChecker(this.countTo);
  }

  set countTo(val) {
    this._countTo = parseFloat(val);
    this.start();
  }

  get countTo() {
    return this._countTo;
  }

  set countFrom(val) {
    this._countFrom = parseFloat(val);
    this.start();
  }

  get countFrom() {
    return this._countFrom;
  }

  ngOnDestroy() {
    cancelAnimationFrame(this.animationReq);
  }

  start() {
    cancelAnimationFrame(this.animationReq);

    const valueFormatting = this.valueFormatting || (value => `${this.countPrefix}${value.toLocaleString()}${this.countSuffix}`);

    const callback = ({
      value,
      progress,
      finished
    }) => {
      this.value = valueFormatting(value);
      this.cd.markForCheck();
      if (!finished) this.countChange.emit({
        value: this.value,
        progress
      });
      if (finished) this.countFinish.emit({
        value: this.value,
        progress
      });
    };

    this.animationReq = count(this.countFrom, this.countTo, this.countDecimals, this.countDuration, callback);
  }

}

CountUpDirective.ɵfac = function CountUpDirective_Factory(t) {
  return new (t || CountUpDirective)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectorRef), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef));
};

CountUpDirective.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: CountUpDirective,
  selectors: [["", "ngx-charts-count-up", ""]],
  inputs: {
    countDuration: "countDuration",
    countPrefix: "countPrefix",
    countSuffix: "countSuffix",
    countDecimals: "countDecimals",
    countTo: "countTo",
    countFrom: "countFrom",
    valueFormatting: "valueFormatting"
  },
  outputs: {
    countChange: "countChange",
    countFinish: "countFinish"
  },
  attrs: _c17,
  decls: 1,
  vars: 1,
  template: function CountUpDirective_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](0);
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.value, " ");
    }
  },
  encapsulation: 2
});

CountUpDirective.ctorParameters = () => [{
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectorRef
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
}];

CountUpDirective.propDecorators = {
  countDuration: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  countPrefix: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  countSuffix: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  valueFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  countDecimals: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  countTo: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  countFrom: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  countChange: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  countFinish: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](CountUpDirective, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: '[ngx-charts-count-up]',
      template: ` {{ value }} `
    }]
  }], function () {
    return [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectorRef
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
    }];
  }, {
    countDuration: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    countPrefix: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    countSuffix: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    countChange: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    countFinish: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    countDecimals: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    countTo: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    countFrom: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    valueFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})(); // If we don't check whether 'window' and 'global' variables are defined,
// code will fail in browser/node with 'variable is undefined' error.


let root;

if (typeof window !== 'undefined') {
  root = window;
} else if (typeof global !== 'undefined') {
  root = global;
} // tslint:disable-next-line:variable-name


const MouseEvent = root.MouseEvent;

function createMouseEvent(name, bubbles = false, cancelable = true) {
  // Calling new of an event does not work correctly on IE. The following is a tested workaround
  // See https://stackoverflow.com/questions/27176983/dispatchevent-not-working-in-ie11
  if (typeof MouseEvent === 'function') {
    // Sane browsers
    return new MouseEvent(name, {
      bubbles,
      cancelable
    });
  } else {
    // IE
    const event = document.createEvent('MouseEvent');
    event.initEvent(name, bubbles, cancelable);
    return event;
  }
}

class TooltipArea {
  constructor(platformId) {
    this.platformId = platformId;
    this.anchorOpacity = 0;
    this.anchorPos = -1;
    this.anchorValues = [];
    this.showPercentage = false;
    this.tooltipDisabled = false;
    this.hover = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
  }

  getValues(xVal) {
    const results = [];

    for (const group of this.results) {
      const item = group.series.find(d => d.name.toString() === xVal.toString());
      let groupName = group.name;

      if (groupName instanceof Date) {
        groupName = groupName.toLocaleDateString();
      }

      if (item) {
        const label = item.name;
        let val = item.value;

        if (this.showPercentage) {
          val = (item.d1 - item.d0).toFixed(2) + '%';
        }

        let color;

        if (this.colors.scaleType === 'linear') {
          let v = val;

          if (item.d1) {
            v = item.d1;
          }

          color = this.colors.getColor(v);
        } else {
          color = this.colors.getColor(group.name);
        }

        const data = Object.assign({}, item, {
          value: val,
          name: label,
          series: groupName,
          min: item.min,
          max: item.max,
          color
        });
        results.push(data);
      }
    }

    return results;
  }

  mouseMove(event) {
    if (!(0,_angular_common__WEBPACK_IMPORTED_MODULE_3__.isPlatformBrowser)(this.platformId)) {
      return;
    }

    const xPos = event.pageX - event.target.getBoundingClientRect().left;
    const closestIndex = this.findClosestPointIndex(xPos);
    const closestPoint = this.xSet[closestIndex];
    this.anchorPos = this.xScale(closestPoint);
    this.anchorPos = Math.max(0, this.anchorPos);
    this.anchorPos = Math.min(this.dims.width, this.anchorPos);
    this.anchorValues = this.getValues(closestPoint);

    if (this.anchorPos !== this.lastAnchorPos) {
      const ev = createMouseEvent('mouseleave');
      this.tooltipAnchor.nativeElement.dispatchEvent(ev);
      this.anchorOpacity = 0.7;
      this.hover.emit({
        value: closestPoint
      });
      this.showTooltip();
      this.lastAnchorPos = this.anchorPos;
    }
  }

  findClosestPointIndex(xPos) {
    let minIndex = 0;
    let maxIndex = this.xSet.length - 1;
    let minDiff = Number.MAX_VALUE;
    let closestIndex = 0;

    while (minIndex <= maxIndex) {
      const currentIndex = (minIndex + maxIndex) / 2 | 0;
      const currentElement = this.xScale(this.xSet[currentIndex]);
      const curDiff = Math.abs(currentElement - xPos);

      if (curDiff < minDiff) {
        minDiff = curDiff;
        closestIndex = currentIndex;
      }

      if (currentElement < xPos) {
        minIndex = currentIndex + 1;
      } else if (currentElement > xPos) {
        maxIndex = currentIndex - 1;
      } else {
        minDiff = 0;
        closestIndex = currentIndex;
        break;
      }
    }

    return closestIndex;
  }

  showTooltip() {
    const event = createMouseEvent('mouseenter');
    this.tooltipAnchor.nativeElement.dispatchEvent(event);
  }

  hideTooltip() {
    const event = createMouseEvent('mouseleave');
    this.tooltipAnchor.nativeElement.dispatchEvent(event);
    this.anchorOpacity = 0;
    this.lastAnchorPos = -1;
  }

  getToolTipText(tooltipItem) {
    let result = '';

    if (tooltipItem.series !== undefined) {
      result += tooltipItem.series;
    } else {
      result += '???';
    }

    result += ': ';

    if (tooltipItem.value !== undefined) {
      result += tooltipItem.value.toLocaleString();
    }

    if (tooltipItem.min !== undefined || tooltipItem.max !== undefined) {
      result += ' (';

      if (tooltipItem.min !== undefined) {
        if (tooltipItem.max === undefined) {
          result += '≥';
        }

        result += tooltipItem.min.toLocaleString();

        if (tooltipItem.max !== undefined) {
          result += ' - ';
        }
      } else if (tooltipItem.max !== undefined) {
        result += '≤';
      }

      if (tooltipItem.max !== undefined) {
        result += tooltipItem.max.toLocaleString();
      }

      result += ')';
    }

    return result;
  }

}

TooltipArea.ɵfac = function TooltipArea_Factory(t) {
  return new (t || TooltipArea)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.PLATFORM_ID));
};

TooltipArea.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: TooltipArea,
  selectors: [["g", "ngx-charts-tooltip-area", ""]],
  viewQuery: function TooltipArea_Query(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵviewQuery"](_c18, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.tooltipAnchor = _t.first);
    }
  },
  inputs: {
    showPercentage: "showPercentage",
    tooltipDisabled: "tooltipDisabled",
    dims: "dims",
    xSet: "xSet",
    xScale: "xScale",
    yScale: "yScale",
    results: "results",
    colors: "colors",
    tooltipTemplate: "tooltipTemplate"
  },
  outputs: {
    hover: "hover"
  },
  attrs: _c19,
  decls: 6,
  vars: 18,
  consts: [["y", "0", 1, "tooltip-area", 2, "opacity", "0", "cursor", "auto", 3, "mousemove", "mouseleave"], ["defaultTooltipTemplate", ""], ["y", "0", "ngx-tooltip", "", 1, "tooltip-anchor", 3, "tooltipDisabled", "tooltipPlacement", "tooltipType", "tooltipSpacing", "tooltipTemplate", "tooltipContext", "tooltipImmediateExit"], ["tooltipAnchor", ""], [1, "area-tooltip-container"], ["class", "tooltip-item", 4, "ngFor", "ngForOf"], [1, "tooltip-item"], [1, "tooltip-item-color"]],
  template: function TooltipArea_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g")(1, "rect", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("mousemove", function TooltipArea_Template__svg_rect_mousemove_1_listener($event) {
        return ctx.mouseMove($event);
      })("mouseleave", function TooltipArea_Template__svg_rect_mouseleave_1_listener() {
        return ctx.hideTooltip();
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, TooltipArea__svg_ng_template_2_Template, 2, 1, "ng-template", null, 1, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplateRefExtractor"]);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](4, "rect", 2, 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](3);

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("x", 0)("width", ctx.dims.width)("height", ctx.dims.height);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("opacity", ctx.anchorOpacity)("pointer-events", "none");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("@animationState", ctx.anchorOpacity !== 0 ? "active" : "inactive")("tooltipDisabled", ctx.tooltipDisabled)("tooltipPlacement", "right")("tooltipType", "tooltip")("tooltipSpacing", 15)("tooltipTemplate", ctx.tooltipTemplate ? ctx.tooltipTemplate : _r0)("tooltipContext", ctx.anchorValues)("tooltipImmediateExit", true);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("x", ctx.anchorPos)("width", 1)("height", ctx.dims.height);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, TooltipDirective],
  encapsulation: 2,
  data: {
    animation: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)('inactive => active', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 0
    }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(250, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 0.7
    }))]), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)('active => inactive', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 0.7
    }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(250, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 0
    }))])])]
  },
  changeDetection: 0
});

TooltipArea.ctorParameters = () => [{
  type: undefined,
  decorators: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Inject,
    args: [_angular_core__WEBPACK_IMPORTED_MODULE_1__.PLATFORM_ID]
  }]
}];

TooltipArea.propDecorators = {
  dims: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xSet: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  results: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  colors: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showPercentage: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  hover: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  tooltipAnchor: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewChild,
    args: ['tooltipAnchor', {
      static: false
    }]
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](TooltipArea, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-tooltip-area]',
      template: `
    <svg:g>
      <svg:rect
        class="tooltip-area"
        [attr.x]="0"
        y="0"
        [attr.width]="dims.width"
        [attr.height]="dims.height"
        style="opacity: 0; cursor: 'auto';"
        (mousemove)="mouseMove($event)"
        (mouseleave)="hideTooltip()"
      />
      <ng-template #defaultTooltipTemplate let-model="model">
        <xhtml:div class="area-tooltip-container">
          <xhtml:div *ngFor="let tooltipItem of model" class="tooltip-item">
            <xhtml:span class="tooltip-item-color" [style.background-color]="tooltipItem.color"></xhtml:span>
            {{ getToolTipText(tooltipItem) }}
          </xhtml:div>
        </xhtml:div>
      </ng-template>
      <svg:rect
        #tooltipAnchor
        [@animationState]="anchorOpacity !== 0 ? 'active' : 'inactive'"
        class="tooltip-anchor"
        [attr.x]="anchorPos"
        y="0"
        [attr.width]="1"
        [attr.height]="dims.height"
        [style.opacity]="anchorOpacity"
        [style.pointer-events]="'none'"
        ngx-tooltip
        [tooltipDisabled]="tooltipDisabled"
        [tooltipPlacement]="'right'"
        [tooltipType]="'tooltip'"
        [tooltipSpacing]="15"
        [tooltipTemplate]="tooltipTemplate ? tooltipTemplate : defaultTooltipTemplate"
        [tooltipContext]="anchorValues"
        [tooltipImmediateExit]="true"
      />
    </svg:g>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      animations: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)('inactive => active', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 0
      }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(250, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 0.7
      }))]), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)('active => inactive', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 0.7
      }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(250, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 0
      }))])])]
    }]
  }], function () {
    return [{
      type: undefined,
      decorators: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Inject,
        args: [_angular_core__WEBPACK_IMPORTED_MODULE_1__.PLATFORM_ID]
      }]
    }];
  }, {
    showPercentage: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    hover: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    dims: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xSet: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    results: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    colors: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipAnchor: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewChild,
      args: ['tooltipAnchor', {
        static: false
      }]
    }]
  });
})();

class Timeline {
  constructor(element, cd) {
    this.cd = cd;
    this.height = 50;
    this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.onDomainChange = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.initialized = false;
    this.element = element.nativeElement;
  }

  ngOnChanges(changes) {
    this.update();

    if (!this.initialized) {
      this.addBrush();
      this.initialized = true;
    }
  }

  update() {
    this.dims = this.getDims();
    this.height = this.dims.height;
    const offsetY = this.view[1] - this.height;
    this.xDomain = this.getXDomain();
    this.xScale = this.getXScale();

    if (this.brush) {
      this.updateBrush();
    }

    this.transform = `translate(0 , ${offsetY})`;
    this.filterId = 'filter' + id().toString();
    this.filter = `url(#${this.filterId})`;
    this.cd.markForCheck();
  }

  getXDomain() {
    let values = [];

    for (const results of this.results) {
      for (const d of results.series) {
        if (!values.includes(d.name)) {
          values.push(d.name);
        }
      }
    }

    let domain = [];

    if (this.scaleType === 'time') {
      const min = Math.min(...values);
      const max = Math.max(...values);
      domain = [min, max];
    } else if (this.scaleType === 'linear') {
      values = values.map(v => Number(v));
      const min = Math.min(...values);
      const max = Math.max(...values);
      domain = [min, max];
    } else {
      domain = values;
    }

    return domain;
  }

  getXScale() {
    let scale;

    if (this.scaleType === 'time') {
      scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_9__["default"])().range([0, this.dims.width]).domain(this.xDomain);
    } else if (this.scaleType === 'linear') {
      scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().range([0, this.dims.width]).domain(this.xDomain);
    } else if (this.scaleType === 'ordinal') {
      scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_11__.point)().range([0, this.dims.width]).padding(0.1).domain(this.xDomain);
    }

    return scale;
  }

  addBrush() {
    if (this.brush) return;
    const height = this.height;
    const width = this.view[0];
    this.brush = (0,d3_brush__WEBPACK_IMPORTED_MODULE_0__.brushX)().extent([[0, 0], [width, height]]).on('brush end', ({
      d3selection
    }) => {
      const selection = d3selection || this.xScale.range();
      const newDomain = selection.map(this.xScale.invert);
      this.onDomainChange.emit(newDomain);
      this.cd.markForCheck();
    });
    (0,d3_selection__WEBPACK_IMPORTED_MODULE_8__["default"])(this.element).select('.brush').call(this.brush);
  }

  updateBrush() {
    if (!this.brush) return;
    const height = this.height;
    const width = this.view[0];
    this.brush.extent([[0, 0], [width, height]]);
    (0,d3_selection__WEBPACK_IMPORTED_MODULE_8__["default"])(this.element).select('.brush').call(this.brush); // clear hardcoded properties so they can be defined by CSS

    (0,d3_selection__WEBPACK_IMPORTED_MODULE_8__["default"])(this.element).select('.selection').attr('fill', undefined).attr('stroke', undefined).attr('fill-opacity', undefined);
    this.cd.markForCheck();
  }

  getDims() {
    const width = this.view[0];
    const dims = {
      width,
      height: this.height
    };
    return dims;
  }

}

Timeline.ɵfac = function Timeline_Factory(t) {
  return new (t || Timeline)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectorRef));
};

Timeline.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: Timeline,
  selectors: [["g", "ngx-charts-timeline", ""]],
  inputs: {
    height: "height",
    view: "view",
    state: "state",
    results: "results",
    scheme: "scheme",
    customColors: "customColors",
    legend: "legend",
    miniChart: "miniChart",
    autoScale: "autoScale",
    scaleType: "scaleType"
  },
  outputs: {
    select: "select",
    onDomainChange: "onDomainChange"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c20,
  ngContentSelectors: _c2,
  decls: 7,
  vars: 4,
  consts: [[1, "timeline"], ["in", "SourceGraphic", "type", "matrix", "values", "0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0"], [1, "embedded-chart"], ["x", "0", "y", "0", 1, "brush-background"], [1, "brush"]],
  template: function Timeline_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵprojectionDef"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 0)(1, "filter");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](2, "feColorMatrix", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "g", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵprojection"](4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](5, "rect", 3)(6, "g", 4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("id", ctx.filterId);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("width", ctx.view[0])("height", ctx.height);
    }
  },
  styles: [".timeline .brush-background{fill:rgba(0,0,0,.05)}.timeline .brush .selection{fill:rgba(0,0,0,.1);stroke:#888;stroke-width:1px}.timeline .brush .handle{fill-opacity:0}.timeline .embedded-chart{opacity:.6}"],
  encapsulation: 2,
  changeDetection: 0
});

Timeline.ctorParameters = () => [{
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectorRef
}];

Timeline.propDecorators = {
  view: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  state: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  results: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  scheme: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  customColors: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legend: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  miniChart: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  autoScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  scaleType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  height: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  select: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  onDomainChange: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](Timeline, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-timeline]',
      template: `
    <svg:g class="timeline" [attr.transform]="transform">
      <svg:filter [attr.id]="filterId">
        <svg:feColorMatrix
          in="SourceGraphic"
          type="matrix"
          values="0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0"
        />
      </svg:filter>
      <svg:g class="embedded-chart">
        <ng-content></ng-content>
      </svg:g>
      <svg:rect x="0" [attr.width]="view[0]" y="0" [attr.height]="height" class="brush-background" />
      <svg:g class="brush"></svg:g>
    </svg:g>
  `,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      styles: [".timeline .brush-background{fill:rgba(0,0,0,.05)}.timeline .brush .selection{fill:rgba(0,0,0,.1);stroke:#888;stroke-width:1px}.timeline .brush .handle{fill-opacity:0}.timeline .embedded-chart{opacity:.6}"]
    }]
  }], function () {
    return [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectorRef
    }];
  }, {
    height: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    select: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    onDomainChange: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    view: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    state: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    results: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    scheme: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    customColors: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legend: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    miniChart: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    autoScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    scaleType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class LegendComponent {
  constructor(cd) {
    this.cd = cd;
    this.horizontal = false;
    this.labelClick = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.labelActivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.labelDeactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.legendEntries = [];
  }

  ngOnChanges(changes) {
    this.update();
  }

  update() {
    this.cd.markForCheck();
    this.legendEntries = this.getLegendEntries();
  }

  getLegendEntries() {
    const items = [];

    for (const label of this.data) {
      const formattedLabel = formatLabel(label);
      const idx = items.findIndex(i => {
        return i.label === formattedLabel;
      });

      if (idx === -1) {
        items.push({
          label,
          formattedLabel,
          color: this.colors.getColor(label)
        });
      }
    }

    return items;
  }

  isActive(entry) {
    if (!this.activeEntries) return false;
    const item = this.activeEntries.find(d => {
      return entry.label === d.name;
    });
    return item !== undefined;
  }

  activate(item) {
    this.labelActivate.emit(item);
  }

  deactivate(item) {
    this.labelDeactivate.emit(item);
  }

  trackBy(index, item) {
    return item.label;
  }

}

LegendComponent.ɵfac = function LegendComponent_Factory(t) {
  return new (t || LegendComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectorRef));
};

LegendComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: LegendComponent,
  selectors: [["ngx-charts-legend"]],
  inputs: {
    horizontal: "horizontal",
    data: "data",
    title: "title",
    colors: "colors",
    height: "height",
    width: "width",
    activeEntries: "activeEntries"
  },
  outputs: {
    labelClick: "labelClick",
    labelActivate: "labelActivate",
    labelDeactivate: "labelDeactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  decls: 5,
  vars: 9,
  consts: [["class", "legend-title", 4, "ngIf"], [1, "legend-wrap"], [1, "legend-labels"], ["class", "legend-label", 4, "ngFor", "ngForOf", "ngForTrackBy"], [1, "legend-title"], [1, "legend-title-text"], [1, "legend-label"], [3, "label", "formattedLabel", "color", "isActive", "select", "activate", "deactivate"]],
  template: function LegendComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, LegendComponent_header_1_Template, 3, 1, "header", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 1)(3, "ul", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, LegendComponent_li_4_Template, 2, 4, "li", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("width", ctx.width, "px");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (ctx.title == null ? null : ctx.title.length) > 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("max-height", ctx.height - 45, "px");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("horizontal-legend", ctx.horizontal);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.legendEntries)("ngForTrackBy", ctx.trackBy);
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, LegendEntryComponent];
  },
  styles: [".chart-legend{display:inline-block;padding:0;width:auto!important}.chart-legend .legend-title{font-size:14px;font-weight:700;margin-bottom:5px;margin-left:10px;overflow:hidden;white-space:nowrap}.chart-legend li,.chart-legend ul{list-style:none;margin:0;padding:0}.chart-legend .horizontal-legend li{display:inline-block}.chart-legend .legend-wrap{width:calc(100% - 10px)}.chart-legend .legend-labels{background:rgba(0,0,0,.05);border-radius:3px;float:left;line-height:85%;list-style:none;overflow-x:hidden;overflow-y:auto;text-align:left;white-space:nowrap;width:100%}.chart-legend .legend-label{color:#afb7c8;cursor:pointer;font-size:90%;margin:8px}.chart-legend .legend-label:hover{color:#000;transition:.2s}.chart-legend .legend-label .active .legend-label-text{color:#000}.chart-legend .legend-label-color{border-radius:3px;color:#5b646b;display:inline-block;height:15px;margin-right:5px;width:15px}.chart-legend .legend-label-text{font-size:12px;line-height:15px;vertical-align:top;width:calc(100% - 20px)}.chart-legend .legend-label-text,.chart-legend .legend-title-text{display:inline-block;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.chart-legend .legend-title-text{line-height:16px;vertical-align:bottom}"],
  encapsulation: 2,
  changeDetection: 0
});

LegendComponent.ctorParameters = () => [{
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectorRef
}];

LegendComponent.propDecorators = {
  data: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  title: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  colors: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  height: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  width: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  horizontal: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  labelClick: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  labelActivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  labelDeactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](LegendComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-charts-legend',
      template: `
    <div [style.width.px]="width">
      <header class="legend-title" *ngIf="title?.length > 0">
        <span class="legend-title-text">{{ title }}</span>
      </header>
      <div class="legend-wrap">
        <ul class="legend-labels" [class.horizontal-legend]="horizontal" [style.max-height.px]="height - 45">
          <li *ngFor="let entry of legendEntries; trackBy: trackBy" class="legend-label">
            <ngx-charts-legend-entry
              [label]="entry.label"
              [formattedLabel]="entry.formattedLabel"
              [color]="entry.color"
              [isActive]="isActive(entry)"
              (select)="labelClick.emit($event)"
              (activate)="activate($event)"
              (deactivate)="deactivate($event)"
            >
            </ngx-charts-legend-entry>
          </li>
        </ul>
      </div>
    </div>
  `,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      styles: [".chart-legend{display:inline-block;padding:0;width:auto!important}.chart-legend .legend-title{font-size:14px;font-weight:700;margin-bottom:5px;margin-left:10px;overflow:hidden;white-space:nowrap}.chart-legend li,.chart-legend ul{list-style:none;margin:0;padding:0}.chart-legend .horizontal-legend li{display:inline-block}.chart-legend .legend-wrap{width:calc(100% - 10px)}.chart-legend .legend-labels{background:rgba(0,0,0,.05);border-radius:3px;float:left;line-height:85%;list-style:none;overflow-x:hidden;overflow-y:auto;text-align:left;white-space:nowrap;width:100%}.chart-legend .legend-label{color:#afb7c8;cursor:pointer;font-size:90%;margin:8px}.chart-legend .legend-label:hover{color:#000;transition:.2s}.chart-legend .legend-label .active .legend-label-text{color:#000}.chart-legend .legend-label-color{border-radius:3px;color:#5b646b;display:inline-block;height:15px;margin-right:5px;width:15px}.chart-legend .legend-label-text{font-size:12px;line-height:15px;vertical-align:top;width:calc(100% - 20px)}.chart-legend .legend-label-text,.chart-legend .legend-title-text{display:inline-block;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.chart-legend .legend-title-text{line-height:16px;vertical-align:bottom}"]
    }]
  }], function () {
    return [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectorRef
    }];
  }, {
    horizontal: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    labelClick: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    labelActivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    labelDeactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    data: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    title: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    colors: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    height: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    width: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class LegendEntryComponent {
  constructor() {
    this.isActive = false;
    this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.toggle = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
  }

  get trimmedLabel() {
    return this.formattedLabel || '(empty)';
  }

  onMouseEnter() {
    this.activate.emit({
      name: this.label
    });
  }

  onMouseLeave() {
    this.deactivate.emit({
      name: this.label
    });
  }

}

LegendEntryComponent.ɵfac = function LegendEntryComponent_Factory(t) {
  return new (t || LegendEntryComponent)();
};

LegendEntryComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: LegendEntryComponent,
  selectors: [["ngx-charts-legend-entry"]],
  hostBindings: function LegendEntryComponent_HostBindings(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("mouseenter", function LegendEntryComponent_mouseenter_HostBindingHandler() {
        return ctx.onMouseEnter();
      })("mouseleave", function LegendEntryComponent_mouseleave_HostBindingHandler() {
        return ctx.onMouseLeave();
      });
    }
  },
  inputs: {
    isActive: "isActive",
    color: "color",
    label: "label",
    formattedLabel: "formattedLabel"
  },
  outputs: {
    select: "select",
    activate: "activate",
    deactivate: "deactivate",
    toggle: "toggle"
  },
  decls: 4,
  vars: 6,
  consts: [["tabindex", "-1", 3, "title", "click"], [1, "legend-label-color", 3, "click"], [1, "legend-label-text"]],
  template: function LegendEntryComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "span", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function LegendEntryComponent_Template_span_click_0_listener() {
        return ctx.select.emit(ctx.formattedLabel);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "span", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function LegendEntryComponent_Template_span_click_1_listener() {
        return ctx.toggle.emit(ctx.formattedLabel);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "span", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("active", ctx.isActive);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("title", ctx.formattedLabel);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("background-color", ctx.color);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.trimmedLabel, " ");
    }
  },
  encapsulation: 2,
  changeDetection: 0
});
LegendEntryComponent.propDecorators = {
  color: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  label: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  formattedLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  isActive: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  select: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  toggle: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  onMouseEnter: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['mouseenter']
  }],
  onMouseLeave: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['mouseleave']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](LegendEntryComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-charts-legend-entry',
      template: `
    <span [title]="formattedLabel" tabindex="-1" [class.active]="isActive" (click)="select.emit(formattedLabel)">
      <span class="legend-label-color" [style.background-color]="color" (click)="toggle.emit(formattedLabel)"> </span>
      <span class="legend-label-text">
        {{ trimmedLabel }}
      </span>
    </span>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush
    }]
  }], function () {
    return [];
  }, {
    isActive: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    select: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    toggle: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    onMouseEnter: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['mouseenter']
    }],
    onMouseLeave: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['mouseleave']
    }],
    color: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    label: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    formattedLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class ScaleLegendComponent {
  constructor(sanitizer) {
    this.sanitizer = sanitizer;
    this.horizontal = false;
  }

  ngOnChanges(changes) {
    const gradientValues = this.gradientString(this.colors.range(), this.colors.domain());
    const direction = this.horizontal ? 'right' : 'bottom';
    this.gradient = `linear-gradient(to ${direction}, ${gradientValues})`;
  }
  /**
   * Generates the string used in the gradient stylesheet properties
   * @param colors array of colors
   * @param splits array of splits on a scale of (0, 1)
   */


  gradientString(colors, splits) {
    // add the 100%
    splits.push(1);
    const pairs = [];
    colors.reverse().forEach((c, i) => {
      pairs.push(`${c} ${Math.round(splits[i] * 100)}%`);
    });
    return pairs.join(', ');
  }

}

ScaleLegendComponent.ɵfac = function ScaleLegendComponent_Factory(t) {
  return new (t || ScaleLegendComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_platform_browser__WEBPACK_IMPORTED_MODULE_12__.DomSanitizer));
};

ScaleLegendComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: ScaleLegendComponent,
  selectors: [["ngx-charts-scale-legend"]],
  inputs: {
    horizontal: "horizontal",
    valueRange: "valueRange",
    colors: "colors",
    height: "height",
    width: "width"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  decls: 8,
  vars: 10,
  consts: [[1, "scale-legend"], [1, "scale-legend-label"], [1, "scale-legend-wrap"]],
  template: function ScaleLegendComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0)(1, "div", 1)(2, "span");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](4, "div", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 1)(6, "span");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](7);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("height", ctx.horizontal ? undefined : ctx.height, "px")("width", ctx.width, "px");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("horizontal-legend", ctx.horizontal);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.valueRange[1].toLocaleString());
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("background", ctx.gradient);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.valueRange[0].toLocaleString());
    }
  },
  styles: [".chart-legend{display:inline-block;padding:0;width:auto!important}.chart-legend .scale-legend{display:flex;flex-direction:column;text-align:center}.chart-legend .scale-legend-wrap{border-radius:5px;display:inline-block;flex:1;margin:0 auto;width:30px}.chart-legend .scale-legend-label{font-size:12px}.chart-legend .horizontal-legend.scale-legend{flex-direction:row}.chart-legend .horizontal-legend .scale-legend-wrap{height:30px;margin:0 16px;width:auto}"],
  encapsulation: 2,
  changeDetection: 0
});

ScaleLegendComponent.ctorParameters = () => [{
  type: _angular_platform_browser__WEBPACK_IMPORTED_MODULE_12__.DomSanitizer
}];

ScaleLegendComponent.propDecorators = {
  valueRange: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  colors: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  height: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  width: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  horizontal: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](ScaleLegendComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-charts-scale-legend',
      template: `
    <div
      class="scale-legend"
      [class.horizontal-legend]="horizontal"
      [style.height.px]="horizontal ? undefined : height"
      [style.width.px]="width"
    >
      <div class="scale-legend-label">
        <span>{{ valueRange[1].toLocaleString() }}</span>
      </div>
      <div class="scale-legend-wrap" [style.background]="gradient"></div>
      <div class="scale-legend-label">
        <span>{{ valueRange[0].toLocaleString() }}</span>
      </div>
    </div>
  `,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      styles: [".chart-legend{display:inline-block;padding:0;width:auto!important}.chart-legend .scale-legend{display:flex;flex-direction:column;text-align:center}.chart-legend .scale-legend-wrap{border-radius:5px;display:inline-block;flex:1;margin:0 auto;width:30px}.chart-legend .scale-legend-label{font-size:12px}.chart-legend .horizontal-legend.scale-legend{flex-direction:row}.chart-legend .horizontal-legend .scale-legend-wrap{height:30px;margin:0 16px;width:auto}"]
    }]
  }], function () {
    return [{
      type: _angular_platform_browser__WEBPACK_IMPORTED_MODULE_12__.DomSanitizer
    }];
  }, {
    horizontal: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    valueRange: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    colors: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    height: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    width: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class AdvancedLegendComponent {
  constructor() {
    this.label = 'Total';
    this.animations = true;
    this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.legendItems = [];

    this.labelFormatting = label => label;

    this.percentageFormatting = percentage => percentage;

    this.defaultValueFormatting = value => value.toLocaleString();
  }

  ngOnChanges(changes) {
    this.update();
  }

  getTotal() {
    return this.data.map(d => d.value).reduce((sum, d) => sum + d, 0);
  }

  update() {
    this.total = this.getTotal();
    this.roundedTotal = this.total;
    this.legendItems = this.getLegendItems();
  }

  getLegendItems() {
    return this.data.map(d => {
      const label = formatLabel(d.name);
      const value = d.value;
      const color = this.colors.getColor(label);
      const percentage = this.total > 0 ? value / this.total * 100 : 0;
      const formattedLabel = typeof this.labelFormatting === 'function' ? this.labelFormatting(label) : label;
      return {
        _value: value,
        data: d,
        value,
        color,
        label: formattedLabel,
        displayLabel: trimLabel(formattedLabel, 20),
        origialLabel: d.name,
        percentage: this.percentageFormatting ? this.percentageFormatting(percentage) : percentage.toLocaleString()
      };
    });
  }

  trackBy(item) {
    return item.formattedLabel;
  }

}

AdvancedLegendComponent.ɵfac = function AdvancedLegendComponent_Factory(t) {
  return new (t || AdvancedLegendComponent)();
};

AdvancedLegendComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: AdvancedLegendComponent,
  selectors: [["ngx-charts-advanced-legend"]],
  inputs: {
    label: "label",
    animations: "animations",
    labelFormatting: "labelFormatting",
    percentageFormatting: "percentageFormatting",
    width: "width",
    data: "data",
    colors: "colors",
    valueFormatting: "valueFormatting"
  },
  outputs: {
    select: "select",
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  decls: 8,
  vars: 7,
  consts: [[1, "advanced-pie-legend"], ["class", "total-value", "ngx-charts-count-up", "", 3, "countTo", "valueFormatting", 4, "ngIf"], ["class", "total-value", 4, "ngIf"], [1, "total-label"], [1, "legend-items-container"], [1, "legend-items"], ["tabindex", "-1", "class", "legend-item", 3, "mouseenter", "mouseleave", "click", 4, "ngFor", "ngForOf", "ngForTrackBy"], ["ngx-charts-count-up", "", 1, "total-value", 3, "countTo", "valueFormatting"], [1, "total-value"], ["tabindex", "-1", 1, "legend-item", 3, "mouseenter", "mouseleave", "click"], [1, "item-color"], ["class", "item-value", "ngx-charts-count-up", "", 3, "countTo", "valueFormatting", 4, "ngIf"], ["class", "item-value", 4, "ngIf"], [1, "item-label"], ["class", "item-percent", "ngx-charts-count-up", "", 3, "countTo", "countSuffix", 4, "ngIf"], ["class", "item-percent", 4, "ngIf"], ["ngx-charts-count-up", "", 1, "item-value", 3, "countTo", "valueFormatting"], [1, "item-value"], ["ngx-charts-count-up", "", 1, "item-percent", 3, "countTo", "countSuffix"], [1, "item-percent"]],
  template: function AdvancedLegendComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, AdvancedLegendComponent_div_1_Template, 1, 2, "div", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, AdvancedLegendComponent_div_2_Template, 2, 1, "div", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "div", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 4)(6, "div", 5);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](7, AdvancedLegendComponent_div_7_Template, 8, 7, "div", 6);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("width", ctx.width, "px");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.animations);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.animations);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.label, " ");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.legendItems)("ngForTrackBy", ctx.trackBy);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, CountUpDirective],
  styles: [".advanced-pie-legend{float:left;position:relative;top:50%;transform:translateY(-50%)}.advanced-pie-legend .total-value{font-size:36px}.advanced-pie-legend .total-label{font-size:24px;margin-bottom:19px}.advanced-pie-legend .legend-items-container{width:100%}.advanced-pie-legend .legend-items-container .legend-items{overflow:auto;white-space:nowrap}.advanced-pie-legend .legend-items-container .legend-items .legend-item{cursor:pointer;display:inline-block;margin-right:20px}.advanced-pie-legend .legend-items-container .legend-items .legend-item:focus{outline:none}.advanced-pie-legend .legend-items-container .legend-items .legend-item:hover{color:#000;transition:.2s}.advanced-pie-legend .legend-items-container .legend-items .legend-item .item-value{font-size:24px;margin-left:11px;margin-top:-6px}.advanced-pie-legend .legend-items-container .legend-items .legend-item .item-label{font-size:14px;margin-left:11px;margin-top:-6px;opacity:.7}.advanced-pie-legend .legend-items-container .legend-items .legend-item .item-percent{font-size:24px;margin-left:11px;opacity:.7}.advanced-pie-legend .legend-items-container .legend-items .legend-item .item-color{border-left:4px solid;float:left;height:42px;margin-right:7px;width:4px}"],
  encapsulation: 2,
  changeDetection: 0
});
AdvancedLegendComponent.propDecorators = {
  width: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  data: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  colors: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  label: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  animations: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  select: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  valueFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  labelFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  percentageFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](AdvancedLegendComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-charts-advanced-legend',
      template: `
    <div class="advanced-pie-legend" [style.width.px]="width">
      <div
        *ngIf="animations"
        class="total-value"
        ngx-charts-count-up
        [countTo]="roundedTotal"
        [valueFormatting]="valueFormatting"
      ></div>
      <div class="total-value" *ngIf="!animations">
        {{ valueFormatting ? valueFormatting(roundedTotal) : defaultValueFormatting(roundedTotal) }}
      </div>
      <div class="total-label">
        {{ label }}
      </div>
      <div class="legend-items-container">
        <div class="legend-items">
          <div
            *ngFor="let legendItem of legendItems; trackBy: trackBy"
            tabindex="-1"
            class="legend-item"
            (mouseenter)="activate.emit(legendItem.data)"
            (mouseleave)="deactivate.emit(legendItem.data)"
            (click)="select.emit(legendItem.data)"
          >
            <div class="item-color" [style.border-left-color]="legendItem.color"></div>
            <div
              *ngIf="animations"
              class="item-value"
              ngx-charts-count-up
              [countTo]="legendItem._value"
              [valueFormatting]="valueFormatting"
            ></div>
            <div *ngIf="!animations" class="item-value">
              {{ valueFormatting ? valueFormatting(legendItem.value) : defaultValueFormatting(legendItem.value) }}
            </div>
            <div class="item-label">{{ legendItem.displayLabel }}</div>
            <div
              *ngIf="animations"
              class="item-percent"
              ngx-charts-count-up
              [countTo]="legendItem.percentage"
              [countSuffix]="'%'"
            ></div>
            <div *ngIf="!animations" class="item-percent">{{ legendItem.percentage.toLocaleString() }}%</div>
          </div>
        </div>
      </div>
    </div>
  `,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      styles: [".advanced-pie-legend{float:left;position:relative;top:50%;transform:translateY(-50%)}.advanced-pie-legend .total-value{font-size:36px}.advanced-pie-legend .total-label{font-size:24px;margin-bottom:19px}.advanced-pie-legend .legend-items-container{width:100%}.advanced-pie-legend .legend-items-container .legend-items{overflow:auto;white-space:nowrap}.advanced-pie-legend .legend-items-container .legend-items .legend-item{cursor:pointer;display:inline-block;margin-right:20px}.advanced-pie-legend .legend-items-container .legend-items .legend-item:focus{outline:none}.advanced-pie-legend .legend-items-container .legend-items .legend-item:hover{color:#000;transition:.2s}.advanced-pie-legend .legend-items-container .legend-items .legend-item .item-value{font-size:24px;margin-left:11px;margin-top:-6px}.advanced-pie-legend .legend-items-container .legend-items .legend-item .item-label{font-size:14px;margin-left:11px;margin-top:-6px;opacity:.7}.advanced-pie-legend .legend-items-container .legend-items .legend-item .item-percent{font-size:24px;margin-left:11px;opacity:.7}.advanced-pie-legend .legend-items-container .legend-items .legend-item .item-color{border-left:4px solid;float:left;height:42px;margin-right:7px;width:4px}"]
    }]
  }], function () {
    return [];
  }, {
    label: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    animations: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    select: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    labelFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    percentageFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    width: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    data: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    colors: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    valueFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

const COMPONENTS = [AreaComponent, BaseChartComponent, CountUpDirective, TooltipArea, ChartComponent, LegendComponent, LegendEntryComponent, ScaleLegendComponent, CircleComponent, CircleSeriesComponent, GridPanelComponent, GridPanelSeriesComponent, SvgLinearGradientComponent, SvgRadialGradientComponent, Timeline, AdvancedLegendComponent];

class ChartCommonModule {}

ChartCommonModule.ɵfac = function ChartCommonModule_Factory(t) {
  return new (t || ChartCommonModule)();
};

ChartCommonModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({
  type: ChartCommonModule
});
ChartCommonModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, AxesModule, TooltipModule, _angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, AxesModule, TooltipModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](ChartCommonModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.NgModule,
    args: [{
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, AxesModule, TooltipModule],
      declarations: [...COMPONENTS, VisibilityObserver],
      exports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, AxesModule, TooltipModule, ...COMPONENTS, VisibilityObserver]
    }]
  }], null, null);
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](ChartCommonModule, {
    declarations: function () {
      return [AreaComponent, BaseChartComponent, CountUpDirective, TooltipArea, ChartComponent, LegendComponent, LegendEntryComponent, ScaleLegendComponent, CircleComponent, CircleSeriesComponent, GridPanelComponent, GridPanelSeriesComponent, SvgLinearGradientComponent, SvgRadialGradientComponent, Timeline, AdvancedLegendComponent, VisibilityObserver];
    },
    imports: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, AxesModule, TooltipModule];
    },
    exports: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, AxesModule, TooltipModule, AreaComponent, BaseChartComponent, CountUpDirective, TooltipArea, ChartComponent, LegendComponent, LegendEntryComponent, ScaleLegendComponent, CircleComponent, CircleSeriesComponent, GridPanelComponent, GridPanelSeriesComponent, SvgLinearGradientComponent, SvgRadialGradientComponent, Timeline, AdvancedLegendComponent, VisibilityObserver];
    }
  });
})();

function calculateViewDimensions({
  width,
  height,
  margins,
  showXAxis = false,
  showYAxis = false,
  xAxisHeight = 0,
  yAxisWidth = 0,
  showXLabel = false,
  showYLabel = false,
  showLegend = false,
  legendType = 'ordinal',
  legendPosition = 'right',
  columns = 12
}) {
  let xOffset = margins[3];
  let chartWidth = width;
  let chartHeight = height - margins[0] - margins[2];

  if (showLegend && legendPosition === 'right') {
    if (legendType === 'ordinal') {
      columns -= 2;
    } else {
      columns -= 1;
    }
  }

  chartWidth = chartWidth * columns / 12;
  chartWidth = chartWidth - margins[1] - margins[3];

  if (showXAxis) {
    chartHeight -= 5;
    chartHeight -= xAxisHeight;

    if (showXLabel) {
      // text height + spacing between axis label and tick labels
      const offset = 25 + 5;
      chartHeight -= offset;
    }
  }

  if (showYAxis) {
    chartWidth -= 5;
    chartWidth -= yAxisWidth;
    xOffset += yAxisWidth;
    xOffset += 10;

    if (showYLabel) {
      // text height + spacing between axis label and tick labels
      const offset = 25 + 5;
      chartWidth -= offset;
      xOffset += offset;
    }
  }

  chartWidth = Math.max(0, chartWidth);
  chartHeight = Math.max(0, chartHeight);
  return {
    width: Math.floor(chartWidth),
    height: Math.floor(chartHeight),
    xOffset: Math.floor(xOffset)
  };
}

let colorSets = [{
  name: 'vivid',
  selectable: true,
  group: 'Ordinal',
  domain: ['#647c8a', '#3f51b5', '#2196f3', '#00b862', '#afdf0a', '#a7b61a', '#f3e562', '#ff9800', '#ff5722', '#ff4514']
}, {
  name: 'natural',
  selectable: true,
  group: 'Ordinal',
  domain: ['#bf9d76', '#e99450', '#d89f59', '#f2dfa7', '#a5d7c6', '#7794b1', '#afafaf', '#707160', '#ba9383', '#d9d5c3']
}, {
  name: 'cool',
  selectable: true,
  group: 'Ordinal',
  domain: ['#a8385d', '#7aa3e5', '#a27ea8', '#aae3f5', '#adcded', '#a95963', '#8796c0', '#7ed3ed', '#50abcc', '#ad6886']
}, {
  name: 'fire',
  selectable: true,
  group: 'Ordinal',
  domain: ['#ff3d00', '#bf360c', '#ff8f00', '#ff6f00', '#ff5722', '#e65100', '#ffca28', '#ffab00']
}, {
  name: 'solar',
  selectable: true,
  group: 'Continuous',
  domain: ['#fff8e1', '#ffecb3', '#ffe082', '#ffd54f', '#ffca28', '#ffc107', '#ffb300', '#ffa000', '#ff8f00', '#ff6f00']
}, {
  name: 'air',
  selectable: true,
  group: 'Continuous',
  domain: ['#e1f5fe', '#b3e5fc', '#81d4fa', '#4fc3f7', '#29b6f6', '#03a9f4', '#039be5', '#0288d1', '#0277bd', '#01579b']
}, {
  name: 'aqua',
  selectable: true,
  group: 'Continuous',
  domain: ['#e0f7fa', '#b2ebf2', '#80deea', '#4dd0e1', '#26c6da', '#00bcd4', '#00acc1', '#0097a7', '#00838f', '#006064']
}, {
  name: 'flame',
  selectable: false,
  group: 'Ordinal',
  domain: ['#A10A28', '#D3342D', '#EF6D49', '#FAAD67', '#FDDE90', '#DBED91', '#A9D770', '#6CBA67', '#2C9653', '#146738']
}, {
  name: 'ocean',
  selectable: false,
  group: 'Ordinal',
  domain: ['#1D68FB', '#33C0FC', '#4AFFFE', '#AFFFFF', '#FFFC63', '#FDBD2D', '#FC8A25', '#FA4F1E', '#FA141B', '#BA38D1']
}, {
  name: 'forest',
  selectable: false,
  group: 'Ordinal',
  domain: ['#55C22D', '#C1F33D', '#3CC099', '#AFFFFF', '#8CFC9D', '#76CFFA', '#BA60FB', '#EE6490', '#C42A1C', '#FC9F32']
}, {
  name: 'horizon',
  selectable: false,
  group: 'Ordinal',
  domain: ['#2597FB', '#65EBFD', '#99FDD0', '#FCEE4B', '#FEFCFA', '#FDD6E3', '#FCB1A8', '#EF6F7B', '#CB96E8', '#EFDEE0']
}, {
  name: 'neons',
  selectable: false,
  group: 'Ordinal',
  domain: ['#FF3333', '#FF33FF', '#CC33FF', '#0000FF', '#33CCFF', '#33FFFF', '#33FF66', '#CCFF33', '#FFCC00', '#FF6600']
}, {
  name: 'picnic',
  selectable: false,
  group: 'Ordinal',
  domain: ['#FAC51D', '#66BD6D', '#FAA026', '#29BB9C', '#E96B56', '#55ACD2', '#B7332F', '#2C83C9', '#9166B8', '#92E7E8']
}, {
  name: 'night',
  selectable: false,
  group: 'Ordinal',
  domain: ['#2B1B5A', '#501356', '#183356', '#28203F', '#391B3C', '#1E2B3C', '#120634', '#2D0432', '#051932', '#453080', '#75267D', '#2C507D', '#4B3880', '#752F7D', '#35547D']
}, {
  name: 'nightLights',
  selectable: false,
  group: 'Ordinal',
  domain: ['#4e31a5', '#9c25a7', '#3065ab', '#57468b', '#904497', '#46648b', '#32118d', '#a00fb3', '#1052a2', '#6e51bd', '#b63cc3', '#6c97cb', '#8671c1', '#b455be', '#7496c3']
}];

class ColorHelper {
  constructor(scheme, type, domain, customColors) {
    if (typeof scheme === 'string') {
      scheme = colorSets.find(cs => {
        return cs.name === scheme;
      });
    }

    this.colorDomain = scheme.domain;
    this.scaleType = type;
    this.domain = domain;
    this.customColors = customColors;
    this.scale = this.generateColorScheme(scheme, type, this.domain);
  }

  generateColorScheme(scheme, type, domain) {
    if (typeof scheme === 'string') {
      scheme = colorSets.find(cs => {
        return cs.name === scheme;
      });
    }

    let colorScale;

    if (type === 'quantile') {
      colorScale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_13__["default"])().range(scheme.domain).domain(domain);
    } else if (type === 'ordinal') {
      colorScale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_14__["default"])().range(scheme.domain).domain(domain);
    } else if (type === 'linear') {
      // linear schemes must have at least 2 colors
      const colorDomain = [...scheme.domain];

      if (colorDomain.length === 1) {
        colorDomain.push(colorDomain[0]);
        this.colorDomain = colorDomain;
      }

      const points = (0,d3_array__WEBPACK_IMPORTED_MODULE_15__["default"])(0, 1, 1.0 / colorDomain.length);
      colorScale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().domain(points).range(colorDomain);
    }

    return colorScale;
  }

  getColor(value) {
    if (value === undefined || value === null) {
      throw new Error('Value can not be null');
    }

    if (this.scaleType === 'linear') {
      const valueScale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().domain(this.domain).range([0, 1]);
      return this.scale(valueScale(value));
    } else {
      if (typeof this.customColors === 'function') {
        return this.customColors(value);
      }

      const formattedValue = value.toString();
      let found; // todo type customColors

      if (this.customColors && this.customColors.length > 0) {
        found = this.customColors.find(mapping => {
          return mapping.name.toLowerCase() === formattedValue.toLowerCase();
        });
      }

      if (found) {
        return found.value;
      } else {
        return this.scale(value);
      }
    }
  }

  getLinearGradientStops(value, start) {
    if (start === undefined) {
      start = this.domain[0];
    }

    const valueScale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().domain(this.domain).range([0, 1]);
    const colorValueScale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_11__["default"])().domain(this.colorDomain).range([0, 1]);
    const endColor = this.getColor(value); // generate the stops

    const startVal = valueScale(start);
    const startColor = this.getColor(start);
    const endVal = valueScale(value);
    let i = 1;
    let currentVal = startVal;
    const stops = [];
    stops.push({
      color: startColor,
      offset: startVal,
      originalOffset: startVal,
      opacity: 1
    });

    while (currentVal < endVal && i < this.colorDomain.length) {
      const color = this.colorDomain[i];
      const offset = colorValueScale(color);

      if (offset <= startVal) {
        i++;
        continue;
      }

      if (offset.toFixed(4) >= (endVal - colorValueScale.bandwidth()).toFixed(4)) {
        break;
      }

      stops.push({
        color,
        offset,
        opacity: 1
      });
      currentVal = offset;
      i++;
    }

    if (stops[stops.length - 1].offset < 100) {
      stops.push({
        color: endColor,
        offset: endVal,
        opacity: 1
      });
    }

    if (endVal === startVal) {
      stops[0].offset = 0;
      stops[1].offset = 100;
    } else {
      // normalize the offsets into percentages
      if (stops[stops.length - 1].offset !== 100) {
        for (const s of stops) {
          s.offset = (s.offset - startVal) / (endVal - startVal) * 100;
        }
      }
    }

    return stops;
  }

}
/**
 * Based on the data, return an array with unique values.
 *
 * @export
 * @returns array
 */


function getUniqueXDomainValues(results) {
  const valueSet = new Set();

  for (const result of results) {
    for (const d of result.series) {
      valueSet.add(d.name);
    }
  }

  return Array.from(valueSet);
}
/**
 * Get the scaleType of enumerable of values.
 * @returns  'time', 'linear' or 'ordinal'
 */


function getScaleType(values, checkDateType = true) {
  if (checkDateType) {
    const allDates = values.every(value => value instanceof Date);

    if (allDates) {
      return 'time';
    }
  }

  const allNumbers = values.every(value => typeof value === 'number');

  if (allNumbers) {
    return 'linear';
  }

  return 'ordinal';
}

class AreaChartComponent extends BaseChartComponent {
  constructor() {
    super(...arguments);
    this.legendTitle = 'Legend';
    this.legendPosition = 'right';
    this.baseValue = 'auto';
    this.showGridLines = true;
    this.curve = d3_shape__WEBPACK_IMPORTED_MODULE_16__["default"];
    this.activeEntries = [];
    this.trimXAxisTicks = true;
    this.trimYAxisTicks = true;
    this.rotateXAxisTicks = true;
    this.maxXAxisTickLength = 16;
    this.maxYAxisTickLength = 16;
    this.roundDomains = false;
    this.tooltipDisabled = false;
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.margin = [10, 20, 10, 20];
    this.xAxisHeight = 0;
    this.yAxisWidth = 0;
    this.timelineHeight = 50;
    this.timelinePadding = 10;
  }

  update() {
    super.update();
    this.dims = calculateViewDimensions({
      width: this.width,
      height: this.height,
      margins: this.margin,
      showXAxis: this.xAxis,
      showYAxis: this.yAxis,
      xAxisHeight: this.xAxisHeight,
      yAxisWidth: this.yAxisWidth,
      showXLabel: this.showXAxisLabel,
      showYLabel: this.showYAxisLabel,
      showLegend: this.legend,
      legendType: this.schemeType,
      legendPosition: this.legendPosition
    });

    if (this.timeline) {
      this.dims.height -= this.timelineHeight + this.margin[2] + this.timelinePadding;
    }

    this.xDomain = this.getXDomain();

    if (this.filteredDomain) {
      this.xDomain = this.filteredDomain;
    }

    this.yDomain = this.getYDomain();
    this.seriesDomain = this.getSeriesDomain();
    this.xScale = this.getXScale(this.xDomain, this.dims.width);
    this.yScale = this.getYScale(this.yDomain, this.dims.height);
    this.updateTimeline();
    this.setColors();
    this.legendOptions = this.getLegendOptions();
    this.transform = `translate(${this.dims.xOffset}, ${this.margin[0]})`;
    this.clipPathId = 'clip' + id().toString();
    this.clipPath = `url(#${this.clipPathId})`;
  }

  updateTimeline() {
    if (this.timeline) {
      this.timelineWidth = this.dims.width;
      this.timelineXDomain = this.getXDomain();
      this.timelineXScale = this.getXScale(this.timelineXDomain, this.timelineWidth);
      this.timelineYScale = this.getYScale(this.yDomain, this.timelineHeight);
      this.timelineTransform = `translate(${this.dims.xOffset}, ${-this.margin[2]})`;
    }
  }

  getXDomain() {
    let values = getUniqueXDomainValues(this.results);
    this.scaleType = getScaleType(values);
    let domain = [];

    if (this.scaleType === 'linear') {
      values = values.map(v => Number(v));
    }

    let min;
    let max;

    if (this.scaleType === 'time' || this.scaleType === 'linear') {
      min = this.xScaleMin ? this.xScaleMin : Math.min(...values);
      max = this.xScaleMax ? this.xScaleMax : Math.max(...values);
    }

    if (this.scaleType === 'time') {
      domain = [new Date(min), new Date(max)];
      this.xSet = [...values].sort((a, b) => {
        const aDate = a.getTime();
        const bDate = b.getTime();
        if (aDate > bDate) return 1;
        if (bDate > aDate) return -1;
        return 0;
      });
    } else if (this.scaleType === 'linear') {
      domain = [min, max]; // Use compare function to sort numbers numerically

      this.xSet = [...values].sort((a, b) => a - b);
    } else {
      domain = values;
      this.xSet = values;
    }

    return domain;
  }

  getYDomain() {
    const domain = [];

    for (const results of this.results) {
      for (const d of results.series) {
        if (!domain.includes(d.value)) {
          domain.push(d.value);
        }
      }
    }

    const values = [...domain];

    if (!this.autoScale) {
      values.push(0);
    }

    if (this.baseValue !== 'auto') {
      values.push(this.baseValue);
    }

    const min = this.yScaleMin ? this.yScaleMin : Math.min(...values);
    const max = this.yScaleMax ? this.yScaleMax : Math.max(...values);
    return [min, max];
  }

  getSeriesDomain() {
    return this.results.map(d => d.name);
  }

  getXScale(domain, width) {
    let scale;

    if (this.scaleType === 'time') {
      scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_9__["default"])();
    } else if (this.scaleType === 'linear') {
      scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])();
    } else if (this.scaleType === 'ordinal') {
      scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_11__.point)().padding(0.1);
    }

    scale.range([0, width]).domain(domain);
    return this.roundDomains ? scale.nice() : scale;
  }

  getYScale(domain, height) {
    const scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().range([height, 0]).domain(domain);
    return this.roundDomains ? scale.nice() : scale;
  }

  getScaleType(values) {
    let date = true;
    let num = true;

    for (const value of values) {
      if (!this.isDate(value)) {
        date = false;
      }

      if (typeof value !== 'number') {
        num = false;
      }
    }

    if (date) {
      return 'time';
    }

    if (num) {
      return 'linear';
    }

    return 'ordinal';
  }

  isDate(value) {
    if (value instanceof Date) {
      return true;
    }

    return false;
  }

  updateDomain(domain) {
    this.filteredDomain = domain;
    this.xDomain = this.filteredDomain;
    this.xScale = this.getXScale(this.xDomain, this.dims.width);
  }

  updateHoveredVertical(item) {
    this.hoveredVertical = item.value;
    this.deactivateAll();
  }

  hideCircles() {
    this.hoveredVertical = null;
    this.deactivateAll();
  }

  onClick(data, series) {
    if (series) {
      data.series = series.name;
    }

    this.select.emit(data);
  }

  trackBy(index, item) {
    return item.name;
  }

  setColors() {
    let domain;

    if (this.schemeType === 'ordinal') {
      domain = this.seriesDomain;
    } else {
      domain = this.yDomain;
    }

    this.colors = new ColorHelper(this.scheme, this.schemeType, domain, this.customColors);
  }

  getLegendOptions() {
    const opts = {
      scaleType: this.schemeType,
      colors: undefined,
      domain: [],
      title: undefined,
      position: this.legendPosition
    };

    if (opts.scaleType === 'ordinal') {
      opts.domain = this.seriesDomain;
      opts.colors = this.colors;
      opts.title = this.legendTitle;
    } else {
      opts.domain = this.yDomain;
      opts.colors = this.colors.scale;
    }

    return opts;
  }

  updateYAxisWidth({
    width
  }) {
    this.yAxisWidth = width;
    this.update();
  }

  updateXAxisHeight({
    height
  }) {
    this.xAxisHeight = height;
    this.update();
  }

  onActivate(item) {
    const idx = this.activeEntries.findIndex(d => {
      return d.name === item.name && d.value === item.value;
    });

    if (idx > -1) {
      return;
    }

    this.activeEntries = [item, ...this.activeEntries];
    this.activate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

  onDeactivate(item) {
    const idx = this.activeEntries.findIndex(d => {
      return d.name === item.name && d.value === item.value;
    });
    this.activeEntries.splice(idx, 1);
    this.activeEntries = [...this.activeEntries];
    this.deactivate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

  deactivateAll() {
    this.activeEntries = [...this.activeEntries];

    for (const entry of this.activeEntries) {
      this.deactivate.emit({
        value: entry,
        entries: []
      });
    }

    this.activeEntries = [];
  }

}

AreaChartComponent.ɵfac = /*@__PURE__*/function () {
  let ɵAreaChartComponent_BaseFactory;
  return function AreaChartComponent_Factory(t) {
    return (ɵAreaChartComponent_BaseFactory || (ɵAreaChartComponent_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](AreaChartComponent)))(t || AreaChartComponent);
  };
}();

AreaChartComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: AreaChartComponent,
  selectors: [["ngx-charts-area-chart"]],
  contentQueries: function AreaChartComponent_ContentQueries(rf, ctx, dirIndex) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"](dirIndex, _c21, 5);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"](dirIndex, _c22, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.tooltipTemplate = _t.first);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.seriesTooltipTemplate = _t.first);
    }
  },
  hostBindings: function AreaChartComponent_HostBindings(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("mouseleave", function AreaChartComponent_mouseleave_HostBindingHandler() {
        return ctx.hideCircles();
      });
    }
  },
  inputs: {
    legendTitle: "legendTitle",
    legendPosition: "legendPosition",
    baseValue: "baseValue",
    showGridLines: "showGridLines",
    curve: "curve",
    activeEntries: "activeEntries",
    trimXAxisTicks: "trimXAxisTicks",
    trimYAxisTicks: "trimYAxisTicks",
    rotateXAxisTicks: "rotateXAxisTicks",
    maxXAxisTickLength: "maxXAxisTickLength",
    maxYAxisTickLength: "maxYAxisTickLength",
    roundDomains: "roundDomains",
    tooltipDisabled: "tooltipDisabled",
    legend: "legend",
    state: "state",
    xAxis: "xAxis",
    yAxis: "yAxis",
    autoScale: "autoScale",
    showXAxisLabel: "showXAxisLabel",
    showYAxisLabel: "showYAxisLabel",
    xAxisLabel: "xAxisLabel",
    yAxisLabel: "yAxisLabel",
    timeline: "timeline",
    gradient: "gradient",
    schemeType: "schemeType",
    xAxisTickFormatting: "xAxisTickFormatting",
    yAxisTickFormatting: "yAxisTickFormatting",
    xAxisTicks: "xAxisTicks",
    yAxisTicks: "yAxisTicks",
    xScaleMin: "xScaleMin",
    xScaleMax: "xScaleMax",
    yScaleMin: "yScaleMin",
    yScaleMax: "yScaleMax"
  },
  outputs: {
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]],
  decls: 11,
  vars: 20,
  consts: [[3, "view", "showLegend", "legendOptions", "activeEntries", "animations", "legendLabelClick", "legendLabelActivate", "legendLabelDeactivate"], [1, "area-chart", "chart"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], [4, "ngFor", "ngForOf", "ngForTrackBy"], [3, "mouseleave", 4, "ngIf"], ["ngx-charts-timeline", "", 3, "results", "view", "height", "scheme", "customColors", "legend", "scaleType", "onDomainChange", 4, "ngIf"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-area-series", "", 3, "xScale", "yScale", "baseValue", "colors", "data", "activeEntries", "scaleType", "gradient", "curve", "animations"], [3, "mouseleave"], ["ngx-charts-tooltip-area", "", 3, "dims", "xSet", "xScale", "yScale", "results", "colors", "tooltipDisabled", "tooltipTemplate", "hover"], [4, "ngFor", "ngForOf"], ["ngx-charts-circle-series", "", 3, "xScale", "yScale", "colors", "activeEntries", "data", "scaleType", "visibleValue", "tooltipDisabled", "tooltipTemplate", "select", "activate", "deactivate"], ["ngx-charts-timeline", "", 3, "results", "view", "height", "scheme", "customColors", "legend", "scaleType", "onDomainChange"], ["ngx-charts-area-series", "", 3, "xScale", "yScale", "baseValue", "colors", "data", "scaleType", "gradient", "curve", "animations"]],
  template: function AreaChartComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "ngx-charts-chart", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("legendLabelClick", function AreaChartComponent_Template_ngx_charts_chart_legendLabelClick_0_listener($event) {
        return ctx.onClick($event);
      })("legendLabelActivate", function AreaChartComponent_Template_ngx_charts_chart_legendLabelActivate_0_listener($event) {
        return ctx.onActivate($event);
      })("legendLabelDeactivate", function AreaChartComponent_Template_ngx_charts_chart_legendLabelDeactivate_0_listener($event) {
        return ctx.onDeactivate($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "defs")(2, "clipPath");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](3, "rect");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "g", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](5, AreaChartComponent__svg_g_5_Template, 1, 10, "g", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](6, AreaChartComponent__svg_g_6_Template, 1, 9, "g", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "g");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](8, AreaChartComponent__svg_g_8_Template, 2, 10, "g", 4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](9, AreaChartComponent__svg_g_9_Template, 3, 9, "g", 5);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](10, AreaChartComponent__svg_g_10_Template, 2, 13, "g", 6);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("view", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](17, _c23, ctx.width, ctx.height))("showLegend", ctx.legend)("legendOptions", ctx.legendOptions)("activeEntries", ctx.activeEntries)("animations", ctx.animations);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("id", ctx.clipPathId);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("width", ctx.dims.width + 10)("height", ctx.dims.height + 10)("transform", "translate(-5, -5)");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.xAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.yAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("clip-path", ctx.clipPath);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.results)("ngForTrackBy", ctx.trackBy);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.tooltipDisabled);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.timeline && ctx.scaleType != "ordinal");
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, XAxisComponent, YAxisComponent, TooltipArea, ChartComponent, CircleSeriesComponent, Timeline, AreaSeriesComponent];
  },
  styles: [_c24],
  encapsulation: 2,
  changeDetection: 0
});
AreaChartComponent.propDecorators = {
  legend: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendTitle: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendPosition: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  state: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  baseValue: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  autoScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showXAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showYAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  timeline: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showGridLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  curve: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  schemeType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimYAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  rotateXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxXAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxYAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundDomains: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScaleMin: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScaleMax: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScaleMin: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScaleMax: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
    args: ['tooltipTemplate']
  }],
  seriesTooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
    args: ['seriesTooltipTemplate']
  }],
  hideCircles: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['mouseleave']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](AreaChartComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-charts-area-chart',
      template: `
    <ngx-charts-chart
      [view]="[width, height]"
      [showLegend]="legend"
      [legendOptions]="legendOptions"
      [activeEntries]="activeEntries"
      [animations]="animations"
      (legendLabelClick)="onClick($event)"
      (legendLabelActivate)="onActivate($event)"
      (legendLabelDeactivate)="onDeactivate($event)"
    >
      <svg:defs>
        <svg:clipPath [attr.id]="clipPathId">
          <svg:rect
            [attr.width]="dims.width + 10"
            [attr.height]="dims.height + 10"
            [attr.transform]="'translate(-5, -5)'"
          />
        </svg:clipPath>
      </svg:defs>
      <svg:g [attr.transform]="transform" class="area-chart chart">
        <svg:g
          ngx-charts-x-axis
          *ngIf="xAxis"
          [xScale]="xScale"
          [dims]="dims"
          [showGridLines]="showGridLines"
          [showLabel]="showXAxisLabel"
          [labelText]="xAxisLabel"
          [trimTicks]="trimXAxisTicks"
          [rotateTicks]="rotateXAxisTicks"
          [maxTickLength]="maxXAxisTickLength"
          [tickFormatting]="xAxisTickFormatting"
          [ticks]="xAxisTicks"
          (dimensionsChanged)="updateXAxisHeight($event)"
        ></svg:g>
        <svg:g
          ngx-charts-y-axis
          *ngIf="yAxis"
          [yScale]="yScale"
          [dims]="dims"
          [showGridLines]="showGridLines"
          [showLabel]="showYAxisLabel"
          [labelText]="yAxisLabel"
          [trimTicks]="trimYAxisTicks"
          [maxTickLength]="maxYAxisTickLength"
          [tickFormatting]="yAxisTickFormatting"
          [ticks]="yAxisTicks"
          (dimensionsChanged)="updateYAxisWidth($event)"
        ></svg:g>
        <svg:g [attr.clip-path]="clipPath">
          <svg:g *ngFor="let series of results; trackBy: trackBy">
            <svg:g
              ngx-charts-area-series
              [xScale]="xScale"
              [yScale]="yScale"
              [baseValue]="baseValue"
              [colors]="colors"
              [data]="series"
              [activeEntries]="activeEntries"
              [scaleType]="scaleType"
              [gradient]="gradient"
              [curve]="curve"
              [animations]="animations"
            />
          </svg:g>

          <svg:g *ngIf="!tooltipDisabled" (mouseleave)="hideCircles()">
            <svg:g
              ngx-charts-tooltip-area
              [dims]="dims"
              [xSet]="xSet"
              [xScale]="xScale"
              [yScale]="yScale"
              [results]="results"
              [colors]="colors"
              [tooltipDisabled]="tooltipDisabled"
              [tooltipTemplate]="seriesTooltipTemplate"
              (hover)="updateHoveredVertical($event)"
            />

            <svg:g *ngFor="let series of results">
              <svg:g
                ngx-charts-circle-series
                [xScale]="xScale"
                [yScale]="yScale"
                [colors]="colors"
                [activeEntries]="activeEntries"
                [data]="series"
                [scaleType]="scaleType"
                [visibleValue]="hoveredVertical"
                [tooltipDisabled]="tooltipDisabled"
                [tooltipTemplate]="tooltipTemplate"
                (select)="onClick($event, series)"
                (activate)="onActivate($event)"
                (deactivate)="onDeactivate($event)"
              />
            </svg:g>
          </svg:g>
        </svg:g>
      </svg:g>
      <svg:g
        ngx-charts-timeline
        *ngIf="timeline && scaleType != 'ordinal'"
        [attr.transform]="timelineTransform"
        [results]="results"
        [view]="[timelineWidth, height]"
        [height]="timelineHeight"
        [scheme]="scheme"
        [customColors]="customColors"
        [legend]="legend"
        [scaleType]="scaleType"
        (onDomainChange)="updateDomain($event)"
      >
        <svg:g *ngFor="let series of results; trackBy: trackBy">
          <svg:g
            ngx-charts-area-series
            [xScale]="timelineXScale"
            [yScale]="timelineYScale"
            [baseValue]="baseValue"
            [colors]="colors"
            [data]="series"
            [scaleType]="scaleType"
            [gradient]="gradient"
            [curve]="curve"
            [animations]="animations"
          />
        </svg:g>
      </svg:g>
    </ngx-charts-chart>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      styles: [".ngx-charts{float:left;overflow:visible}.ngx-charts .arc,.ngx-charts .bar,.ngx-charts .circle{cursor:pointer}.ngx-charts .arc.active,.ngx-charts .arc:hover,.ngx-charts .bar.active,.ngx-charts .bar:hover,.ngx-charts .card.active,.ngx-charts .card:hover,.ngx-charts .cell.active,.ngx-charts .cell:hover{opacity:.8;transition:opacity .1s ease-in-out}.ngx-charts .arc:focus,.ngx-charts .bar:focus,.ngx-charts .card:focus,.ngx-charts .cell:focus{outline:none}.ngx-charts .arc.hidden,.ngx-charts .bar.hidden,.ngx-charts .card.hidden,.ngx-charts .cell.hidden{display:none}.ngx-charts g:focus{outline:none}.ngx-charts .area-series.inactive,.ngx-charts .line-series-range.inactive,.ngx-charts .line-series.inactive,.ngx-charts .polar-series-area.inactive,.ngx-charts .polar-series-path.inactive{opacity:.2;transition:opacity .1s ease-in-out}.ngx-charts .line-highlight{display:none}.ngx-charts .line-highlight.active{display:block}.ngx-charts .area{opacity:.6}.ngx-charts .circle:hover{cursor:pointer}.ngx-charts .label{font-size:12px;font-weight:400}.ngx-charts .tooltip-anchor{fill:#000}.ngx-charts .gridline-path{fill:none;stroke:#ddd;stroke-width:1}.ngx-charts .refline-path{stroke:#a8b2c7;stroke-dasharray:5;stroke-dashoffset:5;stroke-width:1}.ngx-charts .refline-label{font-size:9px}.ngx-charts .reference-area{fill:#000;fill-opacity:.05}.ngx-charts .gridline-path-dotted{fill:none;stroke:#ddd;stroke-dasharray:1,20;stroke-dashoffset:3;stroke-width:1}.ngx-charts .grid-panel rect{fill:none}.ngx-charts .grid-panel.odd rect{fill:rgba(0,0,0,.05)}"]
    }]
  }], null, {
    legendTitle: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendPosition: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    baseValue: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showGridLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    curve: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimYAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    rotateXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxXAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxYAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundDomains: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    hideCircles: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['mouseleave']
    }],
    legend: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    state: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    autoScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showXAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showYAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    timeline: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    schemeType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScaleMin: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScaleMax: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScaleMin: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScaleMax: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
      args: ['tooltipTemplate']
    }],
    seriesTooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
      args: ['seriesTooltipTemplate']
    }]
  });
})();

class AreaChartNormalizedComponent extends BaseChartComponent {
  constructor() {
    super(...arguments);
    this.legend = false;
    this.legendTitle = 'Legend';
    this.legendPosition = 'right';
    this.showGridLines = true;
    this.curve = d3_shape__WEBPACK_IMPORTED_MODULE_16__["default"];
    this.activeEntries = [];
    this.trimXAxisTicks = true;
    this.trimYAxisTicks = true;
    this.rotateXAxisTicks = true;
    this.maxXAxisTickLength = 16;
    this.maxYAxisTickLength = 16;
    this.roundDomains = false;
    this.tooltipDisabled = false;
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.margin = [10, 20, 10, 20];
    this.xAxisHeight = 0;
    this.yAxisWidth = 0;
    this.timelineHeight = 50;
    this.timelinePadding = 10;
  }

  update() {
    super.update();
    this.dims = calculateViewDimensions({
      width: this.width,
      height: this.height,
      margins: this.margin,
      showXAxis: this.xAxis,
      showYAxis: this.yAxis,
      xAxisHeight: this.xAxisHeight,
      yAxisWidth: this.yAxisWidth,
      showXLabel: this.showXAxisLabel,
      showYLabel: this.showYAxisLabel,
      showLegend: this.legend,
      legendType: this.schemeType,
      legendPosition: this.legendPosition
    });

    if (this.timeline) {
      this.dims.height -= this.timelineHeight + this.margin[2] + this.timelinePadding;
    }

    this.xDomain = this.getXDomain();

    if (this.filteredDomain) {
      this.xDomain = this.filteredDomain;
    }

    this.yDomain = this.getYDomain();
    this.seriesDomain = this.getSeriesDomain();
    this.xScale = this.getXScale(this.xDomain, this.dims.width);
    this.yScale = this.getYScale(this.yDomain, this.dims.height);

    for (let i = 0; i < this.xSet.length; i++) {
      const val = this.xSet[i];
      let d0 = 0;
      let total = 0;

      for (const group of this.results) {
        const d = group.series.find(item => {
          let a = item.name;
          let b = val;

          if (this.scaleType === 'time') {
            a = a.valueOf();
            b = b.valueOf();
          }

          return a === b;
        });

        if (d) {
          total += d.value;
        }
      }

      for (const group of this.results) {
        let d = group.series.find(item => {
          let a = item.name;
          let b = val;

          if (this.scaleType === 'time') {
            a = a.valueOf();
            b = b.valueOf();
          }

          return a === b;
        });

        if (d) {
          d.d0 = d0;
          d.d1 = d0 + d.value;
          d0 += d.value;
        } else {
          d = {
            name: val,
            value: 0,
            d0,
            d1: d0
          };
          group.series.push(d);
        }

        if (total > 0) {
          d.d0 = d.d0 * 100 / total;
          d.d1 = d.d1 * 100 / total;
        } else {
          d.d0 = 0;
          d.d1 = 0;
        }
      }
    }

    this.updateTimeline();
    this.setColors();
    this.legendOptions = this.getLegendOptions();
    this.transform = `translate(${this.dims.xOffset} , ${this.margin[0]})`;
    this.clipPathId = 'clip' + id().toString();
    this.clipPath = `url(#${this.clipPathId})`;
  }

  updateTimeline() {
    if (this.timeline) {
      this.timelineWidth = this.dims.width;
      this.timelineXDomain = this.getXDomain();
      this.timelineXScale = this.getXScale(this.timelineXDomain, this.timelineWidth);
      this.timelineYScale = this.getYScale(this.yDomain, this.timelineHeight);
      this.timelineTransform = `translate(${this.dims.xOffset}, ${-this.margin[2]})`;
    }
  }

  getXDomain() {
    let values = getUniqueXDomainValues(this.results);
    this.scaleType = getScaleType(values);
    let domain = [];

    if (this.scaleType === 'time') {
      const min = Math.min(...values);
      const max = Math.max(...values);
      domain = [new Date(min), new Date(max)];
      this.xSet = [...values].sort((a, b) => {
        const aDate = a.getTime();
        const bDate = b.getTime();
        if (aDate > bDate) return 1;
        if (bDate > aDate) return -1;
        return 0;
      });
    } else if (this.scaleType === 'linear') {
      values = values.map(v => Number(v));
      const min = Math.min(...values);
      const max = Math.max(...values);
      domain = [min, max]; // Use compare function to sort numbers numerically

      this.xSet = [...values].sort((a, b) => a - b);
    } else {
      domain = values;
      this.xSet = values;
    }

    return domain;
  }

  getYDomain() {
    return [0, 100];
  }

  getSeriesDomain() {
    return this.results.map(d => d.name);
  }

  getXScale(domain, width) {
    let scale;

    if (this.scaleType === 'time') {
      scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_9__["default"])();
    } else if (this.scaleType === 'linear') {
      scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])();
    } else if (this.scaleType === 'ordinal') {
      scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_11__.point)().padding(0.1);
    }

    scale.range([0, width]).domain(domain);
    return this.roundDomains ? scale.nice() : scale;
  }

  getYScale(domain, height) {
    const scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().range([height, 0]).domain(domain);
    return this.roundDomains ? scale.nice() : scale;
  }

  updateDomain(domain) {
    this.filteredDomain = domain;
    this.xDomain = this.filteredDomain;
    this.xScale = this.getXScale(this.xDomain, this.dims.width);
  }

  updateHoveredVertical(item) {
    this.hoveredVertical = item.value;
    this.deactivateAll();
  }

  hideCircles() {
    this.hoveredVertical = null;
    this.deactivateAll();
  }

  onClick(data, series) {
    if (series) {
      data.series = series.name;
    }

    this.select.emit(data);
  }

  trackBy(index, item) {
    return item.name;
  }

  setColors() {
    let domain;

    if (this.schemeType === 'ordinal') {
      domain = this.seriesDomain;
    } else {
      domain = this.yDomain;
    }

    this.colors = new ColorHelper(this.scheme, this.schemeType, domain, this.customColors);
  }

  getLegendOptions() {
    const opts = {
      scaleType: this.schemeType,
      colors: undefined,
      domain: [],
      title: undefined,
      position: this.legendPosition
    };

    if (opts.scaleType === 'ordinal') {
      opts.domain = this.seriesDomain;
      opts.colors = this.colors;
      opts.title = this.legendTitle;
    } else {
      opts.domain = this.yDomain;
      opts.colors = this.colors.scale;
    }

    return opts;
  }

  updateYAxisWidth({
    width
  }) {
    this.yAxisWidth = width;
    this.update();
  }

  updateXAxisHeight({
    height
  }) {
    this.xAxisHeight = height;
    this.update();
  }

  onActivate(item) {
    const idx = this.activeEntries.findIndex(d => {
      return d.name === item.name && d.value === item.value;
    });

    if (idx > -1) {
      return;
    }

    this.activeEntries = [item, ...this.activeEntries];
    this.activate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

  onDeactivate(item) {
    const idx = this.activeEntries.findIndex(d => {
      return d.name === item.name && d.value === item.value;
    });
    this.activeEntries.splice(idx, 1);
    this.activeEntries = [...this.activeEntries];
    this.deactivate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

  deactivateAll() {
    this.activeEntries = [...this.activeEntries];

    for (const entry of this.activeEntries) {
      this.deactivate.emit({
        value: entry,
        entries: []
      });
    }

    this.activeEntries = [];
  }

}

AreaChartNormalizedComponent.ɵfac = /*@__PURE__*/function () {
  let ɵAreaChartNormalizedComponent_BaseFactory;
  return function AreaChartNormalizedComponent_Factory(t) {
    return (ɵAreaChartNormalizedComponent_BaseFactory || (ɵAreaChartNormalizedComponent_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](AreaChartNormalizedComponent)))(t || AreaChartNormalizedComponent);
  };
}();

AreaChartNormalizedComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: AreaChartNormalizedComponent,
  selectors: [["ngx-charts-area-chart-normalized"]],
  contentQueries: function AreaChartNormalizedComponent_ContentQueries(rf, ctx, dirIndex) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"](dirIndex, _c21, 5);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"](dirIndex, _c22, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.tooltipTemplate = _t.first);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.seriesTooltipTemplate = _t.first);
    }
  },
  hostBindings: function AreaChartNormalizedComponent_HostBindings(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("mouseleave", function AreaChartNormalizedComponent_mouseleave_HostBindingHandler() {
        return ctx.hideCircles();
      });
    }
  },
  inputs: {
    legend: "legend",
    legendTitle: "legendTitle",
    legendPosition: "legendPosition",
    showGridLines: "showGridLines",
    curve: "curve",
    activeEntries: "activeEntries",
    trimXAxisTicks: "trimXAxisTicks",
    trimYAxisTicks: "trimYAxisTicks",
    rotateXAxisTicks: "rotateXAxisTicks",
    maxXAxisTickLength: "maxXAxisTickLength",
    maxYAxisTickLength: "maxYAxisTickLength",
    roundDomains: "roundDomains",
    tooltipDisabled: "tooltipDisabled",
    xAxis: "xAxis",
    yAxis: "yAxis",
    showXAxisLabel: "showXAxisLabel",
    showYAxisLabel: "showYAxisLabel",
    xAxisLabel: "xAxisLabel",
    yAxisLabel: "yAxisLabel",
    timeline: "timeline",
    gradient: "gradient",
    schemeType: "schemeType",
    xAxisTickFormatting: "xAxisTickFormatting",
    yAxisTickFormatting: "yAxisTickFormatting",
    xAxisTicks: "xAxisTicks",
    yAxisTicks: "yAxisTicks"
  },
  outputs: {
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]],
  decls: 11,
  vars: 20,
  consts: [[3, "view", "showLegend", "legendOptions", "activeEntries", "animations", "legendLabelClick", "legendLabelActivate", "legendLabelDeactivate"], [1, "area-chart", "chart"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], [4, "ngFor", "ngForOf", "ngForTrackBy"], [3, "mouseleave", 4, "ngIf"], ["ngx-charts-timeline", "", 3, "results", "view", "height", "scheme", "customColors", "legend", "scaleType", "onDomainChange", 4, "ngIf"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-area-series", "", "normalized", "true", 3, "xScale", "yScale", "colors", "data", "scaleType", "activeEntries", "gradient", "curve", "animations"], [3, "mouseleave"], ["ngx-charts-tooltip-area", "", 3, "dims", "xSet", "xScale", "yScale", "results", "colors", "showPercentage", "tooltipDisabled", "tooltipTemplate", "hover"], [4, "ngFor", "ngForOf"], ["ngx-charts-circle-series", "", "type", "stacked", 3, "xScale", "yScale", "colors", "activeEntries", "data", "scaleType", "visibleValue", "tooltipDisabled", "tooltipTemplate", "select", "activate", "deactivate"], ["ngx-charts-timeline", "", 3, "results", "view", "height", "scheme", "customColors", "legend", "scaleType", "onDomainChange"], ["ngx-charts-area-series", "", "normalized", "true", 3, "xScale", "yScale", "colors", "data", "scaleType", "gradient", "curve", "animations"]],
  template: function AreaChartNormalizedComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "ngx-charts-chart", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("legendLabelClick", function AreaChartNormalizedComponent_Template_ngx_charts_chart_legendLabelClick_0_listener($event) {
        return ctx.onClick($event);
      })("legendLabelActivate", function AreaChartNormalizedComponent_Template_ngx_charts_chart_legendLabelActivate_0_listener($event) {
        return ctx.onActivate($event);
      })("legendLabelDeactivate", function AreaChartNormalizedComponent_Template_ngx_charts_chart_legendLabelDeactivate_0_listener($event) {
        return ctx.onDeactivate($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "defs")(2, "clipPath");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](3, "rect");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "g", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](5, AreaChartNormalizedComponent__svg_g_5_Template, 1, 10, "g", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](6, AreaChartNormalizedComponent__svg_g_6_Template, 1, 9, "g", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "g");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](8, AreaChartNormalizedComponent__svg_g_8_Template, 2, 9, "g", 4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](9, AreaChartNormalizedComponent__svg_g_9_Template, 3, 10, "g", 5);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](10, AreaChartNormalizedComponent__svg_g_10_Template, 2, 13, "g", 6);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("view", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](17, _c23, ctx.width, ctx.height))("showLegend", ctx.legend)("legendOptions", ctx.legendOptions)("activeEntries", ctx.activeEntries)("animations", ctx.animations);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("id", ctx.clipPathId);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("width", ctx.dims.width + 10)("height", ctx.dims.height + 10)("transform", "translate(-5, -5)");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.xAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.yAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("clip-path", ctx.clipPath);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.results)("ngForTrackBy", ctx.trackBy);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.tooltipDisabled);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.timeline && ctx.scaleType != "ordinal");
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, XAxisComponent, YAxisComponent, TooltipArea, ChartComponent, CircleSeriesComponent, Timeline, AreaSeriesComponent];
  },
  styles: [_c24],
  encapsulation: 2,
  changeDetection: 0
});
AreaChartNormalizedComponent.propDecorators = {
  legend: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendTitle: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendPosition: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showXAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showYAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  timeline: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showGridLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  curve: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  schemeType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimYAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  rotateXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxXAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxYAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundDomains: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
    args: ['tooltipTemplate']
  }],
  seriesTooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
    args: ['seriesTooltipTemplate']
  }],
  hideCircles: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['mouseleave']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](AreaChartNormalizedComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-charts-area-chart-normalized',
      template: `
    <ngx-charts-chart
      [view]="[width, height]"
      [showLegend]="legend"
      [legendOptions]="legendOptions"
      [activeEntries]="activeEntries"
      [animations]="animations"
      (legendLabelClick)="onClick($event)"
      (legendLabelActivate)="onActivate($event)"
      (legendLabelDeactivate)="onDeactivate($event)"
    >
      <svg:defs>
        <svg:clipPath [attr.id]="clipPathId">
          <svg:rect
            [attr.width]="dims.width + 10"
            [attr.height]="dims.height + 10"
            [attr.transform]="'translate(-5, -5)'"
          />
        </svg:clipPath>
      </svg:defs>
      <svg:g [attr.transform]="transform" class="area-chart chart">
        <svg:g
          ngx-charts-x-axis
          *ngIf="xAxis"
          [xScale]="xScale"
          [dims]="dims"
          [showGridLines]="showGridLines"
          [showLabel]="showXAxisLabel"
          [labelText]="xAxisLabel"
          [trimTicks]="trimXAxisTicks"
          [rotateTicks]="rotateXAxisTicks"
          [maxTickLength]="maxXAxisTickLength"
          [tickFormatting]="xAxisTickFormatting"
          [ticks]="xAxisTicks"
          (dimensionsChanged)="updateXAxisHeight($event)"
        ></svg:g>
        <svg:g
          ngx-charts-y-axis
          *ngIf="yAxis"
          [yScale]="yScale"
          [dims]="dims"
          [showGridLines]="showGridLines"
          [showLabel]="showYAxisLabel"
          [labelText]="yAxisLabel"
          [trimTicks]="trimYAxisTicks"
          [maxTickLength]="maxYAxisTickLength"
          [tickFormatting]="yAxisTickFormatting"
          [ticks]="yAxisTicks"
          (dimensionsChanged)="updateYAxisWidth($event)"
        ></svg:g>
        <svg:g [attr.clip-path]="clipPath">
          <svg:g *ngFor="let series of results; trackBy: trackBy">
            <svg:g
              ngx-charts-area-series
              [xScale]="xScale"
              [yScale]="yScale"
              [colors]="colors"
              [data]="series"
              [scaleType]="scaleType"
              [activeEntries]="activeEntries"
              [gradient]="gradient"
              normalized="true"
              [curve]="curve"
              [animations]="animations"
            />
          </svg:g>

          <svg:g *ngIf="!tooltipDisabled" (mouseleave)="hideCircles()">
            <svg:g
              ngx-charts-tooltip-area
              [dims]="dims"
              [xSet]="xSet"
              [xScale]="xScale"
              [yScale]="yScale"
              [results]="results"
              [colors]="colors"
              [showPercentage]="true"
              [tooltipDisabled]="tooltipDisabled"
              [tooltipTemplate]="seriesTooltipTemplate"
              (hover)="updateHoveredVertical($event)"
            />

            <svg:g *ngFor="let series of results">
              <svg:g
                ngx-charts-circle-series
                type="stacked"
                [xScale]="xScale"
                [yScale]="yScale"
                [colors]="colors"
                [activeEntries]="activeEntries"
                [data]="series"
                [scaleType]="scaleType"
                [visibleValue]="hoveredVertical"
                [tooltipDisabled]="tooltipDisabled"
                [tooltipTemplate]="tooltipTemplate"
                (select)="onClick($event, series)"
                (activate)="onActivate($event)"
                (deactivate)="onDeactivate($event)"
              />
            </svg:g>
          </svg:g>
        </svg:g>
      </svg:g>
      <svg:g
        ngx-charts-timeline
        *ngIf="timeline && scaleType != 'ordinal'"
        [attr.transform]="timelineTransform"
        [results]="results"
        [view]="[timelineWidth, height]"
        [height]="timelineHeight"
        [scheme]="scheme"
        [customColors]="customColors"
        [legend]="legend"
        [scaleType]="scaleType"
        (onDomainChange)="updateDomain($event)"
      >
        <svg:g *ngFor="let series of results; trackBy: trackBy">
          <svg:g
            ngx-charts-area-series
            [xScale]="timelineXScale"
            [yScale]="timelineYScale"
            [colors]="colors"
            [data]="series"
            [scaleType]="scaleType"
            [gradient]="gradient"
            normalized="true"
            [curve]="curve"
            [animations]="animations"
          />
        </svg:g>
      </svg:g>
    </ngx-charts-chart>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      styles: [".ngx-charts{float:left;overflow:visible}.ngx-charts .arc,.ngx-charts .bar,.ngx-charts .circle{cursor:pointer}.ngx-charts .arc.active,.ngx-charts .arc:hover,.ngx-charts .bar.active,.ngx-charts .bar:hover,.ngx-charts .card.active,.ngx-charts .card:hover,.ngx-charts .cell.active,.ngx-charts .cell:hover{opacity:.8;transition:opacity .1s ease-in-out}.ngx-charts .arc:focus,.ngx-charts .bar:focus,.ngx-charts .card:focus,.ngx-charts .cell:focus{outline:none}.ngx-charts .arc.hidden,.ngx-charts .bar.hidden,.ngx-charts .card.hidden,.ngx-charts .cell.hidden{display:none}.ngx-charts g:focus{outline:none}.ngx-charts .area-series.inactive,.ngx-charts .line-series-range.inactive,.ngx-charts .line-series.inactive,.ngx-charts .polar-series-area.inactive,.ngx-charts .polar-series-path.inactive{opacity:.2;transition:opacity .1s ease-in-out}.ngx-charts .line-highlight{display:none}.ngx-charts .line-highlight.active{display:block}.ngx-charts .area{opacity:.6}.ngx-charts .circle:hover{cursor:pointer}.ngx-charts .label{font-size:12px;font-weight:400}.ngx-charts .tooltip-anchor{fill:#000}.ngx-charts .gridline-path{fill:none;stroke:#ddd;stroke-width:1}.ngx-charts .refline-path{stroke:#a8b2c7;stroke-dasharray:5;stroke-dashoffset:5;stroke-width:1}.ngx-charts .refline-label{font-size:9px}.ngx-charts .reference-area{fill:#000;fill-opacity:.05}.ngx-charts .gridline-path-dotted{fill:none;stroke:#ddd;stroke-dasharray:1,20;stroke-dashoffset:3;stroke-width:1}.ngx-charts .grid-panel rect{fill:none}.ngx-charts .grid-panel.odd rect{fill:rgba(0,0,0,.05)}"]
    }]
  }], null, {
    legend: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendTitle: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendPosition: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showGridLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    curve: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimYAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    rotateXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxXAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxYAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundDomains: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    hideCircles: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['mouseleave']
    }],
    xAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showXAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showYAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    timeline: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    schemeType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
      args: ['tooltipTemplate']
    }],
    seriesTooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
      args: ['seriesTooltipTemplate']
    }]
  });
})();

class AreaChartStackedComponent extends BaseChartComponent {
  constructor() {
    super(...arguments);
    this.legend = false;
    this.legendTitle = 'Legend';
    this.legendPosition = 'right';
    this.showGridLines = true;
    this.curve = d3_shape__WEBPACK_IMPORTED_MODULE_16__["default"];
    this.activeEntries = [];
    this.trimXAxisTicks = true;
    this.trimYAxisTicks = true;
    this.rotateXAxisTicks = true;
    this.maxXAxisTickLength = 16;
    this.maxYAxisTickLength = 16;
    this.roundDomains = false;
    this.tooltipDisabled = false;
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.margin = [10, 20, 10, 20];
    this.xAxisHeight = 0;
    this.yAxisWidth = 0;
    this.timelineHeight = 50;
    this.timelinePadding = 10;
  }

  update() {
    super.update();
    this.dims = calculateViewDimensions({
      width: this.width,
      height: this.height,
      margins: this.margin,
      showXAxis: this.xAxis,
      showYAxis: this.yAxis,
      xAxisHeight: this.xAxisHeight,
      yAxisWidth: this.yAxisWidth,
      showXLabel: this.showXAxisLabel,
      showYLabel: this.showYAxisLabel,
      showLegend: this.legend,
      legendType: this.schemeType,
      legendPosition: this.legendPosition
    });

    if (this.timeline) {
      this.dims.height -= this.timelineHeight + this.margin[2] + this.timelinePadding;
    }

    this.xDomain = this.getXDomain();

    if (this.filteredDomain) {
      this.xDomain = this.filteredDomain;
    }

    this.yDomain = this.getYDomain();
    this.seriesDomain = this.getSeriesDomain();
    this.xScale = this.getXScale(this.xDomain, this.dims.width);
    this.yScale = this.getYScale(this.yDomain, this.dims.height);

    for (let i = 0; i < this.xSet.length; i++) {
      const val = this.xSet[i];
      let d0 = 0;

      for (const group of this.results) {
        let d = group.series.find(item => {
          let a = item.name;
          let b = val;

          if (this.scaleType === 'time') {
            a = a.valueOf();
            b = b.valueOf();
          }

          return a === b;
        });

        if (d) {
          d.d0 = d0;
          d.d1 = d0 + d.value;
          d0 += d.value;
        } else {
          d = {
            name: val,
            value: 0,
            d0,
            d1: d0
          };
          group.series.push(d);
        }
      }
    }

    this.updateTimeline();
    this.setColors();
    this.legendOptions = this.getLegendOptions();
    this.transform = `translate(${this.dims.xOffset} , ${this.margin[0]})`;
    this.clipPathId = 'clip' + id().toString();
    this.clipPath = `url(#${this.clipPathId})`;
  }

  updateTimeline() {
    if (this.timeline) {
      this.timelineWidth = this.dims.width;
      this.timelineXDomain = this.getXDomain();
      this.timelineXScale = this.getXScale(this.timelineXDomain, this.timelineWidth);
      this.timelineYScale = this.getYScale(this.yDomain, this.timelineHeight);
      this.timelineTransform = `translate(${this.dims.xOffset}, ${-this.margin[2]})`;
    }
  }

  getXDomain() {
    let values = getUniqueXDomainValues(this.results);
    this.scaleType = getScaleType(values);
    let domain = [];

    if (this.scaleType === 'linear') {
      values = values.map(v => Number(v));
    }

    let min;
    let max;

    if (this.scaleType === 'time' || this.scaleType === 'linear') {
      min = this.xScaleMin ? this.xScaleMin : Math.min(...values);
      max = this.xScaleMax ? this.xScaleMax : Math.max(...values);
    }

    if (this.scaleType === 'time') {
      domain = [new Date(min), new Date(max)];
      this.xSet = [...values].sort((a, b) => {
        const aDate = a.getTime();
        const bDate = b.getTime();
        if (aDate > bDate) return 1;
        if (bDate > aDate) return -1;
        return 0;
      });
    } else if (this.scaleType === 'linear') {
      domain = [min, max]; // Use compare function to sort numbers numerically

      this.xSet = [...values].sort((a, b) => a - b);
    } else {
      domain = values;
      this.xSet = values;
    }

    return domain;
  }

  getYDomain() {
    const domain = [];

    for (let i = 0; i < this.xSet.length; i++) {
      const val = this.xSet[i];
      let sum = 0;

      for (const group of this.results) {
        const d = group.series.find(item => {
          let a = item.name;
          let b = val;

          if (this.scaleType === 'time') {
            a = a.valueOf();
            b = b.valueOf();
          }

          return a === b;
        });

        if (d) {
          sum += d.value;
        }
      }

      domain.push(sum);
    }

    const min = this.yScaleMin ? this.yScaleMin : Math.min(0, ...domain);
    const max = this.yScaleMax ? this.yScaleMax : Math.max(...domain);
    return [min, max];
  }

  getSeriesDomain() {
    return this.results.map(d => d.name);
  }

  getXScale(domain, width) {
    let scale;

    if (this.scaleType === 'time') {
      scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_9__["default"])();
    } else if (this.scaleType === 'linear') {
      scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])();
    } else if (this.scaleType === 'ordinal') {
      scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_11__.point)().padding(0.1);
    }

    scale.range([0, width]).domain(domain);
    return this.roundDomains ? scale.nice() : scale;
  }

  getYScale(domain, height) {
    const scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().range([height, 0]).domain(domain);
    return this.roundDomains ? scale.nice() : scale;
  }

  updateDomain(domain) {
    this.filteredDomain = domain;
    this.xDomain = this.filteredDomain;
    this.xScale = this.getXScale(this.xDomain, this.dims.width);
  }

  updateHoveredVertical(item) {
    this.hoveredVertical = item.value;
    this.deactivateAll();
  }

  hideCircles() {
    this.hoveredVertical = null;
    this.deactivateAll();
  }

  onClick(data, series) {
    if (series) {
      data.series = series.name;
    }

    this.select.emit(data);
  }

  trackBy(index, item) {
    return item.name;
  }

  setColors() {
    let domain;

    if (this.schemeType === 'ordinal') {
      domain = this.seriesDomain;
    } else {
      domain = this.yDomain;
    }

    this.colors = new ColorHelper(this.scheme, this.schemeType, domain, this.customColors);
  }

  getLegendOptions() {
    const opts = {
      scaleType: this.schemeType,
      colors: undefined,
      domain: [],
      title: undefined,
      position: this.legendPosition
    };

    if (opts.scaleType === 'ordinal') {
      opts.domain = this.seriesDomain;
      opts.colors = this.colors;
      opts.title = this.legendTitle;
    } else {
      opts.domain = this.yDomain;
      opts.colors = this.colors.scale;
    }

    return opts;
  }

  updateYAxisWidth({
    width
  }) {
    this.yAxisWidth = width;
    this.update();
  }

  updateXAxisHeight({
    height
  }) {
    this.xAxisHeight = height;
    this.update();
  }

  onActivate(item) {
    const idx = this.activeEntries.findIndex(d => {
      return d.name === item.name && d.value === item.value;
    });

    if (idx > -1) {
      return;
    }

    this.activeEntries = [item, ...this.activeEntries];
    this.activate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

  onDeactivate(item) {
    const idx = this.activeEntries.findIndex(d => {
      return d.name === item.name && d.value === item.value;
    });
    this.activeEntries.splice(idx, 1);
    this.activeEntries = [...this.activeEntries];
    this.deactivate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

  deactivateAll() {
    this.activeEntries = [...this.activeEntries];

    for (const entry of this.activeEntries) {
      this.deactivate.emit({
        value: entry,
        entries: []
      });
    }

    this.activeEntries = [];
  }

}

AreaChartStackedComponent.ɵfac = /*@__PURE__*/function () {
  let ɵAreaChartStackedComponent_BaseFactory;
  return function AreaChartStackedComponent_Factory(t) {
    return (ɵAreaChartStackedComponent_BaseFactory || (ɵAreaChartStackedComponent_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](AreaChartStackedComponent)))(t || AreaChartStackedComponent);
  };
}();

AreaChartStackedComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: AreaChartStackedComponent,
  selectors: [["ngx-charts-area-chart-stacked"]],
  contentQueries: function AreaChartStackedComponent_ContentQueries(rf, ctx, dirIndex) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"](dirIndex, _c21, 5);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"](dirIndex, _c22, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.tooltipTemplate = _t.first);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.seriesTooltipTemplate = _t.first);
    }
  },
  hostBindings: function AreaChartStackedComponent_HostBindings(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("mouseleave", function AreaChartStackedComponent_mouseleave_HostBindingHandler() {
        return ctx.hideCircles();
      });
    }
  },
  inputs: {
    legend: "legend",
    legendTitle: "legendTitle",
    legendPosition: "legendPosition",
    showGridLines: "showGridLines",
    curve: "curve",
    activeEntries: "activeEntries",
    trimXAxisTicks: "trimXAxisTicks",
    trimYAxisTicks: "trimYAxisTicks",
    rotateXAxisTicks: "rotateXAxisTicks",
    maxXAxisTickLength: "maxXAxisTickLength",
    maxYAxisTickLength: "maxYAxisTickLength",
    roundDomains: "roundDomains",
    tooltipDisabled: "tooltipDisabled",
    xAxis: "xAxis",
    yAxis: "yAxis",
    showXAxisLabel: "showXAxisLabel",
    showYAxisLabel: "showYAxisLabel",
    xAxisLabel: "xAxisLabel",
    yAxisLabel: "yAxisLabel",
    timeline: "timeline",
    gradient: "gradient",
    schemeType: "schemeType",
    xAxisTickFormatting: "xAxisTickFormatting",
    yAxisTickFormatting: "yAxisTickFormatting",
    xAxisTicks: "xAxisTicks",
    yAxisTicks: "yAxisTicks",
    xScaleMin: "xScaleMin",
    xScaleMax: "xScaleMax",
    yScaleMin: "yScaleMin",
    yScaleMax: "yScaleMax"
  },
  outputs: {
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]],
  decls: 11,
  vars: 20,
  consts: [[3, "view", "showLegend", "legendOptions", "activeEntries", "animations", "legendLabelClick", "legendLabelActivate", "legendLabelDeactivate"], [1, "area-chart", "chart"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], [4, "ngFor", "ngForOf", "ngForTrackBy"], [3, "mouseleave", 4, "ngIf"], ["ngx-charts-timeline", "", 3, "results", "view", "height", "scheme", "customColors", "legend", "scaleType", "onDomainChange", 4, "ngIf"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-area-series", "", "stacked", "true", 3, "xScale", "yScale", "colors", "data", "scaleType", "gradient", "activeEntries", "curve", "animations"], [3, "mouseleave"], ["ngx-charts-tooltip-area", "", 3, "dims", "xSet", "xScale", "yScale", "results", "colors", "tooltipDisabled", "tooltipTemplate", "hover"], ["ngx-charts-circle-series", "", "type", "stacked", 3, "xScale", "yScale", "colors", "activeEntries", "data", "scaleType", "visibleValue", "tooltipDisabled", "tooltipTemplate", "select", "activate", "deactivate"], ["ngx-charts-timeline", "", 3, "results", "view", "height", "scheme", "customColors", "legend", "scaleType", "onDomainChange"], ["ngx-charts-area-series", "", "stacked", "true", 3, "xScale", "yScale", "colors", "data", "scaleType", "gradient", "curve", "animations"]],
  template: function AreaChartStackedComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "ngx-charts-chart", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("legendLabelClick", function AreaChartStackedComponent_Template_ngx_charts_chart_legendLabelClick_0_listener($event) {
        return ctx.onClick($event);
      })("legendLabelActivate", function AreaChartStackedComponent_Template_ngx_charts_chart_legendLabelActivate_0_listener($event) {
        return ctx.onActivate($event);
      })("legendLabelDeactivate", function AreaChartStackedComponent_Template_ngx_charts_chart_legendLabelDeactivate_0_listener($event) {
        return ctx.onDeactivate($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "defs")(2, "clipPath");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](3, "rect");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "g", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](5, AreaChartStackedComponent__svg_g_5_Template, 1, 10, "g", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](6, AreaChartStackedComponent__svg_g_6_Template, 1, 9, "g", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "g");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](8, AreaChartStackedComponent__svg_g_8_Template, 2, 9, "g", 4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](9, AreaChartStackedComponent__svg_g_9_Template, 3, 10, "g", 5);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](10, AreaChartStackedComponent__svg_g_10_Template, 2, 13, "g", 6);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("view", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](17, _c23, ctx.width, ctx.height))("showLegend", ctx.legend)("legendOptions", ctx.legendOptions)("activeEntries", ctx.activeEntries)("animations", ctx.animations);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("id", ctx.clipPathId);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("width", ctx.dims.width + 10)("height", ctx.dims.height + 10)("transform", "translate(-5, -5)");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.xAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.yAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("clip-path", ctx.clipPath);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.results)("ngForTrackBy", ctx.trackBy);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.tooltipDisabled);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.timeline && ctx.scaleType != "ordinal");
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, XAxisComponent, YAxisComponent, TooltipArea, ChartComponent, CircleSeriesComponent, Timeline, AreaSeriesComponent];
  },
  styles: [_c24],
  encapsulation: 2,
  changeDetection: 0
});
AreaChartStackedComponent.propDecorators = {
  legend: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendTitle: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendPosition: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showXAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showYAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  timeline: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showGridLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  curve: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  schemeType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimYAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  rotateXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxXAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxYAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundDomains: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScaleMin: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScaleMax: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScaleMin: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScaleMax: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
    args: ['tooltipTemplate']
  }],
  seriesTooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
    args: ['seriesTooltipTemplate']
  }],
  hideCircles: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['mouseleave']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](AreaChartStackedComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-charts-area-chart-stacked',
      template: `
    <ngx-charts-chart
      [view]="[width, height]"
      [showLegend]="legend"
      [legendOptions]="legendOptions"
      [activeEntries]="activeEntries"
      [animations]="animations"
      (legendLabelClick)="onClick($event)"
      (legendLabelActivate)="onActivate($event)"
      (legendLabelDeactivate)="onDeactivate($event)"
    >
      <svg:defs>
        <svg:clipPath [attr.id]="clipPathId">
          <svg:rect
            [attr.width]="dims.width + 10"
            [attr.height]="dims.height + 10"
            [attr.transform]="'translate(-5, -5)'"
          />
        </svg:clipPath>
      </svg:defs>
      <svg:g [attr.transform]="transform" class="area-chart chart">
        <svg:g
          ngx-charts-x-axis
          *ngIf="xAxis"
          [xScale]="xScale"
          [dims]="dims"
          [showGridLines]="showGridLines"
          [showLabel]="showXAxisLabel"
          [labelText]="xAxisLabel"
          [trimTicks]="trimXAxisTicks"
          [rotateTicks]="rotateXAxisTicks"
          [maxTickLength]="maxXAxisTickLength"
          [tickFormatting]="xAxisTickFormatting"
          [ticks]="xAxisTicks"
          (dimensionsChanged)="updateXAxisHeight($event)"
        ></svg:g>
        <svg:g
          ngx-charts-y-axis
          *ngIf="yAxis"
          [yScale]="yScale"
          [dims]="dims"
          [showGridLines]="showGridLines"
          [showLabel]="showYAxisLabel"
          [labelText]="yAxisLabel"
          [trimTicks]="trimYAxisTicks"
          [maxTickLength]="maxYAxisTickLength"
          [tickFormatting]="yAxisTickFormatting"
          [ticks]="yAxisTicks"
          (dimensionsChanged)="updateYAxisWidth($event)"
        ></svg:g>
        <svg:g [attr.clip-path]="clipPath">
          <svg:g *ngFor="let series of results; trackBy: trackBy">
            <svg:g
              ngx-charts-area-series
              [xScale]="xScale"
              [yScale]="yScale"
              [colors]="colors"
              [data]="series"
              [scaleType]="scaleType"
              [gradient]="gradient"
              [activeEntries]="activeEntries"
              stacked="true"
              [curve]="curve"
              [animations]="animations"
            />
          </svg:g>

          <svg:g *ngIf="!tooltipDisabled" (mouseleave)="hideCircles()">
            <svg:g
              ngx-charts-tooltip-area
              [dims]="dims"
              [xSet]="xSet"
              [xScale]="xScale"
              [yScale]="yScale"
              [results]="results"
              [colors]="colors"
              [tooltipDisabled]="tooltipDisabled"
              [tooltipTemplate]="seriesTooltipTemplate"
              (hover)="updateHoveredVertical($event)"
            />

            <svg:g *ngFor="let series of results; trackBy: trackBy">
              <svg:g
                ngx-charts-circle-series
                type="stacked"
                [xScale]="xScale"
                [yScale]="yScale"
                [colors]="colors"
                [activeEntries]="activeEntries"
                [data]="series"
                [scaleType]="scaleType"
                [visibleValue]="hoveredVertical"
                [tooltipDisabled]="tooltipDisabled"
                [tooltipTemplate]="tooltipTemplate"
                (select)="onClick($event, series)"
                (activate)="onActivate($event)"
                (deactivate)="onDeactivate($event)"
              />
            </svg:g>
          </svg:g>
        </svg:g>
      </svg:g>
      <svg:g
        ngx-charts-timeline
        *ngIf="timeline && scaleType != 'ordinal'"
        [attr.transform]="timelineTransform"
        [results]="results"
        [view]="[timelineWidth, height]"
        [height]="timelineHeight"
        [scheme]="scheme"
        [customColors]="customColors"
        [legend]="legend"
        [scaleType]="scaleType"
        (onDomainChange)="updateDomain($event)"
      >
        <svg:g *ngFor="let series of results; trackBy: trackBy">
          <svg:g
            ngx-charts-area-series
            [xScale]="timelineXScale"
            [yScale]="timelineYScale"
            [colors]="colors"
            [data]="series"
            [scaleType]="scaleType"
            [gradient]="gradient"
            stacked="true"
            [curve]="curve"
            [animations]="animations"
          />
        </svg:g>
      </svg:g>
    </ngx-charts-chart>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      styles: [".ngx-charts{float:left;overflow:visible}.ngx-charts .arc,.ngx-charts .bar,.ngx-charts .circle{cursor:pointer}.ngx-charts .arc.active,.ngx-charts .arc:hover,.ngx-charts .bar.active,.ngx-charts .bar:hover,.ngx-charts .card.active,.ngx-charts .card:hover,.ngx-charts .cell.active,.ngx-charts .cell:hover{opacity:.8;transition:opacity .1s ease-in-out}.ngx-charts .arc:focus,.ngx-charts .bar:focus,.ngx-charts .card:focus,.ngx-charts .cell:focus{outline:none}.ngx-charts .arc.hidden,.ngx-charts .bar.hidden,.ngx-charts .card.hidden,.ngx-charts .cell.hidden{display:none}.ngx-charts g:focus{outline:none}.ngx-charts .area-series.inactive,.ngx-charts .line-series-range.inactive,.ngx-charts .line-series.inactive,.ngx-charts .polar-series-area.inactive,.ngx-charts .polar-series-path.inactive{opacity:.2;transition:opacity .1s ease-in-out}.ngx-charts .line-highlight{display:none}.ngx-charts .line-highlight.active{display:block}.ngx-charts .area{opacity:.6}.ngx-charts .circle:hover{cursor:pointer}.ngx-charts .label{font-size:12px;font-weight:400}.ngx-charts .tooltip-anchor{fill:#000}.ngx-charts .gridline-path{fill:none;stroke:#ddd;stroke-width:1}.ngx-charts .refline-path{stroke:#a8b2c7;stroke-dasharray:5;stroke-dashoffset:5;stroke-width:1}.ngx-charts .refline-label{font-size:9px}.ngx-charts .reference-area{fill:#000;fill-opacity:.05}.ngx-charts .gridline-path-dotted{fill:none;stroke:#ddd;stroke-dasharray:1,20;stroke-dashoffset:3;stroke-width:1}.ngx-charts .grid-panel rect{fill:none}.ngx-charts .grid-panel.odd rect{fill:rgba(0,0,0,.05)}"]
    }]
  }], null, {
    legend: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendTitle: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendPosition: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showGridLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    curve: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimYAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    rotateXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxXAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxYAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundDomains: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    hideCircles: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['mouseleave']
    }],
    xAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showXAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showYAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    timeline: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    schemeType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScaleMin: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScaleMax: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScaleMin: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScaleMax: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
      args: ['tooltipTemplate']
    }],
    seriesTooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
      args: ['seriesTooltipTemplate']
    }]
  });
})();

function sortLinear(data, property, direction = 'asc') {
  return data.sort((a, b) => {
    if (direction === 'asc') {
      return a[property] - b[property];
    } else {
      return b[property] - a[property];
    }
  });
}

function sortByDomain(data, property, direction = 'asc', domain) {
  return data.sort((a, b) => {
    const aVal = a[property];
    const bVal = b[property];
    const aIdx = domain.indexOf(aVal);
    const bIdx = domain.indexOf(bVal);

    if (direction === 'asc') {
      return aIdx - bIdx;
    } else {
      return bIdx - aIdx;
    }
  });
}

function sortByTime(data, property, direction = 'asc') {
  return data.sort((a, b) => {
    const aDate = a[property].getTime();
    const bDate = b[property].getTime();

    if (direction === 'asc') {
      if (aDate > bDate) return 1;
      if (bDate > aDate) return -1;
      return 0;
    } else {
      if (aDate > bDate) return -1;
      if (bDate > aDate) return 1;
      return 0;
    }
  });
}

class AreaSeriesComponent {
  constructor() {
    this.baseValue = 'auto';
    this.stacked = false;
    this.normalized = false;
    this.animations = true;
    this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
  }

  ngOnChanges(changes) {
    this.update();
  }

  update() {
    this.updateGradient();
    let currentArea;
    let startingArea;

    const xProperty = d => {
      const label = d.name;
      return this.xScale(label);
    };

    if (this.stacked || this.normalized) {
      currentArea = (0,d3_shape__WEBPACK_IMPORTED_MODULE_17__["default"])().x(xProperty).y0((d, i) => this.yScale(d.d0)).y1((d, i) => this.yScale(d.d1));
      startingArea = (0,d3_shape__WEBPACK_IMPORTED_MODULE_17__["default"])().x(xProperty).y0(d => this.yScale.range()[0]).y1(d => this.yScale.range()[0]);
    } else {
      currentArea = (0,d3_shape__WEBPACK_IMPORTED_MODULE_17__["default"])().x(xProperty).y0(() => this.baseValue === 'auto' ? this.yScale.range()[0] : this.yScale(this.baseValue)).y1(d => this.yScale(d.value));
      startingArea = (0,d3_shape__WEBPACK_IMPORTED_MODULE_17__["default"])().x(xProperty).y0(d => this.baseValue === 'auto' ? this.yScale.range()[0] : this.yScale(this.baseValue)).y1(d => this.baseValue === 'auto' ? this.yScale.range()[0] : this.yScale(this.baseValue));
    }

    currentArea.curve(this.curve);
    startingArea.curve(this.curve);
    this.opacity = 0.8;
    let data = this.data.series;

    if (this.scaleType === 'linear') {
      data = sortLinear(data, 'name');
    } else if (this.scaleType === 'time') {
      data = sortByTime(data, 'name');
    } else {
      data = sortByDomain(data, 'name', 'asc', this.xScale.domain());
    }

    this.path = currentArea(data);
    this.startingPath = startingArea(data);
  }

  updateGradient() {
    if (this.colors.scaleType === 'linear') {
      this.hasGradient = true;

      if (this.stacked || this.normalized) {
        const d0values = this.data.series.map(d => d.d0);
        const d1values = this.data.series.map(d => d.d1);
        const max = Math.max(...d1values);
        const min = Math.min(...d0values);
        this.gradientStops = this.colors.getLinearGradientStops(max, min);
      } else {
        const values = this.data.series.map(d => d.value);
        const max = Math.max(...values);
        this.gradientStops = this.colors.getLinearGradientStops(max);
      }
    } else {
      this.hasGradient = false;
      this.gradientStops = undefined;
    }
  }

  isActive(entry) {
    if (!this.activeEntries) return false;
    const item = this.activeEntries.find(d => {
      return entry.name === d.name;
    });
    return item !== undefined;
  }

  isInactive(entry) {
    if (!this.activeEntries || this.activeEntries.length === 0) return false;
    const item = this.activeEntries.find(d => {
      return entry.name === d.name;
    });
    return item === undefined;
  }

}

AreaSeriesComponent.ɵfac = function AreaSeriesComponent_Factory(t) {
  return new (t || AreaSeriesComponent)();
};

AreaSeriesComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: AreaSeriesComponent,
  selectors: [["g", "ngx-charts-area-series", ""]],
  inputs: {
    baseValue: "baseValue",
    stacked: "stacked",
    normalized: "normalized",
    animations: "animations",
    data: "data",
    xScale: "xScale",
    yScale: "yScale",
    colors: "colors",
    scaleType: "scaleType",
    gradient: "gradient",
    curve: "curve",
    activeEntries: "activeEntries"
  },
  outputs: {
    select: "select"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c25,
  decls: 1,
  vars: 12,
  consts: [["ngx-charts-area", "", 1, "area-series", 3, "data", "path", "fill", "stops", "startingPath", "opacity", "gradient", "animations"]],
  template: function AreaSeriesComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "g", 0);
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("active", ctx.isActive(ctx.data))("inactive", ctx.isInactive(ctx.data));
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("data", ctx.data)("path", ctx.path)("fill", ctx.colors.getColor(ctx.data.name))("stops", ctx.gradientStops)("startingPath", ctx.startingPath)("opacity", ctx.opacity)("gradient", ctx.gradient || ctx.hasGradient)("animations", ctx.animations);
    }
  },
  dependencies: [AreaComponent],
  encapsulation: 2,
  changeDetection: 0
});
AreaSeriesComponent.propDecorators = {
  data: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  baseValue: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  colors: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  scaleType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  stacked: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  normalized: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  curve: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  animations: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  select: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](AreaSeriesComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-area-series]',
      template: `
    <svg:g
      ngx-charts-area
      class="area-series"
      [data]="data"
      [path]="path"
      [fill]="colors.getColor(data.name)"
      [stops]="gradientStops"
      [startingPath]="startingPath"
      [opacity]="opacity"
      [gradient]="gradient || hasGradient"
      [animations]="animations"
      [class.active]="isActive(data)"
      [class.inactive]="isInactive(data)"
    />
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush
    }]
  }], function () {
    return [];
  }, {
    baseValue: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    stacked: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    normalized: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    animations: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    select: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    data: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    colors: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    scaleType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    curve: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class AreaChartModule {}

AreaChartModule.ɵfac = function AreaChartModule_Factory(t) {
  return new (t || AreaChartModule)();
};

AreaChartModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({
  type: AreaChartModule
});
AreaChartModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({
  imports: [ChartCommonModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](AreaChartModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.NgModule,
    args: [{
      imports: [ChartCommonModule],
      declarations: [AreaChartComponent, AreaChartNormalizedComponent, AreaChartStackedComponent, AreaSeriesComponent],
      exports: [AreaChartComponent, AreaChartNormalizedComponent, AreaChartStackedComponent, AreaSeriesComponent]
    }]
  }], null, null);
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](AreaChartModule, {
    declarations: [AreaChartComponent, AreaChartNormalizedComponent, AreaChartStackedComponent, AreaSeriesComponent],
    imports: [ChartCommonModule],
    exports: [AreaChartComponent, AreaChartNormalizedComponent, AreaChartStackedComponent, AreaSeriesComponent]
  });
})();

class BarComponent {
  constructor(element) {
    this.roundEdges = true;
    this.gradient = false;
    this.offset = 0;
    this.isActive = false;
    this.animations = true;
    this.noBarWhenZero = true;
    this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.hasGradient = false;
    this.hideBar = false;
    this.element = element.nativeElement;
  }

  ngOnChanges(changes) {
    if (changes.roundEdges) {
      this.loadAnimation();
    }

    this.update();
  }

  update() {
    this.gradientId = 'grad' + id().toString();
    this.gradientFill = `url(#${this.gradientId})`;

    if (this.gradient || this.stops) {
      this.gradientStops = this.getGradient();
      this.hasGradient = true;
    } else {
      this.hasGradient = false;
    }

    this.updatePathEl();
    this.checkToHideBar();
  }

  loadAnimation() {
    this.path = this.getStartingPath();
    setTimeout(this.update.bind(this), 100);
  }

  updatePathEl() {
    const node = (0,d3_selection__WEBPACK_IMPORTED_MODULE_8__["default"])(this.element).select('.bar');
    const path = this.getPath();

    if (this.animations) {
      node.transition().duration(500).attr('d', path);
    } else {
      node.attr('d', path);
    }
  }

  getGradient() {
    if (this.stops) {
      return this.stops;
    }

    return [{
      offset: 0,
      color: this.fill,
      opacity: this.getStartOpacity()
    }, {
      offset: 100,
      color: this.fill,
      opacity: 1
    }];
  }

  getStartingPath() {
    if (!this.animations) {
      return this.getPath();
    }

    let radius = this.getRadius();
    let path;

    if (this.roundEdges) {
      if (this.orientation === 'vertical') {
        radius = Math.min(this.height, radius);
        path = roundedRect(this.x, this.y + this.height, this.width, 1, 0, this.edges);
      } else if (this.orientation === 'horizontal') {
        radius = Math.min(this.width, radius);
        path = roundedRect(this.x, this.y, 1, this.height, 0, this.edges);
      }
    } else {
      if (this.orientation === 'vertical') {
        path = roundedRect(this.x, this.y + this.height, this.width, 1, 0, this.edges);
      } else if (this.orientation === 'horizontal') {
        path = roundedRect(this.x, this.y, 1, this.height, 0, this.edges);
      }
    }

    return path;
  }

  getPath() {
    let radius = this.getRadius();
    let path;

    if (this.roundEdges) {
      if (this.orientation === 'vertical') {
        radius = Math.min(this.height, radius);
        path = roundedRect(this.x, this.y, this.width, this.height, radius, this.edges);
      } else if (this.orientation === 'horizontal') {
        radius = Math.min(this.width, radius);
        path = roundedRect(this.x, this.y, this.width, this.height, radius, this.edges);
      }
    } else {
      path = roundedRect(this.x, this.y, this.width, this.height, radius, this.edges);
    }

    return path;
  }

  getRadius() {
    let radius = 0;

    if (this.roundEdges && this.height > 5 && this.width > 5) {
      radius = Math.floor(Math.min(5, this.height / 2, this.width / 2));
    }

    return radius;
  }

  getStartOpacity() {
    if (this.roundEdges) {
      return 0.2;
    } else {
      return 0.5;
    }
  }

  get edges() {
    let edges = [false, false, false, false];

    if (this.roundEdges) {
      if (this.orientation === 'vertical') {
        if (this.data.value > 0) {
          edges = [true, true, false, false];
        } else {
          edges = [false, false, true, true];
        }
      } else if (this.orientation === 'horizontal') {
        if (this.data.value > 0) {
          edges = [false, true, false, true];
        } else {
          edges = [true, false, true, false];
        }
      }
    }

    return edges;
  }

  onMouseEnter() {
    this.activate.emit(this.data);
  }

  onMouseLeave() {
    this.deactivate.emit(this.data);
  }

  checkToHideBar() {
    this.hideBar = this.noBarWhenZero && (this.orientation === 'vertical' && this.height === 0 || this.orientation === 'horizontal' && this.width === 0);
  }

}

BarComponent.ɵfac = function BarComponent_Factory(t) {
  return new (t || BarComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef));
};

BarComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: BarComponent,
  selectors: [["g", "ngx-charts-bar", ""]],
  hostBindings: function BarComponent_HostBindings(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("mouseenter", function BarComponent_mouseenter_HostBindingHandler() {
        return ctx.onMouseEnter();
      })("mouseleave", function BarComponent_mouseleave_HostBindingHandler() {
        return ctx.onMouseLeave();
      });
    }
  },
  inputs: {
    roundEdges: "roundEdges",
    gradient: "gradient",
    offset: "offset",
    isActive: "isActive",
    animations: "animations",
    noBarWhenZero: "noBarWhenZero",
    fill: "fill",
    data: "data",
    width: "width",
    height: "height",
    x: "x",
    y: "y",
    orientation: "orientation",
    stops: "stops",
    ariaLabel: "ariaLabel"
  },
  outputs: {
    select: "select",
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c26,
  decls: 2,
  vars: 8,
  consts: [[4, "ngIf"], ["stroke", "none", "role", "img", "tabIndex", "-1", 1, "bar", 3, "click"], ["ngx-charts-svg-linear-gradient", "", 3, "orientation", "name", "stops"]],
  template: function BarComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, BarComponent__svg_defs_0_Template, 2, 3, "defs", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "path", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function BarComponent_Template__svg_path_click_1_listener() {
        return ctx.select.emit(ctx.data);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.hasGradient);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("active", ctx.isActive)("hidden", ctx.hideBar);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("d", ctx.path)("aria-label", ctx.ariaLabel)("fill", ctx.hasGradient ? ctx.gradientFill : ctx.fill);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, SvgLinearGradientComponent],
  encapsulation: 2,
  changeDetection: 0
});

BarComponent.ctorParameters = () => [{
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
}];

BarComponent.propDecorators = {
  fill: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  data: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  width: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  height: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  x: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  y: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  orientation: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundEdges: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  offset: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  isActive: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  stops: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  animations: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  ariaLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  noBarWhenZero: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  select: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  onMouseEnter: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['mouseenter']
  }],
  onMouseLeave: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['mouseleave']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](BarComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-bar]',
      template: `
    <svg:defs *ngIf="hasGradient">
      <svg:g ngx-charts-svg-linear-gradient [orientation]="orientation" [name]="gradientId" [stops]="gradientStops" />
    </svg:defs>
    <svg:path
      class="bar"
      stroke="none"
      role="img"
      tabIndex="-1"
      [class.active]="isActive"
      [class.hidden]="hideBar"
      [attr.d]="path"
      [attr.aria-label]="ariaLabel"
      [attr.fill]="hasGradient ? gradientFill : fill"
      (click)="select.emit(data)"
    />
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush
    }]
  }], function () {
    return [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
    }];
  }, {
    roundEdges: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    offset: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    isActive: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    animations: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    noBarWhenZero: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    select: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    onMouseEnter: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['mouseenter']
    }],
    onMouseLeave: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['mouseleave']
    }],
    fill: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    data: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    width: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    height: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    x: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    y: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    orientation: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    stops: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    ariaLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class BarHorizontalComponent extends BaseChartComponent {
  constructor() {
    super(...arguments);
    this.legend = false;
    this.legendTitle = 'Legend';
    this.legendPosition = 'right';
    this.tooltipDisabled = false;
    this.showGridLines = true;
    this.activeEntries = [];
    this.trimXAxisTicks = true;
    this.trimYAxisTicks = true;
    this.rotateXAxisTicks = true;
    this.maxXAxisTickLength = 16;
    this.maxYAxisTickLength = 16;
    this.barPadding = 8;
    this.roundDomains = false;
    this.roundEdges = true;
    this.showDataLabel = false;
    this.noBarWhenZero = true;
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.margin = [10, 20, 10, 20];
    this.xAxisHeight = 0;
    this.yAxisWidth = 0;
    this.dataLabelMaxWidth = {
      negative: 0,
      positive: 0
    };
  }

  update() {
    super.update();

    if (!this.showDataLabel) {
      this.dataLabelMaxWidth = {
        negative: 0,
        positive: 0
      };
    }

    this.margin = [10, 20 + this.dataLabelMaxWidth.positive, 10, 20 + this.dataLabelMaxWidth.negative];
    this.dims = calculateViewDimensions({
      width: this.width,
      height: this.height,
      margins: this.margin,
      showXAxis: this.xAxis,
      showYAxis: this.yAxis,
      xAxisHeight: this.xAxisHeight,
      yAxisWidth: this.yAxisWidth,
      showXLabel: this.showXAxisLabel,
      showYLabel: this.showYAxisLabel,
      showLegend: this.legend,
      legendType: this.schemeType,
      legendPosition: this.legendPosition
    });
    this.formatDates();
    this.xScale = this.getXScale();
    this.yScale = this.getYScale();
    this.setColors();
    this.legendOptions = this.getLegendOptions();
    this.transform = `translate(${this.dims.xOffset} , ${this.margin[0]})`;
  }

  getXScale() {
    this.xDomain = this.getXDomain();
    const scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().range([0, this.dims.width]).domain(this.xDomain);
    return this.roundDomains ? scale.nice() : scale;
  }

  getYScale() {
    this.yDomain = this.getYDomain();
    const spacing = this.yDomain.length / (this.dims.height / this.barPadding + 1);
    return (0,d3_scale__WEBPACK_IMPORTED_MODULE_11__["default"])().rangeRound([0, this.dims.height]).paddingInner(spacing).domain(this.yDomain);
  }

  getXDomain() {
    const values = this.results.map(d => d.value);
    const min = this.xScaleMin ? Math.min(this.xScaleMin, ...values) : Math.min(0, ...values);
    const max = this.xScaleMax ? Math.max(this.xScaleMax, ...values) : Math.max(0, ...values);
    return [min, max];
  }

  getYDomain() {
    return this.results.map(d => d.label);
  }

  onClick(data) {
    this.select.emit(data);
  }

  setColors() {
    let domain;

    if (this.schemeType === 'ordinal') {
      domain = this.yDomain;
    } else {
      domain = this.xDomain;
    }

    this.colors = new ColorHelper(this.scheme, this.schemeType, domain, this.customColors);
  }

  getLegendOptions() {
    const opts = {
      scaleType: this.schemeType,
      colors: undefined,
      domain: [],
      title: undefined,
      position: this.legendPosition
    };

    if (opts.scaleType === 'ordinal') {
      opts.domain = this.yDomain;
      opts.colors = this.colors;
      opts.title = this.legendTitle;
    } else {
      opts.domain = this.xDomain;
      opts.colors = this.colors.scale;
    }

    return opts;
  }

  updateYAxisWidth({
    width
  }) {
    this.yAxisWidth = width;
    this.update();
  }

  updateXAxisHeight({
    height
  }) {
    this.xAxisHeight = height;
    this.update();
  }

  onDataLabelMaxWidthChanged(event) {
    if (event.size.negative) {
      this.dataLabelMaxWidth.negative = Math.max(this.dataLabelMaxWidth.negative, event.size.width);
    } else {
      this.dataLabelMaxWidth.positive = Math.max(this.dataLabelMaxWidth.positive, event.size.width);
    }

    if (event.index === this.results.length - 1) {
      setTimeout(() => this.update());
    }
  }

  onActivate(item, fromLegend = false) {
    item = this.results.find(d => {
      if (fromLegend) {
        return d.label === item.name;
      } else {
        return d.name === item.name;
      }
    });
    const idx = this.activeEntries.findIndex(d => {
      return d.name === item.name && d.value === item.value && d.series === item.series;
    });

    if (idx > -1) {
      return;
    }

    this.activeEntries = [item, ...this.activeEntries];
    this.activate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

  onDeactivate(item, fromLegend = false) {
    item = this.results.find(d => {
      if (fromLegend) {
        return d.label === item.name;
      } else {
        return d.name === item.name;
      }
    });
    const idx = this.activeEntries.findIndex(d => {
      return d.name === item.name && d.value === item.value && d.series === item.series;
    });
    this.activeEntries.splice(idx, 1);
    this.activeEntries = [...this.activeEntries];
    this.deactivate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

}

BarHorizontalComponent.ɵfac = /*@__PURE__*/function () {
  let ɵBarHorizontalComponent_BaseFactory;
  return function BarHorizontalComponent_Factory(t) {
    return (ɵBarHorizontalComponent_BaseFactory || (ɵBarHorizontalComponent_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](BarHorizontalComponent)))(t || BarHorizontalComponent);
  };
}();

BarHorizontalComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: BarHorizontalComponent,
  selectors: [["ngx-charts-bar-horizontal"]],
  contentQueries: function BarHorizontalComponent_ContentQueries(rf, ctx, dirIndex) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"](dirIndex, _c21, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.tooltipTemplate = _t.first);
    }
  },
  inputs: {
    legend: "legend",
    legendTitle: "legendTitle",
    legendPosition: "legendPosition",
    tooltipDisabled: "tooltipDisabled",
    showGridLines: "showGridLines",
    activeEntries: "activeEntries",
    trimXAxisTicks: "trimXAxisTicks",
    trimYAxisTicks: "trimYAxisTicks",
    rotateXAxisTicks: "rotateXAxisTicks",
    maxXAxisTickLength: "maxXAxisTickLength",
    maxYAxisTickLength: "maxYAxisTickLength",
    barPadding: "barPadding",
    roundDomains: "roundDomains",
    roundEdges: "roundEdges",
    showDataLabel: "showDataLabel",
    noBarWhenZero: "noBarWhenZero",
    xAxis: "xAxis",
    yAxis: "yAxis",
    showXAxisLabel: "showXAxisLabel",
    showYAxisLabel: "showYAxisLabel",
    xAxisLabel: "xAxisLabel",
    yAxisLabel: "yAxisLabel",
    gradient: "gradient",
    schemeType: "schemeType",
    xAxisTickFormatting: "xAxisTickFormatting",
    yAxisTickFormatting: "yAxisTickFormatting",
    xAxisTicks: "xAxisTicks",
    yAxisTicks: "yAxisTicks",
    xScaleMax: "xScaleMax",
    xScaleMin: "xScaleMin",
    dataLabelFormatting: "dataLabelFormatting"
  },
  outputs: {
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]],
  decls: 5,
  vars: 25,
  consts: [[3, "view", "showLegend", "legendOptions", "activeEntries", "animations", "legendLabelClick", "legendLabelActivate", "legendLabelDeactivate"], [1, "bar-chart", "chart"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "yAxisOffset", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-series-horizontal", "", 3, "xScale", "yScale", "colors", "series", "dims", "gradient", "tooltipDisabled", "tooltipTemplate", "activeEntries", "roundEdges", "animations", "showDataLabel", "dataLabelFormatting", "noBarWhenZero", "select", "activate", "deactivate", "dataLabelWidthChanged"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "yAxisOffset", "dimensionsChanged"]],
  template: function BarHorizontalComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "ngx-charts-chart", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("legendLabelClick", function BarHorizontalComponent_Template_ngx_charts_chart_legendLabelClick_0_listener($event) {
        return ctx.onClick($event);
      })("legendLabelActivate", function BarHorizontalComponent_Template_ngx_charts_chart_legendLabelActivate_0_listener($event) {
        return ctx.onActivate($event, true);
      })("legendLabelDeactivate", function BarHorizontalComponent_Template_ngx_charts_chart_legendLabelDeactivate_0_listener($event) {
        return ctx.onDeactivate($event, true);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "g", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, BarHorizontalComponent__svg_g_2_Template, 1, 10, "g", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, BarHorizontalComponent__svg_g_3_Template, 1, 9, "g", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "g", 4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("select", function BarHorizontalComponent_Template__svg_g_select_4_listener($event) {
        return ctx.onClick($event);
      })("activate", function BarHorizontalComponent_Template__svg_g_activate_4_listener($event) {
        return ctx.onActivate($event);
      })("deactivate", function BarHorizontalComponent_Template__svg_g_deactivate_4_listener($event) {
        return ctx.onDeactivate($event);
      })("dataLabelWidthChanged", function BarHorizontalComponent_Template__svg_g_dataLabelWidthChanged_4_listener($event) {
        return ctx.onDataLabelMaxWidthChanged($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("view", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](22, _c23, ctx.width, ctx.height))("showLegend", ctx.legend)("legendOptions", ctx.legendOptions)("activeEntries", ctx.activeEntries)("animations", ctx.animations);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.xAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.yAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx.xScale)("yScale", ctx.yScale)("colors", ctx.colors)("series", ctx.results)("dims", ctx.dims)("gradient", ctx.gradient)("tooltipDisabled", ctx.tooltipDisabled)("tooltipTemplate", ctx.tooltipTemplate)("activeEntries", ctx.activeEntries)("roundEdges", ctx.roundEdges)("animations", ctx.animations)("showDataLabel", ctx.showDataLabel)("dataLabelFormatting", ctx.dataLabelFormatting)("noBarWhenZero", ctx.noBarWhenZero);
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, XAxisComponent, YAxisComponent, ChartComponent, SeriesHorizontal];
  },
  styles: [_c24],
  encapsulation: 2,
  changeDetection: 0
});
BarHorizontalComponent.propDecorators = {
  legend: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendTitle: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendPosition: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showXAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showYAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showGridLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  schemeType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimYAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  rotateXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxXAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxYAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  barPadding: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundDomains: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundEdges: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScaleMax: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScaleMin: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showDataLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  dataLabelFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  noBarWhenZero: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
    args: ['tooltipTemplate']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](BarHorizontalComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-charts-bar-horizontal',
      template: `
    <ngx-charts-chart
      [view]="[width, height]"
      [showLegend]="legend"
      [legendOptions]="legendOptions"
      [activeEntries]="activeEntries"
      [animations]="animations"
      (legendLabelClick)="onClick($event)"
      (legendLabelActivate)="onActivate($event, true)"
      (legendLabelDeactivate)="onDeactivate($event, true)"
    >
      <svg:g [attr.transform]="transform" class="bar-chart chart">
        <svg:g
          ngx-charts-x-axis
          *ngIf="xAxis"
          [xScale]="xScale"
          [dims]="dims"
          [showGridLines]="showGridLines"
          [showLabel]="showXAxisLabel"
          [labelText]="xAxisLabel"
          [trimTicks]="trimXAxisTicks"
          [rotateTicks]="rotateXAxisTicks"
          [maxTickLength]="maxXAxisTickLength"
          [tickFormatting]="xAxisTickFormatting"
          [ticks]="xAxisTicks"
          (dimensionsChanged)="updateXAxisHeight($event)"
        ></svg:g>
        <svg:g
          ngx-charts-y-axis
          *ngIf="yAxis"
          [yScale]="yScale"
          [dims]="dims"
          [showLabel]="showYAxisLabel"
          [labelText]="yAxisLabel"
          [trimTicks]="trimYAxisTicks"
          [maxTickLength]="maxYAxisTickLength"
          [tickFormatting]="yAxisTickFormatting"
          [ticks]="yAxisTicks"
          [yAxisOffset]="dataLabelMaxWidth.negative"
          (dimensionsChanged)="updateYAxisWidth($event)"
        ></svg:g>
        <svg:g
          ngx-charts-series-horizontal
          [xScale]="xScale"
          [yScale]="yScale"
          [colors]="colors"
          [series]="results"
          [dims]="dims"
          [gradient]="gradient"
          [tooltipDisabled]="tooltipDisabled"
          [tooltipTemplate]="tooltipTemplate"
          [activeEntries]="activeEntries"
          [roundEdges]="roundEdges"
          [animations]="animations"
          [showDataLabel]="showDataLabel"
          [dataLabelFormatting]="dataLabelFormatting"
          [noBarWhenZero]="noBarWhenZero"
          (select)="onClick($event)"
          (activate)="onActivate($event)"
          (deactivate)="onDeactivate($event)"
          (dataLabelWidthChanged)="onDataLabelMaxWidthChanged($event)"
        ></svg:g>
      </svg:g>
    </ngx-charts-chart>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      styles: [".ngx-charts{float:left;overflow:visible}.ngx-charts .arc,.ngx-charts .bar,.ngx-charts .circle{cursor:pointer}.ngx-charts .arc.active,.ngx-charts .arc:hover,.ngx-charts .bar.active,.ngx-charts .bar:hover,.ngx-charts .card.active,.ngx-charts .card:hover,.ngx-charts .cell.active,.ngx-charts .cell:hover{opacity:.8;transition:opacity .1s ease-in-out}.ngx-charts .arc:focus,.ngx-charts .bar:focus,.ngx-charts .card:focus,.ngx-charts .cell:focus{outline:none}.ngx-charts .arc.hidden,.ngx-charts .bar.hidden,.ngx-charts .card.hidden,.ngx-charts .cell.hidden{display:none}.ngx-charts g:focus{outline:none}.ngx-charts .area-series.inactive,.ngx-charts .line-series-range.inactive,.ngx-charts .line-series.inactive,.ngx-charts .polar-series-area.inactive,.ngx-charts .polar-series-path.inactive{opacity:.2;transition:opacity .1s ease-in-out}.ngx-charts .line-highlight{display:none}.ngx-charts .line-highlight.active{display:block}.ngx-charts .area{opacity:.6}.ngx-charts .circle:hover{cursor:pointer}.ngx-charts .label{font-size:12px;font-weight:400}.ngx-charts .tooltip-anchor{fill:#000}.ngx-charts .gridline-path{fill:none;stroke:#ddd;stroke-width:1}.ngx-charts .refline-path{stroke:#a8b2c7;stroke-dasharray:5;stroke-dashoffset:5;stroke-width:1}.ngx-charts .refline-label{font-size:9px}.ngx-charts .reference-area{fill:#000;fill-opacity:.05}.ngx-charts .gridline-path-dotted{fill:none;stroke:#ddd;stroke-dasharray:1,20;stroke-dashoffset:3;stroke-width:1}.ngx-charts .grid-panel rect{fill:none}.ngx-charts .grid-panel.odd rect{fill:rgba(0,0,0,.05)}"]
    }]
  }], null, {
    legend: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendTitle: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendPosition: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showGridLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimYAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    rotateXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxXAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxYAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    barPadding: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundDomains: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundEdges: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showDataLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    noBarWhenZero: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    xAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showXAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showYAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    schemeType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScaleMax: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScaleMin: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    dataLabelFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
      args: ['tooltipTemplate']
    }]
  });
})();

class BarHorizontal2DComponent extends BaseChartComponent {
  constructor() {
    super(...arguments);
    this.legend = false;
    this.legendTitle = 'Legend';
    this.legendPosition = 'right';
    this.tooltipDisabled = false;
    this.showGridLines = true;
    this.activeEntries = [];
    this.trimXAxisTicks = true;
    this.trimYAxisTicks = true;
    this.rotateXAxisTicks = true;
    this.maxXAxisTickLength = 16;
    this.maxYAxisTickLength = 16;
    this.groupPadding = 16;
    this.barPadding = 8;
    this.roundDomains = false;
    this.roundEdges = true;
    this.showDataLabel = false;
    this.noBarWhenZero = true;
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.margin = [10, 20, 10, 20];
    this.xAxisHeight = 0;
    this.yAxisWidth = 0;
    this.dataLabelMaxWidth = {
      negative: 0,
      positive: 0
    };
  }

  update() {
    super.update();

    if (!this.showDataLabel) {
      this.dataLabelMaxWidth = {
        negative: 0,
        positive: 0
      };
    }

    this.margin = [10, 20 + this.dataLabelMaxWidth.positive, 10, 20 + this.dataLabelMaxWidth.negative];
    this.dims = calculateViewDimensions({
      width: this.width,
      height: this.height,
      margins: this.margin,
      showXAxis: this.xAxis,
      showYAxis: this.yAxis,
      xAxisHeight: this.xAxisHeight,
      yAxisWidth: this.yAxisWidth,
      showXLabel: this.showXAxisLabel,
      showYLabel: this.showYAxisLabel,
      showLegend: this.legend,
      legendType: this.schemeType,
      legendPosition: this.legendPosition
    });
    this.formatDates();
    this.groupDomain = this.getGroupDomain();
    this.innerDomain = this.getInnerDomain();
    this.valuesDomain = this.getValueDomain();
    this.groupScale = this.getGroupScale();
    this.innerScale = this.getInnerScale();
    this.valueScale = this.getValueScale();
    this.setColors();
    this.legendOptions = this.getLegendOptions();
    this.transform = `translate(${this.dims.xOffset} , ${this.margin[0]})`;
  }

  getGroupScale() {
    const spacing = this.groupDomain.length / (this.dims.height / this.groupPadding + 1);
    return (0,d3_scale__WEBPACK_IMPORTED_MODULE_11__["default"])().rangeRound([0, this.dims.height]).paddingInner(spacing).paddingOuter(spacing / 2).domain(this.groupDomain);
  }

  getInnerScale() {
    const height = this.groupScale.bandwidth();
    const spacing = this.innerDomain.length / (height / this.barPadding + 1);
    return (0,d3_scale__WEBPACK_IMPORTED_MODULE_11__["default"])().rangeRound([0, height]).paddingInner(spacing).domain(this.innerDomain);
  }

  getValueScale() {
    const scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().range([0, this.dims.width]).domain(this.valuesDomain);
    return this.roundDomains ? scale.nice() : scale;
  }

  getGroupDomain() {
    const domain = [];

    for (const group of this.results) {
      if (!domain.includes(group.label)) {
        domain.push(group.label);
      }
    }

    return domain;
  }

  getInnerDomain() {
    const domain = [];

    for (const group of this.results) {
      for (const d of group.series) {
        if (!domain.includes(d.label)) {
          domain.push(d.label);
        }
      }
    }

    return domain;
  }

  getValueDomain() {
    const domain = [];

    for (const group of this.results) {
      for (const d of group.series) {
        if (!domain.includes(d.value)) {
          domain.push(d.value);
        }
      }
    }

    const min = Math.min(0, ...domain);
    const max = this.xScaleMax ? Math.max(this.xScaleMax, ...domain) : Math.max(0, ...domain);
    return [min, max];
  }

  groupTransform(group) {
    return `translate(0, ${this.groupScale(group.label)})`;
  }

  onClick(data, group) {
    if (group) {
      data.series = group.name;
    }

    this.select.emit(data);
  }

  trackBy(index, item) {
    return item.name;
  }

  setColors() {
    let domain;

    if (this.schemeType === 'ordinal') {
      domain = this.innerDomain;
    } else {
      domain = this.valuesDomain;
    }

    this.colors = new ColorHelper(this.scheme, this.schemeType, domain, this.customColors);
  }

  getLegendOptions() {
    const opts = {
      scaleType: this.schemeType,
      colors: undefined,
      domain: [],
      title: undefined,
      position: this.legendPosition
    };

    if (opts.scaleType === 'ordinal') {
      opts.domain = this.innerDomain;
      opts.colors = this.colors;
      opts.title = this.legendTitle;
    } else {
      opts.domain = this.valuesDomain;
      opts.colors = this.colors.scale;
    }

    return opts;
  }

  updateYAxisWidth({
    width
  }) {
    this.yAxisWidth = width;
    this.update();
  }

  updateXAxisHeight({
    height
  }) {
    this.xAxisHeight = height;
    this.update();
  }

  onDataLabelMaxWidthChanged(event, groupIndex) {
    if (event.size.negative) {
      this.dataLabelMaxWidth.negative = Math.max(this.dataLabelMaxWidth.negative, event.size.width);
    } else {
      this.dataLabelMaxWidth.positive = Math.max(this.dataLabelMaxWidth.positive, event.size.width);
    }

    if (groupIndex === this.results.length - 1) {
      setTimeout(() => this.update());
    }
  }

  onActivate(event, group, fromLegend = false) {
    const item = Object.assign({}, event);

    if (group) {
      item.series = group.name;
    }

    const items = this.results.map(g => g.series).flat().filter(i => {
      if (fromLegend) {
        return i.label === item.name;
      } else {
        return i.name === item.name && i.series === item.series;
      }
    });
    this.activeEntries = [...items];
    this.activate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

  onDeactivate(event, group, fromLegend = false) {
    const item = Object.assign({}, event);

    if (group) {
      item.series = group.name;
    }

    this.activeEntries = this.activeEntries.filter(i => {
      if (fromLegend) {
        return i.label !== item.name;
      } else {
        return !(i.name === item.name && i.series === item.series);
      }
    });
    this.deactivate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

}

BarHorizontal2DComponent.ɵfac = /*@__PURE__*/function () {
  let ɵBarHorizontal2DComponent_BaseFactory;
  return function BarHorizontal2DComponent_Factory(t) {
    return (ɵBarHorizontal2DComponent_BaseFactory || (ɵBarHorizontal2DComponent_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](BarHorizontal2DComponent)))(t || BarHorizontal2DComponent);
  };
}();

BarHorizontal2DComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: BarHorizontal2DComponent,
  selectors: [["ngx-charts-bar-horizontal-2d"]],
  contentQueries: function BarHorizontal2DComponent_ContentQueries(rf, ctx, dirIndex) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"](dirIndex, _c21, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.tooltipTemplate = _t.first);
    }
  },
  inputs: {
    legend: "legend",
    legendTitle: "legendTitle",
    legendPosition: "legendPosition",
    tooltipDisabled: "tooltipDisabled",
    showGridLines: "showGridLines",
    activeEntries: "activeEntries",
    trimXAxisTicks: "trimXAxisTicks",
    trimYAxisTicks: "trimYAxisTicks",
    rotateXAxisTicks: "rotateXAxisTicks",
    maxXAxisTickLength: "maxXAxisTickLength",
    maxYAxisTickLength: "maxYAxisTickLength",
    groupPadding: "groupPadding",
    barPadding: "barPadding",
    roundDomains: "roundDomains",
    roundEdges: "roundEdges",
    showDataLabel: "showDataLabel",
    noBarWhenZero: "noBarWhenZero",
    xAxis: "xAxis",
    yAxis: "yAxis",
    showXAxisLabel: "showXAxisLabel",
    showYAxisLabel: "showYAxisLabel",
    xAxisLabel: "xAxisLabel",
    yAxisLabel: "yAxisLabel",
    gradient: "gradient",
    schemeType: "schemeType",
    xAxisTickFormatting: "xAxisTickFormatting",
    yAxisTickFormatting: "yAxisTickFormatting",
    xAxisTicks: "xAxisTicks",
    yAxisTicks: "yAxisTicks",
    xScaleMax: "xScaleMax",
    dataLabelFormatting: "dataLabelFormatting"
  },
  outputs: {
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]],
  decls: 6,
  vars: 17,
  consts: [[3, "view", "showLegend", "legendOptions", "activeEntries", "animations", "legendLabelActivate", "legendLabelDeactivate", "legendLabelClick"], [1, "bar-chart", "chart"], ["ngx-charts-grid-panel-series", "", "orient", "horizontal", 3, "xScale", "yScale", "data", "dims"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "yAxisOffset", "dimensionsChanged", 4, "ngIf"], [4, "ngFor", "ngForOf", "ngForTrackBy"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "yAxisOffset", "dimensionsChanged"], ["ngx-charts-series-horizontal", "", 3, "xScale", "activeEntries", "yScale", "colors", "series", "dims", "gradient", "tooltipDisabled", "tooltipTemplate", "seriesName", "roundEdges", "animations", "showDataLabel", "dataLabelFormatting", "noBarWhenZero", "select", "activate", "deactivate", "dataLabelWidthChanged"]],
  template: function BarHorizontal2DComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "ngx-charts-chart", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("legendLabelActivate", function BarHorizontal2DComponent_Template_ngx_charts_chart_legendLabelActivate_0_listener($event) {
        return ctx.onActivate($event, undefined, true);
      })("legendLabelDeactivate", function BarHorizontal2DComponent_Template_ngx_charts_chart_legendLabelDeactivate_0_listener($event) {
        return ctx.onDeactivate($event, undefined, true);
      })("legendLabelClick", function BarHorizontal2DComponent_Template_ngx_charts_chart_legendLabelClick_0_listener($event) {
        return ctx.onClick($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "g", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](2, "g", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, BarHorizontal2DComponent__svg_g_3_Template, 1, 10, "g", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, BarHorizontal2DComponent__svg_g_4_Template, 1, 9, "g", 4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](5, BarHorizontal2DComponent__svg_g_5_Template, 2, 17, "g", 5);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("view", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](14, _c23, ctx.width, ctx.height))("showLegend", ctx.legend)("legendOptions", ctx.legendOptions)("activeEntries", ctx.activeEntries)("animations", ctx.animations);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx.valueScale)("yScale", ctx.groupScale)("data", ctx.results)("dims", ctx.dims);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.xAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.yAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.results)("ngForTrackBy", ctx.trackBy);
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, XAxisComponent, YAxisComponent, ChartComponent, GridPanelSeriesComponent, SeriesHorizontal];
  },
  styles: [_c24],
  encapsulation: 2,
  data: {
    animation: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 1,
      transform: '*'
    }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 0,
      transform: 'scale(0)'
    }))])])]
  },
  changeDetection: 0
});
BarHorizontal2DComponent.propDecorators = {
  legend: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendTitle: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendPosition: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showXAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showYAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showGridLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  schemeType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimYAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  rotateXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxXAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxYAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  groupPadding: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  barPadding: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundDomains: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundEdges: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScaleMax: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showDataLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  dataLabelFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  noBarWhenZero: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
    args: ['tooltipTemplate']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](BarHorizontal2DComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-charts-bar-horizontal-2d',
      template: `
    <ngx-charts-chart
      [view]="[width, height]"
      [showLegend]="legend"
      [legendOptions]="legendOptions"
      [activeEntries]="activeEntries"
      [animations]="animations"
      (legendLabelActivate)="onActivate($event, undefined, true)"
      (legendLabelDeactivate)="onDeactivate($event, undefined, true)"
      (legendLabelClick)="onClick($event)"
    >
      <svg:g [attr.transform]="transform" class="bar-chart chart">
        <svg:g
          ngx-charts-grid-panel-series
          [xScale]="valueScale"
          [yScale]="groupScale"
          [data]="results"
          [dims]="dims"
          orient="horizontal"
        ></svg:g>
        <svg:g
          ngx-charts-x-axis
          *ngIf="xAxis"
          [xScale]="valueScale"
          [dims]="dims"
          [showGridLines]="showGridLines"
          [showLabel]="showXAxisLabel"
          [labelText]="xAxisLabel"
          [trimTicks]="trimXAxisTicks"
          [rotateTicks]="rotateXAxisTicks"
          [maxTickLength]="maxXAxisTickLength"
          [tickFormatting]="xAxisTickFormatting"
          [ticks]="xAxisTicks"
          (dimensionsChanged)="updateXAxisHeight($event)"
        ></svg:g>
        <svg:g
          ngx-charts-y-axis
          *ngIf="yAxis"
          [yScale]="groupScale"
          [dims]="dims"
          [showLabel]="showYAxisLabel"
          [labelText]="yAxisLabel"
          [trimTicks]="trimYAxisTicks"
          [maxTickLength]="maxYAxisTickLength"
          [tickFormatting]="yAxisTickFormatting"
          [ticks]="yAxisTicks"
          [yAxisOffset]="dataLabelMaxWidth.negative"
          (dimensionsChanged)="updateYAxisWidth($event)"
        ></svg:g>
        <svg:g
          *ngFor="let group of results; let index = index; trackBy: trackBy"
          [@animationState]="'active'"
          [attr.transform]="groupTransform(group)"
        >
          <svg:g
            ngx-charts-series-horizontal
            [xScale]="valueScale"
            [activeEntries]="activeEntries"
            [yScale]="innerScale"
            [colors]="colors"
            [series]="group.series"
            [dims]="dims"
            [gradient]="gradient"
            [tooltipDisabled]="tooltipDisabled"
            [tooltipTemplate]="tooltipTemplate"
            [seriesName]="group.name"
            [roundEdges]="roundEdges"
            [animations]="animations"
            [showDataLabel]="showDataLabel"
            [dataLabelFormatting]="dataLabelFormatting"
            [noBarWhenZero]="noBarWhenZero"
            (select)="onClick($event, group)"
            (activate)="onActivate($event, group)"
            (deactivate)="onDeactivate($event, group)"
            (dataLabelWidthChanged)="onDataLabelMaxWidthChanged($event, index)"
          />
        </svg:g>
      </svg:g>
    </ngx-charts-chart>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      animations: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 1,
        transform: '*'
      }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 0,
        transform: 'scale(0)'
      }))])])],
      styles: [".ngx-charts{float:left;overflow:visible}.ngx-charts .arc,.ngx-charts .bar,.ngx-charts .circle{cursor:pointer}.ngx-charts .arc.active,.ngx-charts .arc:hover,.ngx-charts .bar.active,.ngx-charts .bar:hover,.ngx-charts .card.active,.ngx-charts .card:hover,.ngx-charts .cell.active,.ngx-charts .cell:hover{opacity:.8;transition:opacity .1s ease-in-out}.ngx-charts .arc:focus,.ngx-charts .bar:focus,.ngx-charts .card:focus,.ngx-charts .cell:focus{outline:none}.ngx-charts .arc.hidden,.ngx-charts .bar.hidden,.ngx-charts .card.hidden,.ngx-charts .cell.hidden{display:none}.ngx-charts g:focus{outline:none}.ngx-charts .area-series.inactive,.ngx-charts .line-series-range.inactive,.ngx-charts .line-series.inactive,.ngx-charts .polar-series-area.inactive,.ngx-charts .polar-series-path.inactive{opacity:.2;transition:opacity .1s ease-in-out}.ngx-charts .line-highlight{display:none}.ngx-charts .line-highlight.active{display:block}.ngx-charts .area{opacity:.6}.ngx-charts .circle:hover{cursor:pointer}.ngx-charts .label{font-size:12px;font-weight:400}.ngx-charts .tooltip-anchor{fill:#000}.ngx-charts .gridline-path{fill:none;stroke:#ddd;stroke-width:1}.ngx-charts .refline-path{stroke:#a8b2c7;stroke-dasharray:5;stroke-dashoffset:5;stroke-width:1}.ngx-charts .refline-label{font-size:9px}.ngx-charts .reference-area{fill:#000;fill-opacity:.05}.ngx-charts .gridline-path-dotted{fill:none;stroke:#ddd;stroke-dasharray:1,20;stroke-dashoffset:3;stroke-width:1}.ngx-charts .grid-panel rect{fill:none}.ngx-charts .grid-panel.odd rect{fill:rgba(0,0,0,.05)}"]
    }]
  }], null, {
    legend: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendTitle: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendPosition: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showGridLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimYAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    rotateXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxXAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxYAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    groupPadding: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    barPadding: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundDomains: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundEdges: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showDataLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    noBarWhenZero: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    xAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showXAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showYAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    schemeType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScaleMax: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    dataLabelFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
      args: ['tooltipTemplate']
    }]
  });
})();

class BarHorizontalNormalizedComponent extends BaseChartComponent {
  constructor() {
    super(...arguments);
    this.legend = false;
    this.legendTitle = 'Legend';
    this.legendPosition = 'right';
    this.tooltipDisabled = false;
    this.showGridLines = true;
    this.activeEntries = [];
    this.trimXAxisTicks = true;
    this.trimYAxisTicks = true;
    this.rotateXAxisTicks = true;
    this.maxXAxisTickLength = 16;
    this.maxYAxisTickLength = 16;
    this.barPadding = 8;
    this.roundDomains = false;
    this.noBarWhenZero = true;
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.margin = [10, 20, 10, 20];
    this.xAxisHeight = 0;
    this.yAxisWidth = 0;
  }

  update() {
    super.update();
    this.dims = calculateViewDimensions({
      width: this.width,
      height: this.height,
      margins: this.margin,
      showXAxis: this.xAxis,
      showYAxis: this.yAxis,
      xAxisHeight: this.xAxisHeight,
      yAxisWidth: this.yAxisWidth,
      showXLabel: this.showXAxisLabel,
      showYLabel: this.showYAxisLabel,
      showLegend: this.legend,
      legendType: this.schemeType,
      legendPosition: this.legendPosition
    });
    this.formatDates();
    this.groupDomain = this.getGroupDomain();
    this.innerDomain = this.getInnerDomain();
    this.valueDomain = this.getValueDomain();
    this.xScale = this.getXScale();
    this.yScale = this.getYScale();
    this.setColors();
    this.legendOptions = this.getLegendOptions();
    this.transform = `translate(${this.dims.xOffset} , ${this.margin[0]})`;
  }

  getGroupDomain() {
    const domain = [];

    for (const group of this.results) {
      if (!domain.includes(group.label)) {
        domain.push(group.label);
      }
    }

    return domain;
  }

  getInnerDomain() {
    const domain = [];

    for (const group of this.results) {
      for (const d of group.series) {
        if (!domain.includes(d.label)) {
          domain.push(d.label);
        }
      }
    }

    return domain;
  }

  getValueDomain() {
    return [0, 100];
  }

  getYScale() {
    const spacing = this.groupDomain.length / (this.dims.height / this.barPadding + 1);
    return (0,d3_scale__WEBPACK_IMPORTED_MODULE_11__["default"])().rangeRound([0, this.dims.height]).paddingInner(spacing).domain(this.groupDomain);
  }

  getXScale() {
    const scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().range([0, this.dims.width]).domain(this.valueDomain);
    return this.roundDomains ? scale.nice() : scale;
  }

  groupTransform(group) {
    return `translate(0, ${this.yScale(group.name)})`;
  }

  onClick(data, group) {
    if (group) {
      data.series = group.name;
    }

    this.select.emit(data);
  }

  trackBy(index, item) {
    return item.name;
  }

  setColors() {
    let domain;

    if (this.schemeType === 'ordinal') {
      domain = this.innerDomain;
    } else {
      domain = this.valueDomain;
    }

    this.colors = new ColorHelper(this.scheme, this.schemeType, domain, this.customColors);
  }

  getLegendOptions() {
    const opts = {
      scaleType: this.schemeType,
      colors: undefined,
      domain: [],
      title: undefined,
      position: this.legendPosition
    };

    if (opts.scaleType === 'ordinal') {
      opts.domain = this.innerDomain;
      opts.colors = this.colors;
      opts.title = this.legendTitle;
    } else {
      opts.domain = this.valueDomain;
      opts.colors = this.colors.scale;
    }

    return opts;
  }

  updateYAxisWidth({
    width
  }) {
    this.yAxisWidth = width;
    this.update();
  }

  updateXAxisHeight({
    height
  }) {
    this.xAxisHeight = height;
    this.update();
  }

  onActivate(event, group, fromLegend = false) {
    const item = Object.assign({}, event);

    if (group) {
      item.series = group.name;
    }

    const items = this.results.map(g => g.series).flat().filter(i => {
      if (fromLegend) {
        return i.label === item.name;
      } else {
        return i.name === item.name && i.series === item.series;
      }
    });
    this.activeEntries = [...items];
    this.activate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

  onDeactivate(event, group, fromLegend = false) {
    const item = Object.assign({}, event);

    if (group) {
      item.series = group.name;
    }

    this.activeEntries = this.activeEntries.filter(i => {
      if (fromLegend) {
        return i.label !== item.name;
      } else {
        return !(i.name === item.name && i.series === item.series);
      }
    });
    this.deactivate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

}

BarHorizontalNormalizedComponent.ɵfac = /*@__PURE__*/function () {
  let ɵBarHorizontalNormalizedComponent_BaseFactory;
  return function BarHorizontalNormalizedComponent_Factory(t) {
    return (ɵBarHorizontalNormalizedComponent_BaseFactory || (ɵBarHorizontalNormalizedComponent_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](BarHorizontalNormalizedComponent)))(t || BarHorizontalNormalizedComponent);
  };
}();

BarHorizontalNormalizedComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: BarHorizontalNormalizedComponent,
  selectors: [["ngx-charts-bar-horizontal-normalized"]],
  contentQueries: function BarHorizontalNormalizedComponent_ContentQueries(rf, ctx, dirIndex) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"](dirIndex, _c21, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.tooltipTemplate = _t.first);
    }
  },
  inputs: {
    legend: "legend",
    legendTitle: "legendTitle",
    legendPosition: "legendPosition",
    tooltipDisabled: "tooltipDisabled",
    showGridLines: "showGridLines",
    activeEntries: "activeEntries",
    trimXAxisTicks: "trimXAxisTicks",
    trimYAxisTicks: "trimYAxisTicks",
    rotateXAxisTicks: "rotateXAxisTicks",
    maxXAxisTickLength: "maxXAxisTickLength",
    maxYAxisTickLength: "maxYAxisTickLength",
    barPadding: "barPadding",
    roundDomains: "roundDomains",
    noBarWhenZero: "noBarWhenZero",
    xAxis: "xAxis",
    yAxis: "yAxis",
    showXAxisLabel: "showXAxisLabel",
    showYAxisLabel: "showYAxisLabel",
    xAxisLabel: "xAxisLabel",
    yAxisLabel: "yAxisLabel",
    gradient: "gradient",
    schemeType: "schemeType",
    xAxisTickFormatting: "xAxisTickFormatting",
    yAxisTickFormatting: "yAxisTickFormatting",
    xAxisTicks: "xAxisTicks",
    yAxisTicks: "yAxisTicks"
  },
  outputs: {
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]],
  decls: 5,
  vars: 13,
  consts: [[3, "view", "showLegend", "legendOptions", "activeEntries", "animations", "legendLabelActivate", "legendLabelDeactivate", "legendLabelClick"], [1, "bar-chart", "chart"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], [4, "ngFor", "ngForOf", "ngForTrackBy"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-series-horizontal", "", "type", "normalized", 3, "xScale", "yScale", "activeEntries", "colors", "series", "dims", "gradient", "tooltipDisabled", "tooltipTemplate", "seriesName", "animations", "noBarWhenZero", "select", "activate", "deactivate"]],
  template: function BarHorizontalNormalizedComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "ngx-charts-chart", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("legendLabelActivate", function BarHorizontalNormalizedComponent_Template_ngx_charts_chart_legendLabelActivate_0_listener($event) {
        return ctx.onActivate($event, undefined, true);
      })("legendLabelDeactivate", function BarHorizontalNormalizedComponent_Template_ngx_charts_chart_legendLabelDeactivate_0_listener($event) {
        return ctx.onDeactivate($event, undefined, true);
      })("legendLabelClick", function BarHorizontalNormalizedComponent_Template_ngx_charts_chart_legendLabelClick_0_listener($event) {
        return ctx.onClick($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "g", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, BarHorizontalNormalizedComponent__svg_g_2_Template, 1, 10, "g", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, BarHorizontalNormalizedComponent__svg_g_3_Template, 1, 8, "g", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, BarHorizontalNormalizedComponent__svg_g_4_Template, 2, 14, "g", 4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("view", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](10, _c23, ctx.width, ctx.height))("showLegend", ctx.legend)("legendOptions", ctx.legendOptions)("activeEntries", ctx.activeEntries)("animations", ctx.animations);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.xAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.yAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.results)("ngForTrackBy", ctx.trackBy);
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, XAxisComponent, YAxisComponent, ChartComponent, SeriesHorizontal];
  },
  styles: [_c24],
  encapsulation: 2,
  data: {
    animation: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 1,
      transform: '*'
    }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 0,
      transform: 'scale(0)'
    }))])])]
  },
  changeDetection: 0
});
BarHorizontalNormalizedComponent.propDecorators = {
  legend: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendTitle: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendPosition: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showXAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showYAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showGridLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  schemeType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimYAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  rotateXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxXAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxYAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  barPadding: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundDomains: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  noBarWhenZero: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
    args: ['tooltipTemplate']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](BarHorizontalNormalizedComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-charts-bar-horizontal-normalized',
      template: `
    <ngx-charts-chart
      [view]="[width, height]"
      [showLegend]="legend"
      [legendOptions]="legendOptions"
      [activeEntries]="activeEntries"
      [animations]="animations"
      (legendLabelActivate)="onActivate($event, undefined, true)"
      (legendLabelDeactivate)="onDeactivate($event, undefined, true)"
      (legendLabelClick)="onClick($event)"
    >
      <svg:g [attr.transform]="transform" class="bar-chart chart">
        <svg:g
          ngx-charts-x-axis
          *ngIf="xAxis"
          [xScale]="xScale"
          [dims]="dims"
          [showGridLines]="showGridLines"
          [showLabel]="showXAxisLabel"
          [labelText]="xAxisLabel"
          [trimTicks]="trimXAxisTicks"
          [rotateTicks]="rotateXAxisTicks"
          [maxTickLength]="maxXAxisTickLength"
          [tickFormatting]="xAxisTickFormatting"
          [ticks]="xAxisTicks"
          (dimensionsChanged)="updateXAxisHeight($event)"
        ></svg:g>
        <svg:g
          ngx-charts-y-axis
          *ngIf="yAxis"
          [yScale]="yScale"
          [dims]="dims"
          [showLabel]="showYAxisLabel"
          [labelText]="yAxisLabel"
          [trimTicks]="trimYAxisTicks"
          [maxTickLength]="maxYAxisTickLength"
          [tickFormatting]="yAxisTickFormatting"
          [ticks]="yAxisTicks"
          (dimensionsChanged)="updateYAxisWidth($event)"
        ></svg:g>
        <svg:g
          *ngFor="let group of results; trackBy: trackBy"
          [@animationState]="'active'"
          [attr.transform]="groupTransform(group)"
        >
          <svg:g
            ngx-charts-series-horizontal
            type="normalized"
            [xScale]="xScale"
            [yScale]="yScale"
            [activeEntries]="activeEntries"
            [colors]="colors"
            [series]="group.series"
            [dims]="dims"
            [gradient]="gradient"
            [tooltipDisabled]="tooltipDisabled"
            [tooltipTemplate]="tooltipTemplate"
            [seriesName]="group.name"
            [animations]="animations"
            (select)="onClick($event, group)"
            (activate)="onActivate($event, group)"
            (deactivate)="onDeactivate($event, group)"
            [noBarWhenZero]="noBarWhenZero"
          />
        </svg:g>
      </svg:g>
    </ngx-charts-chart>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      animations: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 1,
        transform: '*'
      }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 0,
        transform: 'scale(0)'
      }))])])],
      styles: [".ngx-charts{float:left;overflow:visible}.ngx-charts .arc,.ngx-charts .bar,.ngx-charts .circle{cursor:pointer}.ngx-charts .arc.active,.ngx-charts .arc:hover,.ngx-charts .bar.active,.ngx-charts .bar:hover,.ngx-charts .card.active,.ngx-charts .card:hover,.ngx-charts .cell.active,.ngx-charts .cell:hover{opacity:.8;transition:opacity .1s ease-in-out}.ngx-charts .arc:focus,.ngx-charts .bar:focus,.ngx-charts .card:focus,.ngx-charts .cell:focus{outline:none}.ngx-charts .arc.hidden,.ngx-charts .bar.hidden,.ngx-charts .card.hidden,.ngx-charts .cell.hidden{display:none}.ngx-charts g:focus{outline:none}.ngx-charts .area-series.inactive,.ngx-charts .line-series-range.inactive,.ngx-charts .line-series.inactive,.ngx-charts .polar-series-area.inactive,.ngx-charts .polar-series-path.inactive{opacity:.2;transition:opacity .1s ease-in-out}.ngx-charts .line-highlight{display:none}.ngx-charts .line-highlight.active{display:block}.ngx-charts .area{opacity:.6}.ngx-charts .circle:hover{cursor:pointer}.ngx-charts .label{font-size:12px;font-weight:400}.ngx-charts .tooltip-anchor{fill:#000}.ngx-charts .gridline-path{fill:none;stroke:#ddd;stroke-width:1}.ngx-charts .refline-path{stroke:#a8b2c7;stroke-dasharray:5;stroke-dashoffset:5;stroke-width:1}.ngx-charts .refline-label{font-size:9px}.ngx-charts .reference-area{fill:#000;fill-opacity:.05}.ngx-charts .gridline-path-dotted{fill:none;stroke:#ddd;stroke-dasharray:1,20;stroke-dashoffset:3;stroke-width:1}.ngx-charts .grid-panel rect{fill:none}.ngx-charts .grid-panel.odd rect{fill:rgba(0,0,0,.05)}"]
    }]
  }], null, {
    legend: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendTitle: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendPosition: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showGridLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimYAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    rotateXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxXAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxYAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    barPadding: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundDomains: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    noBarWhenZero: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    xAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showXAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showYAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    schemeType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
      args: ['tooltipTemplate']
    }]
  });
})();

class BarHorizontalStackedComponent extends BaseChartComponent {
  constructor() {
    super(...arguments);
    this.legend = false;
    this.legendTitle = 'Legend';
    this.legendPosition = 'right';
    this.tooltipDisabled = false;
    this.showGridLines = true;
    this.activeEntries = [];
    this.trimXAxisTicks = true;
    this.trimYAxisTicks = true;
    this.rotateXAxisTicks = true;
    this.maxXAxisTickLength = 16;
    this.maxYAxisTickLength = 16;
    this.barPadding = 8;
    this.roundDomains = false;
    this.showDataLabel = false;
    this.noBarWhenZero = true;
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.margin = [10, 20, 10, 20];
    this.xAxisHeight = 0;
    this.yAxisWidth = 0;
    this.dataLabelMaxWidth = {
      negative: 0,
      positive: 0
    };
  }

  update() {
    super.update();

    if (!this.showDataLabel) {
      this.dataLabelMaxWidth = {
        negative: 0,
        positive: 0
      };
    }

    this.margin = [10, 20 + this.dataLabelMaxWidth.positive, 10, 20 + this.dataLabelMaxWidth.negative];
    this.dims = calculateViewDimensions({
      width: this.width,
      height: this.height,
      margins: this.margin,
      showXAxis: this.xAxis,
      showYAxis: this.yAxis,
      xAxisHeight: this.xAxisHeight,
      yAxisWidth: this.yAxisWidth,
      showXLabel: this.showXAxisLabel,
      showYLabel: this.showYAxisLabel,
      showLegend: this.legend,
      legendType: this.schemeType,
      legendPosition: this.legendPosition
    });
    this.formatDates();
    this.groupDomain = this.getGroupDomain();
    this.innerDomain = this.getInnerDomain();
    this.valueDomain = this.getValueDomain();
    this.xScale = this.getXScale();
    this.yScale = this.getYScale();
    this.setColors();
    this.legendOptions = this.getLegendOptions();
    this.transform = `translate(${this.dims.xOffset} , ${this.margin[0]})`;
  }

  getGroupDomain() {
    const domain = [];

    for (const group of this.results) {
      if (!domain.includes(group.label)) {
        domain.push(group.label);
      }
    }

    return domain;
  }

  getInnerDomain() {
    const domain = [];

    for (const group of this.results) {
      for (const d of group.series) {
        if (!domain.includes(d.label)) {
          domain.push(d.label);
        }
      }
    }

    return domain;
  }

  getValueDomain() {
    const domain = [];
    let smallest = 0;
    let biggest = 0;

    for (const group of this.results) {
      let smallestSum = 0;
      let biggestSum = 0;

      for (const d of group.series) {
        if (d.value < 0) {
          smallestSum += d.value;
        } else {
          biggestSum += d.value;
        }

        smallest = d.value < smallest ? d.value : smallest;
        biggest = d.value > biggest ? d.value : biggest;
      }

      domain.push(smallestSum);
      domain.push(biggestSum);
    }

    domain.push(smallest);
    domain.push(biggest);
    const min = Math.min(0, ...domain);
    const max = this.xScaleMax ? Math.max(this.xScaleMax, ...domain) : Math.max(...domain);
    return [min, max];
  }

  getYScale() {
    const spacing = this.groupDomain.length / (this.dims.height / this.barPadding + 1);
    return (0,d3_scale__WEBPACK_IMPORTED_MODULE_11__["default"])().rangeRound([0, this.dims.height]).paddingInner(spacing).domain(this.groupDomain);
  }

  getXScale() {
    const scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().range([0, this.dims.width]).domain(this.valueDomain);
    return this.roundDomains ? scale.nice() : scale;
  }

  groupTransform(group) {
    return `translate(0, ${this.yScale(group.name)})`;
  }

  onClick(data, group) {
    if (group) {
      data.series = group.name;
    }

    this.select.emit(data);
  }

  trackBy(index, item) {
    return item.name;
  }

  setColors() {
    let domain;

    if (this.schemeType === 'ordinal') {
      domain = this.innerDomain;
    } else {
      domain = this.valueDomain;
    }

    this.colors = new ColorHelper(this.scheme, this.schemeType, domain, this.customColors);
  }

  getLegendOptions() {
    const opts = {
      scaleType: this.schemeType,
      colors: undefined,
      domain: [],
      title: undefined,
      position: this.legendPosition
    };

    if (opts.scaleType === 'ordinal') {
      opts.domain = this.innerDomain;
      opts.colors = this.colors;
      opts.title = this.legendTitle;
    } else {
      opts.domain = this.valueDomain;
      opts.colors = this.colors.scale;
    }

    return opts;
  }

  updateYAxisWidth({
    width
  }) {
    this.yAxisWidth = width;
    this.update();
  }

  updateXAxisHeight({
    height
  }) {
    this.xAxisHeight = height;
    this.update();
  }

  onDataLabelMaxWidthChanged(event, groupIndex) {
    if (event.size.negative) {
      this.dataLabelMaxWidth.negative = Math.max(this.dataLabelMaxWidth.negative, event.size.width);
    } else {
      this.dataLabelMaxWidth.positive = Math.max(this.dataLabelMaxWidth.positive, event.size.width);
    }

    if (groupIndex === this.results.length - 1) {
      setTimeout(() => this.update());
    }
  }

  onActivate(event, group, fromLegend = false) {
    const item = Object.assign({}, event);

    if (group) {
      item.series = group.name;
    }

    const items = this.results.map(g => g.series).flat().filter(i => {
      if (fromLegend) {
        return i.label === item.name;
      } else {
        return i.name === item.name && i.series === item.series;
      }
    });
    this.activeEntries = [...items];
    this.activate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

  onDeactivate(event, group, fromLegend = false) {
    const item = Object.assign({}, event);

    if (group) {
      item.series = group.name;
    }

    this.activeEntries = this.activeEntries.filter(i => {
      if (fromLegend) {
        return i.label !== item.name;
      } else {
        return !(i.name === item.name && i.series === item.series);
      }
    });
    this.deactivate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

}

BarHorizontalStackedComponent.ɵfac = /*@__PURE__*/function () {
  let ɵBarHorizontalStackedComponent_BaseFactory;
  return function BarHorizontalStackedComponent_Factory(t) {
    return (ɵBarHorizontalStackedComponent_BaseFactory || (ɵBarHorizontalStackedComponent_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](BarHorizontalStackedComponent)))(t || BarHorizontalStackedComponent);
  };
}();

BarHorizontalStackedComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: BarHorizontalStackedComponent,
  selectors: [["ngx-charts-bar-horizontal-stacked"]],
  contentQueries: function BarHorizontalStackedComponent_ContentQueries(rf, ctx, dirIndex) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"](dirIndex, _c21, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.tooltipTemplate = _t.first);
    }
  },
  inputs: {
    legend: "legend",
    legendTitle: "legendTitle",
    legendPosition: "legendPosition",
    tooltipDisabled: "tooltipDisabled",
    showGridLines: "showGridLines",
    activeEntries: "activeEntries",
    trimXAxisTicks: "trimXAxisTicks",
    trimYAxisTicks: "trimYAxisTicks",
    rotateXAxisTicks: "rotateXAxisTicks",
    maxXAxisTickLength: "maxXAxisTickLength",
    maxYAxisTickLength: "maxYAxisTickLength",
    barPadding: "barPadding",
    roundDomains: "roundDomains",
    showDataLabel: "showDataLabel",
    noBarWhenZero: "noBarWhenZero",
    xAxis: "xAxis",
    yAxis: "yAxis",
    showXAxisLabel: "showXAxisLabel",
    showYAxisLabel: "showYAxisLabel",
    xAxisLabel: "xAxisLabel",
    yAxisLabel: "yAxisLabel",
    gradient: "gradient",
    schemeType: "schemeType",
    xAxisTickFormatting: "xAxisTickFormatting",
    yAxisTickFormatting: "yAxisTickFormatting",
    xAxisTicks: "xAxisTicks",
    yAxisTicks: "yAxisTicks",
    xScaleMax: "xScaleMax",
    dataLabelFormatting: "dataLabelFormatting"
  },
  outputs: {
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]],
  decls: 5,
  vars: 13,
  consts: [[3, "view", "showLegend", "legendOptions", "activeEntries", "animations", "legendLabelActivate", "legendLabelDeactivate", "legendLabelClick"], [1, "bar-chart", "chart"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "yAxisOffset", "dimensionsChanged", 4, "ngIf"], [4, "ngFor", "ngForOf", "ngForTrackBy"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "yAxisOffset", "dimensionsChanged"], ["ngx-charts-series-horizontal", "", "type", "stacked", 3, "xScale", "yScale", "colors", "series", "activeEntries", "dims", "gradient", "tooltipDisabled", "tooltipTemplate", "seriesName", "animations", "showDataLabel", "dataLabelFormatting", "noBarWhenZero", "select", "activate", "deactivate", "dataLabelWidthChanged"]],
  template: function BarHorizontalStackedComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "ngx-charts-chart", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("legendLabelActivate", function BarHorizontalStackedComponent_Template_ngx_charts_chart_legendLabelActivate_0_listener($event) {
        return ctx.onActivate($event, undefined, true);
      })("legendLabelDeactivate", function BarHorizontalStackedComponent_Template_ngx_charts_chart_legendLabelDeactivate_0_listener($event) {
        return ctx.onDeactivate($event, undefined, true);
      })("legendLabelClick", function BarHorizontalStackedComponent_Template_ngx_charts_chart_legendLabelClick_0_listener($event) {
        return ctx.onClick($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "g", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, BarHorizontalStackedComponent__svg_g_2_Template, 1, 10, "g", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, BarHorizontalStackedComponent__svg_g_3_Template, 1, 9, "g", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, BarHorizontalStackedComponent__svg_g_4_Template, 2, 16, "g", 4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("view", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](10, _c23, ctx.width, ctx.height))("showLegend", ctx.legend)("legendOptions", ctx.legendOptions)("activeEntries", ctx.activeEntries)("animations", ctx.animations);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.xAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.yAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.results)("ngForTrackBy", ctx.trackBy);
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, XAxisComponent, YAxisComponent, ChartComponent, SeriesHorizontal];
  },
  styles: [_c24],
  encapsulation: 2,
  data: {
    animation: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 1,
      transform: '*'
    }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 0,
      transform: 'scale(0)'
    }))])])]
  },
  changeDetection: 0
});
BarHorizontalStackedComponent.propDecorators = {
  legend: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendTitle: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendPosition: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showXAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showYAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showGridLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  schemeType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimYAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  rotateXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxXAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxYAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  barPadding: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundDomains: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScaleMax: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showDataLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  dataLabelFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  noBarWhenZero: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
    args: ['tooltipTemplate']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](BarHorizontalStackedComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-charts-bar-horizontal-stacked',
      template: `
    <ngx-charts-chart
      [view]="[width, height]"
      [showLegend]="legend"
      [legendOptions]="legendOptions"
      [activeEntries]="activeEntries"
      [animations]="animations"
      (legendLabelActivate)="onActivate($event, undefined, true)"
      (legendLabelDeactivate)="onDeactivate($event, undefined, true)"
      (legendLabelClick)="onClick($event)"
    >
      <svg:g [attr.transform]="transform" class="bar-chart chart">
        <svg:g
          ngx-charts-x-axis
          *ngIf="xAxis"
          [xScale]="xScale"
          [dims]="dims"
          [showGridLines]="showGridLines"
          [showLabel]="showXAxisLabel"
          [labelText]="xAxisLabel"
          [trimTicks]="trimXAxisTicks"
          [rotateTicks]="rotateXAxisTicks"
          [maxTickLength]="maxXAxisTickLength"
          [tickFormatting]="xAxisTickFormatting"
          [ticks]="xAxisTicks"
          (dimensionsChanged)="updateXAxisHeight($event)"
        ></svg:g>
        <svg:g
          ngx-charts-y-axis
          *ngIf="yAxis"
          [yScale]="yScale"
          [dims]="dims"
          [showLabel]="showYAxisLabel"
          [labelText]="yAxisLabel"
          [trimTicks]="trimYAxisTicks"
          [maxTickLength]="maxYAxisTickLength"
          [tickFormatting]="yAxisTickFormatting"
          [ticks]="yAxisTicks"
          [yAxisOffset]="dataLabelMaxWidth.negative"
          (dimensionsChanged)="updateYAxisWidth($event)"
        ></svg:g>
        <svg:g
          *ngFor="let group of results; let index = index; trackBy: trackBy"
          [@animationState]="'active'"
          [attr.transform]="groupTransform(group)"
        >
          <svg:g
            ngx-charts-series-horizontal
            type="stacked"
            [xScale]="xScale"
            [yScale]="yScale"
            [colors]="colors"
            [series]="group.series"
            [activeEntries]="activeEntries"
            [dims]="dims"
            [gradient]="gradient"
            [tooltipDisabled]="tooltipDisabled"
            [tooltipTemplate]="tooltipTemplate"
            [seriesName]="group.name"
            [animations]="animations"
            [showDataLabel]="showDataLabel"
            [dataLabelFormatting]="dataLabelFormatting"
            [noBarWhenZero]="noBarWhenZero"
            (select)="onClick($event, group)"
            (activate)="onActivate($event, group)"
            (deactivate)="onDeactivate($event, group)"
            (dataLabelWidthChanged)="onDataLabelMaxWidthChanged($event, index)"
          />
        </svg:g>
      </svg:g>
    </ngx-charts-chart>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      animations: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 1,
        transform: '*'
      }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 0,
        transform: 'scale(0)'
      }))])])],
      styles: [".ngx-charts{float:left;overflow:visible}.ngx-charts .arc,.ngx-charts .bar,.ngx-charts .circle{cursor:pointer}.ngx-charts .arc.active,.ngx-charts .arc:hover,.ngx-charts .bar.active,.ngx-charts .bar:hover,.ngx-charts .card.active,.ngx-charts .card:hover,.ngx-charts .cell.active,.ngx-charts .cell:hover{opacity:.8;transition:opacity .1s ease-in-out}.ngx-charts .arc:focus,.ngx-charts .bar:focus,.ngx-charts .card:focus,.ngx-charts .cell:focus{outline:none}.ngx-charts .arc.hidden,.ngx-charts .bar.hidden,.ngx-charts .card.hidden,.ngx-charts .cell.hidden{display:none}.ngx-charts g:focus{outline:none}.ngx-charts .area-series.inactive,.ngx-charts .line-series-range.inactive,.ngx-charts .line-series.inactive,.ngx-charts .polar-series-area.inactive,.ngx-charts .polar-series-path.inactive{opacity:.2;transition:opacity .1s ease-in-out}.ngx-charts .line-highlight{display:none}.ngx-charts .line-highlight.active{display:block}.ngx-charts .area{opacity:.6}.ngx-charts .circle:hover{cursor:pointer}.ngx-charts .label{font-size:12px;font-weight:400}.ngx-charts .tooltip-anchor{fill:#000}.ngx-charts .gridline-path{fill:none;stroke:#ddd;stroke-width:1}.ngx-charts .refline-path{stroke:#a8b2c7;stroke-dasharray:5;stroke-dashoffset:5;stroke-width:1}.ngx-charts .refline-label{font-size:9px}.ngx-charts .reference-area{fill:#000;fill-opacity:.05}.ngx-charts .gridline-path-dotted{fill:none;stroke:#ddd;stroke-dasharray:1,20;stroke-dashoffset:3;stroke-width:1}.ngx-charts .grid-panel rect{fill:none}.ngx-charts .grid-panel.odd rect{fill:rgba(0,0,0,.05)}"]
    }]
  }], null, {
    legend: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendTitle: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendPosition: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showGridLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimYAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    rotateXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxXAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxYAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    barPadding: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundDomains: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showDataLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    noBarWhenZero: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    xAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showXAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showYAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    schemeType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScaleMax: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    dataLabelFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
      args: ['tooltipTemplate']
    }]
  });
})();

class BarVerticalComponent extends BaseChartComponent {
  constructor() {
    super(...arguments);
    this.legend = false;
    this.legendTitle = 'Legend';
    this.legendPosition = 'right';
    this.tooltipDisabled = false;
    this.showGridLines = true;
    this.activeEntries = [];
    this.trimXAxisTicks = true;
    this.trimYAxisTicks = true;
    this.rotateXAxisTicks = true;
    this.maxXAxisTickLength = 16;
    this.maxYAxisTickLength = 16;
    this.barPadding = 8;
    this.roundDomains = false;
    this.roundEdges = true;
    this.showDataLabel = false;
    this.noBarWhenZero = true;
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.margin = [10, 20, 10, 20];
    this.xAxisHeight = 0;
    this.yAxisWidth = 0;
    this.dataLabelMaxHeight = {
      negative: 0,
      positive: 0
    };
  }

  update() {
    super.update();

    if (!this.showDataLabel) {
      this.dataLabelMaxHeight = {
        negative: 0,
        positive: 0
      };
    }

    this.margin = [10 + this.dataLabelMaxHeight.positive, 20, 10 + this.dataLabelMaxHeight.negative, 20];
    this.dims = calculateViewDimensions({
      width: this.width,
      height: this.height,
      margins: this.margin,
      showXAxis: this.xAxis,
      showYAxis: this.yAxis,
      xAxisHeight: this.xAxisHeight,
      yAxisWidth: this.yAxisWidth,
      showXLabel: this.showXAxisLabel,
      showYLabel: this.showYAxisLabel,
      showLegend: this.legend,
      legendType: this.schemeType,
      legendPosition: this.legendPosition
    });
    this.formatDates();

    if (this.showDataLabel) {
      this.dims.height -= this.dataLabelMaxHeight.negative;
    }

    this.xScale = this.getXScale();
    this.yScale = this.getYScale();
    this.setColors();
    this.legendOptions = this.getLegendOptions();
    this.transform = `translate(${this.dims.xOffset} , ${this.margin[0] + this.dataLabelMaxHeight.negative})`;
  }

  getXScale() {
    this.xDomain = this.getXDomain();
    const spacing = this.xDomain.length / (this.dims.width / this.barPadding + 1);
    return (0,d3_scale__WEBPACK_IMPORTED_MODULE_11__["default"])().range([0, this.dims.width]).paddingInner(spacing).domain(this.xDomain);
  }

  getYScale() {
    this.yDomain = this.getYDomain();
    const scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().range([this.dims.height, 0]).domain(this.yDomain);
    return this.roundDomains ? scale.nice() : scale;
  }

  getXDomain() {
    return this.results.map(d => d.label);
  }

  getYDomain() {
    const values = this.results.map(d => d.value);
    let min = this.yScaleMin ? Math.min(this.yScaleMin, ...values) : Math.min(0, ...values);

    if (this.yAxisTicks && !this.yAxisTicks.some(isNaN)) {
      min = Math.min(min, ...this.yAxisTicks);
    }

    let max = this.yScaleMax ? Math.max(this.yScaleMax, ...values) : Math.max(0, ...values);

    if (this.yAxisTicks && !this.yAxisTicks.some(isNaN)) {
      max = Math.max(max, ...this.yAxisTicks);
    }

    return [min, max];
  }

  onClick(data) {
    this.select.emit(data);
  }

  setColors() {
    let domain;

    if (this.schemeType === 'ordinal') {
      domain = this.xDomain;
    } else {
      domain = this.yDomain;
    }

    this.colors = new ColorHelper(this.scheme, this.schemeType, domain, this.customColors);
  }

  getLegendOptions() {
    const opts = {
      scaleType: this.schemeType,
      colors: undefined,
      domain: [],
      title: undefined,
      position: this.legendPosition
    };

    if (opts.scaleType === 'ordinal') {
      opts.domain = this.xDomain;
      opts.colors = this.colors;
      opts.title = this.legendTitle;
    } else {
      opts.domain = this.yDomain;
      opts.colors = this.colors.scale;
    }

    return opts;
  }

  updateYAxisWidth({
    width
  }) {
    this.yAxisWidth = width;
    this.update();
  }

  updateXAxisHeight({
    height
  }) {
    this.xAxisHeight = height;
    this.update();
  }

  onDataLabelMaxHeightChanged(event) {
    if (event.size.negative) {
      this.dataLabelMaxHeight.negative = Math.max(this.dataLabelMaxHeight.negative, event.size.height);
    } else {
      this.dataLabelMaxHeight.positive = Math.max(this.dataLabelMaxHeight.positive, event.size.height);
    }

    if (event.index === this.results.length - 1) {
      setTimeout(() => this.update());
    }
  }

  onActivate(item, fromLegend = false) {
    item = this.results.find(d => {
      if (fromLegend) {
        return d.label === item.name;
      } else {
        return d.name === item.name;
      }
    });
    const idx = this.activeEntries.findIndex(d => {
      return d.name === item.name && d.value === item.value && d.series === item.series;
    });

    if (idx > -1) {
      return;
    }

    this.activeEntries = [item, ...this.activeEntries];
    this.activate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

  onDeactivate(item, fromLegend = false) {
    item = this.results.find(d => {
      if (fromLegend) {
        return d.label === item.name;
      } else {
        return d.name === item.name;
      }
    });
    const idx = this.activeEntries.findIndex(d => {
      return d.name === item.name && d.value === item.value && d.series === item.series;
    });
    this.activeEntries.splice(idx, 1);
    this.activeEntries = [...this.activeEntries];
    this.deactivate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

}

BarVerticalComponent.ɵfac = /*@__PURE__*/function () {
  let ɵBarVerticalComponent_BaseFactory;
  return function BarVerticalComponent_Factory(t) {
    return (ɵBarVerticalComponent_BaseFactory || (ɵBarVerticalComponent_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](BarVerticalComponent)))(t || BarVerticalComponent);
  };
}();

BarVerticalComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: BarVerticalComponent,
  selectors: [["ngx-charts-bar-vertical"]],
  contentQueries: function BarVerticalComponent_ContentQueries(rf, ctx, dirIndex) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"](dirIndex, _c21, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.tooltipTemplate = _t.first);
    }
  },
  inputs: {
    legend: "legend",
    legendTitle: "legendTitle",
    legendPosition: "legendPosition",
    tooltipDisabled: "tooltipDisabled",
    showGridLines: "showGridLines",
    activeEntries: "activeEntries",
    trimXAxisTicks: "trimXAxisTicks",
    trimYAxisTicks: "trimYAxisTicks",
    rotateXAxisTicks: "rotateXAxisTicks",
    maxXAxisTickLength: "maxXAxisTickLength",
    maxYAxisTickLength: "maxYAxisTickLength",
    barPadding: "barPadding",
    roundDomains: "roundDomains",
    roundEdges: "roundEdges",
    showDataLabel: "showDataLabel",
    noBarWhenZero: "noBarWhenZero",
    xAxis: "xAxis",
    yAxis: "yAxis",
    showXAxisLabel: "showXAxisLabel",
    showYAxisLabel: "showYAxisLabel",
    xAxisLabel: "xAxisLabel",
    yAxisLabel: "yAxisLabel",
    gradient: "gradient",
    schemeType: "schemeType",
    xAxisTickFormatting: "xAxisTickFormatting",
    yAxisTickFormatting: "yAxisTickFormatting",
    xAxisTicks: "xAxisTicks",
    yAxisTicks: "yAxisTicks",
    yScaleMax: "yScaleMax",
    yScaleMin: "yScaleMin",
    dataLabelFormatting: "dataLabelFormatting"
  },
  outputs: {
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]],
  decls: 5,
  vars: 25,
  consts: [[3, "view", "showLegend", "legendOptions", "activeEntries", "animations", "legendLabelClick", "legendLabelActivate", "legendLabelDeactivate"], [1, "bar-chart", "chart"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "xAxisOffset", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-series-vertical", "", 3, "xScale", "yScale", "colors", "series", "dims", "gradient", "tooltipDisabled", "tooltipTemplate", "showDataLabel", "dataLabelFormatting", "activeEntries", "roundEdges", "animations", "noBarWhenZero", "activate", "deactivate", "select", "dataLabelHeightChanged"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "xAxisOffset", "dimensionsChanged"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"]],
  template: function BarVerticalComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "ngx-charts-chart", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("legendLabelClick", function BarVerticalComponent_Template_ngx_charts_chart_legendLabelClick_0_listener($event) {
        return ctx.onClick($event);
      })("legendLabelActivate", function BarVerticalComponent_Template_ngx_charts_chart_legendLabelActivate_0_listener($event) {
        return ctx.onActivate($event, true);
      })("legendLabelDeactivate", function BarVerticalComponent_Template_ngx_charts_chart_legendLabelDeactivate_0_listener($event) {
        return ctx.onDeactivate($event, true);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "g", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, BarVerticalComponent__svg_g_2_Template, 1, 10, "g", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, BarVerticalComponent__svg_g_3_Template, 1, 9, "g", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "g", 4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("activate", function BarVerticalComponent_Template__svg_g_activate_4_listener($event) {
        return ctx.onActivate($event);
      })("deactivate", function BarVerticalComponent_Template__svg_g_deactivate_4_listener($event) {
        return ctx.onDeactivate($event);
      })("select", function BarVerticalComponent_Template__svg_g_select_4_listener($event) {
        return ctx.onClick($event);
      })("dataLabelHeightChanged", function BarVerticalComponent_Template__svg_g_dataLabelHeightChanged_4_listener($event) {
        return ctx.onDataLabelMaxHeightChanged($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("view", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](22, _c23, ctx.width, ctx.height))("showLegend", ctx.legend)("legendOptions", ctx.legendOptions)("activeEntries", ctx.activeEntries)("animations", ctx.animations);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.xAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.yAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx.xScale)("yScale", ctx.yScale)("colors", ctx.colors)("series", ctx.results)("dims", ctx.dims)("gradient", ctx.gradient)("tooltipDisabled", ctx.tooltipDisabled)("tooltipTemplate", ctx.tooltipTemplate)("showDataLabel", ctx.showDataLabel)("dataLabelFormatting", ctx.dataLabelFormatting)("activeEntries", ctx.activeEntries)("roundEdges", ctx.roundEdges)("animations", ctx.animations)("noBarWhenZero", ctx.noBarWhenZero);
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, XAxisComponent, YAxisComponent, ChartComponent, SeriesVerticalComponent];
  },
  styles: [_c24],
  encapsulation: 2,
  changeDetection: 0
});
BarVerticalComponent.propDecorators = {
  legend: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendTitle: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendPosition: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showXAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showYAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showGridLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  schemeType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimYAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  rotateXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxXAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxYAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  barPadding: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundDomains: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundEdges: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScaleMax: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScaleMin: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showDataLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  dataLabelFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  noBarWhenZero: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
    args: ['tooltipTemplate']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](BarVerticalComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-charts-bar-vertical',
      template: `
    <ngx-charts-chart
      [view]="[width, height]"
      [showLegend]="legend"
      [legendOptions]="legendOptions"
      [activeEntries]="activeEntries"
      [animations]="animations"
      (legendLabelClick)="onClick($event)"
      (legendLabelActivate)="onActivate($event, true)"
      (legendLabelDeactivate)="onDeactivate($event, true)"
    >
      <svg:g [attr.transform]="transform" class="bar-chart chart">
        <svg:g
          ngx-charts-x-axis
          *ngIf="xAxis"
          [xScale]="xScale"
          [dims]="dims"
          [showLabel]="showXAxisLabel"
          [labelText]="xAxisLabel"
          [trimTicks]="trimXAxisTicks"
          [rotateTicks]="rotateXAxisTicks"
          [maxTickLength]="maxXAxisTickLength"
          [tickFormatting]="xAxisTickFormatting"
          [ticks]="xAxisTicks"
          [xAxisOffset]="dataLabelMaxHeight.negative"
          (dimensionsChanged)="updateXAxisHeight($event)"
        ></svg:g>
        <svg:g
          ngx-charts-y-axis
          *ngIf="yAxis"
          [yScale]="yScale"
          [dims]="dims"
          [showGridLines]="showGridLines"
          [showLabel]="showYAxisLabel"
          [labelText]="yAxisLabel"
          [trimTicks]="trimYAxisTicks"
          [maxTickLength]="maxYAxisTickLength"
          [tickFormatting]="yAxisTickFormatting"
          [ticks]="yAxisTicks"
          (dimensionsChanged)="updateYAxisWidth($event)"
        ></svg:g>
        <svg:g
          ngx-charts-series-vertical
          [xScale]="xScale"
          [yScale]="yScale"
          [colors]="colors"
          [series]="results"
          [dims]="dims"
          [gradient]="gradient"
          [tooltipDisabled]="tooltipDisabled"
          [tooltipTemplate]="tooltipTemplate"
          [showDataLabel]="showDataLabel"
          [dataLabelFormatting]="dataLabelFormatting"
          [activeEntries]="activeEntries"
          [roundEdges]="roundEdges"
          [animations]="animations"
          [noBarWhenZero]="noBarWhenZero"
          (activate)="onActivate($event)"
          (deactivate)="onDeactivate($event)"
          (select)="onClick($event)"
          (dataLabelHeightChanged)="onDataLabelMaxHeightChanged($event)"
        ></svg:g>
      </svg:g>
    </ngx-charts-chart>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      styles: [".ngx-charts{float:left;overflow:visible}.ngx-charts .arc,.ngx-charts .bar,.ngx-charts .circle{cursor:pointer}.ngx-charts .arc.active,.ngx-charts .arc:hover,.ngx-charts .bar.active,.ngx-charts .bar:hover,.ngx-charts .card.active,.ngx-charts .card:hover,.ngx-charts .cell.active,.ngx-charts .cell:hover{opacity:.8;transition:opacity .1s ease-in-out}.ngx-charts .arc:focus,.ngx-charts .bar:focus,.ngx-charts .card:focus,.ngx-charts .cell:focus{outline:none}.ngx-charts .arc.hidden,.ngx-charts .bar.hidden,.ngx-charts .card.hidden,.ngx-charts .cell.hidden{display:none}.ngx-charts g:focus{outline:none}.ngx-charts .area-series.inactive,.ngx-charts .line-series-range.inactive,.ngx-charts .line-series.inactive,.ngx-charts .polar-series-area.inactive,.ngx-charts .polar-series-path.inactive{opacity:.2;transition:opacity .1s ease-in-out}.ngx-charts .line-highlight{display:none}.ngx-charts .line-highlight.active{display:block}.ngx-charts .area{opacity:.6}.ngx-charts .circle:hover{cursor:pointer}.ngx-charts .label{font-size:12px;font-weight:400}.ngx-charts .tooltip-anchor{fill:#000}.ngx-charts .gridline-path{fill:none;stroke:#ddd;stroke-width:1}.ngx-charts .refline-path{stroke:#a8b2c7;stroke-dasharray:5;stroke-dashoffset:5;stroke-width:1}.ngx-charts .refline-label{font-size:9px}.ngx-charts .reference-area{fill:#000;fill-opacity:.05}.ngx-charts .gridline-path-dotted{fill:none;stroke:#ddd;stroke-dasharray:1,20;stroke-dashoffset:3;stroke-width:1}.ngx-charts .grid-panel rect{fill:none}.ngx-charts .grid-panel.odd rect{fill:rgba(0,0,0,.05)}"]
    }]
  }], null, {
    legend: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendTitle: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendPosition: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showGridLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimYAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    rotateXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxXAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxYAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    barPadding: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundDomains: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundEdges: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showDataLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    noBarWhenZero: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    xAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showXAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showYAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    schemeType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScaleMax: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScaleMin: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    dataLabelFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
      args: ['tooltipTemplate']
    }]
  });
})();

class BarVertical2DComponent extends BaseChartComponent {
  constructor() {
    super(...arguments);
    this.legend = false;
    this.legendTitle = 'Legend';
    this.legendPosition = 'right';
    this.tooltipDisabled = false;
    this.scaleType = 'ordinal';
    this.showGridLines = true;
    this.activeEntries = [];
    this.trimXAxisTicks = true;
    this.trimYAxisTicks = true;
    this.rotateXAxisTicks = true;
    this.maxXAxisTickLength = 16;
    this.maxYAxisTickLength = 16;
    this.groupPadding = 16;
    this.barPadding = 8;
    this.roundDomains = false;
    this.roundEdges = true;
    this.showDataLabel = false;
    this.noBarWhenZero = true;
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.margin = [10, 20, 10, 20];
    this.xAxisHeight = 0;
    this.yAxisWidth = 0;
    this.dataLabelMaxHeight = {
      negative: 0,
      positive: 0
    };
  }

  update() {
    super.update();

    if (!this.showDataLabel) {
      this.dataLabelMaxHeight = {
        negative: 0,
        positive: 0
      };
    }

    this.margin = [10 + this.dataLabelMaxHeight.positive, 20, 10 + this.dataLabelMaxHeight.negative, 20];
    this.dims = calculateViewDimensions({
      width: this.width,
      height: this.height,
      margins: this.margin,
      showXAxis: this.xAxis,
      showYAxis: this.yAxis,
      xAxisHeight: this.xAxisHeight,
      yAxisWidth: this.yAxisWidth,
      showXLabel: this.showXAxisLabel,
      showYLabel: this.showYAxisLabel,
      showLegend: this.legend,
      legendType: this.schemeType,
      legendPosition: this.legendPosition
    });

    if (this.showDataLabel) {
      this.dims.height -= this.dataLabelMaxHeight.negative;
    }

    this.formatDates();
    this.groupDomain = this.getGroupDomain();
    this.innerDomain = this.getInnerDomain();
    this.valuesDomain = this.getValueDomain();
    this.groupScale = this.getGroupScale();
    this.innerScale = this.getInnerScale();
    this.valueScale = this.getValueScale();
    this.setColors();
    this.legendOptions = this.getLegendOptions();
    this.transform = `translate(${this.dims.xOffset} , ${this.margin[0] + this.dataLabelMaxHeight.negative})`;
  }

  onDataLabelMaxHeightChanged(event, groupIndex) {
    if (event.size.negative) {
      this.dataLabelMaxHeight.negative = Math.max(this.dataLabelMaxHeight.negative, event.size.height);
    } else {
      this.dataLabelMaxHeight.positive = Math.max(this.dataLabelMaxHeight.positive, event.size.height);
    }

    if (groupIndex === this.results.length - 1) {
      setTimeout(() => this.update());
    }
  }

  getGroupScale() {
    const spacing = this.groupDomain.length / (this.dims.height / this.groupPadding + 1);
    return (0,d3_scale__WEBPACK_IMPORTED_MODULE_11__["default"])().rangeRound([0, this.dims.width]).paddingInner(spacing).paddingOuter(spacing / 2).domain(this.groupDomain);
  }

  getInnerScale() {
    const width = this.groupScale.bandwidth();
    const spacing = this.innerDomain.length / (width / this.barPadding + 1);
    return (0,d3_scale__WEBPACK_IMPORTED_MODULE_11__["default"])().rangeRound([0, width]).paddingInner(spacing).domain(this.innerDomain);
  }

  getValueScale() {
    const scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().range([this.dims.height, 0]).domain(this.valuesDomain);
    return this.roundDomains ? scale.nice() : scale;
  }

  getGroupDomain() {
    const domain = [];

    for (const group of this.results) {
      if (!domain.includes(group.label)) {
        domain.push(group.label);
      }
    }

    return domain;
  }

  getInnerDomain() {
    const domain = [];

    for (const group of this.results) {
      for (const d of group.series) {
        if (!domain.includes(d.label)) {
          domain.push(d.label);
        }
      }
    }

    return domain;
  }

  getValueDomain() {
    const domain = [];

    for (const group of this.results) {
      for (const d of group.series) {
        if (!domain.includes(d.value)) {
          domain.push(d.value);
        }
      }
    }

    const min = Math.min(0, ...domain);
    const max = this.yScaleMax ? Math.max(this.yScaleMax, ...domain) : Math.max(0, ...domain);
    return [min, max];
  }

  groupTransform(group) {
    return `translate(${this.groupScale(group.label)}, 0)`;
  }

  onClick(data, group) {
    if (group) {
      data.series = group.name;
    }

    this.select.emit(data);
  }

  trackBy(index, item) {
    return item.name;
  }

  setColors() {
    let domain;

    if (this.schemeType === 'ordinal') {
      domain = this.innerDomain;
    } else {
      domain = this.valuesDomain;
    }

    this.colors = new ColorHelper(this.scheme, this.schemeType, domain, this.customColors);
  }

  getLegendOptions() {
    const opts = {
      scaleType: this.schemeType,
      colors: undefined,
      domain: [],
      title: undefined,
      position: this.legendPosition
    };

    if (opts.scaleType === 'ordinal') {
      opts.domain = this.innerDomain;
      opts.colors = this.colors;
      opts.title = this.legendTitle;
    } else {
      opts.domain = this.valuesDomain;
      opts.colors = this.colors.scale;
    }

    return opts;
  }

  updateYAxisWidth({
    width
  }) {
    this.yAxisWidth = width;
    this.update();
  }

  updateXAxisHeight({
    height
  }) {
    this.xAxisHeight = height;
    this.update();
  }

  onActivate(event, group, fromLegend = false) {
    const item = Object.assign({}, event);

    if (group) {
      item.series = group.name;
    }

    const items = this.results.map(g => g.series).flat().filter(i => {
      if (fromLegend) {
        return i.label === item.name;
      } else {
        return i.name === item.name && i.series === item.series;
      }
    });
    this.activeEntries = [...items];
    this.activate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

  onDeactivate(event, group, fromLegend = false) {
    const item = Object.assign({}, event);

    if (group) {
      item.series = group.name;
    }

    this.activeEntries = this.activeEntries.filter(i => {
      if (fromLegend) {
        return i.label !== item.name;
      } else {
        return !(i.name === item.name && i.series === item.series);
      }
    });
    this.deactivate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

}

BarVertical2DComponent.ɵfac = /*@__PURE__*/function () {
  let ɵBarVertical2DComponent_BaseFactory;
  return function BarVertical2DComponent_Factory(t) {
    return (ɵBarVertical2DComponent_BaseFactory || (ɵBarVertical2DComponent_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](BarVertical2DComponent)))(t || BarVertical2DComponent);
  };
}();

BarVertical2DComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: BarVertical2DComponent,
  selectors: [["ngx-charts-bar-vertical-2d"]],
  contentQueries: function BarVertical2DComponent_ContentQueries(rf, ctx, dirIndex) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"](dirIndex, _c21, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.tooltipTemplate = _t.first);
    }
  },
  inputs: {
    legend: "legend",
    legendTitle: "legendTitle",
    legendPosition: "legendPosition",
    tooltipDisabled: "tooltipDisabled",
    scaleType: "scaleType",
    showGridLines: "showGridLines",
    activeEntries: "activeEntries",
    trimXAxisTicks: "trimXAxisTicks",
    trimYAxisTicks: "trimYAxisTicks",
    rotateXAxisTicks: "rotateXAxisTicks",
    maxXAxisTickLength: "maxXAxisTickLength",
    maxYAxisTickLength: "maxYAxisTickLength",
    groupPadding: "groupPadding",
    barPadding: "barPadding",
    roundDomains: "roundDomains",
    roundEdges: "roundEdges",
    showDataLabel: "showDataLabel",
    noBarWhenZero: "noBarWhenZero",
    xAxis: "xAxis",
    yAxis: "yAxis",
    showXAxisLabel: "showXAxisLabel",
    showYAxisLabel: "showYAxisLabel",
    xAxisLabel: "xAxisLabel",
    yAxisLabel: "yAxisLabel",
    gradient: "gradient",
    schemeType: "schemeType",
    xAxisTickFormatting: "xAxisTickFormatting",
    yAxisTickFormatting: "yAxisTickFormatting",
    xAxisTicks: "xAxisTicks",
    yAxisTicks: "yAxisTicks",
    yScaleMax: "yScaleMax",
    dataLabelFormatting: "dataLabelFormatting"
  },
  outputs: {
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]],
  decls: 6,
  vars: 17,
  consts: [[3, "view", "showLegend", "legendOptions", "activeEntries", "animations", "legendLabelActivate", "legendLabelDeactivate", "legendLabelClick"], [1, "bar-chart", "chart"], ["ngx-charts-grid-panel-series", "", "orient", "vertical", 3, "xScale", "yScale", "data", "dims"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "xAxisOffset", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-series-vertical", "", 3, "activeEntries", "xScale", "yScale", "colors", "series", "dims", "gradient", "tooltipDisabled", "tooltipTemplate", "showDataLabel", "dataLabelFormatting", "seriesName", "roundEdges", "animations", "noBarWhenZero", "select", "activate", "deactivate", "dataLabelHeightChanged", 4, "ngFor", "ngForOf", "ngForTrackBy"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "xAxisOffset", "dimensionsChanged"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-series-vertical", "", 3, "activeEntries", "xScale", "yScale", "colors", "series", "dims", "gradient", "tooltipDisabled", "tooltipTemplate", "showDataLabel", "dataLabelFormatting", "seriesName", "roundEdges", "animations", "noBarWhenZero", "select", "activate", "deactivate", "dataLabelHeightChanged"]],
  template: function BarVertical2DComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "ngx-charts-chart", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("legendLabelActivate", function BarVertical2DComponent_Template_ngx_charts_chart_legendLabelActivate_0_listener($event) {
        return ctx.onActivate($event, undefined, true);
      })("legendLabelDeactivate", function BarVertical2DComponent_Template_ngx_charts_chart_legendLabelDeactivate_0_listener($event) {
        return ctx.onDeactivate($event, undefined, true);
      })("legendLabelClick", function BarVertical2DComponent_Template_ngx_charts_chart_legendLabelClick_0_listener($event) {
        return ctx.onClick($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "g", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](2, "g", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, BarVertical2DComponent__svg_g_3_Template, 1, 10, "g", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, BarVertical2DComponent__svg_g_4_Template, 1, 9, "g", 4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](5, BarVertical2DComponent__svg_g_5_Template, 1, 17, "g", 5);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("view", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](14, _c23, ctx.width, ctx.height))("showLegend", ctx.legend)("legendOptions", ctx.legendOptions)("activeEntries", ctx.activeEntries)("animations", ctx.animations);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("xScale", ctx.groupScale)("yScale", ctx.valueScale)("data", ctx.results)("dims", ctx.dims);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.xAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.yAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.results)("ngForTrackBy", ctx.trackBy);
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, XAxisComponent, YAxisComponent, ChartComponent, GridPanelSeriesComponent, SeriesVerticalComponent];
  },
  styles: [_c24],
  encapsulation: 2,
  data: {
    animation: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 1,
      transform: '*'
    }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 0,
      transform: 'scale(0)'
    }))])])]
  },
  changeDetection: 0
});
BarVertical2DComponent.propDecorators = {
  legend: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendTitle: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendPosition: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showXAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showYAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  scaleType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showGridLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  schemeType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimYAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  rotateXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxXAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxYAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  groupPadding: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  barPadding: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundDomains: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundEdges: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScaleMax: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showDataLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  dataLabelFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  noBarWhenZero: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
    args: ['tooltipTemplate']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](BarVertical2DComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-charts-bar-vertical-2d',
      template: `
    <ngx-charts-chart
      [view]="[width, height]"
      [showLegend]="legend"
      [legendOptions]="legendOptions"
      [activeEntries]="activeEntries"
      [animations]="animations"
      (legendLabelActivate)="onActivate($event, undefined, true)"
      (legendLabelDeactivate)="onDeactivate($event, undefined, true)"
      (legendLabelClick)="onClick($event)"
    >
      <svg:g [attr.transform]="transform" class="bar-chart chart">
        <svg:g
          ngx-charts-grid-panel-series
          [xScale]="groupScale"
          [yScale]="valueScale"
          [data]="results"
          [dims]="dims"
          orient="vertical"
        ></svg:g>
        <svg:g
          ngx-charts-x-axis
          *ngIf="xAxis"
          [xScale]="groupScale"
          [dims]="dims"
          [showLabel]="showXAxisLabel"
          [labelText]="xAxisLabel"
          [trimTicks]="trimXAxisTicks"
          [rotateTicks]="rotateXAxisTicks"
          [maxTickLength]="maxXAxisTickLength"
          [tickFormatting]="xAxisTickFormatting"
          [ticks]="xAxisTicks"
          [xAxisOffset]="dataLabelMaxHeight.negative"
          (dimensionsChanged)="updateXAxisHeight($event)"
        ></svg:g>
        <svg:g
          ngx-charts-y-axis
          *ngIf="yAxis"
          [yScale]="valueScale"
          [dims]="dims"
          [showGridLines]="showGridLines"
          [showLabel]="showYAxisLabel"
          [labelText]="yAxisLabel"
          [trimTicks]="trimYAxisTicks"
          [maxTickLength]="maxYAxisTickLength"
          [tickFormatting]="yAxisTickFormatting"
          [ticks]="yAxisTicks"
          (dimensionsChanged)="updateYAxisWidth($event)"
        ></svg:g>
        <svg:g
          ngx-charts-series-vertical
          *ngFor="let group of results; let index = index; trackBy: trackBy"
          [@animationState]="'active'"
          [attr.transform]="groupTransform(group)"
          [activeEntries]="activeEntries"
          [xScale]="innerScale"
          [yScale]="valueScale"
          [colors]="colors"
          [series]="group.series"
          [dims]="dims"
          [gradient]="gradient"
          [tooltipDisabled]="tooltipDisabled"
          [tooltipTemplate]="tooltipTemplate"
          [showDataLabel]="showDataLabel"
          [dataLabelFormatting]="dataLabelFormatting"
          [seriesName]="group.name"
          [roundEdges]="roundEdges"
          [animations]="animations"
          [noBarWhenZero]="noBarWhenZero"
          (select)="onClick($event, group)"
          (activate)="onActivate($event, group)"
          (deactivate)="onDeactivate($event, group)"
          (dataLabelHeightChanged)="onDataLabelMaxHeightChanged($event, index)"
        />
      </svg:g>
    </ngx-charts-chart>
  `,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      animations: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 1,
        transform: '*'
      }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 0,
        transform: 'scale(0)'
      }))])])],
      styles: [".ngx-charts{float:left;overflow:visible}.ngx-charts .arc,.ngx-charts .bar,.ngx-charts .circle{cursor:pointer}.ngx-charts .arc.active,.ngx-charts .arc:hover,.ngx-charts .bar.active,.ngx-charts .bar:hover,.ngx-charts .card.active,.ngx-charts .card:hover,.ngx-charts .cell.active,.ngx-charts .cell:hover{opacity:.8;transition:opacity .1s ease-in-out}.ngx-charts .arc:focus,.ngx-charts .bar:focus,.ngx-charts .card:focus,.ngx-charts .cell:focus{outline:none}.ngx-charts .arc.hidden,.ngx-charts .bar.hidden,.ngx-charts .card.hidden,.ngx-charts .cell.hidden{display:none}.ngx-charts g:focus{outline:none}.ngx-charts .area-series.inactive,.ngx-charts .line-series-range.inactive,.ngx-charts .line-series.inactive,.ngx-charts .polar-series-area.inactive,.ngx-charts .polar-series-path.inactive{opacity:.2;transition:opacity .1s ease-in-out}.ngx-charts .line-highlight{display:none}.ngx-charts .line-highlight.active{display:block}.ngx-charts .area{opacity:.6}.ngx-charts .circle:hover{cursor:pointer}.ngx-charts .label{font-size:12px;font-weight:400}.ngx-charts .tooltip-anchor{fill:#000}.ngx-charts .gridline-path{fill:none;stroke:#ddd;stroke-width:1}.ngx-charts .refline-path{stroke:#a8b2c7;stroke-dasharray:5;stroke-dashoffset:5;stroke-width:1}.ngx-charts .refline-label{font-size:9px}.ngx-charts .reference-area{fill:#000;fill-opacity:.05}.ngx-charts .gridline-path-dotted{fill:none;stroke:#ddd;stroke-dasharray:1,20;stroke-dashoffset:3;stroke-width:1}.ngx-charts .grid-panel rect{fill:none}.ngx-charts .grid-panel.odd rect{fill:rgba(0,0,0,.05)}"]
    }]
  }], null, {
    legend: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendTitle: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendPosition: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    scaleType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showGridLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimYAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    rotateXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxXAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxYAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    groupPadding: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    barPadding: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundDomains: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundEdges: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showDataLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    noBarWhenZero: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    xAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showXAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showYAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    schemeType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScaleMax: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    dataLabelFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
      args: ['tooltipTemplate']
    }]
  });
})();

class BarVerticalNormalizedComponent extends BaseChartComponent {
  constructor() {
    super(...arguments);
    this.legend = false;
    this.legendTitle = 'Legend';
    this.legendPosition = 'right';
    this.tooltipDisabled = false;
    this.showGridLines = true;
    this.activeEntries = [];
    this.trimXAxisTicks = true;
    this.trimYAxisTicks = true;
    this.rotateXAxisTicks = true;
    this.maxXAxisTickLength = 16;
    this.maxYAxisTickLength = 16;
    this.barPadding = 8;
    this.roundDomains = false;
    this.noBarWhenZero = true;
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.margin = [10, 20, 10, 20];
    this.xAxisHeight = 0;
    this.yAxisWidth = 0;
  }

  update() {
    super.update();
    this.dims = calculateViewDimensions({
      width: this.width,
      height: this.height,
      margins: this.margin,
      showXAxis: this.xAxis,
      showYAxis: this.yAxis,
      xAxisHeight: this.xAxisHeight,
      yAxisWidth: this.yAxisWidth,
      showXLabel: this.showXAxisLabel,
      showYLabel: this.showYAxisLabel,
      showLegend: this.legend,
      legendType: this.schemeType,
      legendPosition: this.legendPosition
    });
    this.formatDates();
    this.groupDomain = this.getGroupDomain();
    this.innerDomain = this.getInnerDomain();
    this.valueDomain = this.getValueDomain();
    this.xScale = this.getXScale();
    this.yScale = this.getYScale();
    this.setColors();
    this.legendOptions = this.getLegendOptions();
    this.transform = `translate(${this.dims.xOffset} , ${this.margin[0]})`;
  }

  getGroupDomain() {
    const domain = [];

    for (const group of this.results) {
      if (!domain.includes(group.label)) {
        domain.push(group.label);
      }
    }

    return domain;
  }

  getInnerDomain() {
    const domain = [];

    for (const group of this.results) {
      for (const d of group.series) {
        if (!domain.includes(d.label)) {
          domain.push(d.label);
        }
      }
    }

    return domain;
  }

  getValueDomain() {
    return [0, 100];
  }

  getXScale() {
    const spacing = this.groupDomain.length / (this.dims.width / this.barPadding + 1);
    return (0,d3_scale__WEBPACK_IMPORTED_MODULE_11__["default"])().rangeRound([0, this.dims.width]).paddingInner(spacing).domain(this.groupDomain);
  }

  getYScale() {
    const scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().range([this.dims.height, 0]).domain(this.valueDomain);
    return this.roundDomains ? scale.nice() : scale;
  }

  groupTransform(group) {
    return `translate(${this.xScale(group.name)}, 0)`;
  }

  onClick(data, group) {
    if (group) {
      data.series = group.name;
    }

    this.select.emit(data);
  }

  trackBy(index, item) {
    return item.name;
  }

  setColors() {
    let domain;

    if (this.schemeType === 'ordinal') {
      domain = this.innerDomain;
    } else {
      domain = this.valueDomain;
    }

    this.colors = new ColorHelper(this.scheme, this.schemeType, domain, this.customColors);
  }

  getLegendOptions() {
    const opts = {
      scaleType: this.schemeType,
      colors: undefined,
      domain: [],
      title: undefined,
      position: this.legendPosition
    };

    if (opts.scaleType === 'ordinal') {
      opts.domain = this.innerDomain;
      opts.colors = this.colors;
      opts.title = this.legendTitle;
    } else {
      opts.domain = this.valueDomain;
      opts.colors = this.colors.scale;
    }

    return opts;
  }

  updateYAxisWidth({
    width
  }) {
    this.yAxisWidth = width;
    this.update();
  }

  updateXAxisHeight({
    height
  }) {
    this.xAxisHeight = height;
    this.update();
  }

  onActivate(event, group, fromLegend = false) {
    const item = Object.assign({}, event);

    if (group) {
      item.series = group.name;
    }

    const items = this.results.map(g => g.series).flat().filter(i => {
      if (fromLegend) {
        return i.label === item.name;
      } else {
        return i.name === item.name && i.series === item.series;
      }
    });
    this.activeEntries = [...items];
    this.activate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

  onDeactivate(event, group, fromLegend = false) {
    const item = Object.assign({}, event);

    if (group) {
      item.series = group.name;
    }

    this.activeEntries = this.activeEntries.filter(i => {
      if (fromLegend) {
        return i.label !== item.name;
      } else {
        return !(i.name === item.name && i.series === item.series);
      }
    });
    this.deactivate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

}

BarVerticalNormalizedComponent.ɵfac = /*@__PURE__*/function () {
  let ɵBarVerticalNormalizedComponent_BaseFactory;
  return function BarVerticalNormalizedComponent_Factory(t) {
    return (ɵBarVerticalNormalizedComponent_BaseFactory || (ɵBarVerticalNormalizedComponent_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](BarVerticalNormalizedComponent)))(t || BarVerticalNormalizedComponent);
  };
}();

BarVerticalNormalizedComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: BarVerticalNormalizedComponent,
  selectors: [["ngx-charts-bar-vertical-normalized"]],
  contentQueries: function BarVerticalNormalizedComponent_ContentQueries(rf, ctx, dirIndex) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"](dirIndex, _c21, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.tooltipTemplate = _t.first);
    }
  },
  inputs: {
    legend: "legend",
    legendTitle: "legendTitle",
    legendPosition: "legendPosition",
    tooltipDisabled: "tooltipDisabled",
    showGridLines: "showGridLines",
    activeEntries: "activeEntries",
    trimXAxisTicks: "trimXAxisTicks",
    trimYAxisTicks: "trimYAxisTicks",
    rotateXAxisTicks: "rotateXAxisTicks",
    maxXAxisTickLength: "maxXAxisTickLength",
    maxYAxisTickLength: "maxYAxisTickLength",
    barPadding: "barPadding",
    roundDomains: "roundDomains",
    noBarWhenZero: "noBarWhenZero",
    xAxis: "xAxis",
    yAxis: "yAxis",
    showXAxisLabel: "showXAxisLabel",
    showYAxisLabel: "showYAxisLabel",
    xAxisLabel: "xAxisLabel",
    yAxisLabel: "yAxisLabel",
    gradient: "gradient",
    schemeType: "schemeType",
    xAxisTickFormatting: "xAxisTickFormatting",
    yAxisTickFormatting: "yAxisTickFormatting",
    xAxisTicks: "xAxisTicks",
    yAxisTicks: "yAxisTicks"
  },
  outputs: {
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]],
  decls: 5,
  vars: 13,
  consts: [[3, "view", "showLegend", "legendOptions", "activeEntries", "animations", "legendLabelActivate", "legendLabelDeactivate", "legendLabelClick"], [1, "bar-chart", "chart"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], [4, "ngFor", "ngForOf", "ngForTrackBy"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-series-vertical", "", "type", "normalized", 3, "xScale", "yScale", "activeEntries", "colors", "series", "dims", "gradient", "tooltipDisabled", "tooltipTemplate", "seriesName", "animations", "noBarWhenZero", "select", "activate", "deactivate"]],
  template: function BarVerticalNormalizedComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "ngx-charts-chart", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("legendLabelActivate", function BarVerticalNormalizedComponent_Template_ngx_charts_chart_legendLabelActivate_0_listener($event) {
        return ctx.onActivate($event, undefined, true);
      })("legendLabelDeactivate", function BarVerticalNormalizedComponent_Template_ngx_charts_chart_legendLabelDeactivate_0_listener($event) {
        return ctx.onDeactivate($event, undefined, true);
      })("legendLabelClick", function BarVerticalNormalizedComponent_Template_ngx_charts_chart_legendLabelClick_0_listener($event) {
        return ctx.onClick($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "g", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, BarVerticalNormalizedComponent__svg_g_2_Template, 1, 9, "g", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, BarVerticalNormalizedComponent__svg_g_3_Template, 1, 9, "g", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, BarVerticalNormalizedComponent__svg_g_4_Template, 2, 14, "g", 4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("view", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](10, _c23, ctx.width, ctx.height))("showLegend", ctx.legend)("legendOptions", ctx.legendOptions)("activeEntries", ctx.activeEntries)("animations", ctx.animations);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.xAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.yAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.results)("ngForTrackBy", ctx.trackBy);
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, XAxisComponent, YAxisComponent, ChartComponent, SeriesVerticalComponent];
  },
  styles: [_c24],
  encapsulation: 2,
  data: {
    animation: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 1,
      transform: '*'
    }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 0,
      transform: 'scale(0)'
    }))])])]
  },
  changeDetection: 0
});
BarVerticalNormalizedComponent.propDecorators = {
  legend: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendTitle: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendPosition: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showXAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showYAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showGridLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  schemeType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimYAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  rotateXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxXAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxYAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  barPadding: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundDomains: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  noBarWhenZero: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
    args: ['tooltipTemplate']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](BarVerticalNormalizedComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-charts-bar-vertical-normalized',
      template: `
    <ngx-charts-chart
      [view]="[width, height]"
      [showLegend]="legend"
      [legendOptions]="legendOptions"
      [activeEntries]="activeEntries"
      [animations]="animations"
      (legendLabelActivate)="onActivate($event, undefined, true)"
      (legendLabelDeactivate)="onDeactivate($event, undefined, true)"
      (legendLabelClick)="onClick($event)"
    >
      <svg:g [attr.transform]="transform" class="bar-chart chart">
        <svg:g
          ngx-charts-x-axis
          *ngIf="xAxis"
          [xScale]="xScale"
          [dims]="dims"
          [showLabel]="showXAxisLabel"
          [labelText]="xAxisLabel"
          [trimTicks]="trimXAxisTicks"
          [rotateTicks]="rotateXAxisTicks"
          [maxTickLength]="maxXAxisTickLength"
          [tickFormatting]="xAxisTickFormatting"
          [ticks]="xAxisTicks"
          (dimensionsChanged)="updateXAxisHeight($event)"
        ></svg:g>
        <svg:g
          ngx-charts-y-axis
          *ngIf="yAxis"
          [yScale]="yScale"
          [dims]="dims"
          [showGridLines]="showGridLines"
          [showLabel]="showYAxisLabel"
          [labelText]="yAxisLabel"
          [trimTicks]="trimYAxisTicks"
          [maxTickLength]="maxYAxisTickLength"
          [tickFormatting]="yAxisTickFormatting"
          [ticks]="yAxisTicks"
          (dimensionsChanged)="updateYAxisWidth($event)"
        ></svg:g>
        <svg:g
          *ngFor="let group of results; trackBy: trackBy"
          [@animationState]="'active'"
          [attr.transform]="groupTransform(group)"
        >
          <svg:g
            ngx-charts-series-vertical
            type="normalized"
            [xScale]="xScale"
            [yScale]="yScale"
            [activeEntries]="activeEntries"
            [colors]="colors"
            [series]="group.series"
            [dims]="dims"
            [gradient]="gradient"
            [tooltipDisabled]="tooltipDisabled"
            [tooltipTemplate]="tooltipTemplate"
            [seriesName]="group.name"
            [animations]="animations"
            [noBarWhenZero]="noBarWhenZero"
            (select)="onClick($event, group)"
            (activate)="onActivate($event, group)"
            (deactivate)="onDeactivate($event, group)"
          />
        </svg:g>
      </svg:g>
    </ngx-charts-chart>
  `,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      animations: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 1,
        transform: '*'
      }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 0,
        transform: 'scale(0)'
      }))])])],
      styles: [".ngx-charts{float:left;overflow:visible}.ngx-charts .arc,.ngx-charts .bar,.ngx-charts .circle{cursor:pointer}.ngx-charts .arc.active,.ngx-charts .arc:hover,.ngx-charts .bar.active,.ngx-charts .bar:hover,.ngx-charts .card.active,.ngx-charts .card:hover,.ngx-charts .cell.active,.ngx-charts .cell:hover{opacity:.8;transition:opacity .1s ease-in-out}.ngx-charts .arc:focus,.ngx-charts .bar:focus,.ngx-charts .card:focus,.ngx-charts .cell:focus{outline:none}.ngx-charts .arc.hidden,.ngx-charts .bar.hidden,.ngx-charts .card.hidden,.ngx-charts .cell.hidden{display:none}.ngx-charts g:focus{outline:none}.ngx-charts .area-series.inactive,.ngx-charts .line-series-range.inactive,.ngx-charts .line-series.inactive,.ngx-charts .polar-series-area.inactive,.ngx-charts .polar-series-path.inactive{opacity:.2;transition:opacity .1s ease-in-out}.ngx-charts .line-highlight{display:none}.ngx-charts .line-highlight.active{display:block}.ngx-charts .area{opacity:.6}.ngx-charts .circle:hover{cursor:pointer}.ngx-charts .label{font-size:12px;font-weight:400}.ngx-charts .tooltip-anchor{fill:#000}.ngx-charts .gridline-path{fill:none;stroke:#ddd;stroke-width:1}.ngx-charts .refline-path{stroke:#a8b2c7;stroke-dasharray:5;stroke-dashoffset:5;stroke-width:1}.ngx-charts .refline-label{font-size:9px}.ngx-charts .reference-area{fill:#000;fill-opacity:.05}.ngx-charts .gridline-path-dotted{fill:none;stroke:#ddd;stroke-dasharray:1,20;stroke-dashoffset:3;stroke-width:1}.ngx-charts .grid-panel rect{fill:none}.ngx-charts .grid-panel.odd rect{fill:rgba(0,0,0,.05)}"]
    }]
  }], null, {
    legend: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendTitle: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendPosition: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showGridLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimYAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    rotateXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxXAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxYAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    barPadding: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundDomains: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    noBarWhenZero: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    xAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showXAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showYAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    schemeType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
      args: ['tooltipTemplate']
    }]
  });
})();

class BarVerticalStackedComponent extends BaseChartComponent {
  constructor() {
    super(...arguments);
    this.legend = false;
    this.legendTitle = 'Legend';
    this.legendPosition = 'right';
    this.tooltipDisabled = false;
    this.showGridLines = true;
    this.activeEntries = [];
    this.trimXAxisTicks = true;
    this.trimYAxisTicks = true;
    this.rotateXAxisTicks = true;
    this.maxXAxisTickLength = 16;
    this.maxYAxisTickLength = 16;
    this.barPadding = 8;
    this.roundDomains = false;
    this.showDataLabel = false;
    this.noBarWhenZero = true;
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.margin = [10, 20, 10, 20];
    this.xAxisHeight = 0;
    this.yAxisWidth = 0;
    this.dataLabelMaxHeight = {
      negative: 0,
      positive: 0
    };
  }

  update() {
    super.update();

    if (!this.showDataLabel) {
      this.dataLabelMaxHeight = {
        negative: 0,
        positive: 0
      };
    }

    this.margin = [10 + this.dataLabelMaxHeight.positive, 20, 10 + this.dataLabelMaxHeight.negative, 20];
    this.dims = calculateViewDimensions({
      width: this.width,
      height: this.height,
      margins: this.margin,
      showXAxis: this.xAxis,
      showYAxis: this.yAxis,
      xAxisHeight: this.xAxisHeight,
      yAxisWidth: this.yAxisWidth,
      showXLabel: this.showXAxisLabel,
      showYLabel: this.showYAxisLabel,
      showLegend: this.legend,
      legendType: this.schemeType,
      legendPosition: this.legendPosition
    });

    if (this.showDataLabel) {
      this.dims.height -= this.dataLabelMaxHeight.negative;
    }

    this.formatDates();
    this.groupDomain = this.getGroupDomain();
    this.innerDomain = this.getInnerDomain();
    this.valueDomain = this.getValueDomain();
    this.xScale = this.getXScale();
    this.yScale = this.getYScale();
    this.setColors();
    this.legendOptions = this.getLegendOptions();
    this.transform = `translate(${this.dims.xOffset} , ${this.margin[0] + this.dataLabelMaxHeight.negative})`;
  }

  getGroupDomain() {
    const domain = [];

    for (const group of this.results) {
      if (!domain.includes(group.label)) {
        domain.push(group.label);
      }
    }

    return domain;
  }

  getInnerDomain() {
    const domain = [];

    for (const group of this.results) {
      for (const d of group.series) {
        if (!domain.includes(d.label)) {
          domain.push(d.label);
        }
      }
    }

    return domain;
  }

  getValueDomain() {
    const domain = [];
    let smallest = 0;
    let biggest = 0;

    for (const group of this.results) {
      let smallestSum = 0;
      let biggestSum = 0;

      for (const d of group.series) {
        if (d.value < 0) {
          smallestSum += d.value;
        } else {
          biggestSum += d.value;
        }

        smallest = d.value < smallest ? d.value : smallest;
        biggest = d.value > biggest ? d.value : biggest;
      }

      domain.push(smallestSum);
      domain.push(biggestSum);
    }

    domain.push(smallest);
    domain.push(biggest);
    const min = Math.min(0, ...domain);
    const max = this.yScaleMax ? Math.max(this.yScaleMax, ...domain) : Math.max(...domain);
    return [min, max];
  }

  getXScale() {
    const spacing = this.groupDomain.length / (this.dims.width / this.barPadding + 1);
    return (0,d3_scale__WEBPACK_IMPORTED_MODULE_11__["default"])().rangeRound([0, this.dims.width]).paddingInner(spacing).domain(this.groupDomain);
  }

  getYScale() {
    const scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().range([this.dims.height, 0]).domain(this.valueDomain);
    return this.roundDomains ? scale.nice() : scale;
  }

  onDataLabelMaxHeightChanged(event, groupIndex) {
    if (event.size.negative) {
      this.dataLabelMaxHeight.negative = Math.max(this.dataLabelMaxHeight.negative, event.size.height);
    } else {
      this.dataLabelMaxHeight.positive = Math.max(this.dataLabelMaxHeight.positive, event.size.height);
    }

    if (groupIndex === this.results.length - 1) {
      setTimeout(() => this.update());
    }
  }

  groupTransform(group) {
    return `translate(${this.xScale(group.name) || 0}, 0)`;
  }

  onClick(data, group) {
    if (group) {
      data.series = group.name;
    }

    this.select.emit(data);
  }

  trackBy(index, item) {
    return item.name;
  }

  setColors() {
    let domain;

    if (this.schemeType === 'ordinal') {
      domain = this.innerDomain;
    } else {
      domain = this.valueDomain;
    }

    this.colors = new ColorHelper(this.scheme, this.schemeType, domain, this.customColors);
  }

  getLegendOptions() {
    const opts = {
      scaleType: this.schemeType,
      colors: undefined,
      domain: [],
      title: undefined,
      position: this.legendPosition
    };

    if (opts.scaleType === 'ordinal') {
      opts.domain = this.innerDomain;
      opts.colors = this.colors;
      opts.title = this.legendTitle;
    } else {
      opts.domain = this.valueDomain;
      opts.colors = this.colors.scale;
    }

    return opts;
  }

  updateYAxisWidth({
    width
  }) {
    this.yAxisWidth = width;
    this.update();
  }

  updateXAxisHeight({
    height
  }) {
    this.xAxisHeight = height;
    this.update();
  }

  onActivate(event, group, fromLegend = false) {
    const item = Object.assign({}, event);

    if (group) {
      item.series = group.name;
    }

    const items = this.results.map(g => g.series).flat().filter(i => {
      if (fromLegend) {
        return i.label === item.name;
      } else {
        return i.name === item.name && i.series === item.series;
      }
    });
    this.activeEntries = [...items];
    this.activate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

  onDeactivate(event, group, fromLegend = false) {
    const item = Object.assign({}, event);

    if (group) {
      item.series = group.name;
    }

    this.activeEntries = this.activeEntries.filter(i => {
      if (fromLegend) {
        return i.label !== item.name;
      } else {
        return !(i.name === item.name && i.series === item.series);
      }
    });
    this.deactivate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

}

BarVerticalStackedComponent.ɵfac = /*@__PURE__*/function () {
  let ɵBarVerticalStackedComponent_BaseFactory;
  return function BarVerticalStackedComponent_Factory(t) {
    return (ɵBarVerticalStackedComponent_BaseFactory || (ɵBarVerticalStackedComponent_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](BarVerticalStackedComponent)))(t || BarVerticalStackedComponent);
  };
}();

BarVerticalStackedComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: BarVerticalStackedComponent,
  selectors: [["ngx-charts-bar-vertical-stacked"]],
  contentQueries: function BarVerticalStackedComponent_ContentQueries(rf, ctx, dirIndex) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"](dirIndex, _c21, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.tooltipTemplate = _t.first);
    }
  },
  inputs: {
    legend: "legend",
    legendTitle: "legendTitle",
    legendPosition: "legendPosition",
    tooltipDisabled: "tooltipDisabled",
    showGridLines: "showGridLines",
    activeEntries: "activeEntries",
    trimXAxisTicks: "trimXAxisTicks",
    trimYAxisTicks: "trimYAxisTicks",
    rotateXAxisTicks: "rotateXAxisTicks",
    maxXAxisTickLength: "maxXAxisTickLength",
    maxYAxisTickLength: "maxYAxisTickLength",
    barPadding: "barPadding",
    roundDomains: "roundDomains",
    showDataLabel: "showDataLabel",
    noBarWhenZero: "noBarWhenZero",
    xAxis: "xAxis",
    yAxis: "yAxis",
    showXAxisLabel: "showXAxisLabel",
    showYAxisLabel: "showYAxisLabel",
    xAxisLabel: "xAxisLabel",
    yAxisLabel: "yAxisLabel",
    gradient: "gradient",
    schemeType: "schemeType",
    xAxisTickFormatting: "xAxisTickFormatting",
    yAxisTickFormatting: "yAxisTickFormatting",
    xAxisTicks: "xAxisTicks",
    yAxisTicks: "yAxisTicks",
    yScaleMax: "yScaleMax",
    dataLabelFormatting: "dataLabelFormatting"
  },
  outputs: {
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]],
  decls: 5,
  vars: 13,
  consts: [[3, "view", "showLegend", "legendOptions", "activeEntries", "animations", "legendLabelActivate", "legendLabelDeactivate", "legendLabelClick"], [1, "bar-chart", "chart"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "xAxisOffset", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], [4, "ngFor", "ngForOf", "ngForTrackBy"], ["ngx-charts-x-axis", "", 3, "xScale", "dims", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "xAxisOffset", "dimensionsChanged"], ["ngx-charts-y-axis", "", 3, "yScale", "dims", "showGridLines", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-series-vertical", "", "type", "stacked", 3, "xScale", "yScale", "activeEntries", "colors", "series", "dims", "gradient", "tooltipDisabled", "tooltipTemplate", "showDataLabel", "dataLabelFormatting", "seriesName", "animations", "noBarWhenZero", "select", "activate", "deactivate", "dataLabelHeightChanged"]],
  template: function BarVerticalStackedComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "ngx-charts-chart", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("legendLabelActivate", function BarVerticalStackedComponent_Template_ngx_charts_chart_legendLabelActivate_0_listener($event) {
        return ctx.onActivate($event, undefined, true);
      })("legendLabelDeactivate", function BarVerticalStackedComponent_Template_ngx_charts_chart_legendLabelDeactivate_0_listener($event) {
        return ctx.onDeactivate($event, undefined, true);
      })("legendLabelClick", function BarVerticalStackedComponent_Template_ngx_charts_chart_legendLabelClick_0_listener($event) {
        return ctx.onClick($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "g", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, BarVerticalStackedComponent__svg_g_2_Template, 1, 10, "g", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, BarVerticalStackedComponent__svg_g_3_Template, 1, 9, "g", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, BarVerticalStackedComponent__svg_g_4_Template, 2, 16, "g", 4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("view", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](10, _c23, ctx.width, ctx.height))("showLegend", ctx.legend)("legendOptions", ctx.legendOptions)("activeEntries", ctx.activeEntries)("animations", ctx.animations);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.xAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.yAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.results)("ngForTrackBy", ctx.trackBy);
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, XAxisComponent, YAxisComponent, ChartComponent, SeriesVerticalComponent];
  },
  styles: [_c24],
  encapsulation: 2,
  data: {
    animation: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 1,
      transform: '*'
    }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 0,
      transform: 'scale(0)'
    }))])])]
  },
  changeDetection: 0
});
BarVerticalStackedComponent.propDecorators = {
  legend: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendTitle: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendPosition: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showXAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showYAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showGridLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  schemeType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimYAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  rotateXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxXAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxYAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  barPadding: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundDomains: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScaleMax: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showDataLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  dataLabelFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  noBarWhenZero: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
    args: ['tooltipTemplate']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](BarVerticalStackedComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-charts-bar-vertical-stacked',
      template: `
    <ngx-charts-chart
      [view]="[width, height]"
      [showLegend]="legend"
      [legendOptions]="legendOptions"
      [activeEntries]="activeEntries"
      [animations]="animations"
      (legendLabelActivate)="onActivate($event, undefined, true)"
      (legendLabelDeactivate)="onDeactivate($event, undefined, true)"
      (legendLabelClick)="onClick($event)"
    >
      <svg:g [attr.transform]="transform" class="bar-chart chart">
        <svg:g
          ngx-charts-x-axis
          *ngIf="xAxis"
          [xScale]="xScale"
          [dims]="dims"
          [showLabel]="showXAxisLabel"
          [labelText]="xAxisLabel"
          [trimTicks]="trimXAxisTicks"
          [rotateTicks]="rotateXAxisTicks"
          [maxTickLength]="maxXAxisTickLength"
          [tickFormatting]="xAxisTickFormatting"
          [ticks]="xAxisTicks"
          [xAxisOffset]="dataLabelMaxHeight.negative"
          (dimensionsChanged)="updateXAxisHeight($event)"
        ></svg:g>
        <svg:g
          ngx-charts-y-axis
          *ngIf="yAxis"
          [yScale]="yScale"
          [dims]="dims"
          [showGridLines]="showGridLines"
          [showLabel]="showYAxisLabel"
          [labelText]="yAxisLabel"
          [trimTicks]="trimYAxisTicks"
          [maxTickLength]="maxYAxisTickLength"
          [tickFormatting]="yAxisTickFormatting"
          [ticks]="yAxisTicks"
          (dimensionsChanged)="updateYAxisWidth($event)"
        ></svg:g>
        <svg:g
          *ngFor="let group of results; let index = index; trackBy: trackBy"
          [@animationState]="'active'"
          [attr.transform]="groupTransform(group)"
        >
          <svg:g
            ngx-charts-series-vertical
            type="stacked"
            [xScale]="xScale"
            [yScale]="yScale"
            [activeEntries]="activeEntries"
            [colors]="colors"
            [series]="group.series"
            [dims]="dims"
            [gradient]="gradient"
            [tooltipDisabled]="tooltipDisabled"
            [tooltipTemplate]="tooltipTemplate"
            [showDataLabel]="showDataLabel"
            [dataLabelFormatting]="dataLabelFormatting"
            [seriesName]="group.name"
            [animations]="animations"
            [noBarWhenZero]="noBarWhenZero"
            (select)="onClick($event, group)"
            (activate)="onActivate($event, group)"
            (deactivate)="onDeactivate($event, group)"
            (dataLabelHeightChanged)="onDataLabelMaxHeightChanged($event, index)"
          />
        </svg:g>
      </svg:g>
    </ngx-charts-chart>
  `,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      animations: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 1,
        transform: '*'
      }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 0,
        transform: 'scale(0)'
      }))])])],
      styles: [".ngx-charts{float:left;overflow:visible}.ngx-charts .arc,.ngx-charts .bar,.ngx-charts .circle{cursor:pointer}.ngx-charts .arc.active,.ngx-charts .arc:hover,.ngx-charts .bar.active,.ngx-charts .bar:hover,.ngx-charts .card.active,.ngx-charts .card:hover,.ngx-charts .cell.active,.ngx-charts .cell:hover{opacity:.8;transition:opacity .1s ease-in-out}.ngx-charts .arc:focus,.ngx-charts .bar:focus,.ngx-charts .card:focus,.ngx-charts .cell:focus{outline:none}.ngx-charts .arc.hidden,.ngx-charts .bar.hidden,.ngx-charts .card.hidden,.ngx-charts .cell.hidden{display:none}.ngx-charts g:focus{outline:none}.ngx-charts .area-series.inactive,.ngx-charts .line-series-range.inactive,.ngx-charts .line-series.inactive,.ngx-charts .polar-series-area.inactive,.ngx-charts .polar-series-path.inactive{opacity:.2;transition:opacity .1s ease-in-out}.ngx-charts .line-highlight{display:none}.ngx-charts .line-highlight.active{display:block}.ngx-charts .area{opacity:.6}.ngx-charts .circle:hover{cursor:pointer}.ngx-charts .label{font-size:12px;font-weight:400}.ngx-charts .tooltip-anchor{fill:#000}.ngx-charts .gridline-path{fill:none;stroke:#ddd;stroke-width:1}.ngx-charts .refline-path{stroke:#a8b2c7;stroke-dasharray:5;stroke-dashoffset:5;stroke-width:1}.ngx-charts .refline-label{font-size:9px}.ngx-charts .reference-area{fill:#000;fill-opacity:.05}.ngx-charts .gridline-path-dotted{fill:none;stroke:#ddd;stroke-dasharray:1,20;stroke-dashoffset:3;stroke-width:1}.ngx-charts .grid-panel rect{fill:none}.ngx-charts .grid-panel.odd rect{fill:rgba(0,0,0,.05)}"]
    }]
  }], null, {
    legend: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendTitle: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendPosition: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showGridLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimYAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    rotateXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxXAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxYAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    barPadding: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundDomains: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showDataLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    noBarWhenZero: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    xAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showXAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showYAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    schemeType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScaleMax: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    dataLabelFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
      args: ['tooltipTemplate']
    }]
  });
})();

var D0Types;

(function (D0Types) {
  D0Types["positive"] = "positive";
  D0Types["negative"] = "negative";
})(D0Types || (D0Types = {}));

class SeriesVerticalComponent {
  constructor() {
    this.type = 'standard';
    this.tooltipDisabled = false;
    this.animations = true;
    this.showDataLabel = false;
    this.noBarWhenZero = true;
    this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.dataLabelHeightChanged = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.barsForDataLabels = [];
  }

  ngOnChanges(changes) {
    this.update();
  }

  update() {
    this.updateTooltipSettings();
    let width;

    if (this.series.length) {
      width = this.xScale.bandwidth();
    }

    width = Math.round(width);
    const yScaleMin = Math.max(this.yScale.domain()[0], 0);
    const d0 = {
      [D0Types.positive]: 0,
      [D0Types.negative]: 0
    };
    let d0Type = D0Types.positive;
    let total;

    if (this.type === 'normalized') {
      total = this.series.map(d => d.value).reduce((sum, d) => sum + d, 0);
    }

    this.bars = this.series.map((d, index) => {
      let value = d.value;
      const label = this.getLabel(d);
      const formattedLabel = formatLabel(label);
      const roundEdges = this.roundEdges;
      d0Type = value > 0 ? D0Types.positive : D0Types.negative;
      const bar = {
        value,
        label,
        roundEdges,
        data: d,
        width,
        formattedLabel,
        height: 0,
        x: 0,
        y: 0
      };

      if (this.type === 'standard') {
        bar.height = Math.abs(this.yScale(value) - this.yScale(yScaleMin));
        bar.x = this.xScale(label);

        if (value < 0) {
          bar.y = this.yScale(0);
        } else {
          bar.y = this.yScale(value);
        }
      } else if (this.type === 'stacked') {
        const offset0 = d0[d0Type];
        const offset1 = offset0 + value;
        d0[d0Type] += value;
        bar.height = this.yScale(offset0) - this.yScale(offset1);
        bar.x = 0;
        bar.y = this.yScale(offset1);
        bar.offset0 = offset0;
        bar.offset1 = offset1;
      } else if (this.type === 'normalized') {
        let offset0 = d0[d0Type];
        let offset1 = offset0 + value;
        d0[d0Type] += value;

        if (total > 0) {
          offset0 = offset0 * 100 / total;
          offset1 = offset1 * 100 / total;
        } else {
          offset0 = 0;
          offset1 = 0;
        }

        bar.height = this.yScale(offset0) - this.yScale(offset1);
        bar.x = 0;
        bar.y = this.yScale(offset1);
        bar.offset0 = offset0;
        bar.offset1 = offset1;
        value = (offset1 - offset0).toFixed(2) + '%';
      }

      if (this.colors.scaleType === 'ordinal') {
        bar.color = this.colors.getColor(label);
      } else {
        if (this.type === 'standard') {
          bar.color = this.colors.getColor(value);
          bar.gradientStops = this.colors.getLinearGradientStops(value);
        } else {
          bar.color = this.colors.getColor(bar.offset1);
          bar.gradientStops = this.colors.getLinearGradientStops(bar.offset1, bar.offset0);
        }
      }

      let tooltipLabel = formattedLabel;
      bar.ariaLabel = formattedLabel + ' ' + value.toLocaleString();

      if (this.seriesName) {
        tooltipLabel = `${this.seriesName} • ${formattedLabel}`;
        bar.data.series = this.seriesName;
        bar.ariaLabel = this.seriesName + ' ' + bar.ariaLabel;
      }

      bar.tooltipText = this.tooltipDisabled ? undefined : `
        <span class="tooltip-label">${escapeLabel(tooltipLabel)}</span>
        <span class="tooltip-val">${this.dataLabelFormatting ? this.dataLabelFormatting(value) : value.toLocaleString()}</span>
      `;
      return bar;
    });
    this.updateDataLabels();
  }

  updateDataLabels() {
    if (this.type === 'stacked') {
      this.barsForDataLabels = [];
      const section = {};
      section.series = this.seriesName;
      const totalPositive = this.series.map(d => d.value).reduce((sum, d) => d > 0 ? sum + d : sum, 0);
      const totalNegative = this.series.map(d => d.value).reduce((sum, d) => d < 0 ? sum + d : sum, 0);
      section.total = totalPositive + totalNegative;
      section.x = 0;
      section.y = 0;

      if (section.total > 0) {
        section.height = this.yScale(totalPositive);
      } else {
        section.height = this.yScale(totalNegative);
      }

      section.width = this.xScale.bandwidth();
      this.barsForDataLabels.push(section);
    } else {
      this.barsForDataLabels = this.series.map(d => {
        const section = {};
        section.series = this.seriesName ? this.seriesName : d.label;
        section.total = d.value;
        section.x = this.xScale(d.label);
        section.y = this.yScale(0);
        section.height = this.yScale(section.total) - this.yScale(0);
        section.width = this.xScale.bandwidth();
        return section;
      });
    }
  }

  updateTooltipSettings() {
    this.tooltipPlacement = this.tooltipDisabled ? undefined : 'top';
    this.tooltipType = this.tooltipDisabled ? undefined : 'tooltip';
  }

  isActive(entry) {
    if (!this.activeEntries) return false;
    const item = this.activeEntries.find(d => {
      return entry.name === d.name && entry.series === d.series;
    });
    return item !== undefined;
  }

  onClick(data) {
    this.select.emit(data);
  }

  getLabel(dataItem) {
    if (dataItem.label) {
      return dataItem.label;
    }

    return dataItem.name;
  }

  trackBy(index, bar) {
    return bar.label;
  }

  trackDataLabelBy(index, barLabel) {
    return index + '#' + barLabel.series + '#' + barLabel.total;
  }

}

SeriesVerticalComponent.ɵfac = function SeriesVerticalComponent_Factory(t) {
  return new (t || SeriesVerticalComponent)();
};

SeriesVerticalComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: SeriesVerticalComponent,
  selectors: [["g", "ngx-charts-series-vertical", ""]],
  inputs: {
    type: "type",
    tooltipDisabled: "tooltipDisabled",
    animations: "animations",
    showDataLabel: "showDataLabel",
    noBarWhenZero: "noBarWhenZero",
    dims: "dims",
    series: "series",
    xScale: "xScale",
    yScale: "yScale",
    colors: "colors",
    gradient: "gradient",
    activeEntries: "activeEntries",
    seriesName: "seriesName",
    tooltipTemplate: "tooltipTemplate",
    roundEdges: "roundEdges",
    dataLabelFormatting: "dataLabelFormatting"
  },
  outputs: {
    select: "select",
    activate: "activate",
    deactivate: "deactivate",
    dataLabelHeightChanged: "dataLabelHeightChanged"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c27,
  decls: 2,
  vars: 3,
  consts: [["ngx-charts-bar", "", "ngx-tooltip", "", 3, "width", "height", "x", "y", "fill", "stops", "data", "orientation", "roundEdges", "gradient", "ariaLabel", "isActive", "tooltipDisabled", "tooltipPlacement", "tooltipType", "tooltipTitle", "tooltipTemplate", "tooltipContext", "noBarWhenZero", "animations", "select", "activate", "deactivate", 4, "ngFor", "ngForOf", "ngForTrackBy"], [4, "ngIf"], ["ngx-charts-bar", "", "ngx-tooltip", "", 3, "width", "height", "x", "y", "fill", "stops", "data", "orientation", "roundEdges", "gradient", "ariaLabel", "isActive", "tooltipDisabled", "tooltipPlacement", "tooltipType", "tooltipTitle", "tooltipTemplate", "tooltipContext", "noBarWhenZero", "animations", "select", "activate", "deactivate"], ["ngx-charts-bar-label", "", 3, "barX", "barY", "barWidth", "barHeight", "value", "valueFormatting", "orientation", "dimensionsChanged", 4, "ngFor", "ngForOf", "ngForTrackBy"], ["ngx-charts-bar-label", "", 3, "barX", "barY", "barWidth", "barHeight", "value", "valueFormatting", "orientation", "dimensionsChanged"]],
  template: function SeriesVerticalComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, SeriesVerticalComponent__svg_g_0_Template, 1, 22, "g", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, SeriesVerticalComponent__svg_g_1_Template, 2, 2, "g", 1);
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.bars)("ngForTrackBy", ctx.trackBy);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.showDataLabel);
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, TooltipDirective, BarComponent, BarLabelComponent];
  },
  encapsulation: 2,
  data: {
    animation: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 1
    }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 0
    }))])])]
  },
  changeDetection: 0
});
SeriesVerticalComponent.propDecorators = {
  dims: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  type: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  series: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  colors: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  seriesName: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundEdges: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  animations: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showDataLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  dataLabelFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  noBarWhenZero: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  select: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  dataLabelHeightChanged: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](SeriesVerticalComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-series-vertical]',
      template: `
    <svg:g
      ngx-charts-bar
      *ngFor="let bar of bars; trackBy: trackBy"
      [@animationState]="'active'"
      [@.disabled]="!animations"
      [width]="bar.width"
      [height]="bar.height"
      [x]="bar.x"
      [y]="bar.y"
      [fill]="bar.color"
      [stops]="bar.gradientStops"
      [data]="bar.data"
      [orientation]="'vertical'"
      [roundEdges]="bar.roundEdges"
      [gradient]="gradient"
      [ariaLabel]="bar.ariaLabel"
      [isActive]="isActive(bar.data)"
      (select)="onClick($event)"
      (activate)="activate.emit($event)"
      (deactivate)="deactivate.emit($event)"
      ngx-tooltip
      [tooltipDisabled]="tooltipDisabled"
      [tooltipPlacement]="tooltipPlacement"
      [tooltipType]="tooltipType"
      [tooltipTitle]="tooltipTemplate ? undefined : bar.tooltipText"
      [tooltipTemplate]="tooltipTemplate"
      [tooltipContext]="bar.data"
      [noBarWhenZero]="noBarWhenZero"
      [animations]="animations"
    ></svg:g>
    <svg:g *ngIf="showDataLabel">
      <svg:g
        ngx-charts-bar-label
        *ngFor="let b of barsForDataLabels; let i = index; trackBy: trackDataLabelBy"
        [barX]="b.x"
        [barY]="b.y"
        [barWidth]="b.width"
        [barHeight]="b.height"
        [value]="b.total"
        [valueFormatting]="dataLabelFormatting"
        [orientation]="'vertical'"
        (dimensionsChanged)="dataLabelHeightChanged.emit({ size: $event, index: i })"
      />
    </svg:g>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      animations: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 1
      }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 0
      }))])])]
    }]
  }], function () {
    return [];
  }, {
    type: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    animations: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showDataLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    noBarWhenZero: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    select: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    dataLabelHeightChanged: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    dims: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    series: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    colors: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    seriesName: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundEdges: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    dataLabelFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class SeriesHorizontal {
  constructor() {
    this.barsForDataLabels = [];
    this.type = 'standard';
    this.tooltipDisabled = false;
    this.animations = true;
    this.showDataLabel = false;
    this.noBarWhenZero = true;
    this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.dataLabelWidthChanged = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
  }

  ngOnChanges(changes) {
    this.update();
  }

  update() {
    this.updateTooltipSettings();
    const d0 = {
      [D0Types.positive]: 0,
      [D0Types.negative]: 0
    };
    let d0Type;
    d0Type = D0Types.positive;
    let total;

    if (this.type === 'normalized') {
      total = this.series.map(d => d.value).reduce((sum, d) => sum + d, 0);
    }

    const xScaleMin = Math.max(this.xScale.domain()[0], 0);
    this.bars = this.series.map((d, index) => {
      let value = d.value;
      const label = this.getLabel(d);
      const formattedLabel = formatLabel(label);
      const roundEdges = this.roundEdges;
      d0Type = value > 0 ? D0Types.positive : D0Types.negative;
      const bar = {
        value,
        label,
        roundEdges,
        data: d,
        formattedLabel
      };
      bar.height = this.yScale.bandwidth();

      if (this.type === 'standard') {
        bar.width = Math.abs(this.xScale(value) - this.xScale(xScaleMin));

        if (value < 0) {
          bar.x = this.xScale(value);
        } else {
          bar.x = this.xScale(xScaleMin);
        }

        bar.y = this.yScale(label);
      } else if (this.type === 'stacked') {
        const offset0 = d0[d0Type];
        const offset1 = offset0 + value;
        d0[d0Type] += value;
        bar.width = this.xScale(offset1) - this.xScale(offset0);
        bar.x = this.xScale(offset0);
        bar.y = 0;
        bar.offset0 = offset0;
        bar.offset1 = offset1;
      } else if (this.type === 'normalized') {
        let offset0 = d0[d0Type];
        let offset1 = offset0 + value;
        d0[d0Type] += value;

        if (total > 0) {
          offset0 = offset0 * 100 / total;
          offset1 = offset1 * 100 / total;
        } else {
          offset0 = 0;
          offset1 = 0;
        }

        bar.width = this.xScale(offset1) - this.xScale(offset0);
        bar.x = this.xScale(offset0);
        bar.y = 0;
        bar.offset0 = offset0;
        bar.offset1 = offset1;
        value = (offset1 - offset0).toFixed(2) + '%';
      }

      if (this.colors.scaleType === 'ordinal') {
        bar.color = this.colors.getColor(label);
      } else {
        if (this.type === 'standard') {
          bar.color = this.colors.getColor(value);
          bar.gradientStops = this.colors.getLinearGradientStops(value);
        } else {
          bar.color = this.colors.getColor(bar.offset1);
          bar.gradientStops = this.colors.getLinearGradientStops(bar.offset1, bar.offset0);
        }
      }

      let tooltipLabel = formattedLabel;
      bar.ariaLabel = formattedLabel + ' ' + value.toLocaleString();

      if (this.seriesName) {
        tooltipLabel = `${this.seriesName} • ${formattedLabel}`;
        bar.data.series = this.seriesName;
        bar.ariaLabel = this.seriesName + ' ' + bar.ariaLabel;
      }

      bar.tooltipText = this.tooltipDisabled ? undefined : `
        <span class="tooltip-label">${escapeLabel(tooltipLabel)}</span>
        <span class="tooltip-val">${this.dataLabelFormatting ? this.dataLabelFormatting(value) : value.toLocaleString()}</span>
      `;
      return bar;
    });
    this.updateDataLabels();
  }

  updateDataLabels() {
    if (this.type === 'stacked') {
      this.barsForDataLabels = [];
      const section = {};
      section.series = this.seriesName;
      const totalPositive = this.series.map(d => d.value).reduce((sum, d) => d > 0 ? sum + d : sum, 0);
      const totalNegative = this.series.map(d => d.value).reduce((sum, d) => d < 0 ? sum + d : sum, 0);
      section.total = totalPositive + totalNegative;
      section.x = 0;
      section.y = 0; // if total is positive then we show it on the right, otherwise on the left

      if (section.total > 0) {
        section.width = this.xScale(totalPositive);
      } else {
        section.width = this.xScale(totalNegative);
      }

      section.height = this.yScale.bandwidth();
      this.barsForDataLabels.push(section);
    } else {
      this.barsForDataLabels = this.series.map(d => {
        const section = {};
        section.series = this.seriesName ? this.seriesName : d.label;
        section.total = d.value;
        section.x = this.xScale(0);
        section.y = this.yScale(d.label);
        section.width = this.xScale(section.total) - this.xScale(0);
        section.height = this.yScale.bandwidth();
        return section;
      });
    }
  }

  updateTooltipSettings() {
    this.tooltipPlacement = this.tooltipDisabled ? undefined : 'top';
    this.tooltipType = this.tooltipDisabled ? undefined : 'tooltip';
  }

  isActive(entry) {
    if (!this.activeEntries) return false;
    const item = this.activeEntries.find(d => {
      return entry.name === d.name && entry.series === d.series;
    });
    return item !== undefined;
  }

  getLabel(dataItem) {
    if (dataItem.label) {
      return dataItem.label;
    }

    return dataItem.name;
  }

  trackBy(index, bar) {
    return bar.label;
  }

  trackDataLabelBy(index, barLabel) {
    return index + '#' + barLabel.series + '#' + barLabel.total;
  }

  click(data) {
    this.select.emit(data);
  }

}

SeriesHorizontal.ɵfac = function SeriesHorizontal_Factory(t) {
  return new (t || SeriesHorizontal)();
};

SeriesHorizontal.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: SeriesHorizontal,
  selectors: [["g", "ngx-charts-series-horizontal", ""]],
  inputs: {
    type: "type",
    tooltipDisabled: "tooltipDisabled",
    animations: "animations",
    showDataLabel: "showDataLabel",
    noBarWhenZero: "noBarWhenZero",
    dims: "dims",
    series: "series",
    xScale: "xScale",
    yScale: "yScale",
    colors: "colors",
    gradient: "gradient",
    activeEntries: "activeEntries",
    seriesName: "seriesName",
    tooltipTemplate: "tooltipTemplate",
    roundEdges: "roundEdges",
    dataLabelFormatting: "dataLabelFormatting"
  },
  outputs: {
    select: "select",
    activate: "activate",
    deactivate: "deactivate",
    dataLabelWidthChanged: "dataLabelWidthChanged"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c28,
  decls: 2,
  vars: 3,
  consts: [["ngx-charts-bar", "", "ngx-tooltip", "", 3, "width", "height", "x", "y", "fill", "stops", "data", "orientation", "roundEdges", "gradient", "isActive", "ariaLabel", "animations", "tooltipDisabled", "tooltipPlacement", "tooltipType", "tooltipTitle", "tooltipTemplate", "tooltipContext", "noBarWhenZero", "select", "activate", "deactivate", 4, "ngFor", "ngForOf", "ngForTrackBy"], [4, "ngIf"], ["ngx-charts-bar", "", "ngx-tooltip", "", 3, "width", "height", "x", "y", "fill", "stops", "data", "orientation", "roundEdges", "gradient", "isActive", "ariaLabel", "animations", "tooltipDisabled", "tooltipPlacement", "tooltipType", "tooltipTitle", "tooltipTemplate", "tooltipContext", "noBarWhenZero", "select", "activate", "deactivate"], ["ngx-charts-bar-label", "", 3, "barX", "barY", "barWidth", "barHeight", "value", "valueFormatting", "orientation", "dimensionsChanged", 4, "ngFor", "ngForOf", "ngForTrackBy"], ["ngx-charts-bar-label", "", 3, "barX", "barY", "barWidth", "barHeight", "value", "valueFormatting", "orientation", "dimensionsChanged"]],
  template: function SeriesHorizontal_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, SeriesHorizontal__svg_g_0_Template, 1, 21, "g", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, SeriesHorizontal__svg_g_1_Template, 2, 2, "g", 1);
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.bars)("ngForTrackBy", ctx.trackBy);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.showDataLabel);
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, TooltipDirective, BarComponent, BarLabelComponent];
  },
  encapsulation: 2,
  data: {
    animation: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 1
    }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 0
    }))])])]
  },
  changeDetection: 0
});
SeriesHorizontal.propDecorators = {
  dims: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  type: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  series: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  colors: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  seriesName: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundEdges: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  animations: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showDataLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  dataLabelFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  noBarWhenZero: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  select: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  dataLabelWidthChanged: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](SeriesHorizontal, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-series-horizontal]',
      template: `
    <svg:g
      ngx-charts-bar
      *ngFor="let bar of bars; trackBy: trackBy"
      [@animationState]="'active'"
      [width]="bar.width"
      [height]="bar.height"
      [x]="bar.x"
      [y]="bar.y"
      [fill]="bar.color"
      [stops]="bar.gradientStops"
      [data]="bar.data"
      [orientation]="'horizontal'"
      [roundEdges]="bar.roundEdges"
      (select)="click($event)"
      [gradient]="gradient"
      [isActive]="isActive(bar.data)"
      [ariaLabel]="bar.ariaLabel"
      [animations]="animations"
      (activate)="activate.emit($event)"
      (deactivate)="deactivate.emit($event)"
      ngx-tooltip
      [tooltipDisabled]="tooltipDisabled"
      [tooltipPlacement]="tooltipPlacement"
      [tooltipType]="tooltipType"
      [tooltipTitle]="tooltipTemplate ? undefined : bar.tooltipText"
      [tooltipTemplate]="tooltipTemplate"
      [tooltipContext]="bar.data"
      [noBarWhenZero]="noBarWhenZero"
    ></svg:g>
    <svg:g *ngIf="showDataLabel">
      <svg:g
        ngx-charts-bar-label
        *ngFor="let b of barsForDataLabels; let i = index; trackBy: trackDataLabelBy"
        [barX]="b.x"
        [barY]="b.y"
        [barWidth]="b.width"
        [barHeight]="b.height"
        [value]="b.total"
        [valueFormatting]="dataLabelFormatting"
        [orientation]="'horizontal'"
        (dimensionsChanged)="dataLabelWidthChanged.emit({ size: $event, index: i })"
      />
    </svg:g>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      animations: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 1
      }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 0
      }))])])]
    }]
  }], function () {
    return [];
  }, {
    type: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    animations: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showDataLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    noBarWhenZero: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    select: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    dataLabelWidthChanged: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    dims: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    series: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    colors: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    seriesName: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundEdges: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    dataLabelFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class BarLabelComponent {
  constructor(element) {
    this.dimensionsChanged = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.horizontalPadding = 2;
    this.verticalPadding = 5;
    this.element = element.nativeElement;
  }

  ngOnChanges(changes) {
    this.update();
  }

  getSize() {
    const h = this.element.getBoundingClientRect().height;
    const w = this.element.getBoundingClientRect().width;
    return {
      height: h,
      width: w,
      negative: this.value < 0
    };
  }

  ngAfterViewInit() {
    this.dimensionsChanged.emit(this.getSize());
  }

  update() {
    if (this.valueFormatting) {
      this.formatedValue = this.valueFormatting(this.value);
    } else {
      this.formatedValue = formatLabel(this.value);
    }

    if (this.orientation === 'horizontal') {
      this.x = this.barX + this.barWidth; // if the value is negative then it's on the left of the x0.
      // we need to put the data label in front of the bar

      if (this.value < 0) {
        this.x = this.x - this.horizontalPadding;
        this.textAnchor = 'end';
      } else {
        this.x = this.x + this.horizontalPadding;
        this.textAnchor = 'start';
      }

      this.y = this.barY + this.barHeight / 2;
    } else {
      // orientation must be "vertical"
      this.x = this.barX + this.barWidth / 2;
      this.y = this.barY + this.barHeight;

      if (this.value < 0) {
        this.y = this.y + this.verticalPadding;
        this.textAnchor = 'end';
      } else {
        this.y = this.y - this.verticalPadding;
        this.textAnchor = 'start';
      }

      this.transform = `rotate(-45, ${this.x} , ${this.y})`;
    }
  }

}

BarLabelComponent.ɵfac = function BarLabelComponent_Factory(t) {
  return new (t || BarLabelComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef));
};

BarLabelComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: BarLabelComponent,
  selectors: [["g", "ngx-charts-bar-label", ""]],
  inputs: {
    value: "value",
    valueFormatting: "valueFormatting",
    barX: "barX",
    barY: "barY",
    barWidth: "barWidth",
    barHeight: "barHeight",
    orientation: "orientation"
  },
  outputs: {
    dimensionsChanged: "dimensionsChanged"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c29,
  decls: 2,
  vars: 5,
  consts: [["alignment-baseline", "middle", 1, "textDataLabel"]],
  template: function BarLabelComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "text", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("text-anchor", ctx.textAnchor)("transform", ctx.transform)("x", ctx.x)("y", ctx.y);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.formatedValue, " ");
    }
  },
  styles: [".textDataLabel[_ngcontent-%COMP%]{font-size:11px}"],
  changeDetection: 0
});

BarLabelComponent.ctorParameters = () => [{
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
}];

BarLabelComponent.propDecorators = {
  value: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  valueFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  barX: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  barY: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  barWidth: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  barHeight: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  orientation: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  dimensionsChanged: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](BarLabelComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-bar-label]',
      template: `
    <svg:text
      class="textDataLabel"
      alignment-baseline="middle"
      [attr.text-anchor]="textAnchor"
      [attr.transform]="transform"
      [attr.x]="x"
      [attr.y]="y"
    >
      {{ formatedValue }}
    </svg:text>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      styles: [".textDataLabel{font-size:11px}"]
    }]
  }], function () {
    return [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
    }];
  }, {
    dimensionsChanged: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    value: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    valueFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    barX: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    barY: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    barWidth: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    barHeight: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    orientation: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class BarChartModule {}

BarChartModule.ɵfac = function BarChartModule_Factory(t) {
  return new (t || BarChartModule)();
};

BarChartModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({
  type: BarChartModule
});
BarChartModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({
  imports: [ChartCommonModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](BarChartModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.NgModule,
    args: [{
      imports: [ChartCommonModule],
      declarations: [BarComponent, BarHorizontalComponent, BarHorizontal2DComponent, BarHorizontalNormalizedComponent, BarHorizontalStackedComponent, BarVerticalComponent, BarVertical2DComponent, BarVerticalNormalizedComponent, BarVerticalStackedComponent, BarLabelComponent, SeriesHorizontal, SeriesVerticalComponent],
      exports: [BarComponent, BarHorizontalComponent, BarHorizontal2DComponent, BarHorizontalNormalizedComponent, BarHorizontalStackedComponent, BarVerticalComponent, BarVertical2DComponent, BarVerticalNormalizedComponent, BarVerticalStackedComponent, BarLabelComponent, SeriesHorizontal, SeriesVerticalComponent]
    }]
  }], null, null);
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](BarChartModule, {
    declarations: [BarComponent, BarHorizontalComponent, BarHorizontal2DComponent, BarHorizontalNormalizedComponent, BarHorizontalStackedComponent, BarVerticalComponent, BarVertical2DComponent, BarVerticalNormalizedComponent, BarVerticalStackedComponent, BarLabelComponent, SeriesHorizontal, SeriesVerticalComponent],
    imports: [ChartCommonModule],
    exports: [BarComponent, BarHorizontalComponent, BarHorizontal2DComponent, BarHorizontalNormalizedComponent, BarHorizontalStackedComponent, BarVerticalComponent, BarVertical2DComponent, BarVerticalNormalizedComponent, BarVerticalStackedComponent, BarLabelComponent, SeriesHorizontal, SeriesVerticalComponent]
  });
})();

function getDomain(values, scaleType, autoScale, minVal, maxVal) {
  let domain = [];

  if (scaleType === 'linear') {
    values = values.map(v => Number(v));

    if (!autoScale) {
      values.push(0);
    }
  }

  if (scaleType === 'time' || scaleType === 'linear') {
    const min = minVal ? minVal : Math.min(...values);
    const max = maxVal ? maxVal : Math.max(...values);
    domain = [min, max];
  } else {
    domain = values;
  }

  return domain;
}

function getScale(domain, range, scaleType, roundDomains) {
  let scale;

  if (scaleType === 'time') {
    scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_9__["default"])().range(range).domain(domain);
  } else if (scaleType === 'linear') {
    scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().range(range).domain(domain);

    if (roundDomains) {
      scale = scale.nice();
    }
  } else if (scaleType === 'ordinal') {
    scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_11__.point)().range([range[0], range[1]]).domain(domain);
  }

  return scale;
}

class BubbleChartComponent extends BaseChartComponent {
  constructor() {
    super(...arguments);
    this.showGridLines = true;
    this.legend = false;
    this.legendTitle = 'Legend';
    this.legendPosition = 'right';
    this.xAxis = true;
    this.yAxis = true;
    this.trimXAxisTicks = true;
    this.trimYAxisTicks = true;
    this.rotateXAxisTicks = true;
    this.maxXAxisTickLength = 16;
    this.maxYAxisTickLength = 16;
    this.roundDomains = false;
    this.maxRadius = 10;
    this.minRadius = 3;
    this.schemeType = 'ordinal';
    this.tooltipDisabled = false;
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.scaleType = 'linear';
    this.margin = [10, 20, 10, 20];
    this.bubblePadding = [0, 0, 0, 0];
    this.xAxisHeight = 0;
    this.yAxisWidth = 0;
    this.activeEntries = [];
  }

  update() {
    super.update();
    this.dims = calculateViewDimensions({
      width: this.width,
      height: this.height,
      margins: this.margin,
      showXAxis: this.xAxis,
      showYAxis: this.yAxis,
      xAxisHeight: this.xAxisHeight,
      yAxisWidth: this.yAxisWidth,
      showXLabel: this.showXAxisLabel,
      showYLabel: this.showYAxisLabel,
      showLegend: this.legend,
      legendType: this.schemeType,
      legendPosition: this.legendPosition
    });
    this.seriesDomain = this.results.map(d => d.name);
    this.rDomain = this.getRDomain();
    this.xDomain = this.getXDomain();
    this.yDomain = this.getYDomain();
    this.transform = `translate(${this.dims.xOffset},${this.margin[0]})`;
    const colorDomain = this.schemeType === 'ordinal' ? this.seriesDomain : this.rDomain;
    this.colors = new ColorHelper(this.scheme, this.schemeType, colorDomain, this.customColors);
    this.data = this.results;
    this.minRadius = Math.max(this.minRadius, 1);
    this.maxRadius = Math.max(this.maxRadius, 1);
    this.rScale = this.getRScale(this.rDomain, [this.minRadius, this.maxRadius]);
    this.bubblePadding = [0, 0, 0, 0];
    this.setScales();
    this.bubblePadding = this.getBubblePadding();
    this.setScales();
    this.legendOptions = this.getLegendOptions();
    this.clipPathId = 'clip' + id().toString();
    this.clipPath = `url(#${this.clipPathId})`;
  }

  hideCircles() {
    this.deactivateAll();
  }

  onClick(data, series) {
    if (series) {
      data.series = series.name;
    }

    this.select.emit(data);
  }

  getBubblePadding() {
    let yMin = 0;
    let xMin = 0;
    let yMax = this.dims.height;
    let xMax = this.dims.width;

    for (const s of this.data) {
      for (const d of s.series) {
        const r = this.rScale(d.r);
        const cx = this.xScaleType === 'linear' ? this.xScale(Number(d.x)) : this.xScale(d.x);
        const cy = this.yScaleType === 'linear' ? this.yScale(Number(d.y)) : this.yScale(d.y);
        xMin = Math.max(r - cx, xMin);
        yMin = Math.max(r - cy, yMin);
        yMax = Math.max(cy + r, yMax);
        xMax = Math.max(cx + r, xMax);
      }
    }

    xMax = Math.max(xMax - this.dims.width, 0);
    yMax = Math.max(yMax - this.dims.height, 0);
    return [yMin, xMax, yMax, xMin];
  }

  setScales() {
    let width = this.dims.width;

    if (this.xScaleMin === undefined && this.xScaleMax === undefined) {
      width = width - this.bubblePadding[1];
    }

    let height = this.dims.height;

    if (this.yScaleMin === undefined && this.yScaleMax === undefined) {
      height = height - this.bubblePadding[2];
    }

    this.xScale = this.getXScale(this.xDomain, width);
    this.yScale = this.getYScale(this.yDomain, height);
  }

  getYScale(domain, height) {
    return getScale(domain, [height, this.bubblePadding[0]], this.yScaleType, this.roundDomains);
  }

  getXScale(domain, width) {
    return getScale(domain, [this.bubblePadding[3], width], this.xScaleType, this.roundDomains);
  }

  getRScale(domain, range) {
    const scale = (0,d3_scale__WEBPACK_IMPORTED_MODULE_10__["default"])().range(range).domain(domain);
    return this.roundDomains ? scale.nice() : scale;
  }

  getLegendOptions() {
    const opts = {
      scaleType: this.schemeType,
      colors: undefined,
      domain: [],
      position: this.legendPosition,
      title: undefined
    };

    if (opts.scaleType === 'ordinal') {
      opts.domain = this.seriesDomain;
      opts.colors = this.colors;
      opts.title = this.legendTitle;
    } else {
      opts.domain = this.rDomain;
      opts.colors = this.colors.scale;
    }

    return opts;
  }

  getXDomain() {
    const values = [];

    for (const results of this.results) {
      for (const d of results.series) {
        if (!values.includes(d.x)) {
          values.push(d.x);
        }
      }
    }

    this.xScaleType = getScaleType(values);
    return getDomain(values, this.xScaleType, this.autoScale, this.xScaleMin, this.xScaleMax);
  }

  getYDomain() {
    const values = [];

    for (const results of this.results) {
      for (const d of results.series) {
        if (!values.includes(d.y)) {
          values.push(d.y);
        }
      }
    }

    this.yScaleType = getScaleType(values);
    return getDomain(values, this.yScaleType, this.autoScale, this.yScaleMin, this.yScaleMax);
  }

  getRDomain() {
    let min = Infinity;
    let max = -Infinity;

    for (const results of this.results) {
      for (const d of results.series) {
        const value = Number(d.r) || 1;
        min = Math.min(min, value);
        max = Math.max(max, value);
      }
    }

    return [min, max];
  }

  updateYAxisWidth({
    width
  }) {
    this.yAxisWidth = width;
    this.update();
  }

  updateXAxisHeight({
    height
  }) {
    this.xAxisHeight = height;
    this.update();
  }

  onActivate(item) {
    const idx = this.activeEntries.findIndex(d => {
      return d.name === item.name;
    });

    if (idx > -1) {
      return;
    }

    this.activeEntries = [item, ...this.activeEntries];
    this.activate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

  onDeactivate(item) {
    const idx = this.activeEntries.findIndex(d => {
      return d.name === item.name;
    });
    this.activeEntries.splice(idx, 1);
    this.activeEntries = [...this.activeEntries];
    this.deactivate.emit({
      value: item,
      entries: this.activeEntries
    });
  }

  deactivateAll() {
    this.activeEntries = [...this.activeEntries];

    for (const entry of this.activeEntries) {
      this.deactivate.emit({
        value: entry,
        entries: []
      });
    }

    this.activeEntries = [];
  }

  trackBy(index, item) {
    return item.name;
  }

}

BubbleChartComponent.ɵfac = /*@__PURE__*/function () {
  let ɵBubbleChartComponent_BaseFactory;
  return function BubbleChartComponent_Factory(t) {
    return (ɵBubbleChartComponent_BaseFactory || (ɵBubbleChartComponent_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](BubbleChartComponent)))(t || BubbleChartComponent);
  };
}();

BubbleChartComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: BubbleChartComponent,
  selectors: [["ngx-charts-bubble-chart"]],
  contentQueries: function BubbleChartComponent_ContentQueries(rf, ctx, dirIndex) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"](dirIndex, _c21, 5);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.tooltipTemplate = _t.first);
    }
  },
  hostBindings: function BubbleChartComponent_HostBindings(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("mouseleave", function BubbleChartComponent_mouseleave_HostBindingHandler() {
        return ctx.hideCircles();
      });
    }
  },
  inputs: {
    showGridLines: "showGridLines",
    legend: "legend",
    legendTitle: "legendTitle",
    legendPosition: "legendPosition",
    xAxis: "xAxis",
    yAxis: "yAxis",
    trimXAxisTicks: "trimXAxisTicks",
    trimYAxisTicks: "trimYAxisTicks",
    rotateXAxisTicks: "rotateXAxisTicks",
    maxXAxisTickLength: "maxXAxisTickLength",
    maxYAxisTickLength: "maxYAxisTickLength",
    roundDomains: "roundDomains",
    maxRadius: "maxRadius",
    minRadius: "minRadius",
    schemeType: "schemeType",
    tooltipDisabled: "tooltipDisabled",
    showXAxisLabel: "showXAxisLabel",
    showYAxisLabel: "showYAxisLabel",
    xAxisLabel: "xAxisLabel",
    yAxisLabel: "yAxisLabel",
    xAxisTickFormatting: "xAxisTickFormatting",
    yAxisTickFormatting: "yAxisTickFormatting",
    xAxisTicks: "xAxisTicks",
    yAxisTicks: "yAxisTicks",
    autoScale: "autoScale",
    xScaleMin: "xScaleMin",
    xScaleMax: "xScaleMax",
    yScaleMin: "yScaleMin",
    yScaleMax: "yScaleMax"
  },
  outputs: {
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]],
  decls: 10,
  vars: 20,
  consts: [[3, "view", "showLegend", "activeEntries", "legendOptions", "animations", "legendLabelClick", "legendLabelActivate", "legendLabelDeactivate"], [1, "bubble-chart", "chart"], ["ngx-charts-x-axis", "", 3, "showGridLines", "dims", "xScale", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], ["ngx-charts-y-axis", "", 3, "showGridLines", "yScale", "dims", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged", 4, "ngIf"], ["x", "0", "y", "0", 1, "bubble-chart-area", 2, "fill", "rgb(255, 0, 0)", "opacity", "0", "cursor", "auto", 3, "mouseenter"], [4, "ngFor", "ngForOf", "ngForTrackBy"], ["ngx-charts-x-axis", "", 3, "showGridLines", "dims", "xScale", "showLabel", "labelText", "trimTicks", "rotateTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-y-axis", "", 3, "showGridLines", "yScale", "dims", "showLabel", "labelText", "trimTicks", "maxTickLength", "tickFormatting", "ticks", "dimensionsChanged"], ["ngx-charts-bubble-series", "", 3, "xScale", "yScale", "rScale", "xScaleType", "yScaleType", "xAxisLabel", "yAxisLabel", "colors", "data", "activeEntries", "tooltipDisabled", "tooltipTemplate", "select", "activate", "deactivate"]],
  template: function BubbleChartComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "ngx-charts-chart", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("legendLabelClick", function BubbleChartComponent_Template_ngx_charts_chart_legendLabelClick_0_listener($event) {
        return ctx.onClick($event);
      })("legendLabelActivate", function BubbleChartComponent_Template_ngx_charts_chart_legendLabelActivate_0_listener($event) {
        return ctx.onActivate($event);
      })("legendLabelDeactivate", function BubbleChartComponent_Template_ngx_charts_chart_legendLabelDeactivate_0_listener($event) {
        return ctx.onDeactivate($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "defs")(2, "clipPath");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](3, "rect");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "g", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](5, BubbleChartComponent__svg_g_5_Template, 1, 10, "g", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](6, BubbleChartComponent__svg_g_6_Template, 1, 9, "g", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "rect", 4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("mouseenter", function BubbleChartComponent_Template__svg_rect_mouseenter_7_listener() {
        return ctx.deactivateAll();
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "g");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](9, BubbleChartComponent__svg_g_9_Template, 2, 13, "g", 5);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("view", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](17, _c23, ctx.width, ctx.height))("showLegend", ctx.legend)("activeEntries", ctx.activeEntries)("legendOptions", ctx.legendOptions)("animations", ctx.animations);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("id", ctx.clipPathId);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("width", ctx.dims.width + 10)("height", ctx.dims.height + 10)("transform", "translate(-5, -5)");
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.xAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.yAxis);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("width", ctx.dims.width)("height", ctx.dims.height);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("clip-path", ctx.clipPath);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.data)("ngForTrackBy", ctx.trackBy);
    }
  },
  dependencies: function () {
    return [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, XAxisComponent, YAxisComponent, ChartComponent, BubbleSeriesComponent];
  },
  styles: [_c24],
  encapsulation: 2,
  data: {
    animation: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 1
    }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 0
    }))])])]
  },
  changeDetection: 0
});
BubbleChartComponent.propDecorators = {
  showGridLines: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legend: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendTitle: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  legendPosition: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxis: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showXAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  showYAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  trimYAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  rotateXAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxXAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxYAxisTickLength: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTickFormatting: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisTicks: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  roundDomains: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  maxRadius: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  minRadius: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  autoScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  schemeType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScaleMin: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScaleMax: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScaleMin: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScaleMax: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
    args: ['tooltipTemplate']
  }],
  hideCircles: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['mouseleave']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](BubbleChartComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'ngx-charts-bubble-chart',
      template: `
    <ngx-charts-chart
      [view]="[width, height]"
      [showLegend]="legend"
      [activeEntries]="activeEntries"
      [legendOptions]="legendOptions"
      [animations]="animations"
      (legendLabelClick)="onClick($event)"
      (legendLabelActivate)="onActivate($event)"
      (legendLabelDeactivate)="onDeactivate($event)"
    >
      <svg:defs>
        <svg:clipPath [attr.id]="clipPathId">
          <svg:rect
            [attr.width]="dims.width + 10"
            [attr.height]="dims.height + 10"
            [attr.transform]="'translate(-5, -5)'"
          />
        </svg:clipPath>
      </svg:defs>
      <svg:g [attr.transform]="transform" class="bubble-chart chart">
        <svg:g
          ngx-charts-x-axis
          *ngIf="xAxis"
          [showGridLines]="showGridLines"
          [dims]="dims"
          [xScale]="xScale"
          [showLabel]="showXAxisLabel"
          [labelText]="xAxisLabel"
          [trimTicks]="trimXAxisTicks"
          [rotateTicks]="rotateXAxisTicks"
          [maxTickLength]="maxXAxisTickLength"
          [tickFormatting]="xAxisTickFormatting"
          [ticks]="xAxisTicks"
          (dimensionsChanged)="updateXAxisHeight($event)"
        />
        <svg:g
          ngx-charts-y-axis
          *ngIf="yAxis"
          [showGridLines]="showGridLines"
          [yScale]="yScale"
          [dims]="dims"
          [showLabel]="showYAxisLabel"
          [labelText]="yAxisLabel"
          [trimTicks]="trimYAxisTicks"
          [maxTickLength]="maxYAxisTickLength"
          [tickFormatting]="yAxisTickFormatting"
          [ticks]="yAxisTicks"
          (dimensionsChanged)="updateYAxisWidth($event)"
        />
        <svg:rect
          class="bubble-chart-area"
          x="0"
          y="0"
          [attr.width]="dims.width"
          [attr.height]="dims.height"
          style="fill: rgb(255, 0, 0); opacity: 0; cursor: 'auto';"
          (mouseenter)="deactivateAll()"
        />
        <svg:g [attr.clip-path]="clipPath">
          <svg:g *ngFor="let series of data; trackBy: trackBy" [@animationState]="'active'">
            <svg:g
              ngx-charts-bubble-series
              [xScale]="xScale"
              [yScale]="yScale"
              [rScale]="rScale"
              [xScaleType]="xScaleType"
              [yScaleType]="yScaleType"
              [xAxisLabel]="xAxisLabel"
              [yAxisLabel]="yAxisLabel"
              [colors]="colors"
              [data]="series"
              [activeEntries]="activeEntries"
              [tooltipDisabled]="tooltipDisabled"
              [tooltipTemplate]="tooltipTemplate"
              (select)="onClick($event, series)"
              (activate)="onActivate($event)"
              (deactivate)="onDeactivate($event)"
            />
          </svg:g>
        </svg:g>
      </svg:g>
    </ngx-charts-chart>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ViewEncapsulation.None,
      animations: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 1
      }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(500, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 0
      }))])])],
      styles: [".ngx-charts{float:left;overflow:visible}.ngx-charts .arc,.ngx-charts .bar,.ngx-charts .circle{cursor:pointer}.ngx-charts .arc.active,.ngx-charts .arc:hover,.ngx-charts .bar.active,.ngx-charts .bar:hover,.ngx-charts .card.active,.ngx-charts .card:hover,.ngx-charts .cell.active,.ngx-charts .cell:hover{opacity:.8;transition:opacity .1s ease-in-out}.ngx-charts .arc:focus,.ngx-charts .bar:focus,.ngx-charts .card:focus,.ngx-charts .cell:focus{outline:none}.ngx-charts .arc.hidden,.ngx-charts .bar.hidden,.ngx-charts .card.hidden,.ngx-charts .cell.hidden{display:none}.ngx-charts g:focus{outline:none}.ngx-charts .area-series.inactive,.ngx-charts .line-series-range.inactive,.ngx-charts .line-series.inactive,.ngx-charts .polar-series-area.inactive,.ngx-charts .polar-series-path.inactive{opacity:.2;transition:opacity .1s ease-in-out}.ngx-charts .line-highlight{display:none}.ngx-charts .line-highlight.active{display:block}.ngx-charts .area{opacity:.6}.ngx-charts .circle:hover{cursor:pointer}.ngx-charts .label{font-size:12px;font-weight:400}.ngx-charts .tooltip-anchor{fill:#000}.ngx-charts .gridline-path{fill:none;stroke:#ddd;stroke-width:1}.ngx-charts .refline-path{stroke:#a8b2c7;stroke-dasharray:5;stroke-dashoffset:5;stroke-width:1}.ngx-charts .refline-label{font-size:9px}.ngx-charts .reference-area{fill:#000;fill-opacity:.05}.ngx-charts .gridline-path-dotted{fill:none;stroke:#ddd;stroke-dasharray:1,20;stroke-dashoffset:3;stroke-width:1}.ngx-charts .grid-panel rect{fill:none}.ngx-charts .grid-panel.odd rect{fill:rgba(0,0,0,.05)}"]
    }]
  }], null, {
    showGridLines: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legend: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendTitle: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    legendPosition: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxis: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    trimYAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    rotateXAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxXAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxYAxisTickLength: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    roundDomains: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    maxRadius: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    minRadius: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    schemeType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    hideCircles: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['mouseleave']
    }],
    showXAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    showYAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTickFormatting: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisTicks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    autoScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScaleMin: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScaleMax: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScaleMin: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScaleMax: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ContentChild,
      args: ['tooltipTemplate']
    }]
  });
})();

class BubbleSeriesComponent {
  constructor() {
    this.tooltipDisabled = false;
    this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
  }

  ngOnChanges(changes) {
    this.update();
  }

  update() {
    this.circles = this.getCircles();
  }

  getCircles() {
    const seriesName = this.data.name;
    return this.data.series.map((d, i) => {
      if (typeof d.y !== 'undefined' && typeof d.x !== 'undefined') {
        const y = d.y;
        const x = d.x;
        const r = d.r;
        const radius = this.rScale(r || 1);
        const tooltipLabel = formatLabel(d.name);
        const cx = this.xScaleType === 'linear' ? this.xScale(Number(x)) : this.xScale(x);
        const cy = this.yScaleType === 'linear' ? this.yScale(Number(y)) : this.yScale(y);
        const color = this.colors.scaleType === 'linear' ? this.colors.getColor(r) : this.colors.getColor(seriesName);
        const isActive = !this.activeEntries.length ? true : this.isActive({
          name: seriesName
        });
        const opacity = isActive ? 1 : 0.3;
        const data = Object.assign({}, d, {
          series: seriesName,
          name: d.name,
          value: d.y,
          x: d.x,
          radius: d.r
        });
        return {
          data,
          x,
          y,
          r,
          classNames: [`circle-data-${i}`],
          value: y,
          label: x,
          cx,
          cy,
          radius,
          tooltipLabel,
          color,
          opacity,
          seriesName,
          isActive,
          transform: `translate(${cx},${cy})`
        };
      }
    }).filter(circle => circle !== undefined);
  }

  getTooltipText(circle) {
    const hasRadius = typeof circle.r !== 'undefined';
    const hasTooltipLabel = circle.tooltipLabel && circle.tooltipLabel.length;
    const hasSeriesName = circle.seriesName && circle.seriesName.length;
    const radiusValue = hasRadius ? formatLabel(circle.r) : '';
    const xAxisLabel = this.xAxisLabel && this.xAxisLabel !== '' ? `${this.xAxisLabel}:` : '';
    const yAxisLabel = this.yAxisLabel && this.yAxisLabel !== '' ? `${this.yAxisLabel}:` : '';
    const x = formatLabel(circle.x);
    const y = formatLabel(circle.y);
    const name = hasSeriesName && hasTooltipLabel ? `${circle.seriesName} • ${circle.tooltipLabel}` : circle.seriesName + circle.tooltipLabel;
    const tooltipTitle = hasSeriesName || hasTooltipLabel ? `<span class="tooltip-label">${escapeLabel(name)}</span>` : '';
    return `
      ${tooltipTitle}
      <span class="tooltip-label">
        <label>${escapeLabel(xAxisLabel)}</label> ${escapeLabel(x)}<br />
        <label>${escapeLabel(yAxisLabel)}</label> ${escapeLabel(y)}
      </span>
      <span class="tooltip-val">
        ${escapeLabel(radiusValue)}
      </span>
    `;
  }

  onClick(data) {
    this.select.emit(data);
  }

  isActive(entry) {
    if (!this.activeEntries) return false;
    const item = this.activeEntries.find(d => {
      return entry.name === d.name;
    });
    return item !== undefined;
  }

  isVisible(circle) {
    if (this.activeEntries.length > 0) {
      return this.isActive({
        name: circle.seriesName
      });
    }

    return circle.opacity !== 0;
  }

  activateCircle(circle) {
    circle.barVisible = true;
    this.activate.emit({
      name: this.data.name
    });
  }

  deactivateCircle(circle) {
    circle.barVisible = false;
    this.deactivate.emit({
      name: this.data.name
    });
  }

  trackBy(index, circle) {
    return `${circle.data.series} ${circle.data.name}`;
  }

}

BubbleSeriesComponent.ɵfac = function BubbleSeriesComponent_Factory(t) {
  return new (t || BubbleSeriesComponent)();
};

BubbleSeriesComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: BubbleSeriesComponent,
  selectors: [["g", "ngx-charts-bubble-series", ""]],
  inputs: {
    tooltipDisabled: "tooltipDisabled",
    data: "data",
    xScale: "xScale",
    yScale: "yScale",
    rScale: "rScale",
    xScaleType: "xScaleType",
    yScaleType: "yScaleType",
    colors: "colors",
    visibleValue: "visibleValue",
    activeEntries: "activeEntries",
    xAxisLabel: "xAxisLabel",
    yAxisLabel: "yAxisLabel",
    tooltipTemplate: "tooltipTemplate"
  },
  outputs: {
    select: "select",
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c30,
  decls: 1,
  vars: 2,
  consts: [[4, "ngFor", "ngForOf", "ngForTrackBy"], ["ngx-charts-circle", "", "ngx-tooltip", "", 1, "circle", 3, "cx", "cy", "r", "fill", "pointerEvents", "data", "classNames", "tooltipDisabled", "tooltipPlacement", "tooltipType", "tooltipTitle", "tooltipTemplate", "tooltipContext", "select", "activate", "deactivate"]],
  template: function BubbleSeriesComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, BubbleSeriesComponent__svg_g_0_Template, 3, 19, "g", 0);
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.circles)("ngForTrackBy", ctx.trackBy);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, TooltipDirective, CircleComponent],
  encapsulation: 2,
  data: {
    animation: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':enter', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 0,
      transform: 'scale(0)'
    }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(250, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
      opacity: 1,
      transform: 'scale(1)'
    }))])])]
  },
  changeDetection: 0
});
BubbleSeriesComponent.propDecorators = {
  data: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  rScale: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xScaleType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yScaleType: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  colors: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  visibleValue: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  activeEntries: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  xAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  yAxisLabel: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipDisabled: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  tooltipTemplate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  select: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](BubbleSeriesComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-bubble-series]',
      template: `
    <svg:g *ngFor="let circle of circles; trackBy: trackBy">
      <svg:g [attr.transform]="circle.transform">
        <svg:g
          ngx-charts-circle
          [@animationState]="'active'"
          class="circle"
          [cx]="0"
          [cy]="0"
          [r]="circle.radius"
          [fill]="circle.color"
          [style.opacity]="circle.opacity"
          [class.active]="circle.isActive"
          [pointerEvents]="'all'"
          [data]="circle.value"
          [classNames]="circle.classNames"
          (select)="onClick(circle.data)"
          (activate)="activateCircle(circle)"
          (deactivate)="deactivateCircle(circle)"
          ngx-tooltip
          [tooltipDisabled]="tooltipDisabled"
          [tooltipPlacement]="'top'"
          [tooltipType]="'tooltip'"
          [tooltipTitle]="tooltipTemplate ? undefined : getTooltipText(circle)"
          [tooltipTemplate]="tooltipTemplate"
          [tooltipContext]="circle.data"
        />
      </svg:g>
    </svg:g>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      animations: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.trigger)('animationState', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.transition)(':enter', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 0,
        transform: 'scale(0)'
      }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.animate)(250, (0,_angular_animations__WEBPACK_IMPORTED_MODULE_5__.style)({
        opacity: 1,
        transform: 'scale(1)'
      }))])])]
    }]
  }], function () {
    return [];
  }, {
    tooltipDisabled: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    select: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    data: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    rScale: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xScaleType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yScaleType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    colors: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    visibleValue: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    activeEntries: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    xAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    yAxisLabel: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    tooltipTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class BubbleChartModule {}

BubbleChartModule.ɵfac = function BubbleChartModule_Factory(t) {
  return new (t || BubbleChartModule)();
};

BubbleChartModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({
  type: BubbleChartModule
});
BubbleChartModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({
  imports: [ChartCommonModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](BubbleChartModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.NgModule,
    args: [{
      imports: [ChartCommonModule],
      declarations: [BubbleChartComponent, BubbleSeriesComponent],
      exports: [BubbleChartComponent, BubbleSeriesComponent]
    }]
  }], null, null);
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](BubbleChartModule, {
    declarations: [BubbleChartComponent, BubbleSeriesComponent],
    imports: [ChartCommonModule],
    exports: [BubbleChartComponent, BubbleSeriesComponent]
  });
})();

class HeatMapCellComponent {
  constructor(element) {
    this.gradient = false;
    this.animations = true;
    this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.element = element.nativeElement;
  }

  ngOnChanges(changes) {
    this.transform = `translate(${this.x} , ${this.y})`;
    this.startOpacity = 0.3;
    this.gradientId = 'grad' + id().toString();
    this.gradientUrl = `url(#${this.gradientId})`;
    this.gradientStops = this.getGradientStops();

    if (this.animations) {
      this.loadAnimation();
    }
  }

  getGradientStops() {
    return [{
      offset: 0,
      color: this.fill,
      opacity: this.startOpacity
    }, {
      offset: 100,
      color: this.fill,
      opacity: 1
    }];
  }

  loadAnimation() {
    const node = (0,d3_selection__WEBPACK_IMPORTED_MODULE_8__["default"])(this.element).select('.cell');
    node.attr('opacity', 0);
    this.animateToCurrentForm();
  }

  animateToCurrentForm() {
    const node = (0,d3_selection__WEBPACK_IMPORTED_MODULE_8__["default"])(this.element).select('.cell');
    node.transition().duration(750).attr('opacity', 1);
  }

  onClick() {
    this.select.emit(this.data);
  }

  onMouseEnter() {
    this.activate.emit(this.data);
  }

  onMouseLeave() {
    this.deactivate.emit(this.data);
  }

}

HeatMapCellComponent.ɵfac = function HeatMapCellComponent_Factory(t) {
  return new (t || HeatMapCellComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef));
};

HeatMapCellComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: HeatMapCellComponent,
  selectors: [["g", "ngx-charts-heat-map-cell", ""]],
  hostBindings: function HeatMapCellComponent_HostBindings(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("mouseenter", function HeatMapCellComponent_mouseenter_HostBindingHandler() {
        return ctx.onMouseEnter();
      })("mouseleave", function HeatMapCellComponent_mouseleave_HostBindingHandler() {
        return ctx.onMouseLeave();
      });
    }
  },
  inputs: {
    gradient: "gradient",
    animations: "animations",
    fill: "fill",
    x: "x",
    y: "y",
    width: "width",
    height: "height",
    data: "data",
    label: "label"
  },
  outputs: {
    select: "select",
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c31,
  decls: 3,
  vars: 5,
  consts: [[1, "cell"], [4, "ngIf"], ["rx", "3", 1, "cell", 2, "cursor", "pointer", 3, "click"], ["ngx-charts-svg-linear-gradient", "", "orientation", "vertical", 3, "name", "stops"]],
  template: function HeatMapCellComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "g", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, HeatMapCellComponent__svg_defs_1_Template, 2, 2, "defs", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "rect", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function HeatMapCellComponent_Template__svg_rect_click_2_listener() {
        return ctx.onClick();
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("transform", ctx.transform);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.gradient);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("fill", ctx.gradient ? ctx.gradientUrl : ctx.fill)("width", ctx.width)("height", ctx.height);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, SvgLinearGradientComponent],
  encapsulation: 2,
  changeDetection: 0
});

HeatMapCellComponent.ctorParameters = () => [{
  type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
}];

HeatMapCellComponent.propDecorators = {
  fill: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  x: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  y: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  width: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  height: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  data: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  label: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  gradient: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  animations: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
  }],
  select: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  activate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  deactivate: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
  }],
  onMouseEnter: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['mouseenter']
  }],
  onMouseLeave: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
    args: ['mouseleave']
  }]
};

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](HeatMapCellComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'g[ngx-charts-heat-map-cell]',
      template: `
    <svg:g [attr.transform]="transform" class="cell">
      <defs *ngIf="gradient">
        <svg:g ngx-charts-svg-linear-gradient orientation="vertical" [name]="gradientId" [stops]="gradientStops" />
      </defs>
      <svg:rect
        [attr.fill]="gradient ? gradientUrl : fill"
        rx="3"
        [attr.width]="width"
        [attr.height]="height"
        class="cell"
        style="cursor: pointer"
        (click)="onClick()"
      />
    </svg:g>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush
    }]
  }], function () {
    return [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef
    }];
  }, {
    gradient: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    animations: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    select: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    activate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    deactivate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Output
    }],
    onMouseEnter: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['mouseenter']
    }],
    onMouseLeave: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.HostListener,
      args: ['mouseleave']
    }],
    fill: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    x: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    y: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    width: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    height: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    data: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }],
    label: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Input
    }]
  });
})();

class HeatCellSeriesComponent {
  constructor() {
    this.tooltipDisabled = false;
    this.animations = true;
    this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.activate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    this.deactivate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
  }

  ngOnInit() {
    if (!this.tooltipText) {
      this.tooltipText = this.getTooltipText;
    }
  }

  ngOnChanges(changes) {
    this.update();
  }

  update() {
    this.cells = this.getCells();
  }

  getCells() {
    const cells = [];
    this.data.map(row => {
      row.series.map(cell => {
        const value = cell.value;
        cell.series = row.name;
        cells.push({
          row,
          cell,
          x: this.xScale(row.name),
          y: this.yScale(cell.name),
          width: this.xScale.bandwidth(),
          height: this.yScale.bandwidth(),
          fill: this.colors.getColor(value),
          data: value,
          label: formatLabel(cell.name),
          series: row.name
        });
      });
    });
    return cells;
  }

  getTooltipText({
    label,
    data,
    series
  }) {
    return `
      <span class="tooltip-label">${escapeLabel(series)} • ${escapeLabel(label)}</span>
      <span class="tooltip-val">${data.toLocaleString()}</span>
    `;
  }

  trackBy(index, item) {
    return item.tooltipText;
  }

  onClick(data) {
    this.select.emit(data);
  }

}

HeatCellSeriesComponent.ɵfac = function HeatCellSeriesComponent_Factory(t) {
  return new (t || HeatCellSeriesComponent)();
};

HeatCellSeriesComponent.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: HeatCellSeriesComponent,
  selectors: [["g", "ngx-charts-heat-map-cell-series", ""]],
  inputs: {
    tooltipDisabled: "tooltipDisabled",
    animations: "animations",
    tooltipText: "tooltipText",
    data: "data",
    colors: "colors",
    xScale: "xScale",
    yScale: "yScale",
    gradient: "gradient",
    tooltipTemplate: "tooltipTemplate"
  },
  outputs: {
    select: "select",
    activate: "activate",
    deactivate: "deactivate"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]],
  attrs: _c32,
  decls: 1,
  vars: 2,
  consts: [["ngx-charts-heat-map-cell", "", "ngx-tooltip", "", 3, "x", "y", "width", "height", "fill", "data", "gradient", "animations", "tooltipDisabled", "tooltipPlacement", "tooltipType", "tooltipTitle", "tooltipTemplate", "tooltipContext", "select", "activate", "deactivate", 4, "ngFor", "ngForOf", "ngForTrackBy"], ["ngx-charts-heat-map-cell", "", "ngx-tooltip", "", 3, "x", "y", "width", "height", "fill", "data", "gradient", "animations", "tooltipDisabled", "tooltipPlacement", "tooltipType", "tooltipTitle", "tooltipTemplate", "tooltipContext", "select", "activate", "deactivate"]],
  template: function HeatCellSeriesComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, HeatCellSeriesComponent__svg_g_0_Template, 1, 18, "g", 0);
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.cells)("ngForTrackBy", ctx.trackBy);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.Ng