<?php
/**
 * Plugin Name: Custom Carousel
 * Description: Custom carousel using PHP, MySQL, and Elementor.
 * Version: 1.0
 */

// Shortcode para exibir o carrossel
function custom_carousel_shortcode($atts) {
    ob_start();
    
    $host = '162.241.101.209';
    $dbname = 'appcollo_mautic_app';
    $username = "appcollo_mautic_app";
    $password = "webuser@9009";
    $dsn = "mysql:host=$host;dbname=$dbname;charset=utf8";
    
    $pdo = new PDO($dsn, $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->exec("set names utf8");

    $query1 = "SELECT * FROM `process_list` WHERE `status` = 'read' AND `show` = 'true' ORDER BY `order` ASC";
    $stmt1 = $pdo->prepare($query1);
    $stmt1->execute();
    $result1 = $stmt1->fetchAll(PDO::FETCH_ASSOC);

    $finalResults = [];
    
    function getCategory($minAge, $maxAge) {
        if ($maxAge >= 14 && $minAge <= 18) {
            return '14 aos 18';
        } elseif ($maxAge >= 19 && $minAge <= 30) {
            return '19 aos 30';
        } elseif ($maxAge >= 31 && $minAge <= 40) {
            return '31 aos 40';
        } elseif ($maxAge >= 41 && $minAge <= 50) {
            return '41 aos 50';
        } elseif ($maxAge > 50) {
            return 'Acima dos 50';
        } else {
            return 'Desconhecida';
        }
    }
    
    $niveisEscolaridade = array(
        'curso-tecnico' => 'Curso técnico',
        'ens-fun-nivel' => 'Ensino Fundamental',
        'ens-med-nivel' => 'Ensino Médio',
        'ens-sup-nivel' => 'Ensino Superior',
        'ens-sup-nivel2' => 'Ensino Superior',
        'ens-sup-nivel3' => 'Ensino Superior',
        'ens-sup-nivel4' => 'Ensino Superior',
        'ens-comp-nivel' => 'Supletivo',
        'curso-extra' => 'Outros Cursos',
        'mba' => 'MBA'
    );
    
    $frasesCativadoras = array(
        "Junte-se a nós para criar um futuro incrível juntos!",
        "Estamos em busca de talentos apaixonados para fazer parte da nossa equipe.",
        "Se você procura desafios emocionantes e oportunidades de crescimento, este é o lugar certo.",
        "Venha fazer parte de uma equipe que valoriza a inovação e a criatividade.",
        "Aqui, sua paixão e habilidades podem florescer em um ambiente colaborativo.",
        "Trabalhe conosco e ajude a moldar a indústria com suas ideias únicas.",
        "Nós acreditamos no seu potencial e queremos ajudá-lo a alcançar seus objetivos.",
        "Seja parte de uma equipe que se orgulha de alcançar resultados excepcionais.",
        "Oportunidades ilimitadas aguardam você em nossa empresa inovadora.",
        "Nosso compromisso com a excelência começa com pessoas incríveis como você.",
        "Aqui, você será desafiado a crescer e superar suas próprias expectativas.",
        "Venha para um ambiente onde cada dia é uma oportunidade de aprendizado e evolução.",
        "Nosso sucesso é construído sobre uma equipe diversificada e talentosa como a sua.",
        "Juntos, podemos conquistar novos horizontes e alcançar o extraordinário.",
        "Oferecemos um ambiente de trabalho inspirador onde sua criatividade pode prosperar.",
        "Seja parte de uma cultura que prioriza o desenvolvimento pessoal e profissional.",
        "Nossa equipe é unida por uma paixão comum por excelência e inovação.",
        "Se você busca um lugar onde seu trabalho faça a diferença, você encontrou.",
        "Valorizamos cada membro da nossa equipe e reconhecemos suas contribuições únicas.",
        "Aqui, você terá as ferramentas e o suporte necessário para alcançar o sucesso.",
        "Queremos conhecê-lo e descobrir como suas habilidades podem enriquecer nossa equipe.",
        "Trabalhe conosco para criar soluções impactantes que transformam o mundo.",
        "Acreditamos que cada indivíduo traz algo especial para nossa jornada rumo ao sucesso.",
        "Buscamos pessoas comprometidas que compartilhem nossa paixão por fazer a diferença.",
        "Estamos à procura de mentes curiosas e ambiciosas para se juntarem à nossa equipe.",
        "Venha para um ambiente onde seu trabalho seja mais do que apenas um emprego.",
        "Nossa equipe é movida por desafios, determinação e uma visão ousada do futuro.",
        "Trabalhe onde suas ideias serão ouvidas e suas realizações serão celebradas.",
        "Você é mais do que uma contratação – é um membro essencial da nossa família.",
        "Seja bem-vindo a um lugar onde você pode fazer parte de algo maior do que você mesmo.",
        "Nossos valores são a base do nosso sucesso, e estamos ansiosos para compartilhá-los com você.",
        "Nossa equipe é como uma comunidade, onde cada indivíduo contribui para o crescimento coletivo.",
        "Aqui, você será desafiado a expandir seus limites e a alcançar seu potencial máximo.",
        "Sua jornada conosco será repleta de oportunidades para aprender, crescer e prosperar.",
        "Junte-se a nós para construir um futuro emocionante, cheio de conquistas e realizações."
    );
    
    $query2 = "SELECT process_list, lead FROM `process_list_lead` WHERE process_list = :id";
    $stmt2 = $pdo->prepare($query2);

    foreach ($result1 as $row) {
        $id = $row['id']; 
        $data = $row['created_at']; 
        
        $stmt2->bindValue(':id', $id, PDO::PARAM_INT);
        $stmt2->execute();
        $result2 = $stmt2->fetchAll(PDO::FETCH_ASSOC);

        $leadIds = [];
        foreach ($result2 as $result) {
            $leadIds[] = $result['lead'];
        }

        if (!empty($leadIds)) {
            $leadIdsString = implode(', ', $leadIds);
            
            $query3 = "
                SELECT
                    gender,
                    MIN(birthdate) AS min_birthdate,
                    MAX(birthdate) AS max_birthdate,
                    state
                FROM `leads`
                WHERE id IN ($leadIdsString)
                GROUP BY gender, state
            ";
            $stmt3 = $pdo->prepare($query3);
            $stmt3->execute();
            $result3 = $stmt3->fetchAll(PDO::FETCH_ASSOC);
            
            
            $query4 = "
                SELECT education_level FROM `education_experience`
                WHERE lead_id IN ($leadIdsString)
                GROUP BY education_level
            ";
            $stmt4 = $pdo->prepare($query4);
            $stmt4->execute();
            $result4 = $stmt4->fetchAll(PDO::FETCH_ASSOC);
            $nivel = $result4[0]['education_level'];
            
            if (array_key_exists($nivel, $niveisEscolaridade)) {
                $nivel = $niveisEscolaridade[$nivel];
            }
            
            $escolaridade=['escolaridade'=>$nivel];

            // Calcula as idades mínimas e máximas e verifica gêneros
            $minAge = PHP_INT_MAX;
            $maxAge = 0;
            $bothGendersPresent = false;
            
            $estadosAcentuados = array(
                'Acre' => 'Acre',
                'Alagoas' => 'Alagoas',
                'Amapa' => 'Amapá',
                'Amazonas' => 'Amazonas',
                'Bahia' => 'Bahia',
                'Ceara' => 'Ceará',
                'Distrito Federal' => 'Distrito Federal',
                'Espirito Santo' => 'Espírito Santo',
                'Goias' => 'Goiás',
                'Maranhao' => 'Maranhão',
                'Mato Grosso' => 'Mato Grosso',
                'Mato Grosso do Sul' => 'Mato Grosso do Sul',
                'Minas Gerais' => 'Minas Gerais',
                'Para' => 'Pará',
                'Paraiba' => 'Paraíba',
                'Parana' => 'Paraná',
                'Pernambuco' => 'Pernambuco',
                'Piaui' => 'Piauí',
                'Rio de Janeiro' => 'Rio de Janeiro',
                'Rio Grande do Norte' => 'Rio Grande do Norte',
                'Rio Grande do Sul' => 'Rio Grande do Sul',
                'Rondonia' => 'Rondônia',
                'Roraima' => 'Roraima',
                'Santa Catarina' => 'Santa Catarina',
                'Sao Paulo' => 'São Paulo',
                'Sergipe' => 'Sergipe',
                'Tocantins' => 'Tocantins'
            );

            foreach ($result3 as $leadData) {
                $estadoSemAcento = $result3[0]['state'];
                
                // Verificar se o estado sem acento existe no array de estados acentuados
                if (array_key_exists($estadoSemAcento, $estadosAcentuados)) {
                    $estado = $estadosAcentuados[$estadoSemAcento];
                } else {
                    $estado = $estadoSemAcento;
                }
                
                $minBirthdate = $leadData['min_birthdate'];
                $maxBirthdate = $leadData['max_birthdate'];
                
                // Verifica se as datas de nascimento são válidas
                $minTimestamp = strtotime($minBirthdate);
                $maxTimestamp = strtotime($maxBirthdate);
                
                if ($minTimestamp !== false && $maxTimestamp !== false) {
                    // Calcula a idade com base no ano atual
                    $currentYear = date('Y');
                    $minYear = (int) substr($minBirthdate, 0, 4);
                    $maxYear = (int) substr($maxBirthdate, 0, 4);
                    
                    $minAgeCandidate = $currentYear - $maxYear;
                    $maxAgeCandidate = $currentYear - $minYear;
                }
                
                if ($minAgeCandidate < $minAge) {
                    $minAge = $minAgeCandidate;
                }
                if ($maxAgeCandidate > $maxAge) {
                    $maxAge = $maxAgeCandidate;
                }
                
                // Suponha que $minAge e $maxAge já foram calculados no código anterior
                $ageCategory = getCategory($minAge, $maxAge);
                
                if ($leadData['gender'] == 'Feminino' || $leadData['gender'] == 'Masculino') {
                    $bothGendersPresent = true;
                }
            }

            // Organiza os resultados na estrutura desejada
            if ($bothGendersPresent) {
                $candidatos = [
                    'sexo' => 'Todos',
                    'idade' => $ageCategory,
                    'state' => $estado
                ];
            } else {
                $gender = $result3[0]['gender'];
                $candidatos = [
                    'sexo' => ($gender == 'Feminino') ? 'Feminino' : 'Masculino',
                    'idade' => $ageCategory,
                    'state' => $estado
                ];
            }
            
            $fraseAleatoria = $frasesCativadoras[array_rand($frasesCativadoras)];
            $frase = ['texto'=>$fraseAleatoria];
            
            // Converte a string para um objeto DateTime
            $dateTime = new DateTime($data);
            
            // Formata a data para o formato desejado (apenas a data)
            $dataFormatada = $dateTime->format('Y-m-d');
            $data=['data'=>$dataFormatada];
            // Organiza os resultados na estrutura desejada
            $row = array_merge($row, $candidatos);
            $row = array_merge($row, $data);
            $row = array_merge($row, $escolaridade);
            $row = array_merge($row, $frase);
            $finalResults[] = $row;
        }
    }

    // echo json_encode($finalResults);
    //echo'<pre>';print_r($finalResults);exit;

    if (!empty($finalResults)) {
        ?>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css">
        <style>        
            body {
              font-family: Open Sans, sans-serif;
            }
            
            .carousel-container {
              position: relative;
              max-width: 800px;
              margin: 0 auto;
              display: flex;
              align-items: center;
              justify-content: space-between;
            }
            
            .carousel {
              overflow: hidden;
              margin: 0;
            }
            
            .carousel-item {
              padding: 50px 10px;
              text-align: center;
              border: 1px solid #ccc;
              min-height:320px;
              margin: 0 10px;
              flex: 0 0 calc(25% - 20px);
            }
            
            .carousel-item h2{
                color: #048C94;
                font-family: "Open Sans", Sans-serif;
                font-size: 16px;
                font-weight: 700;
                line-height: 14px;
                word-wrap: break-word;
                text-transform: uppercase;
            }
            
            .carousel-item p{
                font-family: "Open Sans", Sans-serif;
                font-size: 14px;
                text-align:left;
            }
            
            .carousel-controls {
              display: flex;
              align-items: center;
            }
            
            .prev-btn,
            .next-btn {
                background-color: #333;
                color: white;
                border: none;
                padding: 0px 13px 8px 13px;
                width: 30px;
                height: 30px;
                border-radius: 50%;
                font-size: 30px;
                display: flex;
                align-items: center;
                justify-content: center;
                cursor: pointer;
            }
            
            .prev-btn:hover,
            .next-btn:hover {
              background-color: #048c94;
            }
            
            .prev-btn:active,
            .next-btn:active {
              outline: none; 
              user-select: none;
            }
            
            .prev-btn {
              margin-right: auto;
            }
            
            .next-btn {
              margin-left: auto;
            }
            
            .no-bullets{
               list-style-type: none;
               text-align:left;
               font-size: 12px;
               padding:0;
            }
            
            .circle {
              width: 50px;
              height: 50px;
              margin: auto;
              border-radius: 50%;
              background-color: #048C94;
              display: flex;
              justify-content: center;
              align-items: center;
            }
            
            .carousel-item .elementor-icon {
                color:#fff!important;
                font-size:30px!important;
            }

        </style>
        <div class="carousel-container">
            <span class="prev-btn">&#8249;</span>
            <div class="carousel">
                <?php 
                    $index = 0; 
                    while ($index < count($finalResults)) { 
                    $row = $finalResults[$index];
                ?>
                    <div class="carousel-item">
                        <div class="elementor-icon-wrapper circle">
                			<div class="elementor-icon elementor-animation-">
                				<i aria-hidden="true" class="fas fa-address-card"></i>
                			</div>
                		</div>
                        <h2><?php echo $row['name']; ?></h2>
                        <p><?php //echo $row['texto']; ?></p>
                        <ul class="no-bullets">
                            <li><strong>Idade:</strong> <?php echo $row['idade']; ?> </li>
                            <?php
                                if (!empty($row['escolaridade'])) {
                                    echo '<li><strong>Escolaridade: </strong>' . $row['escolaridade'] . '</li>';
                                }else{
                                    echo '<li><strong>Escolaridade: </strong>Todos</li>';
                                } 
                            ?>
                            <li><strong>Sexo:</strong> <?php echo $row['sexo']; ?></li>
                            <li><strong>Disponível desde:</strong> <?php echo date('d/m/Y', strtotime($row['data'])); ?></li>
                            <li><strong>Localidade:</strong> <?php echo $row['state']; ?></li>
                        </ul>
                    </div>
                <?php $index++; } ?>
            </div>
            <span class="next-btn">&#8250;</span>
        </div>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js"></script>
        <script>
            $(document).ready(function(){
              $('.carousel').slick({
                slidesToShow: 3,
                slidesToScroll: 3,
                prevArrow: $('.prev-btn'),
                nextArrow: $('.next-btn'),
                autoplay: true,
                autoplaySpeed: 7000, // Tempo em milissegundos (2 segundos)
                responsive: [
                  {
                    breakpoint: 768,
                    settings: {
                      slidesToShow: 2,
                      slidesToScroll: 2
                    }
                  },
                  {
                    breakpoint: 480,
                    settings: {
                      slidesToShow: 1,
                      slidesToScroll: 1
                    }
                  }
                ]
              });
            });
        </script>
        <?php
    }

    return ob_get_clean();
}
add_shortcode('custom_carousel', 'custom_carousel_shortcode');
