<?php

    class CompanyBoleto extends Core {

        function get() {
            
            if(!isset($_GET['cnpj'])){
                return 'Informe o CNPJ';
                exit;
            }
            
            $cnpj = $_GET['cnpj'];
            
            $sql = "SELECT * FROM config WHERE id = 1";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute();
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($result) {
            
            // Configurações do banco de dados
            $host = $result['host'];
            $dbname = $result['dbname'];
            $user = $result['username'];
            $password = $result['password'];
            
                try {
                    // Criação da conexão PDO
                    $conn2 = new PDO("mysql:host=$host;dbname=$dbname", $user, $password);
                
                    // Configuração de opções do PDO
                    $conn2->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                
                    // Consulta SQL preparada
                    $sql = "SELECT * FROM TB_CampanhaBoleto WHERE cnpj = ?";
                    $stmt = $conn2->prepare($sql);
                    $stmt->execute([$cnpj]);
                    
                    // Fetch dos resultados como um array associativo
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                
                    // Verifica se a consulta retornou algum resultado
                    if ($result) {
                        // Retornar os resultados em formato JSON
                        header('Content-Type: application/json');
                        return json_encode($result);
                    } else {
                        // Se nenhum resultado foi encontrado, você pode retornar uma mensagem ou um JSON vazio
                        header('Content-Type: application/json');
                        return json_encode(array('message' => 'Nenhum resultado encontrado.'));
                    }
                } catch (PDOException $e) {
                    // Em caso de erro na conexão ou consulta
                    echo "Erro: " . $e->getMessage();
                }
                
                // Fecha a conexão
                $conn2 = null;
            }
        }

    }