<?php

    class Company extends Core {

        function get() {
            
            $id = $_GET['id'];
            $sql = "SELECT * FROM companies WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$id]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);

            return [ 'type' => 'OK', 'data' => $result ];

        }

        function update() {

            $id = $_POST['id'];
            $businessname = $_POST['businessName'];
            $companyname = $_POST['companyName'];
            $cnpj = $_POST['cnpj'];
            $ie = $_POST['ie'];
            $im = $_POST['im'];
            $tax_regime = $_POST['taxRegime'];
            $zip_code = $_POST['zipCode'];
            $state = $_POST['state'];
            $city = $_POST['city'];
            $street = $_POST['street'];
            $district = $_POST['district'];
            $number = $_POST['number'];
            $complement = $_POST['complement'];
            $email = $_POST['email'];
            $site = $_POST['site'];
            $facebook = $_POST['facebook'];
            $instagram = $_POST['instagram'];
            $youtube = $_POST['youtube'];
            $website = $_POST['website'];
            
            $sql = "UPDATE companies 
                SET companyname = :companyname, companyaddress1 = :companyaddress1, companyaddress2 = :companyaddress2,
                    companycity = :companycity, companystate = :companystate, companyzipcode = :companyzipcode,
                    companywebsite = :companywebsite,
                    businessname = :businessname, ie = :ie, cnpj = :cnpj, im = :im,
                    tax_regime = :tax_regime, district = :district, complement = :complement, 
                    instagram = :instagram, youtube = :youtube, facebook = :facebook
                WHERE id = :id";

            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([
                ':companyname' => $companyname,
                ':companyaddress1' => $street,
                ':companyaddress2' => $number,
                ':companycity' => $city,
                ':companystate' => $state,
                ':companyzipcode' => $zip_code,
                ':companywebsite' => $site,
                ':businessname' => $businessname,
                ':ie' => $ie,
                ':cnpj' => $cnpj,
                ':im' => $im,
                ':tax_regime' => $tax_regime,
                ':district' => $district,
                ':complement' => $complement,
                ':instagram' => $instagram,
                ':youtube' => $youtube,
                ':facebook' => $facebook,
                ':id' => $id
            ]);
            
            return [ 'type' => 'OK' ];

        }

        function list() {

            $sql = "SELECT * FROM companies";
            $stmt = parent::$conn->query($sql);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            return [ 'type' => 'OK', 'data' => $result ];

        }

        function updateVoucher() {

            $id = $_POST['id'];
            $enable = $_POST['enable'] == 'true';

            $voucher = $enable ? substr(uniqid(), 0, 8) : null;
            $sql = "UPDATE companies SET voucher = ? WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $voucher, $id ]);

            return ['type' => 'OK'];

        }

        function updateShowUserData() {

            $id = $_POST['id'];
            $enable = $_POST['enable'] == 'true';

            $show_user_data = $enable ? 'true' : null;
            $sql = "UPDATE companies SET show_user_data = ? WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            
            $stmt->execute([ $show_user_data, $id ]);

            return ['type' => 'OK'];

        }

        function total() {

            $sql = "SELECT count(*) as records FROM companies";
            $stmt = parent::$conn->query($sql);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);

            return [ 'type' => 'OK', 'data' => $result ];

        }
        
        function removeInfo(){
            
            $id = $_POST['id'];
            $id_user = $_POST['id_user'];
            
            $sql = "DELETE FROM leads WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id_user ]);
            
            $sql = "DELETE FROM lead_lists_leads WHERE lead_id = ?";   
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id_user ]);
            
            $sql = "DELETE FROM companies WHERE id = ?";   
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);
            
            $sql = "DELETE FROM companies_leads WHERE company_id = ? and lead_id = ?";   
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id, $id_user ]);
            
            return [ 'type' => 'OK', 'post' => $_POST ];
        }

    }