<?php

    class CompanyBoleto extends Core {

        function get() {
            
            if(!isset($_GET['cnpj'])){
                return 'Informe o CNPJ';
                exit;
            }
            
            $cnpj = $_GET['cnpj'];
            
            $sql = "SELECT * FROM config WHERE id = 1";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute();
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            $data = [];

            if ($result) {
            
                // Configurações do banco de dados
                $host = $result['host'];
                $dbname = $result['dbname'];
                $user = $result['username'];
                $password = $result['password'];
            
                try {
                    // Criação da conexão PDO
                    $conn2 = new PDO("mysql:host=$host;dbname=$dbname", $user, $password);
                
                    // Configuração de opções do PDO
                    $conn2->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                
                    // Consulta SQL preparada
                    $sql = "SELECT * FROM TB_CampanhaBoleto WHERE cnpj = ?";
                    $stmt = $conn2->prepare($sql);
                    $stmt->execute([$cnpj]);
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);

                    if($result)
                        $data = $result;
                    
                } catch (PDOException $e) {
                                    
                }
                
                // Fecha a conexão
                $conn2 = null;
            }

            return $data;
        }

    }