<?php

    class ContinueRegistration extends Core {

        function get() {
            
            if(!isset($_GET['cnpj'])){
                return 'Informe o CNPJs';
                exit;
            }
            
            $data = array();
            $cnpj = $_GET['cnpj'];
            
            $sql = "SELECT businessname, companyname, companyemail, cnpj, tax_regime, companyzipcode, companystate, companycity, district, companyaddress1, companyaddress2, complement FROM companies WHERE cnpj = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$cnpj]);
            
            // Obter o número de linhas retornadas
            $numRows = $stmt->rowCount();
            
            if ($numRows > 0) {
                
                // while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                //     $data[] = $row;
                // }
                $company = $stmt->fetch(PDO::FETCH_ASSOC);
                $data['company'] = $company;
                
                $sql = "SELECT email, firstname, lastname, phone, cpf, password, plan_signature, passo_2_concluido, passo_3_concluido, passo_4_concluido FROM leads WHERE email = ?";
                $stmt2 = parent::$conn->prepare($sql);
                $stmt2->execute([$company['companyemail']]);

                $data['user'] = $stmt2->fetch(PDO::FETCH_ASSOC);
                
                
            }else{
                
                $candidatos = "SELECT * FROM leads WHERE cpf = ?";
                $stmt2 = parent::$conn->prepare($candidatos);
                $stmt2->execute([$cnpj]);               
                
                $lead = $stmt2->fetch(PDO::FETCH_ASSOC);
                $data['user'] = $lead;

                $id = $lead['id'];
                
                $profissao = "SELECT * FROM professional_experiences WHERE lead_id = ?";
                $stmt3 = parent::$conn->prepare($profissao);
                $stmt3->execute([$id]);                
                
                $data['profession'] = $stmt3->fetch(PDO::FETCH_ASSOC);                
                
                $educacao = "SELECT * FROM education_experience WHERE lead_id = ?";
                $stmt4 = parent::$conn->prepare($educacao);
                $stmt4->execute([$id]);                
                
                $data['education'] = $stmt4->fetch(PDO::FETCH_ASSOC);                
                    
            }

            return sizeof($data) ? $data : null;
            
        }

    }