<?php
include_once __dir__ . '/../vendor/autoload.php';
// include_once __dir__ . '/../core/Config.php';

use Gerencianet\Exception\GerencianetException;
use Gerencianet\Gerencianet;

const PLANS = array(
    'MONTHLY' => [
        'key' => '889F3540181899BCC4FA2F81A71046B3',
        'price' => 49.90,
        'name' => 'Plano mensal',
        'interval' => 1,
        'free' => true
    ],
    'YEARLY' => [        
        'key' => '6C6DB88BFFFF3598846E7FB841EC353A',
        'price' => 49.90,
        'name' => 'Plano semestral',
        'interval' => 6,
        'free' => false
    ],
    'FREE_BUSINESS' => [
        'key' => '889F3540181899BCC4FA2F81A71046B3',
        'price' => 257.97,
        'name' => 'Plano mensal',
        'interval' => 1,
        'free' => true
    ],
    'MONTHLY_BUSINESS' => [
        'key' => '889F3540181899BCC4FA2F81A71046B3',
        'price' => 257.97,
        'name' => 'Plano mensal para empresas',
        'interval' => 1,
        'free' => false
    ],
    'YEARLY_BUSINESS' => [
        'key' => '889F3540181899BCC4FA2F81A71046B3',
        'price' => 1580.90,
        'name' => 'Plano semestral para empresas',
        'interval' => 6,
        'free' => false
    ],
);
const STATES = array(
	'AC' => 'Acre',
	'AL' => 'Alagoas',
	'AP' => 'Amapá',
	'AM' => 'Amazonas',
	'BA' => 'Bahia',
	'CE' => 'Ceará',
	'DF' => 'Distrito Federal',
	'ES' => 'Espirito Santo',
	'GO' => 'Goiás',
	'MA' => 'Maranhão',
	'MS' => 'Mato Grosso do Sul',
	'MT' => 'Mato Grosso',
	'MG' => 'Minas Gerais',
	'PA' => 'Pará',
	'PB' => 'Paraíba',
	'PR' => 'Paraná',
	'PE' => 'Pernambuco',
	'PI' => 'Piauí',
	'RJ' => 'Rio de Janeiro',
	'RN' => 'Rio Grande do Norte',
	'RS' => 'Rio Grande do Sul',
	'RO' => 'Rondônia',
	'RR' => 'Roraima',
	'SC' => 'Santa Catarina',
	'SP' => 'São Paulo',
	'SE' => 'Sergipe',
	'TO' => 'Tocantins',
);


class GerencianetPayment extends Core {

    private $api;

    function __construct($conn) {

        parent::__construct($conn);

        $options = [
            'client_id' => GERENCIANET_CLIENT_ID,
            'client_secret' => GERENCIANET_CLIENT_SECRET,
			'pix_cert' => GERENCIANET_CERTIFICADO,
            'sandbox' => GERENCIANET_IS_SANDBOX,
			'debug' => false,
			'timeout' => 30
        ];
		
        $this->api = new Gerencianet($options);
        
    }
    
    function listPlans() {

        $params = ['limit' => 20, 'offset' => 0];
        $plans = $this->api->getPlans($params, []);
        return [ 'type' => 'OK', 'data' => $plans ];

    }

    function paymentCreditCard() {

        try {

            $user_id = $_POST['userId'];
            $card_token = $_POST['cardToken'];
            $plan = $_POST['plan'];
            if($plan['free']){
                $this->updateMakeFreeAccount($user['email']);
            }else{
            $birthdate = $_POST['birthdate'];
            $holder_name = $_POST['holderName'];
			file_put_contents('POST.txt', print_r($_POST, true));
            
            $sql = "SELECT * FROM leads WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $user_id ]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            
            $state_uf = null;
            $signature_plan_id = $user['signature_plan_id'];
            $plan = PLANS[$signature_plan_id];

            $city_parts = explode(',', $user['city']);
            $state_uf = strtoupper(trim($city_parts[1]));
            $city = strtoupper(trim($city_parts[0]));

            //verifica se existe plano
            $params = array(
                'name' => $plan['name']
            );
            $query_result = $this->api->listPlans($params, []);
            
            if(sizeof($query_result['data']) > 0)
                $plan_id = $query_result['data'][0]['plan_id'];
            else {

                $body = [
                    'name' => $plan['name'] . ' da Colloca.com.br',
                    'interval' => $plan['interval'],
                    'repeats' => null
                ];
                $result = $this->api->createPlan([], $body);
                $plan_id = $result['data']['plan_id'];

            }
            
            $params = ['id' => $plan_id];
            $items = [
                [
                    'name' => $plan['name'],
                    'amount' => 1,
                    'value' => intval(floatval($plan['price']) * 100)
                ]
            ];
            $body = [
                'metadata' => [
                    'notification_url' => GERENCIANET_NOTIFICATION_URL
                ],
                'items' => $items,
            ];            
            $subscription = $this->api->createSubscription($params, $body);            
            $subscription_id = $subscription['data']['subscription_id'];
            $params = [ 'id' => $subscription_id ];
            $customer = [
                'name' => $holder_name,
                'cpf' => $user['cpf'],
                'phone_number' => $user['phone'],
                'email' =>  $user['email'],
                'birth' => $user['birthdate']
            ];            
            $billing_address = [
                'street' => $user['address1'],
                'number' => $user['address2'],
                'neighborhood' => $user['district'],
                'zipcode' => $user['zipcode'],
                'city' => $city,
                'state' => $state_uf
            ];
            $body = [ 
                'payment' => [
                    'credit_card' => [
                        'billing_address' => $billing_address,
                        'payment_token' => $card_token,
                        'customer' => $customer,                        
                    ]
                ]
            ];
            file_put_contents('CREDIT_CARD.txt', print_r($body, true));
            $payment = $this->api->defineSubscriptionPayMethod($params, $body);
            $signature_id = $subscription_id;
            $signature_status_text = 'Liberado momentaneamente, esperando autorização da operadora do cartão';
            $sql = "UPDATE leads SET signature_id = ?, voucher = NULL, signature_status = 'ACTIVE', signature_date = NOW(), signature_status_text = ? WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $signature_id, $signature_status_text, $user_id ]);
                        
            $sql = "INSERT INTO lead_lists_leads(leadlist_id, lead_id, date_added, manually_removed, manually_added)
                VALUES(42, ?,NOW(), 0, 0)";        
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $user_id ]);

            $this->updateMakePaidAccount($user['email']);
            
            return [ 
                'type' => 'OK', 
                'data' => [
                    'id' => $signature_id
                ]
            ];
            }
        } catch(\Exception $err) {
            file_put_contents('GERENCIANET.PAYMENT.err', print_r($err, true));
            return [ 'type' => 'ERROR', 'data' => $err->getMessage() ];
        }

    }
    
    function paymentBillet() {

        try {

            $user_id = $_POST['userId'];
            
            $sql = "SELECT * FROM leads WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $user_id ]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            $signature_plan_id = $_POST['signaturePlanId'];

            if(!$signature_plan_id)
                $signature_plan_id = $user['signature_plan_id'];
            
            $state_uf = null;            
            $plan = PLANS[$signature_plan_id];
            if($plan['free']){
                $this->updateMakeFreeAccount($user['email']);    
            }else{
            $city_parts = explode(',', $user['city']);
            $state_uf = strtoupper(trim($city_parts[1]));
            $city = strtoupper(trim($city_parts[0]));

            //verifica se existe plano
            $params = array(
                'name' => $plan['name']
            );
			
            $query_result = $this->api->listPlans($params, []);
            
            if(sizeof($query_result['data']) > 0)
                $plan_id = $query_result['data'][0]['plan_id'];
            else {

                $body = [
                    'name' => $plan['name'] . ' da Colloca.com.br',
                    'interval' => $plan['interval'],
                    'repeats' => null
                ];
                $result = $this->api->createPlan([], $body);
                $plan_id = $result['data']['plan_id'];

            }
            
            $params = ['id' => $plan_id];
            $items = [
                [
                    'name' => $plan['name'],
                    'amount' => 1,
                    'value' => intval(floatval($plan['price']) * 100)
                ]
            ];
            
            $metadata = ['notification_url'=>GERENCIANET_NOTIFICATION_URL];
            
            $body  =  [
                'items' => $items,
                'metadata' => $metadata
            ];

            $subscription = $this->api->createSubscription($params, $body);            
            $subscription_id = $subscription['data']['subscription_id'];            
            $params = [ 'id' => $subscription_id ];			
            $billet_name = $user['account_type'] === 'company' ? $user['company'] : $user['firstname'] . ' ' . $user['lastname'];
            $customer = [
                'name' => $billet_name,
                'cpf' => $user['cpf'],
                'phone_number' => $user['phone'],
                'email' =>  $user['email'],
                'birth' => $user['birthdate']
            ];
            $date = new DateTime();
            //$date = $plan['free'] ? $date->add(new DateInterval('P90D')) : $date->add(new DateInterval('P7D'));
            $date = $date->add(new DateInterval('P7D'));
            $banking_billet = [
                'expire_at' => $date->format('Y-m-d'),
                'message' => "Colloca.com.br, {$plan['name']}",
                'customer' => $customer
            ];
            $payment = [
                'banking_billet' => $banking_billet, //forma de pagamento (banking_billet = boleto)                
            ];
            $body = [
                'payment' => $payment
            ];
            
			$payment = $this->api->defineSubscriptionPayMethod($params, $body);
            // file_put_contents('RETORNO.PAYLOAD.txt', print_r($payment, true));
            
            $signature_id = $subscription_id;
            $charge_link = $payment['data']['billet_link'];
            $signature_status_text = 'Liberado momentaneamente, esperando autorização da operadora do cartão';            
            $sql = "UPDATE leads SET signature_id = ?, voucher = NULL, signature_status = 'ACTIVE', signature_date = NOW(), signature_status_text = ?, payment_link = ?, signature_plan_id = ? WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $signature_id, $signature_status_text, $charge_link,  $signature_plan_id, $user_id ]);
            
            $sql = "INSERT IGNORE INTO lead_lists_leads(leadlist_id, lead_id, date_added, manually_removed, manually_added)
                VALUES(42, ?,NOW(), 0, 0)";        
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $user_id ]);

            $this->updateMakePaidAccount($user['email']);

            return [ 
                'type' => 'OK', 
                'data' => [
                    'id' => $signature_id,
                    'link' => $charge_link
                ]
            ];
            }
        } catch(\Exception $err) {
            file_put_contents('GERENCIANET.PAYMENT.err', print_r($err, true));
            return [ 'type' => 'ERROR', 'data' => $err->getMessage() ];
        }
        
    }

    function notification() {

        define('GEN_STATUS', array(
            'new' => [
                'status' => 'ACTIVE',
                'text' => 'Liberada momentaneamente, esperando autorização da operadora do cartão'
            ],
            'new_charge' => [
                'status' => 'ACTIVE',
                'text' => 'Liberada momentaneamente, esperando autorização da operadora do cartão'
            ],
            'active' => [
                'status' => 'ACTIVE',
                'text' => 'Assinatura ativa'
            ],
            'paid' => [
                'status' => 'ACTIVE',
                'text' => 'Assinatura/cobrança paga'
            ],
            'canceled' => [
                'status' => 'CANCELED',
                'text' => 'Assinatura cancelada'
            ],
            'expired' => [
                'status' => 'CANCELED',
                'text' => 'Assinatura cancelada por falta de pagamento ou expirada, você pode emitir um novo boleto e fazer o pagamento antes do vencimento'
            ],
        ));

        try {

            $token = $_POST['notification'];
            $params = [
                'token' => $token
            ];
            $notification = $this->api->getNotification($params, []);
            
            $i = count($notification["data"]); 
            $last_status = $notification["data"][$i-1];    
            $status = $last_status["status"];            
            $charge_id = $last_status["identifiers"]["subscription_id"];    
            $current_status = $status["current"];            
            $status = GEN_STATUS[$current_status] ?? [ 'status' => 'CANCELED', 'text' => 'Assinatura cancelada por falta de pagamento ou expirada' ];
            
            $sql = "UPDATE leads SET signature_status = :status, signature_status_text = :text WHERE signature_id = :id";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ 
                ':status' => $status['status'],
                ':text' => $status['text'],
                ':id' => $charge_id,
            ]);

            $sql = "SELECT id, email FROM leads WHERE signature_id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $charge_id ]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            
            //deleta se estiver nos segmentos de pendentes ou cancelados
            $sql = "DELETE FROM lead_lists_leads WHERE leadlist_id IN(42, 41, 39) AND lead_id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $user['id'] ]);

            if($status === 'ACTIVE') {

                $sql = "INSERT INTO lead_lists_leads(leadlist_id, lead_id, date_added, manually_removed, manually_added)
                    VALUES(39, ?,NOW(), 0, 0)";   
                $stmt = parent::$conn->prepare($sql);
                $stmt->execute([ $user['id'] ]);

                $this->updateMakePaidAccount($user['email']);

            } else {

                //Segmentos dos cancelados, ID  41
                $sql = "INSERT INTO lead_lists_leads(leadlist_id, lead_id, date_added, manually_removed, manually_added)
                    VALUES(41, ?,NOW(), 0, 0)";        
                $stmt = parent::$conn->prepare($sql);
                $stmt->execute([ $user['id'] ]);
                
            }


        } catch(\Exception $err) {
            http_response_code(500);
        }

        http_response_code(200);

    }

    private function updateMakePaidAccount($email) {

        $sql = "UPDATE companies SET free_account = 0 WHERE companyemail = ?";
        $stmt = parent::$conn->prepare($sql);
        $stmt->execute([ $user['email'] ]);

    }

    private function updateMakeFreeAccount($email) {

        $sql = "UPDATE companies SET free_account = 1 WHERE companyemail = ?";
        $stmt = parent::$conn->prepare($sql);
        $stmt->execute([ $user['email'] ]);

    }

    function cancelSignature() {

        try {
            
            $id = $_GET['id'];
            $sql = "SELECT signature_id FROM leads WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);
            $signature = $stmt->fetch(PDO::FETCH_ASSOC);
            $plan_id = $signature['signature_id'];
            $params = [
                'id' => $plan_id
            ];

            $this->api->cancelSubscription($params, []);

            $status = 'CANCELED';
            $status_text = 'Assinatura cancelada pelo assinante';
            $sql = "UPDATE leads SET signature_status = ?, signature_status_text = ? WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $status, $status_text, $id ]);

            if($stmt->errorCode() != '00000')
                throw new \Exception(json_encode($stmt->errorInfo()));

            return [ 'type' => 'OK' ];

        } catch(\Exception $err) {

            file_put_contents('GERENCIANET.CANCEL.err', print_r($err, true));
            return [ 'type' => 'ERROR', 'data' => $err->getMessage() ];
            
        }

    }

    function alterPaymentMethod() {

        try {

            /*$user_id = $_POST['userId'];            
            $sql = "SELECT signature_id FROM leads WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $user_id ]);
            $signature = $stmt->fetch(PDO::FETCH_ASSOC);            
            $plan_id = $signature['signature_id'];
            $params = [
                'id' => $plan_id
            ];

            $this->api->cancelSubscription($params, []);*/

            return $this->paymentCreditCard();

        } catch(\Exception $err) {

            file_put_contents('GERENCIANET.ALTER.err', print_r($err, true));
            return [ 'type' => 'ERROR', 'data' => $err->getMessage() ];

        }

    }

}