<?php
include_once __dir__ . "/../vendor/autoload.php";

const EMAIL = 'lukas.freire2011@gmail.com';
//const EMAIL = 'adm@memprega.com.br';
const TOKEN = '4b6ea431-8013-49d4-b9c2-2077d82c0d80cea031c742c5a97371a75d2b7cb23009d6c1-f764-4dab-b0f5-f944dca8329d';
//fcf8ee6c-ce81-4571-ba20-3fb5c31805b428da3abd4d43a59d8fbd99f4418877a27c8a-1bd6-482c-b7e2-7a5645d54c17
const PLAN_CODES = array(
    '6C6DB88BFFFF3598846E7FB841EC353A' => 35.90,
    '889F3540181899BCC4FA2F81A71046B3' => 9.90
);
const STATES = array(
	'AC' => 'Acre',
	'AL' => 'Alagoas',
	'AP' => 'Amapá',
	'AM' => 'Amazonas',
	'BA' => 'Bahia',
	'CE' => 'Ceará',
	'DF' => 'Distrito Federal',
	'ES' => 'Espirito Santo',
	'GO' => 'Goiás',
	'MA' => 'Maranhão',
	'MS' => 'Mato Grosso do Sul',
	'MT' => 'Mato Grosso',
	'MG' => 'Minas Gerais',
	'PA' => 'Pará',
	'PB' => 'Paraíba',
	'PR' => 'Paraná',
	'PE' => 'Pernambuco',
	'PI' => 'Piauí',
	'RJ' => 'Rio de Janeiro',
	'RN' => 'Rio Grande do Norte',
	'RS' => 'Rio Grande do Sul',
	'RO' => 'Rondônia',
	'RR' => 'Roraima',
	'SC' => 'Santa Catarina',
	'SP' => 'São Paulo',
	'SE' => 'Sergipe',
	'TO' => 'Tocantins',
);


class Pagseguro extends Core {

    function __construct($conn) {

        parent::__construct($conn);
        \PagSeguro\Library::initialize();
        \PagSeguro\Library::cmsVersion()->setName("Memprega")->setRelease("1.0.0");
        \PagSeguro\Library::moduleVersion()->setName("Memprega")->setRelease("1.0.0");
        \PagSeguro\Configuration\Configure::setEnvironment('production');//production or sandbox
        \PagSeguro\Configuration\Configure::setAccountCredentials(
            EMAIL,
            TOKEN
        );
        \PagSeguro\Configuration\Configure::setCharset('UTF-8');// UTF-8 or ISO-8859-1
        \PagSeguro\Configuration\Configure::setLog(true, __dir__ . '/../pagseguro.txt');

    }

    function getSession() {

        $sessionCode = \PagSeguro\Services\Session::create(
            \PagSeguro\Configuration\Configure::getAccountCredentials()
        );

        return [ 'type' => 'OK', 'data' => $sessionCode->getResult() ];    

    }

    function payment() {

        $user_id = $_POST['userId'];
        $card_token = $_POST['cardToken'];
        $card_holder_name = $_POST['holderName'];
        
        $sql = "SELECT * FROM leads WHERE id = ?";
        $stmt = parent::$conn->prepare($sql);
        $stmt->execute([ $user_id ]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        $plan_code = null;
        $state_uf = null;
        
        foreach(PLAN_CODES as $key=>$price) {
            $plan_price = intval($user['plan_signature']) * 100;
            $integer_price = intval($price) * 100;
            if($plan_price === $integer_price) {
                $plan_code = $key;
                break;
            }
        }

        if($user['state'] !== null && !empty($user['state'])) {
            
            foreach(STATES as $key=>$state) {
                $user_state = strtolower($user['state']);
                $state_name = strtolower($state);
                if($user_state === $state_name) {
                    $state_uf = $key;
                    break;
                }
            }

        } else {

            $uf = explode(',',$user['city'])[1];
            
            $state_uf = strtoupper(trim($uf));

        }

        //$user_phone = preg_replace('/\D/gmi', '', $user['phone']);
        $user_phone = $user['phone'];
        
        $user_phone_ddd = substr($user_phone, 0, 2);
        $user_phone_number = substr($user_phone, 2);
        $user_birthdate_fdate = (new DateTime($user['birthdate']))->format('d/m/Y');
        
        $preApproval = new \PagSeguro\Domains\Requests\DirectPreApproval\Accession();
        $preApproval->setPlan($plan_code);
        $preApproval->setReference(uniqid('sign_'));
        $preApproval->setSender()->setName($user['firstname']);//assinante
        $preApproval->setSender()->setEmail($user['email']);//assinante
        $preApproval->setSender()->setIp($_SERVER['REMOTE_ADDR']);//assinante
        $preApproval->setSender()->setAddress()
            ->withParameters($user['address1'], $user['address2'], $user['district'], $user['zipcode'], $user['city'], $state_uf, 'BRA');//assinante
        $document = new \PagSeguro\Domains\DirectPreApproval\Document();
        $document->withParameters('CPF', $user['cpf']); //assinante
        $preApproval->setSender()->setDocuments($document);
        $preApproval->setSender()->setPhone()->withParameters($user_phone_ddd, $user_phone_number); //assinante
        $preApproval->setPaymentMethod()->setCreditCard()->setToken($card_token); //token do cartão de crédito gerado via javascript
        $preApproval->setPaymentMethod()->setCreditCard()->setHolder()->setName($card_holder_name); //nome do titular do cartão de crédito
        $preApproval->setPaymentMethod()->setCreditCard()->setHolder()->setBirthDate($user_birthdate_fdate); //data de nascimento do titular do cartão de crédito
        $document = new \PagSeguro\Domains\DirectPreApproval\Document();
        $document->withParameters('CPF', $user['cpf']); //cpf do titular do cartão de crédito
        $preApproval->setPaymentMethod()->setCreditCard()->setHolder()->setDocuments($document);
        $preApproval->setPaymentMethod()->setCreditCard()->setHolder()->setPhone()
            ->withParameters($user_phone_ddd, $user_phone_number); //telefone do titular do cartão de crédito
        $preApproval->setPaymentMethod()->setCreditCard()->setHolder()->setBillingAddress()
            ->withParameters($user['address1'], $user['address2'], $user['district'], $user['zipcode'], $user['city'], $state_uf, 'BRA'); //endereço do titular do cartão de crédito
        
        $response = $preApproval->register(
            new \PagSeguro\Domains\AccountCredentials(EMAIL, TOKEN) // credencias do vendedor no pagseguro
        );

        $signature_id = $response->code;

        $sql = "UPDATE leads SET signature_id = ?, voucher = NULL WHERE id = ?";
        $stmt = parent::$conn->prepare($sql);
        $stmt->execute([ $signature_id, $user_id ]);

        return [ 'type' => 'OK', 'data' => $signature_id ];

    }

}