<?php

    class Profile extends Core {

        function updateShowInfo() {

            $id = $_POST['id'];
            $show = $_POST['showInfo'] ?? false;
            $show = $show == 'true' ? true : false;
            $sql = "UPDATE professional_experiences SET mostrar_experiencias = :show_info  WHERE lead_id = :id";

            $stmt = parent::$conn->prepare($sql);
            $stmt->bindParam(':show_info', $show);
            $stmt->bindParam(':id', $id);
            $stmt->execute();

            $sql = "UPDATE education_experience  SET mostrar_experiencias = :show_info  WHERE lead_id = :id";

            $stmt = parent::$conn->prepare($sql);
            $stmt->bindParam(':show_info', $show);
            $stmt->bindParam(':id', $id);
            $stmt->execute();

            $sql = "UPDATE leads SET mostrar_experiencias = :show_info  WHERE id = :id";

            $stmt = parent::$conn->prepare($sql);
            $stmt->bindParam(':show_info', $show);
            $stmt->bindParam(':id', $id);
            $stmt->execute();

            return [ 'type' => 'OK' ];

        }

        function store() {

            $firstname = $_POST['firstname'];
            $lastname = $_POST['lastname'];
            $email = $_POST['email'];
            $cpf = $_POST['cpf'];
            $phone = $_POST['phone'];
            $mobile = $_POST['mobile'];
            $gender = $_POST['gender'];
            $birthday = $_POST['birthday'];
            $zipcode = $_POST['zipCode'];
            $state = $_POST['state'];
            $city = $_POST['city'];
            $district = $_POST['district'];
            $street = $_POST['street'];
            $number = $_POST['number'];
            $complement = $_POST['complement'];

            $sql = "UPDATE leads SET firstname = :firstname, 
                lastname = :lastname, 
                email = :email, cpf = :cpf, 
                phone = :phone,
                mobile = :mobile,
                gender = :gender, 
                birthdate = :birthdate, 
                zipcode = :zipcode, 
                state = :state, 
                city = :city, 
                district = :district, 
                address1 = :street, 
                address2 = :number, 
                complement = :complement
                WHERE email = :email
            ";

            $stmt = parent::$conn->prepare($sql);
            $stmt->execute(
                array(
                    ':firstname' => $firstname,
                    ':lastname' => $lastname, 
                    ':email' => $email, 
                    ':cpf' => $cpf, 
                    ':phone' => $phone,
                    ':mobile' => $mobile,
                    ':gender' => $gender, 
                    ':birthdate' => $birthday, 
                    ':zipcode' => $zipcode, 
                    ':state' => $state,
                    ':city' => $city,
                    ':district' => $district, 
                    ':street' => $street, 
                    ':number' => $number,
                    ':complement' => $complement
                )            
            );

            return [ 'type' => 'OK', 'data' => $stmt->rowCount() ];

        }

        function get() {

            $id =  $_GET['id'];
            $sql = "SELECT * FROM leads WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);

            return [ 'type' => 'OK', 'data' => $result ];

        }

        function getAvatarProfile() {

            $id =  $_GET['id'];
            $sql = "SELECT avatar_profile FROM leads WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);

            return [ 'type' => 'OK', 'data' => $result ];

        }


        function upload() {

            $id =  $_GET['id'];
            $uploaddir = __dir__ . '/../uploads/avatars/';
            $filename = basename($_FILES['avatar']['name']);
            $uploadfile = $uploaddir . $filename;
            //$real_filename = uniqid('avatar_') . '.png';
            $real_filename = "avatar_{$id}.png";
            $dir_file = $uploaddir . $real_filename;

            if (!move_uploaded_file($_FILES['avatar']['tmp_name'], $uploadfile))
                return ['type' => 'FAIL', 'data' => 'Não foi possivel processar upload'];

            list($width, $height) = getimagesize($uploadfile);
            
            if($width > 1000) {
                $image_type = $_FILES['avatar']['type'];
                $image = ($image_type === 'image/jpeg')
                    ? imagecreatefromjpeg($uploadfile)
                    : imagecreatefrompng($uploadfile);

                $image = imagescale($image, 1000);
                if($image_type === 'image/jpeg')
                    imagejpeg($image, $dir_file);
                else imagepng($image, $dir_file);
                
            } else
                copy($uploadfile, $dir_file);
            
            unlink($uploadfile);

            $public_link = '/uploads/avatars/' . $real_filename;
            
            $sql = "UPDATE leads SET avatar_profile = '$public_link' WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);

            return [ 'type' => 'OK' ];

        }

        function getSignatureStatus() {

            $id =  $_GET['id'];
            $sql = "SELECT signature_status, signature_status_text FROM leads WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);

            return [ 'type' => 'OK', 'data' => $result ];

        }

        function appInstall() {

            $id = $_POST['userId'];

            $sql = "DELETE FROM lead_lists_leads WHERE leadlist_id IN (40, 43) AND lead_id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);
            
            $sql = "INSERT INTO lead_lists_leads(leadlist_id, lead_id, date_added, manually_removed, manually_added)
                    VALUES(40, ?,NOW(), 0, 0)";   
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);

            return [ 'type' => 'OK' ];

        }

        function makePaymentStatusActive() {

            $email =  $_POST['email'];
            $sql = "UPDATE leads SET signature_status = 'ACTIVE', signature_id = 0 WHERE email = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $email ]);

            return [ 'type' => 'OK' ];

        }

        function makePaid() {

            $email =  $_POST['email'];
            $free = $_POST['free'] ?? 0;            
            $sql = "UPDATE companies SET free_account = ? WHERE companyemail = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $free, $email ]);

            return [ 'type' => 'OK' ];

        }

    }