<?php

    class ContinueRegistration extends Core {

        function get() {
            
            if(!isset($_GET['cnpj'])){
                return 'Informe o CNPJs';
                exit;
            }
            
            $data = array();
            $cnpj = $_GET['cnpj'];
            
            $sql = "SELECT businessname, companyname, companyemail, cnpj, tax_regime, companyzipcode, companystate, companycity, district, companyaddress1, companyaddress2, complement FROM companies WHERE cnpj = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$cnpj]);
            
            // Obter o número de linhas retornadas
            $numRows = $stmt->rowCount();
            
            if ($numRows > 0) {
                
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    $data[] = $row;
                }
                
                $sql = "SELECT firstname, lastname, phone, cpf, password, plan_signature, passo_2_concluido, passo_3_concluido, passo_4_concluido FROM leads WHERE cpf = ?";
                $stmt2 = parent::$conn->prepare($sql);
                $stmt2->execute([$cnpj]);
                
                while ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
                    $data[] = $row2;
                }
                
            }else{
                
                $candidatos = "SELECT id, firstname, lastname, email, password, phone, cpf, address1, address2, city, district, complement, state, zipcode, birthdate, gender, desired_job_title, plan_signature, passo_2_concluido, passo_3_concluido, passo_4_concluido FROM leads WHERE cpf = ?";
                $stmt2 = parent::$conn->prepare($candidatos);
                $stmt2->execute([$cnpj]);
                
                while ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
                    $data[] = $row2;
                }
                
                $id = $row2['id'];
                
                $profissao = "SELECT * FROM professional_experiences WHERE lead_id = ?";
                $stmt3 = parent::$conn->prepare($profissao);
                $stmt3->execute([$id]);
                
                while ($row3 = $stmt3->fetch(PDO::FETCH_ASSOC)) {
                    $data[] = $row3;
                }
                
                $educacao = "SELECT * FROM education_experience WHERE lead_id = ?";
                $stmt4 = parent::$conn->prepare($educacao);
                $stmt4->execute([$id]);
                
                while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                    $data[] = $row4;
                }
                    
            }
            
            if ($data) {
                // Retornar os resultados em formato JSON
                header('Content-Type: application/json');
                return json_encode($data);
            } else {
                // Se nenhum resultado foi encontrado, você pode retornar uma mensagem ou um JSON vazio
                header('Content-Type: application/json');
                return json_encode(array('message' => 'Nenhum resultado encontrado.'));
            }
            
        }

    }