<?php

function validarEmail($email) {
    // Expressão regular para validar o formato do e-mail
    $padrao = '/^[\w\.-]+@[\w\.-]+\.\w+$/';
    return preg_match($padrao, $email);
}

function limparLabel($label) {
    // Remover espaços em branco do início e do final do label
    $label = trim($label);

    // Remover caracteres especiais do label usando expressão regular
    $label = preg_replace('/[^A-Za-z0-9 ]/', '', $label);

    return $label;
}

function obterDadosBanco($conexao) {
    $dadosValidados = array();

    $consulta = "SELECT email, firstname FROM `leads` WHERE email IS NOT NULL AND email <> '' LIMIT 300000 OFFSET 600001";
file_put_contents('SQL.txt', $consulta);
    $resultado = mysqli_query($conexao, $consulta);

    if ($resultado) {
        while ($linha = mysqli_fetch_assoc($resultado)) {
            $email = $linha['email'];
            $label = $linha['firstname'];

            // Validar o e-mail
            if (validarEmail($email)) {
                // Limpar o label
                $label = limparLabel($label);
                $dadosValidados[] = array($email, $label, '');
            }
        }

        mysqli_free_result($resultado);
    }

    return $dadosValidados;
}

function salvarArquivoCSV($dadosValidados, $nomeArquivo) {
    $handle = fopen($nomeArquivo, "w");

    if ($handle) {
        // Escrever o cabeçalho no arquivo CSV
        $cabecalho = array('Email', 'Label', 'Data de Nascimento');
        fputcsv($handle, $cabecalho, ';');

        // Escrever os dados validados com ponto e vírgula como separador
        foreach ($dadosValidados as $linha) {
            fputcsv($handle, $linha, ';');
        }

        fclose($handle);
    }
}

// Configurações do banco de dados
$servername = 'localhost';
$database = 'appcollo_mautic_app';
$username = 'appcollo_mautic_app';
$password = 'webuser@9009';

// Nome do arquivo de saída
$arquivoSaida = 'leads_Colloca.csv';

// Conectar ao banco de dados
$conexao = mysqli_connect($servername, $username, $password, $database);

if (!$conexao) {
    die("Falha na conexão com o banco de dados: " . mysqli_connect_error());
}

// Configurar o conjunto de caracteres para UTF-8
mysqli_set_charset($conexao, "utf8");

// Obter os dados do banco de dados
$dadosValidados = obterDadosBanco($conexao);

// Fechar a conexão com o banco de dados
mysqli_close($conexao);

// Salvar os dados validados em um arquivo CSV com ponto e vírgula como separador
salvarArquivoCSV($dadosValidados, $arquivoSaida);

// Definir o cabeçalho para o download do arquivo
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="' . $arquivoSaida . '"');
header('Content-Length: ' . filesize($arquivoSaida));

// Enviar o conteúdo do arquivo para o navegador
readfile($arquivoSaida);

// Remover o arquivo CSV após o download
unlink($arquivoSaida);

exit;
?>