<?php
include_once __dir__ . "/../vendor/autoload.php";
use Gerencianet\Exception\GerencianetException;
use Gerencianet\Gerencianet;

// const PLAN_CODES = array(
//     '6C6DB88BFFFF3598846E7FB841EC353A' => 35.90,
//     '889F3540181899BCC4FA2F81A71046B3' => 9.90
// );
const PLANS = array(
    'MONTHLY' => [
        'key' => '',
        'price' => 9.90,
        'name' => 'Plano mensal'
    ],
    'YEARLY' => [
        'key' => '',
        'price' => 35.90,
        'name' => 'Plano anual'
    ]
);
const STATES = array(
	'AC' => 'Acre',
	'AL' => 'Alagoas',
	'AP' => 'Amapá',
	'AM' => 'Amazonas',
	'BA' => 'Bahia',
	'CE' => 'Ceará',
	'DF' => 'Distrito Federal',
	'ES' => 'Espirito Santo',
	'GO' => 'Goiás',
	'MA' => 'Maranhão',
	'MS' => 'Mato Grosso do Sul',
	'MT' => 'Mato Grosso',
	'MG' => 'Minas Gerais',
	'PA' => 'Pará',
	'PB' => 'Paraíba',
	'PR' => 'Paraná',
	'PE' => 'Pernambuco',
	'PI' => 'Piauí',
	'RJ' => 'Rio de Janeiro',
	'RN' => 'Rio Grande do Norte',
	'RS' => 'Rio Grande do Sul',
	'RO' => 'Rondônia',
	'RR' => 'Roraima',
	'SC' => 'Santa Catarina',
	'SP' => 'São Paulo',
	'SE' => 'Sergipe',
	'TO' => 'Tocantins',
);


class GerencianetPayment extends Core {

    private $api;

    function __construct($conn) {

        parent::__construct($conn);

        $options = [
            'client_id' => GERENCIANET_CLIENT_ID,
            'client_secret' => GERENCIANET_CLIENT_SECRET,
            'sandbox' => GERENCIANET_IS_SANDBOX
        ];
           
        $this->api = new Gerencianet($options);

    }
    
    function listPlans() {

        $params = ['limit' => 20, 'offset' => 0];
        $plans = $this->api->getPlans($params, []);
        print_r($plans);
        file_put_contents('GERENCIANET.PLANS.RESPONSE.txt', print_r($plans, true));
        return [ 'type' => 'OK', 'data' => $plans ];

    }
    
    function payment() {

        $user_id = $_POST['userId'];
        $card_token = $_POST['cardToken'];        
        $plan = $_POST['plan'];
        $birthdate = $_POST['birthdate'];
        
        $sql = "SELECT * FROM leads WHERE id = ?";
        $stmt = parent::$conn->prepare($sql);
        $stmt->execute([ $user_id ]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        $state_uf = null;        
        $plan = PLANS[$plan];

        if($user['state'] !== null && !empty($user['state'])) {
            
            foreach(STATES as $key=>$state) {
                $user_state = strtolower($user['state']);
                $state_name = strtolower($state);
                if($user_state === $state_name) {
                    $state_uf = $key;
                    break;
                }
            }

        } else {

            $uf = explode(',', $user['city'])[1];
            $state_uf = strtoupper(trim($uf));

        }
        
        $params = ['id' => $plan['key']];
        $items = [
            [
                'name' => $plan['name'],
                'amount' => 1,
                'value' => $plan['price']
            ]
        ];

        $customer = [
            'name' => $user['firstname'],
            'cpf' => $user['cpf'],
            'phone_number' => $user['phone'],
            'email' =>  $user['email'],
            'birth' => $user['birthdate']
        ];
        
        $billing_address = [
            'street' => $user['address1'],
            'number' => $user['address2'],
            'neighborhood' => $user['disctrict'],
            'zipcode' => $user['zipcode'],
            'city' => $user['city'],
            'state' => $state_uf
        ];

        $body = [
            'items' => $items,
            'payment' => [
                'credit_card' => [
                    'billing_address' => $billing_address,
                    'payment_token' => $card_token,
                    'customer' => $customer
                ]
            ]
        ];

        $response = $api->oneStepSubscription($params, $body);
        file_put_contents('GERENCIANET.RESPONSE.txt', print_r($response, true));
        $signature_id = $response->code;

        return [ 'type' => 'OK', 'data' => 1 ];

    }

}