<?php

    class ProcessList extends Core {

        function store() {

            $name = $_POST['name'] ?? null;
            $company = $_POST['company'];
            $viewname = $_POST['viewname'];
            $viewend = $_POST['viewend'];
            $companyname = $_POST['companyname'] ?? null;
            $zipCode = $_POST['zipCode'];
            $state = $_POST['state'];
            $city = $_POST['city'];
            $district = $_POST['district'];
            $street = $_POST['street'];
            $number = $_POST['number'];
            $complement = $_POST['complement'] ?? null;
            $modalityjob = $_POST['modalityjob'];
            $sinonimo = $_POST['sinonimo'];
            $salary = $_POST['salary'];
            $coin = $_POST['coin'];
            $workregime = $_POST['workregime'];
            $daysWeek = $_POST['daysWeek'];
            $start_monday = $_POST['start_monday'] ?? null;
            $end_monday = $_POST['end_monday'] ?? null;
            $start_tuesday = $_POST['start_tuesday'] ?? null;
            $end_tuesday = $_POST['end_tuesday'] ?? null;
            $start_thursday = $_POST['start_thursday'] ?? null;
            $end_thursday = $_POST['end_thursday'] ?? null;
            $start_wednesday = $_POST['start_wednesday'] ?? null;
            $end_wednesday = $_POST['end_wednesday'] ?? null;
            $start_friday = $_POST['start_friday'] ?? null;
            $end_friday = $_POST['end_friday'] ?? null;
            $start_saturday = $_POST['start_saturday'] ?? null;
            $end_saturday = $_POST['end_saturday'] ?? null;
            $start_sunday = $_POST['start_sunday'] ?? null;
            $end_sunday = $_POST['end_sunday'] ?? null;
            $benefits = $_POST['benefits'];
            $requirements = $_POST['requirements'];
            $activities = $_POST['activities'];
            $created_by = $_POST['created_by'];
            
            $sql = "INSERT INTO process_list(name, company, viewname, viewend, companyname, zipCode, state, city, district, street, number, complement, modalityjob, sinonimo, salary, coin, workregime, daysWeek, start_monday, end_monday, start_tuesday, end_tuesday, start_wednesday, end_wednesday, start_thursday, end_thursday, start_friday, end_friday, start_saturday, end_saturday, start_sunday, end_sunday, benefits, requirements, activities, created_by) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $name, $company, $viewname, $viewend, $companyname, $zipCode, $state, $city, $district, $street, $number, $complement, $modalityjob, $sinonimo, $salary, $coin, $workregime, $daysWeek, $start_monday, $end_monday, $start_tuesday, $end_tuesday, $start_wednesday, $end_wednesday, $start_thursday, $end_thursday, $start_friday, $end_friday, $start_saturday, $end_saturday, $start_sunday, $end_sunday, $benefits, $requirements, $activities, $created_by ]);
            $insert_id = parent::$conn->lastInsertId();
            
            $sql2 = "INSERT INTO process_list_user(process_list_id, lead_id) VALUES (?,?)";
            $stmt2 = parent::$conn->prepare($sql2);
            $stmt2->execute([ $insert_id, $created_by ]);
            
            return ['type' => 'OK', 'data' => $insert_id ];

        }
        
        function update() {
            
            $id = $_POST['id'];
            $name = $_POST['name'] ?? null;
            $viewname = $_POST['viewname'];
            $viewend = $_POST['viewend'];
            $companyname = $_POST['companyname'] ?? null;
            $zipCode = $_POST['zipCode'];
            $state = $_POST['state'];
            $city = $_POST['city'];
            $district = $_POST['district'];
            $street = $_POST['street'];
            $number = $_POST['number'];
            $complement = $_POST['complement'] ?? null;
            $modalityjob = $_POST['modalityjob'];
            $sinonimo = $_POST['sinonimo'];
            $salary = $_POST['salary'];
            $coin = $_POST['coin'];
            $workregime = $_POST['workregime'];
            $daysWeek = $_POST['daysWeek'];
            $start_monday = $_POST['start_monday'] ?? null;
            $end_monday = $_POST['end_monday'] ?? null;
            $start_tuesday = $_POST['start_tuesday'] ?? null;
            $end_tuesday = $_POST['end_tuesday'] ?? null;
            $start_thursday = $_POST['start_thursday'] ?? null;
            $end_thursday = $_POST['end_thursday'] ?? null;
            $start_wednesday = $_POST['start_wednesday'] ?? null;
            $end_wednesday = $_POST['end_wednesday'] ?? null;
            $start_friday = $_POST['start_friday'] ?? null;
            $end_friday = $_POST['end_friday'] ?? null;
            $start_saturday = $_POST['start_saturday'] ?? null;
            $end_saturday = $_POST['end_saturday'] ?? null;
            $start_sunday = $_POST['start_sunday'] ?? null;
            $end_sunday = $_POST['end_sunday'] ?? null;
            $benefits = $_POST['benefits'];
            $requirements = $_POST['requirements'];
            $activities = $_POST['activities'];
            
            $sql = "UPDATE process_list SET name=?, viewname=?, viewend=?, companyname=?, zipCode=?, state=?, city=?, district=?, street=?, number=?, complement=?, modalityjob=?, sinonimo=?, salary=?, coin=?, workregime=?, daysWeek=?, start_monday=?, end_monday=?, start_tuesday=?, end_tuesday=?, start_wednesday=?, end_wednesday=?, start_thursday=?, end_thursday=?, start_friday=?, end_friday=?, start_saturday=?, end_saturday=?, start_sunday=?, end_sunday=?, benefits=?, requirements=?, activities=? WHERE id=?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$name, $viewname, $viewend, $companyname, $zipCode, $state, $city, $district, $street, $number, $complement, $modalityjob, $sinonimo, $salary, $coin, $workregime, $daysWeek, $start_monday, $end_monday, $start_tuesday, $end_tuesday, $start_wednesday, $end_wednesday, $start_thursday, $end_thursday, $start_friday, $end_friday, $start_saturday, $end_saturday, $start_sunday, $end_sunday, $benefits, $requirements, $activities, $id]);
            
            if ($stmt->rowCount() > 0) {
                return ['type' => 'OK'];
            } else {
                return ['type' => 'FAIL'];
            }
        
        }


        function getUsers() {
            $company = $_POST['company'];
            $user_id = $_POST['id'];
            
            $sql = "SELECT lead_id FROM `companies_leads` WHERE company_id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$company]);
            $leads = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            $leadIds = array_column($leads, 'lead_id');
        
            // Use a cláusula NOT IN para evitar os lead_ids que estão vinculados a um process_list_id
            $sql = "SELECT id, firstname, lastname FROM `leads` 
                    WHERE id NOT IN (SELECT lead_id FROM process_list_user WHERE process_list_id = ?)
                    AND id IN (".implode(',', $leadIds).")";
            
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$user_id]);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
            return [ 'type' => 'OK', 'data' => $result ];
        }
        
        function setUsers() {

            $process_id = $_POST['process_id'];
            $user_id = $_POST['selectedUser'];
            
            $sql = "INSERT INTO process_list_user(process_list_id, lead_id) VALUES (?,?)";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$process_id, $user_id]);
            
            return [ 'type' => 'OK' ];
        
        }

        function removeUsers() {

            $process_id = $_GET['process_id'];
            $user_id = $_GET['user_id'];
            
            $sql = "DELETE FROM process_list_user WHERE process_list_id = ? AND lead_id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$process_id, $user_id]);
            
            return [ 'type' => 'OK' ];
        
        }

        function getAssignUsers() {
            $user_id = $_POST['user_id'];
            $process_id = $_POST['process_id'];
            
            $sql = "SELECT lead_id FROM process_list_user WHERE process_list_id = ? AND lead_id <> ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$process_id, $user_id]);
            $leads = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            $leadIds = array_column($leads, 'lead_id');
        
            // Use a cláusula NOT IN para evitar os lead_ids que estão vinculados a um process_list_id
            $sql = "SELECT id, firstname, lastname FROM `leads` WHERE id IN (".implode(',', $leadIds).")";
            
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute();
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
            return [ 'type' => 'OK', 'data' => $result ];
        } 
        
        function list() {
            $user_id = $_GET['id'];
            $company = $_GET['company'];
        
            $sql = "SELECT P.*,
                    (SELECT count(*) FROM process_list_lead AS PLL WHERE PLL.process_list = P.id) AS candidates,
                    (SELECT count(*) FROM process_list_lead AS PLL WHERE PLL.process_list = P.id AND status = 'pending') AS candidatesPending
                FROM process_list AS P
                WHERE P.company = ? AND (
                    P.created_by = ? OR 
                    P.created_by IS NULL OR 
                    P.id IN (SELECT process_list_id FROM process_list_user WHERE lead_id = ?)
                )
                ORDER BY P.created_at DESC";
        
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$company, $user_id, $user_id]);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            return ['type' => 'OK', 'data' => $result];
        }

        function delete() {

            $id = $_GET['id'];
            $sql = "DELETE FROM process_list WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);
			
            return [ 'type' => 'OK' ];

        }

        function saveSelectionTest() {

            $tests = $_POST['tests'];
            $candidates = $_POST['candidates'];
            $process_list = $_POST['processList'];

            $tests = json_decode($tests, true);
            $candidates = json_decode($candidates, true);

            $candidates_id = join(', ', $candidates);
            
            $sql = "DELETE FROM process_list_test WHERE process_list = $process_list AND lead IN ($candidates_id) AND status = 'pending'";
            parent::$conn->query($sql);            

            $sql = "INSERT IGNORE INTO process_list_test(process_list, selection_test, lead) VALUES(?, ?, ?)";
            
            $candidates_emails = array();
            foreach($tests as $test) {

                foreach($candidates as $candidate) {

                    $stmt = parent::$conn->prepare($sql);
                    $stmt->execute([ $process_list, $test, $candidate ]);

                    if($stmt->rowCount())
                        $candidates_emails[] = array('candidate' => $candidate, 'test' => $test);

                }

            }           

            if(sizeof($candidates_emails)) {

                $sender = new SendEmail($this->getConnection());

                foreach($candidates_emails as $email)
                    $sender->sendForTest($candidate, $process_list, $test);

            }

            return ['type' => 'OK' ];

        }

        function listProcessListTest() {

            $process_list = $_GET['processList'];

            $sql = "SELECT A2.*, A1.lead FROM process_list_test AS A1 
                LEFT JOIN selection_tests as A2 ON A2.id = A1.selection_test
                WHERE process_list = $process_list";

            $stmt = parent::$conn->query($sql);
            return [ 'type' => 'OK', 'data' => $stmt->fetchAll(PDO::FETCH_ASSOC) ];

        }

        function deleteProcessListTest() {

            $process_list = $_GET['processList'];
            $test = $_GET['test'];
            $sql = "DELETE FROM process_list_test WHERE process_list = ? AND selection_test = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $process_list, $test ]);
            
            return ['type' => 'OK'];

        }

        function saveLeads() {

            $leads = $_POST['leads'];
            $process_list = $_POST['processList'];
            $leads = json_decode($leads, true);

            $sql = "INSERT IGNORE INTO process_list_lead(lead, process_list) VALUES(?, ?)";

            foreach($leads as $lead) {
                $stmt = parent::$conn->prepare($sql);
                $stmt->execute([ $lead, $process_list ]);
            }

            $sql = "UPDATE process_list SET status = 'read' WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$process_list]);

            return [ 'type' => 'OK' ];

        }

        function getTotalLeads() {

            $process_list = $_GET['processList'];
            $sql = "SELECT count(*) AS records FROM process_list_lead WHERE process_list = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $process_list ]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            
            return [ 'type' => 'OK', 'data' => $result ];

        }

        function getLeads() {

            $pageIndex = $_GET['pageIndex'] ?? 0;
            $limit = $_GET['limit'] ?? 20;
            $offset =  $pageIndex * $limit;
            $process_list = $_GET['processList'];
            $sql = "SELECT A2.*/*, A5.status*/, A1.status AS candidateStatus,
                    (SELECT sum(points) FROM process_list_interviews AS A3 LEFT JOIN process_list_lead_interviews AS A4 ON A4.interview = A3.id WHERE process_list = :process_list AND A4.lead = A1.lead) AS points,
                    (SELECT count(status) FROM process_list_interviews AS A3 LEFT JOIN process_list_lead_interviews AS A4 ON A4.interview = A3.id WHERE process_list = :process_list AND A4.lead = A1.lead AND status IN('evaluated')) AS status,
                    (SELECT count(*) FROM process_list_test_response AS A5 WHERE lead = A1.lead AND A5.process_list = :process_list) as responses_total,
                    (SELECT count(*) FROM process_list_test_response AS A6 WHERE lead = A1.lead AND A6.process_list = :process_list AND A6.approved = 1) as responses_approved_total
                FROM process_list_lead as A1 
                LEFT JOIN leads as A2 ON A1.lead = A2.id
                WHERE A1.process_list = :process_list ORDER BY firstname
                LIMIT :offset, :limit
            ";           
            
            $stmt = parent::$conn->prepare($sql);
            $stmt->bindParam(':process_list', $process_list);
            $stmt->bindParam(':offset', $offset, PDO::PARAM_INT);
            $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
            $stmt->execute();
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            return [ 'type' => 'OK', 'data' => $result ];

        }

        function deleteLead() {

			file_put_contents('TEST.txt', true);
            $process_list = $_GET['processList'];
            $lead = $_GET['lead'];
            
            $sql = "DELETE FROM process_list_lead WHERE process_list = ? AND lead = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $process_list, $lead ]);
			file_put_contents('SQL.DELETE.ERR.txt', print_r($stmt->errorInfo(), true));
            $sql = "DELETE process_list_interview_sessions FROM process_list_interview_sessions 
                LEFT JOIN process_list_interviews ON process_list_interviews.id = process_list_interview_sessions.process_list_interview
                WHERE process_list = ? AND lead = ?
            ";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $process_list, $lead ]);
            file_put_contents('SQL.DELETE.txt', "$sql $process_list, $lead");

            return ['type' => 'OK'];

        }

        function saveInterview() {

            $process_list = $_POST['processList'];
            $name = $_POST['name'];
            $contact = $_POST['contact'];
            $address = $_POST['address'];
            $time_start = $_POST['timeStart'];
            $time_end = $_POST['timeEnd'];
            $date_start = $_POST['dateStart'];
            $next_days = $_POST['nextDays'] == 'true';
            $candidates_session_duration = $_POST['candidatesSessionDuration'];

            $sql = "INSERT INTO process_list_interviews(process_list, name, contact, address, date_start, time_start, time_end, next_days, candidates_session_duration) 
                VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$process_list, $name, $contact, $address, $date_start, $time_start, $time_end, $next_days, $candidates_session_duration]);
            
            return ['type' => 'OK'];

        }

        function updateInterview() {

            $id = $_POST['id'];
            $name = $_POST['name'];
            $contact = $_POST['contact'];
            $address = $_POST['address'];
            $time_start = $_POST['timeStart'];
            $time_end = $_POST['timeEnd'];
            $date_start = $_POST['dateStart'];
            $next_days = $_POST['nextDays'] == 'true';
            $candidates_session_duration = $_POST['candidatesSessionDuration'];


            $sql = "UPDATE process_list_interviews SET name = :name, contact = :contact, address = :address, date_start = :date_start, 
                time_start = :time_start, time_end = :time_end, next_days = :next_days, candidates_session_duration = :candidates_session_duration
                WHERE id = :id";

            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([
                ':name' => $name,
                ':contact' => $contact,
                ':address' => $address,
                ':date_start' => $date_start,
                ':time_start' => $time_start,
                ':time_end' => $time_end,
                ':next_days' => $next_days,
                ':candidates_session_duration' => $candidates_session_duration,
                ':id' => $id
            ]);
            
            return ['type' => 'OK'];

        }

        function getInterview() {

            $process_list = $_GET['processList'];
            $sql = "SELECT * FROM process_list_interviews WHERE process_list = ? ORDER BY date_start DESC";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $process_list/*, $user_id*/ ]);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            return [ 'type' => 'OK', 'data' => $result ];

        }

        function deleteInterview() {

            $id = $_GET['id'];

            $sql = "SELECT * FROM process_list_interviews AS A1 
                RIGHT JOIN process_list_lead_interviews AS A2 ON A1.id = A2.interview
                WHERE A1.id = ?
            ";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);

            if($stmt->rowCount() > 0)
                return ['type' => 'FAIL'];

            $sql = "DELETE FROM process_list_interviews WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);
            return ['type' => 'OK'];

        }

        function finish() {

            $id = $_POST['id'];
            $sql = "UPDATE process_list SET status = 'read' WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$id]);
            
            return ['type' => 'OK'];

        }

        function conclude() {

            $id = $_POST['id'];
            $sql = "UPDATE process_list SET status = 'finished' WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$id]);
            
            return ['type' => 'OK'];

        }

        function hireCandidates() {

            $candidates = json_decode($_POST['candidates'], true);
            $process_list = $_POST['processList'];
            
            $sql = "UPDATE process_list_lead SET status = 'hired' WHERE lead IN (?) AND process_list = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([
                join(', ',$candidates),
                $process_list
            ]);

            return [ 'type' => 'OK' ];

        }

        function saveInterviewSessions () {

            $sessions = $_POST['sessions'];
            $interview = $_POST['interview'];

            $sql = "INSERT IGNORE INTO process_list_interview_sessions(process_list_interview, lead, date, time_start, time_end, blocked) 
                VALUES(:process_list_interview, :lead, :date, :time_start, :time_end, :blocked)
                ON DUPLICATE KEY UPDATE time_start = :time_start, time_end = :time_end, blocked = :blocked";
            $sessions = json_decode($sessions, true);
            $candidates_emails = array();

            foreach($sessions as $session) {

                $stmt = parent::$conn->prepare($sql);
                $stmt->execute([
                    ':process_list_interview' => $interview,
                    ':lead' => $session['candidate']['id'],
                    ':date' => $session['date'],
                    ':time_start' => $session['timeAt'],
                    ':time_end' => $session['timeEnd'],
                    ':blocked' => $session['blocked'] == 'true'
                ]);

                if($session['candidate']) {
                    $sqlI = "INSERT INTO process_list_lead_interviews(lead, interview) VALUES(?, ?)";
                    $stmt = parent::$conn->prepare($sqlI);
                    $stmt->execute([ $session['candidate']['id'], $interview ]);
                }
                
                if(parent::$conn->lastInsertId()) {
                    $candidates_emails[] = array(
                        'candidate' => $session['candidate']['id'], 
                        'interview' => $interview
                    );
                }

            }
            
            $sender = new SendEmail($this->getConnection());
            foreach($candidates_emails as $email)
                $sender->sendForInterview($email['candidate'], $email['interview']);

            return ['type' => 'OK'];

        }

        function getInterviewSessions() {

            $interview = $_GET['interview'];
            $sql = "SELECT A1.*, A2.id AS lead_id, firstname, lastname, avatar_profile, accept FROM process_list_interview_sessions AS A1
                LEFT JOIN leads AS A2 ON A1.lead = A2.id
                LEFT JOIN process_list_lead_interviews AS A3 ON A3.interview = A1.process_list_interview AND A3.lead = A2.id
                WHERE process_list_interview = ?
            ";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $interview ]);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

            /*var_dump(parent::$conn->errorInfo());
            var_dump($stmt->errorInfo());*/

            return $result;

        }

        function deleteInterviewSession() {

            $id = $_GET['id'];
            $sql = "DELETE FROM process_list_interview_sessions WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);

            return ['type' => 'OK'];

        }

        function updateLeadComment() {

            $lead_id = $_POST['candidateId'];
            $comment = $_POST['comment'];
            $process_list_id = $_POST['processListId'];

            $sql = "UPDATE process_list_lead SET observacao = :comment WHERE lead = :leadId AND process_list = :processList";
            $stmt = parent::$conn->prepare($sql);
            $stmt->bindParam(':comment', $comment);
            $stmt->bindParam(':leadId', $lead_id);
            $stmt->bindParam(':processList', $process_list_id);
            $stmt->execute();

            return ['type' => 'OK'];

        }

        function getLeadComment() {

            $lead_id = $_GET['candidateId'];
            $process_list_id = $_GET['processListId'];

            $sql = "SELECT observacao FROM process_list_lead WHERE lead = :leadId AND process_list = :processList";
            $stmt = parent::$conn->prepare($sql);            
            $stmt->bindParam(':leadId', $lead_id);
            $stmt->bindParam(':processList', $process_list_id);
            $stmt->execute();            
            $result = $stmt->fetch(PDO::FETCH_ASSOC);

            return [ 'type' => 'OK', 'data' => $result ];

        }

        function updateLeadPoint() {

            $lead_id = $_POST['candidateId'];            
            $process_list_id = $_POST['processListId'];
            $points = $_POST['points'];

            $sql = "UPDATE process_list_lead SET pontos = :points WHERE lead = :leadId AND process_list = :processList";
            $stmt = parent::$conn->prepare($sql);
            $stmt->bindParam(':points', $points);
            $stmt->bindParam(':leadId', $lead_id);
            $stmt->bindParam(':processList', $process_list_id);
            $stmt->execute();
            file_put_contents('UPDATE POINTS.txt', print_r($stmt->errorInfo(), true));
            return ['type' => 'OK'];

        }

        function getLeadPoint() {

            $lead_id = $_GET['candidateId'];
            $process_list_id = $_GET['processListId'];

            $sql = "SELECT pontos FROM process_list_lead WHERE lead = :leadId AND process_list = :processList";
            $stmt = parent::$conn->prepare($sql);            
            $stmt->bindParam(':leadId', $lead_id);
            $stmt->bindParam(':processList', $process_list_id);
            $stmt->execute();            
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            file_put_contents('SELECT POINTS.txt', print_r($stmt->errorInfo(), true));
            return [ 'type' => 'OK', 'data' => $result ];

        }

    }