<?php
    require __DIR__ . '/../core/Core.php';
    include_once __DIR__ .'/../connection.php';

    const FIELD_IMPORT = array(
        'education' => 'leveleducation',
        'gender' => 'gender',
        'state' => 'state'
    );
    const PROFESSIONAL_FIELD_IMPORT = array(
        'professional:professionalName' => 'professional_name',
        'professional:specializationName' => 'specialization_name',
        'professional:roleLevel' => 'role_level',
        'professional:branch' => 'branch'
    );

    class SegmentImport extends Core {

        public function import() {

            $sql = "SELECT * FROM schedule_segment_import WHERE total_record_processed < total_record LIMIT 10";
            $stmt = parent::$conn->query($sql);
            
            while($item = $stmt->fetch(PDO::FETCH_ASSOC)) {

                
                $filter_name = $item['filter_attr'];
                $filter_value = $item['filter_value'];
                $extras_filters = $item['extras_filters'] ? json_decode($item['extras_filters'], true) : [];
                $total_record_processed = intval($item['total_record_processed']);
                
                if(strpos($filter_name, ':') > -1)
                    list($p1, $p2) = explode($filter_name, ':');
                else
                    $p2 = null;

                $total_inserted = 0;
                $last_lead_id = $item['last_lead_id'] ?? 0;

                $conditions = [];

                if(isset($extras_filters['desiredJob'])) {            
                    $desired_job = $extras_filters['desiredJob'];
                    $conditions[] = "desired_job_title LIKE '%$desired_job%'";
                }
        
                if(isset($extras_filters['dateStart']) && isset($extras_filters['dateEnd'])) {        
                    $date_start = $extras_filters['dateStart'];
                    $date_end = $extras_filters['dateEnd'];
                    $conditions[] = "(date_added >= '$date_start' AND date_added <= '$date_end')";        
                }

                $condition_str = '';

                if(sizeof($conditions))
                    $condition_str =  'AND ' . implode(' AND ', $conditions);

                if($p2 === null) {

                    $field_name = FIELD_IMPORT[$filter_name];
                    $sql = "SELECT id FROM leads WHERE $field_name = '$filter_value' AND id > $last_lead_id $condition_str ORDER BY id LIMIT 50000";
                    
                    $stmt_leads = parent::$conn->query($sql);                    
                    list($total_inserted, $last_lead_id) = $this->insertLeadLists($stmt_leads, $item['leadlist_id']);
                    

                } else {
                    
                    $field_name = PROFESSIONAL_FIELD_IMPORT[$filter_name];
                    $sql = "SELECT lead_id as id FROM professional_experiences WHERE $field_name = '$filter_value' AND lead_id > $last_lead_id $condition_str ORDER BY id LIMIT 50000";
                                        
                    $stmt_professional = parent::$conn->query($sql);                    
                    list($total_inserted, $last_lead_id) = $this->insertLeadLists($stmt_professional, $item['leadlist_id']);

                }
                
                $total_record_processed += $total_inserted;

                $sql = "UPDATE schedule_segment_import SET total_record_processed = $total_record_processed, time_end = NOW(), last_lead_id = $last_lead_id
                    WHERE id = {$item['id']}";
                
                parent::$conn->query($sql);
                

            }

        }

        private function insertLeadLists($stmt_leads, $leadlist_id) {

            $total_insert = 0;
            $last_lead_id = 0;

            while($lead = $stmt_leads->fetch(PDO::FETCH_ASSOC)) {                

                $sql = "INSERT IGNORE INTO lead_lists_leads(leadlist_id, lead_id, date_added, manually_removed, manually_added)
                    VALUES(?, ?, NOW(), 0, 1)";
                $stmt = parent::$conn->prepare($sql);                
                $stmt->execute([
                    $leadlist_id,
                    $lead['id']
                ]);
                
                if($stmt->rowCount() > 0)
                    $total_insert++;

                $last_lead_id = $lead['id'];

            }

            return array($total_insert, $last_lead_id);

        }

    }


    $importer = new SegmentImport(new Connection());
    $importer->import();