<?php

    class Profile extends Core {

        function updateShowInfo() {

            $id = $_POST['id'];
            $show = $_POST['showInfo'] ?? false;
            $show = $show == 'true' ? true : false;
            $sql = "UPDATE professional_experiences SET mostrar_experiencias = :show_info  WHERE lead_id = :id";

            $stmt = parent::$conn->prepare($sql);
            $stmt->bindParam(':show_info', $show);
            $stmt->bindParam(':id', $id);
            $stmt->execute();

            $sql = "UPDATE education_experience  SET mostrar_experiencias = :show_info  WHERE lead_id = :id";

            $stmt = parent::$conn->prepare($sql);
            $stmt->bindParam(':show_info', $show);
            $stmt->bindParam(':id', $id);
            $stmt->execute();

            $sql = "UPDATE leads SET mostrar_experiencias = :show_info  WHERE id = :id";

            $stmt = parent::$conn->prepare($sql);
            $stmt->bindParam(':show_info', $show);
            $stmt->bindParam(':id', $id);
            $stmt->execute();

            return [ 'type' => 'OK' ];

        }

        function store() {

            $firstname = $_POST['firstname'];
            $lastname = $_POST['lastname'];
            $email = $_POST['email'];
            $cpf = $_POST['cpf'];
            $phone = $_POST['phone'];
            $gender = $_POST['gender'];
            $birthday = $_POST['birthday'];
            $zipcode = $_POST['zipCode'];
            $state = $_POST['state'];
            $city = $_POST['city'];
            $district = $_POST['district'];
            $street = $_POST['street'];
            $number = $_POST['number'];
            $complement = $_POST['complement'];
            $sobre = $_POST['aboutme'];

            $sql = "UPDATE leads SET firstname = :firstname, 
                lastname = :lastname, 
                email = :email, cpf = :cpf, 
                phone = :phone, 
                gender = :gender, 
                birthdate = :birthdate, 
                zipcode = :zipcode, 
                state = :state, 
                city = :city, 
                district = :district, 
                address1 = :street, 
                address2 = :number, 
                complement = :complement,
                sobre_candidato = :sobre
                WHERE email = :email
            ";

            $stmt = parent::$conn->prepare($sql);
            $stmt->execute(
                array(
                    ':firstname' => $firstname,
                    ':lastname' => $lastname, 
                    ':email' => $email, 
                    ':cpf' => $cpf, 
                    ':phone' => $phone, 
                    ':gender' => $gender, 
                    ':birthdate' => $birthday, 
                    ':zipcode' => $zipcode, 
                    ':state' => $state,
                    ':city' => $city,
                    ':district' => $district, 
                    ':street' => $street, 
                    ':number' => $number,
                    ':complement' => $complement,
                    ':sobre' => $sobre
                )            
            );

            return [ 'type' => 'OK', 'data' => $stmt->rowCount() ];

        }

        function get() {

            $id =  $_GET['id'];
            $sql = "SELECT * FROM leads WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);

            return [ 'type' => 'OK', 'data' => $result ];

        }
        
        function getinfo() {

            $id =  $_GET['id'];
            $sql = "SELECT leads.email, leads.id, leads.firstname, leads.lastname, A2.company_id, leads.phone, DATE_FORMAT(leads.birthdate, '%d/%m/%Y') AS birthdate, leads.cpf, A3.companyname, A3.cnpj, A3.companyaddress1, A3.companyaddress2, A3.companycity, A3.companystate, A3.companyzipcode, A3.district, A3.complement FROM leads 
            LEFT JOIN companies_leads as A2 ON A2.lead_id = leads.id 
            LEFT JOIN companies AS A3 ON A3.id = A2.company_id
            WHERE leads.id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            if($result){
                return [ 'type' => 'OK', 'data' => $result ];
            }else{
                return [ 'type' => 'FAIL', 'data' => $result ];
            }

        }

        function getAvatarProfile() {

            $id =  $_GET['id'];
            $sql = "SELECT avatar_profile FROM leads WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);

            return [ 'type' => 'OK', 'data' => $result ];

        }


        function upload() {

            $id =  $_GET['id'];
            $uploaddir = __dir__ . '/../uploads/avatars/';
            $filename = basename($_FILES['avatar']['name']);
            $uploadfile = $uploaddir . $filename;
            
            $real_filename = "avatar_{$id}.png";
            $dir_file = $uploaddir . $real_filename;

            if (!move_uploaded_file($_FILES['avatar']['tmp_name'], $uploadfile))
                return ['type' => 'FAIL', 'data' => 'Não foi possivel processar upload'];

            list($width, $height) = getimagesize($uploadfile);
            
            if($width > 1000) {
                $image_type = $_FILES['avatar']['type'];
                $image = ($image_type === 'image/jpeg')
                    ? imagecreatefromjpeg($uploadfile)
                    : imagecreatefrompng($uploadfile);

                $image = imagescale($image, 1000);
                if($image_type === 'image/jpeg')
                    imagejpeg($image, $dir_file);
                else imagepng($image, $dir_file);
                
            } else
                copy($uploadfile, $dir_file);
            
            unlink($uploadfile);

            $public_link = '/uploads/avatars/' . $real_filename;
            file_put_contents('UPLOAD.txt', $public_link);
            $sql = "UPDATE leads SET avatar_profile = '$public_link' WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);
            file_put_contents('UPLOAD.sql', "$sql $id");

            return [ 'type' => 'OK' ];

        }

        function getSignatureStatus() {

            $id =  $_GET['id'];
            $sql = "SELECT signature_status, signature_status_text FROM leads WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);

            return [ 'type' => 'OK', 'data' => $result ];

        }

        function appInstall() {

            $id = $_POST['userId'];

            $sql = "DELETE FROM lead_lists_leads WHERE leadlist_id IN (40, 43) AND lead_id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);
            
            $sql = "INSERT INTO lead_lists_leads(leadlist_id, lead_id, date_added, manually_removed, manually_added)
                    VALUES(40, ?,NOW(), 0, 0)";   
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);

            return [ 'type' => 'OK' ];

        }

        function makePaymentStatusActive() {

            $email =  $_POST['email'];
            $sql = "UPDATE leads SET signature_status = 'ACTIVE', signature_id = 0 WHERE email = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $email ]);

            return [ 'type' => 'OK' ];

        }

        function makePaid() {

            $email =  $_POST['email'];
            $free = $_POST['free'] ?? 0;            
            $sql = "UPDATE companies SET free_account = ? WHERE companyemail = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $free, $email ]);
			/*file_put_contents('FREE.DATA.txt', print_r($_POST, true));
			file_put_contents('FREE.SQL.txt', print_r($stmt->errorInfo(), true));*/

            return [ 'type' => 'OK' ];

        }
        
         function removeInfo(){
            
            $id = $_POST['id'];

            $sql = "DELETE FROM leads WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);
            
            $sql = "DELETE FROM lead_lists_leads WHERE lead_id = ?";   
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);

            return [ 'type' => 'OK' ];
        }

    }