<?php

if(isset($_GET)){
    file_put_contents('resultado2.txt', print_r($_GET, true), FILE_APPEND);
}

require_once('vendor/autoload.php');

use GuzzleHttp\Client;

$accessToken = '66141b8032f3a7000d6b3fbd'; // Sua chave Token
$user_id = '65d382294f51c600144521fd'; // Seu ID de usuário

$passos = [
    '1'=>'65d38294d36b6900147b8305', //passo1
    '2'=>'65d38295d36b6900147b8306', //passo2
    '3'=>'65d38295d36b6900147b8307', //passo3
    '4'=>'65d38295d36b6900147b8308', //passo4
    's'=>'65d38295d36b6900147b8309', //processo seletivo
    'l'=>'6601812c6bffe90017f3bef7'  //limbo
];

function ListarContatos($page = null, $limit = null, $order = null, $direction = null, $email = null, $filter = null, $fone = null, $cargo = null) {
    
    global $accessToken, $user_id;
    
    // Construção do array de parâmetros
    $queryParams = ['token' => $accessToken];

    // Lista de parâmetros opcionais
    $opcionais = ['page', 'limit', 'order', 'direction', 'email', 'filter', 'fone', 'cargo'];

    // Adiciona parâmetros opcionais apenas se forem passados
    foreach ($opcionais as $param) {
        if ($$param !== null) {
            $queryParams[$param] = $$param;
        }
    }

    // Construção da query string
    $queryString = http_build_query($queryParams);

    // Construção da URL completa
    $url = 'https://crm.rdstation.com/api/v1/contacts?' . $queryString;

    // Realização da requisição
    $client = new \GuzzleHttp\Client();
     try {
        $response = $client->request('GET', $url, [
            'headers' => [
                'accept' => 'application/json',
            ],
        ]);
    
        // Exibição da resposta
        return $response->getBody()->getContents();
        
     } catch (\Exception $e) {
        echo "Erro ao listar contato: " . $e->getMessage();
    }
    
}

function CriarContato($nome = null, $sobrenome = null, $celular = null, $estado = null, $cidade = null, $bairro = null, $tipo_conta = null, $aniversario = null, $escolaridade = null, $movimentacao = null, $deal_ids = null, $email = null, $linkedin = null, $id_empresa = '65d7ce9e046bf00001c11108', $cargo = null ){
    
    global $accessToken, $passos;
    
    $deal_ids = $passos[$deal_ids]? $passos[$deal_ids] : '';
    
    $client = new \GuzzleHttp\Client();

    $response = $client->request('POST', 'https://crm.rdstation.com/api/v1/contacts?token=$accessToken', [
      'body' => '
      {"contact":{
        "contact_custom_fields":[
              {"custom_field_id":"65d4e434561d9c0011508b52","value":"$sobrenome"},
              {"custom_field_id":"65d4e4844b87d5000d688b4b","value":"$celular"},
              {"custom_field_id":"65d4e4a6f8e1ff000dc884cd","value":"$cidade"},
              {"custom_field_id":"65d4e4b1f8e1ff000dc884d5","value":"$bairro"},
              {"custom_field_id":"65d4e4d8181f51001276c892","value":"$estado"},
              {"custom_field_id":"65d4e50e2d03470010e47bc1","value":"$tipo_conta"},
              {"custom_field_id":"65d4e53f73c48d0019fcdc69","value":"$aniversario"},
              {"custom_field_id":"65d4e599167bd5000dc2c50c","value":"$escolaridade"},
              {"custom_field_id":"65d4e63e4b87d50014689443","value":"$movimentacao"}
          ],
          "deal_ids":["$deal_ids"],
          "emails":[{"email":"$email"}],
          "legal_bases":[{"category":"data_processing","status":"granted","type":"consent"}],
          "linkedin":"$linkedin",
          "name":"$nome",
          "organization_id":"$id_empresa",
          "phones":[{"phone":"$celular","type":"celular"}],
          "title":"$cargo"
          }
        }',
      'headers' => [
        'accept' => 'application/json',
        'content-type' => 'application/json',
      ],
    ]);
    
    echo $response->getBody();
}

function AtualizarContato($id_contato = null, $nome = null, $sobrenome = null, $celular = null, $estado = null, $cidade = null, $bairro = null, $tipo_conta = null, $aniversario = null, $escolaridade = null, $movimentacao = null, $deal_ids = null, $email = null, $linkedin = null, $id_empresa = '65d7ce9e046bf00001c11108', $cargo = null ){
    
    global $accessToken, $passos;
    
    $deal_ids = $passos[$deal_ids]? $passos[$deal_ids] : '';
     
    $client = new \GuzzleHttp\Client();

    $response = $client->request('PUT', 'https://crm.rdstation.com/api/v1/contacts/'.$id_contato.'?token='.$accessToken, [
      'body' => '{"contact":
          {"contact_custom_fields":[
              {"custom_field_id":"65d4e434561d9c0011508b52","value":"'.$sobrenome.'"},
              {"custom_field_id":"65d4e4844b87d5000d688b4b","value":"'.$celular.'"},
              {"custom_field_id":"65d4e4a6f8e1ff000dc884cd","value":"'.$cidade.'"},
              {"custom_field_id":"65d4e4b1f8e1ff000dc884d5","value":"'.$bairro.'"},
              {"custom_field_id":"65d4e4d8181f51001276c892","value":"'.$estado.'"},
              {"custom_field_id":"65d4e50e2d03470010e47bc1","value":"'.$tipo_conta.'"},
              {"custom_field_id":"65d4e53f73c48d0019fcdc69","value":"'.$aniversario.'"},
              {"custom_field_id":"65d4e599167bd5000dc2c50c","value":"'.$escolaridade.'"},
              {"custom_field_id":"65d4e63e4b87d50014689443","value":"'.$movimentacao.'"}
            ],
            "emails":[{"email":"'.$email.'"}],
            "linkedin":"'.$linkedin.'",
            "name":"'.$nome.'",
            "organization_id":"'.$id_empresa.'",
            "title":"'.$cargo.'"
          }
        }',
        'headers' => [
            'accept' => 'application/json',
            'content-type' => 'application/json',
        ],
    ]);
    
    echo $response->getBody();

}

function ListarEmpresas($page = null, $limit = null, $order = null, $direction = null, $segmento = null, $user_id = null, $filter = null){
    
    global $accessToken, $passos;
    
    // Construção do array de parâmetros
    $queryParams = ['token' => $accessToken];

    // Lista de parâmetros opcionais
    $opcionais = ['page', 'limit', 'order', 'direction', 'segmento', 'user_id', 'filter'];

    // Adiciona parâmetros opcionais apenas se forem passados
    foreach ($opcionais as $param) {
        if ($$param !== null) {
            $queryParams[$param] = $$param;
        }
    }

    // Construção da query string
    $queryString = http_build_query($queryParams);

    // Construção da URL completa
    $url = 'https://crm.rdstation.com/api/v1/organizations?' . $queryString;

      
    $client = new \GuzzleHttp\Client();

    $response = $client->request('GET', $url, [
      'headers' => [
        'accept' => 'application/json',
      ],
    ]);
    
    echo $response->getBody();
}

function CriarEmpresa($nome = null, $site = null, $descricao = null, $segmento = null, $cnpj = null ){

    global $accessToken, $user_id;
   
    $client = new \GuzzleHttp\Client();
    
    $response = $client->request('POST', 'https://crm.rdstation.com/api/v1/organizations?token='.$accessToken, [
      'body' => '{"organization":{
          "user_id":"$user_id",
          "url":"$site",
          "resume":"$descricao",
          "organization_segments":["$segmento"],
          "organization_custom_fields":[
              {"custom_field_id":"661422bf2dcd8b0010a5b497","value":"$cnpj"}
            ],
            "name":"$nome"
      }}',
      'headers' => [
        'accept' => 'application/json',
        'content-type' => 'application/json',
      ],
    ]);
    
    echo $response->getBody();

}

function AtualizarEmpresa ($nome = null, $site = null, $descricao = null, $segmento = null, $cnpj = null, $id_empresa = null ){
    
    global $accessToken, $user_id;
    
    $client = new \GuzzleHttp\Client();

    $response = $client->request('PUT', 'https://crm.rdstation.com/api/v1/organizations/$id_empresa?token=$accessToken', [
      'body' => '{"organization":{
          "organization_custom_fields":[{"custom_field_id":"661422bf2dcd8b0010a5b497","value":"$cnpj"}],
          "organization_segments":["$segmento"],
          "resume":"$descricao",
          "url":"$site",
          "user_id":"$user_id",
          "name":"$nome"
      }}',
      'headers' => [
        'accept' => 'application/json',
        'content-type' => 'application/json',
      ],
    ]);
    
    echo $response->getBody();
}

function ListarNegociacao($page = null, $limit = null, $order = null, $direction = null, $name = null, $win = null, $close = false, $deal_stage_id = null, $id_empresa = null){
    
     global $accessToken, $user_id, $passos;
    
    // Construção do array de parâmetros
    $queryParams = ['token' => $accessToken];

    // Lista de parâmetros opcionais
    $opcionais = ['page', 'limit', 'order', 'direction', 'name', 'win', 'close', 'deal_stage_id', 'id_empresa'];

    // Adiciona parâmetros opcionais apenas se forem passados
    foreach ($opcionais as $param) {
        if ($$param !== null) {
            $queryParams[$param] = $$param;
        }
    }

    // Construção da query string
    $queryString = http_build_query($queryParams);

    // Construção da URL completa
    $url = 'https://crm.rdstation.com/api/v1/deals?' . $queryString;

    $client = new \GuzzleHttp\Client();
    try {
        $response = $client->request('GET', $url, [
          'headers' => [
            'accept' => 'application/json',
          ],
        ]);
        
        return $response->getBody()->getContents();
    
    } catch (\Exception $e) {
        echo "Erro ao listar a negociação: " . $e->getMessage();
    }
    
}

function CriarNegociacao($etapa = null, $nome_negociacao = null, $idcampanha = null, $deal_source = null, $id_empresa = null, $contacts = []) {
    
    global $accessToken, $passos, $user_id;
    
    $client = new \GuzzleHttp\Client();

    $deal_stage_id = isset($passos[$etapa]) ? $passos[$etapa] : null;
    if (!$deal_stage_id) {
        echo "Etapa inválida: $etapa";
        return;
    }

    $deal = [
        "deal_stage_id" => $deal_stage_id,
        "name" => $nome_negociacao,
        "user_id" => $user_id
    ];

    $dealArray = ["deal" => $deal];

    if ($idcampanha) {
        $dealArray["campaign"] = ["_id" => $idcampanha];
    }

    if ($deal_source) {
        $dealArray["deal_source"] = ["_id" => $deal_source];
    }

    $dealArray["organization"] = [
        "_id" => $id_empresa
    ];

    $contactsArray = [];
    foreach ($contacts as $contact) {
        $contactsArray[] = [
            "birthday" => [
                "day" => $contact['day'],
                "month" => $contact['month'],
                "year" => $contact['year']
            ],
            "emails" => [
                ["email" => $contact['email']]
            ],
            "legal_bases" => [
                [
                    "category" => "data_processing",
                    "status" => "granted",
                    "type" => "consent"
                ]
            ],
            "name" => $contact['name'],
            "phones" => [
                ["phone" => $contact['phone'], "type" => "cellphone"]
            ],
            "title" => $contact['cargo'],
            "contact_custom_fields"=> [
                [
                    "custom_field_id"=> "65d4e434561d9c0011508b52",
                    "value"=> $contact['sobrenome']
                ],
                [
                    "custom_field_id"=> "65d4e4844b87d5000d688b4b",
                    "value"=> $contact['phone']
                ],
                [
                    "custom_field_id"=> "65d4e4a6f8e1ff000dc884cd",
                    "value"=> $contact['cidade']
                ],
                [
                    "custom_field_id"=> "65d4e4b1f8e1ff000dc884d5",
                    "value"=> $contact['bairro']
                ],
                [
                    "custom_field_id"=> "65d4e4d8181f51001276c892",
                    "value"=> $contact['estado']
                ],
                [
                    "custom_field_id"=> "65d4e50e2d03470010e47bc1",
                    "value"=> $contact['tipo_conta']
                ],
                [
                    "custom_field_id"=> "65d4e53f73c48d0019fcdc69",
                    "value"=> $contact['aniversario']
                ],
                [
                    "custom_field_id"=> "65d4e599167bd5000dc2c50c",
                    "value"=> $contact['escolaridade']
                ],
                [
                    "custom_field_id"=> "65d4e63e4b87d50014689443",
                    "value"=> date("d/m/Y")
                ]
            ]
        ];
    }

    $dealArray["contacts"] = $contactsArray;

    $jsonData = json_encode($dealArray);
    
     print_r($jsonData); // Comente ou remova esta linha em produção
    
    try {
        $response = $client->request('POST', 'https://crm.rdstation.com/api/v1/deals?token=' . $accessToken, [
            'body' => $jsonData,
            'headers' => [
                'accept' => 'application/json',
                'content-type' => 'application/json',
            ],
        ]);

        echo $response->getBody();
    } catch (\Exception $e) {
        echo "Erro ao criar a negociação: " . $e->getMessage();
    }
    
}

function AtualizarNegociacao($id_deal, $id_campanha = null, $id_motivo_perda = null, $hold = null, $nome_negociacao = null, $id_empresa = null, $previsao_data_fechamento = null, $estrela = null, $win = null, $fonte = null, $etapa = null) {
    global $accessToken, $user_id, $passos;
    
    $client = new \GuzzleHttp\Client();

    $dealArray = [];

    if ($id_campanha) {
        $dealArray["campaign"] = ["_id" => $id_campanha];
    }

    $deal = [
        "name" => $nome_negociacao,
        "organization_id" => $id_empresa,
        "user_id" => $user_id,
        "prediction_date" => $previsao_data_fechamento,
        "rating" => $estrela
    ];

    if ($id_motivo_perda) {
        $deal["deal_lost_reason_id"] = $id_motivo_perda;
    }

    if (!is_null($hold)) {
        $deal["hold"] = $hold;
    }

    if (!is_null($win)) {
        $deal["win"] = $win;
    }

    $dealArray["deal"] = $deal;

    if ($fonte) {
        $dealArray["deal_source"] = ["_id" => $fonte];
    }

    if ($passos[$etapa]) {
        $dealArray["deal_stage_id"] = $passos[$etapa];
    }

    $jsonData = json_encode($dealArray);
    print_r($jsonData);
    
    try {
        $response = $client->request('PUT', 'https://crm.rdstation.com/api/v1/deals/' . $id_deal . '?token=' . $accessToken, [
            'body' => $jsonData,
            'headers' => [
                'accept' => 'application/json',
                'content-type' => 'application/json',
            ],
        ]);

        echo $response->getBody();
    } catch (\Exception $e) {
        echo "Erro ao atualizar a negociação: " . $e->getMessage();
    }
}

function getDealStageId($deal_stage_name) {
    global $passos;

    foreach ($passos as $key => $value) {
        if ($deal_stage_name == $value) {
            return $key;
        }
    }
    return null; // Retorna null se não encontrar o deal_stage_name nos passos
}


if(isset($_GET)){
    
    $nome  = $_GET['firstname'].' '.$_GET['lastname'];
    $firstname = $_GET['firstname'];
    $lastname = $_GET['lastname'];
    $stage = $_GET['etapa'];
    $email = $_GET['email'];
    $fone  = $_GET['phone'];
    $cargo = $_GET['cargo'];
    $niver = $_GET['aniversario'];
    $cidade = $_GET['cidade'];
    $bairro = $_GET['bairro'];
    $estado = $_GET['estado'];
    $tipo_conta = $_GET['tipo_conta'];
    $escolaridade = $_GET['escolaridade'];
    $fonte = '65d38294d36b6900147b82f9'; //contato pelo site
    
    
    
    $data = new DateTime($niver);
    $aniversario_formatado = $data->format("d/m/Y");
    
    $partes = explode("-", $niver);

    // Atribui cada parte a uma variável
    $ano = $partes[0];
    $mes = $partes[1];
    $dia = $partes[2];
    
    if($nome == '' || $email == ''){
        exit();
    }
    
    //Verifica se esse contato já está no RD Station
    $candidato = ListarContatos(null, 1, null, null, $email, null, $fone, null);
    $objeto = json_decode($candidato);
    $id_cliente = "";
     
    //verifica se a busca encontrou algum resultado
    if($objeto->total <= 0){
        
        echo "Criar Contato <br/>";
        
        file_put_contents('resultado2.txt', 'CRIAR CONTATO'.PHP_EOL, FILE_APPEND);
         CriarNegociacao(
            $stage, // Preencher com o valor desejado para a variável $etapa
            $nome, // Preencher com o valor desejado para a variável $nome_negociacao
            null, // $idcampanha
            $fonte, // $deal_source
            '65d7ce9e046bf00001c11108', // $id_empresa
            [
                [
                    'day' => $dia,
                    'month' => $mes,
                    'year' => $ano,
                    'email' => $email,
                    'name' => $firstname,
                    'phone' => $fone,
                    'cargo' => $cargo,
                    'sobrenome' => $lastname,
                    'cidade'=>$cidade,
                    'bairro'=> $bairro,
                    'estado' => $estado,
                    'tipo_conta'=> $tipo_conta,
                    'aniversario'=> $aniversario_formatado,
                    'escolaridade'=> $escolaridade
                    
                ]
            ]
        );
        exit();
    }else{
        
        $id_cliente = $objeto->contacts[0]->id;
        
        //contato duplicado
        if($objeto->total > 1){
            file_put_contents('contatoduplicado.txt', print_r($_GET, true), FILE_APPEND);
        }
        
    }
    
    // echo "<pre>";
    // print_r($id_cliente);
    // echo "</pre>";
    
    
    
    $json = ListarNegociacao(null, null, null, null, $nome, null, false, null, '65d7ce9e046bf00001c11108');
    $objeto = json_decode($json);
    // print_r($json);
    
    if(!empty($objeto->deals)){
        
        if(count($objeto->deals) > 1){
            file_put_contents('negociacaoduplicada.txt', print_r($_GET, true), FILE_APPEND);
        }else{
        
            $id = $objeto->deals[0]->id;
            $id_deal_stage = $objeto->deals[0]->deal_stage->id;
            $etapa = getDealStageId($id_deal_stage);
            
            // echo $id.'<br/>';
            // echo $etapa.'<br/>';
            
            if(intval($stage) > intval($etapa)){
                
                
                if($id_cliente !== ""){
                    
                    echo "Atualizar contato <br/>";
                    file_put_contents('resultado2.txt', 'ATUALIZAR CONTATO'.PHP_EOL, FILE_APPEND);
                
                    AtualizarContato(
                        $id_cliente, $firstname, $lastname, $fone, $estado, $cidade, $bairro, $tipo_conta, $niver, $escolaridade, null, $stage, $email , null, '65d7ce9e046bf00001c11108', $cargo);
                        
                }
                
                echo "Atualizar negociação <br/>";
                
                file_put_contents('resultado2.txt', 'ATUALIZAR NEGOCIAÇÃO'.PHP_EOL, FILE_APPEND);
            
                AtualizarNegociacao(
                    $id, // $id_deal
                    null, // $id_campanha
                    null, // $id_motivo_perda
                    null, // $hold paused e null
                    $nome, // $nome_negociacao
                    '65d7ce9e046bf00001c11108', // $id_empresa
                    null, // $previsao_data_fechamento
                    null, // $estrela
                    null, // $win true, false, null
                    null, // $fonte
                    $stage // $etapa
                );
            }
        
        }
    
    }else{
        
        file_put_contents('resultado2.txt', 'CRIAR NEGOCIAÇÃO'.PHP_EOL, FILE_APPEND);
        
         CriarNegociacao(
            $stage, // Preencher com o valor desejado para a variável $etapa
            $nome, // Preencher com o valor desejado para a variável $nome_negociacao
            null, // $idcampanha
            $fonte, // $deal_source
            '65d7ce9e046bf00001c11108', // $id_empresa
            [
                [
                    'day' => $dia,
                    'month' => $mes,
                    'year' => $ano,
                    'email' => $email,
                    'name' => $firstname,
                    'phone' => $fone,
                    'cargo' => $cargo,
                    'sobrenome' => $lastname,
                    'cidade'=>$cidade,
                    'bairro'=> $bairro,
                    'estado' => $estado,
                    'tipo_conta'=> $tipo_conta,
                    'aniversario'=> $aniversario_formatado,
                    'escolaridade'=> $escolaridade
                    
                ]
            ]
        );
        
    }
    
}

//  [firstname] => Thiago Donet
//     [lastname] => Presta de Almeida
//     [email] => iacobvs@hotmail.com
//     [cpf] => 32601704802
//     [phone] => 11983999398
//     [cargo] => Diretor de marketing,Analista de marketing
//     [etapa] => 1


// print_r($teste['deals'][0]['id']);

// Exemplo de uso:
// AtualizarNegociacao(
//     '661816ad2b37360013f3f201', // $id_deal
//     null, // $id_campanha
//     null, // $id_motivo_perda
//     null, // $hold paused e null
//     'TESTE2 NOVA ATUALIZACAO', // $nome_negociacao
//     '65d7ce9e046bf00001c11108', // $id_empresa
//     '2024-12-31', // $previsao_data_fechamento
//     5, // $estrela
//     null, // $win true, false, null
//     null, // $fonte
//     "3" // $etapa
// );

// Exemplo de uso:
// CriarNegociacao(
//     $stage, // Preencher com o valor desejado para a variável $etapa
//     $nome, // Preencher com o valor desejado para a variável $nome_negociacao
//     null, // $idcampanha
//     null, // $deal_source
//     '65d7ce9e046bf00001c11108', // $id_empresa
//     [
//         [
//             'day' => $dia,
//             'month' => $mes,
//             'year' => $ano,
//             'email' => $email,
//             'name' => $nome,
//             'phone' => $fone,
//             'cargo' => $cargo
//         ]
//     ]
// );



?>