<?php 
    include_once __dir__ . '/../vendor/autoload.php';
    use Smalot\PdfParser\Parser;

    class Curriculo extends Core {

        /**
         * Faz o upload faz analise por IA
         */
        function upload() {

            try {

                if(isset($_FILES['curriculo']) && $_FILES['curriculo']['error'] === UPLOAD_ERR_OK) {
                    
                    $parser = new Parser();
                    $pdf = $parser->parseFile($_FILES['curriculo']['tmp_name']);
                    
                    unlink($_FILES['curriculo']['tmp_name']);                
                    $text = '';                    
                    foreach($pdf->getPages() as $page) {
                        $text .= $page->getText();
                    }
                    
                    $user_id = $_POST['userId'];
                    $sql = "INSERT INTO leads_curriculo(lead_id, content) VALUES(?, ?) ON DUPLICATE KEY UPDATE content = ?, date_created = NOW()";
                    $stmt = parent::$conn->prepare($sql);
                    $stmt->execute([
                        $user_id, 
                        $text,
                        $text
                    ]);

                    return [ 'type' => 'OK', 'data' => $text ];

                } else {
                    return ['type' => 'ERROR', 'message' => $_FILES['curriculo']['error']];
                }

            } catch(\Exception $err) {
                return ['type' => 'ERROR', 'message' => $err->getMessage()];
            }

        }

        function updateContent() {

            try {

                $data = $_POST;
                $sql = "UPDATE leads_curriculo SET content = ? WHERE lead_id = ?";

                $content = strip_tags($data['content']);
                $stmt = parent::$conn->prepare($sql);
                $stmt->execute([
                    $content,
                    $data['userId']
                ]);

                return [ 'type' => 'OK' ];

            } catch(\Exception $err) {
                return [ 'type' => 'OK', 'error' => $err->getMessage() ];
            }

        }

        function get() {

            try {

                $id = $_GET['id'];
                $sql ="SELECT * FROM leads_curriculo WHERE lead_id = ?";
                $stmt = parent::$conn->prepare($sql);
                $stmt->execute([$id]);
                $result = $stmt->fetch(PDO::FETCH_ASSOC);

                return ['type' => 'OK', 'data' => $result ];

            } catch(\Exception $err) {
                return ['type' => 'ERROR', 'message' => $err->getMessage()];
            }

        }

    }