<?php

    include_once 'connection.php'; 
    include_once 'core/Core.php';
    include_once 'core/Config.php';
    include_once 'core/email/SendEmail.php';
    
    try {

        $action = $_GET['action'];
        $method = strtolower($_SERVER['REQUEST_METHOD']);
        
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
        header("Access-Control-Allow-Headers: X-Requested-With, Content-Type, X-Token-Auth, Authorization, x-store-code, x-xsrf-token");
		header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
        
        if($method === 'options' )
            exit;
        
        $resources = include_once './actions.php';

        if(!array_key_exists($action, $resources))
            throw new \Exception('Recurso não encontrado', 500);

        $actions = $resources[$action];

        if(!array_key_exists($method, $actions))
            throw new \Exception('Ação não encontrada', 500);

        $collection = $actions[$method];
        
        $class_name = array_keys($collection)[0];
        $function = $collection[$class_name];
        include "./controllers/{$class_name}.php";
        $controller = new $class_name(new Connection());
        $result = $controller->$function();
        $controller = null;
        
        header("content-type: application/json");
		
        echo json_encode($result);

    } catch(\Exception $err) {
        $code = $err->getCode() ?? 500;
        http_response_code($code);
        echo $err->getMessage();
    }